data:extend(
{
  {
    type = "item-with-entity-data",
    name = "deg-electric-locomotive",
    icon = "__ElectricTrains__/graphics/icons/electric-locomotive.png",
    icon_size = 32,
    subgroup = "transport",
    order = "a[train-system]-fa[electric-locomotive]",
    place_result = "deg-electric-locomotive",
    stack_size = 5
  },
  
  {
    type = "item",
    name = "deg-battery-charging-station",
    icon = "__base__/graphics/icons/accumulator.png",
    icon_size = 64, icon_mipmaps = 4,
    subgroup = "production-machine",
    order = "h[train-system]",
    place_result = "deg-battery-charging-station",
    stack_size = 10
  },
  
  {
    type = "item",
    name = "deg-battery-pack",
    icon = "__ElectricTrains__/graphics/icons/battery.png",
    icon_size = 128,
    fuel_category = "electrical",
    fuel_value = "100MJ",
    burnt_result = "deg-discharged-battery-pack",
    subgroup = "intermediate-product",
    order = "s-a[battery-pack]",
    stack_size = 10,
    fuel_acceleration_multiplier = 2.2,
    --fuel_acceleration_multiplier_quality_bonus = 0,
    fuel_top_speed_multiplier = 1.1,
    --fuel_top_speed_multiplier_quality_bonus = 0
  },
  
  {
    type = "item",
    name = "deg-discharged-battery-pack",
    icon = "__ElectricTrains__/graphics/icons/discharged-battery.png",
    icon_size = 128,
    subgroup = "intermediate-product",
    order = "s-b[discharged-battery-pack]",
    stack_size = 10
  },
  
  {
    type = "item",
    name = "deg-electric-locomotive-fuel-dummy",
    --icon = "__base__/graphics/icons/accumulator.png",
    icons = {
      {icon = "__ElectricTrains__/graphics/icons/electric-locomotive.png", icon_size = 32},
      {icon = "__ElectricTrains__/graphics/icons/lightning-bolt.png", icon_size = 32, scale = 0.5, shift = {12, 12}}
    },
    fuel_category = "electrical",
    fuel_value = "250MJ",
    subgroup = "raw-material",
    order = "h[battery]",
    stack_size = 1,
    fuel_acceleration_multiplier = 2.2,
    --fuel_acceleration_multiplier_quality_bonus = 0,
    fuel_top_speed_multiplier = 1.1,
    --fuel_top_speed_multiplier_quality_bonus = 0
  },
  
  { -- defined to stop Factorio complaining about not having an item to place for the charging point
    type = "item",
    name = "deg-locomotive-charging-dummy",
    icon = "__ElectricTrains__/graphics/icons/electric-locomotive.png",
    icon_size = 32,
    subgroup = "transport",
    order = "a[train-system]-c[train-stop]-a",
    place_result = "deg-locomotive-charging-dummy",
    stack_size = 10
  }
})
