recipe_ingredients = {}

if mods["space-age"] and settings.startup["deg-et-enable-space-age-changes"].value then
    recipe_ingredients = {
        locomotive = {
            {type = "item", name = "electric-engine-unit", amount = 20},
            {type = "item", name = "advanced-circuit", amount = 10},
            {type = "item", name = "steel-plate", amount = 30},
            {type = "item", name = "supercapacitor", amount = 20}
        },
        charger = {
            {type = "item", name = "iron-plate", amount = 15},
            {type = "item", name = "advanced-circuit", amount = 5},
            {type = "item", name = "superconductor", amount = 5}
        },
        battery = {
            {type = "item", name = "steel-plate", amount = 2},
            {type = "item", name = "supercapacitor", amount = 5}
        }
    }
else
    recipe_ingredients = {
        locomotive = {
            {type = "item", name = "electric-engine-unit", amount = 20},
            {type = "item", name = "advanced-circuit", amount = 10},
            {type = "item", name = "steel-plate", amount = 30},
            {type = "item", name = "battery", amount = 50}
        },
        charger = {
            {type = "item", name = "iron-plate", amount = 15},
            {type = "item", name = "advanced-circuit", amount = 5},
            {type = "item", name = "copper-cable", amount = 20}
        },
        battery = {
            {type = "item", name = "steel-plate", amount = 2},
            {type = "item", name = "battery", amount = 20}
        }
    }
end

data:extend(
{
  {
    type = "recipe",
    name = "deg-electric-locomotive",
    energy_required = 5,
    enabled = false,
    ingredients = recipe_ingredients.locomotive,
    results = {{type = "item", name = "deg-electric-locomotive", amount = 1}}
  },
  
  {
    type = "recipe",
    name = "deg-battery-charging-station",
    energy_required = 5,
    enabled = false,
    ingredients = recipe_ingredients.charger,
    results = {{type = "item", name = "deg-battery-charging-station", amount = 1}}
  },
  
  {
    type = "recipe",
    name = "deg-battery-pack",
    energy_required = 10,
    enabled = false,
    ingredients = recipe_ingredients.battery,
    results = {{type = "item", name = "deg-battery-pack", amount = 1}}
  },
  
  {
    type = "recipe",
    name = "deg-battery-pack-recharge",
    icons = {
      {icon = "__ElectricTrains__/graphics/icons/battery.png", icon_size = 128},
      {icon = "__ElectricTrains__/graphics/icons/lightning-bolt.png", icon_size = 32, scale = 0.5, shift = {12, 12}}
    },
    category = "deg-et-electrical",
    energy_required = 10,
    enabled = false,
    auto_recycle = false,
    ingredients =
    {
      {type = "item", name = "deg-discharged-battery-pack", amount = 1}
    },
    results = {{type = "item", name = "deg-battery-pack", amount = 1}}
  }
})
