tech_prereqs = {}
tech_ingredients = {}

if mods["space-age"] and settings.startup["deg-et-enable-space-age-changes"].value then
    tech_prereqs = {"railway", "electric-energy-distribution-2", "utility-science-pack", "electromagnetic-science-pack"}
    tech_ingredients = {
        {"automation-science-pack", 1},
        {"logistic-science-pack", 1},
        {"chemical-science-pack", 1},
        {"utility-science-pack", 1},
        {"space-science-pack", 1},
        {"electromagnetic-science-pack", 1}
    }
else
    tech_prereqs = {"railway", "electric-energy-distribution-2", "electric-engine"}
    tech_ingredients = {
        {"automation-science-pack", 1},
        {"logistic-science-pack", 1},
        {"chemical-science-pack", 1}
    }
end

data:extend(
{
  {
    type = "technology",
    name = "deg-electric-railway",
    icon_size = 256, icon_mipmaps = 4,
    icon = "__ElectricTrains__/graphics/icons/railway.png",
    effects =
    {
      {
        type = "unlock-recipe",
        recipe = "deg-electric-locomotive"
      },
      {
        type = "unlock-recipe",
        recipe = "deg-battery-charging-station"
      },
      {
        type = "unlock-recipe",
        recipe = "deg-battery-pack"
      },
      {
        type = "unlock-recipe",
        recipe = "deg-battery-pack-recharge"
      }
    },
    prerequisites = tech_prereqs,
    unit =
    {
      count = 150,
      ingredients = tech_ingredients,
      time = 30
    },
    order = "c-g-aa",
  }
})
