local Migrate = {}

function Migrate.migrations()
  storage.old_version = storage.version or "0.0.0"
  storage.version = script.active_mods["aai-signal-transmission"]

  if Util.dot_string_less_than(storage.old_version, "0.3.21", false) then
    Migrate.v0_3_21()
  end
  if Util.dot_string_less_than(storage.old_version, "0.4.8", false) then
    Migrate.v0_4_8()
  end
end


function Migrate.v0_3_21()
  local transceivers = {}

  storage.channels = storage.channels or {}
  storage.transceivers = storage.transceivers or {}
  storage.selected = storage.selected or {}
  for key, transceiver in pairs(storage.transceivers) do
    if transceiver.entity.valid then
      local entity = transceiver.entity
      local channel = transceiver.channel
      if channel and entity and entity.valid then
        transceivers[entity.unit_number] = {entity = entity, channel = channel}
      end
      deconstruct(key)
    end
  end

  storage.transmission_receivers = nil
  storage.transmission_senders = nil
  storage.transmission_receivers_by_channel = nil
  storage.transmission_senders_by_channel = nil
  storage.tick_skip = nil
  storage.signals_by_channel = nil
  storage.playerdata = nil

  for surface_name, surface in pairs(game.surfaces) do
    for _, entity in pairs(surface.find_entities_filtered{name={"aai-signal-sender", "aai-signal-receiver"}}) do
      if not transceivers[entity.unit_number] then
        transceivers[entity.unit_number] = {entity = entity, channel = DEFAULT_CHANNEL}
      end
    end
  end

  for _, transceiver in pairs(transceivers) do
    register_transceiver(transceiver.entity, transceiver.channel)
  end

end

function Migrate.v0_4_8()
  rebuild_surface()
end

return Migrate
