local M = require("data.constants")

data:extend({
	{
		type = "item-subgroup",
		name = "nco-crane",
		group = "logistics",
		order = "c",
	},
	{
    	type = "item-subgroup",
    	name = "nco-short-crane",
		group = "logistics",
    	order = "c",
  	},
})

make_crane_entity = require("data.entity")
make_crane_item = require("data.item")
make_crane_recipe = require("data.recipe")
make_crane_tech = require("data.tech")

function register_crane(entityName, newName, wide, forced_ips, forced_speed, prerequisites, next_upgrade)
	make_crane_entity(entityName, newName, wide, forced_ips, forced_speed, next_upgrade)
	make_crane_item(entityName, newName)
	make_crane_recipe(entityName, newName, wide)
	make_crane_tech(newName, prerequisites)
end

function rotation_speed_calc(speed)
	speed = ( 1 / 21600 ) * speed * M.speed_multiply
	return speed
end

local	next_upgrade_mk3 = nil
local	next_short_upgrade_mk3 = nil

if mods["space-age"] then
	next_upgrade_mk3 = "nco-crane-mk4"
	next_short_upgrade_mk3 = "nco-short-crane-mk4"
end

register_crane("inserter", "nco-crane-mk1", true, M.stack_size, rotation_speed_calc(360),
	{
		"railway"
	},
	"nco-crane-mk2"
)

register_crane("inserter", "nco-short-crane-mk1", false, M.stack_size, rotation_speed_calc(360),
	{
		"railway"
	},
	"nco-short-crane-mk2"
)

register_crane("fast-inserter", "nco-crane-mk2", true, M.stack_size, rotation_speed_calc(720),
	{
		"fast-inserter",
		"railway",
		"technology-nco-crane-mk1"
	},
	"nco-crane-mk3"
)

register_crane("fast-inserter", "nco-short-crane-mk2", false, M.stack_size, rotation_speed_calc(720),
	{
		"fast-inserter",
		"railway",
		"technology-nco-crane-mk1"
	},
	"nco-short-crane-mk3"
)

register_crane("bulk-inserter", "nco-crane-mk3", true, M.stack_size, rotation_speed_calc(1080),
	{
		"bulk-inserter",
		"railway",
		"technology-nco-crane-mk2"
	},
	next_upgrade_mk3
)

register_crane("bulk-inserter", "nco-short-crane-mk3",false, M.stack_size, rotation_speed_calc(1080),
	{
		"bulk-inserter",
		"railway",
		"technology-nco-crane-mk2"
	},
	next_short_upgrade_mk3
)

if mods["space-age"] then
	register_crane("stack-inserter", "nco-crane-mk4", true, M.stack_size, rotation_speed_calc(1440),
		{
		"stack-inserter",
		"railway",
		"technology-nco-crane-mk3"
		},
		nil
	)

	register_crane("stack-inserter", "nco-short-crane-mk4", false, M.stack_size, rotation_speed_calc(1440),
		{
		"stack-inserter",
		"railway",
		"technology-nco-crane-mk3"
		},
		nil
	)
end