local M = require("data.constants")

local function make_crane_entity(entityName, newName, wide, forced_ips, forced_speed, next_upgrade)

   if wide then
		
		local entity = table.deepcopy(data.raw["inserter"][entityName])
		entity.type = "inserter"
		entity.name = newName																								         --- <- DIFFERENT FOR OTHERS +
		entity.icon = "__inserter-cranes-fork__/graphics/icons/"..newName..".png"										--- <- DIFFERENT FOR OTHERS +
		entity.icon_size = 64
		entity.icon_draw_specification = {scale = 0.5}
		entity.flags = {"placeable-neutral", "placeable-player", "player-creation"}
		entity.subgroup = "nco-crane"
		entity.filter_count = 4
		entity.stack_size_bonus = forced_ips - 1											                                 --- <- DIFFERENT FOR OTHERS +
		entity.minable = { mining_time = 0.1 * 6, result = newName }														--- <- DIFFERENT FOR OTHERS +
		entity.max_health = 150 * 6
		entity.corpse = "inserter-remnants"
		entity.collision_box = {{-2.8, -0.15}, {2.8, 0.15}}
		entity.selection_box = {{-3, -0.5}, {3, 0.5}}
		entity.pickup_position = {0.3, -1}
		entity.insert_position = {-0.3, 1.2}
		entity.next_upgrade = next_upgrade																						   --- <- DIFFERENT FOR OTHERS +
		entity.energy_source = {type = "electric", usage_priority = "secondary-input", drain = "2.4kW"}			--- <- DIFFERENT FOR OTHERS -
		entity.energy_per_rotation = data.raw["inserter"][entityName].energy_per_rotation 							--- <- DIFFERENT FOR OTHERS -
		entity.energy_per_movement = data.raw["inserter"][entityName].energy_per_movement 							--- <- DIFFERENT FOR OTHERS -
		entity.rotation_speed = forced_speed																				      --- <- DIFFERENT FOR OTHERS +
		entity.extension_speed = 0.035 * 6 * 1.08																				   --- <- DIFFERENT FOR OTHERS -
		entity.fast_replaceable_group = "nco-crane"
		entity.vehicle_impact_sound = { filename = "__base__/sound/car-metal-impact.ogg", volume = 1.0 }
		entity.open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.5 }
		entity.close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.5 }
		entity.working_sound = {
			match_progress_to_activity = true,
			sound = {
				{ filename = "__base__/sound/inserter-basic-1.ogg", volume = 0.75 },
				{ filename = "__base__/sound/inserter-basic-2.ogg", volume = 0.75 },
				{ filename = "__base__/sound/inserter-basic-3.ogg", volume = 0.75 },
				{ filename = "__base__/sound/inserter-basic-4.ogg", volume = 0.75 },
				{ filename = "__base__/sound/inserter-basic-5.ogg", volume = 0.75 }
			}
		}
		
		entity.hand_base_picture = table.deepcopy(data.raw["inserter"][entityName].hand_base_picture)
		entity.hand_closed_picture = table.deepcopy(data.raw["inserter"][entityName].hand_closed_picture)
		entity.hand_open_picture = table.deepcopy(data.raw["inserter"][entityName].hand_open_picture)
		entity.hand_base_shadow = table.deepcopy(data.raw["inserter"][entityName].hand_base_shadow)
		entity.hand_closed_shadow = table.deepcopy(data.raw["inserter"][entityName].hand_closed_shadow)
		entity.hand_open_shadow = table.deepcopy(data.raw["inserter"][entityName].hand_open_shadow)
		
		-- Base Platform Layer
		entity.platform_picture = make_4way_animation_from_spritesheet({
			layers = {
				{
					filename = "__inserter-cranes-fork__/graphics/entity/crane-platform-6x1.png",
					priority = "extra-high",
					width = 408, 
					height = 384,
					scale = 0.5
				},
				{
					filename = "__inserter-cranes-fork__/graphics/entity/crane-platform-6x1-sh.png",
					priority = "extra-high",
					width = 408,
					height = 384,
					draw_as_shadow = true,
					scale = 0.5
				}
			}
		})
		
		-- Overlay Platform Layer
		entity.integration_patch_render_layer = "object"
		entity.integration_patch = make_4way_animation_from_spritesheet({
			layers = {
				{
					filename = "__inserter-cranes-fork__/graphics/entity/crane-platform-6x1-oh.png",
					priority = "extra-high",
					width = 408,
					height = 384,
					scale = 0.5
				}
			}
		})
			
		-- Circuit connection points
		entity.circuit_connector = circuit_connector_definitions["crane"]
		entity.circuit_wire_max_distance = inserter_circuit_wire_max_distance
		entity.default_stack_control_input_signal = inserter_default_stack_control_input_signal
		data:extend({entity})

	else

		local entity = table.deepcopy(data.raw["inserter"][entityName])
		entity.type = "inserter"
		entity.name = newName																						               --- <- DIFFERENT FOR OTHERS +
   	entity.icon = "__inserter-cranes-fork__/graphics/icons/"..newName..".png"										--- <- DIFFERENT FOR OTHERS +
    	entity.icon_size = 64
		entity.icon_draw_specification = {scale = 0.5}
	  	entity.flags = {"placeable-neutral", "placeable-player", "player-creation"}
		entity.subgroup = "nco-short-crane"
    	entity.filter_count = 4
		entity.stack_size_bonus = forced_ips - 1											                                 --- <- DIFFERENT FOR OTHERS +
		entity.minable = { mining_time = 0.1 * 6, result = newName }														--- <- DIFFERENT FOR OTHERS +
    	entity.max_health = 150 * 3
    	entity.corpse = "inserter-remnants"
    	entity.collision_box = {{-1.3, -0.15}, {1.3, 0.15}}
    	entity.selection_box = {{-1.5, -0.5}, {1.5, 0.5}}
    	entity.pickup_position = {0, -1}
    	entity.insert_position = {0, 1.2}
		entity.next_upgrade = next_upgrade																						   --- <- DIFFERENT FOR OTHERS +
		entity.energy_source = {type = "electric", usage_priority = "secondary-input", drain = "2.4kW"}			--- <- DIFFERENT FOR OTHERS -
		entity.energy_per_rotation = data.raw["inserter"][entityName].energy_per_rotation 							--- <- DIFFERENT FOR OTHERS -
		entity.energy_per_movement = data.raw["inserter"][entityName].energy_per_movement 							--- <- DIFFERENT FOR OTHERS -
		entity.rotation_speed = forced_speed / 2																				   --- <- DIFFERENT FOR OTHERS +
		entity.extension_speed = 0.035 * 6 * 1.08																				   --- <- DIFFERENT FOR OTHERS -
    	entity.fast_replaceable_group = "nco-short-crane"
    	entity.vehicle_impact_sound = { filename = "__base__/sound/car-metal-impact.ogg", volume = 1.0 }
		entity.open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.5 }
    	entity.close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.5 }
		entity.working_sound = {
			match_progress_to_activity = true,
			sound = {
				{ filename = "__base__/sound/inserter-basic-1.ogg", volume = 0.75 },
				{ filename = "__base__/sound/inserter-basic-2.ogg", volume = 0.75 },
				{ filename = "__base__/sound/inserter-basic-3.ogg", volume = 0.75 },
				{ filename = "__base__/sound/inserter-basic-4.ogg", volume = 0.75 },
				{ filename = "__base__/sound/inserter-basic-5.ogg", volume = 0.75 }
			}
		}
		
		entity.hand_base_picture = table.deepcopy(data.raw["inserter"][entityName].hand_base_picture)
		entity.hand_closed_picture = table.deepcopy(data.raw["inserter"][entityName].hand_closed_picture)
		entity.hand_open_picture = table.deepcopy(data.raw["inserter"][entityName].hand_open_picture)
		entity.hand_base_shadow = table.deepcopy(data.raw["inserter"][entityName].hand_base_shadow)
		entity.hand_closed_shadow = table.deepcopy(data.raw["inserter"][entityName].hand_closed_shadow)
		entity.hand_open_shadow = table.deepcopy(data.raw["inserter"][entityName].hand_open_shadow)

		-- Base Platform Layer
		entity.platform_picture = make_4way_animation_from_spritesheet({
      	layers = {
        		{
          		filename = "__inserter-cranes-fork__/graphics/entity/crane-platform-3x1.png",
          		priority = "extra-high",
		  			width = 384,
          		height = 192,
          		scale = 0.5
        		},
				{
          		filename = "__inserter-cranes-fork__/graphics/entity/crane-platform-3x1-sh.png",
          		priority = "extra-high",
		  			width = 384,
          		height = 192,
	      		draw_as_shadow = true,
          		scale = 0.5
        		}
      	}
    	})
	
		-- Overlay Platform Layer
		entity.integration_patch_render_layer = "object"
    	entity.integration_patch = make_4way_animation_from_spritesheet({
			layers = {
				{
					filename = "__inserter-cranes-fork__/graphics/entity/crane-platform-3x1-oh.png",
					priority = "extra-high",
					width = 384,
					height = 192,
					scale = 0.5
				}
			}
		})
		
    	-- Circuit connection points
   	entity.circuit_connector = circuit_connector_definitions["short-crane"]
   	entity.circuit_wire_max_distance = inserter_circuit_wire_max_distance
   	entity.default_stack_control_input_signal = inserter_default_stack_control_input_signal
		data:extend({entity})
		
	end
end

return make_crane_entity