local function make_crane_recipe(recipeName, newName, wide)
	local recipe = table.deepcopy(data.raw["recipe"][recipeName])
   recipe.name = newName
   recipe.icon = "__inserter-cranes-fork__/graphics/icons/"..newName..".png"	
   recipe.icon_size = 64

	if wide == true then
		scale_count = 20
	else
		scale_count = 10
	end

	local ingredients = {}
	local base_ingredients = recipe.ingredients

	for _, v in pairs(base_ingredients) do
		local name = v["name"] or v[1]
		local amount = v["amount"] or v[2]
		table.insert(ingredients, {type = "item", name = name, amount = math.ceil(amount * scale_count)})
	end
	
	recipe.ingredients = ingredients
	recipe.results = {
		{type = "item", name = newName, amount = 1}
	}

	data:extend({recipe})
end

return make_crane_recipe