local function make_crane_tech(newName, prerequisites)
	local parent_tech_name = prerequisites[1]
   local tech_name = "technology-"..newName:gsub("-short--", "-")
   local technology = data.raw["technology"][tech_name]
   if not technology then
      local technology = table.deepcopy(data.raw["technology"][parent_tech_name])
      technology.name = tech_name
      technology.icon = "__inserter-cranes-fork__/graphics/icons/"..newName..".png"	
      technology.icon_size = 64 
      technology.effects = {}
      technology.prerequisites = prerequisites
      table.insert(technology.effects,{
         type = "unlock-recipe",
         recipe = newName
      })
      data:extend({technology})
      log("Технология создалась: "..tech_name)
   else
      table.insert(technology.effects,{
         type = "unlock-recipe",
         recipe = newName
      })
   end
end

return make_crane_tech