# space-exploration-menu-simulations
Factorio Space Exploration

This is **NOT** an open source project, please check the licence file. 

If you would like to contribute please contact Earendel on Discord first: https://discord.gg/ymjUVMv


# Make a simulation from scratch

## Creating the save file

Start from one of the map templates in [the `blank-templates` folder.](menu-simulations/blank-templates).

`menu-simulation-blank-space.zip` is the same as `menu-simulation-blank.zip` but starts covered in empty space tiles, which is convenient as a starting point for space sims.

Open the save file in the editor and save a copy as a different name.

## Markers

Notice the map is 8 chunks x 6 chunks, has the logo and has a bunch of crates. These are helper markers.

* The wooden crates in the middle are where the menu will show. Anything placed here will be hidden unless the player manually drags the menu away. You can put an easter egg here.

* The rectangle of steel chests is the visible area on a 1080p screen at default zoom level. Make sure most of the action is in that rectangle.

* The far rectangle of wooden chests is the visible area on a 1440p screen at default zoom, or a 1080p screen at 75% zoom. (You can zoom/unzoom on the main menu with ctrl and + or -). Your scene can extend to these boxes to make it nice for large screens and unzoomed players, but it doesn't need to be that interesting.

* Outside of the wooden chests is extra space. Feel free to add electric interfaces and infinite chests here. They will be visible if someone unzooms all the way but even vanilla sims do this, so it's ok. You could also put more easter eggs here if you want.

If you need to redo these crate markers, there's a blueprint for them at the bottom of this Readme.

## Cloning your terrain

If you are making a space simulation, first do this in the console to be able to draw space tiles and buildings on the `nauvis` surface:  
`/c remote.call("space-exploration-menu-simulations", "remove_placement_restrictions")`

The save file already has all zones visible in the Universe Explorer. Exit the editor (`/editor`), then view the surface of a zone that has the terrain you want. Once the surface is generated, you can exit satellite mode and go back to editor (`/editor` again). Switch surface in the editor in the Surfaces tab.

If you already have a terrain in mind from another save file, you can import a single surface from another save file in the editor's "Surfaces" tab.

When you have a terrain area that you want to clone, enable the grid to see chunks (F4 -> `show-tile-grid`) then use the editor's clone tool in Area mode to select a 8x6 chunk rectangle. Keep the interesting bits near the center.

Make sure every option is checked **EXCEPT** "Clear destination entities" and "Manual collision mode" in order to preserve the Space Exploration logo and crate markers.

Go back to the `nauvis` surface and paste your cloned area.

## Looking at your simulation

Add a new entry in [`menu-simulations.lua`](data/menu-simulations.lua). You will have to copy your save file to the [`menu-simulations` folder](menu-simulations), either in `scripted` or `no-scripts`.

`length` is the number of ticks until the scene switches to the next simulation. If you're making a static scene, keep it `default_simulation_length` which is a player-configurable mod setting. Otherwise just make it switch 5-10 seconds after the action stops.

You can uncomment and modify the last line of the file to have the game only use your new simulation, so you don't have to wait for it to debug it.

## Scripts

If you need a mod's scripts to run, add the mod under the `mods` key in the simulation's definition.

In a menu simulation, SE's global table is recreated from scratch. If you are relying on anything that uses Space Exploration scripts (e.g. cannons, rockets, weapons, ships...) you will need to re-register those entities using remote interfaces.

Look at the functions in [`menu-simulations-remote-interface.lua` in the SE repo](https://github.com/EarendelDevelopers/space-exploration/blob/v0_6/menu-simulations/menu-simulations-remote-interface.lua). You may need to create your own. Look at `find_and_enable_cannon` as an example.

If you want to do things based on a timer, you can either use `script.on_nth_tick(1, ...` or the `update` script. You cannot register an event for `on_tick` directly, as that would break SE scripts. 

If you choose to use the `update` script, you won't have access to any of the variables in `init`. For this reason, it's probably best to stick to `on_nth_tick` unless your update script is very simple.

If your init script is starting to get long, you can use `init_file` instead of `init` to point to a lua file instead of typing the script in a string. Put your init_file script in the [`menu-simulations-scripts` folder](menu-simulations-scripts). Doing this means you won't be able to do fancy string substition tricks in the script though (e.g. changing parts of the script based on data-phase info, such as active mods).

## Spaceships

Spaceships can be simulated through "simulation spaceships". Look at the init script of existing spaceship sims to see how that works. Currently they cannot land or launch, they can only appear to fly.

If you are making a "spaceship in flight" simulation, before you do the final cleanup, run your remote_interface commands to make the simulation spaceship fly while inside your save. Then you can save while particles and asteroids are already on the screen. This will avoid the beginning of the menu simulation being empty of particles for the first few seconds.

## Zoomed-out sims

The default zoom level is best for file size, performance, and visibility reasons. But in some situations you might want to have more space included in the screen.

You can use 2 other zoom levels:
* x1.5 screen space: Use 0.6875 zoom level, 22-tiles logo, 15.272727 tiles shift
* x2 screen space: Use 0.5 zoom level, 30-tiles logo, 21 tiles shift

See blank_zoomed_out_1point5 and blank_zoomed_out_2 commented out sims for examples.

See the bottom of this page for the crate markers at zoomed-out levels.


## Final cleanup

When you are done with your simulation, run this to cleanup the save file:  
`/c remote.call("space-exploration-menu-simulations", "cleanup_menu_simulation")`

It will remove all non-nauvis surfaces, clean up any extra chunk or entities, clear inventories, and delete the chat history.

If your simulation needs more than the default 8x6 chunks (e.g. you are moving the camera like the `weapons-delivery` simulation or you are making a zoomed-out sim), you can instead indicate the boundaries with this:  
`/c remote.call("space-exploration-menu-simulations", "cleanup_menu_simulation", {top_left_chunk = {x=-4, y=-3}, bottom_right_chunk = {x=3, y=2}})`

Once done, save your file one last time.

Put your save in the right folder (`scripted` or `no-scripts`) then run the `remove_preview_pictures.sh` script (Or unzip the save and remove that picture yourself if you can't run the script).

Don't forget to comment out the final line of `menu-simulations.lua` to enable all simulations again.

## Simulation tips

* Use `game.surfaces.nauvis.daytime = 0.65` for any space scene, `0` for daytime and `0.5` for nighttime.

* To remove all crate markers: (Make sure your simulation doesn't actually use crates!)
```lua
/c for key, entity in pairs(game.surfaces.nauvis.find_entities_filtered{name={"wooden-chest", "iron-chest", "steel-chest"}}) do
	entity.destroy()
end
```

* You can look at `Factorio\data\base\menu-simulations\menu-simulations.lua` to see the scripts used by vanilla simulations.

* There's no undo button when drawing and cloning tiles. Make sure to save often, especially before clonings.

* We can't use Editor Extensions, but vanilla does come with an infinite electricity accumulator (`energy-interface`), infinite chests, and loaders.

* There doesn't seem to be any way to introduce randomness in a simulation, since it is always seeded the same way. Let me know if you find a way.

* If you are putting the Space Exploration logo over grey terrain (e.g. scaffolding or stone bricks), put a "logo shadow" over it so that it does not blend with the background. See existing sims with scaffolding.

* Blueprint with crate markers showing different screen sizes (Can be useful to hover over your terrain while building to see what will be visible):
```
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
```

* Crate markers at x1.5 screen space:
```
0eNqdnd2OXsdxRV+FmGt+xum/06f5DrnKhQEnRkBJA2dgckiQQ8eCwDx7hhIgDpJs7bUb8IUtmRvVxDr1Vdeu7v7l7od3X+4/fnp4fLp788vdT/eff/z08PHp4cPj3Zu7f326v3/36sf/vP/89OrT/Y9Pbx//9u7+zatyXMfHf3/884cPP/3ff/nfpffj493ru4cfPzx+vnvzb7/cfX742+Pbd9/kn37+eP+s+4+HT09fnv/J67vHt++//YPf/h+3cvf1+c89/nT/z7s35evr4E/+9OHpxZ+t0Z8dL/5k+/rX13f3j08PTw/3vwX/6//4+T8ev7z/4f7Tc1i//+n/el7+/ePt17+AZ82PHz4//PbX9svds9BtHX8ar+9+fv5v/frT+Potov8lVanUtZxUw1KXk+pYajqpgaVOJ3ViqeGkJpbqTurCUs1JLSxVnVQ5sFaxWpj3y/JeMPDTAl8w8dMSXzDy03JaMPPTfj4FQz8t9AVTPy31BWM/LfYFcz8t9xVzPy33FXM/fZ7H3J+W+4q5Py33FXN/WlYr5v6031DF3J+W+4q5Py33FXN/Wu4r5v603DfM/WlZbZj7035DDXM/LKsNcz98sYS5H5bVhrkf9htqmPthWW2Y+2G/oYa5H55VzP2w31DH3A/LfcfcD8t9x9x3X41j7rvlvmPuu+W+Y+675b5j7rvlvmPuu+W+Y+675b5j7rvlfmDuu+V+YO675X5g7pvlfmDum+V+YO6b5X5g7pvfHmPum+V+YO6b5X5g7pvlfmDum+X+xNw3y/2JuW+W+xNzXy33J+a+Wu5PzH31/RfMfbXcn5j7ark/MffVcn9i7qvl/sTcV8v9xNxXy/3E3FfL/cTcF8v9xNwXy/3E3BfL/cTcF8v9xNwX38TE3Bf7DU3MfbHcT8x9sdxfmPtiub8w98Vyf/HGvZXC2FvqL97NsVK8iWmleG1vpfiW1krxTG+leIFjLQDMu8V9cdytFKXdK1HY/fIo6/7vnKJuQViUdEvnoqDbT2ZRzm1KWBRz72ocFHNvAh0Uc+8BHRhz75kdFHT/u1UOirr/PS0Hhb0Aj5Hi7muZclDgfS1TDop8AaRS6H0dWbAp6+vbgk1ZX3cXbMpW4BVT7v0+pWBT1u+fCjZl/b6uYFPW7zcLNmX9PrhgU9bvzws2ZX3foGBT1vczCjZlfZ+lYFPW938KNmUbmJHApY3nHpuyvo9XsCnr+4sFm7K+71mwKev7sQWbsr5PXLAp28CsC+Xe99ULNmV9v79gU9b7EAWbst4fKdiU9b5Nwaas95MKNmW9z1WwKev9t4JNWe8LFmzKer+yYFO2gxkvyr33dws2Zb3vXLAp6/3wgk1Z79MXbMr6WYSCTVk/i1CwKevnLQo2ZQeY+6Pc+/mUgk1ZPzdTsCnr53kKNmX9nFHBpqyfpSrYlPWzVAWbsn72rGBT1s+eFWzK+lm9gk1ZP6tXsCnrZxsLNmX9bGPBpqyf3yzYlPVzpQWbsn7etWBTFszhYlMWzAdjUxbMLWNTFsxmY1MWzGZjUxbMn2NTFszFY1MWzOtjUxacI8CmLDjfgE1Zf+yiYFPWnwYp3JR9cThoKrFrQ+xUYitfpdLCtuwLLbXIa+c41VBidUOsK7GWr1Jq9VxLLnJsLLIpsXNDrCqxma9Sal25llzk2lhkUcdVjg2xQ4mVfJVSq+ZacpEtX+S3Ntb/L9Y3xORpoRGvUmvlmV8vciPzN5UU10bmbypbrzzzK6165JlfLbIeG5m/DSW2kflbV2J55tdaeebXi9zI/K0psY3M36oSyzO/1sozv17kRuZvRR0I3Mj87VBieebXWnnm14vcyPx1KbGNzF/lecw882utPPPrRW5k/qqSYtnI/FVl65JnfqlV88wvF1k3Mn9VSbFuZP6qsvULH/fzt5svwPkordWp1vBag2p1r3VSrea1JtWqXuuiWsVrLarlmXjh4/6x1ncfV2sVqnV5rUq1ptei3DfPfaPcN899o9w3z32j3DfPfaPcN899o9w3z32j3DfPfafcV899p9xXz32n3FfPfafcV899p9xXz32n3FfPfafcV899p9xXz32n3FfPfafcV8/9oNwXz/2g3BfP/aDcF8/9oNwXz/2g3BfP/aDcF8/9oNwXz/2g3BfP/aDcF8/9oNwXz/1JuffYnxR7T/1JqfegnhR6//2cuLb3UhR5//WcONN7KVzgeCnKO0AU426lJqQdKEHY/fImZN3/nU+IugdhQtI9nROC7j+ZCTn33/GEmPvkMiHlPnlOCLnPnRdl3EN+QcjB78wFKQc/yxfEHPwqX5BzUMRcEHRQw1yQdFDyXRB1UPFdkHVQIF8QdlAfL0g72E4sSDvYTSxIO9h8LZrUPe0L0g62qgvSDnaqC9IONvYL0g729QvSDtogC9LuuyDtgLT7plE7IO2+Z9QOWsE0LwVp9x22dkDafROxHZB239tsB6Tdt1zbAWn3neB2QNobQBTS7vvmrUDafTu/bRivWis3XpWP1baM16bEdozXqsRGborJwM5cS8Y1Yyik1BVLyRVumK4qrB3TVcW1ZboWJbZjuh5KbMN0lYH1XEvGNWIopNQZS8kV5qM2Oqx81EbHtTFqU5a663dj1KbIi4NLzIQOrOZaMq6WQqGleiwlV5iP2eiw8jEbHdfGmE2ZSmxjzKacSmzlTKjAsOn6QkvF9cJ0ffj0AVzhpZUqUwIxNaY0vFJnSt0rDabUvNLJlKpXmkypeKWLKXnOX5isf6TkhV44rH8k5NdG7dXuMwJ1VztYXj4+rLXy8WG9xI3x4aK2K2NjfLiofRS2V19kPal15VpykQt+hdWGdR5QqnmpEkupBZ41XqCUgpm9eBxOmNq/+xZaasRScoFnvEApBbP75dcHs/vySitVUqubR7o6qVTSukOtbta0FpJKLVWSq+vp6qTSSGshubozrc+k0kyV5OqudHVSaaX1mVrddaQ1o1QqqZJa3VXT1UmlltaMcnU9rWOl0kiV5OrOdHVSaYaFrFzcFZbWUiit0dXSVlqjSyHGt/9QFsPbf7urhUJyaT1cmhRibPukuxja/ndgzVBILu0KlyaFGNm2FOjHEQoNJcTInl6ohkJyaXlHUUrlHUW5vI2Oogxro6Mo49rpKDYlttNRrEpso6OotMpGR1EtspR4uyilaryJlVL5zlNK5TtPKTXSXZBUOtOdmVSa6Y5DKl3pLkgqrbS6V0r1SHccUqmklbRUqml1L5XimlwqxTW5VBphtSmFzrDalEIzLMmk0BUWiVJohQWQEmpHWJJJobRukUI1rKSkUF63qJ+7DSdURrVRt8iwNuoWGddO3VKU2E7dciixjbpFae04oWqR/G3X4hfJH3ddXqvFD0lprR6/2aS1RvyUlNY641ebtNaMH5PSWlf8bpPWWvFzUlKLP+5avFaJH5TSWjV9vElLtfRFKS3V0+ebtNRI35TSUmf6gJOWiqcctVQ85Sgz6sinHGVYZz7lKOM6N6Ycl9LaGHKUD1znM45SKh9xlCsc+e+iDOvMtWRc8ftnMqorVZIxrfTjkQ+Ux8PsKqaZz7LLoPJRdhnVxiT7VFobg+yn0srn2KVUPsYuVzjz70aGdeVaMq6VfjkqKnxdcHcxXfG8l4wpHveSMeXTXjKofNhLRrUx66X65Ft3BCutfNJLSuWDXnKFa+OdYaG1Nt4sVnHh64G7jaqmSjKmuFcjY4pbNTKmvFMjg8obNTKqnSuBldbOvZBKK+/SCKlx5E2apqQ2ejQyrJprybha+uXIqHqqJGPKTyYppfhgkoxp41ySktq4AVhJ7ZxKElo79/8eSis/kySlNo4kKamWfzcyrL7Rc1VaI/1yZFR5Y0YpxX0ZGVPellFKeVdGBbVx9FRFtXHyVEaVt2RkVHFHRirFDRm5vLwfI4PK2zEyqrQbI2NKmzEyorQXoyJqaStGRdTiTowMKW7EyJjyPoz6RW55G0b9Ire4CyOV4iaMXF7eg5FB5S0YGVXagVEx9bQBoyLqaf9FRpS2X2REcfdFhhQ3X2RMee+lK6m89TKUVNx5kUpx40UuL++7qKBG3nZRUY206yJjSpsuMqK05yIjSlsuMqK44yJDihsuMqa833IqqbzdMpVU3G1RSmfcbFHLO/Nei5TKWy1yfWmnRcaUNlpkRGmfRQqlbRa5tLjLIkOKmywyprzHIlzIMfMWy1JScYdFKsUNFrm8vL8ig8rbKzKqtLsiY0qbKzKitLciI0pbKzKiuLOiQsofT1UxbTydqmZwxsbLqWoGZ1x5Z0VKxa0VvcKN3orUOtMRUC010wlQLXWlA6BaaqXzn1KK+6HDSpV0+lNL1XT4U0u1dPZTS/V09FNLjXTyU0ud4eCnVprh3KdWusKxT620wqlPpXQeaZtFK6V9FpVAzyNttOiY4k6LDiputeio8l6LOqNxbryIqs5onEfcbdFScbtFrzDum6ug4gt5ZUz5fbw6qLh1rqPKe+fqzPK5cRmvOrN85nfxaqm4fa5XmNbrOqi0YNcxxRW7DCr3QmVUG16ouhvu3DFDp9LKa3YpldfscoVp/0UHlTZgdExxB0YHFbdgdFR5D0bd2npuXL6rbm0987t3dVhxG0ZHlfbTdVBpQ13HFHfUtVTcUtfry3vq6rbpc+Ooqbpt+sxPmsqw8oOmMqrYH9VBxQapjCmu27VUbpHK9eV1u7ol/9wwSdUt+Wfukuqw4rpdR5XW7TKokdbtMqYR1+1aKq7b9fo2Zl5UrTbyul297nGOuG7XUvnYi1xhWrfroNK6XccU1+0yqPxgqYxq41xpVbXaxrnSqkrI/FypDgvX7cNKYdq7lcK0NyuFc3u1Uji3FyuFKxkLFj1Yevv9xSUtRev239+B0lK0bv/9dSotRWlvlnb6rumtWdrxudJmacfnSpulfeIXfC3t1EW9NUs7fdz01izt9HXTW7W003Olt2pppwdLb9XSjn3UamnHPmq1tNPXTW/V0n7h96ot7fhcabW043Ol1dJOXze9VUs7fd30Vizt9HXTW7G009dNb8XSTs+V3oqlnR4svRVLO33d9FYs7fR10+9XXmopSnuxtNPXTb9feaml8OvsjvaJz5Uuq0Rhv6wSZf20ShT1aZVwzW6VKOjDKuGsbpVwCWOVKOWeTAy5U6IWqheCiNu10ZOk9q+70JeqrRDk20JJfVP7nVDX1H661DO12YRapjZVFoi2zZSVkm3RrhBt/4tSIdv2x3dSq9T+9k7qlNoyZVKj1FYpkxqltqCbFQJu67lZIeG29J304KitfCc9OWo3CZNapHaPMKlDardTkxqkdjc1qUFqN56THhy1+85JD47aLfpskHG7Q58NMm6bGZNao7aXMakzats+kxqjtuszqTFqG2SzQ8Ztf2x2yLjt/80OGbdNydkh47ZTOqklatu3kzqizZMJGbeN7pkbolIpN0SnksoNURnVhiF6Ka0NQ3QprXjcRUvF4y56hfm4SzuUVj7u0orSik1RKZWbonKFG6Zoq0orN0VbU1r5pQBSKh550SvMR15aV1r5yEsbSiseaNRS8UCjXmE+0NhUDtw4VdpUas6v3NVScZbXK8yzfFM5cOPK3aZS84yzvJaKs7xeYZ7lu8qBM8/yXaXm/JCplMpPmcoVbhwz7SoHbhwz7So15xfvaqk4y+sVblz+onLgxsW7XaXmK87yWirO8nqFeZbvKgeuPMt3lZpXnOW1VJzl9QrzLN9VDlx5lu8qNfOzpteyWpj567Ja/Gz1tFo4z1+n1cLUX8NoXfjQ6e07X1ILZ/qrWS2c6a9qtfgrScVqYe6vw2ph7ueyWpj7eVktzP08rRa/VGBaLcz9tNzzy3in5R4fQb1Nyz0+g3qblnt+CHVa7vkh1Gm5L/x1MMs9vpD3dlruC+b+tKwWzP1pv6HCb9Ow3OOzqLfTcs8Po56WVX4Y9bTfUMXcn5b7irk/Lff8et5huef38w7LPT6SehuWe3wm9TYs9/xQ6rDc80Opw3KPL+u9Dcsqvq73Nuw3xC/sHZZ7fmPvsNzjo6m3brnHZ1Nv3XLPD6d2yz0/nNot9/ji3u9HaaQWvrv3+1karcXvT7Lc81dQu+Wev4LaLff8FdRuueeHVJvlnh9SbZZ7/gpqs9wHr6Ba7vl1vs1yz+/zbZZ7/gpqs9wPfnGY5Z57s81yz73ZZrnH3uz3ozVaC3NfLffcna2We+7OVsv94K//Wu6xPfv9fI3WwtxXyz33Z6vl/uQ35lnusUH7/YyN1uJXRFrug+dQLfcnf57Acn/y9wks99yjLZZV7tEW+w1Nfr215X7y+60t98H1v5b7jft/tdZIrzPVUmd6namWmul1plrqSq8z1VIrvc5USl1Hep2plirpdaZaqqbXmWqpll5nqqV6ep2plhrhdaZa6QyvM9VKM7zOVCtd4XWmWil9fkYqYWfWfjLYl7UpAduyNiNgV9ZmPOzJ2jSMHVn/44ANWf+bxa//tZhjO9b/wmM31hYxC5uxtoZZ2Iu1ZdrCVqytHhd2Ym1Ru7ARa2vthX1YuwVY2Ia1O5OFXVi7YVrYhLX7uIU9WLu9XNiCtbvehR1Yuxlf2IC1PYKF/VfbuljYfrUdlYXdV9voWdh8tf2nhb1X2xZb2Hq13bqFnVfbRFzYeLW9zYV9V9tyXdh2tZ3ghV1X26Be2HS1ffOFPVfbzl/YcrUuw+JPolra+aOolnbst1qraGG71TpYC7ut1lhb2Gy1ft/CXqu1IRe2Wq07urDTak3bhY1W6yUv7LNai3thm9U67wu7rHa4YGGT1c4WLOyx2vGJhS1WO9WxsMNqh00WNljtDMzC/qodzVnYXrUTQwu7q3YoamFz1c5ELeyt2rGvha1VO422sLNqh+QWNlbt7N7CvqodKVzYVrWTjgu7qnYAc2FT1c6FLuyp2nHVhS1VO0W7sKNqh3sXNlTtzPHCfqodq17YTrVT1Qu7qXZwfGEz1c6zL+yl2jH7ha1UO/2/+FlXSzs/62ppP/Nzf+JYz5r5ub9fo/rr67uHp/v3z3/sh3df7j9+enj89mfevf3h/t3zP/uX+8cvrz4/vH/1/u2nv99/+vzq9uovHz68v//p1YcvT6/++fzX/vx//sfzv/hVv16lz+ct0jif/9Ovr1//B0QOy5E=
```

* Crate markers at x2 screen space:
```
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
```