-- SE+K2 sim: space_bio_sludge_loop
local surface = game.surfaces.nauvis
local force = game.forces.player
local logo = surface.find_entities_filtered{name = "se-space-exploration-logo-shattered-15tiles", limit = 1}[1]
game.simulation.camera_position = {logo.position.x, logo.position.y+10.50}
game.simulation.camera_zoom = 1
game.tick_paused = false
surface.daytime = 0.65

game.forces.player.bulk_inserter_capacity_bonus = 11
game.forces.player.inserter_stack_size_bonus = 1

local mod_gui = require("__core__/lualib/mod-gui")
if script.level.is_simulation then
  local frame = mod_gui.get_button_flow(game.players[1])
  frame.parent.visible = false
end

local surface = game.surfaces.nauvis
local force = game.forces.player
local stack_ins1 = surface.create_entity{name="bulk-inserter", position={-42.5,0.5}, direction=defines.direction.north, force=force, create_build_effect_smoke=false}
stack_ins1.set_filter(1,"kr-fertilizer")
stack_ins1.clone{position={-40.5,0.5}, surface=surface, force=force, create_build_effect_smoke=false}

local rocket_pad = surface.find_entity("cargo-landing-pad",{-44.5,-3.5})
local rocket_inv = rocket_pad.get_inventory(defines.inventory.chest)
rocket_inv.remove({name="kr-glass",count=1000})
rocket_inv.remove({name="iron-plate",count=1000})
rocket_inv.insert({name="kr-fertilizer",count=30000})

local function create_entities(entity_name, entity_direction, positions_table)
  for _, position in pairs(positions_table) do
    surface.create_entity{name=entity_name, position=position, direction=entity_direction, force=force, create_build_effect_smoke=false}
  end
end

-- Belt and inserters for fertilizer

local e_belt_positions = {{-42.5,1.5},{-41.5,2.5},{-40.5,2.5},{-39.5,2.5},{-38.5,0.5},{-37.5,0.5},{-36.5,0.5},{-35.5,0.5},{-34.5,0.5},{-33.5,0.5}}
create_entities("se-space-transport-belt", defines.direction.east, e_belt_positions)

local n_belt_positions = {{-38.5,2.5},{-38.5,1.5},{-32.5,0.5},{-32.5,-0.5}}
create_entities("se-space-transport-belt", defines.direction.north, n_belt_positions)

create_entities("se-space-transport-belt", defines.direction.west, {{-40.5,1.5}})
create_entities("se-space-transport-belt", defines.direction.south, {{-41.5,1.5}})

local w_bulk_inserters_positions = {{-31.5,0.5},{-31.5,-0.5}}
create_entities("bulk-inserter", defines.direction.west, w_bulk_inserters_positions)
