-- SE sim: spidertron_deployment
local surface = game.surfaces.nauvis
local logo = surface.find_entities_filtered{name = "se-space-exploration-logo-shattered-15tiles", limit = 1}[1]
game.simulation.camera_position = {logo.position.x, logo.position.y+10.50}
game.simulation.camera_zoom = 1
game.tick_paused = false
surface.daytime = 0
surface.solar_power_multiplier = 2

-- game.camera_alt_info = true

game.forces.player.bulk_inserter_capacity_bonus = 3
game.forces.player.worker_robots_speed_modifier = 1.55
game.forces.player.worker_robots_storage_bonus = 4
game.forces.player.technologies["se-recycling-facility"].researched = true

local mod_gui = require("__core__/lualib/mod-gui")
if script.level.is_simulation then
  local frame = mod_gui.get_button_flow(game.players[1])
  frame.parent.visible = false
end

local initial_spider = surface.find_entities_filtered{name = "spidertron", limit = 1}[1]
local journey_task_data = {
  position = {x=-21, y=0},
  launch_timer = nil,
  spidertron = initial_spider,
  contents = {
    {name = "logistic-robot", count = 400},
    {name = "construction-robot", count = 400},
    {name = "roboport", count = 20},
    {name = "se-space-solar-panel", count = 140},
    {name = "se-space-accumulator", count = 100},
    {name = "substation", count = 100},
    {name = "transport-belt", count = 200},
    {name = "inserter", count = 10},
    {name = "bulk-inserter", count = 70},
    {name = "storage-chest", count = 50},
    {name = "requester-chest", count = 50},
    {name = "buffer-chest", count = 50},
    {name = "constant-combinator", count = 20},
    {name = "arithmetic-combinator", count = 20},
    {name = "decider-combinator", count = 20},
    {name = "rocket", count = 800},
    {name = "cliff-explosives", count = 40},
    {name = "small-lamp", count = 20},
    {name = "se-recycling-facility", count = 2},
    {name = "speed-module-4", count = 8},
    {name = "storage-tank", count = 1},
    {name = "pipe", count = 30},
    {name = "pipe-to-ground", count = 10},
    {name = "area-mining-drill", count = 10},
    {name = "uranium-fuel-cell", count = 20}, -- Fuel for K2
    {name = "se-scrap", count = 700},
  },
  fixed_pod_offset = {
    {x=5, y=11},
    {x=-5, y=-10},
    {x=-10, y=10},
    {x=9, y=-12},
    {x=3, y=15},
    {x=10, y=12},
    {x=-11, y=1},
    {x=-15, y=-14},
    {x=0, y=6},
    {x=3, y=-3}, --spider
  }
}
remote.call("space-exploration-menu-simulations", "make_launchpad_journey_task", journey_task_data)

local solar_blueprint = "0eNqd01+LhCAQAPDvMs8G2T/Lr3Isi7XDIdQkacdF+N3X2oc7OC9YX0TF+TEz6g79uKJZNDmQO+hhJgvyYwerP0mNx57bDIIE7XACBqSmY2Uxs0YNYZxHtWRGEY7gGWh64DdI7m8MkJx2Gl/eudjutE49LuHAtcTAzDYEz3RkEMCM5zmDLUxa7j374xXvel1zxZVvc8UVVyVXK0TMq1PTi3PND7f21qkz8v+WxRGRXmMZ89rUG41zXXLLAhce8/n85a/fwuALF3sGFC2vRFeImte8bHLvn3vjF/k="
local accumulator_blueprint = "0eNqd1N1qxCAQBeB3OdcGVjd/66uUpbjpUITEhGhKQ/DdG9ObQkXQy5HxY+Awc+A1brSs2jjIA3qYjYV8O2D1p1FjeHP7QpDQjiYwGDWFylJlFzVQpYZhm7ZRuXmFZ9Dmg74huX8ykHHaafr1rmJ/N9v0ovVsSEsMy2zPz7MJEwTwxrBDVr337B8mcjGRwO65WJ3A6lysTWBNLtYnsDYTE6kAusI02xjWF6YZxR6FaUaxMHZRnHGNF+YZ10RhoKd27uq13fLPMWD4otVe7aLndfcQXcMbfm9v3v8A1Ixnhw=="
local storage_chests_blueprint = "0eNq9ld1ugzAMhd/F11ARILTwKlNVAXOpJZqw/ExDiHdfoNpWqSA2UHcXR/HnkzhH7qCoLTaKhIGsAyql0JC9dKCpEnk97Jm2QciADF7BA5Ffh6iWFWlDpV9eUBtfG6nyCqH3gMQrfkDG+qMHKAwZwhtxDNqTsNcClTvwzdK20CY3JIXjN1LTuHSVHcYPuQctZIEjC6TqUkirBl567L0HZjinr7DnszswgWe7WwE/2HFXo8gHaY6j8M26zNOZaoPqdoOvq/0oR1+XKm8cuJR2eELOg35KWfR3ZcH/KIuXevoojcX30iaYfAWTLzCTFcxwgblfwYwWmIcVTLbATH/nlXTaKmyq7SxY/yOf+yEZW+/iJysLN3hlprUs2uCVOWa8wStzTL7BK3PMZINXRqabMeNcyu7GmAfvrtdjSnhg8T4N95xxFiVB338CEc5GQw=="
local roboport_blueprint = "0eNqdkN0KwjAMhd8l11XstE77KiKynyDBLS1tJ47Rd7fbRITtyqtwkpMv4QxQNh1aRxxAD0CVYQ/6MoCnOxfN2Au9RdBAAVsQwEU7KmdKY40LEAUQ1/gCLeNVAHKgQDgzJtHfuGtLdMmw3BZgjU8LhsdLCbJRSkCfqoxRLAjZl+BDUT02xB5dSJMVTr79kHZblZ6syWE1G44r5P0/ZLkkpwimoPRPrgKe6PxkyE7ykJ+zXEkl98ddjG+fWH1F"
local requester_chest_blueprint = "0eNqFkdFuwyAMRf/Fz1CVrKwrv1JVVUJZZy2BDMy0KOLfa9Ktm9aHPoGR7/G9Zoauz26M6AnMDGiDT2D2MyQ8+7avbzSNDgwguQEE+HaoVR/OmAittG8ukYzuI/PpIhQB6E/uC4wqBwHOExK6K3MppqPPQ8edRj2mCRhDYkDw1QlD5Wa30gImvjUrzcO+e4+v2LPgOufHwI1fU1HMtoJkDF0gJtuQa2i9LuImae4t3bcfquBfll9hota+S/TJxUcJFCeoS1pWa/78hIBPzrJomhe12e6arVZaPT2vS7kAV7CQ5Q=="
local lamp_blueprint = "0eNrlmF2OmzAQx+8yz84KkwABrfqyx6giRMDJWjUG2SYtijhA79GT9SS1YfOxkLAmiqpm+4JkbM94fv8ZbLOHNatIKShXEO2BpgWXEH3dg6RbnjDzTtUlgQioIjkg4EluWhlJaUbELC3yNeWJKgQ0CCjPyA+IcLNCQLiiipLOWtuoY17layL0gKMdmSeMzViSl9p2WUg9peDGqzbjPHkIaohm7pOnjeulKVGweE1ekx3VDvWolIq0oirWfdlx6oYKqeJBADsqVKXfnHy3I2YJr9Ur5VvofEiVGBaOaeRlItrYIvhiuitJtCtWCB2VEhXpZnCSGtfS+MLmIUh2HjXVLa9ZNU2DBiRcKxL+gcT8wUhsBSG8z2JxxsG0/Sts5lZssPsfpMnCCsUMv6FwPkOauL00CdBx9V33ZVTepIpyHj9ncI/TvNfGjh04367cFp8rxy6zCMY2ugGTA5LgCpA3Gycg8gYiL+9RzIcsEBSVKqsJNkvKv3Vmy1qvruIq3ogijynXZiDaJEySxj4Tl+8TrZ+YGA8TEYFrvU8s7fJ4OUk771/Q7vfPXzeoVxPGiu931C8Y1y/sd4/LZ/m9DifJ5T9qqd1drI+Kzbmq1qU9xHKPMOMmqBU8bnHd+dMYTlEj7IuBrA6JGE8rpVaasN3GMyq6INrXf0sqvy/V8w1CvYyo1B4HJpyk8Dh47I4XER4vyWCYAxdlPN0JD6isisxWyQ1liogrt/wPKFdGNnx+0b+dbhf/CnV/FqKzHxEIdnqBbQzuEi+C0A08HztY82/+AOGyw88="
local recycling_blueprint = "0eNqdmNFuozAQRf/Fz1CBPWMgv7KqVoR4K6sJIHBWG0X594UkKpHitJd5TIsPw+Az4+Gstvuj6wffBrU5K9907ag2v85q9B9tvZ//Fk69UxvlgzuoRLX1Yf41unRwzanZ+/Yj/VM3fu/DSV0S5dud+6c2+eU9Ua4NPnh3A15/nH63x8PWDdMFX6gw1O3Yd0NIt24fplv03Tgt69r55hMqzbPsjRN1mhbxG0/32Pnp3rcr6JI8oTWOrqqXZBshmxXkchWZROkokHSwCG0RtF32Q6ibz9S3oxvC9J/v8gGRixXkahW5FKWjQtCVCF0i6DyTpHqOOgbLJdl9BdNrntrcaTqHntqI2BnEXqWcfsmO2Zyvci5fx7aSXQayC0HpBNGloHaC6Eq0SwzUSzIRW0PsXMTGeqDMSoLY5odjwHdv9NaypkW+vwPGZqj7BTOtno8a47x07J3bpYdud9y7lOZoYuGQ6FGh3qlZxIYakV7RPR8KkEWU0IvI/ZzoyBuhx0TEEOVDeN1Qf7g01O1nDPUVW/kCJRMUaowmE2WxhI57D33yuJ3w10ujMV+pRsee3iwqIn3W5PEkGgNhip8wopOmgYqlYUGNf0ZHX4UVdCYQXUiihiq8KSVRP6F1DL3CqWVTaGgWyURbBOpLJJr7DNSXaBFt6LbdjI4l4+6qjdlBRhQe1EtIZh7US0g05BloqiHRgdNA1ZsKCZug4YFEkx5BwwOJRj2CqiiL9COoILFIP4LUZi1iQ2qzyEvCvo+IvCTISxZ5SZCXLPKSIC9Z5CVDXrLIS4a8ZJGXDHlpRV4y5KUVecmQl1bkJUNeWpGXDHlpRV4y9uFS5CVDXlqRlxzx8v02Ck+g5SN9ov66YbwdC8ucikoXnHNubHa5/AfrJ63H"
local recycling_blueprint_2 = "0eNqd1uGumyAUB/B3OZ/hRhCk9lWWm8Uqa8gsGqDLTOO7X7zdrlsKBfoNlfz8I+eoNziNVzkbpR0cb6D6SVs4fruBVWfdjds5t8wSjqCcvAAC3V22Iyuxkf3Sj0qf8Y+uV6NyC6wIlB7kbziS9R2B1E45Je/g58HyXV8vJ2n8hC9qVt5HME/WT570dksP4MPhjSNY/Ii98XVFDwL9T8BuwmczXfUQssS/FoJB+fD3CU1ArlPZRCoby88m2mg2GpB5MptIZGuSQpMQRFLgCeGQFFhCaBOl+KygqociQODHav7D2d508456ayt+u0F2lnLAl2m4jhIzv9GhbKTKXx4NL4+QfKKOEHuDWNf1P7HSVhrnLwWezRdGcoqQ1Pnpqkg6lk+QCMFfWGCVtb69R56Zfzs3tgEiSxEJZe8VZzpt58k4fJKje1biD68SFpLbF2Se8/xoVSC3scxBmRTITVFmWiCLWObQ54TWL8h5mVmBzIpkXiDzIrkpkGmRLArkukgu6cEqJod6kJb0IIlnfr9/ozyz/88h+CWNvU84ECZaKjjhpG6qdf0AzBo0XQ=="
local miners_blueprint = "0eNqd2OGOmkAUhuF7md+48ZwzA8itNJsG18lmEhwNjE2N4d4XNds2LW2+fv/E4MsJ4WGEm9sPl3geUy6uu7n0dsqT677c3JTecz/cvyvXc3SdSyUeXeVyf7xv9WPsN8eUU37fHMY0DG6uXMqH+N11Mr9WLuaSSorP2GPj+jVfjvs4Ljv8I1O582lafnnK92MvtU2Ql1C56/LJXsJylEMa49tzB52rP+L6X3Ef/hqvV+L2I17GPk/n01g2+ziUtXL7Wdbfy36l7JmyIeXAnW1BTnbNTL1Fpm6YsiDllrtABLk+dsTU0NCyJcrQiZafGqfLfir9Y9eVqjyaOq81lJgOuniFEQeBE8+5qBEXEoixAzQ2Q85D5YaDUSMwpCXGbqCxGXM1UlbG3A4qC1FuoTIjUaBbkDIUBboHKbP6CXQDUUaiQHcQZSgKpFyZ5U8g5spIFIiiUssfZNEYiwJhNAajQBqN0aiQRqMWRkijMRoV0miMRoU0GqNRIY3GaFRIozEaFdJojEaFNHpGo0IaPaNRIY2e+pcKafSMRoM0ekajQRo9o9Gwx1lGo0EaPaPRII2e0WiQRs9oNEhjYDQapDEwGm1F42v1fIHU/fK+qXLf4jg9n6Fa8c1OmyBBrN7O8we3tQeW"
local fragment_deconstruction = "0eNqV1NtuhCAQANB/4VkTYb2s/kqzMSyOlpbLBtimG+O/l227cXyDNyVzcEaGWckEwhof3F0Eac14U9wYcGRYiYcQpFn88xlMkOExzlIFcHHlbSWGayBDjCoFd4stnRWfEP5fbnYiBZFmgm8yVFuBw33gQYpX/Oz4ouP25VUuJd8RTUbXHbFkJHZ0SkaopjoJaZjkXR/KqnIgKo3SHIjKo2k/xWuu1CHTOsPhRJsMh/NsMxw6CdplOEDunOFm5PoMt6DerDLcO3I0w0nkcs79A7m0+xBHwwO3C6vTGb6xTTpDzcLadIZ6hXXpDLUKO6cz1Cms3y4FCVLB6EHB34DVdoLfQUVkAB33Ow7g8jWAC/IVJ21ceX6e1l3PuoY29NRW2/YDL1f5Dg=="

local spider
local stack = game.create_inventory(1)[1]
local step = 1
local last_step_tick = game.tick

local actions = {
  {8, function()
    spider = game.surfaces.nauvis.find_entities_filtered{name = "spidertron", limit = 1}[1]
    spider.autopilot_destination = {11, 0}
  end},
  {1.7, function()
    stack.import_stack(solar_blueprint)
    stack.build_blueprint{surface=surface, force="player", position={14, -9}, build_mode=defines.build_mode.forced}
  end},
  {0.2, function()
    stack.build_blueprint{surface=surface, force="player", position={14, 9}, build_mode=defines.build_mode.forced}
  end},
  {0.8, function()
    stack.import_stack(accumulator_blueprint)
    stack.build_blueprint{surface=surface, force="player", position={14, 0}, build_mode=defines.build_mode.forced}
  end},
  {4.5, function()
    surface.create_entity{name="entity-ghost", inner_name="substation", force="player", position={5, 0}}
  end},
  {0.3, function()
    spider.autopilot_destination = {-19, -5}
  end},
  {2.5, function()
    stack.import_stack(storage_chests_blueprint)
    stack.build_blueprint{surface=surface, force="player", position={-20, 0}, build_mode=defines.build_mode.forced}
  end},
  {2.7, function()
    stack.import_stack(roboport_blueprint)
    stack.build_blueprint{surface=surface, force="player", position={-18, 6}, build_mode=defines.build_mode.forced, direction=defines.direction.north}
  end},
  {1.2, function()
    stack.build_blueprint{surface=surface, force="player", position={-26, -7}, build_mode=defines.build_mode.forced, direction=defines.direction.east}
  end},
  {1.2, function()
    stack.import_stack(requester_chest_blueprint)
    stack.build_blueprint{surface=surface, force="player", position={-17, 3}, build_mode=defines.build_mode.forced, direction=defines.direction.north}
  end},
  {0.3, function()
    stack.build_blueprint{surface=surface, force="player", position={-23, -6}, build_mode=defines.build_mode.forced, direction=defines.direction.east}
  end},
  {0.8, function()
    stack.set_stack{name="deconstruction-planner", count=1}
    stack.deconstruct_area{surface=surface, force="player", area={{-14, -8}, {-10, -4}}}
    surface.create_entity{name="entity-ghost", inner_name="roboport", force="player", position={-12, -6}}
  end},
  {3.3, function()
    spider.autopilot_destination = {-21, -2}
  end},
  {0.3, function()
    stack.set_stack{name="deconstruction-planner", count=1}
    stack.set_entity_filter(1, "se-cargo-rocket-cargo-pod")
    stack.deconstruct_area{surface=surface, force="player", area={{-40, -40}, {40, 40}}}
  end},
  {9.5, function()
    stack.import_stack(fragment_deconstruction)
    stack.deconstruct_area{surface=surface, force="player", area={{-40, -40}, {40, 40}}}
  end},
  {7.8, function()
    spider.autopilot_destination = {-18, -10}
    spider.add_autopilot_destination{-14, -10}
  end},
  {1.2, function()
    surface.create_entity{name="entity-ghost", inner_name="substation", force="player", position={-12, -14}}
    surface.create_entity{name="entity-ghost", inner_name="substation", force="player", position={5, -14}}
  end},
  {3, function()
    stack.import_stack(lamp_blueprint)
    stack.build_blueprint{surface=surface, force="player", position={-4, -7}, build_mode=defines.build_mode.forced}
  end},
  {4.5, function()
    spider.autopilot_destination = {-4, -10}
    spider.add_autopilot_destination{-4, 60}
  end},
  {0.8, function()
    stack.import_stack(solar_blueprint)
    stack.build_blueprint{surface=surface, force="player", position={14, -21}, build_mode=defines.build_mode.forced}
    stack.build_blueprint{surface=surface, force="player", position={14, 21}, build_mode=defines.build_mode.forced}
    --stack.set_stack{name="deconstruction-planner", count=1}
    --stack.deconstruct_area{surface=surface, force="player", area={{20, -2}, {24, 2}}}
    surface.create_entity{name="entity-ghost", inner_name="roboport", force="player", position={22, 0}}
  end},
  {1.6, function()
    stack.set_stack{name="deconstruction-planner", count=1}
    stack.set_entity_filter(1, "bulk-inserter")
    stack.deconstruct_area{surface=surface, force="player", area={{-20, 5}, {-19, 7}}}
    stack.import_stack(recycling_blueprint)
    stack.build_blueprint{surface=surface, force="player", position={-23, 19}, build_mode=defines.build_mode.forced}
    stack.import_stack(solar_blueprint)
    stack.build_blueprint{surface=surface, force="player", position={26, -21}, build_mode=defines.build_mode.forced}
    stack.build_blueprint{surface=surface, force="player", position={26, 21}, build_mode=defines.build_mode.forced}
  end},
  {1.6, function()
    stack.build_blueprint{surface=surface, force="player", position={26, -9}, build_mode=defines.build_mode.forced}
    stack.build_blueprint{surface=surface, force="player", position={26, 9}, build_mode=defines.build_mode.forced}
  end},
  {1.6, function()
    stack.build_blueprint{surface=surface, force="player", position={38, -21}, build_mode=defines.build_mode.forced}
    stack.build_blueprint{surface=surface, force="player", position={38, 21}, build_mode=defines.build_mode.forced}
    stack.import_stack(accumulator_blueprint)
    stack.build_blueprint{surface=surface, force="player", position={30, 0}, build_mode=defines.build_mode.forced}
  end},
  {1.6, function()
    stack.import_stack(solar_blueprint)
    stack.build_blueprint{surface=surface, force="player", position={38, -9}, build_mode=defines.build_mode.forced}
    stack.build_blueprint{surface=surface, force="player", position={38, 9}, build_mode=defines.build_mode.forced}
  end},
  {3.2, function()
    stack.import_stack(recycling_blueprint_2)
    stack.build_blueprint{surface=surface, force="player", position={-28, 10}, build_mode=defines.build_mode.forced}
  end},
  {3.2, function()
    stack.import_stack(miners_blueprint)
    stack.build_blueprint{surface=surface, force="player", position={-41, 17}, build_mode=defines.build_mode.forced}
  end},
}

function check_next(ticks_since_last_step, seconds_until_action, next_action)
  if ticks_since_last_step >= seconds_until_action * 60 then
    next_action()
    last_step_tick = game.tick
    step = step + 1
  end
end

script.on_nth_tick(1, function()
  local ticks_since_last_step = game.tick - last_step_tick
  if actions[step] then
    check_next(ticks_since_last_step, actions[step][1], actions[step][2])
  end
end)
