local data_util = require("data_util")

-- stop nukes making land in space.
local max_depth = 20
local function set_tiles_mask_recursive(object, depth)
  if type(object) == "table" and depth < max_depth then
    for _, child in pairs(object) do
      set_tiles_mask_recursive(child, depth + 1)
    end
    if object.type == "set-tile" then
      object.tile_collision_mask = object.tile_collision_mask or {}
      object.tile_collision_mask.layers[space_collision_layer] = true
      object.tile_collision_mask.layers[spaceship_collision_layer] = true
    end
  end
end
set_tiles_mask_recursive(data.raw, 0)

-- all space tiles have space_collision_layer ("space-tile")
-- if there is "space-tile" on planet, except spaceship tile, we can remove that.
-- we need the same for planet tiles, but for it to NOT be on out-of-map tiles.
-- IMPORTANT: never use this on a space tile or out-of-map, it WILL horribly break the fix tiles code.
for _, tile in pairs(data.raw.tile) do
  tile.check_collision_with_entities = true
  -- if not a moving tile then it's a static tile
  if not tile.collision_mask.layers[spaceship_collision_layer] then
    tile.collision_mask.layers[static_tile_layer] = true
  end

  if tile.name ~= "out-of-map" and not tile.collision_mask.layers[space_collision_layer] then
    tile.collision_mask.layers[planet_collision_layer] = true
  end
end
