local data_util = require("data_util")
--[[
Trunk 10x10, chamber connections in middle of each edge.
Branch 8x4, chamber connections in middle of each edge. Can have leaves connecting anywhere along the long sides.
Leaf 3x5, Has 1 connection in the middle 1 of the narrow sides. Must connect anywhere along the long side of a chamber.

emitter = Maser transmitter -- storage tank?
chamber = Maser chamber -- storage tank?
Leaf = Maser injector -- assembling machine

emitter = Maser transmitter -- assembling (anything that can be opened, maybe roboport?)
chamber = Maser chamber -- storage tank?
Leaf = Maser injector -- assembling machine, reactor

178, 160, 76
]]

local blank = {
  -- direction_count = 8,
  frame_count = 1,
  filename = "__space-exploration-graphics__/graphics/blank.png",
  width = 1,
  height = 1,
  priority = "low"
}

local emitter_layers = {
  {
    filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/energy-transmitter.png",
    priority = "high",
    width = 640,
    height = 736,
    frame_count = 1,
    line_length = 1,
    shift = util.by_pixel(0, -24),
    animation_speed = 1,
    scale = 0.5,
  },
  {
    draw_as_shadow = true,
    filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/energy-transmitter-shadow.png",
    priority = "high",
    width = 709,
    height = 477,
    frame_count = 1,
    line_length = 1,
    repeat_count = 1,
    shift = util.by_pixel(32, 28),
    scale = 0.5*10/9,
  },
}

-- someone (else) will need to uncomment the shadows and adjust their shifts
local emitter_pipe_pictures = {
  north = {
    layers = {
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-south-addon.png",
        priority = "high",
        width = 64,
        height = 128,
        shift = {0, 1},
        scale = 0.5
      },
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-south-addon-glow.png",
        priority = "high",
        width = 64,
        height = 128,
        shift = {0, 1},
        scale = 0.5
      },
      -- {
      --   draw_as_shadow = true,
      --   filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-south-addon-shadow.png",
      --   priority = "high",
      --   width = 96,
      --   height = 148,
      --   scale = 0.5,
      --   shift = util.by_pixel(32, 0),
      -- },
    }
  },
  east = {
    layers = {
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-west-addon.png",
        priority = "high",
        width = 96,
        height = 96,
        shift = {-1.25, -0.25},
        scale = 0.5
      },
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-west-addon-glow.png",
        priority = "high",
        width = 96,
        height = 96,
        shift = {-1.25, -0.25},
        scale = 0.5
      },
      -- {
      --   draw_as_shadow = true,
      --   filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-west-addon-shadow.png",
      --   priority = "high",
      --   width = 80,
      --   height = 68,
      --   scale = 0.5,
      --   shift = util.by_pixel(32, 0),
      -- },
    }
  },
  south = {
    layers = {
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-north-addon.png",
        priority = "high",
        width = 64,
        height = 192,
        shift = {0, -1.5},
        scale = 0.5
      },
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-north-addon-glow.png",
        priority = "high",
        width = 64,
        height = 192,
        shift = {0, -1.5},
        scale = 0.5
      },
      -- {
      --   draw_as_shadow = true,
      --   filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-north-addon-shadow.png",
      --   priority = "high",
      --   width = 128,
      --   height = 138,
      --   scale = 0.5,
      --   shift = util.by_pixel(32, 1),
      -- }
    }
  },
  west = {
    layers = {
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-east-addon.png",
        priority = "high",
        width = 96,
        height = 96,
        shift = {1.25, -0.25},
        scale = 0.5
      },
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-east-addon-glow.png",
        priority = "high",
        width = 96,
        height = 96,
        shift = {1.25, -0.25},
        scale = 0.5
      },
      -- {
      --   draw_as_shadow = true,
      --   filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-east-addon-shadow.png",
      --   priority = "high",
      --   width = 24,
      --   height = 54,
      --   scale = 0.5,
      --   shift = util.by_pixel(32, 0),
      -- },
    }
  },
}

-- someone (else) will need to uncomment the shadows and adjust their shifts
local chamber_pipe_pictures = {
  north = {
    layers = {
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-h-north.png",
        priority = "high",
        width = 192,
        height = 160,
        shift = {0, 0.75},
        scale = 0.5
      },
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-h-north-glow.png",
        priority = "high",
        width = 192,
        height = 160,
        shift = {0, 0.75},
        scale = 0.5
      },
      -- {
      --   draw_as_shadow = true,
      --   filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-h-north-shadow.png",
      --   priority = "high",
      --   width = 116,
      --   height = 74,
      --   scale = 0.5,
      --   shift = util.by_pixel(32, 0),
      -- },
    }
  },
  east = {
    layers = {
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-v-east.png",
        priority = "high",
        width = 128,
        height = 224,
        shift = {-1.5, -0.25},
        scale = 0.5
      },
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-v-east-glow.png",
        priority = "high",
        width = 128,
        height = 224,
        shift = {-1.5, -0.25},
        scale = 0.5
      },
      -- {
      --   draw_as_shadow = true,
      --   filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-v-east-shadow.png",
      --   priority = "high",
      --   width = 90,
      --   height = 84,
      --   scale = 0.5,
      --   shift = util.by_pixel(32, 0),
      -- },
    }
  },
  south = {
    layers = {
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-h-south.png",
        priority = "high",
        width = 192,
        height = 192,
        shift = {0, -2},
        scale = 0.5
      },
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-h-south-glow.png",
        priority = "high",
        width = 192,
        height = 192,
        shift = {0, -2},
        scale = 0.5
      },
      -- {
      --   draw_as_shadow = true,
      --   filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-h-south-shadow.png",
      --   priority = "high",
      --   width = 114,
      --   height = 22,
      --   scale = 0.5,
      --   shift = util.by_pixel(32, 32),
      -- },
    }
  },
  west = {
    layers = {
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-v-west.png",
        priority = "high",
        width = 128,
        height = 224,
        shift = {1.5, -0.25},
        scale = 0.5
      },
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-v-west-glow.png",
        priority = "high",
        width = 128,
        height = 224,
        shift = {1.5, -0.25},
        scale = 0.5
      },
      -- {
      --   draw_as_shadow = true,
      --   filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-v-west-shadow.png",
      --   priority = "high",
      --   width = 20,
      --   height = 84,
      --   scale = 0.5,
      --   shift = util.by_pixel(32, 0),
      -- },
    }
  },
}

local fluid = {
  type = "fluid",
  name = data_util.mod_prefix .. "energy-transmitter-fluid",
  icon = "__space-exploration-graphics__/graphics/blank.png",
  base_color = {255, 255, 0},
  flow_color = {255, 255, 0},
  default_temperature = 15,
  fuel_value = "1GW",
  auto_barrel = false,
  hidden = true,
}
data:extend{fluid}

data:extend({
  {
      type = "technology",
      name = data_util.mod_prefix .. "energy-beaming",
      effects = {
       {  type = "unlock-recipe",  recipe = data_util.mod_prefix .. "energy-transmitter-emitter" },
       {  type = "unlock-recipe",  recipe = data_util.mod_prefix .. "energy-transmitter-chamber" },
       {  type = "unlock-recipe",  recipe = data_util.mod_prefix .. "energy-transmitter-injector" },
       {  type = "unlock-recipe",  recipe = data_util.mod_prefix .. "energy-receiver" },
      },
      icon = "__space-exploration-graphics__/graphics/technology/energy-transmitter.png",
      icon_size = 128,
      order = "e-g",
      prerequisites = {
        data_util.mod_prefix .. "superconductive-cable",
        data_util.mod_prefix .. "aeroframe-bulkhead",
      },
      unit = {
       count = 500,
       time = 30,
       ingredients = {
         { "automation-science-pack", 1 },
         { "logistic-science-pack", 1 },
         { "chemical-science-pack", 1 },
         { "production-science-pack", 1 },
         { data_util.mod_prefix .. "rocket-science-pack", 1 },
         { data_util.mod_prefix .. "astronomic-science-pack-3", 1 },
         { data_util.mod_prefix .. "material-science-pack-3", 1 },
         { data_util.mod_prefix .. "energy-science-pack-3", 1 },
       }
      },
  },
  {
      type = "recipe",
      name = data_util.mod_prefix .. "energy-receiver",
      results = {
        {type = "item", name = data_util.mod_prefix .. "energy-receiver", amount = 1},
      },
      enabled = false,
      energy_required = 10,
      ingredients = {
        {type = "item", name = SEItemNames.get_glass_name(), amount = 1000},
        {type = "item", name = "copper-plate", amount = 1000},
        {type = "item", name =  data_util.mod_prefix .. "heat-shielding", amount = 100},
        {type = "item", name = data_util.mod_prefix .. "aeroframe-bulkhead", amount = 100},
        {type = "item", name = data_util.mod_prefix .. "superconductive-cable", amount = 20},
        {type = "item", name = data_util.mod_prefix .. "heavy-girder", amount = 100},
        {type = "item", name = "processing-unit", amount = 50},
      },
      requester_paste_multiplier = 1,
      always_show_made_in = false,
  },
  {
      type = "recipe",
      name = data_util.mod_prefix .. "energy-transmitter-emitter",
      results = {
        {type = "item", name = data_util.mod_prefix .. "energy-transmitter-emitter", amount = 1},
      },
      enabled = false,
      energy_required = 10,
      ingredients = {
        {type = "item", name = SEItemNames.get_glass_name(), amount = 1000},
        {type = "item", name = data_util.mod_prefix .. "aeroframe-bulkhead", amount = 100},
        {type = "item", name = data_util.mod_prefix .. "superconductive-cable", amount = 200},
        {type = "item", name = data_util.mod_prefix .. "heavy-girder", amount = 200},
        {type = "item", name = "processing-unit", amount = 100},
      },
      requester_paste_multiplier = 1,
      always_show_made_in = false,
  },
  {
      type = "recipe",
      name = data_util.mod_prefix .. "energy-transmitter-chamber",
      results = {
        {type = "item", name = data_util.mod_prefix .. "energy-transmitter-chamber", amount = 1},
      },
      enabled = false,
      energy_required = 10,
      ingredients = {
        {type = "item", name = SEItemNames.get_glass_name(), amount = 100},
        {type = "item", name = data_util.mod_prefix .. "aeroframe-bulkhead", amount = 50},
        {type = "item", name = data_util.mod_prefix .. "superconductive-cable", amount = 50},
        {type = "item", name = data_util.mod_prefix .. "heavy-girder", amount = 50},
      },
      requester_paste_multiplier = 1,
      always_show_made_in = false,
  },
  {
      type = "recipe",
      name = data_util.mod_prefix .. "energy-transmitter-injector",
      results = {
        {type = "item", name = data_util.mod_prefix .. "energy-transmitter-injector", amount = 1},
      },
      enabled = false,
      energy_required = 10,
      ingredients = {
        {type = "item", name = SEItemNames.get_glass_name(), amount = 100},
        {type = "item", name = data_util.mod_prefix .. "aeroframe-bulkhead", amount = 100},
        {type = "item", name = data_util.mod_prefix .. "superconductive-cable", amount = 100},
        {type = "item", name = data_util.mod_prefix .. "heavy-girder", amount = 100},
        {type = "item", name = "processing-unit", amount = 50},
      },
      requester_paste_multiplier = 1,
      always_show_made_in = false,
  },
  {
      type = "item",
      name = data_util.mod_prefix .. "energy-receiver",
      icon = "__space-exploration-graphics__/graphics/icons/energy-receiver.png",
      icon_size = 64,
      order = "b-a",
      subgroup = "beaming",
      stack_size = 1,
      place_result = data_util.mod_prefix .. "energy-receiver",
  },
  {
      type = "item",
      name = data_util.mod_prefix .. "energy-transmitter-emitter",
      icon = "__space-exploration-graphics__/graphics/icons/energy-transmitter.png",
      icon_size = 64,
      order = "a-a",
      subgroup = "beaming",
      stack_size = 1,
      place_result = data_util.mod_prefix .. "energy-transmitter-emitter",
  },
  {
      type = "item",
      name = data_util.mod_prefix .. "energy-transmitter-chamber",
      icon = "__space-exploration-graphics__/graphics/icons/energy-transmitter-chamber.png",
      icon_size = 64,
      order = "a-b",
      subgroup = "beaming",
      stack_size = 10,
      place_result = data_util.mod_prefix .. "energy-transmitter-chamber",
  },
  {
      type = "item",
      name = data_util.mod_prefix .. "energy-transmitter-injector",
      icon = "__space-exploration-graphics__/graphics/icons/energy-transmitter-injector.png",
      icon_size = 64,
      order = "a-c",
      subgroup = "beaming",
      stack_size = 50,
      place_result = data_util.mod_prefix .. "energy-transmitter-injector",
  },
  { --
    type = "recipe",
    name = data_util.mod_prefix .. "energy-transmitter-emitter-fixed",
    localised_name = {"entity-name."..data_util.mod_prefix.."energy-transmitter-emitter"},
    icon = "__space-exploration-graphics__/graphics/blank.png",
    icon_size = 32,
    order = "a-d",
    subgroup = "beaming",
    energy_required = 1,
    category = "fixed-recipe",
    ingredients = {},
    results = {},
    flags = {},
    hidden = true,
    enabled = true,
    always_show_made_in = true,
  },
  { --
    type = "recipe",
    name = data_util.mod_prefix .. "energy-transmitter-injector-fixed",
    localised_name = {"entity-name."..data_util.mod_prefix.."energy-transmitter-injector"},
    icon = "__space-exploration-graphics__/graphics/blank.png",
    icon_size = 32,
    order = "a-d",
    subgroup = "beaming",
    energy_required = 1,
    category = "fixed-recipe",
    ingredients = {},
    results = {
      {type = "fluid", name = fluid.name, amount = 0}
    },
    flags = {},
    hidden = true,
    enabled = true,
    always_show_made_in = true,
  },
  {
    type = "item",
    name = data_util.mod_prefix .. "energy-transmitter-targeter",
    icon = "__space-exploration-graphics__/graphics/icons/energy-transmitter-targeter.png",
    icon_size = 64,
    subgroup = "beaming",
    order = "a-d",
    stack_size = 1,
    hidden = true,
    flags = {"only-in-cursor"},
  },
  {
    type = "assembling-machine",
    name = data_util.mod_prefix .. "energy-transmitter-emitter", -- emitter
    icon = "__space-exploration-graphics__/graphics/icons/energy-transmitter.png",
    icon_size = 64,
    minable = {mining_time = 0.5, result = data_util.mod_prefix .. "energy-transmitter-emitter"},
    order = "a-a",
    allow_copy_paste = true,
    fluid_boxes =
    {
      {
        volume = 100 * 1,

        height = 1,
        pipe_connections = {
          { flow_direction = "input", position = { -4.7, 0 }, direction = defines.direction.west },
          { flow_direction = "input", position = { 4.7, 0 }, direction = defines.direction.east },
          { flow_direction = "input", position = { 0, -4.7}, direction = defines.direction.north },
          { flow_direction = "input", position = { 0, 4.7 }, direction = defines.direction.south },
        },
        production_type = "input"
      },
    },
    graphics_set = {
      animation = -- structure =
      {
        north = {layers = emitter_layers},
        south = {layers = emitter_layers},
        east = {layers = emitter_layers},
        west = {layers = emitter_layers},
      },
    },
    collision_box = data_util.auto_box(10, 10, 0.2),
    selection_box = data_util.auto_box(10, 10),
    drawing_box_vertical_extension = 1,
    collision_mask = {
      layers = {
        water_tile = true,
        item = true,
        object = true,
        player = true,
        [spaceship_collision_layer] = true
      },
    },
    se_allow_in_space = true,
    ignore_by_tomwub = {ignore = true}, -- https://discord.com/channels/419526714721566720/1421944675719184486/1421944675719184486
    corpse = "medium-remnants",
    energy_source = {
      type = "electric",
      usage_priority = "secondary-input",
      buffer_capacity = "10GJ",
    },
    energy_usage = "1GW",
    flags = {
      "placeable-player",
      "player-creation",
    },
    max_health = 5000,
    impact_category = "metal-large",
    open_sound = data_util.machine_open_sound,
    close_sound = data_util.machine_close_sound,
    crafting_speed = 1,
    crafting_categories = {"fixed-recipe"},
    fixed_recipe = data_util.mod_prefix .. "energy-transmitter-emitter-fixed",
    working_sound = {
      apparent_volume = 1.5,
      fade_in_ticks = 10,
      fade_out_ticks = 30,
      max_sounds_per_type = 3,
      sound = {
        {
          filename = "__base__/sound/nuclear-reactor-1.ogg",
          volume = 0.6
        },
        {
          filename = "__base__/sound/nuclear-reactor-2.ogg",
          volume = 0.6
        }
      }
    },
    --fire = blank,
    --fire_glow = blank,
    --burning_cooldown = 20,
    --target_temperature = 1000000,
    --mode = "heat-fluid-inside",
    --energy_consumption = "100MW",
    --energy_usage = "100MW",
    --light = {intensity = 1, size = 8, shift = {0.0, 0.0}, color = {r = 0.6, g = 0.9, b = 1}}
  },
  {
    type = "boiler",
    name = data_util.mod_prefix .. "energy-transmitter-chamber",
    icon = "__space-exploration-graphics__/graphics/icons/energy-transmitter-chamber.png",
    icon_size = 64,
    minable = {mining_time = 0.2, result = data_util.mod_prefix .. "energy-transmitter-chamber"},
    order = "a-b",
    allow_copy_paste = true,
    collision_box = data_util.auto_box(4, 8, 0.05),
    selection_box = data_util.auto_box(4, 8),
    collision_mask = {
      layers = {
        water_tile = true,
        item = true,
        object = true,
        player = true,
        [spaceship_collision_layer] = true,
      },
    },
    se_allow_in_space = true,
    ignore_by_tomwub = {ignore = true}, -- https://discord.com/channels/419526714721566720/1421944675719184486/1421944675719184486
    fluid_box = {
      hide_connection_info = true, -- visual overkill
      volume = 100,
      height = 1,
      draw_only_when_connected = true,
      pipe_picture = emitter_pipe_pictures,
      pipe_connections = {
        {flow_direction = "input", position = {-1.5, -3.5}, direction = defines.direction.west, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},
        {flow_direction = "input", position = {-1.5, -2.5}, direction = defines.direction.west, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},
        {flow_direction = "input", position = {-1.5, -1.5}, direction = defines.direction.west, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},
        {flow_direction = "input", position = {-1.5, -0.5}, direction = defines.direction.west, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},
        {flow_direction = "input", position = {-1.5,  0.5}, direction = defines.direction.west, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},
        {flow_direction = "input", position = {-1.5,  1.5}, direction = defines.direction.west, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},
        {flow_direction = "input", position = {-1.5,  2.5}, direction = defines.direction.west, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},
        {flow_direction = "input", position = {-1.5,  3.5}, direction = defines.direction.west, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},

        {flow_direction = "input", position = {1.5, -3.5}, direction = defines.direction.east, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},
        {flow_direction = "input", position = {1.5, -2.5}, direction = defines.direction.east, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},
        {flow_direction = "input", position = {1.5, -1.5}, direction = defines.direction.east, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},
        {flow_direction = "input", position = {1.5, -0.5}, direction = defines.direction.east, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},
        {flow_direction = "input", position = {1.5,  0.5}, direction = defines.direction.east, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},
        {flow_direction = "input", position = {1.5,  1.5}, direction = defines.direction.east, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},
        {flow_direction = "input", position = {1.5,  2.5}, direction = defines.direction.east, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},
        {flow_direction = "input", position = {1.5,  3.5}, direction = defines.direction.east, connection_category = data_util.mod_prefix .. "energy-transmitter-injector"},
      },
      production_type = "input-output"
    },
    output_fluid_box = {
      max_pipeline_extent = 2000000,
      hide_connection_info = true,
      volume = 100,
      height = 1,
      draw_only_when_connected = true,
      pipe_picture = chamber_pipe_pictures,
      pipe_connections = {
        {connection_type = "underground", max_underground_distance = 1, flow_direction = "output", position = {-1.5, 0}, direction = defines.direction.west, connection_category = data_util.mod_prefix .. "energy-transmitter-chamber"},
        {connection_type = "underground", max_underground_distance = 1, flow_direction = "output", position = { 1.5, 0}, direction = defines.direction.east, connection_category = data_util.mod_prefix .. "energy-transmitter-chamber"},
      },
      production_type = "output"
    },
    fire = blank,
    fire_glow = blank,
    burning_cooldown = 20,
    target_temperature = 1000000,
    mode = "heat-fluid-inside",
    pictures =
    {
      east = {
        structure = {
        layers =
        {
          {
            filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-h.png",
            priority = "high",
            width = 512,
            height = 256,
            frame_count = 1,
            line_length = 1,
            animation_speed = 1,
            scale = 0.5
          },
          {
            filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-h-glow.png",
            priority = "high",
            width = 512,
            height = 256,
            frame_count = 1,
            line_length = 1,
            animation_speed = 1,
            scale = 0.5,
          },
          {
            draw_as_shadow = true,
            filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-h-shadow.png",
            priority = "high",
            width = 578,
            height = 250,
            frame_count = 1,
            line_length = 1,
            animation_speed = 1,
            scale = 0.5,
            shift = util.by_pixel(17, 1),
          },
        },
      },
      },
      west = {
        structure = {
          layers =
        {
          {
            filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-h.png",
            priority = "high",
            width = 512,
            height = 256,
            frame_count = 1,
            line_length = 1,
            animation_speed = 1,
            scale = 0.5
          },
          {
            filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-h-glow.png",
            priority = "high",
            width = 512,
            height = 256,
            frame_count = 1,
            line_length = 1,
            animation_speed = 1,
            scale = 0.5,
          },
          {
            draw_as_shadow = true,
            filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-h-shadow.png",
            priority = "high",
            width = 578,
            height = 250,
            frame_count = 1,
            line_length = 1,
            animation_speed = 1,
            scale = 0.5,
            shift = util.by_pixel(17, 1),
          },
        },
      }
      },
      north = {
        structure = {
        layers =
        {
          {
            filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-v.png",
            priority = "high",
            width = 256,
            height = 576,
            frame_count = 1,
            line_length = 1,
            animation_speed = 1,
            shift = {0, -0.5},
            scale = 0.5
          },
          {
            filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-v-glow.png",
            priority = "high",
            width = 256,
            height = 576,
            frame_count = 1,
            line_length = 1,
            animation_speed = 1,
            shift = {0, -0.5},
            scale = 0.5
          },
          {
            draw_as_shadow = true,
            filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-v-shadow.png",
            priority = "high",
            width = 260,
            height = 562,
            frame_count = 1,
            line_length = 1,
            animation_speed = 1,
            scale = 0.5,
            shift = util.by_pixel(2, -8),
          },
        },
      },
      },
      south = {
        structure = {
        layers =
        {
          {
            filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-v.png",
            priority = "high",
            width = 256,
            height = 576,
            frame_count = 1,
            line_length = 1,
            animation_speed = 1,
            shift = {0, -0.5},
            scale = 0.5
          },
          {
            filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-v-glow.png",
            priority = "high",
            width = 256,
            height = 576,
            frame_count = 1,
            line_length = 1,
            animation_speed = 1,
            shift = {0, -0.5},
            scale = 0.5
          },
          {
            draw_as_shadow = true,
            filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/chamber-v-shadow.png",
            priority = "high",
            width = 260,
            height = 562,
            frame_count = 1,
            line_length = 1,
            animation_speed = 1,
            scale = 0.5,
            shift = util.by_pixel(2, -8),
          },
        },
      },
      },
    },
    corpse = "medium-remnants",
    alert_icon_scale = 0,
    energy_source = {
      type = "fluid",
      usage_priority = "secondary-input",
      buffer_capacity = "1GJ",
      burns_fluid = true,
      fluid_box = {
        max_pipeline_extent = 2000000,
        filter = fluid.name,
        hide_connection_info = true,
        volume = 100,
        height = 1,
        draw_only_when_connected = true,
        pipe_connections = {
          {connection_type = "underground", max_underground_distance = 1, flow_direction = "input-output", position = { 0, -3.5}, direction = defines.direction.north, connection_category = data_util.mod_prefix .. "energy-transmitter-chamber"},
          {connection_type = "underground", max_underground_distance = 1, flow_direction = "input-output", position = { 0,  3.5}, direction = defines.direction.south, connection_category = data_util.mod_prefix .. "energy-transmitter-chamber"},
        },
        production_type = "output"
      }
    },
    energy_consumption = "100MW",
    energy_usage = "100MW",
    flags = {
      "placeable-player",
      "player-creation",
    },
    max_health = 5000,
    impact_category = "metal-large",
    crafting_speed = 1,
    crafting_categories = {"fixed-recipe"},
    working_sound = {
      apparent_volume = 1.5,
      fade_in_ticks = 10,
      fade_out_ticks = 30,
      max_sounds_per_type = 3,
      sound = {
        {
          filename = "__base__/sound/nuclear-reactor-1.ogg",
          volume = 0.6
        },
        {
          filename = "__base__/sound/nuclear-reactor-2.ogg",
          volume = 0.6
        }
      }
    },
    --light = {intensity = 1, size = 8, shift = {0.0, 0.0}, color = {r = 0.6, g = 0.9, b = 1}}
  },
  {
    type = "assembling-machine",
    name = data_util.mod_prefix .. "energy-transmitter-injector",
    icon = "__space-exploration-graphics__/graphics/icons/energy-transmitter-injector.png",
    icon_size = 64,
    minable = {mining_time = 0.1, result = data_util.mod_prefix .. "energy-transmitter-injector"},
    fixed_recipe = data_util.mod_prefix .. "energy-transmitter-injector-fixed",
    order = "a-c",
    allow_copy_paste = true,
    collision_box = data_util.auto_box(3, 5, 0.2),
    selection_box = data_util.auto_box(3, 5),
    collision_mask = {
      layers = {
        water_tile = true,
        item = true,
        object = true,
        player = true,
        [spaceship_collision_layer] = true,
      },
    },
    se_allow_in_space = true,
    fluid_boxes = {
      {
        volume = 100,
        height = 1,
        pipe_connections = {
          {
            position = {0, -2},
            flow_direction = "output",
            direction = defines.direction.north,
            connection_category = data_util.mod_prefix .. "energy-transmitter-injector",
          },
        },
        production_type = "output"
      },
    },
    graphics_set = {

      animation =
      {
        east = {
          layers =
          {
            {
              filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-east.png",
              priority = "high",
              width = 352,
              height = 224,
              frame_count = 1,
              line_length = 1,
              animation_speed = 1,
              shift = {-0.25, -0.25},
              scale = 0.5
            },
            {
              filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-east-glow.png",
              priority = "high",
              width = 352,
              height = 224,
              frame_count = 1,
              line_length = 1,
              shift = {-0.25, -0.25},
              animation_speed = 1,
              scale = 0.5
            },
            {
              draw_as_shadow = true,
              filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-east-shadow.png",
              priority = "high",
              width = 394,
              height = 186,
              frame_count = 1,
              line_length = 1,
              animation_speed = 1,
              scale = 0.5,
              shift = util.by_pixel(22, -3),
            },
          },
        },
        west = {
          layers =
          {
            {
              filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-west.png",
              priority = "high",
              width = 352,
              height = 224,
              frame_count = 1,
              line_length = 1,
              animation_speed = 1,
              shift = {0.25, -0.25},
              scale = 0.5
            },
            {
              filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-west-glow.png",
              priority = "high",
              width = 352,
              height = 224,
              frame_count = 1,
              line_length = 1,
              animation_speed = 1,
              shift = {0.25, -0.25},
              scale = 0.5
            },
            {
              draw_as_shadow = true,
              filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-west-shadow.png",
              priority = "high",
              width = 414,
              height = 184,
              frame_count = 1,
              line_length = 1,
              animation_speed = 1,
              scale = 0.5,
              shift = util.by_pixel(24, -4),
            },
          },
        },
        north = {
          layers =
          {
            {
              filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-north.png",
              priority = "high",
              width = 192,
              height = 352,
              frame_count = 1,
              line_length = 1,
              animation_speed = 1,
              shift = {0, -0.2},
              scale = 0.5
            },
            {
              filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-north-glow.png",
              priority = "high",
              width = 192,
              height = 352,
              frame_count = 1,
              line_length = 1,
              animation_speed = 1,
              shift = {0, -0.25},
              scale = 0.5
            },
            {
              draw_as_shadow = true,
              filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-north-shadow.png",
              priority = "high",
              width = 250,
              height = 348,
              frame_count = 1,
              line_length = 1,
              animation_speed = 1,
              scale = 0.5,
              shift = util.by_pixel(14, -6),
            },
          },
        },
        south = {
          layers =
          {
            {
              filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-south.png",
              priority = "high",
              width = 192,
              height = 384,
              frame_count = 1,
              line_length = 1,
              animation_speed = 1,
              scale = 0.5
            },
            {
              filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-south-glow.png",
              priority = "high",
              width = 192,
              height = 384,
              frame_count = 1,
              line_length = 1,
              animation_speed = 1,
              scale = 0.5
            },
            {
              draw_as_shadow = true,
              filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/injector-south-shadow.png",
              priority = "high",
              width = 250,
              height = 356,
              frame_count = 1,
              line_length = 1,
              animation_speed = 1,
              scale = 0.5,
              shift = util.by_pixel(15, 1),
            },
          },
        },
      },
    },
    corpse = "medium-remnants",
    energy_source = {
      type = "void",
      buffer_capacity = "10GJ",
      usage_priority = "secondary-input",
      input_flow_limit = "1GW",
    },
    energy_usage = "1MW",
    flags = {
      "placeable-player",
      "player-creation",
    },
    max_health = 5000,
    open_sound = data_util.machine_open_sound,
    close_sound = data_util.machine_close_sound,
    impact_category = "metal-large",
    crafting_speed = 1,
    crafting_categories = {"fixed-recipe"},
    working_sound = {
      apparent_volume = 1.5,
      fade_in_ticks = 10,
      fade_out_ticks = 30,
      max_sounds_per_type = 3,
      sound = {
        {
          filename = "__base__/sound/nuclear-reactor-1.ogg",
          volume = 0.6
        },
        {
          filename = "__base__/sound/nuclear-reactor-2.ogg",
          volume = 0.6
        }
      }
    },
    --light = {intensity = 1, size = 8, shift = {0.0, 0.0}, color = {r = 0.6, g = 0.9, b = 1}}
  },
  {
    type = "reactor",
    name = data_util.mod_prefix .. "energy-transmitter-injector-reactor",
    subgroup = "composite-entity-parts",
    hidden = true,
    selectable_in_game = false,
    icon = "__space-exploration-graphics__/graphics/icons/energy-transmitter-injector.png",
    icon_size = 64,
    order = "a-c-b",
    allow_copy_paste = true,
    collision_box = data_util.auto_box(3, 3, 0.2),
    selection_box = data_util.auto_box(3, 3),
    collision_mask = {
      layers = {},
    },
    se_allow_in_space = true,
    heat_buffer =
    {
      max_temperature = 100000,
      specific_heat = "1GJ",
      max_transfer = "100GW",
      connections =
      {
      },
      heat_picture = blank,
      heat_glow = blank,
    },
    energy_source = {
      type = "electric",
      buffer_capacity = "10GJ",
      usage_priority = "secondary-input",
      input_flow_limit = "1GW",
    },
    neighbour_bonus = 0,
    energy_usage = "1MW",
    consumption = "1GW",
    working_light_picture = blank,
    animation = blank,
    corpse = "medium-remnants",
    flags = {
      "placeable-player",
      "player-creation",
    },
    max_health = 5000,
    impact_category = "metal-large",
    crafting_speed = 1,
    crafting_categories = {"fixed-recipe"},
    working_sound = {
      apparent_volume = 1.5,
      fade_in_ticks = 10,
      fade_out_ticks = 30,
      max_sounds_per_type = 3,
      sound = {
        {
          filename = "__base__/sound/nuclear-reactor-1.ogg",
          volume = 0.6
        },
        {
          filename = "__base__/sound/nuclear-reactor-2.ogg",
          volume = 0.6
        }
      }
    },
    --light = {intensity = 1, size = 8, shift = {0.0, 0.0}, color = {r = 0.6, g = 0.9, b = 1}}
  },
  {
    type = "reactor",
    name = data_util.mod_prefix .. "energy-receiver",
    icon = "__space-exploration-graphics__/graphics/icons/energy-receiver.png",
    icon_size = 64,
    minable = {mining_time = 0.2, result = data_util.mod_prefix .. "energy-receiver"},
    flags = {"placeable-neutral", "player-creation"},
    max_health = 1000,
    corpse = "medium-remnants",
    consumption = "1W",
    neighbour_bonus = 0,
    energy_source =
    {
      type = "void",
    },
    collision_box = data_util.auto_box(13, 13, 0.2),
    selection_box = data_util.auto_box(13, 13),
    --the collision box of a reactor is increased by this on the sides where it connects to another reactor:
    --neighbour_collision_increase = 0.25,
    lower_layer_picture =
    {
      filename = "__base__/graphics/entity/nuclear-reactor/reactor-pipes.png",
      width = 320,
      height = 316,
      scale = 0.5,
      shift = util.by_pixel(-1, -5),
      tint = pipe_tint,
    },
    heat_lower_layer_picture =
    {
      filename = "__base__/graphics/entity/nuclear-reactor/reactor-pipes-heated.png",
      width = 320,
      height = 316,
      scale = 0.5,
      shift = util.by_pixel(-0.5, -4.5),
      tint = glow_tint,
    },

    picture =
    {
      layers =
      {
        {
          filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/receiver.png",
          priority = "high",
          width = 832,
          height = 896,
          frame_count = 1,
          line_length = 1,
          shift = util.by_pixel(0, -16),
          animation_speed = 1,
          scale = 0.5,
        },
        {
          filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/receiver-mask.png",
          priority = "high",
          width = 832,
          height = 896,
          frame_count = 1,
          line_length = 1,
          shift = util.by_pixel(0, -16),
          animation_speed = 1,
          tint = {r=178, g=160, b=76},
          scale = 0.5,
        },
        {
          draw_as_shadow = true,
          filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/receiver-shadow.png",
          priority = "high",
          width = 1214,
          height = 820,
          frame_count = 1,
          line_length = 1,
          repeat_count = 1,
          shift = util.by_pixel(32*3+8, 4),
          scale = 0.5,
        },
      },
    },

    working_light_picture = blank,


    light = {intensity = 1, size = 18, shift = {0.0, 0.0}, color = {r = 1, g = 0.6, b = 0.1}},

    heat_buffer =
    {
      max_temperature = 10000,
      specific_heat = "500MJ",
      max_transfer = "1000GJ",
      connections =
      {
        {
          position = {5, 6},
          direction = defines.direction.south
        },
        {
          position = {6, 5},
          direction = defines.direction.east
        },
        {
          position = {5, -6},
          direction = defines.direction.north
        },
        {
          position = {6, -5},
          direction = defines.direction.east
        },
        {
          position = {-5, 6},
          direction = defines.direction.south
        },
        {
          position = {-6, 5},
          direction = defines.direction.west
        },
        {
          position = {-5, -6},
          direction = defines.direction.north
        },
        {
          position = {-6, -5},
          direction = defines.direction.west
        },
        {
          position = {0, -6},
          direction = defines.direction.north
        },
        {
          position = {6, 0},
          direction = defines.direction.east
        },
        {
          position = {0, 6},
          direction = defines.direction.south
        },
        {
          position = {-6, 0},
          direction = defines.direction.west
        },
      },

      heat_picture =
      {
        filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/receiver-glow.png",
        priority = "high",
        width = 832,
        height = 896,
        frame_count = 1,
        line_length = 1,
        shift = util.by_pixel(0, -16),
        animation_speed = 1,
        blend_mode = "additive",
        scale = 0.5,
      }
    },

    connection_patches_connected =
    {
      sheet =
      {
        filename = "__base__/graphics/entity/nuclear-reactor/reactor-connect-patches.png",
        width = 64,
        height = 64,
        variation_count = 12,
        scale = 0.5,
        tint = pipe_tint,
      }
    },

    connection_patches_disconnected =
    {
      sheet =
      {
        filename = "__base__/graphics/entity/nuclear-reactor/reactor-connect-patches.png",
        width = 64,
        height = 64,
        variation_count = 12,
        y = 64,
        scale = 0.5,
        tint = pipe_tint,
      }
    },

    connection_patches =
    {
      north =
      {
        filename = "__base__/graphics/entity/nuclear-reactor/connection-patch-north.png",
        width = 160,
        height = 15,
        shift = util.by_pixel(0, -72.5),
        tint = pipe_tint,
      },
      east =
      {
        filename = "__base__/graphics/entity/nuclear-reactor/connection-patch-east.png",
        width = 15,
        height = 160,
        shift = util.by_pixel(72.5, 0)
      },
      south =
      {
        filename = "__base__/graphics/entity/nuclear-reactor/connection-patch-south.png",
        width = 160,
        height = 15,
        shift = util.by_pixel(0, 72.5)
      },
      west =
      {
        filename = "__base__/graphics/entity/nuclear-reactor/connection-patch-west.png",
        width = 15,
        height = 160,
        shift = util.by_pixel(-72.5, 0)
      }
    },

    heat_connection_patches_connected =
    {
      sheet =
      {
        filename = "__base__/graphics/entity/nuclear-reactor/reactor-connect-patches-heated.png",
        width = 64,
        height = 64,
        variation_count = 12,
        scale = 0.5,
        tint = glow_tint,
      }
    },

    heat_connection_patches_disconnected =
    {
      sheet =
      {
        filename = "__base__/graphics/entity/nuclear-reactor/reactor-connect-patches-heated.png",
        width = 64,
        height = 64,
        variation_count = 12,
        y = 64,
        scale = 0.5,
        tint = glow_tint,
      }
    },

    impact_category = "metal-large",

    meltdown_action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
              repeat_count = 100,
              type = "create-trivial-smoke",
              smoke_name = "nuclear-smoke",
              offset_deviation = {{-1, -1}, {1, 1}},
              starting_frame = 3,
              starting_frame_deviation = 5,
              starting_frame_speed = 0,
              starting_frame_speed_deviation = 5,
              speed_from_center = 0.5
          },
          {
            type = "create-entity",
            entity_name = "explosion"
          },
          {
            type = "damage",
            damage = {amount = 400, type = "explosion"}
          },
          {
            type = "create-entity",
            entity_name = "small-scorchmark",
            check_buildability = true
          },
          {
            type = "nested-result",
            action =
            {
              type = "area",
              target_entities = false,
              trigger_from_target = true,
              repeat_count = 2000,
              radius = 35,
              action_delivery =
              {
                type = "projectile",
                projectile = "atomic-bomb-wave",
                starting_speed = 0.5
              }
            }
          }
        }
      }
    }
  },

  {
    type = "projectile",
    name = data_util.mod_prefix .. "energy-transmitter-beam",
    subgroup = "environmental-effects",
    hidden = true,
    direction_only = false,
    flags = { "not-on-map", "placeable-off-grid" },
    acceleration = 0,
    collision_mask = {
      layers = {},
      not_colliding_with_itself = true,
    },
    light = {intensity = 1, size = 8, shift = {0.0, 0.0}, color = {r = 0.6, g = 0.9, b = 1}},
    working_sound = {
      apparent_volume = 1.5,
      fade_in_ticks = 10,
      fade_out_ticks = 30,
      max_sounds_per_type = 3,
      sound = {
        {
          filename = "__base__/sound/nuclear-reactor-1.ogg",
          volume = 0.6
        },
        {
          filename = "__base__/sound/nuclear-reactor-2.ogg",
          volume = 0.6
        }
      }
    },
    animation = {
      layers = {
        {
          filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/energy-transmitter-light.png",
          priority = "high",
          width = 576,
          height = 640,
          frame_count = 1,
          line_length = 1,
          shift = util.by_pixel(0, -1 * 32 -9 ),
          animation_speed = 1,
          scale = 0.5*10/9,
          apply_runtime_tint = true, --"additive-soft"
        },
        {
          filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/energy-transmitter-skybeam.png",
          priority = "high",
          width = 316,
          height = 2392,
          frame_count = 1,
          line_length = 1,
          shift = util.by_pixel(0, -21 * 32 -11),
          animation_speed = 1,
          scale = 10/9/2,
          apply_runtime_tint = true,
          blend_mode = "additive-soft",
        },
      }
    },
  },

  {
    type = "projectile",
    name = data_util.mod_prefix .. "energy-receiver-beam",
    subgroup = "environmental-effects",
    hidden = true,
    direction_only = false,
    flags = { "not-on-map", "placeable-off-grid" },
    acceleration = 0,
    rotatable = false,
    collision_mask = {
      layers = {},
      not_colliding_with_itself = true,
    },
    light = {intensity = 1, size = 8, shift = {0.0, 0.0}, color = {r = 0.6, g = 0.9, b = 1}},
    working_sound = {
      apparent_volume = 1.5,
      fade_in_ticks = 10,
      fade_out_ticks = 30,
      max_sounds_per_type = 3,
      sound = {
        {
          filename = "__base__/sound/nuclear-reactor-1.ogg",
          volume = 0.6
        },
        {
          filename = "__base__/sound/nuclear-reactor-2.ogg",
          volume = 0.6
        }
      }
    },
    animation = {
      layers = {
        {
          filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/receiver-beam.png",
          priority = "high",
          width = 512,
          height = 1088,
          frame_count = 1,
          line_length = 1,
          shift = util.by_pixel(0, -3 * 32 -17),
          animation_speed = 1,
          scale = 0.5,
          apply_runtime_tint = true,
          blend_mode = "additive",
        },
      }
    },
  },

  {
    type = "projectile",
    name = data_util.mod_prefix .. "energy-glaive-beam",
    subgroup = "environmental-effects",
    hidden = true,
    direction_only = false,
    flags = { "not-on-map", "placeable-off-grid" },
    acceleration = 0,
    rotatable = false,
    collision_mask = {
      layers = {},
      not_colliding_with_itself = true,
    },
    light = {intensity = 1, size = 8, shift = {0.0, 0.0}, color = {r = 0.6, g = 0.9, b = 1}},
    working_sound = {
      apparent_volume = 1.5,
      fade_in_ticks = 10,
      fade_out_ticks = 30,
      max_sounds_per_type = 3,
      sound = {
        {
          filename = "__base__/sound/nuclear-reactor-1.ogg",
          volume = 0.6
        },
        {
          filename = "__base__/sound/nuclear-reactor-2.ogg",
          volume = 0.6
        }
      }
    },
    animation = blank
  },
  {
    type = "sprite",
    name = data_util.mod_prefix .. "energy-glaive-beam-sprite",
    filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/glaive-beam.png",
    priority = "high",
    width = 454,
    height = 1172,
    frame_count = 1,
    line_length = 1,
    shift = util.by_pixel(0, -12 * 32 -11),
    animation_speed = 1,
    scale = 1,
    apply_runtime_tint = true,
    blend_mode = "additive",
  },
  {
    type = "explosion",
    name = data_util.mod_prefix .. "energy-glaive-path-fx",
    subgroup = "environmental-effects",
    hidden = true,
    animations = blank,

    created_effect = {
      type = "direct",
      action_delivery = {
        type = "instant",
        target_effects = {
          {
            check_buildability = true,
            entity_name = "small-scorchmark",
            type = "create-entity"
          },
        },
      },
    },
    flags = { "not-on-map", "placeable-off-grid" },
  },

  {
    type = "explosion",
    name = data_util.mod_prefix .. "energy-glaive-damage-aoe",
    subgroup = "environmental-effects",
    hidden = true,
    localised_name = {"entity-name." .. data_util.mod_prefix .. "energy-beam"},
    animations = blank,

    created_effect = {
      type = "direct",
      action_delivery = {
        type = "instant",
        target_effects = {
          {
            type = "nested-result",
            action = {
              type = "area",
              radius = 2,
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 10, type = "laser" }},
                   { type = "damage", damage = { amount = 10, type = "explosion" }},
                 }
              },
            }
          },
          {
            type = "nested-result",
            action = {
              type = "area",
              radius = 4,
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 10, type = "laser" }},
                   { type = "damage", damage = { amount = 10, type = "fire" }},
                 }
              },
            }
          },
          {
            type = "nested-result",
            action = {
              type = "area",
              radius = 8,
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 5, type = "laser" }, apply_damage_to_trees = false},
                   { type = "damage", damage = { amount = 10, type = "fire" }, apply_damage_to_trees = false},
                 }
              },
            }
          },
          {
            type = "nested-result",
            action = {
              type = "area",
              radius = 12,
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 1, type = "laser" }, apply_damage_to_trees = false},
                   { type = "damage", damage = { amount = 5, type = "fire" }, apply_damage_to_trees = false},
                   {
                     type = "create-sticker",
                     sticker = "fire-sticker",
                   }
                 }
              },
            }
          },
          {
            type = "nested-result",
            action = {
              type = "area",
              radius = 16,
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 2, type = "fire" }, apply_damage_to_trees = false},
                 }
              },
            }
          },
          { -- tree fires
            type = "nested-result",
            action = {
              type = "area",
              radius = 8,
              trigger_target_mask = {"flammable"},
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 100, type = "fire" }},
                   { type = "create-entity", entity_name = data_util.mod_prefix .. "tree-fire-starter" }
                }
              },
            }
          },
        },
      },
    },
    flags = { "not-on-map", "placeable-off-grid"},
  },

  {
    type = "explosion",
    name = data_util.mod_prefix .. "energy-glaive-damage-aoe-large",
    subgroup = "environmental-effects",
    hidden = true,
    localised_name = {"entity-name." .. data_util.mod_prefix .. "energy-beam"},
    animations = blank,

    created_effect = {
      type = "direct",
      action_delivery = {
        type = "instant",
        target_effects = {
          {
            type = "nested-result",
            action = {
              type = "area",
              radius = 4,
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 10, type = "laser" }},
                   { type = "damage", damage = { amount = 10, type = "explosion" }},
                 }
              },
            }
          },
          {
            type = "nested-result",
            action = {
              type = "area",
              radius = 8,
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 10, type = "laser" }, apply_damage_to_trees = false},
                   { type = "damage", damage = { amount = 10, type = "fire" }, apply_damage_to_trees = false},
                 }
              },
            }
          },
          {
            type = "nested-result",
            action = {
              type = "area",
              radius = 16,
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 5, type = "laser" }, apply_damage_to_trees = false},
                   { type = "damage", damage = { amount = 10, type = "fire" }, apply_damage_to_trees = false},
                 }
              },
            }
          },
          {
            type = "nested-result",
            action = {
              type = "area",
              radius = 24,
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 1, type = "laser" }, apply_damage_to_trees = false},
                   { type = "damage", damage = { amount = 5, type = "fire" }, apply_damage_to_trees = false},
                   {
                     type = "create-sticker",
                     sticker = "fire-sticker",
                   }
                 }
              },
            }
          },
          {
            type = "nested-result",
            action = {
              type = "area",
              radius = 32,
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 2, type = "fire" }, apply_damage_to_trees = false},
                 }
              },
            }
          },
          { -- tree fires
            type = "nested-result",
            action = {
              type = "area",
              radius = 8,
              trigger_target_mask = {"flammable"},
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 100, type = "fire" }},
                   { type = "create-entity", entity_name = data_util.mod_prefix .. "tree-fire-starter" }
                }
              },
            }
          },

        },
      },
    },
    flags = { "not-on-map", "placeable-off-grid"},
  },

  {
    type = "explosion",
    name = data_util.mod_prefix .. "energy-glaive-damage-aoe-large-10",
    subgroup = "environmental-effects",
    hidden = true,
    localised_name = {"entity-name." .. data_util.mod_prefix .. "energy-beam"},
    animations = blank,

    created_effect = {
      type = "direct",
      action_delivery = {
        type = "instant",
        target_effects = {
          {
            type = "nested-result",
            action = {
              type = "area",
              radius = 4,
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 100, type = "laser" }},
                   { type = "damage", damage = { amount = 100, type = "explosion" }},
                 }
              },
            }
          },
          {
            type = "nested-result",
            action = {
              type = "area",
              radius = 8,
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 100, type = "laser" }, apply_damage_to_trees = false},
                   { type = "damage", damage = { amount = 100, type = "fire" }, apply_damage_to_trees = false},
                 }
              },
            }
          },
          {
            type = "nested-result",
            action = {
              type = "area",
              radius = 16,
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 50, type = "laser" }, apply_damage_to_trees = false},
                   { type = "damage", damage = { amount = 100, type = "fire" }, apply_damage_to_trees = false},
                 }
              },
            }
          },
          {
            type = "nested-result",
            action = {
              type = "area",
              radius = 24,
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 10, type = "laser" }, apply_damage_to_trees = false},
                   { type = "damage", damage = { amount = 50, type = "fire" }, apply_damage_to_trees = false},
                   {
                     type = "create-sticker",
                     sticker = "fire-sticker",
                   }
                 }
              },
            }
          },
          {
            type = "nested-result",
            action = {
              type = "area",
              radius = 32,
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 20, type = "fire" }, apply_damage_to_trees = false},
                 }
              },
            }
          },
          { -- tree fires
            type = "nested-result",
            action = {
              type = "area",
              radius = 8,
              trigger_target_mask = {"flammable"},
              action_delivery = {
                type = "instant",
                target_effects = {
                   { type = "damage", damage = { amount = 100, type = "fire" }},
                   { type = "create-entity", entity_name = data_util.mod_prefix .. "tree-fire-starter" }
                }
              },
            }
          },

        },
      },
    },
    flags = { "not-on-map", "placeable-off-grid"},
  },


  {
    type = "projectile",
    name = data_util.mod_prefix .. "energy-glaive-damage-projectile",
    subgroup = "environmental-effects",
    hidden = true,
    localised_name = {"entity-name." .. data_util.mod_prefix .. "energy-beam"},
    acceleration = -0.01,
    action = {
      action_delivery = {
        target_effects = {
          {
            type = "damage",
            damage = {
              amount = 10,
              type = "fire"
            },
          },
          {
            type = "damage",
            damage = {
              amount = 5,
              type = "laser"
            },
          },
          {
            type = "create-sticker",
            sticker = "fire-sticker",
          }
        },
        type = "instant"
      },
      type = "direct"
    },
    animation = {
      filename = "__base__/graphics/entity/bullet/bullet.png",
      frame_count = 1,
      height = 50,
      priority = "high",
      width = 3,
      scale = 1.5,
      tint = {r = 255/255, g = 100/255, b = 38/255},
      blend_mode = "additive"
    },
    collision_box = {
      {
        -0.25,
        -0.25
      },
      {
        0.25,
        0.25
      }
    },
    flags = {
      "not-on-map"
    },
  },

})




data:extend({
  {
      type = "technology",
      name = data_util.mod_prefix .. "energy-beam-defence",
      effects = {
       {  type = "unlock-recipe",  recipe = data_util.mod_prefix .. "energy-beam-defence" },
      },
      icon = "__space-exploration-graphics__/graphics/technology/energy-beam-defence.png",
      icon_size = 128,
      order = "e-a",
      prerequisites = {
        data_util.mod_prefix .. "meteor-defence",
      },
      unit = {
       count = 500,
       time = 30,
       ingredients = {
         { "automation-science-pack", 1 },
         { "logistic-science-pack", 1 },
         { "chemical-science-pack", 1 },
       }
      },
  },
  {
      type = "recipe",
      name = data_util.mod_prefix .. "energy-beam-defence",
      results = {
        {type = "item", name = data_util.mod_prefix .. "energy-beam-defence", amount = 1},
      },
      enabled = false,
      energy_required = 10,
      ingredients = {
        {type = "item", name = SEItemNames.get_glass_name(), amount = 200},
        {type = "item", name = "copper-plate", amount = 200},
        {type = "item", name = "steel-plate", amount = 200},
        {type = "item", name = "concrete", amount = 200},
        {type = "item", name = "battery", amount = 100},
        {type = "item", name = "processing-unit", amount = 100},
      },
      requester_paste_multiplier = 1,
      always_show_made_in = false,
  },
  {
      type = "item",
      name = data_util.mod_prefix .. "energy-beam-defence",
      icon = "__space-exploration-graphics__/graphics/icons/energy-beam-defence.png",
      icon_size = 64,
      order = "c-a",
      subgroup = "surface-defense",
      stack_size = 1,
      place_result = data_util.mod_prefix .. "energy-beam-defence",
  },
  {
    type = "electric-energy-interface",
    name = data_util.mod_prefix .. "energy-beam-defence",
    subgroup = "surface-defense",
    icon = "__space-exploration-graphics__/graphics/icons/energy-beam-defence.png",
    icon_size = 64,
    minable = {mining_time = 1, result = data_util.mod_prefix .. "energy-beam-defence"},
    order = "e-a",
    allow_copy_paste = true,
    picture =
    {
      layers =
      {
        {
          filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/receiver.png",
          priority = "high",
          width = 832,
          height = 896,
          frame_count = 1,
          line_length = 1,
          shift = util.by_pixel(0, -16),
          animation_speed = 1,
          scale = 0.5,
        },
        {
          filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/receiver-mask.png",
          priority = "high",
          width = 832,
          height = 896,
          frame_count = 1,
          line_length = 1,
          shift = util.by_pixel(0, -16),
          animation_speed = 1,
          tint = {r=58, g=89, b=35},
          scale = 0.5,
        },
        {
          draw_as_shadow = true,
          filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/receiver-shadow.png",
          priority = "high",
          width = 1214,
          height = 820,
          frame_count = 1,
          line_length = 1,
          repeat_count = 1,
          shift = util.by_pixel(32*3+8, 4),
          scale = 0.5,
        },
      },
    },
    collision_box = data_util.auto_box(13, 13, 0.2),
    selection_box = data_util.auto_box(13, 13),
    selectable = false,
    continuous_animation = true,
    corpse = "medium-remnants",
    energy_source = {
      buffer_capacity = "1GJ",
      input_flow_limit = "50GW",
      output_flow_limit = "0kW",
      type = "electric",
      usage_priority = "primary-input"
    },
    energy_production = "0kW",
    energy_usage = "10MW", -- platform + 1x per lock + 1x for final energy spike final activation.
    --energy_usage = "60GW", -- platform + 1x per lock + 1x for final energy spike final activation.
    flags = {
      "placeable-player",
      "player-creation",
      "not-rotatable"
    },
    hidden = true,
    max_health = 5000,
    open_sound = data_util.machine_open_sound,
    close_sound = data_util.machine_close_sound,
    impact_category = "metal-large",
    working_sound = {
      apparent_volume = 1.5,
      fade_in_ticks = 10,
      fade_out_ticks = 30,
      max_sounds_per_type = 3,
      sound = {
        {
          filename = "__base__/sound/nuclear-reactor-1.ogg",
          volume = 0.6
        },
        {
          filename = "__base__/sound/nuclear-reactor-2.ogg",
          volume = 0.6
        }
      }
    },
    --light = {intensity = 1, size = 8, shift = {0.0, 0.0}, color = {r = 0.6, g = 0.9, b = 1}}
  },
  {
    type = "sprite",
    name = data_util.mod_prefix .. "energy-beam-defence-glow",
    filename = "__space-exploration-graphics-3__/graphics/entity/energy-transmitter/defence-glow.png",
    priority = "high",
    width = 832,
    height = 896,
    frame_count = 1,
    line_length = 1,
    shift = util.by_pixel(0, -16),
    animation_speed = 1,
    blend_mode = "additive",
    apply_runtime_tint = true,
    scale = 0.5,
  },
})
