local data_util = require("data_util")
local sounds = require("__base__/prototypes/entity/sounds")
--[[
copy of shield projector, SW, SE, NE
copy of laser turret NW
interface addon graphic
interface addon display animation.
]]
local blank_image = {
    filename = "__space-exploration-graphics__/graphics/blank.png",
    width = 1,
    height = 1,
    frame_count = 1,
    line_length = 1,
    shift = { 0, 0 },
}
local connection_point = {
  wire = { red = {-1 -8/32, 2 +20/32},   green = {-1 -2/32, 2 +20/32}, },
  shadow = { red = {2 -8/32, 5}, green = {2 -2/32, 5}, },
}

function make_spidertron_leg(spidertron_name, scale, leg_thickness, movement_speed, number, leg_resistances)
  return
  {
    type = "spider-leg",
    name = spidertron_name .. "-leg-" .. number,
    hidden = true,
    localised_name = {"entity-name.spidertron-leg"},
    collision_box = {{-0.05, -0.05}, {0.05, 0.05}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    icon = "__base__/graphics/icons/spidertron.png",
    walking_sound_volume_modifier = 0.6,
    target_position_randomisation_distance = 0.25 * scale,
    minimal_step_size = 1 * scale,
    working_sound =
    {
      match_progress_to_activity = true,
      sound = sounds.spidertron_leg,
      audible_distance_modifier = 0.5
    },
    stretch_force_scalar = 2.5 / (3.5 * scale), -- longer legs, weaker stretch force
    knee_height = 2.5 * scale,
    knee_distance_factor = 0.4,
    initial_movement_speed = 0.06 * movement_speed,
    movement_acceleration = 0.03 * movement_speed,
    max_health = 100,
    resistances = util.table.deepcopy(leg_resistances),
    base_position_selection_distance = 6 * scale,
    movement_based_position_selection_distance = 4 * scale,
    selectable_in_game = false,
    alert_when_damaged = false,
    graphics_set = create_spidertron_leg_graphics_set(scale * leg_thickness, number)
  }
end

data:extend({
  {
    type = "lamp",
    name = data_util.mod_prefix.. "interburbulator-control",
    subgroup = "interburbulator-parts",
    hidden = true,
    icon = "__space-exploration-graphics__/graphics/icons/shield-projector.png",
    icon_size = 64,
    flags = {"placeable-player", "player-creation", "placeable-off-grid", "not-deconstructable", "not-blueprintable"},
    order = "y",
    energy_source = {type = "void"},
    max_health = 10000,
    healing_per_tick = 10000,
    collision_box = data_util.auto_box(2, 2, 0.1),
    selection_box = data_util.auto_box(2, 2),
    collision_mask = {
      layers = {},
      not_colliding_with_itself = true,
    },
    energy_usage_per_tick = "1J",
    always_on = true,
    picture_off = blank_image,
    picture_on = {
      layers = {
        {
          filename = "__base__/graphics/entity/steel-furnace/steel-furnace.png",
          frame_count = 1,
          height = 174,
          priority = "high",
          scale = 0.5,
          shift = {
            -0.0390625,
            0.0625
          },
          width = 171
        },
        {
          draw_as_shadow = true,
          filename = "__base__/graphics/entity/steel-furnace/steel-furnace-shadow.png",
          frame_count = 1,
          height = 85,
          priority = "high",
          scale = 0.5,
          shift = {
            1.2265625,
            0.3515625
          },
          width = 277
        }
      }
    }
  },
  {
    type = "simple-entity",
    name = data_util.mod_prefix.. "interburbulator-interface",
    subgroup = "interburbulator-parts",
    hidden = true,
    icon = "__space-exploration-graphics__/graphics/icons/shield-projector.png",
    icon_size = 64,
    flags = {"placeable-player", "player-creation", "placeable-off-grid", "not-deconstructable", "not-blueprintable"},
    order = "y",
    max_health = 10000,
    healing_per_tick = 10000,
    collision_box = data_util.auto_box(1, 1, 0.1),
    selection_box = data_util.auto_box(1, 1),
    collision_mask = {
      layers = {},
      not_colliding_with_itself = true,
    },
    selectable_in_game = false,
    animations = {
      layers = {
        {
          filename = "__space-exploration-graphics__/graphics/entity/robot-faction/interface-addon.png",
          frame_count = 1,
          width = 72,
          height = 82,
          line_length = 1,
          repeat_count = 3,
          animation_speed = 0.1,
          shift = { 0,0},
          scale = 0.5
        },
        {
          filename = "__space-exploration-graphics__/graphics/entity/robot-faction/interface-addon-display.png",
          frame_count = 3,
          width = 78/3,
          height = 42,
          line_length = 3,
          animation_speed = 0.1,
          shift = { 0,-0.1},
          scale = 0.5,
          blend_mode = "additive"
        },
      }
    }
  },
  {
      type = "constant-combinator",
      name = data_util.mod_prefix.. "interburbulator-projector",
      subgroup = "interburbulator-parts",
      hidden = true,
      icon = "__space-exploration-graphics__/graphics/icons/shield-projector.png",
      icon_size = 64,
      flags = {"placeable-player", "player-creation", "placeable-off-grid", "not-deconstructable", "not-blueprintable"},
      order = "y",
      max_health = 10000,
      healing_per_tick = 10000,
      collision_box = data_util.auto_box(2, 2, 0.1),
      selection_box = data_util.auto_box(2, 2),
      collision_mask = {
        layers = {},
        not_colliding_with_itself = true,
      },
      scale_info_icons = false,
      selectable_in_game = true,
      item_slot_count = 0,
      sprites =
      {
          north = {
            layers = {
              {
                filename = "__shield-projector__/graphics/entity/shield-projector/shield-projector.png",
                frame_count = 1,
                x = 196 * 1,
                width = 196,
                height = 284,
                line_length = 1,
                shift = { 1/32, -24/32 },
                scale = 0.5 * 2/3
              },
              {
                frame_count = 1,
                draw_as_shadow = true,
                filename = "__shield-projector__/graphics/entity/shield-projector/shield-projector-shadow.png",
                x = 412 * 1,
                width = 412,
                height = 249,
                line_length = 1,
                shift = { (1 + 22/32) * 2/3, (-8/32) * 2/3},
                scale = 0.5 * 2/3
              },
            }
          },
          east = {
            layers = {
              {
                filename = "__shield-projector__/graphics/entity/shield-projector/shield-projector.png",
                frame_count = 1,
                x = 196 * 3,
                width = 196,
                height = 284,
                line_length = 1,
                shift = { 1/32, -24/32 },
                scale = 0.5 * 2/3
              },
              {
                frame_count = 1,
                draw_as_shadow = true,
                filename = "__shield-projector__/graphics/entity/shield-projector/shield-projector-shadow.png",
                x = 412 * 3,
                width = 412,
                height = 249,
                line_length = 1,
                shift = { (1 + 22/32) * 2/3, (-8/32) * 2/3},
                scale = 0.5 * 2/3
              },
            }
          },
          south = {
            layers = {
              {
                filename = "__shield-projector__/graphics/entity/shield-projector/shield-projector.png",
                frame_count = 1,
                x = 196 * 5,
                width = 196,
                height = 284,
                line_length = 1,
                shift = { 1/32, -24/32 },
                scale = 0.5 * 2/3
              },
              {
                frame_count = 1,
                draw_as_shadow = true,
                filename = "__shield-projector__/graphics/entity/shield-projector/shield-projector-shadow.png",
                x = 412 * 1,
                y = 249 * 1,
                width = 412,
                height = 249,
                line_length = 1,
                shift = { (1 + 22/32) * 2/3, (-8/32) * 2/3},
                scale = 0.5 * 2/3
              },
            }
          },
          west = {
            layers = {
              {
                filename = "__shield-projector__/graphics/entity/shield-projector/shield-projector.png",
                frame_count = 1,
                x = 196 * 7,
                width = 196,
                height = 284,
                line_length = 1,
                shift = { 1/32, -24/32 },
                scale = 0.5 * 2/3
              },
              {
                frame_count = 1,
                draw_as_shadow = true,
                filename = "__shield-projector__/graphics/entity/shield-projector/shield-projector-shadow.png",
                x = 412 * 3,
                y = 249 * 1,
                width = 412,
                height = 249,
                line_length = 1,
                shift = { (1 + 22/32) * 2/3, (-8/32) * 2/3},
                scale = 0.5 * 2/3
              },
            }
          }
      },
      activity_led_sprites =
      {
          north = blank_image,
          east = blank_image,
          south = blank_image,
          west = blank_image
      },
      activity_led_light =
      {
          intensity = 0.8,
          size = 1,
      },
      activity_led_light_offsets =
      {
          {0, 0},
          {0, 0},
          {0, 0},
          {0, 0}
      },
      circuit_wire_connection_points =
      {
          connection_point,  connection_point,  connection_point,  connection_point,
      },
      circuit_wire_max_distance = 0
  },
  {
    type = "sprite",
    name = data_util.mod_prefix.."interburbulator-grid",
    filename = "__space-exploration-graphics__/graphics/entity/robot-faction/interburbulator-grid.png",
    width = 832,
    height = 864,
    shift = { 0,-0.5 },
    blend_mode = "additive",
    scale = 1
  },
  {
    type = "sprite",
    name = data_util.mod_prefix.."interburbulator-light",
    filename = "__space-exploration-graphics__/graphics/entity/robot-faction/interburbulator-light.png",
    width = 832/2,
    height = 864/2,
    shift = { 0,-0.5 },
    blend_mode = "additive",
    scale = 2
  },
})

local spider_name = data_util.mod_prefix .. "burbulator"
local scale = 1
local leg_scale = scale * 1
local leg_thickness = 1
local leg_movement_speed = 1
local body_height = 1.5 * scale * leg_scale
local spidertron_resistances =
{
  {
    type = "fire",
    decrease = 15,
    percent = 60
  },
  {
    type = "physical",
    decrease = 15,
    percent = 60
  },
  {
    type = "impact",
    decrease = 50,
    percent = 80
  },
  {
    type = "explosion",
    decrease = 20,
    percent = 75
  },
  {
    type = "acid",
    decrease = 0,
    percent = 70
  },
  {
    type = "laser",
    decrease = 0,
    percent = 70
  },
  {
    type = "electric",
    decrease = 0,
    percent = 70
  }
}
local spidertron_leg_resistances = util.table.deepcopy(spidertron_resistances)
spidertron_leg_resistances[4] = { type = "explosion", percent = 100 }

data:extend({
  {
    type = "spider-vehicle",
    name = spider_name,
    subgroup = "creatures",
    hidden = true,
    collision_box = {{-1 * scale, -1 * scale}, {1 * scale, 1 * scale}},
    sticker_box = {{-1.5 * scale, -1.5 * scale}, {1.5 * scale, 1.5 * scale}},
    selection_box = {{-1 * scale, -1 * scale}, {1 * scale, 1 * scale}},
    drawing_box_vertical_extension = 3 * scale,
    icon = "__base__/graphics/icons/spidertron.png",
    --factoriopedia_simulation = arguments.factoriopedia_simulation,
    --mined_sound = sounds.deconstruct_large(0.8),
    open_sound = { filename = "__base__/sound/spidertron/spidertron-door-open.ogg", volume= 0.45 },
    close_sound = { filename = "__base__/sound/spidertron/spidertron-door-close.ogg", volume = 0.4 },
    working_sound =
    {
      sound = { filename = "__base__/sound/spidertron/spidertron-vox.ogg", volume = 0.35 },
      activate_sound = { filename = "__base__/sound/spidertron/spidertron-activate.ogg", volume = 0.5 },
      deactivate_sound = { filename = "__base__/sound/spidertron/spidertron-deactivate.ogg", volume = 0.5 },
      match_speed_to_activity = true,
      activity_to_speed_modifiers =
      {
        multiplier = 6.0,
        minimum = 1.0,
        offset = 0.93333333333
      }
    },
    weight = 1,
    braking_force = 1,
    friction_force = 1,
    flags = {"placeable-neutral", "player-creation", "placeable-off-grid"},
    --minable = {mining_time = 1, result = data_util.mod_prefix .. "burbulator"},
    max_health = 30000000,
    healing_per_tick = 300000,
    resistances = util.table.deepcopy(spidertron_resistances),
    minimap_representation =
    {
      filename = "__base__/graphics/entity/spidertron/spidertron-map.png",
      flags = {"icon"},
      size = {128, 128},
      scale = 0.5
    },
    selected_minimap_representation =
    {
      filename = "__base__/graphics/entity/spidertron/spidertron-map-selected.png",
      flags = {"icon"},
      size = {128, 128},
      scale = 0.5
    },
    corpse = "spidertron-remnants",
    dying_explosion = "spidertron-explosion",
    energy_per_hit_point = 1,
    guns = { "spidertron-rocket-launcher-1", "spidertron-rocket-launcher-2", "spidertron-rocket-launcher-3", "spidertron-rocket-launcher-4" },
    inventory_size = 80,
    equipment_grid = "spidertron-equipment-grid",
    trash_inventory_size = 20,
    height = body_height,
    alert_icon_shift = { 0, -body_height },
    torso_rotation_speed = 0.01,
    chunk_exploration_radius = 3,
    selection_priority = 60,
    graphics_set = spidertron_torso_graphics_set(scale),
    energy_source =
    {
      type = "void"
    },
    movement_energy_consumption = "250kW",
    automatic_weapon_cycling = true,
    chain_shooting_cooldown_modifier = 0.5,
    spider_engine =
    {
      legs =
      {
        { -- 1
          leg = spider_name .. "-leg-1",
          mount_position = util.by_pixel(15  * scale, -22 * scale),
          ground_position = {2.25  * leg_scale, -2.5  * leg_scale},
          walking_group = 1,
          leg_hit_the_ground_trigger = get_leg_hit_the_ground_trigger()
        },--[[
        { -- 2
          leg = spider_name .. "-leg-2",
          mount_position = util.by_pixel(23  * scale, -10  * scale),
          ground_position = {3  * leg_scale, -1  * leg_scale},
          walking_group = 2,
          leg_hit_the_ground_trigger = get_leg_hit_the_ground_trigger()
        },]]
        { -- 3
          leg = spider_name .. "-leg-3",
          mount_position = util.by_pixel(25  * scale, 4  * scale),
          ground_position = {3  * leg_scale, 1  * leg_scale},
          walking_group = 3,
          leg_hit_the_ground_trigger = get_leg_hit_the_ground_trigger()
        },
        { -- 4
          leg = spider_name .. "-leg-4",
          mount_position = util.by_pixel(15  * scale, 17  * scale),
          ground_position = {2.25  * leg_scale, 2.5  * leg_scale},
          walking_group = 2,
          leg_hit_the_ground_trigger = get_leg_hit_the_ground_trigger()
        },
        { -- 5
          leg = spider_name .. "-leg-5",
          mount_position = util.by_pixel(-15 * scale, -22 * scale),
          ground_position = {-2.25 * leg_scale, -2.5 * leg_scale},
          walking_group = 3,
          leg_hit_the_ground_trigger = get_leg_hit_the_ground_trigger()
        },--[[
        { -- 6
          leg = spider_name .. "-leg-6",
          mount_position = util.by_pixel(-23 * scale, -10 * scale),
          ground_position = {-3 * leg_scale, -1 * leg_scale},
          walking_group = 1,
          leg_hit_the_ground_trigger = get_leg_hit_the_ground_trigger()
        },]]
        { -- 7
          leg = spider_name .. "-leg-7",
          mount_position = util.by_pixel(-25 * scale, 4 * scale),
          ground_position = {-3 * leg_scale, 1 * leg_scale},
          walking_group = 2,
          leg_hit_the_ground_trigger = get_leg_hit_the_ground_trigger()
        },
        { -- 8
          leg = spider_name .. "-leg-8",
          mount_position = util.by_pixel(-15 * scale, 17 * scale),
          ground_position = {-2.25 * leg_scale, 2.5 * leg_scale},
          walking_group = 1,
          leg_hit_the_ground_trigger = get_leg_hit_the_ground_trigger()
        }
      },
    },
    is_military_target = true,
    allow_remote_driving = true,
  },
  make_spidertron_leg(spider_name, leg_scale, leg_thickness, leg_movement_speed, 1, spidertron_leg_resistances),
  --make_spidertron_leg(spider_name, leg_scale, leg_thickness, leg_movement_speed, 2, spidertron_leg_resistances),
  make_spidertron_leg(spider_name, leg_scale, leg_thickness, leg_movement_speed, 3, spidertron_leg_resistances),
  make_spidertron_leg(spider_name, leg_scale, leg_thickness, leg_movement_speed, 4, spidertron_leg_resistances),
  make_spidertron_leg(spider_name, leg_scale, leg_thickness, leg_movement_speed, 5, spidertron_leg_resistances),
  --make_spidertron_leg(spider_name, leg_scale, leg_thickness, leg_movement_speed, 6, spidertron_leg_resistances),
  make_spidertron_leg(spider_name, leg_scale, leg_thickness, leg_movement_speed, 7, spidertron_leg_resistances),
  make_spidertron_leg(spider_name, leg_scale, leg_thickness, leg_movement_speed, 8, spidertron_leg_resistances),
})
