local data_util = require("data_util")
--[[
meteors
projectile falls from the sky
shadow moves sideways
projectile causes explosion and spawns a rock
]]--
local meteors = {
  ["meteor-01"] = {209, 138},
  ["meteor-02"] = {165,129},
  ["meteor-03"] = {151,139},
  ["meteor-04"] = {216,110},
  ["meteor-05"] = {154,147},
  ["meteor-06"] = {154,132},
  ["meteor-07"] = {193,120},
  ["meteor-08"] = {136,117},
  ["meteor-09"] = {157,115},
  ["meteor-10"] = {198,153},
  ["meteor-11"] = {190,115},
  ["meteor-12"] = {229,126},
  ["meteor-13"] = {151,125},
  ["meteor-14"] = {137,117},
  ["meteor-15"] = {201,141},
  ["meteor-16"] = {209,154},
}

local tint = {r = 0.5, g = 0.5, b = 0.5}

for name, meteor in pairs(meteors) do
  local width = meteor[1]
  local height = meteor[2]
  local shadow_width = meteor[1]
  local shadow_height = meteor[2]
  local scale = 0.75
  local picture_offset = width / 32 / 16
  data:extend({
    { -- Triggers
      type = "explosion",
      name = data_util.mod_prefix .. "trigger-movable-" .. name .. "-debris",
      subgroup = "environmental-effects",
      hidden = true,
      icons = {
        {
          icon = "__space-exploration-graphics__/graphics/icons/astronomic/asteroid-belt.png",
          icon_size = 64,
          scale = 0.5,
        },
      },
      animations = {
        {
          direction_count = 1,
          filename = "__space-exploration-graphics__/graphics/blank.png",
          frame_count = 1,
          height = 1,
          line_length = 1,
          width = 1
        }
      },
      flags = {
        "not-on-map"
      },
    },
    { -- Falling meteor projectiles
      type = "projectile",
      name = data_util.mod_prefix.."falling-" .. name,
      localised_name = {"entity-name.meteor"},
      subgroup = "environmental-effects",
      hidden = true,
      acceleration = 0,
      rotatable = false,
      icons = {
        {
          icon = "__space-exploration-graphics__/graphics/icons/astronomic/asteroid-belt.png",
          icon_size = 64,
          scale = 0.5,
        },
      },
      animation = {
        filename = "__space-exploration-graphics__/graphics/entity/meteor/"..name..".png",
        frame_count = 1,
        width = width,
        height = height,
        line_length = 1,
        priority = "high",
        shift = { picture_offset, 0 },
        tint=tint,
        scale = scale,
      },
      action = {
        action_delivery = {
          target_effects = {
            {
              action = {
                action_delivery = {
                  target_effects = {
                    {
                      damage = {
                        amount = 20,
                        type = "meteor"
                      },
                      type = "damage"
                    },
                  },
                  type = "instant"
                },
                radius = 10,
                type = "area"
              },
              type = "nested-result"
            },
            {
              action = {
                action_delivery = {
                  target_effects = {
                    {
                      damage = {
                        amount = 100,
                        type = "meteor"
                      },
                      type = "damage"
                    },
                  },
                  type = "instant"
                },
                radius = 4,
                type = "area"
              },
              type = "nested-result"
            },
            {
              action = {
                action_delivery = {
                  target_effects = {
                    {
                      damage = {
                        amount = 200,
                        type = "meteor"
                      },
                      type = "damage"
                    },
                  },
                  type = "instant"
                },
                radius = 2,
                type = "area"
              },
              type = "nested-result"
            },
            {
              action = {
                action_delivery = {
                  target_effects = {
                    {
                      damage = {
                        amount = 10000,
                        type = "meteor"
                      },
                      type = "damage"
                    },
                  },
                  type = "instant"
                },
                radius = 1,
                type = "area"
              },
              type = "nested-result"
            },
            {
              type = "create-entity",
              entity_name = data_util.mod_prefix .. "trigger-movable-" .. name .. "-debris",
              trigger_created_entity = true,
            },
          },
          type = "instant"
        },
        type = "direct"
      },
      flags = { "not-on-map" },
      light = { intensity = 1, size = 5, color={r=1,g=0.7,b=0.3}},
      smoke = {
        {
          deviation = {
            0.15,
            0.15
          },
          frequency = 1,
          --name = "smoke-fast",
          --name = "smoke-explosion-particle",
          name = "soft-fire-smoke", -- lasts longer
          position = {0,0},
          -- slow_down_factor = 1,
          starting_frame = 3,
          starting_frame_deviation = 5,
          -- starting_frame_speed = 0,
          -- starting_frame_speed_deviation = 5
        }
      },
    },
    { -- Meteor shadows
      type = "projectile",
      name = data_util.mod_prefix.."shadow-" .. name,
      hidden = true,
      acceleration = 0,
      rotatable = false,
      animation = {
        draw_as_shadow = true,
        filename = "__space-exploration-graphics__/graphics/entity/meteor/shadows/"..name..".png",
        frame_count = 1,
        width = shadow_width,
        height = shadow_height,
        line_length = 1,
        priority = "high",
        shift = { picture_offset, 0 },
        tint=tint,
        scale = scale,
      },
      flags = { "not-on-map" },
    },
    { -- Meteor remnants
      type = "simple-entity",
      name = data_util.mod_prefix.."static-"..name,
      icon = "__space-exploration-graphics__/graphics/icons/astronomic/asteroid-belt.png",
      icon_size = 64,
      flags = {"placeable-neutral", "placeable-off-grid", "not-on-map"},
      subgroup = "grass",
      order = "d[remnants]-d[ship-wreck]-c[small]-a",
      max_health = 1000,
      minable = {
        mining_time = 1,
        results={
          {type = "item", name = "stone", amount_min = 9, amount_max = 31},
          {type = "item", name = "iron-ore", amount_min = 0, amount_max = 30},
          {type = "item", name = "copper-ore", amount_min = 0, amount_max = 30},
          {type = "item", name = "uranium-ore", amount_min = 0, amount_max = 30, probability = 0.1},
        }
      },
      factoriopedia_alternative = (name ~= "meteor-01") and "se-static-meteor-01" or nil,
      resistances =
      {
        { type = "fire", percent = 100 },
        { type = "poison", percent = 100 }
      },
      collision_box = {{-1, -1}, {1, 1}},
      collision_mask = {
        layers = {
          item = true,
          object = true,
          player = true,
          water_tile = true,
          train = true,
        },
      },
      selection_box = {{-1, -1}, {1, 1}},
      selection_priority = 50, -- need to be at least above resources
      count_as_rock_for_filtered_deconstruction = true,
      picture =
      {
        layers = {
          {
            filename = "__space-exploration-graphics__/graphics/entity/meteor/"..name..".png",
            width = width,
            height = height,
            shift = { picture_offset, 0 },
            tint=tint,
            scale = scale,
          },
          {
            draw_as_shadow = true,
            filename = "__space-exploration-graphics__/graphics/entity/meteor/shadows/"..name..".png",
            width = shadow_width,
            height = shadow_height,
            shift = { picture_offset, 0 },
            tint=tint,
            scale = scale,
          }
        }
      },
      mined_sound = { filename = "__base__/sound/deconstruct-bricks.ogg" },
      render_layer = "object",
      localised_name = {"entity-name.meteorite"}
    },
  })
end

data:extend({
  {
    animation = {
      direction_count = 1,
      frame_count = 1,
      filename = "__base__/graphics/entity/scorchmark/small-scorchmark.png",
      width = 256,
      height = 182,
      line_length = 4,
      shift = util.by_pixel(0, 2),
      variation_count = 4,
      scale = 0.5,
    },
    collision_box = {
      {
        -1.5,
        -1.5
      },
      {
        1.5,
        1.5
      }
    },
    collision_mask = {
      layers = {
        doodad = true,
      },
      not_colliding_with_itself = true,
    },
    final_render_layer = "ground-patch-higher2",
    flags = {
      "placeable-neutral",
      "not-on-map",
      "placeable-off-grid"
    },
    ground_patch =
    {
      sheet =
      {
        filename = "__base__/graphics/entity/scorchmark/small-scorchmark.png",
        width = 256,
        height = 182,
        line_length = 4,
        shift = util.by_pixel(0, 2),
        variation_count = 4,
        scale = 0.5,
      }
    },
    ground_patch_higher =
    {
      sheet =
      {
        filename = "__base__/graphics/entity/scorchmark/small-scorchmark-top.png",
        width = 68,
        height = 54,
        line_length = 4,
        shift = util.by_pixel(0, -2),
        variation_count = 4,
        scale = 0.5,
      }
    },
    icon = "__base__/graphics/icons/small-scorchmark.png",
    icon_size = 64,
    name = data_util.mod_prefix.."meteor-scorchmark",
    localised_name = {"space-exploration."..data_util.mod_prefix.."meteor-scorchmark"},
    order = "d[remnants]-b[scorchmark]-a[small]",
    remove_on_entity_placement = false,
    remove_on_tile_placement = true,
    selectable_in_game = false,
    hidden = true,
    selection_box = {
      {
        -1,
        -1
      },
      {
        1,
        1
      }
    },
    subgroup = "remnants",
    time_before_removed = 36000,
    type = "corpse"
  },

})
