local data_util = require("data_util")

local target_animation_speed = 1
local crafting_speed = 1
local module_slots = 4
local animation_speed = (target_animation_speed / crafting_speed) / (1 + data_util.speed_module_3_speed_bonus * module_slots)

data:extend({
  {
    type = "assembling-machine",
    name = data_util.mod_prefix .. "space-electromagnetics-laboratory",
    icon = "__space-exploration-graphics__/graphics/icons/electromagnetics-laboratory.png",
    icon_size = 64,
    flags = {"placeable-neutral","placeable-player", "player-creation"},
    minable = {mining_time = 0.2, result = data_util.mod_prefix .. "space-electromagnetics-laboratory"},
    max_health = 700,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    alert_icon_shift = util.by_pixel(0, -12),
    collision_box = {{-3.2, -3.2}, {3.2, 3.2}},
    selection_box = {{-3.5, -3.5}, {3.5, 3.5}},
    drawing_box_vertical_extension = 2,
    circuit_connector = circuit_connector_definitions.create_vector
    (
      universal_connector_template,
      {
        { variation = 18, main_offset = {2.5, 2.5}, shadow_offset = {2.5, 2.5}, show_shadow = true },
        { variation = 18, main_offset = {2.5, 2.5}, shadow_offset = {2.5, 2.5}, show_shadow = true },
        { variation = 18, main_offset = {2.5, 2.5}, shadow_offset = {2.5, 2.5}, show_shadow = true },
        { variation = 18, main_offset = {2.5, 2.5}, shadow_offset = {2.5, 2.5}, show_shadow = true },
      }
    ),
    circuit_wire_max_distance = default_circuit_wire_max_distance,
    resistances =
    {
      {
        type = "electric",
        percent = 70
      }
    },
    fluid_boxes = {
      {
        production_type = "input",
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = {{ flow_direction="input", position = {0, -3}, direction = defines.direction.north }},
        secondary_draw_orders = { north = -1 }
      },
      {
        production_type = "input",
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = {{ flow_direction="input", position = {-3, 0}, direction = defines.direction.west }},
        secondary_draw_orders = { north = -1 }
      },
      {
        production_type = "output",
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = {{ flow_direction="output", position = {0, 3}, direction = defines.direction.south }},
        secondary_draw_orders = { north = -1 }
      },
      {
        production_type = "output",
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = {{ flow_direction="output", position = {3, 0}, direction = defines.direction.east }},
        secondary_draw_orders = { north = -1 }
      },
    },
    open_sound = data_util.machine_open_sound,
    close_sound = data_util.machine_close_sound,
    impact_category = "metal-large",
    working_sound =
    {
      sound = {
        {
          filename = "__base__/sound/lab.ogg",
          volume = 0.8
        },
      },
      apparent_volume = 1.5,
    },
    collision_mask = {
      layers = {
        water_tile = true,
        ground_tile = true,
        item = true,
        object = true,
        player = true,
        [spaceship_collision_layer] = true,
      },
    },
    graphics_set = {
      idle_animation =
      {
        layers =
        {
          {
            filename = "__space-exploration-graphics-3__/graphics/entity/electromagnetics-laboratory/base.png",
            priority = "high",
            width = 448,
            height = 576,
            frame_count = 1,
            line_length = 1,
            repeat_count = 64,
            shift = util.by_pixel(0, -16),
            animation_speed = animation_speed,
            scale = 0.5,
          },
          {
            draw_as_shadow = true,
            filename = "__space-exploration-graphics-3__/graphics/entity/electromagnetics-laboratory/shadow.png",
            priority = "high",
            width = 566,
            height = 400,
            frame_count = 1,
            line_length = 1,
            repeat_count = 64,
            shift = util.by_pixel(35, 20),
            animation_speed = animation_speed,
            scale = 0.5,
          },
        },
      },
      animation =
      {
        layers =
        {
          {
            filename = "__space-exploration-graphics-3__/graphics/entity/electromagnetics-laboratory/base.png",
            priority = "high",
            width = 448,
            height = 576,
            frame_count = 1,
            line_length = 1,
            repeat_count = 64,
            shift = util.by_pixel(0, -16),
            animation_speed = animation_speed,
            scale = 0.5,
          },
          {
            priority = "high",
            width = 1392/4,
            height = 1880/5,
            frame_count = 64,
            shift = util.by_pixel(0.5, -17),
            animation_speed = animation_speed,
            scale = 0.5,
            stripes =
            {
              {
               filename = "__space-exploration-graphics-3__/graphics/entity/electromagnetics-laboratory/animation-1.png",
               width_in_frames = 4,
               height_in_frames = 5,
              },
              {
               filename = "__space-exploration-graphics-3__/graphics/entity/electromagnetics-laboratory/animation-2.png",
               width_in_frames = 4,
               height_in_frames = 5,
              },
              {
               filename = "__space-exploration-graphics-3__/graphics/entity/electromagnetics-laboratory/animation-3.png",
               width_in_frames = 4,
               height_in_frames = 5,
              },
              {
               filename = "__space-exploration-graphics-3__/graphics/entity/electromagnetics-laboratory/animation-4.png",
               width_in_frames = 4,
               height_in_frames = 1,
              },
            },
          },
          {
            draw_as_shadow = true,
            filename = "__space-exploration-graphics-3__/graphics/entity/electromagnetics-laboratory/shadow.png",
            priority = "high",
            width = 566,
            height = 400,
            frame_count = 1,
            line_length = 1,
            repeat_count = 64,
            shift = util.by_pixel(35, 20),
            animation_speed = animation_speed,
            scale = 0.5,
          },
        },
      },
      working_visualisations =
      {
        {
          effect = "uranium-glow", -- changes alpha based on energy source light intensity
          light = {intensity = 0.6, size = 16, shift = {0.0, 0.0}, color = {r = 0.3, g = 0.5, b = 1}}
        },
      },
    },
    crafting_categories = {"space-electromagnetics", "crafting-or-electromagnetics"},
    crafting_speed = crafting_speed,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      emissions_per_minute = { pollution = 4 },
    },
    energy_usage = "5MW",
    module_slots = module_slots,
    allowed_effects = data_util.all_effects_except("productivity"),
  },
})
