local data_util = require("data_util")

local target_animation_speed = 1
local crafting_speed = 2
local module_slots = 4
local animation_speed = (target_animation_speed / crafting_speed) / (1 + data_util.speed_module_3_speed_bonus * module_slots)

data:extend({
  {
    type = "assembling-machine",
    name = data_util.mod_prefix .. "space-hypercooler",
    icon = "__space-exploration-graphics__/graphics/icons/hypercooler.png",
    icon_size = 64,
    flags = {"placeable-neutral","placeable-player", "player-creation"},
    minable = {mining_time = 0.2, result = data_util.mod_prefix .. "space-hypercooler"},
    max_health = 500,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    alert_icon_shift = util.by_pixel(0, 0),
    circuit_connector = circuit_connector_definitions.create_vector
    (
      universal_connector_template,
      {
        { variation = 18, main_offset = {2, 2}, shadow_offset = {2, 2}, show_shadow = true },
        { variation = 18, main_offset = {2, 2}, shadow_offset = {2, 2}, show_shadow = true },
        { variation = 18, main_offset = {2, 2}, shadow_offset = {2, 2}, show_shadow = true },
        { variation = 18, main_offset = {2, 2}, shadow_offset = {2, 2}, show_shadow = true },
      }
    ),
    circuit_wire_max_distance = default_circuit_wire_max_distance,
    resistances =
    {
      {
        type = "fire",
        percent = 70
      }
    },
    fluid_boxes = {
      {
        production_type = "input",
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = {{ flow_direction="input", position = {0, -2}, direction = defines.direction.north }},
        secondary_draw_orders = { north = -1 }
      },
      {
        production_type = "input",
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = {{ flow_direction="input", position = {-2, 0}, direction = defines.direction.west }},
        secondary_draw_orders = { north = -1 }
      },
      {
        production_type = "output",
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = {{ flow_direction="output", position = {0, 2}, direction = defines.direction.south }},
        secondary_draw_orders = { north = -1 }
      },
      {
        production_type = "output",
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = {{ flow_direction="output", position = {2, 0}, direction = defines.direction.east }},
        secondary_draw_orders = { north = -1 }
      },
    },
    open_sound = data_util.machine_open_sound,
    close_sound = data_util.machine_close_sound,
    impact_category = "metal-large",
    working_sound =
    {
      sound = {
        {
          filename = "__base__/sound/pumpjack.ogg",
          volume = 0.8
        },
      },
      idle_sound = { filename = "__base__/sound/idle1.ogg", volume = 0.6 },
      apparent_volume = 1.5,
    },
    collision_box = {{-2.2, -2.2}, {2.2, 2.2}},
    collision_mask = {
      layers = {
        water_tile = true,
        ground_tile = true,
        item = true,
        object = true,
        player = true,
        --[spaceship_collision_layer] = true,
      },
    },
    selection_box = {{-2.5, -2.5}, {2.5, 2.5}},
    drawing_box_vertical_extension = 0.2,
    graphics_set = {
      animation =
      {
        layers =
        {
          {
            priority = "high",
            width = 320,
            height = 352,
            frame_count = 64,
            shift = util.by_pixel(-0, -8),
            animation_speed = animation_speed,
            scale = 0.5,
            stripes =
            {
              {
               filename = "__space-exploration-graphics-4__/graphics/entity/hypercooler/hypercooler-1.png",
               width_in_frames = 6,
               height_in_frames = 5,
              },
              {
               filename = "__space-exploration-graphics-4__/graphics/entity/hypercooler/hypercooler-2.png",
               width_in_frames = 6,
               height_in_frames = 5,
              },
              {
               filename = "__space-exploration-graphics-4__/graphics/entity/hypercooler/hypercooler-3.png",
               width_in_frames = 4,
               height_in_frames = 1,
              },
            }
          },
          {
            draw_as_shadow = true,
            filename = "__space-exploration-graphics-4__/graphics/entity/hypercooler/shadow.png",
            priority = "high",
            width = 424,
            height = 280,
            frame_count = 1,
            line_length = 1,
            repeat_count = 64,
            shift = util.by_pixel(25, 11),
            scale = 0.5,
          },
        },
      },
    },
    crafting_categories = {"space-hypercooling"},
    crafting_speed = crafting_speed,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      emissions_per_minute = { pollution = 2 },
    },
    energy_usage = "200kW",
    module_slots = module_slots,
    allowed_effects = data_util.all_effects_except("productivity", "quality"),
  },
})
