local data_util = require("data_util")

data.raw.fluid.water.subgroup = "water"
data.raw.fluid.water.order = "a[water]-a[water]-a[water]"

local steam_max_temperature = 5000
data.raw.fluid.steam.max_temperature = math.max(data.raw.fluid.steam.max_temperature, steam_max_temperature)
data.raw.fluid.steam.subgroup = "water"
data.raw.fluid.steam.order = "a[water]-e[steam]-a[steam]"

local decompressing_steam = table.deepcopy(data.raw.fluid.steam)
decompressing_steam.name = data_util.mod_prefix .. "decompressing-steam"
decompressing_steam.hidden = true
decompressing_steam.icons = {
  { icon = data.raw.item[data_util.mod_prefix .. "condenser-turbine"].icon, scale = 1, icon_size = 64 },
  { icon = data.raw.fluid["steam"].icon, scale = 0.75, icon_size = 64 },
}
decompressing_steam.order = "a[water]-f[decomp-steam]-a[decomp-steam]"

local space_water = table.deepcopy(data.raw.fluid.water)
space_water.name = data_util.mod_prefix .. "space-water"
space_water.icon = "__space-exploration-graphics__/graphics/icons/fluid/space-water.png"
space_water.icon_size = 64
space_water.subgroup = "water"
space_water.order = "a[water]-c[cosmic-water]-a[cosmic-water]"

local contaminated_space_water = table.deepcopy(data.raw.fluid.water)
contaminated_space_water.name = data_util.mod_prefix .. "contaminated-space-water"
contaminated_space_water.icon = "__space-exploration-graphics__/graphics/icons/fluid/contaminated-space-water.png"
contaminated_space_water.icon_size = 64
contaminated_space_water.subgroup = "water"
contaminated_space_water.base_color = {r=106, g=160, b=171}
contaminated_space_water.flow_color = {r=106, g=160, b=171}
contaminated_space_water.order = "a[water]-d[bad-cosmic-water]-a[bad-cosmic-water]"

--TODO: order strings
data:extend({
  decompressing_steam,
  {
    type = "fluid",
    name = data_util.mod_prefix .. "methane-gas",
    subgroup = "oil",
    default_temperature = 15,
    max_temperature = 1000,
    heat_capacity = "0.1kJ",
    icon = "__space-exploration-graphics__/graphics/icons/fluid/methane-gas.png",
    icon_size = 64,
    base_color = {r=0.7, g=0.5, b=0.4},
    flow_color = {r=1.0, g=0.97, b=0.95},
    order = "a[oil]-g[methane]-b[methane-gas]",
    gas_temperature = -160,
    auto_barrel = true
  },
  space_water,
  contaminated_space_water,
  {
    type = "fluid",
    name = data_util.mod_prefix .. "liquid-rocket-fuel",
    default_temperature = 25,
    heat_capacity = "0.1kJ",
    -- fuel_categories = {"chemical"},
    fuel_value = (100 / data_util.liquid_rocket_fuel_per_solid) .. "MJ", -- solid rocket fuel is "100MJ", 50 liquid to solid
    max_temperature = 100,
    base_color = {r=0.53, g=0.1, b=0},
    flow_color = {r=0.93, g=0.68, b=0.2},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/liquid-rocket-fuel.png",
    icon_size = 64,
    order = "a[fuel]-d[liquid-rocket]-a[liquid-rocket]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    subgroup = "fuel",
  },
  --[[{
    type = "fluid",
    name = data_util.mod_prefix .. "space-coolant",
    default_temperature = data_util.coolant_temperature.hot,
    heat_capacity = "0.1kJ",
    min_temperature = -273,
    max_temperature = 1000,
    base_color = {r=80, g=27, b=255},
    flow_color = {r=178, g=155, b=255},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/space-coolant.png",
    icon_size = 64,
    order = "a[fluid]-a[water]",
    pressure_to_speed_ratio = 0.4,
    flow_to_energy_ratio = 0.59,
  },]]--
  {
    type = "fluid",
    name = data_util.mod_prefix .. "space-coolant-hot",
    default_temperature = data_util.coolant_temperature.hot,
    heat_capacity = "0.1kJ",
    -- min_temperature = -273,
    max_temperature = steam_max_temperature,
    base_color = {r=159, g=27, b=255},
    flow_color = {r=212, g=155, b=255},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/space-coolant-hot.png",
    icon_size = 64,
    order = "a[thermofluid]-a[hot]-a[hot]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    subgroup = "thermofluid",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "space-coolant-warm",
    default_temperature = data_util.coolant_temperature.normal,
    heat_capacity = "0.1kJ",
    -- min_temperature = -273,
    max_temperature = steam_max_temperature,
    base_color = {r=121, g=27, b=255},
    flow_color = {r=196, g=155, b=255},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/space-coolant-warm.png",
    icon_size = 64,
    order = "a[thermofluid]-b[warm]-a[warm]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    subgroup = "thermofluid",
    auto_barrel = false,
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "space-coolant-cold",
    default_temperature = data_util.coolant_temperature.cold,
    heat_capacity = "0.1kJ",
    -- min_temperature = -273,
    max_temperature = steam_max_temperature,
    base_color = {r=95, g=47, b=255},
    flow_color = {r=185, g=164, b=255},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/space-coolant-cold.png",
    icon_size = 64,
    order = "a[thermofluid]-c[cold]-a[cold]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    subgroup = "thermofluid",
    auto_barrel = false,
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "space-coolant-supercooled",
    default_temperature = data_util.coolant_temperature.supercooled,
    heat_capacity = "0.1kJ",
    -- min_temperature = -273,
    max_temperature = steam_max_temperature,
    base_color = {r=98, g=111, b=255},
    flow_color = {r=186, g=192, b=255},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/space-coolant-supercooled.png",
    icon_size = 64,
    order = "a[thermofluid]-d[supercooled]-a[supercooled]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    subgroup = "thermofluid",
    auto_barrel = false,
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "bio-sludge",
    default_temperature = 25,
    heat_capacity = "0.1kJ",
    max_temperature = 100,
    base_color = {r=0, g=84, b=3},
    flow_color = {r=133, g=226, b=18},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/bio-sludge.png",
    icon_size = 64,
    order = "a[sludge]-a[bio-sludge]-a[bio-slidge]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    subgroup = "sludge",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "contaminated-bio-sludge",
    default_temperature = 25,
    heat_capacity = "0.1kJ",
    max_temperature = 100,
    base_color = {r=71, g=46, b=5},
    flow_color = {r=135, g=121, b=9},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/contaminated-bio-sludge.png",
    icon_size = 64,
    order = "a[sludge]-b[contaminated-bio-sludge]-a[contaminated-bio-sludge]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    subgroup = "sludge",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "chemical-gel",
    default_temperature = 25,
    heat_capacity = "0.1kJ",
    max_temperature = 100,
    base_color = {r=238, g=106, b=13},
    flow_color = {r=238, g=106, b=13},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/chemical-gel.png",
    icon_size = 64,
    order = "a[gel]-a[chemical-gel]-a[chemical-gel]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    subgroup = "gel",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "nutrient-gel",
    default_temperature = 25,
    heat_capacity = "0.1kJ",
    max_temperature = 100,
    base_color = {r=214, g=52, b=103},
    flow_color = {r=214, g=52, b=103},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/nutrient-gel.png",
    icon_size = 64,
    order = "a[gel]-b[nutrient-gel]-a[nutrient-gel]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    subgroup = "gel",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "neural-gel",
    default_temperature = 25,
    heat_capacity = "0.1kJ",
    max_temperature = 100,
    base_color = {r=210, g=149, b=186},
    flow_color = {r=210, g=149, b=186},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/neural-gel.png",
    icon_size = 64,
    order = "a[gel]-c[neural-gel]-a[neural-gel]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    subgroup = "gel",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "neural-gel-2",
    default_temperature = 25,
    heat_capacity = "0.1kJ",
    max_temperature = 100,
    base_color = {r=135, g=124, b=213},
    flow_color = {r=135, g=124, b=213},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/neural-gel-2.png",
    icon_size = 64,
    order = "a[gel]-d[adv-neural-gel]-a[adv-neural-gel]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    subgroup = "gel",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "plasma-stream",
    default_temperature = 5000,
    heat_capacity = "0.01kJ",
    max_temperature = 100000,
    base_color = {r=255, g=186, b=0},
    flow_color = {r=255, g=186, b=0},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/plasma-stream.png",
    icon_size = 64,
    order = "r-a",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    gas_temperature = 0,
    auto_barrel = false,
    subgroup = "stream",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "ion-stream",
    default_temperature = 5000,
    heat_capacity = "0.01kJ",
    max_temperature = 100000,
    base_color = {r=0, g=240, b=255},
    flow_color = {r=0, g=240, b=255},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/ion-stream.png",
    icon_size = 64,
    order = "r-b",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    gas_temperature = 0,
    auto_barrel = false,
    subgroup = "stream",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "proton-stream",
    default_temperature = 5000,
    heat_capacity = "0.01kJ",
    max_temperature = 100000,
    base_color = {r=13, g=231, b=13},
    flow_color = {r=13, g=231, b=13},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/proton-stream.png",
    icon_size = 64,
    order = "r-d",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    gas_temperature = 0,
    auto_barrel = false,
    subgroup = "stream",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "particle-stream",
    default_temperature = 5000,
    heat_capacity = "0.01kJ",
    max_temperature = 100000,
    base_color = {r=255, g=0, b=150},
    flow_color = {r=255, g=0, b=150},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/particle-stream.png",
    icon_size = 64,
    order = "r-e",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    gas_temperature = 0,
    auto_barrel = false,
    subgroup = "stream",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "antimatter-stream",
    default_temperature = 10000,
    heat_capacity = "0.01kJ",
    max_temperature = 100000,
    base_color = {r=150, g=0, b=255},
    flow_color = {r=150, g=0, b=255},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/antimatter-stream.png",
    icon_size = 64,
    order = "z",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    gas_temperature = 0,
    auto_barrel = false,
    fuel_value = "20MJ", -- liquid rocket fuel is 2
    -- fuel_categories = {"antimatter"},
    subgroup = "stream",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "cryonite-slush",
    default_temperature = 0,
    heat_capacity = "0.01kJ",
    max_temperature = 25,
    base_color = {r=185, g=164, b=255},
    flow_color = {r=185, g=164, b=255},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/cryonite-slush.png",
    icon_size = 64,
    order = "a[cryonite]-f[cryonite-slush]-a[cryonite-slush]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    auto_barrel = true,
    subgroup = "cryonite",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "pyroflux",
    default_temperature = 50,
    heat_capacity = "0.01kJ",
    max_temperature = 10000,
    base_color = {r=185, g=0, b=0},
    flow_color = {r=185, g=0, b=0},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/pyroflux.png",
    icon_size = 64,
    order = "a[vulcanite]-f[pyroflux]-a[pyroflux]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    auto_barrel = true,
    subgroup = "vulcanite",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "vitalic-acid",
    default_temperature = 25,
    heat_capacity = "0.01kJ",
    max_temperature = 25,
    base_color = {r=146, g=240, b=48},
    flow_color = {r=146, g=240, b=48},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/vitalic-acid.png",
    icon_size = 64,
    order = "a[vitamelange]-g[vitalic-acid]-a[vitalic-acid]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    auto_barrel = true,
    subgroup = "vitamelange",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "molten-iron",
    default_temperature = 1600,
    heat_capacity = "0.01kJ",
    max_temperature = 1600,
    base_color = {r=171, g=219, b=253},
    flow_color = {r=171, g=219, b=253},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/molten-iron.png",
    icon_size = 64,
    order = "a[iron]-c[molten-iron]-a[molten-iron]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    auto_barrel = false,
    subgroup = "iron",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "molten-copper",
    default_temperature = 1100,
    heat_capacity = "0.01kJ",
    max_temperature = 1100,
    base_color = {r=253, g=204, b=171},
    flow_color = {r=253, g=204, b=171},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/molten-copper.png",
    icon_size = 64,
    order = "a[copper]-c[molten-copper]-a[molten-copper]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    auto_barrel = false,
    subgroup = "copper",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "molten-holmium",
    default_temperature = 1400,
    heat_capacity = "0.01kJ",
    max_temperature = 1400,
    base_color = {r=253, g=171, b=190},
    flow_color = {r=253, g=171, b=190},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/molten-holmium.png",
    icon_size = 64,
    order = "a[holmium]-f[molten-holmium]-a[molten-holmium]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    auto_barrel = false,
    subgroup = "holmium",
  },
  {
    type = "fluid",
    name = data_util.mod_prefix .. "molten-beryllium",
    default_temperature = 1300,
    heat_capacity = "0.01kJ",
    max_temperature = 1300,
    base_color = {r=171, g=253, b=185},
    flow_color = {r=171, g=253, b=185},
    icon = "__space-exploration-graphics__/graphics/icons/fluid/molten-beryllium.png",
    icon_size = 64,
    order = "a[beryllium]-f[molten-beryllium]-a[molten-beryllium]",
    -- pressure_to_speed_ratio = 0.4,
    -- flow_to_energy_ratio = 0.59,
    auto_barrel = false,
    subgroup = "beryllium",
  },
})
