local data_util = require("data_util")
data:extend({
  {
    icons = {
      {icon = "__space-exploration-graphics__/graphics/icons/spaceship-console-base.png", icon_size = 64},
      {icon = "__space-exploration-graphics__/graphics/icons/spaceship-console-mask.png", icon_size = 64, tint = data_util.console_tint},
      {icon = "__space-exploration-graphics__/graphics/icons/spaceship-console-white.png", icon_size = 64},
    },
    name = data_util.mod_prefix .. "spaceship-console",
    order = "a-a[spaceship-console]",
    place_result = data_util.mod_prefix .. "spaceship-console",
    stack_size = 10,
    subgroup = "spaceship-structure",
    type = "item",
  },
  {
    icons = {
      {icon = "__space-exploration-graphics__/graphics/icons/spaceship-console-base.png", icon_size = 64},
      {icon = "__space-exploration-graphics__/graphics/icons/spaceship-console-mask.png", icon_size = 64, tint = data_util.console_alt_tint},
      {icon = "__space-exploration-graphics__/graphics/icons/spaceship-console-white.png", icon_size = 64},
    },
    name = data_util.mod_prefix .. "spaceship-console-alt",
    order = "a-a[spaceship-console]",
    place_result = data_util.mod_prefix .. "spaceship-console-alt",
    stack_size = 10,
    subgroup = "spaceship-structure",
    type = "item",
    flags = {},
    hidden = true,
  },
  {
    icon = "__space-exploration-graphics__/graphics/icons/spaceship-floor.png",
    icon_size = 64,
    name = data_util.mod_prefix .. "spaceship-floor",
    order = "a-b[spaceship-floor]",
    stack_size = 50,
    subgroup = "spaceship-structure",
    type = "item",
    place_as_tile =
    {
      result = data_util.mod_prefix .. "spaceship-floor",
      condition_size = 1,
      condition = {layers = {player = true, flying = true}} -- prevents placement on out-of-map
    }
  },
  {
    icon = "__space-exploration-graphics__/graphics/icons/spaceship-wall.png",
    icon_size = 64,
    name = data_util.mod_prefix .. "spaceship-wall",
    order = "a-c[spaceship-wall]",
    place_result = data_util.mod_prefix .. "spaceship-wall",
    stack_size = 50,
    subgroup = "spaceship-structure",
    type = "item",
  },
  {
    icon = "__space-exploration-graphics__/graphics/icons/spaceship-gate.png",
    icon_size = 64,
    name = data_util.mod_prefix .. "spaceship-gate",
    order = "a-d[spaceship-gate]",
    place_result = data_util.mod_prefix .. "spaceship-gate",
    stack_size = 50,
    subgroup = "spaceship-structure",
    type = "item",
  },
  {
    icon = "__space-exploration-graphics__/graphics/icons/spaceship-rocket-engine.png",
    icon_size = 64,
    name = data_util.mod_prefix .. "spaceship-rocket-engine",
    order = "a-e[spaceship-engine]-a[rocket]",
    place_result = data_util.mod_prefix .. "spaceship-rocket-engine",
    stack_size = 10,
    subgroup = "spaceship-structure",
    type = "item",
  },
  {
    icon = "__space-exploration-graphics__/graphics/icons/spaceship-rocket-booster-tank.png",
    icon_size = 64,
    name = data_util.mod_prefix .. "spaceship-rocket-booster-tank",
    order = "a-e[spaceship-engine]-b[booster-tank]",
    place_result = data_util.mod_prefix .. "spaceship-rocket-booster-tank",
    stack_size = 10,
    subgroup = "spaceship-structure",
    type = "item",
  },
  {
    icon = "__space-exploration-graphics__/graphics/icons/spaceship-ion-engine.png",
    icon_size = 64,
    name = data_util.mod_prefix .. "spaceship-ion-engine",
    order = "a-f[spaceship-engine]-c[ion]",
    place_result = data_util.mod_prefix .. "spaceship-ion-engine",
    stack_size = 10,
    subgroup = "spaceship-structure",
    type = "item",
  },
  {
    icon = "__space-exploration-graphics__/graphics/icons/spaceship-ion-booster-tank.png",
    icon_size = 64,
    name = data_util.mod_prefix .. "spaceship-ion-booster-tank",
    order = "a-f[spaceship-engine]-d[ion]",
    place_result = data_util.mod_prefix .. "spaceship-ion-booster-tank",
    stack_size = 10,
    subgroup = "spaceship-structure",
    type = "item",
  },
  {
    icon = "__space-exploration-graphics__/graphics/icons/spaceship-antimatter-engine.png",
    icon_size = 64,
    name = data_util.mod_prefix .. "spaceship-antimatter-engine",
    order = "a-g[spaceship-engine]-e[antimatter]",
    place_result = data_util.mod_prefix .. "spaceship-antimatter-engine",
    stack_size = 10,
    subgroup = "spaceship-structure",
    type = "item",
  },
  {
    icon = "__space-exploration-graphics__/graphics/icons/spaceship-antimatter-booster-tank.png",
    icon_size = 64,
    name = data_util.mod_prefix .. "spaceship-antimatter-booster-tank",
    order = "a-g[spaceship-engine]-f[booster-tank]",
    place_result = data_util.mod_prefix .. "spaceship-antimatter-booster-tank",
    stack_size = 10,
    subgroup = "spaceship-structure",
    type = "item",
  },
})
