local data_util = require("data_util")
local make_recipe = data_util.make_recipe

-- Note: telemetry cost: 1.1 coal, 3.9 stone, 5 copper, 6.4 iron, 82 water, 73 oil

function se_chemical_science_pack_recipe_override()
  data:extend({
    {
      type = "recipe",
      name = "chemical-science-pack",
      enabled = false,
      energy_required = 36,
      ingredients =
      {
        {type = "item", name = "engine-unit", amount = 1},
        {type = "item", name = "advanced-circuit", amount = 3},
        {type = "item", name = "sulfur", amount = 2}
      },
      results = {
        {type = "item", name = "chemical-science-pack", amount = 3},
      },
      allow_productivity = true,
    }
  })
end

function se_utility_science_pack_recipe_override()
  data:extend({
    {
        type = "recipe",
        name = "utility-science-pack",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 80,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "machine-learning-data", amount = 4 },
          { type = "item", name = data_util.mod_prefix .. "cryonite-rod", amount = 8 }, -- 2 per output
          { type = "item", name = "efficiency-module", amount = 1 },
          { type = "item", name = "solar-panel", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-warm", amount = 20 },
        },
        results = {
          { type = "item", name = "utility-science-pack", amount = 4},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 4},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icons = {
          {icon = "__space-exploration-graphics__/graphics/icons/catalogue/deep-2.png", icon_size = 64},
          {icon = "__space-exploration-graphics__/graphics/icons/catalogue/mask-2.png", icon_size = 64, tint = data_util.utility_science_tint},
        },
        icon_size = 64,
        main_product = "utility-science-pack",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
        subgroup = "science-pack",
    },
  })
end

function se_production_science_pack_recipe_override()
  data:extend({
    {
        type = "recipe",
        name = "production-science-pack",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 60,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "machine-learning-data", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "vulcanite-block", amount = 6 }, -- 2 per output
          { type = "item", name = "productivity-module", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "iron-ingot", amount = 5 },
          { type = "fluid", name = data_util.mod_prefix .. "plasma-stream", amount = 100 },
        },
        results = {
          { type = "item", name = "production-science-pack", amount = 3},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 1},
        },
        icons = {
          {icon = "__space-exploration-graphics__/graphics/icons/catalogue/deep-2.png", icon_size = 64},
          {icon = "__space-exploration-graphics__/graphics/icons/catalogue/mask-2.png", icon_size = 64, tint = data_util.production_science_tint},
        },
        icon_size = 64,
        main_product = "production-science-pack",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
        subgroup = "science-pack",
    },
  })
end

data:extend({
  --[[{
    -- equivalent to 1 cargo rocket setion: (1/100) of a more expensive rocket
    -- but gives 1/10 of a silo rocket launch, so around 2-5 times more efficient than silo rockets
      type = "recipe",
      name = "space-science-pack",
      results = {{type="item", name="space-science-pack", amount=100}},
      category = "space-manufacturing",
      enabled = false,
      energy_required = 20,
      ingredients = {
        { type = "item", name = data_util.mod_prefix .. "heat-shielding", amount = 10 },
        { type = "item", name = "low-density-structure", amount = 10 },
        { type = "item", name = "rocket-control-unit", amount = 10 },
        { type = "item", name = data_util.mod_prefix .. "cargo-rocket-cargo-pod", amount = 5 },
        { type = "item", name = data_util.mod_prefix .. "cargo-rocket-fuel-tank", amount = 1 }
      },
      main_product = "space-science-pack",
      requester_paste_multiplier = 1,
    },
    {
        -- this is much more efficient that rocket returns
        type = "recipe",
        name = "space-science-pack",
        results = {{type="item", name="space-science-pack", amount=4}},
        category = "space-crafting",
        enabled = false,
        energy_required = 20,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "heat-shielding", amount = 1 },
          { type = "item", name = "low-density-structure", amount = 1 },
          { type = "item", name = "battery", amount = 5 },
          { type = "item", name = "processing-unit", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "liquid-rocket-fuel", amount = 20 },
        },
        main_product = "space-science-pack",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },]]--
    {
        type = "recipe",
        name = data_util.mod_prefix .. "rocket-science-pack",
        category = "advanced-crafting",
        enabled = false,
        energy_required = 80,
        ingredients = {
          { type = "item", name = "speed-module", amount = 1 },
          { type = "item", name = "electric-furnace", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "satellite-telemetry", amount = 1 },
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "rocket-science-pack", amount = 8},
        },
        icon = "__space-exploration-graphics__/graphics/icons/beaker/orange.png",
        icon_size = 64,
        main_product = data_util.mod_prefix .. "rocket-science-pack",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
        allow_productivity = true,
        subgroup = "science-pack",
    },
    {
        type = "recipe",
        name = "space-science-pack",
        category = "space-crafting",
        enabled = false,
        energy_required = 75,
        ingredients = {
          { type = "item", name = "stone", amount = 5},
          { type = "item", name = data_util.mod_prefix .. "space-transport-belt", amount = 2},
          { type = "item", name = "processing-unit", amount = 1},
          { type = "item", name = "rocket-fuel", amount = 1},
          { type = "fluid", name = data_util.mod_prefix .. "space-water", amount = 1 },
        },
        results = {
          { type = "item", name = "space-science-pack", amount = 5},
        },
        icons = {
          {icon = "__space-exploration-graphics__/graphics/icons/catalogue/deep-1.png", icon_size = 64},
          {icon = "__space-exploration-graphics__/graphics/icons/catalogue/mask-1.png", icon_size = 64},
        },
        icon_size = 64,
        main_product = "space-science-pack",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
        subgroup = "science-pack",
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "astronomic-science-pack-1",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "astronomic-catalogue-1", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "beryllium-plate", amount = 20 },
          { type = "item", name = data_util.mod_prefix .. "astronomic-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "astronomic-science-pack-1", amount = 2},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "astronomic-science-pack-1",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "astronomic-science-pack-2",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "astronomic-catalogue-2", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "astronomic-science-pack-1", amount = 2 },
          { type = "item", name = data_util.mod_prefix .. "aeroframe-pole", amount = 40 },
          { type = "item", name = data_util.mod_prefix .. "astronomic-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "astronomic-science-pack-2", amount = 4},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "astronomic-science-pack-2",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "astronomic-science-pack-3",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "astronomic-catalogue-3", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "astronomic-science-pack-2", amount = 4 },
          { type = "item", name = data_util.mod_prefix .. "aeroframe-scaffold", amount = 30 },
          { type = "item", name = data_util.mod_prefix .. "astronomic-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "astronomic-science-pack-3", amount = 6},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "astronomic-science-pack-3",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "astronomic-science-pack-4",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "astronomic-catalogue-4", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "astronomic-science-pack-3", amount = 6 },
          { type = "item", name = data_util.mod_prefix .. "aeroframe-bulkhead", amount = 10 },
          { type = "item", name = data_util.mod_prefix .. "astronomic-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "astronomic-science-pack-4", amount = 8},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "astronomic-science-pack-4",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "biological-science-pack-1",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "biological-catalogue-1", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "vitamelange-extract", amount = 20 },
          { type = "item", name = data_util.mod_prefix .. "biological-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "biological-science-pack-1", amount = 2},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "biological-science-pack-1",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "biological-science-pack-2",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "biological-catalogue-2", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "biological-science-pack-1",amount = 2 },
          { type = "item", name = data_util.mod_prefix .. "bioscrubber", amount = 10 },
          { type = "item", name = data_util.mod_prefix .. "biological-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "biological-science-pack-2", amount = 4},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "biological-science-pack-2",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "biological-science-pack-3",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "biological-catalogue-3", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "biological-science-pack-2", amount = 4 },
          { type = "item", name = data_util.mod_prefix .. "vitalic-reagent", amount = 40 },
          { type = "item", name = data_util.mod_prefix .. "biological-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "biological-science-pack-3", amount = 6},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "biological-science-pack-3",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "biological-science-pack-4",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "biological-catalogue-4", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "biological-science-pack-3", amount = 6 },
          { type = "item", name = data_util.mod_prefix .. "vitalic-epoxy", amount = 10 },
          { type = "item", name = data_util.mod_prefix .. "core-fragment-".. data_util.mod_prefix .."vitamelange", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "biological-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "biological-science-pack-4", amount = 8},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "biological-science-pack-4",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "material-science-pack-1",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "material-catalogue-1", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "iridium-plate", amount = 20 },
          { type = "item", name = data_util.mod_prefix .. "material-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "material-science-pack-1", amount = 2},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "material-science-pack-1",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "material-science-pack-2",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "material-catalogue-2", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "material-science-pack-1", amount = 2 },
          { type = "item", name = data_util.mod_prefix .. "heavy-girder", amount = 10 },
          { type = "item", name = data_util.mod_prefix .. "material-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "material-science-pack-2", amount = 4},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "material-science-pack-2",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "material-science-pack-3",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "material-catalogue-3", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "material-science-pack-2", amount = 4 },
          { type = "item", name = data_util.mod_prefix .. "heavy-bearing", amount = 15 },
          { type = "item", name = data_util.mod_prefix .. "material-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "material-science-pack-3", amount = 6},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "material-science-pack-3",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "material-science-pack-4",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "material-catalogue-4", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "material-science-pack-3", amount = 6 },
          { type = "item", name = data_util.mod_prefix .. "heavy-composite", amount = 10 },
          { type = "item", name = data_util.mod_prefix .. "material-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "material-science-pack-4", amount = 8},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "material-science-pack-4",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "energy-science-pack-1",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "energy-catalogue-1", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "holmium-plate", amount = 20 },
          { type = "item", name = data_util.mod_prefix .. "energy-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "energy-science-pack-1", amount = 2},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "energy-science-pack-1",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "energy-science-pack-2",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "energy-catalogue-2", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "energy-science-pack-1", amount = 2 },
          { type = "item", name = data_util.mod_prefix .. "holmium-cable", amount = 20 },
          { type = "item", name = data_util.mod_prefix .. "energy-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "energy-science-pack-2", amount = 4},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "energy-science-pack-2",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "energy-science-pack-3",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "energy-catalogue-3", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "energy-science-pack-2", amount = 4 },
          { type = "item", name = data_util.mod_prefix .. "holmium-solenoid", amount = 15 },
          { type = "item", name = data_util.mod_prefix .. "energy-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "energy-science-pack-3", amount = 6},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "energy-science-pack-3",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "energy-science-pack-4",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 30,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "energy-catalogue-4", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "energy-science-pack-3", amount = 6 },
          { type = "item", name = data_util.mod_prefix .. "quantum-processor", amount = 5 },
          { type = "item", name = data_util.mod_prefix .. "energy-insight", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-cold", amount = 20},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "energy-science-pack-4", amount = 8},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 6},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 20},
        },
        icon_size = 64,
        main_product = data_util.mod_prefix .. "energy-science-pack-4",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    --[[{
        type = "recipe",
        name = "space-science-pack",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 20,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 100 },
          { type = "item", name = data_util.mod_prefix .. "lifesupport-canister", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "space-mirror", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "space-platform-scaffold", amount = 1 },
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-supercooled", amount = 100},
        },
        results = {
          { type = "item", name = "space-science-pack", amount = 5},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 100},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 100},
        },
        icon = data.raw.tool["space-science-pack"].icon,
        icon_size = 64,
        main_product = "space-science-pack",
        requester_paste_multiplier = 1,
    },]]--
    {
        type = "recipe",
        name = data_util.mod_prefix .. "deep-space-science-pack-1",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 60,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "deep-catalogue-1", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "naquium-plate", amount = 10},
          { type = "fluid", name = data_util.mod_prefix .. "neural-gel-2", amount = 5},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-supercooled", amount = 100},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "deep-space-science-pack-1", amount = 2},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 4},
          { type = "item", name = data_util.mod_prefix .. "broken-data", amount = 1},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 100},
        },
        icon = data.raw.tool[data_util.mod_prefix .. "deep-space-science-pack-1"].icon,
        icon_size = 64,
        main_product = data_util.mod_prefix .. "deep-space-science-pack-1",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "deep-space-science-pack-2",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 120,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "deep-space-science-pack-1", amount = 2},
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "deep-catalogue-2", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "naquium-cube", amount = 1},
          { type = "fluid", name = data_util.mod_prefix .. "neural-gel-2", amount = 5},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-supercooled", amount = 200},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "deep-space-science-pack-2", amount = 4},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 4},
          { type = "item", name = data_util.mod_prefix .. "broken-data", amount = 1},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 200},
        },
        icon = data.raw.tool[data_util.mod_prefix .. "deep-space-science-pack-2"].icon,
        icon_size = 64,
        main_product = data_util.mod_prefix .. "deep-space-science-pack-2",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "deep-space-science-pack-3",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 180,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "deep-space-science-pack-2", amount = 4},
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "deep-catalogue-3", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "naquium-tessaract", amount = 1},
          { type = "fluid", name = data_util.mod_prefix .. "neural-gel-2", amount = 5},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-supercooled", amount = 200},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "deep-space-science-pack-3", amount = 6},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 4},
          { type = "item", name = data_util.mod_prefix .. "broken-data", amount = 1},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 200},
        },
        icon = data.raw.tool[data_util.mod_prefix .. "deep-space-science-pack-3"].icon,
        icon_size = 64,
        main_product = data_util.mod_prefix .. "deep-space-science-pack-3",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },
    {
        type = "recipe",
        name = data_util.mod_prefix .. "deep-space-science-pack-4",
        category = "space-manufacturing",
        enabled = false,
        energy_required = 240,
        ingredients = {
          { type = "item", name = data_util.mod_prefix .. "deep-space-science-pack-3", amount = 6},
          { type = "item", name = data_util.mod_prefix .. "significant-data", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "deep-catalogue-4", amount = 1 },
          { type = "item", name = data_util.mod_prefix .. "naquium-processor", amount = 1},
          { type = "fluid", name = data_util.mod_prefix .. "neural-gel-2", amount = 5},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-supercooled", amount = 200},
        },
        results = {
          { type = "item", name = data_util.mod_prefix .. "deep-space-science-pack-4", amount = 8},
          { type = "item", name = data_util.mod_prefix .. "junk-data", amount = 4},
          { type = "item", name = data_util.mod_prefix .. "broken-data", amount = 1},
          { type = "fluid", name = data_util.mod_prefix .. "space-coolant-hot", amount = 200},
        },
        icon = data.raw.tool[data_util.mod_prefix .. "deep-space-science-pack-4"].icon,
        icon_size = 64,
        main_product = data_util.mod_prefix .. "deep-space-science-pack-4",
        requester_paste_multiplier = 1,
        always_show_made_in = true,
    },

})
