local data_util = require("data_util")
local make_recipe = data_util.make_recipe

data:extend({
  {
    type = "recipe",
    name = data_util.mod_prefix .. "casting-machine",
    results = {
      {type = "item", name = data_util.mod_prefix .. "casting-machine", amount = 1},
    },
    enabled = false,
    energy_required = 10,
    ingredients = {
      { type = "item", name = "concrete", amount = 8 },
      { type = "item", name = data_util.mod_prefix .. "heat-shielding", amount = 4 },
      { type = "item", name = "steel-plate", amount = 8 },
      { type = "item", name = "electronic-circuit", amount = 8 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "fuel-refinery",
    results = {
      {type = "item", name = data_util.mod_prefix .. "fuel-refinery", amount = 1},
    },
    enabled = false,
    energy_required = 10,
    ingredients = {
      { type = "item", name = SEItemNames.get_glass_name(), amount = 20 },
      { type = "item", name = "steel-plate", amount = 20 },
      { type = "item", name = "stone-brick", amount = 20 },
      { type = "item", name = "pipe", amount = 20 },
      { type = "item", name = "iron-gear-wheel", amount = 20 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "fluid-burner-generator",
    results = {
      {type = "item", name = data_util.mod_prefix .. "fluid-burner-generator", amount = 1},
    },
    enabled = false,
    energy_required = 5,
    ingredients = {
      { type = "item", name = "steel-plate", amount = 10 },
      { type = "item", name = "copper-plate", amount = 30 },
      { type = "item", name = "pipe", amount = 30 },
      { type = "item", name = "iron-gear-wheel", amount = 20 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "antimatter-reactor",
    results = {
      {type = "item", name = data_util.mod_prefix .. "antimatter-reactor", amount = 1},
    },
    enabled = false,
    energy_required = 30,
    ingredients = {
      { type = "item", name = data_util.mod_prefix .. "energy-catalogue-4", amount = 5 },
      { type = "item", name = data_util.mod_prefix .. "heat-shielding", amount = 500 },
      { type = "item", name = "low-density-structure", amount = 500 },
      { type = "item", name = "processing-unit", amount = 500 },
      { type = "item", name = data_util.mod_prefix .. "superconductive-cable", amount = 500 },
      { type = "item", name = data_util.mod_prefix .. "naquium-cube", amount = 50},
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "naquium-heat-pipe",
    results = {
      {type = "item", name = data_util.mod_prefix .. "naquium-heat-pipe", amount = 1},
    },
    enabled = false,
    energy_required = 5,
    ingredients = {
      { type = "item", name = data_util.mod_prefix .. "superconductive-cable", amount = 1 },
      { type = "item", name = data_util.mod_prefix .. "naquium-plate", amount = 4},
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "dimensional-anchor",
    hidden_in_factoriopedia = true,
    results = {
      {type = "item", name = data_util.mod_prefix .. "dimensional-anchor", amount = 1},
    },
    enabled = false,
    energy_required = 30,
    ingredients = {
      { type = "item", name = data_util.mod_prefix .. "deep-catalogue-3", amount = 4 },
      { type = "item", name = data_util.mod_prefix .. "heavy-assembly", amount = 100 },
      { type = "item", name = data_util.mod_prefix .. "lattice-pressure-vessel", amount = 100 },
      { type = "item", name = data_util.mod_prefix .. "superconductive-cable", amount = 500 },
      { type = "item", name = data_util.mod_prefix .. "naquium-tessaract", amount = 8},
      { type = "item", name = data_util.mod_prefix .. "quantum-processor", amount = 8},
    },
    requester_paste_multiplier = 1,
    category = "space-manufacturing",
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "meteor-point-defence",
    results = {
      {type = "item", name = data_util.mod_prefix .. "meteor-point-defence", amount = 1},
    },
    enabled = false,
    energy_required = 30,
    ingredients = {
      { type = "item", name = "electronic-circuit", amount = 40 },
      { type = "item", name = "steel-plate", amount = 40 },
      { type = "item", name = "concrete", amount = 40 },
      { type = "item", name = SEItemNames.get_glass_name(), amount = 20 },
      { type = "item", name = "iron-gear-wheel", amount = 20 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "meteor-point-defence-ammo",
    results = {
      {type = "item", name = data_util.mod_prefix .. "meteor-point-defence-ammo", amount = 1},
    },
    enabled = false,
    energy_required = 10,
    ingredients = {
      { type = "item", name = "steel-plate", amount = 8 },
      { type = "item", name = "coal", amount = 4 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "meteor-defence",
    results = {
      {type = "item", name = data_util.mod_prefix .. "meteor-defence", amount = 1},
    },
    enabled = false,
    energy_required = 30,
    ingredients = {
      { type = "item", name = "processing-unit", amount = 100 },
      { type = "item", name = "copper-cable", amount = 100 },
      { type = "item", name = "steel-plate", amount = 100 },
      { type = "item", name = "concrete", amount = 100 },
      { type = "item", name = SEItemNames.get_glass_name(), amount = 50 },
      { type = "item", name = "battery", amount = 50 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "meteor-defence-ammo",
    results = {
      {type = "item", name = data_util.mod_prefix .. "meteor-defence-ammo", amount = 1},
    },
    enabled = false,
    energy_required = 10,
    ingredients = {
      { type = "item", name = "steel-plate", amount = 10 },
      { type = "item", name = "electronic-circuit", amount = 10 },
      { type = "item", name = "battery", amount = 10 },
    },
    requester_paste_multiplier = 1,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "pulveriser",
    category = "crafting",
    enabled = false,
    energy_required = 30,
    ingredients = {
      {type = "item", name = "steel-plate", amount = 15},
      {type = "item", name = "iron-plate", amount = 15},
      {type = "item", name = "pipe", amount = 15},
      {type = "item", name = "concrete", amount = 15},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "pulveriser", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/pulveriser.png",
    icon_size = 64,
    order = "g-z[pulveriser]",
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "addon-power-pole",
    category = "crafting",
    enabled = false,
    energy_required = 2,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "aeroframe-pole", amount = 4},
      {type = "item", name = data_util.mod_prefix .. "holmium-cable", amount = 8},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "addon-power-pole", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/addon-power-pole.png",
    icon_size = 64,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "pylon",
    category = "crafting",
    enabled = false,
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "beryllium-plate", amount = 8},
      {type = "item", name = data_util.mod_prefix .. "aeroframe-pole", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "holmium-cable", amount = 16},
      {type = "item", name = "concrete", amount = 16},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "pylon", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/pylon.png",
    icon_size = 64,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "pylon-substation",
    category = "crafting",
    enabled = false,
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "pylon", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "holmium-solenoid", amount = 4},
      {type = "item", name = "processing-unit", amount = 16},
      {type = "item", name = "battery", amount = 16},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "pylon-substation", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/pylon-substation.png",
    icon_size = 64,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "pylon-construction",
    category = "crafting",
    enabled = false,
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "pylon", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "aeroframe-scaffold", amount = 4},
      {type = "item", name = data_util.mod_prefix .. "holmium-solenoid", amount = 4},
      {type = "item", name = data_util.mod_prefix .. "heavy-girder", amount = 4},
      {type = "item", name = "processing-unit", amount = 16},
      {type = "item", name = "battery", amount = 16},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "pylon-construction", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/pylon-construction.png",
    icon_size = 64,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "pylon-construction-radar",
    category = "crafting",
    enabled = false,
    energy_required = 10,
    ingredients = {
      {type = "item", name = "radar", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "pylon-construction", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "aeroframe-bulkhead", amount = 4},
      {type = "item", name = data_util.mod_prefix .. "heavy-bearing", amount = 4},
      {type = "item", name = data_util.mod_prefix .. "quantum-processor", amount = 4},
      {type = "item", name = "battery", amount = 16},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "pylon-construction-radar", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/pylon-construction-radar.png",
    icon_size = 64,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-assembling-machine",
    category = "crafting",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "heat-shielding", amount = 4},
      {type = "item", name = "low-density-structure", amount = 8},
      {type = "item", name = "electric-engine-unit", amount = 8},
      {type = "item", name = "processing-unit", amount = 4},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/assembling-machine.png",
    icon_size = 64,
    enabled = false,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-astrometrics-laboratory",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 1},
      {type = "item", name = "low-density-structure", amount = 40},
      {type = "item", name = "electric-engine-unit", amount = 8},
      {type = "item", name = "advanced-circuit", amount = 40},
      {type = "item", name = "processing-unit", amount = 20},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-astrometrics-laboratory", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/astrometrics-laboratory.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-biochemical-laboratory",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 3},
      {type = "item", name = "low-density-structure", amount = 60},
      {type = "item", name = SEItemNames.get_glass_name(), amount = 100},
      {type = "item", name = "pump", amount = 4},
      {type = "item", name = "electric-engine-unit", amount = 6},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-biochemical-laboratory", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/biochemical-laboratory.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-decontamination-facility",
    category = "space-crafting",
    energy_required = 10,
    ingredients = {
      {type = "item", name = "low-density-structure", amount = 40},
      {type = "item", name = data_util.mod_prefix .. "space-pipe", amount = 10},
      {type = "item", name = "processing-unit", amount = 6},
      {type = "item", name = "electric-engine-unit", amount = 6},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-decontamination-facility", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/decontamination-facility.png",
    icon_size = 64,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-electromagnetics-laboratory",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 2},
      {type = "item", name = "low-density-structure", amount = 60},
      {type = "item", name = "accumulator", amount = 20},
      {type = "item", name = "processing-unit", amount = 20},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-electromagnetics-laboratory", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/electromagnetics-laboratory.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-genetics-laboratory",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 1},
      {type = "item", name = "low-density-structure", amount = 80},
      {type = "item", name = SEItemNames.get_glass_name(), amount = 80},
      {type = "item", name = "electric-engine-unit", amount = 20},
      {type = "item", name = "processing-unit", amount = 20},
      {type = "item", name = data_util.mod_prefix .. "nutrient-vat", amount = 20},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-genetics-laboratory", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/genetics-laboratory.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-gravimetrics-laboratory",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 1},
      {type = "item", name = "low-density-structure", amount = 40},
      {type = "item", name = "electric-engine-unit", amount = 8},
      {type = "item", name = data_util.mod_prefix .. "aeroframe-pole", amount = 80},
      {type = "item", name = "processing-unit", amount = 20},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-gravimetrics-laboratory", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/gravimetrics-laboratory.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-growth-facility",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 1},
      {type = "item", name = "low-density-structure", amount = 40},
      {type = "item", name = "pump", amount = 4},
      {type = "item", name = "small-lamp", amount = 100},
      {type = "item", name = SEItemNames.get_glass_name(), amount = 400},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-growth-facility", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/growth-facility.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-hypercooler",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = "storage-tank", amount = 1},
      {type = "item", name = "pump", amount = 4},
      {type = "item", name = "electric-engine-unit", amount = 4},
      {type = "item", name = "low-density-structure", amount = 20},
      {type = "item", name = data_util.mod_prefix .. "space-pipe", amount = 10},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-hypercooler", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/hypercooler.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-laser-laboratory",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 1},
      {type = "item", name = "low-density-structure", amount = 60},
      {type = "item", name = SEItemNames.get_glass_name(), amount = 80},
      {type = "item", name = "accumulator", amount = 20},
      {type = "item", name = "laser-turret", amount = 10},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-laser-laboratory", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/laser-laboratory.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "lifesupport-facility",
    category = "crafting",
    energy_required = 10,
    ingredients = {
      {type = "item", name = "assembling-machine-2", amount = 1},
      {type = "item", name = "low-density-structure", amount = 40},
      {type = "item", name = "pump", amount = 1},
      {type = "item", name = "pipe", amount = 40},
      {type = "item", name = "electric-engine-unit", amount = 6},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "lifesupport-facility", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/lifesupport-facility.png",
    icon_size = 64,
    enabled = false,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-manufactory",
    category = "space-crafting",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 4},
      {type = "item", name = "fast-inserter", amount = 8},
      {type = "item", name = data_util.mod_prefix .. "heat-shielding", amount = 8},
      {type = "item", name = "electric-engine-unit", amount = 32},
      {type = "item", name = "low-density-structure", amount = 80},
      {type = "fluid", name = data_util.mod_prefix .. "space-water", amount = 8},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-manufactory", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/manufactory.png",
    icon_size = 64,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-mechanical-laboratory",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 4},
      {type = "item", name = "low-density-structure", amount = 60},
      {type = "item", name = "steel-plate", amount = 100},
      {type = "item", name = "concrete", amount = 100},
      {type = "item", name = "electric-engine-unit", amount = 40},
      {type = "item", name = "gun-turret", amount = 10},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-mechanical-laboratory", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/mechanical-laboratory.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-particle-accelerator",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 1},
      {type = "item", name = "low-density-structure", amount = 60},
      {type = "item", name = "accumulator", amount = 20},
      {type = "item", name = "processing-unit", amount = 20},
      {type = "item", name = data_util.mod_prefix .. "heat-shielding", amount = 20},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-particle-accelerator", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/particle-accelerator.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-particle-collider",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 1},
      {type = "item", name = "low-density-structure", amount = 100},
      {type = "item", name = "processing-unit", amount = 40},
      {type = "item", name = data_util.mod_prefix .. "heat-shielding", amount = 40},
      {type = "item", name = data_util.mod_prefix .. "holmium-cable", amount = 100},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-particle-collider", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/particle-collider.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-plasma-generator",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 1},
      {type = "item", name = "low-density-structure", amount = 60},
      {type = "item", name = data_util.mod_prefix .. "space-pipe", amount = 10},
      {type = "item", name = data_util.mod_prefix .. "heat-shielding", amount = 20},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-plasma-generator", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/plasma-generator.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-radiation-laboratory",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = "uranium-fuel-cell", amount = 4},
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 4},
      {type = "item", name = "low-density-structure", amount = 60},
      {type = "item", name = data_util.mod_prefix .. "heat-shielding", amount = 20},
      {type = "item", name = "steel-plate", amount = 100},
      {type = "item", name = SEItemNames.get_glass_name(), amount = 80},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-radiation-laboratory", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/radiation-laboratory.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-radiator",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = "pump", amount = 4},
      {type = "item", name = "electric-engine-unit", amount = 4},
      {type = "item", name = "steel-plate", amount = 20},
      {type = "item", name = data_util.mod_prefix .. "space-pipe", amount = 4},
      {type = "item", name = "copper-cable", amount = 200},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-radiator", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/radiator.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-radiator-2",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-radiator", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "cryonite-rod", amount = 20},
      {type = "item", name = data_util.mod_prefix .. "lattice-pressure-vessel", amount = 4},
      {type = "item", name = data_util.mod_prefix .. "heavy-assembly", amount = 2},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-radiator-2", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/radiator-blue.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "recycling-facility",
    category = "crafting",
    energy_required = 10,
    ingredients = {
      {type = "item", name = "steel-plate", amount=20},
      {type = "item", name = "advanced-circuit", amount=10},
      {type = "item", name = "electric-engine-unit", amount=10},
      {type = "item", name = "concrete", amount=20},
      {type = "item", name = data_util.mod_prefix .. "heat-shielding", amount=10},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "recycling-facility", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/recycling-facility.png",
    icon_size = 64,
    enabled = false,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-material-fabricator",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-particle-collider", amount=1},
      {type = "item", name = data_util.mod_prefix .. "space-manufactory", amount=1},
      {type = "item", name = data_util.mod_prefix .. "space-thermodynamics-laboratory", amount=1},
      {type = "item", name = "speed-module-6", amount=5},
      {type = "item", name = "efficiency-module-6", amount=5},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-material-fabricator", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/material-fabricator.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-supercomputer-1",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 1},
      {type = "item", name = "low-density-structure", amount = 40},
      {type = "item", name = "processing-unit", amount = 100},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-supercomputer-1", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/supercomputer-1.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-supercomputer-2",
    category = "space-manufacturing",
    energy_required = 20,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-supercomputer-1", amount = 1},
      {type = "item", name = "processing-unit", amount = 500},
      {type = "item", name = data_util.mod_prefix .. "quantum-processor", amount = 50},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-supercomputer-2", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/supercomputer-2.png",
    icon_size = 64,
    requester_paste_multiplier = 2,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-supercomputer-3",
    category = "space-manufacturing",
    energy_required = 30,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-supercomputer-2", amount = 1},
      {type = "item", name = "processing-unit", amount = 1000},
      {type = "item", name = data_util.mod_prefix .. "superconductive-cable", amount = 100},
      {type = "fluid", name = data_util.mod_prefix .. "neural-gel-2", amount = 1000},
      {type = "item", name = data_util.mod_prefix .. "bioelectrics-data", amount = 100},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-supercomputer-3", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/supercomputer-3.png",
    icon_size = 64,
    requester_paste_multiplier = 3,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-supercomputer-4",
    category = "space-manufacturing",
    energy_required = 40,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-supercomputer-3", amount = 1},
      {type = "fluid", name = data_util.mod_prefix .. "neural-gel-2", amount = 1000},
      {type = "item", name = data_util.mod_prefix .. "naquium-processor", amount = 42},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-supercomputer-4", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/supercomputer-4.png",
    icon_size = 64,
    requester_paste_multiplier = 4,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-telescope",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "space-mirror", amount = 2},
      {type = "item", name = "low-density-structure", amount = 40},
      {type = "item", name = SEItemNames.get_glass_name(), amount = 40},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-telescope", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/telescope.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-telescope-radio",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 1},
      {type = "item", name = "radar", amount = 10},
      {type = "item", name = data_util.mod_prefix .. "space-mirror", amount = 10},
      {type = "item", name = "low-density-structure", amount = 120},
      {type = "item", name = data_util.mod_prefix .. "aeroframe-scaffold", amount = 120},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-telescope-radio", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/telescope-radio.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-telescope-microwave",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "space-mirror", amount = 6},
      {type = "item", name = "low-density-structure", amount = 80},
      {type = "item", name = SEItemNames.get_glass_name(), amount = 80},
      {type = "item", name = data_util.mod_prefix .. "aeroframe-pole", amount = 120},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-telescope-microwave", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/telescope-microwave.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-telescope-xray",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "space-mirror", amount = 6},
      {type = "item", name = data_util.mod_prefix .. "heat-shielding", amount = 6},
      {type = "item", name = "low-density-structure", amount = 60},
      {type = "item", name = data_util.mod_prefix .. "aeroframe-pole", amount = 60},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-telescope-xray", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/telescope-xray.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-telescope-gammaray",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "heat-shielding", amount = 6},
      {type = "item", name = data_util.mod_prefix .. "space-mirror", amount = 24},
      {type = "item", name = "low-density-structure", amount = 60},
      {type = "item", name = data_util.mod_prefix .. "aeroframe-scaffold", amount = 60},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-telescope-gammaray", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/telescope-gammaray.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "space-thermodynamics-laboratory",
    category = "space-manufacturing",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "space-assembling-machine", amount = 1},
      {type = "item", name = "low-density-structure", amount = 60},
      {type = "item", name = data_util.mod_prefix .. "heat-shielding", amount = 60},
      {type = "item", name = "steel-plate", amount = 100},
      {type = "item", name = "storage-tank", amount = 8},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "space-thermodynamics-laboratory", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/thermodynamics-laboratory.png",
    icon_size = 64,
    requester_paste_multiplier = 1,
    enabled = false,
    always_show_made_in = true,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "supercharger",
    category = "crafting",
    enabled = false,
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "aeroframe-scaffold", amount = 4},
      {type = "item", name = data_util.mod_prefix .. "heavy-girder", amount = 4},
      {type = "item", name = data_util.mod_prefix .. "holmium-solenoid", amount = 16},
      {type = "item", name = data_util.mod_prefix .. "holmium-cable", amount = 16},
      {type = "item", name = "battery", amount = 16},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "supercharger", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/supercharger.png",
    icon_size = 64,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "compact-beacon",
    energy_required = 10,
    ingredients = {
      {type = "item", name = "beacon", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "energy-catalogue-1", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "holmium-solenoid", amount = 1},
      {type = "item", name = "low-density-structure", amount = 30},
      {type = "item", name = "processing-unit", amount = 30},
      {type = "item", name = data_util.mod_prefix .. "holmium-cable", amount = 100},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "compact-beacon", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/compact-beacon.png",
    icon_size = 64,
    enabled = false,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "compact-beacon-2",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "compact-beacon", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "deep-catalogue-1", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "superconductive-cable", amount = 5},
      {type = "item", name = data_util.mod_prefix .. "dynamic-emitter", amount = 5},
      {type = "item", name = data_util.mod_prefix .. "naquium-tessaract", amount = 5},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "compact-beacon-2", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/compact-beacon-2.png",
    icon_size = 64,
    enabled = false,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "wide-beacon",
    energy_required = 10,
    ingredients = {
      {type = "item", name = "beacon", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "energy-catalogue-1", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "holmium-solenoid", amount = 2},
      {type = "item", name = "low-density-structure", amount = 60},
      {type = "item", name = "processing-unit", amount = 60},
      {type = "item", name = data_util.mod_prefix .. "holmium-cable", amount = 200},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "wide-beacon", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/wide-beacon.png",
    icon_size = 64,
    enabled = false,
    always_show_made_in = false,
  },
  {
    type = "recipe",
    name = data_util.mod_prefix .. "wide-beacon-2",
    energy_required = 10,
    ingredients = {
      {type = "item", name = data_util.mod_prefix .. "wide-beacon", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "deep-catalogue-1", amount = 1},
      {type = "item", name = data_util.mod_prefix .. "superconductive-cable", amount = 10},
      {type = "item", name = data_util.mod_prefix .. "dynamic-emitter", amount = 10},
      {type = "item", name = data_util.mod_prefix .. "naquium-tessaract", amount = 10},
    },
    results=
    {
      {type = "item", name = data_util.mod_prefix .. "wide-beacon-2", amount=1}
    },
    icon = "__space-exploration-graphics__/graphics/icons/wide-beacon-2.png",
    icon_size = 64,
    enabled = false,
    always_show_made_in = false,
  },
})
