local data_util = require("data_util")


data:extend(
{
  {
    type = "tile",
    name = data_util.mod_prefix.."asteroid",
    subgroup = "space-exploration-tiles",
    collision_mask = {
      layers = {
        [space_collision_layer] = true,
      }, -- nothing?
    },
    --autoplace = {}, -- see final-noise-programs
    layer_group = "ground-natural",
    layer = 20,
    variants = tile_variations_template(
      "__space-exploration-graphics__/graphics/terrain/asteroid/asteroid.png",
      "__base__/graphics/terrain/masks/transition-3.png",
      {
        max_size = 4,
        [1] = { weights = {0.085, 0.085, 0.085, 0.085, 0.087, 0.085, 0.065, 0.085, 0.045, 0.045, 0.045, 0.045, 0.005, 0.025, 0.045, 0.045 } },
        [2] = { probability = 1, weights = {0.018, 0.020, 0.015, 0.025, 0.015, 0.020, 0.025, 0.015, 0.025, 0.025, 0.010, 0.025, 0.020, 0.025, 0.025, 0.010 }, },
        [4] = { probability = 0.1, weights = {0.018, 0.020, 0.015, 0.025, 0.015, 0.020, 0.025, 0.015, 0.025, 0.025, 0.010, 0.025, 0.020, 0.025, 0.025, 0.010 }, },
        --[8] = { probability = 1.00, weights = {0.090, 0.125, 0.125, 0.125, 0.125, 0.125, 0.125, 0.025, 0.125, 0.005, 0.010, 0.100, 0.100, 0.010, 0.020, 0.020} },
      }
    ),
    walking_sound = table.deepcopy(data.raw.tile["dirt-1"].walking_sound),
    map_color = {r = 80, g = 80, b = 80},
    ageing=0.0001,
    walking_speed_modifier = 1,
    vehicle_friction_modifier = 1,
    transitions = {
        {
          to_tiles = {
            "water",
            "deepwater",
            "water-green",
            "deepwater-green",
            "water-shallow",
            "water-mud",
            "water-wube",
            data_util.mod_prefix .. "space"
          },
          transition_group = 1,

          spritesheet = "__space-exploration-graphics__/graphics/terrain/asteroid/asteroid-cliff.png",

          overlay_enabled = true,
          background_enabled = true,
          mask_enabled = false,
          background_mask_enabled = true,

          overlay_layer_group = "zero",
          background_layer_offset = 1,
          background_layer_group = "zero",
          offset_background_layer_by_tile_layer = true,

          layout = {
            scale = 0.5,
            inner_corner_count = 5,
            outer_corner_count = 5,
            side_count = 5,
            u_transition_count = 2,
            o_transition_count = 4,
            inner_corner_y = 0,
            outer_corner_y = 576,
            side_y = 1152,
            u_transition_y = 1728,
            o_transition_y = 2304,
            inner_corner_tile_height = 2,
            outer_corner_tile_height = 2,
            side_tile_height = 2,
            u_transition_tile_height = 2,
            overlay    = { x_offset = 0 },
            mask       = { x_offset = 2176 },
            background = { x_offset = 1088 }
          },

      }
    }
  },
})
