local data_util = require("data_util")
data:extend(
{
  {
    type = "tile",
    name = data_util.mod_prefix .. "spaceship-floor",
    needs_correction = false,
    minable = {mining_time = 0.2, result = data_util.mod_prefix .. "spaceship-floor"},
    mined_sound = { filename = "__base__/sound/deconstruct-bricks.ogg" },
    collision_mask = {
      layers = {
        [space_collision_layer] = true,
        [spaceship_collision_layer] = true,
        resource = true,
      },
    },
    walking_speed_modifier = 1.2,
    layer_group = "ground-artificial",
    layer = 126, -- near the top of the 128 "ground-artificial" range
    decorative_removal_probability = 1,
    variants =
    {
      main =
      {
        {
          picture = "__space-exploration-graphics__/graphics/terrain/spaceship-floor/tile1.png",
          count = 12,
          size = 1,
          scale = 0.5
        }
      },
      transition = {
        overlay_layout = {
          inner_corner =
          {
            spritesheet = "__space-exploration-graphics__/graphics/terrain/spaceship-floor/tile-inner-corner.png",
            count = 1,
            tall = false,
            scale = 0.5
          },
          outer_corner =
          {
            spritesheet = "__space-exploration-graphics__/graphics/terrain/spaceship-floor/tile-outer-corner.png",
            count = 1,
            tall = false,
            scale = 0.5
          },
          side =
          {
            spritesheet = "__space-exploration-graphics__/graphics/terrain/spaceship-floor/tile-side.png",
            count = 16,
            tall = false,
            scale = 0.5
          },
          u_transition =
          {
            spritesheet = "__space-exploration-graphics__/graphics/terrain/spaceship-floor/tile-u.png",
            count = 1,
            tall = false,
            scale = 0.5
          },
          o_transition =
          {
            spritesheet = "__space-exploration-graphics__/graphics/terrain/spaceship-floor/tile-o.png",
            count = 1,
            scale = 0.5
          }
        }
      }
    },
    walking_sound =
    {
      {
        filename = "__base__/sound/walking/concrete-1.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-2.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-3.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-4.ogg",
        volume = 1.2
      }
    },
    map_color={r=100, g=100, b=100},
    ageing=0,
    vehicle_friction_modifier = 100
  },
})
