local data_util = require("data_util")

-- this mimics the control stage check
local visible_quality_prototypes_count = 0
for _, prototype in pairs(data.raw.quality) do
  if not prototype.hidden then
    visible_quality_prototypes_count = visible_quality_prototypes_count + 1
  end
end

if visible_quality_prototypes_count > 1 then

  for _, entity in ipairs(data.raw["mod-data"][data_util.mod_prefix .. "loses-quality-when-placed"].data.entities) do
    local prototype = data.raw[entity.type][entity.name]
    if prototype then
      data_util.add_custom_tooltip_field(prototype, {
        key = "loses-quality-when-placed",
        name = "", -- the colon cannot be styled bold like the rest so we hide it
        value = {"space-exploration.loses_quality_when_placed_line"},
        order = 0,
      })
    end
  end

  local is_arcosphere_variant = util.list_to_map({
    data_util.mod_prefix .. "arcosphere-a",
    data_util.mod_prefix .. "arcosphere-b",
    data_util.mod_prefix .. "arcosphere-c",
    data_util.mod_prefix .. "arcosphere-d",
    data_util.mod_prefix .. "arcosphere-e",
    data_util.mod_prefix .. "arcosphere-f",
    data_util.mod_prefix .. "arcosphere-g",
    data_util.mod_prefix .. "arcosphere-h",
  })

  for _, recipe in pairs(data.raw.recipe) do
    for _, result in ipairs(recipe.results or {}) do
      if result.type == "item" and is_arcosphere_variant[result.name] then
        if recipe.allow_quality ~= false then
          recipe.allow_quality = false
          debug_log("blocked quality on recipe producing arcosphere variants: " .. recipe.name)
        end
      end
    end
  end

  if settings.startup["se-modules-with-quality-in-module-slots"].value ~= "ignore" then
    for _, module in pairs(data.raw.module) do
      data_util.add_custom_tooltip_field(module, {
        key = "quality-ones-will-x-themselves",
        name = "", -- the colon cannot be styled bold like the rest so we hide it
        value = {"space-exploration.quality_ones_will_x_themselves_line", settings.startup["se-modules-with-quality-in-module-slots"].value},
        order = 0,
      })
    end
  else
    for _, module in pairs(data.raw.module) do
      data_util.add_custom_tooltip_field(module, {
        key = "quality-ones-will-x-themselves",
        name = "", -- the colon cannot be styled bold like the rest so we hide it
        value = {"space-exploration.quality_ones_should_not_be_used_line"},
        order = 0,
      })
    end
  end
end

-- manages undiscoverability and the disclaimers
if settings.startup["se-quality-mod-name"].value ~= "" then
  local undiscoverable = settings.startup["se-quality-technology-is-undiscoverable"].value

  if undiscoverable then
    data.raw["utility-constants"]["default"].factoriopedia_recycling_recipe_categories = {}
  end

  for _, technology_name in pairs({
    "quality-module",
    "quality-module-2",
    "quality-module-3",
    "quality-module-4",
    "quality-module-5",
    "quality-module-6",
    "quality-module-7",
    "quality-module-8",
    "quality-module-9",
    "recycling",
    "epic-quality",
    "legendary-quality",
  }) do
    local technology = data.raw.technology[technology_name]

    if undiscoverable then
      technology.enabled = false
      technology.visible_when_disabled = true
    end

    assert(technology.localised_description == nil)
    technology.localised_description = {"",
      "[font=default-bold][color=#f5cb48]",
      {undiscoverable and "undiscoverable.disabled-by-se-startup-setting" or "undiscoverable.enabled-by-se-startup-setting"},
      "\n",
      {"undiscoverable.quality-disclaimer"},
      "[/color][/font]",
      "\n",
      {"technology-description." .. (technology.name:match("^quality%-module") and "quality-module" or technology.name)}
    }
  end
end
