local persepolis = {
  name = "persepolis",
  center = {x = 0, y = 0},
  force_name = "ignore",
  clear_entity_areas = {
    {{-97, -128}, {93, 156}},
  },
  clear_decorative_areas = {
    {{-97, -128}, {93, 156}},
  },
  --runtime_area = {left_top = {x = -97, y = -128}, right_bottom = { x = 93, y = 156}},
  --runtime_tick_3600 = function(surface, ruin_data)
  --end,
  ---@param surface LuaSurface
  ---@param ruin_position MapPosition.0
  ---@param ruin RuinInfo
  prebuild = function(surface, ruin_position, ruin)
    local ruin_position_center_offset = Util.vectors_delta(ruin.center, ruin_position)
    surface.request_to_generate_chunks(ruin_position_center_offset, 5)
    surface.force_generate_chunk_requests()
  end,
  ---@param surface LuaSurface
  ---@param ruin_position MapPosition.0
  ---@param ruin RuinInfo
  ---@param built_entities Collection<LuaEntity>
  postbuild = function(surface, ruin_position, ruin, built_entities)
    local ruin_position_center_offset = Util.vectors_delta(ruin.center, ruin_position)
    local iron_wood_chests = {}
    local containers = {}
    local iron
    for entity in pairs(built_entities) do
      local entity_type = entity.type
      local entity_name = entity.name
      if entity_name == "iron-wood-chest" then
        table.insert(iron_wood_chests, entity)
      end
      if entity_type == "container" then
        table.insert(containers, entity)
        entity.force = "capture"
      end
      if entity_type == "lab" then
        entity.insert({name="coal", count=10000})
        entity.insert({name="automation-science-pack", count=10000})
        entity.force = "capture"
        entity.backer_name = "Persepolis II"
      end
      if entity_name == "stone-furnace" then
        entity.force = "capture"
        iron = not iron
        entity.insert({name="coal", count=10000})
        if iron then
          entity.insert({name="iron-ore", count=10000})
        else
          entity.insert({name="copper-ore", count=10000})
        end
      end
      if entity_type == "wall" then
        if math.random() < 0.03 then
          entity.die()
        else
          entity.destructible = false
        end
      end
    end

    local arcospheres_to_add = 10
    local zone = Zone.from_surface(surface)
    if zone and zone.looted_items and zone.looted_items["se-arcosphere"] then
      arcospheres_to_add = arcospheres_to_add - zone.looted_items["se-arcosphere"]
    end
    if arcospheres_to_add > 0 then
      for i = 1, arcospheres_to_add do
        iron_wood_chests[math.random(1, #iron_wood_chests)].insert({name="se-arcosphere", count=1})
      end
    end

    for _, entity in pairs(containers) do
      local r = math.random(1,9)
      entity.insert(({
        {name="coal", count = 10000},
        {name="iron-ore", count = 10000},
        {name="copper-ore", count=10000},
        {name="stone", count=10000},
        {name="wood", count=10000},
        {name="iron-plate", count=10000},
        {name="copper-plate", count=10000},
        {name="stone-brick", count=10000},
        {name="raw-fish", count=10000}
      })[r])
    end

    local area = Util.area_add_position({{-96, -128}, {93, 156}}, ruin_position_center_offset)
    local chunks = {}
    for x = math.floor(area[1][1]/32), math.ceil(area[2][1]/32) do
      for y = math.floor(area[1][2]/32), math.ceil(area[2][2]/32) do
        table.insert(chunks, {x=x,y=y})
      end
    end
    local decorative_names = {}
    for decorative_name, prototype in pairs(prototypes.decorative) do
      if prototype.autoplace_specification and not(string.find(decorative_name, "dune", 1, true)
      or string.find(decorative_name, "blue", 1, true)
      or string.find(decorative_name, "purple", 1, true)
      or string.find(decorative_name, "violet", 1, true)
      or string.find(decorative_name, "mauve", 1, true)) then
        table.insert(decorative_names, decorative_name)
      end
    end
    surface.regenerate_decorative(decorative_names, chunks)
  end,
  entities = { -- not blueprintable
    ["stone-rubble"] = {{x=-78.55078125, y=-126.2109375, graphics_variation=5}, {x=-80.52734375, y=-124.234375, graphics_variation=7}, {x=-54.41015625, y=-122.5390625, graphics_variation=7}, {x=-52.71875, y=-122.4375, graphics_variation=5}, {x=-85.37109375, y=-119.3125, graphics_variation=8}, {x=-21.5078125, y=-117.39453125, graphics_variation=5}, {x=3.4375, y=-109.1796875, graphics_variation=3}, {x=62.95703125, y=-109.55859375, graphics_variation=1}, {x=-84.421875, y=-107.96875, graphics_variation=6}, {x=-5.41796875, y=-107.56640625, graphics_variation=8}, {x=73.62890625, y=-101.328125, graphics_variation=1}, {x=77.53515625, y=-100.56640625, graphics_variation=2}, {x=84.35546875, y=-102.43359375, graphics_variation=6}, {x=75.53515625, y=-100.48828125, graphics_variation=7}, {x=79.36328125, y=-99.5, graphics_variation=6}, {x=56.51953125, y=-96.70703125, graphics_variation=4}, {x=73.6484375, y=-97.48046875, graphics_variation=4}, {x=79.6875, y=-96.62109375, graphics_variation=5}, {x=60.60546875, y=-95.66015625, graphics_variation=7}, {x=64.61328125, y=-94.7109375, graphics_variation=3}, {x=56.515625, y=-92.63671875, graphics_variation=8}, {x=68.48828125, y=-93.48046875, graphics_variation=6}, {x=73.57421875, y=-92.7578125, graphics_variation=3}, {x=13.61328125, y=-91.375, graphics_variation=8}, {x=23.546875, y=-90.86328125, graphics_variation=2}, {x=55.48828125, y=-90.6171875, graphics_variation=7}, {x=60.44140625, y=-91.55078125, graphics_variation=5}, {x=77.171875, y=-90.625, graphics_variation=2}, {x=-84.4140625, y=-90.46484375, graphics_variation=5}, {x=54.5546875, y=-88.5625, graphics_variation=8}, {x=59.390625, y=-89.3828125, graphics_variation=2}, {x=50.72265625, y=-88.5, graphics_variation=6}, {x=57.734375, y=-88.44921875, graphics_variation=7}, {x=61.75390625, y=-87.62890625, graphics_variation=8}, {x=63.54296875, y=-88.44921875, graphics_variation=4}, {x=65.546875, y=-86.859375, graphics_variation=3}, {x=48.6640625, y=-85.5078125, graphics_variation=1}, {x=55.58203125, y=-85.34375, graphics_variation=2}, {x=58.34375, y=-86.3515625, graphics_variation=3}, {x=62.66796875, y=-85.4375, graphics_variation=1}, {x=69.23828125, y=-84.92578125, graphics_variation=5}, {x=73.75390625, y=-85.484375, graphics_variation=5}, {x=76.421875, y=-84.7421875, graphics_variation=8}, {x=60.421875, y=-84.5234375, graphics_variation=3}, {x=-80.16015625, y=-80.42578125, graphics_variation=6}, {x=31.55078125, y=-80.453125, graphics_variation=6}, {x=38.34765625, y=-78.5078125, graphics_variation=8}, {x=-61.5078125, y=-76.4296875, graphics_variation=6}, {x=50.921875, y=-75.3828125, graphics_variation=2}, {x=81.99609375, y=-73.53125, graphics_variation=8}, {x=-57.15625, y=-70.703125, graphics_variation=4}, {x=69.0234375, y=-71.53125, graphics_variation=8}, {x=70.375, y=-72.2109375, graphics_variation=6}, {x=-78.60546875, y=-70.3203125, graphics_variation=5}, {x=-76.35546875, y=-70.34375, graphics_variation=7}, {x=-74.51953125, y=-70.45703125, graphics_variation=8}, {x=-48.5390625, y=-70.38671875, graphics_variation=5}, {x=-78.48828125, y=-67.46484375, graphics_variation=2}, {x=-76.375, y=-67.27734375, graphics_variation=7}, {x=-74.2890625, y=-67.53125, graphics_variation=8}, {x=64.2734375, y=-66.55859375, graphics_variation=1}, {x=-68.515625, y=-65.08984375, graphics_variation=8}, {x=62.578125, y=-66.53515625, graphics_variation=4}, {x=77.5546875, y=-64.5859375, graphics_variation=8}, {x=79.7265625, y=-64.93359375, graphics_variation=7}, {x=84.55859375, y=-64.96875, graphics_variation=3}, {x=-53.6953125, y=-62.859375, graphics_variation=1}, {x=-45.515625, y=-63.55078125, graphics_variation=3}, {x=-41.5234375, y=-63.6640625, graphics_variation=6}, {x=-39.43359375, y=-63.5, graphics_variation=6}, {x=-37.484375, y=-63.453125, graphics_variation=5}, {x=-31.46875, y=-63.5, graphics_variation=8}, {x=-26.2578125, y=-63.7578125, graphics_variation=4}, {x=-21.91796875, y=-63.33984375, graphics_variation=5}, {x=-12.90625, y=-63.546875, graphics_variation=6}, {x=-7.3828125, y=-63.5703125, graphics_variation=2}, {x=5.18359375, y=-63.40625, graphics_variation=6}, {x=61.828125, y=-63.5625, graphics_variation=7}, {x=61.62109375, y=-62.609375, graphics_variation=6}, {x=64.9609375, y=-63.5859375, graphics_variation=3}, {x=75.46484375, y=-63.484375, graphics_variation=2}, {x=78.640625, y=-64.484375, graphics_variation=4}, {x=84.625, y=-64, graphics_variation=5}, {x=-55.234375, y=-61.55078125, graphics_variation=5}, {x=-53.90234375, y=-61.70703125, graphics_variation=7}, {x=-0.4296875, y=-62.47265625, graphics_variation=5}, {x=17.4609375, y=-59.16796875, graphics_variation=8}, {x=46.71875, y=-60.3828125, graphics_variation=3}, {x=48.58984375, y=-59.4375, graphics_variation=8}, {x=47.5703125, y=-59.46484375, graphics_variation=5}, {x=49.62109375, y=-59.5078125, graphics_variation=5}, {x=64.265625, y=-60.171875, graphics_variation=5}, {x=67.5859375, y=-59.12890625, graphics_variation=4}, {x=75.56640625, y=-60.49609375, graphics_variation=3}, {x=-78.921875, y=-58.5, graphics_variation=4}, {x=-77.875, y=-58.16015625, graphics_variation=6}, {x=-68.26171875, y=-58.5234375, graphics_variation=3}, {x=-65.26953125, y=-58.26953125, graphics_variation=6}, {x=-56.5390625, y=-58.22265625, graphics_variation=6}, {x=-21.63671875, y=-58.37109375, graphics_variation=5}, {x=14.7578125, y=-57.1953125, graphics_variation=3}, {x=51.6796875, y=-58.32421875, graphics_variation=3}, {x=20.640625, y=-55.78515625, graphics_variation=1}, {x=40.84375, y=-55.39453125, graphics_variation=1}, {x=55.2890625, y=-56.0703125, graphics_variation=1}, {x=12.62109375, y=-53.328125, graphics_variation=8}, {x=50.47265625, y=-52.5625, graphics_variation=8}, {x=55.51953125, y=-54.3515625, graphics_variation=8}, {x=-82.34765625, y=-49.328125, graphics_variation=7}, {x=32.60546875, y=-50.01171875, graphics_variation=1}, {x=64.4765625, y=-47.2421875, graphics_variation=1}, {x=61.55078125, y=-44.6328125, graphics_variation=2}, {x=62.5, y=-45.55859375, graphics_variation=5}, {x=62.22265625, y=-46.53515625, graphics_variation=4}, {x=71.51953125, y=-45.39453125, graphics_variation=2}, {x=71.50390625, y=-46.4296875, graphics_variation=3}, {x=14.75, y=-44.3359375, graphics_variation=8}, {x=17.453125, y=-42.8359375, graphics_variation=2}, {x=58.734375, y=-44.0625, graphics_variation=8}, {x=61.24609375, y=-43.6796875, graphics_variation=1}, {x=62.45703125, y=-43.35546875, graphics_variation=3}, {x=62.546875, y=-44.4453125, graphics_variation=5}, {x=71.5390625, y=-43.41015625, graphics_variation=1}, {x=58.734375, y=-40.8125, graphics_variation=7}, {x=62.19921875, y=-42.23828125, graphics_variation=6}, {x=69.6328125, y=-40.7578125, graphics_variation=2}, {x=71.46875, y=-42.32421875, graphics_variation=8}, {x=72.40234375, y=-42.48046875, graphics_variation=2}, {x=73.48828125, y=-42.55078125, graphics_variation=7}, {x=74.5390625, y=-42.46484375, graphics_variation=3}, {x=12.4140625, y=-38.578125, graphics_variation=5}, {x=14.70703125, y=-39.1328125, graphics_variation=3}, {x=17.3046875, y=-38.5546875, graphics_variation=7}, {x=61.64453125, y=-39.2734375, graphics_variation=4}, {x=58.5625, y=-37.29296875, graphics_variation=5}, {x=12.265625, y=-35.40625, graphics_variation=1}, {x=14.6796875, y=-33.4765625, graphics_variation=1}, {x=76.5234375, y=-33.171875, graphics_variation=5}, {x=87.05078125, y=-32.265625, graphics_variation=2}, {x=9.07421875, y=-29.0390625, graphics_variation=6}, {x=79.8359375, y=-30.484375, graphics_variation=8}, {x=-82.36328125, y=-26.67578125, graphics_variation=6}, {x=-71.2734375, y=-25.92578125, graphics_variation=2}, {x=-37.58984375, y=-25.8984375, graphics_variation=6}, {x=12.265625, y=-25.48828125, graphics_variation=8}, {x=63.6640625, y=-24.79296875, graphics_variation=3}, {x=69.5, y=-25.921875, graphics_variation=4}, {x=76.60546875, y=-26.1484375, graphics_variation=4}, {x=76.4921875, y=-24.93359375, graphics_variation=1}, {x=84.50390625, y=-20.69140625, graphics_variation=1}, {x=-84.56640625, y=-18.8984375, graphics_variation=2}, {x=-80.3359375, y=-19.31640625, graphics_variation=3}, {x=-37.25390625, y=-19.2109375, graphics_variation=8}, {x=-27.35546875, y=-19.3125, graphics_variation=5}, {x=81.609375, y=-19.17578125, graphics_variation=5}, {x=12.265625, y=-16.76171875, graphics_variation=5}, {x=66.7734375, y=-17.71484375, graphics_variation=6}, {x=76.50390625, y=-17.3828125, graphics_variation=2}, {x=-84.52734375, y=-15.375, graphics_variation=1}, {x=-64.390625, y=-16.39453125, graphics_variation=1}, {x=-87.3984375, y=-14.28515625, graphics_variation=6}, {x=-74.44140625, y=-13.5703125, graphics_variation=5}, {x=-34.23828125, y=-13.7109375, graphics_variation=6}, {x=-24.41015625, y=-13.5703125, graphics_variation=6}, {x=12.54296875, y=-13.72265625, graphics_variation=3}, {x=61.34375, y=-14.546875, graphics_variation=4}, {x=62.2734375, y=-13.7578125, graphics_variation=2}, {x=63.62109375, y=-13.98828125, graphics_variation=3}, {x=64.78125, y=-14.265625, graphics_variation=7}, {x=70.5703125, y=-12.96875, graphics_variation=8}, {x=74.0078125, y=-14.22265625, graphics_variation=2}, {x=-86.9140625, y=-10.5625, graphics_variation=2}, {x=-82.19140625, y=-10.7109375, graphics_variation=4}, {x=-54.33984375, y=-10.55859375, graphics_variation=5}, {x=61.30078125, y=-11.71484375, graphics_variation=8}, {x=62.2734375, y=-12.50390625, graphics_variation=4}, {x=-22.03515625, y=-10.46875, graphics_variation=7}, {x=74.359375, y=-9.1953125, graphics_variation=4}, {x=84.390625, y=-4.890625, graphics_variation=8}, {x=-71.54296875, y=-4.359375, graphics_variation=7}, {x=12.56640625, y=-2.62109375, graphics_variation=5}, {x=84.27734375, y=-3.8984375, graphics_variation=7}, {x=-33.50390625, y=-2.07421875, graphics_variation=4}, {x=-75.27734375, y=1.296875, graphics_variation=8}, {x=-45.56640625, y=-0.04296875, graphics_variation=3}, {x=-37.4140625, y=0.06640625, graphics_variation=4}, {x=14.609375, y=6.1328125, graphics_variation=1}, {x=62.546875, y=7.4140625, graphics_variation=4}, {x=12.3984375, y=7.96875, graphics_variation=5}, {x=67.7109375, y=8.24609375, graphics_variation=6}, {x=67.29296875, y=11.1796875, graphics_variation=4}, {x=67.5234375, y=9.80859375, graphics_variation=3}, {x=87.6171875, y=9.546875, graphics_variation=8}, {x=12.33203125, y=12.140625, graphics_variation=6}, {x=65.3125, y=11.8671875, graphics_variation=1}, {x=65.46484375, y=13.42578125, graphics_variation=1}, {x=67.67578125, y=12.32421875, graphics_variation=7}, {x=84.95703125, y=11.48828125, graphics_variation=8}, {x=12.47265625, y=13.953125, graphics_variation=6}, {x=67.25390625, y=13.921875, graphics_variation=3}, {x=81.58984375, y=13.921875, graphics_variation=1}, {x=-71.546875, y=16.32421875, graphics_variation=1}, {x=-37.46875, y=16.9765625, graphics_variation=5}, {x=81.53125, y=16.2734375, graphics_variation=7}, {x=65.38671875, y=18.32421875, graphics_variation=3}, {x=-71.48828125, y=21.21875, graphics_variation=4}, {x=-33.65625, y=19.5234375, graphics_variation=2}, {x=-86.68359375, y=23.68359375, graphics_variation=7}, {x=-22.0625, y=23.66015625, graphics_variation=8}, {x=-52.546875, y=27.42578125, graphics_variation=7}, {x=-48.3515625, y=26.46875, graphics_variation=5}, {x=-43.18359375, y=27.4453125, graphics_variation=3}, {x=-41.0703125, y=27.28125, graphics_variation=8}, {x=70.609375, y=26.7421875, graphics_variation=7}, {x=-49.953125, y=29.39453125, graphics_variation=4}, {x=81.109375, y=29.43359375, graphics_variation=6}, {x=81.3359375, y=28.2421875, graphics_variation=2}, {x=12.44140625, y=30.13671875, graphics_variation=3}, {x=67.25, y=31.43359375, graphics_variation=1}, {x=-87.3125, y=31.97265625, graphics_variation=6}, {x=-75.58203125, y=32.90625, graphics_variation=4}, {x=-72.34375, y=31.625, graphics_variation=2}, {x=-36.44921875, y=31.671875, graphics_variation=7}, {x=12.59375, y=32.0078125, graphics_variation=3}, {x=67.5234375, y=32.57421875, graphics_variation=6}, {x=81.5625, y=31.640625, graphics_variation=3}, {x=84.4765625, y=33.16796875, graphics_variation=5}, {x=81.64453125, y=33.5078125, graphics_variation=1}, {x=65.48828125, y=35.47265625, graphics_variation=1}, {x=65.73046875, y=36.74609375, graphics_variation=3}, {x=84.421875, y=35.48828125, graphics_variation=4}, {x=-68.03515625, y=38.48046875, graphics_variation=4}, {x=65.8359375, y=37.8515625, graphics_variation=7}, {x=-84.45703125, y=39.68359375, graphics_variation=5}, {x=12.64453125, y=39.81640625, graphics_variation=6}, {x=65.59375, y=39.75, graphics_variation=4}, {x=-65.46484375, y=42.51953125, graphics_variation=4}, {x=9.65625, y=43.4296875, graphics_variation=7}, {x=87.6484375, y=42.90234375, graphics_variation=5}, {x=0.78515625, y=44.73046875, graphics_variation=3}, {x=9.296875, y=45.35546875, graphics_variation=3}, {x=8.32421875, y=44.37890625, graphics_variation=8}, {x=-86.43359375, y=46.56640625, graphics_variation=1}, {x=6.3046875, y=45.90625, graphics_variation=7}, {x=9.7578125, y=46.66015625, graphics_variation=8}, {x=40.2890625, y=47.28515625, graphics_variation=6}, {x=-79.4375, y=48.37890625, graphics_variation=7}, {x=-13.63671875, y=48.421875, graphics_variation=1}, {x=2.61328125, y=48.90625, graphics_variation=6}, {x=20.4765625, y=47.53515625, graphics_variation=6}, {x=23.04296875, y=47.63671875, graphics_variation=4}, {x=24.52734375, y=47.48046875, graphics_variation=4}, {x=36.61328125, y=47.6015625, graphics_variation=2}, {x=39.0234375, y=49.4375, graphics_variation=6}, {x=38.2890625, y=48.2578125, graphics_variation=6}, {x=39.62109375, y=48.20703125, graphics_variation=7}, {x=84.3828125, y=48.921875, graphics_variation=2}, {x=-86.41015625, y=49.5390625, graphics_variation=3}, {x=-27.3984375, y=50.640625, graphics_variation=3}, {x=-18.34765625, y=51.44140625, graphics_variation=8}, {x=33.74609375, y=49.671875, graphics_variation=5}, {x=43.26953125, y=49.6015625, graphics_variation=7}, {x=42.16796875, y=49.73828125, graphics_variation=3}, {x=-69.32421875, y=51.671875, graphics_variation=1}, {x=-27.3984375, y=52.49609375, graphics_variation=1}, {x=18.9140625, y=52.30078125, graphics_variation=4}, {x=27.3984375, y=52.48046875, graphics_variation=6}, {x=41.6484375, y=52.671875, graphics_variation=4}, {x=47.859375, y=52.984375, graphics_variation=3}, {x=49.5859375, y=52.87890625, graphics_variation=1}, {x=53, y=52.6015625, graphics_variation=5}, {x=68.140625, y=52.328125, graphics_variation=1}, {x=69.625, y=52.4296875, graphics_variation=5}, {x=71.73046875, y=52.2578125, graphics_variation=8}, {x=80.875, y=52.71484375, graphics_variation=3}, {x=-77.4609375, y=54.57421875, graphics_variation=7}, {x=-18.52734375, y=54.078125, graphics_variation=8}, {x=16.9921875, y=54.53125, graphics_variation=3}, {x=-28.45703125, y=56.6328125, graphics_variation=1}, {x=9.68359375, y=56.46875, graphics_variation=3}, {x=29.7421875, y=55.625, graphics_variation=7}, {x=-72.5390625, y=58.59375, graphics_variation=1}, {x=13.734375, y=58.62109375, graphics_variation=6}, {x=44.203125, y=59.38671875, graphics_variation=6}, {x=63.8359375, y=59.33203125, graphics_variation=2}, {x=-86.25, y=60.37890625, graphics_variation=4}, {x=75.46875, y=59.81640625, graphics_variation=8}, {x=84.52734375, y=59.578125, graphics_variation=6}, {x=-82.46484375, y=61.58203125, graphics_variation=6}, {x=-77.39453125, y=62.79296875, graphics_variation=7}, {x=-63.359375, y=62.546875, graphics_variation=7}, {x=79.76171875, y=61.48046875, graphics_variation=6}, {x=-82.39453125, y=63.578125, graphics_variation=5}, {x=-28.36328125, y=64.41015625, graphics_variation=7}, {x=26.0859375, y=64.37109375, graphics_variation=6}, {x=27.3046875, y=65.01953125, graphics_variation=1}, {x=33.65234375, y=64.125, graphics_variation=6}, {x=-82.44140625, y=66.52734375, graphics_variation=4}, {x=27.50390625, y=67.28515625, graphics_variation=6}, {x=33.609375, y=66.81640625, graphics_variation=6}, {x=33.56640625, y=65.5546875, graphics_variation=5}, {x=80.1875, y=65.53515625, graphics_variation=6}, {x=82.421875, y=65.87109375, graphics_variation=1}, {x=82.9609375, y=66.7734375, graphics_variation=1}, {x=-67.640625, y=68.42578125, graphics_variation=5}, {x=-30.578125, y=68.71484375, graphics_variation=7}, {x=-30.37109375, y=67.71875, graphics_variation=6}, {x=-16.76171875, y=69.28515625, graphics_variation=8}, {x=7.68359375, y=68.27734375, graphics_variation=8}, {x=16.0390625, y=68.53125, graphics_variation=7}, {x=18.359375, y=68.5859375, graphics_variation=4}, {x=53.2109375, y=67.69140625, graphics_variation=2}, {x=80.65234375, y=68.2734375, graphics_variation=5}, {x=87.6953125, y=69.09765625, graphics_variation=8}, {x=-30.48828125, y=70.203125, graphics_variation=1}, {x=-23.00390625, y=70.6171875, graphics_variation=8}, {x=-21.8671875, y=70.17578125, graphics_variation=3}, {x=15.64453125, y=69.55078125, graphics_variation=1}, {x=19.3515625, y=70.73828125, graphics_variation=8}, {x=25.51953125, y=69.97265625, graphics_variation=5}, {x=82.44921875, y=69.7734375, graphics_variation=1}, {x=87.6328125, y=70.16015625, graphics_variation=2}, {x=-83.28515625, y=73.28125, graphics_variation=2}, {x=36.30859375, y=73.125, graphics_variation=1}, {x=87.8515625, y=72.41015625, graphics_variation=7}, {x=-80.3359375, y=74.046875, graphics_variation=4}, {x=-83.40234375, y=75.48828125, graphics_variation=4}, {x=40.24609375, y=76.41015625, graphics_variation=6}, {x=45.36328125, y=76.4921875, graphics_variation=4}, {x=44.17578125, y=76.37890625, graphics_variation=7}, {x=54.57421875, y=76.4609375, graphics_variation=1}, {x=58.7265625, y=76.28125, graphics_variation=1}, {x=65.41796875, y=76.58203125, graphics_variation=4}, {x=67.1171875, y=76.41015625, graphics_variation=8}, {x=77.0234375, y=76.6640625, graphics_variation=7}, {x=-34.390625, y=78.46484375, graphics_variation=1}, {x=-27.6484375, y=78.796875, graphics_variation=7}, {x=-34.49609375, y=79.6953125, graphics_variation=1}, {x=-22.46875, y=80.640625, graphics_variation=8}, {x=84.7109375, y=81.30859375, graphics_variation=3}, {x=76.7265625, y=81.91015625, graphics_variation=6}, {x=78.796875, y=82.9765625, graphics_variation=8}, {x=84.5390625, y=83.0625, graphics_variation=1}, {x=-22.390625, y=83.6171875, graphics_variation=6}, {x=36.38671875, y=85.3515625, graphics_variation=1}, {x=43.6875, y=85.2578125, graphics_variation=5}, {x=-57.328125, y=87.40234375, graphics_variation=5}, {x=27.35546875, y=86.9453125, graphics_variation=4}, {x=44.29296875, y=86.74609375, graphics_variation=7}, {x=60.4375, y=85.6640625, graphics_variation=6}, {x=75.96484375, y=87.4296875, graphics_variation=7}, {x=84.47265625, y=87.140625, graphics_variation=2}, {x=-55.4140625, y=87.546875, graphics_variation=4}, {x=5.53125, y=89.28515625, graphics_variation=4}, {x=5.78125, y=87.62890625, graphics_variation=5}, {x=62.69921875, y=88.71875, graphics_variation=3}, {x=78.59765625, y=88.84375, graphics_variation=6}, {x=87.52734375, y=88.0390625, graphics_variation=3}, {x=-57.3515625, y=89.62890625, graphics_variation=7}, {x=-55.4140625, y=89.546875, graphics_variation=5}, {x=36.6484375, y=89.74609375, graphics_variation=6}, {x=45.5, y=89.671875, graphics_variation=7}, {x=82.84375, y=89.484375, graphics_variation=6}, {x=83.09765625, y=90.6171875, graphics_variation=7}, {x=84.1171875, y=90.67578125, graphics_variation=4}, {x=84.23046875, y=89.76953125, graphics_variation=1}, {x=-33.33203125, y=91.44921875, graphics_variation=3}, {x=4.0625, y=92.59765625, graphics_variation=2}, {x=33.6953125, y=92.89453125, graphics_variation=6}, {x=64.3125, y=92.7421875, graphics_variation=3}, {x=83.2109375, y=91.9765625, graphics_variation=5}, {x=-81.3359375, y=94.60546875, graphics_variation=4}, {x=33.2734375, y=93.984375, graphics_variation=6}, {x=33.57421875, y=95.34765625, graphics_variation=3}, {x=82.671875, y=93.90234375, graphics_variation=4}, {x=7.5078125, y=95.84765625, graphics_variation=6}, {x=48.703125, y=95.66015625, graphics_variation=8}, {x=60.578125, y=96.9140625, graphics_variation=3}, {x=-12.3046875, y=97.48046875, graphics_variation=6}, {x=5.625, y=98.31640625, graphics_variation=3}, {x=33.359375, y=97.6015625, graphics_variation=5}, {x=33.609375, y=98.73828125, graphics_variation=1}, {x=46.1484375, y=99.328125, graphics_variation=1}, {x=60.46484375, y=98.2421875, graphics_variation=4}, {x=-58.3125, y=99.63671875, graphics_variation=4}, {x=-42.5625, y=100.453125, graphics_variation=4}, {x=25.2890625, y=99.72265625, graphics_variation=8}, {x=52.32421875, y=100.3046875, graphics_variation=5}, {x=-50.5625, y=103.16796875, graphics_variation=8}, {x=68.5859375, y=102.9296875, graphics_variation=6}, {x=84.73828125, y=101.5703125, graphics_variation=1}, {x=16.6015625, y=104.87890625, graphics_variation=6}, {x=87.3359375, y=103.93359375, graphics_variation=2}, {x=87.48828125, y=105.3828125, graphics_variation=7}, {x=-84.6171875, y=106.5390625, graphics_variation=8}, {x=-73.33203125, y=106.61328125, graphics_variation=1}, {x=-68.48828125, y=105.45703125, graphics_variation=5}, {x=-44.671875, y=107.37109375, graphics_variation=6}, {x=-30.41796875, y=105.87890625, graphics_variation=6}, {x=5.3515625, y=106.34765625, graphics_variation=6}, {x=21.5078125, y=107.25390625, graphics_variation=3}, {x=36.43359375, y=107.390625, graphics_variation=2}, {x=37.875, y=106.796875, graphics_variation=8}, {x=50.0234375, y=106.25390625, graphics_variation=4}, {x=56.80078125, y=106.578125, graphics_variation=3}, {x=57.97265625, y=106.546875, graphics_variation=8}, {x=74.4375, y=106.55078125, graphics_variation=1}, {x=78.484375, y=106.58203125, graphics_variation=3}, {x=5.2578125, y=107.59765625, graphics_variation=3}, {x=16.0078125, y=107.56640625, graphics_variation=6}, {x=29.3203125, y=108.25, graphics_variation=2}, {x=36.88671875, y=108.63671875, graphics_variation=2}, {x=68.53125, y=108.4765625, graphics_variation=8}, {x=87.6015625, y=109.078125, graphics_variation=2}, {x=5.4765625, y=110.03515625, graphics_variation=6}, {x=29.2890625, y=110.91015625, graphics_variation=2}, {x=33.30859375, y=110.171875, graphics_variation=1}, {x=33.48046875, y=111.078125, graphics_variation=4}, {x=84.23046875, y=110.55859375, graphics_variation=4}, {x=87.6015625, y=110.18359375, graphics_variation=2}, {x=-62.41015625, y=113.34765625, graphics_variation=5}, {x=5.2890625, y=113.19140625, graphics_variation=4}, {x=5.2890625, y=112.09765625, graphics_variation=1}, {x=29.3203125, y=112.91796875, graphics_variation=7}, {x=29.515625, y=111.81640625, graphics_variation=4}, {x=33.734375, y=112.01171875, graphics_variation=7}, {x=-61.5625, y=114.46484375, graphics_variation=5}, {x=-61.3515625, y=113.50390625, graphics_variation=3}, {x=-62.5390625, y=114.265625, graphics_variation=8}, {x=17.703125, y=115.3671875, graphics_variation=2}, {x=36.3203125, y=113.87109375, graphics_variation=8}, {x=72.54296875, y=114.3515625, graphics_variation=1}, {x=82.65625, y=114.3125, graphics_variation=6}, {x=-80.47265625, y=115.4765625, graphics_variation=6}, {x=-72.125, y=115.66796875, graphics_variation=4}, {x=-55.75, y=117.24609375, graphics_variation=6}, {x=-50.01953125, y=115.46875, graphics_variation=6}, {x=-38.68359375, y=115.60546875, graphics_variation=6}, {x=-33.21875, y=115.625, graphics_variation=1}, {x=7.015625, y=116.78515625, graphics_variation=7}, {x=54.6640625, y=115.9296875, graphics_variation=1}, {x=59.734375, y=116.30859375, graphics_variation=7}, {x=74.58203125, y=115.9921875, graphics_variation=8}, {x=-80.453125, y=117.51953125, graphics_variation=2}, {x=7.10546875, y=119.03515625, graphics_variation=8}, {x=7.7578125, y=118.12890625, graphics_variation=6}, {x=29.3515625, y=118.18359375, graphics_variation=7}, {x=38.171875, y=119.26953125, graphics_variation=3}, {x=91.0703125, y=119.34765625, graphics_variation=3}, {x=-79.0234375, y=120.375, graphics_variation=1}, {x=3.4453125, y=120.81640625, graphics_variation=6}, {x=5.34375, y=121.078125, graphics_variation=1}, {x=7.19921875, y=120.73046875, graphics_variation=1}, {x=6.109375, y=120.08203125, graphics_variation=6}, {x=15.5625, y=119.94921875, graphics_variation=7}, {x=25.3828125, y=119.58984375, graphics_variation=3}, {x=27.7578125, y=120.68359375, graphics_variation=2}, {x=52.50390625, y=121.3125, graphics_variation=3}, {x=56.625, y=120.890625, graphics_variation=5}, {x=84.58203125, y=120.51171875, graphics_variation=1}, {x=83.67578125, y=120.3984375, graphics_variation=4}, {x=5.25, y=122.0078125, graphics_variation=8}, {x=36.515625, y=121.734375, graphics_variation=6}, {x=36.57421875, y=122.83203125, graphics_variation=8}, {x=84.49609375, y=121.55859375, graphics_variation=1}, {x=91.640625, y=121.75, graphics_variation=1}, {x=5.3828125, y=124.06640625, graphics_variation=5}, {x=44.78125, y=124.640625, graphics_variation=4}, {x=-65.41015625, y=127.4375, graphics_variation=1}, {x=-40.48046875, y=127.203125, graphics_variation=7}, {x=-39.30078125, y=126.3828125, graphics_variation=5}, {x=-38.09765625, y=127.0234375, graphics_variation=6}, {x=49.11328125, y=126.140625, graphics_variation=4}, {x=76.6953125, y=127.2578125, graphics_variation=3}, {x=-68.640625, y=129.20703125, graphics_variation=8}, {x=-62.3671875, y=128.62890625, graphics_variation=8}, {x=-39.5078125, y=127.6640625, graphics_variation=4}, {x=-36.2265625, y=127.6875, graphics_variation=4}, {x=-26.92578125, y=130.34765625, graphics_variation=3}, {x=0.609375, y=130.05859375, graphics_variation=7}, {x=2.890625, y=130.93359375, graphics_variation=1}, {x=5.953125, y=130.83984375, graphics_variation=5}, {x=29.7734375, y=129.8828125, graphics_variation=1}, {x=33.55859375, y=130.98046875, graphics_variation=1}, {x=-27.2265625, y=132.85546875, graphics_variation=4}, {x=-26.6015625, y=131.7734375, graphics_variation=5}, {x=33.4921875, y=133.015625, graphics_variation=5}, {x=33.6953125, y=131.91015625, graphics_variation=2}, {x=36.26171875, y=132.99609375, graphics_variation=4}, {x=52.5546875, y=131.5546875, graphics_variation=2}, {x=-53.234375, y=135.24609375, graphics_variation=8}, {x=-46.265625, y=135.24609375, graphics_variation=6}, {x=-44.453125, y=135.37109375, graphics_variation=6}, {x=-27.296875, y=133.78125, graphics_variation=5}, {x=-7.02734375, y=135.3203125, graphics_variation=5}, {x=33.62890625, y=134.32421875, graphics_variation=5}, {x=60.6015625, y=133.6015625, graphics_variation=4}, {x=72.40234375, y=133.625, graphics_variation=7}, {x=-45.359375, y=136.02734375, graphics_variation=8}, {x=-39.140625, y=137.33984375, graphics_variation=1}, {x=-29.890625, y=136.18359375, graphics_variation=3}, {x=-21.33984375, y=136.84765625, graphics_variation=4}, {x=-18.75390625, y=137.3125, graphics_variation=8}, {x=-19.296875, y=135.50390625, graphics_variation=7}, {x=-17.4921875, y=136.59765625, graphics_variation=8}, {x=-12.671875, y=136.52734375, graphics_variation=2}, {x=0.88671875, y=135.53125, graphics_variation=4}, {x=-0.54296875, y=135.63671875, graphics_variation=5}, {x=10.640625, y=137.40234375, graphics_variation=2}, {x=11.203125, y=135.77734375, graphics_variation=1}, {x=12.109375, y=135.80859375, graphics_variation=5}, {x=13.265625, y=135.90234375, graphics_variation=8}, {x=17.703125, y=136.08984375, graphics_variation=4}, {x=21.953125, y=136.80859375, graphics_variation=8}, {x=62.5234375, y=136.39453125, graphics_variation=3}, {x=63.4921875, y=136.26953125, graphics_variation=4}, {x=70.48828125, y=137.1328125, graphics_variation=8}, {x=87.3359375, y=135.61328125, graphics_variation=5}, {x=87.48828125, y=137.0625, graphics_variation=1}, {x=-41.171875, y=137.68359375, graphics_variation=8}, {x=-22.28515625, y=137.54296875, graphics_variation=1}, {x=-17.23828125, y=137.66796875, graphics_variation=7}, {x=20.765625, y=137.68359375, graphics_variation=3}, {x=53.66015625, y=137.5, graphics_variation=5}, {x=70.7734375, y=138.6875, graphics_variation=2}, {x=-54.125, y=141.12109375, graphics_variation=5}, {x=-41.796875, y=141.1875, graphics_variation=7}, {x=7.578125, y=140.44921875, graphics_variation=3}, {x=19.56640625, y=140.7421875, graphics_variation=8}, {x=44.5546875, y=140.80078125, graphics_variation=2}, {x=60.7109375, y=140.45703125, graphics_variation=1}, {x=63.0546875, y=140.67578125, graphics_variation=7}, {x=70.26171875, y=140.69921875, graphics_variation=6}, {x=80.69921875, y=140.77734375, graphics_variation=2}, {x=59.3359375, y=142.17578125, graphics_variation=4}, {x=76.6875, y=142.21484375, graphics_variation=3}, {x=-21.3671875, y=146.40234375, graphics_variation=2}, {x=73.72265625, y=145.5859375, graphics_variation=2}, {x=-16.421875, y=148.28125, graphics_variation=6}, {x=-7.7265625, y=148.55859375, graphics_variation=1}, {x=53.078125, y=151.1484375, graphics_variation=1}, {x=62.5625, y=150.84375, graphics_variation=3}, {x=63.58984375, y=151.30078125, graphics_variation=8}, {x=80.4921875, y=151.30078125, graphics_variation=6}, {x=91.578125, y=150.73046875, graphics_variation=8}, {x=64.9609375, y=151.64453125, graphics_variation=4}, {x=76.60546875, y=151.68359375, graphics_variation=1}, {x=82.28125, y=151.68359375, graphics_variation=8}, {x=91.12109375, y=151.64453125, graphics_variation=6}, },
    ["dead-tree-desert"] = {{x=-76.61328125, y=-126.16796875, graphics_variation=1}, {x=-86.5390625, y=-117.3125, graphics_variation=4}, {x=-27.921875, y=-117.9765625, graphics_variation=3}, {x=3.83984375, y=-106.90234375, graphics_variation=4}, {x=-53.47265625, y=-104.88671875, graphics_variation=1}, {x=-72.03515625, y=-102.9765625, graphics_variation=5}, {x=-28.3046875, y=-100.75390625, graphics_variation=7}, {x=-58.13671875, y=-99.09765625, graphics_variation=1}, {x=50.5078125, y=-100.01171875, graphics_variation=4}, {x=6.8671875, y=-97.7265625, graphics_variation=2}, {x=14.1640625, y=-96.85546875, graphics_variation=7}, {x=28.1953125, y=-95.0078125, graphics_variation=6}, {x=50.5390625, y=-91.07421875, graphics_variation=4}, {x=39.80859375, y=-88.546875, graphics_variation=5}, {x=5.38671875, y=-84.68359375, graphics_variation=6}, {x=-4.63671875, y=-82.94140625, graphics_variation=7}, {x=0.2578125, y=-83.8125, graphics_variation=3}, {x=9.87109375, y=-84.0703125, graphics_variation=8}, {x=-24.828125, y=-82.04296875, graphics_variation=8}, {x=-19.39453125, y=-81.6328125, graphics_variation=3}, {x=-14.8828125, y=-81.8125, graphics_variation=4}, {x=-10.55859375, y=-82.2734375, graphics_variation=10}, {x=-78.8125, y=-80.19921875, graphics_variation=7}, {x=-29.87890625, y=-78.9921875, graphics_variation=9}, {x=0.15625, y=-79.4296875, graphics_variation=1}, {x=5.0546875, y=-79.9921875, graphics_variation=5}, {x=-34.87890625, y=-77.5078125, graphics_variation=9}, {x=-10.1484375, y=-77.63671875, graphics_variation=3}, {x=-5.046875, y=-77.96875, graphics_variation=8}, {x=-30.0078125, y=-74.66015625, graphics_variation=4}, {x=5.2578125, y=-75.91796875, graphics_variation=8}, {x=47.265625, y=-76.24609375, graphics_variation=10}, {x=-35.16015625, y=-74.09765625, graphics_variation=1}, {x=17.87890625, y=-72.84765625, graphics_variation=8}, {x=79.125, y=-73.92578125, graphics_variation=1}, {x=84.05078125, y=-72.0859375, graphics_variation=7}, {x=84.0234375, y=-69.87890625, graphics_variation=1}, {x=-79.8046875, y=-57.1015625, graphics_variation=5}, {x=-34.421875, y=-52.30078125, graphics_variation=1}, {x=-71.98828125, y=-46.74609375, graphics_variation=3}, {x=-24.38671875, y=-41.4921875, graphics_variation=4}, {x=-73.3359375, y=-39.21875, graphics_variation=8}, {x=-76.53125, y=-36.98828125, graphics_variation=4}, {x=-74.63671875, y=-37.7890625, graphics_variation=3}, {x=-72.74609375, y=-34.21484375, graphics_variation=2}, {x=-8.51171875, y=-33.2734375, graphics_variation=2}, {x=84.41796875, y=-33.0078125, graphics_variation=2}, {x=-13.04296875, y=-30.52734375, graphics_variation=9}, {x=24.0625, y=-30.12890625, graphics_variation=4}, {x=28.51171875, y=-28.61328125, graphics_variation=4}, {x=-10.18359375, y=-25.03515625, graphics_variation=6}, {x=23.75, y=-21.1953125, graphics_variation=3}, {x=28.4765625, y=-20.43359375, graphics_variation=3}, {x=45.9140625, y=-22.171875, graphics_variation=3}, {x=26.71875, y=-16.36328125, graphics_variation=5}, {x=3.5390625, y=-13.609375, graphics_variation=7}, {x=-13.43359375, y=-6.46484375, graphics_variation=3}, {x=0.921875, y=-7.25390625, graphics_variation=3}, {x=-2.21875, y=-3.76953125, graphics_variation=6}, {x=-95.44921875, y=0.56640625, graphics_variation=9}, {x=-0.60546875, y=0.4140625, graphics_variation=8}, {x=-1.91015625, y=23.8671875, graphics_variation=3}, {x=91.125, y=53.2109375, graphics_variation=9}, {x=-57.51953125, y=141.3828125, graphics_variation=2}, {x=-45.99609375, y=141.0703125, graphics_variation=9}, {x=-50.9296875, y=141.69140625, graphics_variation=7}, {x=-59.12109375, y=146.171875, graphics_variation=8}, {x=-53.32421875, y=146.06640625, graphics_variation=1}, {x=-46.1484375, y=146.1015625, graphics_variation=10}, {x=-39.73046875, y=146.4453125, graphics_variation=7}, {x=-33.0390625, y=146.34375, graphics_variation=9}, {x=41.4453125, y=145.7734375, graphics_variation=6}, {x=48.68359375, y=146.078125, graphics_variation=3}, {x=57.140625, y=145.88671875, graphics_variation=5}, {x=67.03125, y=145.7734375, graphics_variation=9}, {x=75.4140625, y=145.7734375, graphics_variation=2}, {x=81.96484375, y=146, graphics_variation=4}, {x=-21.09765625, y=149.60546875, graphics_variation=9}, },
    ["huge-rock-beige"] = {{x=-77.51171875, y=-118.7109375, graphics_variation=15}, {x=59.4296875, y=-103.984375, graphics_variation=2}, {x=-87.66796875, y=-98.6796875, graphics_variation=4}, {x=-6.17578125, y=-95.66015625, graphics_variation=11}, {x=33.68359375, y=-95.23046875, graphics_variation=14}, {x=26.71484375, y=-92.83203125, graphics_variation=8}, {x=-73.34375, y=-86.3828125, graphics_variation=8}, {x=0.4765625, y=-87.76171875, graphics_variation=13}, {x=-38.60546875, y=-80.0390625, graphics_variation=9}, {x=-83.43359375, y=-79.10546875, graphics_variation=3}, {x=86.55078125, y=-76.5625, graphics_variation=6}, {x=21.44921875, y=-72.47265625, graphics_variation=12}, {x=74.68359375, y=-67.26953125, graphics_variation=9}, {x=-83.3046875, y=-59.4921875, graphics_variation=11}, {x=-16.5859375, y=-52.234375, graphics_variation=12}, {x=-73.1796875, y=-43.5078125, graphics_variation=9}, {x=-28.1953125, y=-42.0703125, graphics_variation=14}, {x=88.41796875, y=-35.23046875, graphics_variation=1}, {x=-46.33203125, y=-31.4296875, graphics_variation=2}, {x=25.953125, y=-27.8515625, graphics_variation=3}, {x=6.0703125, y=8.16796875, graphics_variation=2}, {x=3.484375, y=17.44921875, graphics_variation=11}, {x=3.50390625, y=28.52734375, graphics_variation=16}, {x=-94.38671875, y=44.1640625, graphics_variation=12}, {x=-84.4765625, y=80.89453125, graphics_variation=8}, {x=-69.9921875, y=85.5859375, graphics_variation=4}, {x=-84.32421875, y=87.6953125, graphics_variation=4}, {x=-61.0625, y=141.02734375, graphics_variation=10}, {x=18.68359375, y=143.18359375, graphics_variation=5}, {x=-66.6875, y=149.89453125, graphics_variation=7}, {x=86.765625, y=150.56640625, graphics_variation=13}, },
    ["sand-decal-tan-ruin"] = {{x=-76.79296875, y=-116.49609375, graphics_variation=17}, {x=3.34375, y=-103.74609375, graphics_variation=14}, {x=-81.7890625, y=-102.1640625, graphics_variation=8}, {x=66.296875, y=-101.51953125, graphics_variation=18}, {x=70.09375, y=-100.79296875, graphics_variation=24}, {x=-5.64453125, y=-97.44140625, graphics_variation=9}, {x=78.58984375, y=-97.8359375, graphics_variation=21}, {x=-1.46875, y=-87.1640625, graphics_variation=26}, {x=3.65234375, y=-87.67578125, graphics_variation=23}, {x=67.8203125, y=-87.25, graphics_variation=23}, {x=-72.16796875, y=-77.79296875, graphics_variation=18}, {x=37.703125, y=-74.49609375, graphics_variation=21}, {x=47.6875, y=-74.95703125, graphics_variation=22}, {x=19.3671875, y=-72.73828125, graphics_variation=2}, {x=-78.3125, y=-57.578125, graphics_variation=2}, {x=-65.1796875, y=-57.83984375, graphics_variation=23}, {x=66.484375, y=-57.9296875, graphics_variation=13}, {x=79.390625, y=-56.86328125, graphics_variation=20}, {x=74.97265625, y=-53.171875, graphics_variation=17}, {x=-14.0078125, y=-51.9765625, graphics_variation=8}, {x=-68.265625, y=-47.08203125, graphics_variation=29}, {x=29.5, y=-41.22265625, graphics_variation=23}, {x=33.73046875, y=-41.46875, graphics_variation=11}, {x=46.78515625, y=-41.41796875, graphics_variation=16}, {x=64.859375, y=-41.08203125, graphics_variation=29}, {x=-26.67578125, y=-40.33203125, graphics_variation=22}, {x=-76.80078125, y=-34.328125, graphics_variation=26}, {x=-44.9453125, y=-29.94140625, graphics_variation=24}, {x=-81.03125, y=-21.14453125, graphics_variation=2}, {x=-31.1953125, y=-20.80859375, graphics_variation=16}, {x=-33.47265625, y=-5.75390625, graphics_variation=23}, {x=-89.53515625, y=17.40234375, graphics_variation=30}, {x=-75.921875, y=23.42578125, graphics_variation=12}, {x=1.89453125, y=56.75, graphics_variation=18}, {x=43.38671875, y=60.5, graphics_variation=28}, {x=52.5546875, y=59.16796875, graphics_variation=11}, {x=55.33203125, y=60.92578125, graphics_variation=3}, {x=65.30078125, y=60.21875, graphics_variation=26}, {x=73.43359375, y=60.74609375, graphics_variation=11}, {x=9.44921875, y=63.5859375, graphics_variation=12}, {x=37.83203125, y=64.62890625, graphics_variation=10}, {x=-91.71875, y=71.5390625, graphics_variation=18}, {x=36.6328125, y=72.6796875, graphics_variation=26}, {x=7.7734375, y=73.26171875, graphics_variation=10}, {x=26.84765625, y=76.9609375, graphics_variation=11}, {x=-91.53125, y=77.95703125, graphics_variation=11}, {x=-83.40234375, y=78.046875, graphics_variation=30}, {x=5.24609375, y=81.41015625, graphics_variation=26}, {x=65.95703125, y=87.95703125, graphics_variation=24}, {x=26.3125, y=91.29296875, graphics_variation=24}, {x=26.5078125, y=99.3515625, graphics_variation=30}, {x=65.890625, y=101.0625, graphics_variation=6}, {x=79.5546875, y=101.8984375, graphics_variation=8}, {x=-90.55859375, y=106.26953125, graphics_variation=13}, {x=53.5703125, y=110.44140625, graphics_variation=9}, {x=26.70703125, y=114.828125, graphics_variation=21}, {x=-82.1640625, y=116.13671875, graphics_variation=7}, {x=83.88671875, y=115.421875, graphics_variation=22}, {x=-30.41796875, y=121.52734375, graphics_variation=10}, {x=-0.83203125, y=121.30859375, graphics_variation=11}, {x=26.734375, y=122.55078125, graphics_variation=13}, {x=83.3203125, y=122.796875, graphics_variation=15}, {x=-0.86328125, y=130.734375, graphics_variation=19}, {x=26.46484375, y=130.515625, graphics_variation=27}, {x=83.24609375, y=131.1953125, graphics_variation=30}, {x=-17.28515625, y=133.38671875, graphics_variation=18}, {x=65.70703125, y=137.3359375, graphics_variation=10}, {x=82.3359375, y=137.94921875, graphics_variation=12}, {x=-55.14453125, y=140.49609375, graphics_variation=23}, {x=-41.5, y=140.0546875, graphics_variation=7}, {x=49.84765625, y=141.80859375, graphics_variation=22}, {x=53.08984375, y=141.81640625, graphics_variation=8}, {x=67.50390625, y=141.609375, graphics_variation=3}, {x=83.76171875, y=141.13671875, graphics_variation=13}, {x=6.01953125, y=143.5625, graphics_variation=27}, {x=61.98046875, y=145.6796875, graphics_variation=8}, {x=63.62109375, y=145.421875, graphics_variation=5}, {x=-15.8203125, y=148.359375, graphics_variation=7}, {x=89.36328125, y=151.03515625, graphics_variation=13}, },
    ["dry-tree"] = {{x=-73.359375, y=-114.515625, graphics_variation=7}, {x=-67.890625, y=-113.9921875, graphics_variation=6}, {x=-59.7734375, y=-112.6875, graphics_variation=8}, {x=-52.8828125, y=-112.45703125, graphics_variation=6}, {x=-76.91015625, y=-111.44921875, graphics_variation=5}, {x=-71.1484375, y=-111.171875, graphics_variation=4}, {x=-66.23046875, y=-110.921875, graphics_variation=6}, {x=-45.1015625, y=-110.26953125, graphics_variation=5}, {x=-64.2109375, y=-108.50390625, graphics_variation=2}, {x=-56.03125, y=-108.54296875, graphics_variation=6}, {x=-50.71875, y=-109.0703125, graphics_variation=1}, {x=-33.328125, y=-108.5234375, graphics_variation=2}, {x=-27.29296875, y=-108.48046875, graphics_variation=9}, {x=-74.11328125, y=-106.7578125, graphics_variation=5}, {x=-68.8984375, y=-107.703125, graphics_variation=1}, {x=-38.94140625, y=-107.93359375, graphics_variation=7}, {x=-21.3203125, y=-108.1875, graphics_variation=6}, {x=-15.74609375, y=-107.28125, graphics_variation=4}, {x=-77.796875, y=-104.359375, graphics_variation=2}, {x=-66.3125, y=-104.40234375, graphics_variation=1}, {x=-62.25390625, y=-105.47265625, graphics_variation=6}, {x=-48.59375, y=-104.84375, graphics_variation=7}, {x=-42.95703125, y=-106, graphics_variation=7}, {x=-35.9765625, y=-104.67578125, graphics_variation=2}, {x=-31.22265625, y=-105.07421875, graphics_variation=2}, {x=-25.56640625, y=-105.22265625, graphics_variation=5}, {x=-45.859375, y=-102.296875, graphics_variation=5}, {x=-18.54296875, y=-103.265625, graphics_variation=4}, {x=-13.01171875, y=-102.55078125, graphics_variation=2}, {x=-64.08203125, y=-101.2890625, graphics_variation=9}, {x=-60.15234375, y=-101.4765625, graphics_variation=8}, {x=-52.0546875, y=-101.60546875, graphics_variation=4}, {x=-40.9375, y=-101.8984375, graphics_variation=1}, {x=-34.1875, y=-101.79296875, graphics_variation=9}, {x=-23.9296875, y=-101.58203125, graphics_variation=8}, {x=-11.60546875, y=-100.53125, graphics_variation=6}, {x=-79.6875, y=-100.02734375, graphics_variation=6}, {x=-74.68359375, y=-98.9765625, graphics_variation=2}, {x=-70.09765625, y=-99.125, graphics_variation=4}, {x=-39.046875, y=-98.953125, graphics_variation=4}, {x=-16.71484375, y=-99.48046875, graphics_variation=4}, {x=-62.37890625, y=-97, graphics_variation=9}, {x=-49.4453125, y=-97.484375, graphics_variation=6}, {x=-26.26171875, y=-96.89453125, graphics_variation=9}, {x=-9.69140625, y=-96.4921875, graphics_variation=6}, {x=-77.015625, y=-95.33984375, graphics_variation=5}, {x=-72.390625, y=-94.94140625, graphics_variation=3}, {x=-66.7109375, y=-94.30859375, graphics_variation=8}, {x=-48.2265625, y=-94.5390625, graphics_variation=5}, {x=-37.11328125, y=-95.80078125, graphics_variation=9}, {x=-31.49609375, y=-95.73828125, graphics_variation=8}, {x=-14.71875, y=-95.31640625, graphics_variation=7}, {x=-60.61328125, y=-93.40234375, graphics_variation=1}, {x=-29.984375, y=-92.33203125, graphics_variation=4}, {x=-24.8515625, y=-93.296875, graphics_variation=9}, {x=-19.08984375, y=-93.9921875, graphics_variation=5}, {x=-74.2421875, y=-90.87890625, graphics_variation=1}, {x=-45.7890625, y=-90.2890625, graphics_variation=1}, {x=-39.046875, y=-90.41796875, graphics_variation=2}, {x=-34.41796875, y=-91.40625, graphics_variation=2}, {x=-68.7734375, y=-89.703125, graphics_variation=9}, {x=-63.34765625, y=-89.890625, graphics_variation=5}, {x=-57.33203125, y=-89.34375, graphics_variation=5}, {x=-51.55078125, y=-89.40625, graphics_variation=3}, },
    ["big-rock-beige"] = {{x=-48.3984375, y=-114.3046875, graphics_variation=2}, {x=-4, y=-109.9765625, graphics_variation=15}, {x=-82.58203125, y=-103.1796875, graphics_variation=5}, {x=10.5234375, y=-103.25390625, graphics_variation=6}, {x=33.1640625, y=-103.04296875, graphics_variation=5}, {x=7.7578125, y=-101.3671875, graphics_variation=2}, {x=56.52734375, y=-102.05078125, graphics_variation=3}, {x=58.87890625, y=-101.21875, graphics_variation=12}, {x=-53.83203125, y=-98.9921875, graphics_variation=1}, {x=1.89453125, y=-99.984375, graphics_variation=8}, {x=-7.4453125, y=-97.921875, graphics_variation=3}, {x=25.1875, y=-95.0078125, graphics_variation=10}, {x=-53.2578125, y=-86.8203125, graphics_variation=11}, {x=-51.203125, y=-86, graphics_variation=19}, {x=13.3515625, y=-84.3125, graphics_variation=6}, {x=73.62890625, y=-81.1640625, graphics_variation=5}, {x=38.8828125, y=-76.03125, graphics_variation=5}, {x=41.2578125, y=-75.9375, graphics_variation=2}, {x=44.2890625, y=-75.1875, graphics_variation=2}, {x=38.1953125, y=-73.59375, graphics_variation=20}, {x=59.015625, y=-72.7109375, graphics_variation=10}, {x=80.953125, y=-71.7734375, graphics_variation=12}, {x=-74.2265625, y=-61.88671875, graphics_variation=15}, {x=78.26171875, y=-50.2109375, graphics_variation=16}, {x=-70.48828125, y=-42.82421875, graphics_variation=8}, {x=-70.23828125, y=-40.29296875, graphics_variation=2}, {x=52.6171875, y=-40.4375, graphics_variation=7}, {x=-88.11328125, y=-39.16796875, graphics_variation=2}, {x=-9.828125, y=-28.64453125, graphics_variation=7}, {x=7.5, y=-23.8046875, graphics_variation=6}, {x=27.5234375, y=-14.5, graphics_variation=14}, {x=52.10546875, y=-15.8359375, graphics_variation=15}, {x=3.53515625, y=-12.05078125, graphics_variation=5}, {x=-11.46875, y=9.76953125, graphics_variation=12}, {x=3.0546875, y=9.578125, graphics_variation=3}, {x=-89.20703125, y=16.45703125, graphics_variation=17}, {x=-20.95703125, y=27.21875, graphics_variation=12}, {x=-2.42578125, y=28.55859375, graphics_variation=17}, {x=-85.8515625, y=64.25, graphics_variation=8}, {x=-84.0234375, y=68.9296875, graphics_variation=14}, {x=-90.75390625, y=75.28515625, graphics_variation=13}, {x=-72.109375, y=78.75, graphics_variation=12}, {x=-11.796875, y=101.796875, graphics_variation=6}, {x=-87.12109375, y=116.73828125, graphics_variation=4}, {x=61.8046875, y=122.93359375, graphics_variation=13}, {x=10.82421875, y=146.3125, graphics_variation=6}, {x=91.13671875, y=147.31640625, graphics_variation=15}, {x=39.41796875, y=151.03515625, graphics_variation=18}, },
    ["sand-decal-white-ruin"] = {{x=3.19140625, y=-109.27734375, graphics_variation=3}, {x=-5.453125, y=-107.1328125, graphics_variation=13}, {x=57.109375, y=-96.5625, graphics_variation=7}, {x=62.65625, y=-94.84765625, graphics_variation=4}, {x=65.7578125, y=-93.16015625, graphics_variation=10}, {x=73.796875, y=-92.7734375, graphics_variation=5}, {x=23.87890625, y=-91, graphics_variation=24}, {x=75.1171875, y=-90.15625, graphics_variation=30}, {x=69.69140625, y=-71.9140625, graphics_variation=26}, {x=-79.32421875, y=-68.2890625, graphics_variation=1}, {x=-79.32421875, y=-68.2890625, graphics_variation=1}, {x=-47.73828125, y=-68.83203125, graphics_variation=23}, {x=63.1015625, y=-66.90625, graphics_variation=22}, {x=-40.85546875, y=-63.08203125, graphics_variation=3}, {x=-22.71484375, y=-63.10546875, graphics_variation=23}, {x=-11.32421875, y=-63.2421875, graphics_variation=21}, {x=4.92578125, y=-63.328125, graphics_variation=3}, {x=77.0234375, y=-63.23046875, graphics_variation=5}, {x=84.45703125, y=-63.29296875, graphics_variation=21}, {x=30.35546875, y=-60.1484375, graphics_variation=23}, {x=46.1171875, y=-59.31640625, graphics_variation=20}, {x=74.48828125, y=-59.62109375, graphics_variation=22}, {x=69.87109375, y=-57.96484375, graphics_variation=9}, {x=14.79296875, y=-56.81640625, graphics_variation=28}, {x=29.0859375, y=-55.78125, graphics_variation=8}, {x=39.65625, y=-55.83203125, graphics_variation=13}, {x=46.44921875, y=-55.98046875, graphics_variation=26}, {x=69.71875, y=-53.8046875, graphics_variation=17}, {x=32.34375, y=-49.19921875, graphics_variation=20}, {x=45.07421875, y=-47.140625, graphics_variation=20}, {x=71.27734375, y=-46.7890625, graphics_variation=23}, {x=71.61328125, y=-42.34375, graphics_variation=20}, {x=12.59375, y=-37.5234375, graphics_variation=13}, {x=60.5, y=-33.921875, graphics_variation=26}, {x=63.44140625, y=-32.96484375, graphics_variation=11}, {x=12.13671875, y=-26.375, graphics_variation=22}, {x=63.80859375, y=-25.9375, graphics_variation=11}, {x=68.37890625, y=-25.7734375, graphics_variation=15}, {x=75.76953125, y=-25.12890625, graphics_variation=22}, {x=-49.83984375, y=-21.62109375, graphics_variation=29}, {x=-38.8046875, y=-21.47265625, graphics_variation=4}, {x=-63.99609375, y=-20.6796875, graphics_variation=28}, {x=67.45703125, y=-18.640625, graphics_variation=1}, {x=-70.15625, y=-15.0625, graphics_variation=23}, {x=-38.05078125, y=-15.453125, graphics_variation=8}, {x=12.50390625, y=-15.49609375, graphics_variation=29}, {x=-59.13671875, y=-14.859375, graphics_variation=8}, {x=61.29296875, y=-14.25, graphics_variation=24}, {x=-80.02734375, y=-9.3046875, graphics_variation=1}, {x=-70.53125, y=-9.05078125, graphics_variation=3}, {x=-55.12109375, y=-10.37109375, graphics_variation=2}, {x=-39.65625, y=-9.62109375, graphics_variation=19}, {x=-26.23828125, y=-9.33984375, graphics_variation=18}, {x=26.39453125, y=-4.60546875, graphics_variation=18}, {x=-66.16796875, y=-2.734375, graphics_variation=23}, {x=-32.05859375, y=-1.29296875, graphics_variation=10}, {x=12.8359375, y=-1.21875, graphics_variation=12}, {x=41.921875, y=-1.65625, graphics_variation=1}, {x=-46.79296875, y=0.9296875, graphics_variation=7}, {x=-44.81640625, y=-0.29296875, graphics_variation=10}, {x=77.375, y=0.125, graphics_variation=20}, {x=14.78515625, y=3.70703125, graphics_variation=16}, {x=52.08203125, y=3.9609375, graphics_variation=28}, {x=-84.51171875, y=5.65625, graphics_variation=11}, {x=17.04296875, y=5.08203125, graphics_variation=26}, {x=28.62890625, y=8.3515625, graphics_variation=18}, {x=55.51171875, y=7.5625, graphics_variation=2}, {x=72.78515625, y=7.87109375, graphics_variation=28}, {x=-56.9296875, y=12.953125, graphics_variation=1}, {x=-26.42578125, y=11.71484375, graphics_variation=17}, {x=58.4296875, y=11.8203125, graphics_variation=5}, {x=-71.75, y=17.015625, graphics_variation=14}, {x=22.2265625, y=17.9921875, graphics_variation=25}, {x=46.10546875, y=18.85546875, graphics_variation=26}, {x=-39.99609375, y=20.80078125, graphics_variation=3}, {x=-31.65234375, y=20.95703125, graphics_variation=12}, {x=14.11328125, y=19.51171875, graphics_variation=19}, {x=-37.09765625, y=22.5859375, graphics_variation=6}, {x=-85.41796875, y=23.9921875, graphics_variation=29}, {x=-70.9375, y=23.94921875, graphics_variation=10}, {x=-54.53515625, y=23.67578125, graphics_variation=12}, {x=-44.4921875, y=23.9453125, graphics_variation=27}, {x=-39.9453125, y=23.57421875, graphics_variation=6}, {x=50.79296875, y=26.46484375, graphics_variation=18}, {x=14.421875, y=28.34765625, graphics_variation=1}, {x=71.76953125, y=27.9296875, graphics_variation=19}, {x=41.21875, y=33.65625, graphics_variation=29}, {x=-3.98828125, y=35.7578125, graphics_variation=3}, {x=17.40625, y=36.828125, graphics_variation=24}, {x=-72.2734375, y=38.12890625, graphics_variation=12}, {x=-42.0703125, y=38.46875, graphics_variation=16}, {x=-12.6796875, y=37.26171875, graphics_variation=20}, {x=-26.61328125, y=40.921875, graphics_variation=2}, {x=-3.91015625, y=40.50390625, graphics_variation=6}, {x=28.13671875, y=39.24609375, graphics_variation=11}, {x=-50.546875, y=41.91796875, graphics_variation=10}, {x=0.5390625, y=43.30859375, graphics_variation=28}, {x=9.015625, y=44.69921875, graphics_variation=12}, {x=18.4140625, y=43.66796875, graphics_variation=30}, {x=55.43359375, y=43.2578125, graphics_variation=4}, {x=77.98046875, y=44.80859375, graphics_variation=4}, {x=-86.62890625, y=46.27734375, graphics_variation=28}, {x=2.25, y=48.83984375, graphics_variation=27}, {x=-6.70703125, y=49.2265625, graphics_variation=21}, {x=-82.9375, y=54.9765625, graphics_variation=24}, {x=8.28515625, y=56.08203125, graphics_variation=28}, {x=-72.8828125, y=58.29296875, graphics_variation=25}, {x=-2.38671875, y=59.51953125, graphics_variation=3}, {x=9.8125, y=62.3203125, graphics_variation=12}, {x=-80.046875, y=65.203125, graphics_variation=29}, {x=-13.3359375, y=65.97265625, graphics_variation=7}, {x=-67.76171875, y=68.33984375, graphics_variation=2}, {x=2.41015625, y=67.2734375, graphics_variation=7}, {x=-58.08984375, y=69.25, graphics_variation=22}, {x=-30.140625, y=71.05859375, graphics_variation=21}, {x=14.7734375, y=72.1796875, graphics_variation=27}, {x=-83.46875, y=74.33203125, graphics_variation=24}, {x=-80.35546875, y=74.890625, graphics_variation=26}, {x=-0.578125, y=74.32421875, graphics_variation=28}, {x=6.12109375, y=73.45703125, graphics_variation=15}, {x=22.2265625, y=73.93359375, graphics_variation=24}, {x=-58.9375, y=80.42578125, graphics_variation=5}, {x=-54.33203125, y=81.75, graphics_variation=30}, {x=5.30859375, y=88.64453125, graphics_variation=10}, {x=19.15625, y=90.5859375, graphics_variation=22}, {x=-63.390625, y=94.69140625, graphics_variation=1}, {x=-81.35546875, y=95.046875, graphics_variation=21}, {x=14.91796875, y=95.26953125, graphics_variation=28}, {x=9.7578125, y=98.71484375, graphics_variation=6}, {x=20.72265625, y=100.5859375, graphics_variation=26}, {x=-72.30859375, y=101.96484375, graphics_variation=3}, {x=-73.15234375, y=106.28515625, graphics_variation=3}, {x=5.4609375, y=108.83203125, graphics_variation=20}, {x=-81.75, y=110.65625, graphics_variation=29}, {x=-62.98046875, y=113.828125, graphics_variation=20}, {x=-79.3203125, y=116.6796875, graphics_variation=20}, {x=22.25390625, y=115.45703125, graphics_variation=21}, {x=7.01953125, y=119.7109375, graphics_variation=24}, {x=-73.46484375, y=122.4375, graphics_variation=18}, {x=-68.8671875, y=122.79296875, graphics_variation=18}, {x=-55.08984375, y=122.875, graphics_variation=9}, {x=-45.875, y=122.39453125, graphics_variation=12}, {x=-35.1796875, y=122.77734375, graphics_variation=9}, {x=-21.57421875, y=122.5078125, graphics_variation=23}, {x=-15.94140625, y=122.9140625, graphics_variation=3}, {x=-38.5234375, y=126.640625, graphics_variation=29}, {x=23.5390625, y=128.5234375, graphics_variation=17}, {x=-20.26953125, y=130.3359375, graphics_variation=28}, {x=-57.68359375, y=131.515625, graphics_variation=23}, {x=-33.84375, y=131.10546875, graphics_variation=19}, {x=-3.140625, y=131.39453125, graphics_variation=26}, {x=9.41015625, y=131.58203125, graphics_variation=21}, {x=-6.9921875, y=133.10546875, graphics_variation=6}, {x=-45.09375, y=135.6328125, graphics_variation=5}, {x=13.04296875, y=135.12109375, graphics_variation=27}, {x=20.7734375, y=136.7421875, graphics_variation=29}, {x=-19.65625, y=137.8046875, graphics_variation=12}, {x=-18.94140625, y=143.85546875, graphics_variation=6}, {x=-6.84375, y=144.21875, graphics_variation=10}, {x=-14.140625, y=146.78125, graphics_variation=8}, },
    ["dead-dry-hairy-tree"] = {{x=1.546875, y=-102.47265625, graphics_variation=1}, },
    ["sand-decal-black-ruin"] = {{x=67.73046875, y=-102.39453125, graphics_variation=20}, {x=71.27734375, y=-100.0859375, graphics_variation=28}, {x=55.34765625, y=-88.1640625, graphics_variation=2}, {x=60.7734375, y=-88.70703125, graphics_variation=29}, {x=67.8203125, y=-84.3359375, graphics_variation=20}, {x=-67.6171875, y=-75.4765625, graphics_variation=23}, {x=-60.1875, y=-76.94921875, graphics_variation=27}, {x=-53.3671875, y=-76.59375, graphics_variation=23}, {x=-65.90234375, y=-70.72265625, graphics_variation=27}, {x=-58.66796875, y=-70.7578125, graphics_variation=22}, {x=-67.9375, y=-63.44140625, graphics_variation=1}, {x=-5.65234375, y=-63.5546875, graphics_variation=21}, {x=1.8828125, y=-63.80078125, graphics_variation=8}, {x=-68.09375, y=-61.953125, graphics_variation=12}, {x=-54.1015625, y=-62.640625, graphics_variation=7}, {x=-37.046875, y=-61.08984375, graphics_variation=2}, {x=-33.19921875, y=-62.73828125, graphics_variation=22}, {x=-27.58203125, y=-62.34375, graphics_variation=10}, {x=13.09375, y=-61.7734375, graphics_variation=23}, {x=62.99609375, y=-62.02734375, graphics_variation=24}, {x=66.9453125, y=-62.12890625, graphics_variation=24}, {x=-60.89453125, y=-60.6328125, graphics_variation=15}, {x=64.73828125, y=-58.42578125, graphics_variation=22}, {x=76.55859375, y=-54.3046875, graphics_variation=17}, {x=51.81640625, y=-50.93359375, graphics_variation=13}, {x=64.890625, y=-45.8984375, graphics_variation=1}, {x=66.50390625, y=-37.9609375, graphics_variation=18}, {x=71.8046875, y=-36.8125, graphics_variation=19}, {x=80.4296875, y=-30.1015625, graphics_variation=15}, {x=-82.5859375, y=-22.19921875, graphics_variation=10}, {x=-79.17578125, y=-22.12109375, graphics_variation=22}, {x=-75.5078125, y=-21.0078125, graphics_variation=7}, {x=-33.77734375, y=-21.4453125, graphics_variation=2}, {x=-30.625, y=-19.625, graphics_variation=4}, {x=80.046875, y=-20.68359375, graphics_variation=7}, {x=-80.2421875, y=-17.83203125, graphics_variation=21}, {x=-76.41015625, y=-14.72265625, graphics_variation=21}, {x=-29.8203125, y=-14.84375, graphics_variation=22}, {x=65.26953125, y=-13.0625, graphics_variation=22}, {x=80.375, y=-13.70703125, graphics_variation=27}, {x=62.90234375, y=-11.5, graphics_variation=23}, {x=63.3203125, y=-12.34765625, graphics_variation=18}, {x=14.12890625, y=-10.109375, graphics_variation=13}, {x=72.140625, y=-9.59765625, graphics_variation=2}, {x=67.2734375, y=-3.90625, graphics_variation=10}, {x=73.0234375, y=-4.94921875, graphics_variation=14}, {x=79.109375, y=-3.73828125, graphics_variation=22}, {x=58.81640625, y=-2.203125, graphics_variation=22}, {x=62.04296875, y=-2.0859375, graphics_variation=3}, {x=17.68359375, y=4.4609375, graphics_variation=13}, {x=62.015625, y=9.78125, graphics_variation=29}, {x=66.984375, y=12.88671875, graphics_variation=14}, {x=12.74609375, y=13.3046875, graphics_variation=5}, {x=78.875, y=13.48828125, graphics_variation=24}, {x=80.3046875, y=16.64453125, graphics_variation=23}, {x=62.5703125, y=20.640625, graphics_variation=3}, {x=-82.93359375, y=27.8515625, graphics_variation=3}, {x=-69.1796875, y=27.48046875, graphics_variation=11}, {x=-32.35546875, y=27.83203125, graphics_variation=21}, {x=61.859375, y=27.0859375, graphics_variation=23}, {x=-76.9453125, y=30.59765625, graphics_variation=1}, {x=-57.50390625, y=29.05859375, graphics_variation=2}, {x=-46.84765625, y=30.50390625, graphics_variation=25}, {x=-70.78125, y=31.71875, graphics_variation=21}, {x=-64.453125, y=31.7109375, graphics_variation=6}, {x=-54.63671875, y=32.43359375, graphics_variation=11}, {x=-37.05859375, y=31.07421875, graphics_variation=4}, {x=-29.2421875, y=31.1015625, graphics_variation=29}, {x=66.5859375, y=32.22265625, graphics_variation=24}, {x=-60.44140625, y=34.09375, graphics_variation=11}, {x=62.48828125, y=33.375, graphics_variation=28}, {x=-79.26953125, y=35.578125, graphics_variation=3}, {x=66.2890625, y=38.00390625, graphics_variation=1}, {x=-66.16796875, y=43.96484375, graphics_variation=9}, {x=-79.5859375, y=46.5390625, graphics_variation=12}, {x=-75.75, y=46.95703125, graphics_variation=23}, {x=-68.4609375, y=47.515625, graphics_variation=20}, {x=-18.453125, y=47.734375, graphics_variation=3}, {x=22.38671875, y=48.49609375, graphics_variation=1}, {x=37.64453125, y=48.671875, graphics_variation=28}, {x=50.53125, y=48.73046875, graphics_variation=28}, {x=66.5078125, y=48.390625, graphics_variation=17}, {x=75.37890625, y=47.125, graphics_variation=15}, {x=-76.328125, y=51.65234375, graphics_variation=26}, {x=-27.8515625, y=51.31640625, graphics_variation=24}, {x=20.07421875, y=53.80859375, graphics_variation=21}, {x=-77.8671875, y=55.61328125, graphics_variation=6}, {x=-63.4765625, y=55.07421875, graphics_variation=11}, {x=24.37109375, y=56.59375, graphics_variation=26}, {x=-80.421875, y=57.6484375, graphics_variation=5}, {x=-76.4765625, y=58.515625, graphics_variation=13}, {x=43.87109375, y=60.515625, graphics_variation=27}, {x=52.265625, y=60.453125, graphics_variation=30}, {x=63.0703125, y=60.46484375, graphics_variation=27}, {x=79.3359375, y=60.03515625, graphics_variation=21}, {x=83.57421875, y=60.8125, graphics_variation=10}, {x=37.9609375, y=61.73046875, graphics_variation=29}, {x=-25.33203125, y=65.66796875, graphics_variation=15}, {x=25.48046875, y=65.45703125, graphics_variation=29}, {x=-77.2890625, y=68.76953125, graphics_variation=30}, {x=82.0234375, y=67.046875, graphics_variation=22}, {x=-16.6171875, y=70.75390625, graphics_variation=3}, {x=-0.65234375, y=69.87109375, graphics_variation=3}, {x=5.81640625, y=69.65234375, graphics_variation=2}, {x=16.50390625, y=69.64453125, graphics_variation=2}, {x=22.3359375, y=69.82421875, graphics_variation=5}, {x=26.17578125, y=69.96484375, graphics_variation=15}, {x=82.83203125, y=70.890625, graphics_variation=7}, {x=37.859375, y=73.74609375, graphics_variation=23}, {x=71.265625, y=76.0234375, graphics_variation=17}, {x=37.84765625, y=77.79296875, graphics_variation=26}, {x=40.5546875, y=77.9921875, graphics_variation=15}, {x=45.93359375, y=77.3046875, graphics_variation=11}, {x=56.5078125, y=77.23828125, graphics_variation=2}, {x=62.22265625, y=77.2265625, graphics_variation=26}, {x=66.05078125, y=77.86328125, graphics_variation=15}, {x=76.3046875, y=77.359375, graphics_variation=11}, {x=84.1484375, y=80.03515625, graphics_variation=26}, {x=27.81640625, y=81.46875, graphics_variation=11}, {x=37.98828125, y=83.375, graphics_variation=8}, {x=79.0859375, y=83.00390625, graphics_variation=5}, {x=60.70703125, y=86.14453125, graphics_variation=18}, {x=61.33984375, y=85.95703125, graphics_variation=8}, {x=83.05078125, y=86.7265625, graphics_variation=5}, {x=-56.9140625, y=88.03125, graphics_variation=20}, {x=25.41796875, y=88.2578125, graphics_variation=7}, {x=61.97265625, y=88.7734375, graphics_variation=6}, {x=78.8203125, y=87.93359375, graphics_variation=3}, {x=5.63671875, y=90.609375, graphics_variation=11}, {x=82.21484375, y=90.00390625, graphics_variation=15}, {x=37.9375, y=91.8515625, graphics_variation=11}, {x=61.1953125, y=92.94140625, graphics_variation=30}, {x=84.0703125, y=91.62109375, graphics_variation=7}, {x=2.51953125, y=93.9609375, graphics_variation=12}, {x=23.125, y=94.61328125, graphics_variation=11}, {x=-54.765625, y=96.265625, graphics_variation=13}, {x=-31.6953125, y=96.26171875, graphics_variation=17}, {x=61.37890625, y=96.171875, graphics_variation=18}, {x=2.8515625, y=98.10546875, graphics_variation=20}, {x=37.3125, y=98.51171875, graphics_variation=28}, {x=-84.17578125, y=100.66796875, graphics_variation=24}, {x=-62.0234375, y=100.67578125, graphics_variation=14}, {x=25.80078125, y=100.67578125, graphics_variation=13}, {x=61.4296875, y=99.89453125, graphics_variation=26}, {x=84.0390625, y=100.7421875, graphics_variation=26}, {x=83.86328125, y=101.5234375, graphics_variation=8}, {x=-66.65625, y=104.05859375, graphics_variation=22}, {x=-33.39453125, y=103.5859375, graphics_variation=4}, {x=2.2421875, y=104.9375, graphics_variation=28}, {x=62.93359375, y=103.140625, graphics_variation=18}, {x=73.68359375, y=106.671875, graphics_variation=23}, {x=77.484375, y=106.125, graphics_variation=23}, {x=15.86328125, y=107.83203125, graphics_variation=25}, {x=20.5390625, y=107.1953125, graphics_variation=17}, {x=38.00390625, y=107.8671875, graphics_variation=10}, {x=49.71484375, y=107.56640625, graphics_variation=20}, {x=57.23046875, y=107.3515625, graphics_variation=3}, {x=-1.26953125, y=109.0390625, graphics_variation=23}, {x=-62.015625, y=111.40234375, graphics_variation=25}, {x=-54.73046875, y=112.28515625, graphics_variation=9}, {x=3.6640625, y=112.35546875, graphics_variation=25}, {x=83.1484375, y=111.32421875, graphics_variation=26}, {x=37.53515625, y=113.67578125, graphics_variation=22}, {x=72.6953125, y=113.40234375, graphics_variation=10}, {x=-55.56640625, y=116.3671875, graphics_variation=6}, {x=-51.41796875, y=116.57421875, graphics_variation=27}, {x=-38.21875, y=116.98046875, graphics_variation=25}, {x=54.8515625, y=116.01171875, graphics_variation=13}, {x=60.58984375, y=116.1640625, graphics_variation=26}, {x=64.0625, y=116.9375, graphics_variation=10}, {x=52.84375, y=119.62890625, graphics_variation=27}, {x=-29.7421875, y=121.47265625, graphics_variation=8}, {x=3.33984375, y=121.48828125, graphics_variation=17}, {x=37.015625, y=122.34765625, graphics_variation=18}, {x=83.08203125, y=121.33984375, graphics_variation=26}, {x=40.26953125, y=124.3984375, graphics_variation=15}, {x=43.77734375, y=124.1953125, graphics_variation=19}, {x=-8.203125, y=126.69921875, graphics_variation=5}, {x=5.23828125, y=125.59375, graphics_variation=29}, {x=-61.46875, y=128.1796875, graphics_variation=15}, {x=-27.640625, y=127.9296875, graphics_variation=21}, {x=15.50390625, y=127.71484375, graphics_variation=9}, {x=-0.38671875, y=129.93359375, graphics_variation=11}, {x=82.5859375, y=129.23046875, graphics_variation=24}, {x=2.09375, y=132.2734375, graphics_variation=18}, {x=53.64453125, y=131.5625, graphics_variation=27}, {x=61.60546875, y=134.734375, graphics_variation=3}, {x=71.04296875, y=134.07421875, graphics_variation=3}, {x=-53.61328125, y=136.01953125, graphics_variation=10}, {x=-47.0390625, y=136.53125, graphics_variation=19}, {x=-28.51953125, y=135.23046875, graphics_variation=1}, {x=-7.9609375, y=136.37890625, graphics_variation=7}, {x=-0.7421875, y=136.59765625, graphics_variation=26}, {x=7.42578125, y=135.71484375, graphics_variation=28}, {x=16.921875, y=136.8359375, graphics_variation=23}, {x=37.3203125, y=135.25, graphics_variation=30}, {x=61.13671875, y=136.63671875, graphics_variation=11}, {x=-12.53125, y=137.328125, graphics_variation=1}, {x=11.44140625, y=137.109375, graphics_variation=27}, {x=53.56640625, y=138.71875, graphics_variation=6}, {x=71.7421875, y=137.9921875, graphics_variation=18}, {x=39.0859375, y=140.7734375, graphics_variation=26}, {x=-2.99609375, y=142.3515625, graphics_variation=3}, {x=46.7109375, y=141.9765625, graphics_variation=1}, {x=61.5625, y=141.1796875, graphics_variation=28}, {x=75.36328125, y=142.60546875, graphics_variation=10}, {x=80.5546875, y=141.375, graphics_variation=27}, {x=-16.43359375, y=144.15625, graphics_variation=1}, },
    ["tree-grassland-h"] = {{x=-43.6171875, y=-98.61328125, graphics_variation=12}, {x=-32.80078125, y=-98.37109375, graphics_variation=4}, {x=-22.0703125, y=-98.40625, graphics_variation=7}, {x=-54.8984375, y=-93.5078125, graphics_variation=8}, {x=-40.6875, y=-94.6796875, graphics_variation=8}, {x=9.8359375, y=-79.28515625, graphics_variation=6}, {x=-25.03515625, y=-77.58203125, graphics_variation=2}, {x=-19.734375, y=-77.5, graphics_variation=9}, {x=-15.484375, y=-78.00390625, graphics_variation=6}, {x=-25.0546875, y=-73.83984375, graphics_variation=3}, {x=-19.921875, y=-74.57421875, graphics_variation=12}, {x=-15.19140625, y=-74.15625, graphics_variation=12}, {x=-5.24609375, y=-74.40625, graphics_variation=4}, {x=-0.11328125, y=-74.4921875, graphics_variation=2}, {x=10.06640625, y=-74.23828125, graphics_variation=6}, {x=25.7265625, y=-25.6796875, graphics_variation=4}, {x=26.48828125, y=-22.87890625, graphics_variation=4}, {x=8.98828125, y=-17.12109375, graphics_variation=9}, {x=8.76953125, y=-4.27734375, graphics_variation=2}, {x=8.14453125, y=-0.08984375, graphics_variation=7}, {x=9.61328125, y=2.28515625, graphics_variation=10}, {x=8.11328125, y=13.12890625, graphics_variation=7}, {x=6.76953125, y=17.81640625, graphics_variation=5}, {x=8.14453125, y=23.03515625, graphics_variation=6}, {x=8.14453125, y=30.37890625, graphics_variation=4}, {x=-19.63671875, y=32.09765625, graphics_variation=4}, {x=4.89453125, y=31.94140625, graphics_variation=12}, {x=1.14453125, y=34.62890625, graphics_variation=7}, {x=-59.56640625, y=48.734375, graphics_variation=1}, {x=-31.4921875, y=48.609375, graphics_variation=8}, {x=-59.38671875, y=51.11328125, graphics_variation=2}, {x=-80.91015625, y=60.6875, graphics_variation=5}, {x=-68.53125, y=74.13671875, graphics_variation=12}, {x=-66.30078125, y=76.4140625, graphics_variation=5}, {x=-23.4609375, y=76.84765625, graphics_variation=4}, {x=-74.51953125, y=77.0859375, graphics_variation=5}, {x=-56.84375, y=77.44921875, graphics_variation=1}, {x=-9.1015625, y=77.8203125, graphics_variation=8}, {x=-65.0234375, y=80.3828125, graphics_variation=3}, {x=-77.6328125, y=81.3828125, graphics_variation=10}, {x=-83.55859375, y=85.33203125, graphics_variation=11}, {x=-11.2265625, y=86.375, graphics_variation=1}, {x=-77.91015625, y=87.41796875, graphics_variation=2}, {x=-13.71484375, y=88.68359375, graphics_variation=10}, {x=-67.18359375, y=91.01953125, graphics_variation=11}, {x=-67.90234375, y=89.27734375, graphics_variation=1}, {x=-11.38671875, y=89.8046875, graphics_variation=2}, {x=-27.359375, y=94.82421875, graphics_variation=9}, {x=-5.56640625, y=99.6484375, graphics_variation=6}, {x=-85.89453125, y=104.3359375, graphics_variation=10}, {x=-17.11328125, y=107.859375, graphics_variation=10}, {x=-11.8046875, y=110.5, graphics_variation=1}, {x=-25.1015625, y=113.51953125, graphics_variation=12}, {x=-8.73046875, y=113.88671875, graphics_variation=6}, {x=65.56640625, y=124.50390625, graphics_variation=3}, {x=67.69921875, y=129.6640625, graphics_variation=12}, {x=60.59375, y=131.77734375, graphics_variation=7}, {x=67.39453125, y=131.58984375, graphics_variation=1}, {x=67.5078125, y=131.58984375, graphics_variation=10}, {x=70.8046875, y=131.51171875, graphics_variation=6}, {x=13.00390625, y=144.64453125, graphics_variation=8}, },
    ["cracked-mud-decal-ruin"] = {{x=10.9296875, y=-98.2109375, graphics_variation=13}, {x=10.9296875, y=-98.2109375, graphics_variation=13}, {x=16.984375, y=-96.0859375, graphics_variation=25}, {x=17.01171875, y=-96.0859375, graphics_variation=21}, {x=23.96484375, y=-94.92578125, graphics_variation=11}, {x=23.96484375, y=-94.92578125, graphics_variation=11}, {x=29.29296875, y=-75.13671875, graphics_variation=2}, {x=29.29296875, y=-75.13671875, graphics_variation=2}, {x=-74.4765625, y=-74.63671875, graphics_variation=14}, {x=-74.4765625, y=-74.63671875, graphics_variation=14}, {x=-77.0859375, y=-62.60546875, graphics_variation=20}, {x=-77.0859375, y=-62.60546875, graphics_variation=20}, {x=-68.62890625, y=-42.62890625, graphics_variation=1}, {x=-22.296875, y=-41.73828125, graphics_variation=20}, {x=-69.2265625, y=-36.10546875, graphics_variation=11}, {x=-43.1875, y=-31.5, graphics_variation=21}, {x=-11.0859375, y=-31.75390625, graphics_variation=8}, {x=-12.2578125, y=-29.09375, graphics_variation=7}, {x=28.0390625, y=-26.46875, graphics_variation=3}, {x=28.0390625, y=-26.46875, graphics_variation=3}, {x=26.21875, y=-19.7421875, graphics_variation=22}, {x=26.21875, y=-19.7421875, graphics_variation=22}, {x=26.21875, y=-19.7421875, graphics_variation=22}, {x=7.46875, y=-10.7734375, graphics_variation=1}, {x=3.2578125, y=13.59375, graphics_variation=30}, {x=3.5078125, y=24.21875, graphics_variation=21}, {x=3.5078125, y=24.21875, graphics_variation=21}, },
    ["workshop-ruin"] = {{x=76.5, y=-97.5, graphics_variation=1}, {x=69.5, y=-87.5, graphics_variation=1}, {x=-19.5, y=-62.5, graphics_variation=1}, {x=8.5, y=-62.5, graphics_variation=1}, {x=66.5, y=-55.5, graphics_variation=1}, {x=73.5, y=-55.5, graphics_variation=1}, {x=78.5, y=-54.5, graphics_variation=1}, {x=13.5, y=-47.5, graphics_variation=1}, {x=66.5, y=-41.5, graphics_variation=1}, {x=80.5, y=-32.5, graphics_variation=1}, {x=13.5, y=-31.5, graphics_variation=1}, {x=80.5, y=-27.5, graphics_variation=1}, {x=80.5, y=-23.5, graphics_variation=1}, {x=13.5, y=-8.5, graphics_variation=1}, {x=77.5, y=-8.5, graphics_variation=1}, {x=13.5, y=21.5, graphics_variation=1}, {x=13.5, y=26.5, graphics_variation=1}, {x=-37.5, y=28.5, graphics_variation=1}, {x=-32.5, y=34.5, graphics_variation=1}, {x=71.5, y=34.5, graphics_variation=1}, {x=77.5, y=34.5, graphics_variation=1}, {x=68.5, y=48.5, graphics_variation=1}, {x=72.5, y=48.5, graphics_variation=1}, {x=80.5, y=48.5, graphics_variation=1}, {x=-22.5, y=51.5, graphics_variation=1}, {x=1.5, y=58.5, graphics_variation=1}, {x=41.5, y=60.5, graphics_variation=1}, {x=46.5, y=60.5, graphics_variation=1}, {x=50.5, y=60.5, graphics_variation=1}, {x=57.5, y=60.5, graphics_variation=1}, {x=61.5, y=60.5, graphics_variation=1}, {x=67.5, y=60.5, graphics_variation=1}, {x=71.5, y=60.5, graphics_variation=1}, {x=9.5, y=64.5, graphics_variation=1}, {x=37.5, y=66.5, graphics_variation=1}, {x=37.5, y=70.5, graphics_variation=1}, {x=6.5, y=75.5, graphics_variation=1}, {x=6.5, y=79.5, graphics_variation=1}, {x=26.5, y=78.5, graphics_variation=1}, {x=65.5, y=88.5, graphics_variation=1}, {x=26.5, y=93.5, graphics_variation=1}, {x=26.5, y=97.5, graphics_variation=1}, {x=37.5, y=102.5, graphics_variation=1}, {x=65.5, y=102.5, graphics_variation=1}, {x=79.5, y=102.5, graphics_variation=1}, {x=26.5, y=112.5, graphics_variation=1}, {x=53.5, y=112.5, graphics_variation=1}, {x=2.5, y=114.5, graphics_variation=1}, {x=83.5, y=117.5, graphics_variation=1}, {x=-30.5, y=123.5, graphics_variation=1}, {x=-0.5, y=123.5, graphics_variation=1}, {x=26.5, y=124.5, graphics_variation=1}, {x=83.5, y=124.5, graphics_variation=1}, {x=-0.5, y=132.5, graphics_variation=1}, {x=26.5, y=132.5, graphics_variation=1}, {x=83.5, y=133.5, graphics_variation=1}, {x=67.5, y=137.5, graphics_variation=1}, {x=83.5, y=137.5, graphics_variation=1}, {x=49.5, y=141.5, graphics_variation=1}, {x=53.5, y=141.5, graphics_variation=1}, {x=67.5, y=141.5, graphics_variation=1}, {x=83.5, y=141.5, graphics_variation=1}, {x=6.5, y=145.5, graphics_variation=1}, },
    ["wood-half-chest-right"] = {{x=79.26953125, y=-97.87890625, graphics_variation=1}, {x=66.47265625, y=-89.8515625, graphics_variation=1}, {x=56.4296875, y=-86.4296875, graphics_variation=1}, {x=-30.5234375, y=-61.625, graphics_variation=1}, {x=-1.828125, y=-61.4453125, graphics_variation=1}, {x=14.53125, y=-55.24609375, graphics_variation=1}, {x=74.1015625, y=-51.8125, graphics_variation=1}, {x=67.43359375, y=-49.60546875, graphics_variation=1}, {x=14.40625, y=-37.25390625, graphics_variation=1}, {x=14.26953125, y=-34.74609375, graphics_variation=1}, {x=14.5, y=-16.98046875, graphics_variation=1}, {x=75.37109375, y=-9.6328125, graphics_variation=1}, {x=14.46484375, y=9.11328125, graphics_variation=1}, {x=62.2890625, y=8.421875, graphics_variation=1}, {x=81.2890625, y=19.078125, graphics_variation=1}, {x=-39.5546875, y=29.3515625, graphics_variation=1}, {x=-75.6015625, y=36.375, graphics_variation=1}, {x=67.2578125, y=43.140625, graphics_variation=1}, {x=7.3359375, y=69.44140625, graphics_variation=1}, {x=80.4453125, y=77.65234375, graphics_variation=1}, {x=7.45703125, y=81.25, graphics_variation=1}, {x=7.45703125, y=81.25, graphics_variation=1}, {x=72.3515625, y=137.87890625, graphics_variation=1}, },
    ["tree-wetland-i"] = {{x=6.8984375, y=-96.2265625, graphics_variation=2}, {x=18.0078125, y=-81.125, graphics_variation=7}, {x=21.87109375, y=-81.4375, graphics_variation=5}, {x=27.66796875, y=-79.78125, graphics_variation=2}, {x=17.87109375, y=-78.67578125, graphics_variation=2}, {x=-40.71875, y=-73.85546875, graphics_variation=1}, {x=7.8984375, y=-57.89453125, graphics_variation=7}, {x=9.25390625, y=-56.109375, graphics_variation=7}, {x=7.25, y=-3.1328125, graphics_variation=1}, {x=9.21484375, y=15.53125, graphics_variation=1}, {x=7.55859375, y=24.7109375, graphics_variation=3}, {x=-16.38671875, y=30.95703125, graphics_variation=5}, {x=9.87109375, y=32.54296875, graphics_variation=2}, {x=-20.8359375, y=34.88671875, graphics_variation=1}, {x=-18.8359375, y=35.578125, graphics_variation=8}, {x=5.3515625, y=35.12890625, graphics_variation=7}, {x=9.04296875, y=35.71484375, graphics_variation=3}, {x=-83.07421875, y=45.24609375, graphics_variation=6}, {x=-60.4375, y=45.03515625, graphics_variation=6}, {x=-60.375, y=48.03515625, graphics_variation=3}, {x=-57.59375, y=47.84765625, graphics_variation=3}, {x=-32.33984375, y=47.7421875, graphics_variation=8}, {x=-30.49609375, y=47.79296875, graphics_variation=1}, {x=-60.5, y=49.22265625, graphics_variation=4}, {x=-58.5625, y=50.75390625, graphics_variation=3}, {x=-30.49609375, y=49.89453125, graphics_variation=1}, {x=-60.375, y=51.84765625, graphics_variation=5}, {x=30.98046875, y=52.85546875, graphics_variation=1}, {x=29.875, y=54.35546875, graphics_variation=7}, {x=-77.46875, y=73.8125, graphics_variation=5}, {x=-56.73828125, y=73.9140625, graphics_variation=3}, {x=-34.97265625, y=73.53125, graphics_variation=8}, {x=-33.12890625, y=73.8359375, graphics_variation=2}, {x=-64.91015625, y=75.23046875, graphics_variation=7}, {x=-58.12109375, y=75.76171875, graphics_variation=5}, {x=-34.21484375, y=75.6015625, graphics_variation=1}, {x=-32.28125, y=75.24609375, graphics_variation=1}, {x=-22.97265625, y=76.22265625, graphics_variation=7}, {x=-18.82421875, y=75.90625, graphics_variation=5}, {x=-5.81640625, y=76.4921875, graphics_variation=3}, {x=-57.6796875, y=77.640625, graphics_variation=8}, {x=-24.44921875, y=77.328125, graphics_variation=4}, {x=-16.9296875, y=77.39453125, graphics_variation=8}, {x=-4.0234375, y=79.35546875, graphics_variation=3}, {x=-0.17578125, y=79.58203125, graphics_variation=3}, {x=-18.375, y=84.83984375, graphics_variation=7}, {x=-65.9296875, y=86.12109375, graphics_variation=8}, {x=-65.9296875, y=86.1875, graphics_variation=4}, {x=-23.20703125, y=87.98828125, graphics_variation=7}, {x=-18.72265625, y=88.015625, graphics_variation=7}, {x=-0.96875, y=87.2890625, graphics_variation=4}, {x=1.9765625, y=88.1953125, graphics_variation=8}, {x=1.9765625, y=88.30859375, graphics_variation=8}, {x=-77.26171875, y=90.4609375, graphics_variation=2}, {x=-65.48828125, y=90.3671875, graphics_variation=2}, {x=-29.078125, y=90.0390625, graphics_variation=1}, {x=-29.19140625, y=89.5859375, graphics_variation=7}, {x=-24.34765625, y=90.74609375, graphics_variation=6}, {x=-84.49609375, y=92.5078125, graphics_variation=3}, {x=-70.38671875, y=91.1796875, graphics_variation=6}, {x=-27.71875, y=91.73828125, graphics_variation=7}, {x=-16.4453125, y=91.47265625, graphics_variation=5}, {x=-23.171875, y=96.78515625, graphics_variation=7}, {x=-17.515625, y=95.12890625, graphics_variation=7}, {x=-4.30859375, y=96.06640625, graphics_variation=8}, {x=-4.30859375, y=96.29296875, graphics_variation=2}, {x=-4.36328125, y=96.515625, graphics_variation=3}, {x=-4.30859375, y=95.21484375, graphics_variation=3}, {x=-4.30859375, y=95.5546875, graphics_variation=3}, {x=-4.30859375, y=95.83984375, graphics_variation=2}, {x=-27.65234375, y=98.38671875, graphics_variation=1}, {x=-4.81640625, y=97.53515625, graphics_variation=6}, {x=-6.7421875, y=99.51953125, graphics_variation=5}, {x=-27.19921875, y=102.06640625, graphics_variation=5}, {x=-25.6171875, y=102.40625, graphics_variation=2}, {x=-26.69140625, y=102.9140625, graphics_variation=8}, {x=-4.9296875, y=102.6875, graphics_variation=1}, {x=-18.7578125, y=104.4453125, graphics_variation=2}, {x=-27.59765625, y=106.25390625, graphics_variation=1}, {x=-4.53515625, y=106.6484375, graphics_variation=8}, {x=-4.4765625, y=106.8203125, graphics_variation=8}, {x=-19.34375, y=107.48046875, graphics_variation=1}, {x=-22.69140625, y=113.48046875, graphics_variation=6}, {x=-26.2421875, y=115.62109375, graphics_variation=7}, {x=-16.71875, y=116.1015625, graphics_variation=5}, {x=-15.09765625, y=117.5859375, graphics_variation=1}, {x=-14.99609375, y=117.4140625, graphics_variation=5}, {x=-65.34765625, y=120.89453125, graphics_variation=5}, {x=62.14453125, y=126.84375, graphics_variation=3}, {x=70.35546875, y=127.37890625, graphics_variation=6}, {x=62.6796875, y=132.046875, graphics_variation=2}, {x=65.8203125, y=131.64453125, graphics_variation=8}, {x=-52.4140625, y=140.93359375, graphics_variation=1}, {x=-43.6484375, y=140.5859375, graphics_variation=3}, {x=9.75, y=140.87890625, graphics_variation=2}, {x=11.2890625, y=140.5703125, graphics_variation=8}, {x=-48.515625, y=141.2421875, graphics_variation=2}, {x=-48.58203125, y=141.2421875, graphics_variation=1}, {x=16.6171875, y=141.98046875, graphics_variation=2}, {x=24, y=141.26171875, graphics_variation=5}, {x=10.515625, y=143.875, graphics_variation=1}, },
    ["tree-desert-f"] = {{x=19.2734375, y=-81.484375, graphics_variation=4}, {x=22.51171875, y=-78.58984375, graphics_variation=3}, {x=29.1015625, y=-78.4375, graphics_variation=6}, {x=25.328125, y=-76.68359375, graphics_variation=6}, {x=33.78515625, y=-76.609375, graphics_variation=4}, {x=18.28125, y=-74.7421875, graphics_variation=5}, {x=-10.0546875, y=-30.91015625, graphics_variation=4}, {x=-58.5234375, y=46.71875, graphics_variation=6}, {x=-57.72265625, y=73.953125, graphics_variation=2}, {x=-14.05859375, y=77.20703125, graphics_variation=6}, {x=-14.6796875, y=79.484375, graphics_variation=7}, {x=-14.74609375, y=79.484375, graphics_variation=5}, {x=-4.63671875, y=87.45703125, graphics_variation=5}, {x=-6.19140625, y=89.11328125, graphics_variation=2}, {x=-4.984375, y=91.390625, graphics_variation=7}, {x=-16.203125, y=98.8359375, graphics_variation=5}, {x=-17.89453125, y=100.07421875, graphics_variation=6}, {x=-23.828125, y=106.35546875, graphics_variation=2}, {x=-26.3828125, y=108.4609375, graphics_variation=7}, {x=-10.71484375, y=108.1484375, graphics_variation=6}, {x=-9.95703125, y=110.390625, graphics_variation=1}, {x=-10.02734375, y=110.359375, graphics_variation=1}, {x=-8.05859375, y=109.76953125, graphics_variation=5}, {x=-14.6171875, y=112.15234375, graphics_variation=7}, {x=-9.6484375, y=112.39453125, graphics_variation=5}, {x=-9.71484375, y=112.4296875, graphics_variation=7}, {x=-9.78515625, y=112.49609375, graphics_variation=4}, {x=-6.75, y=111.7734375, graphics_variation=2}, {x=-13.0390625, y=149.72265625, graphics_variation=6}, {x=-4.9140625, y=149.5234375, graphics_variation=6}, {x=2.7265625, y=149.3828125, graphics_variation=3}, },
    ["vase"] = {{x=26.99609375, y=-66.0390625, graphics_variation=1}, {x=29.98046875, y=-65.99609375, graphics_variation=1}, {x=33.05078125, y=-65.99609375, graphics_variation=1}, {x=42.875, y=-66.0390625, graphics_variation=1}, {x=46.02734375, y=-65.99609375, graphics_variation=1}, {x=49.03515625, y=-65.953125, graphics_variation=1}, {x=27.05859375, y=-41.6796875, graphics_variation=1}, {x=30.00390625, y=-41.73046875, graphics_variation=1}, {x=33.00390625, y=-41.70703125, graphics_variation=1}, {x=43.10546875, y=-41.70703125, graphics_variation=1}, {x=46.02734375, y=-41.65625, graphics_variation=1}, {x=49.10546875, y=-41.78125, graphics_variation=1}, {x=-18.41015625, y=43.4765625, graphics_variation=1}, {x=-16.44140625, y=43.51171875, graphics_variation=1}, {x=52.03515625, y=47.2734375, graphics_variation=1}, {x=54.01953125, y=47.3125, graphics_variation=1}, {x=56.07421875, y=47.29296875, graphics_variation=1}, {x=13.078125, y=52.375, graphics_variation=1}, {x=15.453125, y=56.578125, graphics_variation=1}, {x=21.625, y=56.53125, graphics_variation=1}, {x=-24.953125, y=58.37109375, graphics_variation=1}, {x=-21.92578125, y=58.4140625, graphics_variation=1}, {x=27.81640625, y=57.6953125, graphics_variation=1}, {x=27.81640625, y=59.671875, graphics_variation=1}, {x=15.40625, y=62.390625, graphics_variation=1}, {x=21.609375, y=62.453125, graphics_variation=1}, {x=27.87890625, y=61.6484375, graphics_variation=1}, {x=-57.96875, y=85.203125, graphics_variation=1}, {x=-54.890625, y=85.203125, graphics_variation=1}, {x=36.22265625, y=91.40625, graphics_variation=1}, {x=36.16796875, y=93.5390625, graphics_variation=1}, {x=13.5078125, y=105.984375, graphics_variation=1}, {x=15.5703125, y=105.984375, graphics_variation=1}, {x=17.50390625, y=106.06640625, graphics_variation=1}, {x=19.5234375, y=106.0234375, graphics_variation=1}, {x=70.15234375, y=107.4609375, graphics_variation=1}, {x=84.828125, y=107.55078125, graphics_variation=1}, {x=13.8671875, y=117.64453125, graphics_variation=1}, {x=23.625, y=117.5390625, graphics_variation=1}, {x=-30.484375, y=120.59765625, graphics_variation=1}, {x=-9.45703125, y=120.61328125, graphics_variation=1}, {x=13.7421875, y=125.5859375, graphics_variation=1}, {x=23.60546875, y=125.69140625, graphics_variation=1}, {x=-53.5078125, y=129.6015625, graphics_variation=1}, {x=-45.515625, y=129.70703125, graphics_variation=1}, {x=-37.421875, y=129.8125, graphics_variation=1}, {x=-29.55078125, y=129.55859375, graphics_variation=1}, {x=-9.3828125, y=129.58203125, graphics_variation=1}, {x=2.5078125, y=129.70703125, graphics_variation=1}, {x=-17.4765625, y=132.50390625, graphics_variation=1}, {x=13.67578125, y=133.703125, graphics_variation=1}, {x=23.79296875, y=133.6171875, graphics_variation=1}, },
    ["iron-wood-chest-remnants"] = {{x=-32.5, y=-63.5, graphics_variation=1}, {x=-36.5, y=-61.5, graphics_variation=1}, {x=-36.5, y=-62.5, graphics_variation=1}, {x=64.5, y=-42.5, graphics_variation=1}, {x=80.5, y=-17.5, graphics_variation=1}, {x=-80.5, y=-16.5, graphics_variation=1}, {x=-77.5, y=-16.5, graphics_variation=1}, {x=-31.5, y=-16.5, graphics_variation=1}, {x=-28.5, y=-16.5, graphics_variation=1}, {x=65.5, y=-4.5, graphics_variation=1}, {x=67.5, y=-4.5, graphics_variation=1}, {x=80.5, y=8.5, graphics_variation=1}, {x=80.5, y=10.5, graphics_variation=1}, {x=12.5, y=19.5, graphics_variation=1}, {x=80.5, y=21.5, graphics_variation=1}, {x=-84.5, y=29.5, graphics_variation=1}, {x=-24.5, y=29.5, graphics_variation=1}, {x=12.5, y=34.5, graphics_variation=1}, {x=80.5, y=38.5, graphics_variation=1}, {x=62.5, y=47.5, graphics_variation=1}, {x=62.5, y=49.5, graphics_variation=1}, {x=23.5, y=54.5, graphics_variation=1}, {x=-77.5, y=59.5, graphics_variation=1}, {x=-63.5, y=59.5, graphics_variation=1}, {x=-76.5, y=66.5, graphics_variation=1}, {x=-64.5, y=66.5, graphics_variation=1}, {x=36.5, y=76.5, graphics_variation=1}, {x=50.5, y=76.5, graphics_variation=1}, {x=72.5, y=76.5, graphics_variation=1}, {x=36.5, y=77.5, graphics_variation=1}, {x=50.5, y=78.5, graphics_variation=1}, {x=72.5, y=78.5, graphics_variation=1}, {x=74.5, y=78.5, graphics_variation=1}, {x=74.5, y=77.5, graphics_variation=1}, {x=10.5, y=86.5, graphics_variation=1}, {x=-30.5, y=94.5, graphics_variation=1}, {x=2.5, y=101.5, graphics_variation=1}, {x=1.5, y=101.5, graphics_variation=1}, {x=9.5, y=105.5, graphics_variation=1}, {x=10.5, y=105.5, graphics_variation=1}, {x=2.5, y=110.5, graphics_variation=1}, {x=3.5, y=110.5, graphics_variation=1}, {x=19.5, y=117.5, graphics_variation=1}, {x=-51.5, y=120.5, graphics_variation=1}, {x=-40.5, y=120.5, graphics_variation=1}, {x=2.5, y=124.5, graphics_variation=1}, {x=19.5, y=125.5, graphics_variation=1}, {x=19.5, y=133.5, graphics_variation=1}, },
    ["wood-half-chest-left"] = {{x=-28.65625, y=-62.71484375, graphics_variation=1}, {x=-42.58984375, y=-61.73828125, graphics_variation=1}, {x=61.30078125, y=-56.6484375, graphics_variation=1}, {x=64.41015625, y=-44.7578125, graphics_variation=1}, {x=-84.4375, y=-23.24609375, graphics_variation=1}, {x=-31.55859375, y=-23.33984375, graphics_variation=1}, {x=-31.60546875, y=-21.83203125, graphics_variation=1}, {x=-31.48828125, y=-19.99609375, graphics_variation=1}, {x=70.39453125, y=-2.9921875, graphics_variation=1}, {x=-70.66796875, y=27.59375, graphics_variation=1}, {x=5.43359375, y=62.4765625, graphics_variation=1}, {x=25.31640625, y=101.5078125, graphics_variation=1}, {x=25.69140625, y=117.2265625, graphics_variation=1}, {x=68.48828125, y=116.60546875, graphics_variation=1}, {x=-18.609375, y=133.44921875, graphics_variation=1}, {x=5.375, y=135.5390625, graphics_variation=1}, {x=5.34765625, y=137.3046875, graphics_variation=1}, {x=70.30078125, y=136.1015625, graphics_variation=1}, {x=36.33984375, y=137.69921875, graphics_variation=1}, {x=70.3671875, y=142.1875, graphics_variation=1}, },
    ["furnace-ruin"] = {{x=74, y=-59, graphics_variation=1}, {x=62, y=-55, graphics_variation=1}, {x=82, y=-56, graphics_variation=1}, {x=65, y=-52, graphics_variation=1}, {x=74, y=-49, graphics_variation=1}, {x=74, y=-37, graphics_variation=1}, {x=-75, y=-23, graphics_variation=1}, {x=-34, y=-23, graphics_variation=1}, {x=-75, y=-19, graphics_variation=1}, {x=-34, y=-19, graphics_variation=1}, {x=18, y=-4, graphics_variation=1}, {x=58, y=-4, graphics_variation=1}, {x=62, y=-4, graphics_variation=1}, {x=81, y=0, graphics_variation=1}, {x=81, y=3, graphics_variation=1}, {x=62, y=22, graphics_variation=1}, {x=81, y=24, graphics_variation=1}, {x=-84, y=27, graphics_variation=1}, {x=-78, y=27, graphics_variation=1}, {x=-31, y=27, graphics_variation=1}, {x=-25, y=27, graphics_variation=1}, {x=62, y=26, graphics_variation=1}, {x=-72, y=28, graphics_variation=1}, {x=-57, y=32, graphics_variation=1}, {x=71, y=32, graphics_variation=1}, {x=-72, y=35, graphics_variation=1}, {x=-69, y=35, graphics_variation=1}, {x=-66, y=35, graphics_variation=1}, {x=-63, y=35, graphics_variation=1}, {x=-57, y=35, graphics_variation=1}, {x=-46, y=35, graphics_variation=1}, {x=-43, y=35, graphics_variation=1}, {x=-40, y=35, graphics_variation=1}, {x=-37, y=35, graphics_variation=1}, {x=81, y=41, graphics_variation=1}, {x=-28, y=43, graphics_variation=1}, {x=-74, y=48, graphics_variation=1}, {x=65, y=49, graphics_variation=1}, {x=-64, y=52, graphics_variation=1}, {x=37, y=60, graphics_variation=1}, {x=2, y=70, graphics_variation=1}, {x=13, y=70, graphics_variation=1}, {x=2, y=73, graphics_variation=1}, {x=2, y=76, graphics_variation=1}, {x=23, y=87, graphics_variation=1}, {x=-1, y=93, graphics_variation=1}, {x=23, y=93, graphics_variation=1}, {x=-54, y=95, graphics_variation=1}, {x=-85, y=99, graphics_variation=1}, {x=-66, y=99, graphics_variation=1}, {x=-62, y=99, graphics_variation=1}, {x=-54, y=101, graphics_variation=1}, {x=-35, y=101, graphics_variation=1}, {x=10, y=100, graphics_variation=1}, {x=23, y=100, graphics_variation=1}, {x=-54, y=111, graphics_variation=1}, {x=-35, y=111, graphics_variation=1}, {x=66, y=117, graphics_variation=1}, {x=-18, y=121, graphics_variation=1}, {x=-51, y=124, graphics_variation=1}, {x=-40, y=124, graphics_variation=1}, {x=-18, y=124, graphics_variation=1}, {x=83, y=128, graphics_variation=1}, {x=-18, y=130, graphics_variation=1}, },
    ["sand-decal-ruin"] = {{x=-62.3359375, y=-40.17578125, graphics_variation=12}, {x=-12.6640625, y=-34.4921875, graphics_variation=15}, {x=-62.7890625, y=-31.546875, graphics_variation=7}, {x=4.2109375, y=-18.08203125, graphics_variation=13}, {x=3.703125, y=0.0078125, graphics_variation=11}, },
    ["wooden-barrel"] = {{x=69.6953125, y=-37.54296875, graphics_variation=1}, {x=79.3828125, y=-17.359375, graphics_variation=1}, {x=12.640625, y=3.5859375, graphics_variation=1}, {x=81.8515625, y=28.921875, graphics_variation=1}, {x=14.8515625, y=39.12109375, graphics_variation=1}, {x=14.7890625, y=40.63671875, graphics_variation=1}, {x=14.8671875, y=42.08984375, graphics_variation=1}, {x=12.2109375, y=47.21484375, graphics_variation=1}, {x=43.30078125, y=59.48046875, graphics_variation=1}, {x=48.3359375, y=76.7578125, graphics_variation=1}, {x=47.359375, y=76.64453125, graphics_variation=1}, {x=80.59765625, y=76.8203125, graphics_variation=1}, {x=48.58984375, y=77.56640625, graphics_variation=1}, {x=48.58984375, y=78.5703125, graphics_variation=1}, {x=36.33984375, y=106.6171875, graphics_variation=1}, {x=84.7890625, y=111.578125, graphics_variation=1}, },
  },
  default_under_tile = "mineral-tan-dirt-3", -- put under all minable tiles
  tiles = {
    ["mineral-tan-dirt-3"] = {{-96,-30}, {-96,-29}, {-96,-28}, {-96,-27}, {-96,-5}, {-96,-4}, {-96,-3}, {-96,-2}, {-96,-1}, {-96,0}, {-96,1}, {-96,2}, {-96,3}, {-95,-30}, {-93,68}, {-93,69}, {-93,70}, {-93,71}, {-93,72}, {-93,73}, {-93,74}, {-93,75}, {-93,76}, {-93,77}, {-92,68}, {-92,69}, {-92,70}, {-92,71}, {-92,72}, {-92,73}, {-92,74}, {-92,75}, {-92,76}, {-92,77}, {-91,71}, {-91,72}, {-91,73}, {-91,74}, {-91,75}, {-91,76}, {-90,-42}, {-90,-41}, {-90,-40}, {-90,-39}, {-90,-38}, {-89,-42}, {-89,-41}, {-89,-40}, {-89,-39}, {-89,-38}, {-88,-42}, {-88,-41}, {-88,-40}, {-85,83}, {-85,84}, {-85,85}, {-85,86}, {-85,87}, {-84,69}, {-84,70}, {-84,71}, {-84,72}, {-84,73}, {-84,74}, {-84,75}, {-84,76}, {-84,77}, {-84,78}, {-84,79}, {-84,80}, {-84,81}, {-84,82}, {-84,83}, {-84,84}, {-84,85}, {-84,86}, {-84,87}, {-83,-104}, {-83,-103}, {-83,-102}, {-83,-101}, {-83,-82}, {-83,-81}, {-83,-80}, {-83,-60}, {-83,-59}, {-83,-58}, {-82,-106}, {-82,-105}, {-82,-104}, {-82,-103}, {-82,-102}, {-82,-101}, {-82,-100}, {-82,-99}, {-82,-81}, {-82,-80}, {-82,-79}, {-82,-59}, {-82,-58}, {-82,-57}, {-82,-35}, {-82,-34}, {-82,-33}, {-82,-32}, {-81,-108}, {-81,-107}, {-81,-106}, {-81,-105}, {-81,-104}, {-81,-101}, {-81,-100}, {-81,-99}, {-81,-98}, {-81,-97}, {-81,-81}, {-81,-80}, {-81,-79}, {-81,-60}, {-81,-59}, {-81,-58}, {-81,-57}, {-81,-35}, {-81,-34}, {-81,-33}, {-81,-32}, {-80,-118}, {-80,-117}, {-80,-116}, {-80,-115}, {-80,-114}, {-80,-113}, {-80,-112}, {-80,-111}, {-80,-108}, {-80,-107}, {-80,-106}, {-80,-105}, {-80,-104}, {-80,-103}, {-80,-98}, {-80,-97}, {-80,-96}, {-80,-81}, {-80,-80}, {-80,-79}, {-80,-60}, {-80,-59}, {-80,-58}, {-80,-57}, {-80,-37}, {-80,-36}, {-80,-35}, {-80,-34}, {-79,-119}, {-79,-118}, {-79,-117}, {-79,-116}, {-79,-115}, {-79,-114}, {-79,-113}, {-79,-112}, {-79,-111}, {-79,-110}, {-79,-109}, {-79,-108}, {-79,-107}, {-79,-105}, {-79,-104}, {-79,-103}, {-79,-102}, {-79,-101}, {-79,-100}, {-79,-97}, {-79,-96}, {-79,-95}, {-79,-94}, {-79,-93}, {-79,-80}, {-79,-79}, {-79,-78}, {-79,-60}, {-79,-59}, {-79,-58}, {-79,-40}, {-79,-39}, {-79,-37}, {-79,-36}, {-79,-35}, {-78,-120}, {-78,-119}, {-78,-118}, {-78,-117}, {-78,-116}, {-78,-115}, {-78,-111}, {-78,-110}, {-78,-109}, {-78,-108}, {-78,-107}, {-78,-106}, {-78,-105}, {-78,-103}, {-78,-102}, {-78,-101}, {-78,-100}, {-78,-99}, {-78,-98}, {-78,-96}, {-78,-95}, {-78,-94}, {-78,-93}, {-78,-92}, {-78,-91}, {-78,-80}, {-78,-79}, {-78,-78}, {-78,-77}, {-78,-61}, {-78,-60}, {-78,-59}, {-78,-58}, {-78,-40}, {-78,-39}, {-78,-38}, {-78,-37}, {-78,-36}, {-78,76}, {-78,77}, {-78,79}, {-78,80}, {-78,81}, {-78,82}, {-77,-120}, {-77,-119}, {-77,-118}, {-77,-117}, {-77,-116}, {-77,-115}, {-77,-114}, {-77,-108}, {-77,-107}, {-77,-106}, {-77,-105}, {-77,-104}, {-77,-101}, {-77,-100}, {-77,-99}, {-77,-98}, {-77,-97}, {-77,-96}, {-77,-94}, {-77,-93}, {-77,-92}, {-77,-91}, {-77,-90}, {-77,-89}, {-77,-80}, {-77,-79}, {-77,-78}, {-77,-77}, {-77,-61}, {-77,-60}, {-77,-59}, {-77,-58}, {-77,-47}, {-77,-45}, {-77,-43}, {-77,-42}, {-77,-41}, {-77,-40}, {-77,-39}, {-77,-38}, {-77,-37}, {-77,-36}, {-77,-35}, {-77,74}, {-77,75}, {-77,76}, {-77,77}, {-77,78}, {-77,79}, {-77,80}, {-77,81}, {-77,82}, {-77,83}, {-77,84}, {-77,85}, {-77,86}, {-77,89}, {-77,90}, {-76,-120}, {-76,-119}, {-76,-118}, {-76,-117}, {-76,-116}, {-76,-115}, {-76,-114}, {-76,-113}, {-76,-112}, {-76,-107}, {-76,-106}, {-76,-105}, {-76,-104}, {-76,-99}, {-76,-98}, {-76,-97}, {-76,-96}, {-76,-95}, {-76,-94}, {-76,-91}, {-76,-90}, {-76,-89}, {-76,-88}, {-76,-87}, {-76,-80}, {-76,-79}, {-76,-78}, {-76,-77}, {-76,-76}, {-76,-62}, {-76,-61}, {-76,-60}, {-76,-59}, {-76,-50}, {-76,-49}, {-76,-48}, {-76,-47}, {-76,-46}, {-76,-45}, {-76,-44}, {-76,-43}, {-76,-42}, {-76,-41}, {-76,-40}, {-76,-39}, {-76,-38}, {-76,-37}, {-76,-36}, {-76,-35}, {-76,-34}, {-76,-33}, {-76,74}, {-76,75}, {-76,76}, {-76,77}, {-76,78}, {-76,79}, {-76,80}, {-76,81}, {-76,82}, {-76,83}, {-76,84}, {-76,85}, {-76,86}, {-76,89}, {-76,90}, {-76,91}, {-75,-120}, {-75,-119}, {-75,-118}, {-75,-117}, {-75,-115}, {-75,-114}, {-75,-113}, {-75,-112}, {-75,-111}, {-75,-110}, {-75,-109}, {-75,-105}, {-75,-104}, {-75,-103}, {-75,-102}, {-75,-97}, {-75,-96}, {-75,-95}, {-75,-94}, {-75,-93}, {-75,-92}, {-75,-90}, {-75,-89}, {-75,-88}, {-75,-87}, {-75,-86}, {-75,-80}, {-75,-79}, {-75,-78}, {-75,-77}, {-75,-76}, {-75,-63}, {-75,-62}, {-75,-61}, {-75,-60}, {-75,-59}, {-75,-51}, {-75,-50}, {-75,-49}, {-75,-48}, {-75,-47}, {-75,-46}, {-75,-45}, {-75,-44}, {-75,-43}, {-75,-42}, {-75,-41}, {-75,-40}, {-75,-39}, {-75,-38}, {-75,-37}, {-75,-36}, {-75,-35}, {-75,-34}, {-75,-33}, {-75,74}, {-75,75}, {-75,77}, {-75,78}, {-75,79}, {-75,80}, {-75,81}, {-75,82}, {-75,83}, {-75,84}, {-75,85}, {-75,86}, {-75,87}, {-75,88}, {-75,89}, {-75,90}, {-75,91}, {-74,-120}, {-74,-119}, {-74,-118}, {-74,-117}, {-74,-112}, {-74,-111}, {-74,-110}, {-74,-109}, {-74,-108}, {-74,-107}, {-74,-104}, {-74,-103}, {-74,-102}, {-74,-101}, {-74,-96}, {-74,-95}, {-74,-94}, {-74,-93}, {-74,-92}, {-74,-91}, {-74,-90}, {-74,-89}, {-74,-88}, {-74,-87}, {-74,-86}, {-74,-80}, {-74,-79}, {-74,-78}, {-74,-77}, {-74,-76}, {-74,-75}, {-74,-74}, {-74,-73}, {-74,-63}, {-74,-62}, {-74,-61}, {-74,-60}, {-74,-59}, {-74,-51}, {-74,-50}, {-74,-49}, {-74,-48}, {-74,-47}, {-74,-46}, {-74,-45}, {-74,-44}, {-74,-43}, {-74,-42}, {-74,-41}, {-74,-40}, {-74,-39}, {-74,-38}, {-74,-37}, {-74,-36}, {-74,-35}, {-74,-34}, {-74,-33}, {-74,73}, {-74,74}, {-74,75}, {-74,76}, {-74,77}, {-74,78}, {-74,79}, {-74,80}, {-74,82}, {-74,83}, {-74,84}, {-74,85}, {-74,86}, {-74,89}, {-74,90}, {-74,91}, {-73,-119}, {-73,-118}, {-73,-117}, {-73,-110}, {-73,-109}, {-73,-108}, {-73,-107}, {-73,-106}, {-73,-103}, {-73,-102}, {-73,-101}, {-73,-100}, {-73,-99}, {-73,-98}, {-73,-97}, {-73,-96}, {-73,-94}, {-73,-93}, {-73,-92}, {-73,-91}, {-73,-90}, {-73,-89}, {-73,-88}, {-73,-87}, {-73,-86}, {-73,-79}, {-73,-78}, {-73,-77}, {-73,-76}, {-73,-75}, {-73,-74}, {-73,-73}, {-73,-72}, {-73,-66}, {-73,-65}, {-73,-64}, {-73,-63}, {-73,-62}, {-73,-61}, {-73,-60}, {-73,-59}, {-73,-51}, {-73,-50}, {-73,-49}, {-73,-48}, {-73,-47}, {-73,-46}, {-73,-45}, {-73,-44}, {-73,-43}, {-73,-42}, {-73,-41}, {-73,-40}, {-73,-39}, {-73,-38}, {-73,-37}, {-73,-36}, {-73,-35}, {-73,-34}, {-73,-33}, {-73,73}, {-73,74}, {-73,75}, {-73,76}, {-73,77}, {-73,78}, {-73,79}, {-73,84}, {-73,85}, {-73,86}, {-73,87}, {-73,88}, {-73,89}, {-73,90}, {-72,-119}, {-72,-118}, {-72,-117}, {-72,-116}, {-72,-115}, {-72,-114}, {-72,-109}, {-72,-108}, {-72,-107}, {-72,-106}, {-72,-105}, {-72,-104}, {-72,-101}, {-72,-100}, {-72,-99}, {-72,-98}, {-72,-97}, {-72,-96}, {-72,-95}, {-72,-94}, {-72,-92}, {-72,-91}, {-72,-90}, {-72,-89}, {-72,-88}, {-72,-87}, {-72,-77}, {-72,-75}, {-72,-74}, {-72,-65}, {-72,-62}, {-72,-51}, {-72,-50}, {-72,-49}, {-72,-48}, {-72,-47}, {-72,-46}, {-72,-45}, {-72,-44}, {-72,-43}, {-72,-42}, {-72,-41}, {-72,-40}, {-72,-39}, {-72,-38}, {-72,-37}, {-72,-36}, {-72,-35}, {-72,-34}, {-72,-33}, {-72,-32}, {-72,73}, {-72,74}, {-72,75}, {-72,76}, {-72,77}, {-72,78}, {-72,79}, {-72,84}, {-72,85}, {-72,86}, {-72,87}, {-72,88}, {-72,89}, {-72,90}, {-71,-119}, {-71,-118}, {-71,-117}, {-71,-116}, {-71,-115}, {-71,-114}, {-71,-113}, {-71,-112}, {-71,-107}, {-71,-106}, {-71,-105}, {-71,-104}, {-71,-103}, {-71,-102}, {-71,-99}, {-71,-98}, {-71,-97}, {-71,-96}, {-71,-95}, {-71,-94}, {-71,-93}, {-71,-90}, {-71,-89}, {-71,-88}, {-71,-87}, {-71,-50}, {-71,-49}, {-71,-48}, {-71,-47}, {-71,-46}, {-71,-45}, {-71,-44}, {-71,-43}, {-71,-42}, {-71,-41}, {-71,-40}, {-71,-39}, {-71,-38}, {-71,-37}, {-71,-36}, {-71,-35}, {-71,-34}, {-71,-33}, {-71,-32}, {-71,-31}, {-71,73}, {-71,74}, {-71,75}, {-71,76}, {-71,77}, {-71,78}, {-71,81}, {-71,83}, {-71,84}, {-71,85}, {-71,86}, {-71,87}, {-71,88}, {-71,89}, {-71,90}, {-70,-119}, {-70,-118}, {-70,-117}, {-70,-116}, {-70,-115}, {-70,-114}, {-70,-113}, {-70,-112}, {-70,-111}, {-70,-106}, {-70,-105}, {-70,-104}, {-70,-103}, {-70,-102}, {-70,-101}, {-70,-100}, {-70,-97}, {-70,-96}, {-70,-95}, {-70,-94}, {-70,-93}, {-70,-92}, {-70,-90}, {-70,-89}, {-70,-88}, {-70,-87}, {-70,-50}, {-70,-49}, {-70,-48}, {-70,-47}, {-70,-46}, {-70,-45}, {-70,-44}, {-70,-43}, {-70,-42}, {-70,-41}, {-70,-40}, {-70,-39}, {-70,-38}, {-70,-37}, {-70,-36}, {-70,-35}, {-70,-34}, {-70,-32}, {-70,-31}, {-70,73}, {-70,74}, {-70,75}, {-70,76}, {-70,77}, {-70,78}, {-70,79}, {-70,80}, {-70,81}, {-70,82}, {-70,83}, {-70,84}, {-70,85}, {-70,86}, {-70,87}, {-70,88}, {-70,89}, {-70,90}, {-69,-118}, {-69,-117}, {-69,-114}, {-69,-113}, {-69,-112}, {-69,-111}, {-69,-110}, {-69,-105}, {-69,-104}, {-69,-103}, {-69,-102}, {-69,-101}, {-69,-100}, {-69,-99}, {-69,-95}, {-69,-94}, {-69,-93}, {-69,-92}, {-69,-88}, {-69,-87}, {-69,-80}, {-69,-59}, {-69,-50}, {-69,-49}, {-69,-48}, {-69,-47}, {-69,-46}, {-69,-45}, {-69,-44}, {-69,-43}, {-69,-42}, {-69,-41}, {-69,-40}, {-69,-39}, {-69,-38}, {-69,-37}, {-69,-36}, {-69,-35}, {-69,-34}, {-69,-33}, {-69,74}, {-69,75}, {-69,76}, {-69,77}, {-69,78}, {-69,79}, {-69,80}, {-69,81}, {-69,82}, {-69,83}, {-69,84}, {-69,86}, {-69,87}, {-68,-118}, {-68,-117}, {-68,-112}, {-68,-111}, {-68,-110}, {-68,-109}, {-68,-108}, {-68,-103}, {-68,-102}, {-68,-101}, {-68,-100}, {-68,-99}, {-68,-94}, {-68,-93}, {-68,-92}, {-68,-91}, {-68,-90}, {-68,-88}, {-68,-87}, {-68,-50}, {-68,-49}, {-68,-48}, {-68,-47}, {-68,-46}, {-68,-45}, {-68,-44}, {-68,-43}, {-68,-42}, {-68,-41}, {-68,-40}, {-68,-39}, {-68,-38}, {-68,-37}, {-68,-36}, {-68,-35}, {-68,-34}, {-68,-33}, {-68,-32}, {-68,-31}, {-68,74}, {-68,75}, {-68,76}, {-68,77}, {-68,78}, {-68,79}, {-68,80}, {-68,81}, {-68,82}, {-68,83}, {-68,84}, {-68,85}, {-68,86}, {-67,-118}, {-67,-117}, {-67,-116}, {-67,-115}, {-67,-111}, {-67,-110}, {-67,-109}, {-67,-108}, {-67,-107}, {-67,-106}, {-67,-102}, {-67,-101}, {-67,-100}, {-67,-99}, {-67,-98}, {-67,-97}, {-67,-93}, {-67,-92}, {-67,-91}, {-67,-90}, {-67,-89}, {-67,-88}, {-67,-87}, {-67,-50}, {-67,-49}, {-67,-48}, {-67,-47}, {-67,-46}, {-67,-45}, {-67,-44}, {-67,-43}, {-67,-42}, {-67,-41}, {-67,-40}, {-67,-39}, {-67,-38}, {-67,-37}, {-67,-36}, {-67,-35}, {-67,-34}, {-67,-33}, {-67,-32}, {-67,-31}, {-67,77}, {-67,78}, {-67,79}, {-67,81}, {-67,82}, {-67,83}, {-67,84}, {-66,-118}, {-66,-117}, {-66,-116}, {-66,-115}, {-66,-109}, {-66,-108}, {-66,-107}, {-66,-106}, {-66,-105}, {-66,-101}, {-66,-100}, {-66,-99}, {-66,-98}, {-66,-97}, {-66,-96}, {-66,-95}, {-66,-91}, {-66,-90}, {-66,-89}, {-66,-88}, {-66,-87}, {-66,-80}, {-66,-59}, {-66,-49}, {-66,-48}, {-66,-47}, {-66,-46}, {-66,-45}, {-66,-44}, {-66,-43}, {-66,-42}, {-66,-41}, {-66,-40}, {-66,-39}, {-66,-38}, {-66,-37}, {-66,-36}, {-66,-35}, {-66,-34}, {-66,-33}, {-66,-32}, {-66,-31}, {-66,78}, {-66,79}, {-66,80}, {-65,-117}, {-65,-116}, {-65,-115}, {-65,-114}, {-65,-113}, {-65,-112}, {-65,-107}, {-65,-106}, {-65,-105}, {-65,-104}, {-65,-100}, {-65,-99}, {-65,-98}, {-65,-97}, {-65,-96}, {-65,-95}, {-65,-94}, {-65,-89}, {-65,-88}, {-65,-87}, {-65,-48}, {-65,-47}, {-65,-46}, {-65,-45}, {-65,-44}, {-65,-43}, {-65,-42}, {-65,-41}, {-65,-40}, {-65,-39}, {-65,-38}, {-65,-37}, {-65,-36}, {-65,-35}, {-65,-34}, {-65,-33}, {-65,-32}, {-64,-118}, {-64,-117}, {-64,-116}, {-64,-115}, {-64,-114}, {-64,-113}, {-64,-112}, {-64,-111}, {-64,-106}, {-64,-105}, {-64,-104}, {-64,-103}, {-64,-102}, {-64,-98}, {-64,-97}, {-64,-96}, {-64,-95}, {-64,-94}, {-64,-93}, {-64,-92}, {-64,-89}, {-64,-88}, {-64,-87}, {-64,-44}, {-64,-43}, {-64,-42}, {-64,-41}, {-64,-40}, {-64,-39}, {-64,-38}, {-64,-37}, {-64,-36}, {-64,-35}, {-64,-34}, {-64,-33}, {-64,-32}, {-64,-31}, {-63,-118}, {-63,-117}, {-63,-116}, {-63,-115}, {-63,-114}, {-63,-113}, {-63,-112}, {-63,-111}, {-63,-110}, {-63,-109}, {-63,-104}, {-63,-103}, {-63,-102}, {-63,-101}, {-63,-95}, {-63,-94}, {-63,-93}, {-63,-92}, {-63,-91}, {-63,-90}, {-63,-89}, {-63,-88}, {-63,-87}, {-63,-80}, {-63,-32}, {-63,-31}, {-63,-30}, {-62,-118}, {-62,-117}, {-62,-116}, {-62,-115}, {-62,-114}, {-62,-113}, {-62,-112}, {-62,-111}, {-62,-110}, {-62,-109}, {-62,-108}, {-62,-102}, {-62,-101}, {-62,-100}, {-62,-99}, {-62,-93}, {-62,-92}, {-62,-91}, {-62,-90}, {-62,-89}, {-62,-88}, {-62,-87}, {-62,-31}, {-62,-30}, {-62,140}, {-61,-118}, {-61,-117}, {-61,-116}, {-61,-115}, {-61,-112}, {-61,-111}, {-61,-110}, {-61,-109}, {-61,-108}, {-61,-107}, {-61,-101}, {-61,-100}, {-61,-99}, {-61,-98}, {-61,-92}, {-61,-91}, {-61,-90}, {-61,-89}, {-61,-88}, {-61,-87}, {-61,140}, {-61,146}, {-60,-116}, {-60,-115}, {-60,-111}, {-60,-110}, {-60,-109}, {-60,-108}, {-60,-107}, {-60,-106}, {-60,-105}, {-60,-100}, {-60,-99}, {-60,-98}, {-60,-97}, {-60,-96}, {-60,-90}, {-60,-89}, {-60,-88}, {-60,-87}, {-60,-80}, {-60,140}, {-60,145}, {-60,146}, {-59,-116}, {-59,-115}, {-59,-114}, {-59,-113}, {-59,-110}, {-59,-109}, {-59,-108}, {-59,-107}, {-59,-106}, {-59,-105}, {-59,-104}, {-59,-103}, {-59,-98}, {-59,-97}, {-59,-96}, {-59,-95}, {-59,-94}, {-59,-89}, {-59,-88}, {-59,-87}, {-59,140}, {-59,145}, {-59,146}, {-58,-116}, {-58,-115}, {-58,-114}, {-58,-113}, {-58,-112}, {-58,-108}, {-58,-107}, {-58,-106}, {-58,-105}, {-58,-104}, {-58,-103}, {-58,-102}, {-58,-96}, {-58,-95}, {-58,-94}, {-58,-93}, {-58,-92}, {-58,-88}, {-58,-87}, {-58,140}, {-58,141}, {-58,145}, {-57,-116}, {-57,-115}, {-57,-114}, {-57,-113}, {-57,-112}, {-57,-111}, {-57,-110}, {-57,-106}, {-57,-105}, {-57,-104}, {-57,-103}, {-57,-102}, {-57,-101}, {-57,-94}, {-57,-93}, {-57,-92}, {-57,-91}, {-57,-88}, {-57,-87}, {-57,-80}, {-57,-59}, {-57,140}, {-57,141}, {-56,-116}, {-56,-115}, {-56,-114}, {-56,-113}, {-56,-112}, {-56,-111}, {-56,-110}, {-56,-109}, {-56,-104}, {-56,-103}, {-56,-102}, {-56,-101}, {-56,-100}, {-56,-99}, {-56,-98}, {-56,-93}, {-56,-92}, {-56,-91}, {-56,-90}, {-56,-89}, {-56,-88}, {-56,-87}, {-56,140}, {-56,141}, {-56,146}, {-55,-116}, {-55,-115}, {-55,-113}, {-55,-112}, {-55,-111}, {-55,-110}, {-55,-109}, {-55,-108}, {-55,-102}, {-55,-101}, {-55,-100}, {-55,-99}, {-55,-98}, {-55,-91}, {-55,-90}, {-55,-89}, {-55,-88}, {-55,-87}, {-55,140}, {-55,141}, {-55,145}, {-55,146}, {-54,-116}, {-54,-115}, {-54,-111}, {-54,-110}, {-54,-109}, {-54,-108}, {-54,-107}, {-54,-101}, {-54,-100}, {-54,-99}, {-54,-98}, {-54,-97}, {-54,-90}, {-54,-89}, {-54,-88}, {-54,-80}, {-54,-59}, {-54,140}, {-54,141}, {-54,145}, {-54,146}, {-54,147}, {-53,-116}, {-53,-115}, {-53,-110}, {-53,-109}, {-53,-108}, {-53,-107}, {-53,-106}, {-53,-100}, {-53,-99}, {-53,-98}, {-53,-97}, {-53,-96}, {-53,-95}, {-53,-94}, {-53,-89}, {-53,-88}, {-53,140}, {-53,141}, {-53,145}, {-53,146}, {-53,147}, {-52,-116}, {-52,-115}, {-52,-114}, {-52,-113}, {-52,-108}, {-52,-107}, {-52,-106}, {-52,-105}, {-52,-104}, {-52,-99}, {-52,-98}, {-52,-97}, {-52,-96}, {-52,-95}, {-52,-94}, {-52,-93}, {-52,-89}, {-52,-88}, {-52,-87}, {-52,140}, {-52,141}, {-52,146}, {-51,-116}, {-51,-115}, {-51,-114}, {-51,-113}, {-51,-107}, {-51,-106}, {-51,-105}, {-51,-104}, {-51,-103}, {-51,-102}, {-51,-97}, {-51,-96}, {-51,-95}, {-51,-94}, {-51,-93}, {-51,-92}, {-51,-91}, {-51,-89}, {-51,-88}, {-51,-87}, {-51,-78}, {-51,-77}, {-51,-74}, {-51,-65}, {-51,-62}, {-51,140}, {-51,141}, {-50,-115}, {-50,-114}, {-50,-113}, {-50,-112}, {-50,-111}, {-50,-110}, {-50,-106}, {-50,-105}, {-50,-104}, {-50,-103}, {-50,-102}, {-50,-94}, {-50,-93}, {-50,-92}, {-50,-91}, {-50,-90}, {-50,-89}, {-50,-88}, {-50,-87}, {-50,-34}, {-50,-33}, {-50,140}, {-50,141}, {-49,-115}, {-49,-114}, {-49,-113}, {-49,-112}, {-49,-111}, {-49,-110}, {-49,-109}, {-49,-104}, {-49,-103}, {-49,-102}, {-49,-101}, {-49,-100}, {-49,-92}, {-49,-91}, {-49,-90}, {-49,-89}, {-49,-88}, {-49,-87}, {-49,-34}, {-49,-33}, {-49,-32}, {-49,140}, {-49,141}, {-49,146}, {-48,-115}, {-48,-114}, {-48,-113}, {-48,-112}, {-48,-111}, {-48,-110}, {-48,-109}, {-48,-108}, {-48,-107}, {-48,-102}, {-48,-101}, {-48,-100}, {-48,-99}, {-48,-98}, {-48,-90}, {-48,-89}, {-48,-88}, {-48,-87}, {-48,-34}, {-48,-33}, {-48,-32}, {-48,-31}, {-48,-30}, {-48,140}, {-48,141}, {-48,145}, {-48,146}, {-47,-115}, {-47,-114}, {-47,-113}, {-47,-112}, {-47,-111}, {-47,-110}, {-47,-109}, {-47,-108}, {-47,-107}, {-47,-106}, {-47,-105}, {-47,-101}, {-47,-100}, {-47,-99}, {-47,-98}, {-47,-97}, {-47,-96}, {-47,-90}, {-47,-89}, {-47,-88}, {-47,-33}, {-47,-32}, {-47,-31}, {-47,-30}, {-47,140}, {-47,141}, {-47,145}, {-47,146}, {-46,-114}, {-46,-113}, {-46,-110}, {-46,-109}, {-46,-108}, {-46,-107}, {-46,-106}, {-46,-105}, {-46,-104}, {-46,-99}, {-46,-98}, {-46,-97}, {-46,-96}, {-46,-95}, {-46,-94}, {-46,-89}, {-46,-88}, {-46,-33}, {-46,-32}, {-46,-31}, {-46,-30}, {-46,140}, {-46,141}, {-46,145}, {-46,146}, {-45,-114}, {-45,-113}, {-45,-112}, {-45,-108}, {-45,-107}, {-45,-106}, {-45,-105}, {-45,-104}, {-45,-103}, {-45,-102}, {-45,-98}, {-45,-97}, {-45,-96}, {-45,-95}, {-45,-94}, {-45,-93}, {-45,-92}, {-45,-91}, {-45,-89}, {-45,-88}, {-45,-59}, {-45,-33}, {-45,-32}, {-45,140}, {-45,141}, {-45,146}, {-44,-113}, {-44,-112}, {-44,-111}, {-44,-110}, {-44,-106}, {-44,-105}, {-44,-104}, {-44,-103}, {-44,-102}, {-44,-101}, {-44,-96}, {-44,-95}, {-44,-94}, {-44,-93}, {-44,-92}, {-44,-91}, {-44,-89}, {-44,-88}, {-44,-59}, {-44,-33}, {-44,-32}, {-44,-31}, {-44,140}, {-44,141}, {-43,-113}, {-43,-112}, {-43,-111}, {-43,-110}, {-43,-109}, {-43,-108}, {-43,-104}, {-43,-103}, {-43,-102}, {-43,-101}, {-43,-100}, {-43,-95}, {-43,-94}, {-43,-93}, {-43,-92}, {-43,-91}, {-43,-90}, {-43,-89}, {-43,-88}, {-43,-76}, {-43,-75}, {-43,-74}, {-43,-32}, {-43,-31}, {-43,140}, {-43,141}, {-42,-113}, {-42,-112}, {-42,-111}, {-42,-110}, {-42,-109}, {-42,-108}, {-42,-107}, {-42,-102}, {-42,-101}, {-42,-100}, {-42,-99}, {-42,-98}, {-42,-93}, {-42,-92}, {-42,-91}, {-42,-90}, {-42,-89}, {-42,-88}, {-42,-76}, {-42,-75}, {-42,-74}, {-42,-73}, {-42,-32}, {-42,-31}, {-42,140}, {-42,141}, {-42,146}, {-41,-113}, {-41,-112}, {-41,-111}, {-41,-109}, {-41,-108}, {-41,-107}, {-41,-106}, {-41,-105}, {-41,-100}, {-41,-99}, {-41,-98}, {-41,-97}, {-41,-92}, {-41,-91}, {-41,-90}, {-41,-89}, {-41,-81}, {-41,-80}, {-41,-76}, {-41,-75}, {-41,-74}, {-41,-73}, {-41,-72}, {-41,140}, {-41,145}, {-41,146}, {-41,147}, {-40,-113}, {-40,-112}, {-40,-111}, {-40,-107}, {-40,-106}, {-40,-105}, {-40,-104}, {-40,-99}, {-40,-98}, {-40,-97}, {-40,-96}, {-40,-95}, {-40,-90}, {-40,-89}, {-40,-81}, {-40,-80}, {-40,-79}, {-40,140}, {-40,145}, {-40,146}, {-40,147}, {-39,-113}, {-39,-112}, {-39,-111}, {-39,-110}, {-39,-106}, {-39,-105}, {-39,-104}, {-39,-103}, {-39,-98}, {-39,-97}, {-39,-96}, {-39,-95}, {-39,-94}, {-39,-93}, {-39,-92}, {-39,-91}, {-39,-90}, {-39,-89}, {-39,140}, {-39,145}, {-39,146}, {-39,147}, {-38,-113}, {-38,-112}, {-38,-111}, {-38,-110}, {-38,-109}, {-38,-104}, {-38,-103}, {-38,-102}, {-38,-101}, {-38,-95}, {-38,-94}, {-38,-93}, {-38,-92}, {-38,-91}, {-38,-90}, {-38,-89}, {-38,-82}, {-38,-79}, {-38,-78}, {-38,-77}, {-38,-76}, {-38,140}, {-38,145}, {-38,146}, {-37,-113}, {-37,-112}, {-37,-111}, {-37,-110}, {-37,-109}, {-37,-108}, {-37,-107}, {-37,-103}, {-37,-102}, {-37,-101}, {-37,-100}, {-37,-94}, {-37,-93}, {-37,-92}, {-37,-91}, {-37,-90}, {-37,-89}, {-37,-82}, {-37,-81}, {-37,-80}, {-37,-79}, {-37,-78}, {-37,-77}, {-37,-76}, {-37,-53}, {-37,-52}, {-37,140}, {-36,-112}, {-36,-111}, {-36,-110}, {-36,-109}, {-36,-108}, {-36,-107}, {-36,-106}, {-36,-101}, {-36,-100}, {-36,-99}, {-36,-98}, {-36,-91}, {-36,-90}, {-36,-89}, {-36,-82}, {-36,-81}, {-36,-80}, {-36,-79}, {-36,-78}, {-36,-53}, {-36,-52}, {-36,140}, {-35,-112}, {-35,-111}, {-35,-108}, {-35,-107}, {-35,-106}, {-35,-105}, {-35,-104}, {-35,-99}, {-35,-98}, {-35,-97}, {-35,-96}, {-35,-91}, {-35,-90}, {-35,-89}, {-35,-82}, {-35,-81}, {-35,-80}, {-35,-53}, {-35,-52}, {-35,140}, {-35,146}, {-35,147}, {-34,-112}, {-34,-111}, {-34,-107}, {-34,-106}, {-34,-105}, {-34,-104}, {-34,-103}, {-34,-102}, {-34,-98}, {-34,-97}, {-34,-96}, {-34,-95}, {-34,-94}, {-34,-91}, {-34,-90}, {-34,-89}, {-34,-80}, {-34,-79}, {-34,-78}, {-34,-77}, {-34,-76}, {-34,-75}, {-34,-74}, {-34,140}, {-34,145}, {-34,146}, {-34,147}, {-33,-112}, {-33,-111}, {-33,-106}, {-33,-105}, {-33,-104}, {-33,-103}, {-33,-102}, {-33,-101}, {-33,-96}, {-33,-95}, {-33,-94}, {-33,-93}, {-33,-92}, {-33,-91}, {-33,-90}, {-33,-89}, {-33,-80}, {-33,-79}, {-33,-78}, {-33,-77}, {-33,-76}, {-33,-75}, {-33,-74}, {-33,145}, {-33,146}, {-33,147}, {-32,-112}, {-32,-111}, {-32,-110}, {-32,-104}, {-32,-103}, {-32,-102}, {-32,-101}, {-32,-100}, {-32,-99}, {-32,-95}, {-32,-94}, {-32,-93}, {-32,-92}, {-32,-91}, {-32,-90}, {-32,-83}, {-32,-82}, {-32,-81}, {-32,-80}, {-32,-79}, {-32,-78}, {-32,-77}, {-32,-74}, {-32,-44}, {-32,-43}, {-32,146}, {-32,147}, {-31,-111}, {-31,-110}, {-31,-109}, {-31,-108}, {-31,-102}, {-31,-101}, {-31,-100}, {-31,-99}, {-31,-98}, {-31,-93}, {-31,-92}, {-31,-91}, {-31,-90}, {-31,-83}, {-31,-82}, {-31,-81}, {-31,-74}, {-31,-44}, {-31,-43}, {-30,-111}, {-30,-110}, {-30,-109}, {-30,-108}, {-30,-107}, {-30,-106}, {-30,-105}, {-30,-100}, {-30,-99}, {-30,-98}, {-30,-97}, {-30,-96}, {-30,-91}, {-30,-90}, {-30,-83}, {-30,-82}, {-30,-81}, {-30,-74}, {-30,-44}, {-30,-43}, {-29,-111}, {-29,-110}, {-29,-109}, {-29,-108}, {-29,-107}, {-29,-106}, {-29,-105}, {-29,-104}, {-29,-103}, {-29,-99}, {-29,-98}, {-29,-97}, {-29,-96}, {-29,-95}, {-29,-94}, {-29,-92}, {-29,-91}, {-29,-90}, {-29,-84}, {-29,-83}, {-29,-82}, {-29,-81}, {-29,-80}, {-29,-79}, {-29,-78}, {-29,-77}, {-29,-74}, {-29,-44}, {-29,-43}, {-28,-111}, {-28,-110}, {-28,-107}, {-28,-106}, {-28,-105}, {-28,-104}, {-28,-103}, {-28,-102}, {-28,-97}, {-28,-96}, {-28,-95}, {-28,-94}, {-28,-93}, {-28,-92}, {-28,-91}, {-28,-82}, {-28,-81}, {-28,-80}, {-28,-79}, {-28,-78}, {-28,-77}, {-28,-76}, {-28,-75}, {-28,-74}, {-28,-44}, {-28,-43}, {-28,-42}, {-28,-41}, {-28,-40}, {-28,-39}, {-27,-111}, {-27,-110}, {-27,-105}, {-27,-104}, {-27,-103}, {-27,-102}, {-27,-101}, {-27,-100}, {-27,-95}, {-27,-94}, {-27,-93}, {-27,-92}, {-27,-91}, {-27,-83}, {-27,-82}, {-27,-81}, {-27,-80}, {-27,-79}, {-27,-78}, {-27,-77}, {-27,-76}, {-27,-75}, {-27,-74}, {-27,-44}, {-27,-43}, {-27,-42}, {-27,-41}, {-27,-40}, {-27,-39}, {-26,-111}, {-26,-110}, {-26,-109}, {-26,-108}, {-26,-103}, {-26,-102}, {-26,-101}, {-26,-100}, {-26,-99}, {-26,-98}, {-26,-92}, {-26,-91}, {-26,-84}, {-26,-83}, {-26,-82}, {-26,-81}, {-26,-44}, {-26,-43}, {-26,-42}, {-26,-41}, {-26,-40}, {-25,-112}, {-25,-111}, {-25,-110}, {-25,-109}, {-25,-108}, {-25,-107}, {-25,-106}, {-25,-101}, {-25,-100}, {-25,-99}, {-25,-98}, {-25,-97}, {-25,-92}, {-25,-91}, {-25,-84}, {-25,-83}, {-25,-82}, {-25,-44}, {-25,-43}, {-25,-42}, {-25,-41}, {-25,-40}, {-24,-112}, {-24,-111}, {-24,-110}, {-24,-109}, {-24,-108}, {-24,-107}, {-24,-106}, {-24,-105}, {-24,-104}, {-24,-99}, {-24,-98}, {-24,-97}, {-24,-96}, {-24,-95}, {-24,-94}, {-24,-92}, {-24,-91}, {-24,-83}, {-24,-82}, {-24,-81}, {-24,-80}, {-24,-79}, {-24,-78}, {-24,-77}, {-24,-76}, {-24,-75}, {-24,-74}, {-24,-44}, {-24,-43}, {-24,-42}, {-24,-41}, {-24,-40}, {-23,-112}, {-23,-111}, {-23,-110}, {-23,-108}, {-23,-107}, {-23,-106}, {-23,-105}, {-23,-104}, {-23,-103}, {-23,-102}, {-23,-97}, {-23,-96}, {-23,-95}, {-23,-94}, {-23,-93}, {-23,-92}, {-23,-91}, {-23,-82}, {-23,-81}, {-23,-80}, {-23,-79}, {-23,-78}, {-23,-77}, {-23,-76}, {-23,-75}, {-23,-74}, {-23,-53}, {-23,-52}, {-23,-44}, {-23,-43}, {-23,-42}, {-23,-41}, {-23,-40}, {-23,148}, {-22,-112}, {-22,-111}, {-22,-110}, {-22,-106}, {-22,-105}, {-22,-104}, {-22,-103}, {-22,-102}, {-22,-101}, {-22,-100}, {-22,-96}, {-22,-95}, {-22,-94}, {-22,-93}, {-22,-92}, {-22,-91}, {-22,-84}, {-22,-83}, {-22,-82}, {-22,-81}, {-22,-79}, {-22,-78}, {-22,-77}, {-22,-76}, {-22,-75}, {-22,-74}, {-22,-53}, {-22,-52}, {-22,-51}, {-22,-44}, {-22,-43}, {-22,-42}, {-22,-41}, {-22,-20}, {-22,-19}, {-22,-18}, {-22,-17}, {-22,-16}, {-22,-15}, {-22,-14}, {-22,-13}, {-22,-12}, {-22,-11}, {-22,26}, {-22,27}, {-22,28}, {-22,29}, {-22,30}, {-22,31}, {-22,32}, {-22,148}, {-22,149}, {-21,-111}, {-21,-110}, {-21,-109}, {-21,-104}, {-21,-103}, {-21,-102}, {-21,-101}, {-21,-100}, {-21,-99}, {-21,-98}, {-21,-95}, {-21,-94}, {-21,-93}, {-21,-92}, {-21,-91}, {-21,-85}, {-21,-84}, {-21,-83}, {-21,-53}, {-21,-52}, {-21,-51}, {-21,-44}, {-21,-43}, {-21,-42}, {-21,-17}, {-21,-16}, {-21,-15}, {-21,-14}, {-21,-13}, {-21,-12}, {-21,-11}, {-21,27}, {-21,28}, {-21,29}, {-21,30}, {-21,31}, {-21,32}, {-21,33}, {-21,148}, {-21,149}, {-20,-111}, {-20,-110}, {-20,-109}, {-20,-108}, {-20,-107}, {-20,-102}, {-20,-101}, {-20,-100}, {-20,-99}, {-20,-98}, {-20,-97}, {-20,-96}, {-20,-93}, {-20,-92}, {-20,-85}, {-20,-84}, {-20,-83}, {-20,-52}, {-20,-51}, {-20,-44}, {-20,-43}, {-20,-42}, {-20,27}, {-20,28}, {-20,29}, {-20,30}, {-20,31}, {-20,32}, {-20,33}, {-20,148}, {-20,149}, {-19,-110}, {-19,-109}, {-19,-108}, {-19,-107}, {-19,-106}, {-19,-101}, {-19,-100}, {-19,-99}, {-19,-98}, {-19,-97}, {-19,-96}, {-19,-95}, {-19,-94}, {-19,-93}, {-19,-92}, {-19,-85}, {-19,-84}, {-19,-83}, {-19,-82}, {-19,-81}, {-19,-80}, {-19,-79}, {-19,-78}, {-19,-77}, {-19,-76}, {-19,-75}, {-19,-74}, {-19,-54}, {-19,-53}, {-19,-52}, {-19,-51}, {-19,27}, {-19,28}, {-19,29}, {-19,30}, {-19,31}, {-19,32}, {-19,33}, {-19,148}, {-19,149}, {-18,-110}, {-18,-109}, {-18,-108}, {-18,-107}, {-18,-106}, {-18,-105}, {-18,-100}, {-18,-99}, {-18,-98}, {-18,-97}, {-18,-96}, {-18,-95}, {-18,-94}, {-18,-93}, {-18,-92}, {-18,-83}, {-18,-82}, {-18,-81}, {-18,-80}, {-18,-79}, {-18,-78}, {-18,-77}, {-18,-76}, {-18,-75}, {-18,-74}, {-18,-54}, {-18,-53}, {-18,-52}, {-18,-51}, {-18,28}, {-18,29}, {-18,30}, {-18,31}, {-18,32}, {-18,33}, {-18,34}, {-18,92}, {-18,94}, {-18,100}, {-18,101}, {-18,148}, {-18,149}, {-17,-111}, {-17,-110}, {-17,-109}, {-17,-107}, {-17,-106}, {-17,-105}, {-17,-104}, {-17,-103}, {-17,-99}, {-17,-98}, {-17,-97}, {-17,-96}, {-17,-95}, {-17,-94}, {-17,-93}, {-17,-85}, {-17,-84}, {-17,-83}, {-17,-82}, {-17,-81}, {-17,-80}, {-17,-79}, {-17,-78}, {-17,-77}, {-17,-76}, {-17,-75}, {-17,-74}, {-17,-54}, {-17,-53}, {-17,-52}, {-17,-51}, {-17,28}, {-17,29}, {-17,30}, {-17,31}, {-17,32}, {-17,33}, {-17,34}, {-17,89}, {-17,91}, {-17,92}, {-17,93}, {-17,94}, {-17,95}, {-17,96}, {-17,97}, {-17,99}, {-17,100}, {-17,101}, {-17,148}, {-17,149}, {-16,-111}, {-16,-110}, {-16,-109}, {-16,-108}, {-16,-105}, {-16,-104}, {-16,-103}, {-16,-102}, {-16,-101}, {-16,-95}, {-16,-94}, {-16,-93}, {-16,-85}, {-16,-84}, {-16,-83}, {-16,-53}, {-16,-52}, {-16,-51}, {-16,-33}, {-16,-32}, {-16,-31}, {-16,29}, {-16,30}, {-16,87}, {-16,88}, {-16,90}, {-16,91}, {-16,92}, {-16,93}, {-16,94}, {-16,95}, {-16,96}, {-16,98}, {-16,101}, {-16,102}, {-16,103}, {-16,104}, {-16,105}, {-16,111}, {-16,148}, {-16,149}, {-15,-111}, {-15,-110}, {-15,-109}, {-15,-108}, {-15,-107}, {-15,-105}, {-15,-104}, {-15,-103}, {-15,-102}, {-15,-101}, {-15,-100}, {-15,-94}, {-15,-93}, {-15,-85}, {-15,-84}, {-15,-83}, {-15,-53}, {-15,-52}, {-15,-51}, {-15,-33}, {-15,-32}, {-15,-31}, {-15,-30}, {-15,-29}, {-15,-28}, {-15,-27}, {-15,29}, {-15,30}, {-15,85}, {-15,86}, {-15,87}, {-15,88}, {-15,89}, {-15,90}, {-15,91}, {-15,92}, {-15,93}, {-15,94}, {-15,95}, {-15,96}, {-15,97}, {-15,98}, {-15,99}, {-15,100}, {-15,101}, {-15,102}, {-15,103}, {-15,104}, {-15,105}, {-15,106}, {-15,111}, {-15,112}, {-15,148}, {-15,149}, {-14,-109}, {-14,-108}, {-14,-107}, {-14,-106}, {-14,-102}, {-14,-101}, {-14,-100}, {-14,-99}, {-14,-98}, {-14,-94}, {-14,-93}, {-14,-85}, {-14,-84}, {-14,-83}, {-14,-82}, {-14,-81}, {-14,-80}, {-14,-79}, {-14,-78}, {-14,-77}, {-14,-76}, {-14,-75}, {-14,-74}, {-14,-52}, {-14,-51}, {-14,-34}, {-14,-33}, {-14,-32}, {-14,-31}, {-14,-30}, {-14,-29}, {-14,-28}, {-14,-27}, {-14,-26}, {-14,30}, {-14,85}, {-14,88}, {-14,89}, {-14,90}, {-14,91}, {-14,94}, {-14,95}, {-14,96}, {-14,97}, {-14,98}, {-14,99}, {-14,100}, {-14,101}, {-14,102}, {-14,103}, {-14,105}, {-14,106}, {-14,110}, {-14,111}, {-14,112}, {-14,113}, {-14,148}, {-14,149}, {-14,150}, {-13,-108}, {-13,-107}, {-13,-106}, {-13,-105}, {-13,-100}, {-13,-99}, {-13,-98}, {-13,-97}, {-13,-96}, {-13,-94}, {-13,-93}, {-13,-83}, {-13,-82}, {-13,-81}, {-13,-80}, {-13,-79}, {-13,-78}, {-13,-77}, {-13,-76}, {-13,-75}, {-13,-74}, {-13,-52}, {-13,-51}, {-13,-35}, {-13,-34}, {-13,-33}, {-13,-32}, {-13,-31}, {-13,-30}, {-13,-29}, {-13,-28}, {-13,-27}, {-13,-26}, {-13,-25}, {-13,88}, {-13,89}, {-13,90}, {-13,95}, {-13,96}, {-13,98}, {-13,99}, {-13,100}, {-13,101}, {-13,102}, {-13,103}, {-13,104}, {-13,105}, {-13,106}, {-13,112}, {-13,113}, {-13,114}, {-13,115}, {-13,148}, {-13,149}, {-13,150}, {-12,-106}, {-12,-105}, {-12,-104}, {-12,-98}, {-12,-97}, {-12,-96}, {-12,-95}, {-12,-94}, {-12,-93}, {-12,-86}, {-12,-83}, {-12,-82}, {-12,-81}, {-12,-80}, {-12,-79}, {-12,-78}, {-12,-77}, {-12,-76}, {-12,-75}, {-12,-74}, {-12,-52}, {-12,-51}, {-12,-35}, {-12,-34}, {-12,-33}, {-12,-32}, {-12,-31}, {-12,-30}, {-12,-29}, {-12,-28}, {-12,-26}, {-12,-25}, {-12,-24}, {-12,-23}, {-12,-22}, {-12,-21}, {-12,89}, {-12,90}, {-12,91}, {-12,95}, {-12,96}, {-12,97}, {-12,98}, {-12,99}, {-12,100}, {-12,101}, {-12,102}, {-12,103}, {-12,104}, {-12,105}, {-12,107}, {-12,113}, {-12,114}, {-12,115}, {-12,148}, {-12,149}, {-12,150}, {-11,-106}, {-11,-105}, {-11,-104}, {-11,-103}, {-11,-102}, {-11,-97}, {-11,-96}, {-11,-95}, {-11,-94}, {-11,-93}, {-11,-86}, {-11,-85}, {-11,-84}, {-11,-35}, {-11,-34}, {-11,-33}, {-11,-32}, {-11,-31}, {-11,-30}, {-11,-29}, {-11,-28}, {-11,-26}, {-11,-25}, {-11,-24}, {-11,-23}, {-11,-22}, {-11,-21}, {-11,87}, {-11,88}, {-11,89}, {-11,90}, {-11,91}, {-11,95}, {-11,96}, {-11,97}, {-11,98}, {-11,99}, {-11,100}, {-11,101}, {-11,102}, {-11,104}, {-11,105}, {-11,106}, {-11,107}, {-11,108}, {-11,114}, {-11,115}, {-11,116}, {-11,149}, {-11,150}, {-10,-104}, {-10,-103}, {-10,-102}, {-10,-101}, {-10,-96}, {-10,-95}, {-10,-94}, {-10,-93}, {-10,-86}, {-10,-85}, {-10,-84}, {-10,-35}, {-10,-34}, {-10,-33}, {-10,-32}, {-10,-31}, {-10,-30}, {-10,-29}, {-10,-28}, {-10,-27}, {-10,-26}, {-10,-25}, {-10,-24}, {-10,-23}, {-10,-22}, {-10,86}, {-10,87}, {-10,88}, {-10,89}, {-10,90}, {-10,91}, {-10,92}, {-10,93}, {-10,97}, {-10,98}, {-10,99}, {-10,100}, {-10,101}, {-10,102}, {-10,103}, {-10,104}, {-10,105}, {-10,106}, {-10,107}, {-10,108}, {-10,114}, {-10,116}, {-10,149}, {-10,150}, {-9,-102}, {-9,-101}, {-9,-100}, {-9,-99}, {-9,-98}, {-9,-97}, {-9,-96}, {-9,-95}, {-9,-94}, {-9,-93}, {-9,-86}, {-9,-85}, {-9,-84}, {-9,-83}, {-9,-82}, {-9,-81}, {-9,-80}, {-9,-79}, {-9,-78}, {-9,-77}, {-9,-76}, {-9,-75}, {-9,-74}, {-9,-37}, {-9,-36}, {-9,-35}, {-9,-34}, {-9,-33}, {-9,-32}, {-9,-31}, {-9,-30}, {-9,-29}, {-9,-28}, {-9,-27}, {-9,-26}, {-9,-25}, {-9,-24}, {-9,-23}, {-9,-22}, {-9,89}, {-9,90}, {-9,91}, {-9,92}, {-9,93}, {-9,94}, {-9,95}, {-9,96}, {-9,97}, {-9,98}, {-9,99}, {-9,100}, {-9,101}, {-9,102}, {-9,103}, {-9,104}, {-9,105}, {-9,106}, {-9,107}, {-9,108}, {-9,109}, {-9,114}, {-9,148}, {-9,149}, {-9,150}, {-8,-101}, {-8,-100}, {-8,-99}, {-8,-98}, {-8,-97}, {-8,-96}, {-8,-95}, {-8,-84}, {-8,-83}, {-8,-82}, {-8,-81}, {-8,-80}, {-8,-79}, {-8,-78}, {-8,-77}, {-8,-76}, {-8,-75}, {-8,-74}, {-8,-37}, {-8,-36}, {-8,-35}, {-8,-34}, {-8,-33}, {-8,-32}, {-8,-31}, {-8,-30}, {-8,-29}, {-8,-28}, {-8,87}, {-8,88}, {-8,90}, {-8,91}, {-8,92}, {-8,93}, {-8,94}, {-8,95}, {-8,96}, {-8,97}, {-8,98}, {-8,103}, {-8,104}, {-8,106}, {-8,107}, {-8,108}, {-8,148}, {-8,149}, {-8,150}, {-7,-98}, {-7,-97}, {-7,-96}, {-7,-95}, {-7,-86}, {-7,-85}, {-7,-84}, {-7,-83}, {-7,-82}, {-7,-81}, {-7,-80}, {-7,-79}, {-7,-78}, {-7,-77}, {-7,-76}, {-7,-75}, {-7,-74}, {-7,-37}, {-7,-36}, {-7,-35}, {-7,-34}, {-7,-33}, {-7,-32}, {-7,-31}, {-7,-30}, {-7,-29}, {-7,86}, {-7,87}, {-7,89}, {-7,90}, {-7,91}, {-7,92}, {-7,93}, {-7,94}, {-7,95}, {-7,96}, {-7,108}, {-7,148}, {-7,149}, {-7,150}, {-6,-97}, {-6,-96}, {-6,-95}, {-6,-87}, {-6,-86}, {-6,-85}, {-6,-37}, {-6,-36}, {-6,-35}, {-6,-34}, {-6,-33}, {-6,87}, {-6,88}, {-6,89}, {-6,90}, {-6,148}, {-6,149}, {-6,150}, {-5,-111}, {-5,-110}, {-5,-109}, {-5,-87}, {-5,-86}, {-5,-85}, {-5,-37}, {-5,-36}, {-5,-35}, {-5,87}, {-5,90}, {-5,148}, {-5,149}, {-4,-111}, {-4,-110}, {-4,-109}, {-4,-108}, {-4,-107}, {-4,-85}, {-4,-84}, {-4,-83}, {-4,-82}, {-4,-81}, {-4,-80}, {-4,-79}, {-4,-78}, {-4,-77}, {-4,-76}, {-4,-75}, {-4,-74}, {-4,28}, {-4,30}, {-4,86}, {-4,88}, {-4,89}, {-4,148}, {-4,149}, {-3,-110}, {-3,-109}, {-3,-108}, {-3,-107}, {-3,-85}, {-3,-84}, {-3,-83}, {-3,-82}, {-3,-81}, {-3,-80}, {-3,-79}, {-3,-78}, {-3,-77}, {-3,-76}, {-3,-75}, {-3,-74}, {-3,28}, {-3,30}, {-3,84}, {-3,85}, {-3,87}, {-3,148}, {-3,149}, {-2,-110}, {-2,-109}, {-2,-108}, {-2,-107}, {-2,-106}, {-2,-105}, {-2,-104}, {-2,-87}, {-2,-86}, {-2,-85}, {-2,-84}, {-2,-83}, {-2,-82}, {-2,-81}, {-2,-80}, {-2,-79}, {-2,-78}, {-2,-77}, {-2,-76}, {-2,25}, {-2,26}, {-2,27}, {-2,28}, {-2,29}, {-2,30}, {-2,84}, {-2,85}, {-2,86}, {-2,148}, {-2,149}, {-1,-109}, {-1,-108}, {-1,-107}, {-1,-106}, {-1,-105}, {-1,-104}, {-1,-103}, {-1,-87}, {-1,-86}, {-1,-85}, {-1,-1}, {-1,0}, {-1,1}, {-1,23}, {-1,24}, {-1,25}, {-1,27}, {-1,28}, {-1,29}, {-1,30}, {-1,148}, {0,-109}, {0,-108}, {0,-107}, {0,-106}, {0,-105}, {0,-104}, {0,-103}, {0,-102}, {0,-101}, {0,-87}, {0,-86}, {0,-85}, {0,-74}, {0,-1}, {0,0}, {0,1}, {0,20}, {0,21}, {0,22}, {0,23}, {0,24}, {0,25}, {0,26}, {0,27}, {0,28}, {0,29}, {0,30}, {0,31}, {0,32}, {0,33}, {0,34}, {0,148}, {1,-109}, {1,-108}, {1,-107}, {1,-106}, {1,-103}, {1,-102}, {1,-101}, {1,-100}, {1,-99}, {1,-85}, {1,-84}, {1,-83}, {1,-82}, {1,-81}, {1,-80}, {1,-79}, {1,-78}, {1,-77}, {1,-76}, {1,-75}, {1,-74}, {1,-1}, {1,0}, {1,1}, {1,18}, {1,19}, {1,20}, {1,21}, {1,22}, {1,23}, {1,24}, {1,25}, {1,26}, {1,27}, {1,28}, {1,29}, {1,30}, {1,31}, {1,32}, {1,33}, {1,34}, {1,148}, {2,-109}, {2,-108}, {2,-107}, {2,-106}, {2,-105}, {2,-103}, {2,-102}, {2,-101}, {2,-100}, {2,-99}, {2,-98}, {2,-85}, {2,-84}, {2,-83}, {2,-82}, {2,-81}, {2,-80}, {2,-79}, {2,-78}, {2,-77}, {2,-76}, {2,-75}, {2,-74}, {2,8}, {2,9}, {2,10}, {2,11}, {2,12}, {2,13}, {2,14}, {2,15}, {2,16}, {2,17}, {2,18}, {2,19}, {2,20}, {2,21}, {2,22}, {2,23}, {2,24}, {2,25}, {2,26}, {2,27}, {2,28}, {2,29}, {2,30}, {2,31}, {2,32}, {2,33}, {2,34}, {2,148}, {3,-109}, {3,-108}, {3,-107}, {3,-106}, {3,-105}, {3,-104}, {3,-101}, {3,-100}, {3,-99}, {3,-98}, {3,-87}, {3,-86}, {3,-83}, {3,-82}, {3,-81}, {3,-80}, {3,-79}, {3,-78}, {3,-77}, {3,-76}, {3,-75}, {3,-74}, {3,-17}, {3,-16}, {3,-15}, {3,-14}, {3,-13}, {3,-12}, {3,-11}, {3,-10}, {3,-9}, {3,-8}, {3,-7}, {3,1}, {3,2}, {3,7}, {3,8}, {3,9}, {3,10}, {3,11}, {3,12}, {3,13}, {3,14}, {3,15}, {3,16}, {3,17}, {3,18}, {3,19}, {3,20}, {3,21}, {3,22}, {3,23}, {3,24}, {3,25}, {3,26}, {3,27}, {3,28}, {3,29}, {3,30}, {3,31}, {3,32}, {3,33}, {3,34}, {4,-109}, {4,-108}, {4,-107}, {4,-106}, {4,-105}, {4,-98}, {4,-97}, {4,-87}, {4,-86}, {4,-18}, {4,-17}, {4,-16}, {4,-15}, {4,-14}, {4,-13}, {4,-12}, {4,-11}, {4,-10}, {4,-9}, {4,-8}, {4,-7}, {4,-6}, {4,-5}, {4,-4}, {4,-3}, {4,-2}, {4,-1}, {4,0}, {4,1}, {4,2}, {4,6}, {4,7}, {4,8}, {4,9}, {4,10}, {4,11}, {4,12}, {4,13}, {4,14}, {4,15}, {4,16}, {4,17}, {4,18}, {4,19}, {4,20}, {4,21}, {4,22}, {4,23}, {4,24}, {4,25}, {4,26}, {4,27}, {4,28}, {4,29}, {4,30}, {4,31}, {4,32}, {4,33}, {5,-109}, {5,-108}, {5,-107}, {5,-106}, {5,-105}, {5,-104}, {5,-103}, {5,-102}, {5,-101}, {5,-100}, {5,-97}, {5,-96}, {5,-87}, {5,-86}, {5,-20}, {5,-19}, {5,-18}, {5,-17}, {5,-16}, {5,-15}, {5,-14}, {5,-13}, {5,-12}, {5,-11}, {5,-10}, {5,-9}, {5,-8}, {5,-7}, {5,-6}, {5,-5}, {5,-4}, {5,-3}, {5,-2}, {5,-1}, {5,0}, {5,1}, {5,2}, {5,3}, {5,4}, {5,5}, {5,6}, {5,7}, {5,8}, {5,9}, {5,10}, {5,11}, {5,12}, {5,13}, {5,14}, {5,15}, {5,16}, {5,17}, {5,18}, {5,19}, {5,20}, {5,21}, {5,22}, {5,23}, {5,24}, {5,25}, {5,26}, {5,27}, {5,28}, {5,29}, {5,30}, {5,31}, {5,32}, {6,-109}, {6,-108}, {6,-107}, {6,-106}, {6,-105}, {6,-104}, {6,-103}, {6,-102}, {6,-101}, {6,-100}, {6,-99}, {6,-98}, {6,-96}, {6,-85}, {6,-84}, {6,-83}, {6,-82}, {6,-81}, {6,-80}, {6,-79}, {6,-78}, {6,-77}, {6,-76}, {6,-75}, {6,-74}, {6,-23}, {6,-22}, {6,-21}, {6,-20}, {6,-19}, {6,-18}, {6,-17}, {6,-16}, {6,-15}, {6,-14}, {6,-13}, {6,-12}, {6,-11}, {6,-10}, {6,-9}, {6,-8}, {6,-7}, {6,-6}, {6,-5}, {6,-4}, {6,-3}, {6,-2}, {6,-1}, {6,0}, {6,1}, {6,2}, {6,3}, {6,4}, {6,5}, {6,6}, {6,7}, {6,8}, {6,9}, {6,10}, {6,11}, {6,12}, {6,13}, {6,14}, {6,15}, {6,16}, {6,17}, {6,18}, {6,19}, {6,20}, {6,21}, {6,22}, {6,23}, {6,24}, {6,25}, {6,26}, {6,27}, {6,28}, {6,29}, {6,30}, {7,-109}, {7,-108}, {7,-107}, {7,-106}, {7,-105}, {7,-104}, {7,-103}, {7,-102}, {7,-101}, {7,-100}, {7,-99}, {7,-95}, {7,-85}, {7,-84}, {7,-83}, {7,-82}, {7,-81}, {7,-80}, {7,-79}, {7,-78}, {7,-77}, {7,-76}, {7,-75}, {7,-74}, {7,-26}, {7,-25}, {7,-24}, {7,-23}, {7,-22}, {7,-21}, {7,-20}, {7,-19}, {7,-18}, {7,-17}, {7,-16}, {7,-15}, {7,-14}, {7,-13}, {7,-12}, {7,-11}, {7,-10}, {7,-9}, {7,-8}, {7,-7}, {7,-6}, {7,-5}, {7,-4}, {7,-3}, {7,-2}, {7,-1}, {7,0}, {7,1}, {7,2}, {7,3}, {7,4}, {7,5}, {7,6}, {7,7}, {7,8}, {7,9}, {7,10}, {7,11}, {7,12}, {7,13}, {7,14}, {7,15}, {7,16}, {7,17}, {7,18}, {7,19}, {7,20}, {7,21}, {7,22}, {7,23}, {7,24}, {7,25}, {7,26}, {7,27}, {7,28}, {7,29}, {8,-101}, {8,-100}, {8,-99}, {8,-98}, {8,-95}, {8,-94}, {8,-87}, {8,-86}, {8,-85}, {8,-84}, {8,-83}, {8,-82}, {8,-81}, {8,-80}, {8,-79}, {8,-78}, {8,-77}, {8,-76}, {8,-75}, {8,-74}, {8,-30}, {8,-29}, {8,-28}, {8,-27}, {8,-26}, {8,-25}, {8,-24}, {8,-23}, {8,-22}, {8,-21}, {8,-20}, {8,-19}, {8,-17}, {8,-16}, {8,-15}, {8,-14}, {8,-13}, {8,-12}, {8,-11}, {8,-10}, {8,-9}, {8,-8}, {8,-7}, {8,-6}, {8,-5}, {8,-4}, {8,-3}, {8,-2}, {8,-1}, {8,0}, {8,1}, {8,2}, {8,3}, {8,4}, {8,5}, {8,6}, {8,7}, {8,8}, {8,9}, {8,10}, {8,11}, {8,12}, {8,13}, {8,14}, {8,15}, {8,16}, {8,17}, {8,18}, {8,19}, {8,20}, {8,21}, {8,22}, {8,25}, {8,26}, {8,27}, {8,28}, {9,-100}, {9,-99}, {9,-98}, {9,-97}, {9,-94}, {9,-87}, {9,-86}, {9,-85}, {9,-35}, {9,-34}, {9,-33}, {9,-32}, {9,-31}, {9,-30}, {9,-29}, {9,-28}, {9,-27}, {9,-26}, {9,-25}, {9,-24}, {9,-23}, {9,-22}, {9,-21}, {9,-20}, {9,-15}, {9,-14}, {9,-13}, {9,-12}, {9,-11}, {9,-10}, {9,-9}, {9,-8}, {9,-7}, {9,-6}, {9,-5}, {9,-4}, {9,-3}, {9,-2}, {9,-1}, {9,0}, {9,1}, {9,2}, {9,3}, {9,4}, {9,5}, {9,6}, {9,7}, {9,8}, {9,9}, {9,10}, {9,11}, {9,19}, {9,20}, {9,21}, {9,28}, {9,143}, {9,144}, {9,145}, {9,146}, {9,147}, {10,-99}, {10,-98}, {10,-97}, {10,-96}, {10,-94}, {10,-87}, {10,-86}, {10,-85}, {10,142}, {10,143}, {10,144}, {10,145}, {10,146}, {11,-99}, {11,-98}, {11,-97}, {11,-96}, {11,-87}, {11,-86}, {11,-85}, {11,-84}, {11,-83}, {11,-82}, {11,-81}, {11,-80}, {11,-79}, {11,-78}, {11,-77}, {11,141}, {11,142}, {11,143}, {11,144}, {11,145}, {11,146}, {12,-99}, {12,-98}, {12,-97}, {12,-96}, {12,-84}, {12,-83}, {12,-82}, {12,-81}, {12,-80}, {12,-79}, {12,-78}, {12,141}, {12,142}, {12,143}, {12,144}, {13,-99}, {13,-98}, {13,-97}, {13,-96}, {13,-95}, {13,-94}, {13,-84}, {13,-83}, {13,-82}, {13,-81}, {13,-80}, {13,-79}, {13,141}, {13,142}, {13,143}, {13,144}, {14,-99}, {14,-98}, {14,-97}, {14,-96}, {14,-95}, {14,-94}, {14,-86}, {14,-85}, {14,-84}, {14,-83}, {14,-82}, {14,-81}, {14,-80}, {14,140}, {14,141}, {14,142}, {14,143}, {14,144}, {15,-97}, {15,-96}, {15,-95}, {15,-94}, {15,-93}, {15,140}, {15,141}, {15,142}, {15,143}, {16,-97}, {16,-96}, {16,-95}, {16,-94}, {16,-93}, {16,140}, {16,141}, {16,142}, {17,-97}, {17,-96}, {17,-95}, {17,-94}, {17,-93}, {17,-92}, {17,-79}, {17,-78}, {17,-77}, {17,-76}, {17,-75}, {17,-74}, {17,-73}, {17,-72}, {17,-11}, {17,-10}, {17,-9}, {17,-8}, {17,140}, {17,141}, {17,142}, {18,-95}, {18,-94}, {18,-93}, {18,-92}, {18,-80}, {18,-79}, {18,-78}, {18,-77}, {18,-76}, {18,-75}, {18,-74}, {18,-73}, {18,-13}, {18,-10}, {18,-9}, {18,-8}, {18,141}, {18,142}, {19,-95}, {19,-94}, {19,-93}, {19,-92}, {19,-81}, {19,-80}, {19,-79}, {19,-78}, {19,-77}, {19,-76}, {19,-75}, {19,-74}, {19,-73}, {19,-9}, {19,140}, {19,141}, {19,142}, {20,-95}, {20,-94}, {20,-93}, {20,-92}, {20,-83}, {20,-82}, {20,-81}, {20,-80}, {20,-79}, {20,-78}, {20,-77}, {20,-76}, {20,-75}, {20,-74}, {20,-73}, {20,140}, {20,141}, {20,142}, {21,-95}, {21,-94}, {21,-93}, {21,-92}, {21,-83}, {21,-82}, {21,-81}, {21,-80}, {21,-79}, {21,-78}, {21,-77}, {21,-76}, {21,-75}, {21,-74}, {21,140}, {21,141}, {21,142}, {22,-83}, {22,-82}, {22,-81}, {22,-80}, {22,-79}, {22,-78}, {22,-77}, {22,-76}, {22,-75}, {22,-74}, {22,-42}, {22,-41}, {22,-30}, {22,-29}, {22,-28}, {22,-27}, {22,-26}, {22,-22}, {22,-21}, {22,-20}, {22,140}, {22,141}, {22,142}, {23,-82}, {23,-81}, {23,-80}, {23,-79}, {23,-78}, {23,-77}, {23,-76}, {23,-75}, {23,-74}, {23,-67}, {23,-42}, {23,-41}, {23,-32}, {23,-31}, {23,-30}, {23,-29}, {23,-28}, {23,-27}, {23,-26}, {23,-25}, {23,-24}, {23,-23}, {23,-22}, {23,-21}, {23,-20}, {23,140}, {23,141}, {23,142}, {24,-97}, {24,-96}, {24,-82}, {24,-81}, {24,-80}, {24,-79}, {24,-78}, {24,-77}, {24,-76}, {24,-75}, {24,-67}, {24,-42}, {24,-41}, {24,-40}, {24,-32}, {24,-31}, {24,-30}, {24,-29}, {24,-28}, {24,-27}, {24,-26}, {24,-25}, {24,-24}, {24,-23}, {24,-22}, {24,-21}, {24,-20}, {24,-19}, {24,-18}, {24,-17}, {24,140}, {24,141}, {24,142}, {25,-97}, {25,-96}, {25,-95}, {25,-94}, {25,-93}, {25,-82}, {25,-81}, {25,-80}, {25,-79}, {25,-78}, {25,-77}, {25,-76}, {25,-75}, {25,-68}, {25,-41}, {25,-40}, {25,-32}, {25,-31}, {25,-30}, {25,-29}, {25,-28}, {25,-27}, {25,-26}, {25,-25}, {25,-22}, {25,-21}, {25,-20}, {25,-19}, {25,-18}, {25,-17}, {25,-16}, {25,-15}, {25,-12}, {25,140}, {25,141}, {26,-97}, {26,-96}, {26,-95}, {26,-94}, {26,-93}, {26,-81}, {26,-80}, {26,-79}, {26,-78}, {26,-77}, {26,-76}, {26,-75}, {26,-68}, {26,-67}, {26,-41}, {26,-40}, {26,-39}, {26,-32}, {26,-31}, {26,-30}, {26,-29}, {26,-28}, {26,-26}, {26,-25}, {26,-22}, {26,-21}, {26,-20}, {26,-19}, {26,-18}, {26,-17}, {26,-16}, {26,-12}, {26,140}, {27,-97}, {27,-96}, {27,-95}, {27,-94}, {27,-81}, {27,-80}, {27,-79}, {27,-78}, {27,-77}, {27,-76}, {27,-75}, {27,-74}, {27,-68}, {27,-67}, {27,-41}, {27,-40}, {27,-39}, {27,-32}, {27,-31}, {27,-30}, {27,-29}, {27,-28}, {27,-27}, {27,-26}, {27,-25}, {27,-24}, {27,-23}, {27,-22}, {27,-21}, {27,-20}, {27,-19}, {27,-18}, {27,-17}, {27,-16}, {28,-97}, {28,-96}, {28,-95}, {28,-94}, {28,-81}, {28,-80}, {28,-79}, {28,-78}, {28,-77}, {28,-76}, {28,-75}, {28,-74}, {28,-68}, {28,-41}, {28,-40}, {28,-39}, {28,-32}, {28,-31}, {28,-30}, {28,-29}, {28,-28}, {28,-27}, {28,-26}, {28,-25}, {28,-24}, {28,-23}, {28,-22}, {28,-21}, {28,-20}, {28,-19}, {28,-18}, {28,-17}, {28,-13}, {29,-97}, {29,-96}, {29,-95}, {29,-94}, {29,-81}, {29,-80}, {29,-79}, {29,-78}, {29,-77}, {29,-76}, {29,-75}, {29,-74}, {29,-68}, {29,-67}, {29,-41}, {29,-40}, {29,-39}, {29,-31}, {29,-30}, {29,-29}, {29,-28}, {29,-27}, {29,-26}, {29,-25}, {29,-24}, {29,-23}, {29,-21}, {29,-20}, {29,-19}, {29,-18}, {29,78}, {29,79}, {29,80}, {29,81}, {30,-97}, {30,-96}, {30,-95}, {30,-94}, {30,-81}, {30,-80}, {30,-79}, {30,-78}, {30,-77}, {30,-76}, {30,-75}, {30,-74}, {30,-68}, {30,-67}, {30,-41}, {30,-40}, {30,-39}, {30,-30}, {30,-29}, {30,-28}, {30,-27}, {30,-26}, {30,-25}, {30,-24}, {31,-97}, {31,-96}, {31,-95}, {31,-94}, {31,-80}, {31,-79}, {31,-78}, {31,-77}, {31,-76}, {31,-75}, {31,-74}, {31,-41}, {31,-40}, {31,-39}, {31,-26}, {31,-25}, {32,-97}, {32,-96}, {32,-95}, {32,-94}, {32,-80}, {32,-79}, {32,-78}, {32,-77}, {32,-76}, {32,-75}, {32,-74}, {32,-67}, {32,-41}, {32,-40}, {32,-39}, {33,-97}, {33,-96}, {33,-95}, {33,-94}, {33,-80}, {33,-79}, {33,-78}, {33,-77}, {33,-76}, {33,-75}, {33,-67}, {33,-41}, {33,-40}, {33,62}, {33,63}, {33,64}, {33,65}, {33,66}, {33,67}, {33,68}, {33,69}, {33,70}, {33,71}, {34,-80}, {34,-79}, {34,-78}, {34,-77}, {34,-76}, {34,-75}, {34,-41}, {35,-80}, {35,-79}, {35,-78}, {35,-77}, {35,-76}, {35,-75}, {36,-79}, {36,-78}, {36,-77}, {36,-76}, {36,-75}, {37,-79}, {37,-78}, {37,-77}, {37,-76}, {37,-75}, {38,-79}, {38,-78}, {38,-77}, {38,-76}, {38,-75}, {39,-90}, {39,-89}, {39,-88}, {39,-79}, {39,-78}, {39,-77}, {39,-76}, {39,-10}, {40,-90}, {40,-89}, {40,-88}, {40,-78}, {40,-77}, {40,-76}, {40,-41}, {40,-40}, {41,-78}, {41,-77}, {41,-76}, {41,-41}, {41,-40}, {42,-78}, {42,-77}, {42,-76}, {42,-67}, {42,-41}, {42,-40}, {42,-39}, {43,-78}, {43,-77}, {43,-76}, {43,-75}, {43,-67}, {43,-41}, {43,-40}, {43,-39}, {43,-38}, {44,-77}, {44,-76}, {44,-75}, {44,-41}, {44,-40}, {44,-39}, {44,-38}, {45,-102}, {45,-101}, {45,-77}, {45,-76}, {45,-75}, {45,-68}, {45,-67}, {45,-41}, {45,-40}, {45,-39}, {45,-38}, {46,-102}, {46,-101}, {46,-77}, {46,-76}, {46,-75}, {46,-68}, {46,-67}, {46,-41}, {46,-40}, {46,-39}, {46,-38}, {47,-102}, {47,-101}, {47,-100}, {47,-77}, {47,-76}, {47,-75}, {47,-68}, {47,-41}, {47,-40}, {47,-39}, {47,-38}, {48,-102}, {48,-101}, {48,-100}, {48,-76}, {48,-75}, {48,-68}, {48,-67}, {48,-41}, {48,-40}, {48,-39}, {48,-38}, {49,-102}, {49,-101}, {49,-100}, {49,-90}, {49,-89}, {49,-88}, {49,-76}, {49,-75}, {49,-68}, {49,-67}, {49,-41}, {49,-40}, {49,-39}, {50,-102}, {50,-101}, {50,-100}, {50,-92}, {50,-91}, {50,-90}, {50,-89}, {50,-76}, {50,-75}, {50,-74}, {50,-68}, {50,-41}, {50,-40}, {50,-39}, {51,-102}, {51,-101}, {51,-100}, {51,-99}, {51,-93}, {51,-92}, {51,-91}, {51,-76}, {51,-75}, {51,-74}, {51,-68}, {51,-67}, {51,-42}, {51,-41}, {51,-40}, {52,-101}, {52,-100}, {52,-99}, {52,-98}, {52,-93}, {52,-92}, {52,-75}, {52,-74}, {52,-68}, {52,-67}, {52,-42}, {52,-41}, {52,-40}, {53,-75}, {53,-74}, {53,-67}, {53,-42}, {53,-41}, {54,-75}, {54,-74}, {55,-75}, {55,-74}, {56,-74}, {57,-74}, {58,-74}, {58,-73}, {59,-74}, {59,-73}, {59,122}, {59,123}, {59,124}, {59,131}, {60,-73}, {60,121}, {60,122}, {60,123}, {60,124}, {60,125}, {60,126}, {60,129}, {60,130}, {61,-73}, {61,120}, {61,121}, {61,122}, {61,123}, {61,124}, {61,125}, {61,126}, {61,127}, {61,128}, {61,129}, {61,130}, {62,-73}, {62,56}, {62,120}, {62,121}, {62,122}, {62,123}, {62,126}, {62,127}, {62,128}, {62,129}, {62,130}, {63,56}, {63,121}, {63,122}, {63,123}, {63,127}, {63,129}, {63,130}, {63,145}, {63,146}, {64,56}, {64,120}, {64,121}, {64,122}, {64,123}, {64,128}, {64,129}, {64,130}, {64,131}, {64,145}, {64,146}, {64,147}, {65,56}, {65,120}, {65,121}, {65,122}, {65,123}, {65,124}, {65,127}, {65,128}, {65,129}, {65,130}, {65,131}, {65,145}, {65,146}, {65,147}, {66,56}, {66,120}, {66,121}, {66,122}, {66,123}, {66,126}, {66,127}, {66,128}, {66,129}, {66,130}, {66,131}, {66,145}, {66,146}, {67,56}, {67,120}, {67,121}, {67,122}, {67,123}, {67,125}, {67,126}, {67,127}, {67,128}, {67,129}, {67,130}, {67,145}, {67,146}, {68,56}, {68,121}, {68,122}, {68,125}, {68,126}, {68,127}, {68,128}, {68,129}, {68,145}, {68,146}, {69,120}, {69,121}, {69,122}, {69,123}, {69,124}, {69,125}, {69,126}, {69,127}, {69,128}, {69,145}, {69,146}, {70,120}, {70,121}, {70,122}, {70,123}, {70,124}, {70,125}, {70,126}, {70,127}, {70,145}, {71,-77}, {71,120}, {71,121}, {71,122}, {71,123}, {71,124}, {71,125}, {71,126}, {71,127}, {71,145}, {72,-77}, {72,-76}, {72,52}, {72,121}, {72,122}, {72,123}, {72,124}, {72,125}, {72,145}, {73,-77}, {73,-76}, {73,-75}, {73,-68}, {73,-67}, {73,52}, {73,145}, {73,146}, {74,-76}, {74,-75}, {74,-68}, {74,-67}, {74,52}, {74,145}, {74,146}, {75,-76}, {75,-75}, {75,-67}, {75,145}, {75,146}, {76,-76}, {76,-75}, {76,145}, {76,146}, {77,-75}, {77,145}, {77,146}, {78,-75}, {78,-74}, {78,145}, {79,-75}, {79,-74}, {79,-73}, {79,145}, {80,-74}, {80,-73}, {80,-72}, {80,145}, {81,-74}, {81,-73}, {81,-72}, {81,-37}, {81,145}, {81,146}, {82,-74}, {82,-73}, {82,-72}, {82,-71}, {82,-37}, {82,145}, {82,146}, {83,-73}, {83,-72}, {83,-71}, {83,-70}, {83,145}, {84,-73}, {84,-72}, {84,-71}, {84,-70}, {84,-69}, {84,-68}, {84,-34}, {84,-33}, {84,-32}, {85,-35}, {85,-34}, {85,-33}, {85,-32}, {86,-34}, {86,-33}, {86,-32}, {87,-34}, {87,-33}, {87,-32}, {88,-34}, {88,-33}, {88,-32}, {90,51}, {90,52}, {90,53}, {91,51}, {91,52}, {91,53}, {92,51}, {92,52}, {92,53}, },
    ["mineral-tan-dirt-5"] = {{-96,-26}, {-96,-25}, {-96,-24}, {-96,-23}, {-96,-22}, {-96,-21}, {-96,-20}, {-96,-19}, {-96,-18}, {-96,-17}, {-96,-16}, {-96,-15}, {-96,-14}, {-96,-13}, {-96,-12}, {-96,-11}, {-96,-10}, {-96,-9}, {-96,-8}, {-96,-7}, {-96,-6}, {-96,4}, {-96,5}, {-96,6}, {-96,7}, {-96,8}, {-96,9}, {-96,10}, {-96,11}, {-96,12}, {-96,13}, {-96,14}, {-96,15}, {-96,16}, {-96,17}, {-96,18}, {-96,19}, {-96,20}, {-96,21}, {-96,22}, {-96,23}, {-96,24}, {-96,25}, {-96,26}, {-96,27}, {-96,28}, {-96,29}, {-96,30}, {-96,31}, {-96,32}, {-96,37}, {-96,38}, {-96,39}, {-96,40}, {-96,41}, {-96,42}, {-95,-29}, {-95,-28}, {-95,-27}, {-95,-26}, {-95,-25}, {-95,-21}, {-95,-20}, {-95,-17}, {-95,-16}, {-95,-15}, {-95,-14}, {-95,-13}, {-95,-12}, {-95,-11}, {-95,-8}, {-95,-7}, {-95,-6}, {-95,-5}, {-95,-4}, {-95,-3}, {-95,-2}, {-95,-1}, {-95,0}, {-95,1}, {-95,2}, {-95,3}, {-95,4}, {-95,5}, {-95,6}, {-95,7}, {-95,8}, {-95,18}, {-95,19}, {-95,20}, {-95,39}, {-95,40}, {-95,41}, {-95,42}, {-94,-30}, {-94,-29}, {-94,-5}, {-94,-4}, {-94,-3}, {-94,-2}, {-94,-1}, {-94,0}, {-94,1}, {-94,2}, {-94,3}, {-94,4}, {-94,5}, {-94,35}, {-94,36}, {-94,37}, {-94,42}, {-93,-30}, {-93,-29}, {-93,-28}, {-93,23}, {-93,24}, {-93,25}, {-93,26}, {-93,27}, {-93,28}, {-93,29}, {-93,30}, {-93,43}, {-93,44}, {-93,45}, {-93,46}, {-93,47}, {-93,48}, {-93,49}, {-93,50}, {-93,51}, {-93,52}, {-93,53}, {-93,54}, {-93,55}, {-93,56}, {-93,57}, {-93,58}, {-93,59}, {-93,60}, {-93,61}, {-93,62}, {-93,63}, {-93,64}, {-93,65}, {-93,66}, {-93,67}, {-93,78}, {-93,79}, {-93,80}, {-93,81}, {-93,82}, {-93,83}, {-93,84}, {-93,85}, {-93,86}, {-93,87}, {-93,88}, {-93,89}, {-93,90}, {-93,91}, {-93,92}, {-93,93}, {-93,94}, {-93,95}, {-93,96}, {-93,97}, {-93,98}, {-93,99}, {-93,100}, {-93,101}, {-93,102}, {-93,103}, {-93,104}, {-93,105}, {-93,106}, {-93,107}, {-93,108}, {-92,-30}, {-92,-10}, {-92,-9}, {-92,-8}, {-92,13}, {-92,14}, {-92,15}, {-92,16}, {-92,17}, {-92,18}, {-92,19}, {-92,24}, {-92,25}, {-92,26}, {-92,27}, {-92,28}, {-92,29}, {-92,30}, {-92,44}, {-92,45}, {-92,46}, {-92,47}, {-92,48}, {-92,49}, {-92,50}, {-92,51}, {-92,52}, {-92,53}, {-92,54}, {-92,55}, {-92,56}, {-92,57}, {-92,58}, {-92,59}, {-92,60}, {-92,61}, {-92,62}, {-92,63}, {-92,64}, {-92,65}, {-92,66}, {-92,67}, {-92,78}, {-92,79}, {-92,80}, {-92,81}, {-92,82}, {-92,83}, {-92,84}, {-92,85}, {-92,86}, {-92,87}, {-92,88}, {-92,89}, {-92,90}, {-92,91}, {-92,92}, {-92,93}, {-92,94}, {-92,95}, {-92,96}, {-92,97}, {-92,98}, {-92,99}, {-92,100}, {-92,101}, {-92,102}, {-92,103}, {-92,104}, {-92,105}, {-92,106}, {-92,107}, {-92,108}, {-91,-30}, {-91,-10}, {-91,-9}, {-91,-8}, {-91,-7}, {-91,-6}, {-91,-5}, {-91,-4}, {-91,-3}, {-91,-2}, {-91,12}, {-91,13}, {-91,14}, {-91,15}, {-91,16}, {-91,17}, {-91,18}, {-91,19}, {-91,20}, {-91,25}, {-91,26}, {-91,27}, {-91,28}, {-91,29}, {-91,30}, {-91,44}, {-91,45}, {-91,46}, {-91,47}, {-91,48}, {-91,49}, {-91,62}, {-91,63}, {-91,64}, {-91,65}, {-91,66}, {-91,67}, {-91,68}, {-91,69}, {-91,70}, {-91,77}, {-91,78}, {-91,79}, {-91,80}, {-91,81}, {-91,82}, {-91,83}, {-91,84}, {-91,85}, {-91,86}, {-91,87}, {-91,88}, {-91,89}, {-91,90}, {-91,91}, {-91,92}, {-91,93}, {-91,94}, {-91,105}, {-91,106}, {-91,107}, {-91,108}, {-90,-109}, {-90,-108}, {-90,-107}, {-90,-106}, {-90,-105}, {-90,-104}, {-90,-103}, {-90,-102}, {-90,-101}, {-90,-100}, {-90,-99}, {-90,-98}, {-90,-97}, {-90,-37}, {-90,-36}, {-90,-35}, {-90,-34}, {-90,-33}, {-90,-32}, {-90,-31}, {-90,-30}, {-90,-11}, {-90,-10}, {-90,-9}, {-90,-8}, {-90,-7}, {-90,-6}, {-90,-5}, {-90,-4}, {-90,-3}, {-90,-2}, {-90,-1}, {-90,0}, {-90,1}, {-90,10}, {-90,11}, {-90,12}, {-90,13}, {-90,14}, {-90,15}, {-90,16}, {-90,17}, {-90,18}, {-90,19}, {-90,20}, {-90,21}, {-90,29}, {-90,30}, {-90,36}, {-90,37}, {-90,38}, {-90,39}, {-90,64}, {-90,65}, {-90,66}, {-90,67}, {-90,68}, {-90,69}, {-90,70}, {-90,71}, {-90,72}, {-90,73}, {-90,74}, {-90,75}, {-90,76}, {-90,77}, {-90,78}, {-90,79}, {-90,80}, {-90,81}, {-90,82}, {-90,83}, {-90,84}, {-90,85}, {-90,86}, {-90,106}, {-90,107}, {-90,108}, {-89,-119}, {-89,-118}, {-89,-117}, {-89,-109}, {-89,-108}, {-89,-107}, {-89,-106}, {-89,-105}, {-89,-104}, {-89,-103}, {-89,-102}, {-89,-101}, {-89,-100}, {-89,-99}, {-89,-98}, {-89,-97}, {-89,-37}, {-89,-36}, {-89,-35}, {-89,-34}, {-89,-33}, {-89,-32}, {-89,-31}, {-89,-30}, {-89,-29}, {-89,-10}, {-89,-9}, {-89,-8}, {-89,-7}, {-89,-6}, {-89,-5}, {-89,-4}, {-89,-3}, {-89,-2}, {-89,-1}, {-89,0}, {-89,1}, {-89,2}, {-89,3}, {-89,9}, {-89,10}, {-89,11}, {-89,12}, {-89,13}, {-89,14}, {-89,15}, {-89,16}, {-89,17}, {-89,18}, {-89,19}, {-89,20}, {-89,21}, {-89,22}, {-89,42}, {-89,50}, {-89,53}, {-89,54}, {-89,55}, {-89,56}, {-89,57}, {-89,68}, {-89,69}, {-89,70}, {-89,71}, {-89,72}, {-89,73}, {-89,74}, {-89,75}, {-89,76}, {-89,77}, {-89,97}, {-89,98}, {-89,99}, {-89,100}, {-89,101}, {-89,102}, {-89,107}, {-89,108}, {-89,109}, {-89,110}, {-89,111}, {-89,112}, {-89,113}, {-89,114}, {-89,115}, {-89,116}, {-89,117}, {-89,118}, {-88,-120}, {-88,-119}, {-88,-118}, {-88,-117}, {-88,-116}, {-88,-109}, {-88,-108}, {-88,-107}, {-88,-106}, {-88,-105}, {-88,-100}, {-88,-99}, {-88,-98}, {-88,-97}, {-88,-39}, {-88,-38}, {-88,-37}, {-88,-36}, {-88,-35}, {-88,-34}, {-88,-33}, {-88,-32}, {-88,-31}, {-88,-30}, {-88,23}, {-88,50}, {-88,60}, {-88,62}, {-88,63}, {-88,81}, {-88,82}, {-88,83}, {-88,84}, {-88,85}, {-88,86}, {-88,87}, {-88,88}, {-88,89}, {-88,90}, {-88,91}, {-88,92}, {-88,93}, {-88,94}, {-88,95}, {-88,104}, {-88,109}, {-88,110}, {-88,111}, {-88,112}, {-88,113}, {-88,114}, {-88,115}, {-88,116}, {-88,117}, {-88,118}, {-87,-121}, {-87,-120}, {-87,-119}, {-87,-118}, {-87,-117}, {-87,-116}, {-87,-115}, {-87,-109}, {-87,-108}, {-87,-107}, {-87,-99}, {-87,-98}, {-87,-97}, {-87,-96}, {-87,-95}, {-87,-94}, {-87,-93}, {-87,-92}, {-87,-91}, {-87,-90}, {-87,-89}, {-87,-42}, {-87,-41}, {-87,-40}, {-87,-39}, {-87,-38}, {-87,-37}, {-87,-36}, {-87,-35}, {-87,-34}, {-87,-33}, {-87,-32}, {-87,60}, {-87,62}, {-87,63}, {-87,64}, {-87,65}, {-87,66}, {-87,77}, {-87,78}, {-87,79}, {-87,80}, {-87,81}, {-87,82}, {-87,83}, {-87,84}, {-87,85}, {-87,86}, {-87,87}, {-87,88}, {-87,89}, {-87,90}, {-87,91}, {-87,92}, {-87,93}, {-87,94}, {-87,95}, {-87,104}, {-87,105}, {-87,106}, {-87,114}, {-87,115}, {-87,116}, {-87,117}, {-87,118}, {-86,-122}, {-86,-121}, {-86,-120}, {-86,-119}, {-86,-118}, {-86,-117}, {-86,-116}, {-86,-115}, {-86,-114}, {-86,-113}, {-86,-112}, {-86,-111}, {-86,-110}, {-86,-109}, {-86,-103}, {-86,-97}, {-86,-96}, {-86,-95}, {-86,-94}, {-86,-93}, {-86,-92}, {-86,-91}, {-86,-90}, {-86,-89}, {-86,-88}, {-86,-52}, {-86,-51}, {-86,-50}, {-86,-49}, {-86,-48}, {-86,-47}, {-86,-46}, {-86,-45}, {-86,-44}, {-86,-43}, {-86,-42}, {-86,-41}, {-86,-40}, {-86,-39}, {-86,-38}, {-86,-37}, {-86,-36}, {-86,-35}, {-86,-27}, {-86,43}, {-86,44}, {-86,45}, {-86,46}, {-86,62}, {-86,63}, {-86,64}, {-86,65}, {-86,66}, {-86,69}, {-86,70}, {-86,71}, {-86,72}, {-86,73}, {-86,74}, {-86,75}, {-86,76}, {-86,77}, {-86,78}, {-86,79}, {-86,80}, {-86,81}, {-86,82}, {-86,83}, {-86,84}, {-86,85}, {-86,86}, {-86,87}, {-86,88}, {-86,89}, {-86,90}, {-86,91}, {-86,92}, {-86,104}, {-86,105}, {-86,106}, {-86,107}, {-86,116}, {-86,117}, {-86,118}, {-85,-123}, {-85,-122}, {-85,-121}, {-85,-120}, {-85,-119}, {-85,-118}, {-85,-117}, {-85,-116}, {-85,-115}, {-85,-114}, {-85,-113}, {-85,-112}, {-85,-111}, {-85,-110}, {-85,-104}, {-85,-103}, {-85,-102}, {-85,-95}, {-85,-94}, {-85,-93}, {-85,-92}, {-85,-91}, {-85,-90}, {-85,-89}, {-85,-88}, {-85,-52}, {-85,-51}, {-85,-50}, {-85,-49}, {-85,-48}, {-85,-47}, {-85,-46}, {-85,-45}, {-85,-44}, {-85,-43}, {-85,-42}, {-85,-41}, {-85,-40}, {-85,-39}, {-85,-27}, {-85,42}, {-85,43}, {-85,44}, {-85,45}, {-85,46}, {-85,63}, {-85,64}, {-85,65}, {-85,67}, {-85,68}, {-85,69}, {-85,70}, {-85,71}, {-85,72}, {-85,73}, {-85,74}, {-85,75}, {-85,76}, {-85,77}, {-85,78}, {-85,79}, {-85,80}, {-85,81}, {-85,82}, {-85,88}, {-85,89}, {-85,90}, {-85,91}, {-85,92}, {-85,105}, {-85,106}, {-85,107}, {-85,108}, {-85,109}, {-85,110}, {-85,111}, {-85,112}, {-85,113}, {-85,117}, {-85,118}, {-84,-124}, {-84,-123}, {-84,-122}, {-84,-106}, {-84,-105}, {-84,-104}, {-84,-103}, {-84,-102}, {-84,-101}, {-84,-100}, {-84,-93}, {-84,-92}, {-84,-91}, {-84,-90}, {-84,-89}, {-84,-88}, {-84,-52}, {-84,-51}, {-84,-50}, {-84,-49}, {-84,-48}, {-84,-47}, {-84,-46}, {-84,-44}, {-84,-43}, {-84,-42}, {-84,-34}, {-84,-33}, {-84,-32}, {-84,-31}, {-84,-30}, {-84,-27}, {-84,41}, {-84,42}, {-84,43}, {-84,44}, {-84,45}, {-84,67}, {-84,68}, {-84,88}, {-84,89}, {-84,90}, {-84,91}, {-84,117}, {-84,118}, {-83,-125}, {-83,-124}, {-83,-123}, {-83,-107}, {-83,-106}, {-83,-105}, {-83,-100}, {-83,-99}, {-83,-98}, {-83,-90}, {-83,-89}, {-83,-88}, {-83,-87}, {-83,-86}, {-83,-85}, {-83,-84}, {-83,-83}, {-83,-79}, {-83,-78}, {-83,-77}, {-83,-76}, {-83,-75}, {-83,-71}, {-83,-70}, {-83,-69}, {-83,-68}, {-83,-67}, {-83,-66}, {-83,-63}, {-83,-62}, {-83,-61}, {-83,-57}, {-83,-56}, {-83,-55}, {-83,-54}, {-83,-53}, {-83,-52}, {-83,-51}, {-83,-50}, {-83,-49}, {-83,-48}, {-83,-46}, {-83,-45}, {-83,-44}, {-83,-37}, {-83,-36}, {-83,-35}, {-83,-34}, {-83,-33}, {-83,-32}, {-83,-31}, {-83,-30}, {-83,-27}, {-83,41}, {-83,42}, {-83,43}, {-83,44}, {-83,45}, {-83,117}, {-83,118}, {-82,-126}, {-82,-125}, {-82,-124}, {-82,-119}, {-82,-118}, {-82,-117}, {-82,-116}, {-82,-115}, {-82,-114}, {-82,-113}, {-82,-112}, {-82,-111}, {-82,-110}, {-82,-109}, {-82,-108}, {-82,-107}, {-82,-98}, {-82,-97}, {-82,-96}, {-82,-95}, {-82,-89}, {-82,-88}, {-82,-87}, {-82,-86}, {-82,-85}, {-82,-84}, {-82,-83}, {-82,-82}, {-82,-78}, {-82,-77}, {-82,-76}, {-82,-75}, {-82,-74}, {-82,-73}, {-82,-72}, {-82,-66}, {-82,-65}, {-82,-64}, {-82,-63}, {-82,-62}, {-82,-61}, {-82,-60}, {-82,-56}, {-82,-55}, {-82,-54}, {-82,-53}, {-82,-52}, {-82,-51}, {-82,-50}, {-82,-49}, {-82,-48}, {-82,-47}, {-82,-46}, {-82,-41}, {-82,-40}, {-82,-39}, {-82,-38}, {-82,-37}, {-82,-36}, {-82,-31}, {-82,-30}, {-82,-27}, {-82,118}, {-81,-127}, {-81,-126}, {-81,-125}, {-81,-120}, {-81,-119}, {-81,-118}, {-81,-117}, {-81,-116}, {-81,-115}, {-81,-114}, {-81,-113}, {-81,-112}, {-81,-111}, {-81,-110}, {-81,-109}, {-81,-96}, {-81,-95}, {-81,-94}, {-81,-93}, {-81,-86}, {-81,-85}, {-81,-84}, {-81,-83}, {-81,-82}, {-81,-78}, {-81,-77}, {-81,-76}, {-81,-75}, {-81,-74}, {-81,-73}, {-81,-72}, {-81,-67}, {-81,-66}, {-81,-65}, {-81,-64}, {-81,-63}, {-81,-62}, {-81,-61}, {-81,-56}, {-81,-55}, {-81,-54}, {-81,-53}, {-81,-52}, {-81,-51}, {-81,-50}, {-81,-49}, {-81,-45}, {-81,-44}, {-81,-43}, {-81,-42}, {-81,-41}, {-81,-40}, {-81,-39}, {-81,-38}, {-81,-37}, {-81,-36}, {-81,-31}, {-81,-30}, {-81,-27}, {-81,118}, {-81,119}, {-81,120}, {-81,121}, {-80,-128}, {-80,-127}, {-80,-126}, {-80,-125}, {-80,-121}, {-80,-120}, {-80,-119}, {-80,-110}, {-80,-109}, {-80,-95}, {-80,-94}, {-80,-93}, {-80,-92}, {-80,-91}, {-80,-83}, {-80,-82}, {-80,-78}, {-80,-77}, {-80,-76}, {-80,-75}, {-80,-74}, {-80,-73}, {-80,-72}, {-80,-67}, {-80,-66}, {-80,-65}, {-80,-64}, {-80,-63}, {-80,-62}, {-80,-61}, {-80,-56}, {-80,-55}, {-80,-54}, {-80,-52}, {-80,-51}, {-80,-47}, {-80,-46}, {-80,-45}, {-80,-44}, {-80,-43}, {-80,-42}, {-80,-41}, {-80,-40}, {-80,-39}, {-80,-38}, {-80,-33}, {-80,-32}, {-80,-31}, {-80,-30}, {-80,-27}, {-80,119}, {-80,120}, {-80,121}, {-80,122}, {-80,123}, {-79,-128}, {-79,-127}, {-79,-126}, {-79,-125}, {-79,-122}, {-79,-121}, {-79,-120}, {-79,-92}, {-79,-91}, {-79,-90}, {-79,-89}, {-79,-81}, {-79,-77}, {-79,-76}, {-79,-75}, {-79,-74}, {-79,-73}, {-79,-72}, {-79,-71}, {-79,-67}, {-79,-66}, {-79,-65}, {-79,-64}, {-79,-63}, {-79,-62}, {-79,-61}, {-79,-57}, {-79,-56}, {-79,-54}, {-79,-53}, {-79,-52}, {-79,-49}, {-79,-48}, {-79,-47}, {-79,-46}, {-79,-45}, {-79,-44}, {-79,-43}, {-79,-42}, {-79,-41}, {-79,-38}, {-79,-34}, {-79,-33}, {-79,-32}, {-79,-31}, {-79,-30}, {-79,-29}, {-79,-27}, {-79,119}, {-79,120}, {-79,121}, {-79,122}, {-79,123}, {-79,124}, {-79,125}, {-78,-128}, {-78,-127}, {-78,-126}, {-78,-125}, {-78,-122}, {-78,-121}, {-78,-90}, {-78,-89}, {-78,-88}, {-78,-87}, {-78,-86}, {-78,-81}, {-78,-76}, {-78,-75}, {-78,-74}, {-78,-73}, {-78,-72}, {-78,-71}, {-78,-67}, {-78,-66}, {-78,-65}, {-78,-64}, {-78,-63}, {-78,-62}, {-78,-57}, {-78,-56}, {-78,-55}, {-78,-51}, {-78,-50}, {-78,-49}, {-78,-48}, {-78,-47}, {-78,-46}, {-78,-45}, {-78,-44}, {-78,-43}, {-78,-42}, {-78,-41}, {-78,-35}, {-78,-34}, {-78,-33}, {-78,-32}, {-78,-31}, {-78,-30}, {-78,-29}, {-78,-27}, {-78,124}, {-78,125}, {-78,126}, {-78,127}, {-77,-128}, {-77,-127}, {-77,-126}, {-77,-125}, {-77,-122}, {-77,-121}, {-77,-88}, {-77,-87}, {-77,-86}, {-77,-85}, {-77,-84}, {-77,-81}, {-77,-76}, {-77,-75}, {-77,-74}, {-77,-73}, {-77,-72}, {-77,-71}, {-77,-68}, {-77,-67}, {-77,-66}, {-77,-65}, {-77,-64}, {-77,-63}, {-77,-62}, {-77,-57}, {-77,-56}, {-77,-53}, {-77,-52}, {-77,-51}, {-77,-50}, {-77,-49}, {-77,-48}, {-77,-46}, {-77,-44}, {-77,-34}, {-77,-33}, {-77,-32}, {-77,-31}, {-77,-30}, {-77,-29}, {-77,-27}, {-77,125}, {-77,126}, {-77,127}, {-76,-128}, {-76,-127}, {-76,-126}, {-76,-125}, {-76,-122}, {-76,-121}, {-76,-86}, {-76,-85}, {-76,-84}, {-76,-81}, {-76,-75}, {-76,-74}, {-76,-73}, {-76,-72}, {-76,-71}, {-76,-68}, {-76,-67}, {-76,-66}, {-76,-65}, {-76,-64}, {-76,-63}, {-76,-58}, {-76,-57}, {-76,-56}, {-76,-54}, {-76,-53}, {-76,-52}, {-76,-51}, {-76,-32}, {-76,-31}, {-76,-30}, {-76,-29}, {-76,-27}, {-76,126}, {-76,127}, {-75,-128}, {-75,-127}, {-75,-126}, {-75,-125}, {-75,-122}, {-75,-121}, {-75,-85}, {-75,-84}, {-75,-81}, {-75,-75}, {-75,-74}, {-75,-73}, {-75,-72}, {-75,-71}, {-75,-68}, {-75,-67}, {-75,-66}, {-75,-65}, {-75,-64}, {-75,-58}, {-75,-57}, {-75,-54}, {-75,-53}, {-75,-52}, {-75,-32}, {-75,-31}, {-75,-30}, {-75,-29}, {-75,-27}, {-75,119}, {-75,126}, {-75,127}, {-74,-127}, {-74,-126}, {-74,-125}, {-74,-122}, {-74,-121}, {-74,-85}, {-74,-84}, {-74,-81}, {-74,-72}, {-74,-71}, {-74,-68}, {-74,-67}, {-74,-66}, {-74,-65}, {-74,-64}, {-74,-58}, {-74,-57}, {-74,-54}, {-74,-53}, {-74,-52}, {-74,-32}, {-74,-31}, {-74,-30}, {-74,-29}, {-74,127}, {-74,128}, {-74,129}, {-74,130}, {-74,131}, {-73,-127}, {-73,-126}, {-73,-125}, {-73,-121}, {-73,-120}, {-73,-85}, {-73,-84}, {-73,-81}, {-73,-80}, {-73,-67}, {-73,-58}, {-73,-57}, {-73,-54}, {-73,-53}, {-73,-52}, {-73,-32}, {-73,-31}, {-73,-30}, {-73,-29}, {-73,130}, {-73,131}, {-73,132}, {-73,133}, {-73,134}, {-73,135}, {-72,-127}, {-72,-126}, {-72,-125}, {-72,-121}, {-72,-120}, {-72,-86}, {-72,-85}, {-72,-84}, {-72,-81}, {-72,-58}, {-72,-57}, {-72,-54}, {-72,-53}, {-72,-52}, {-72,-31}, {-72,-30}, {-72,-29}, {-72,-28}, {-72,133}, {-72,134}, {-72,135}, {-72,136}, {-72,137}, {-72,138}, {-72,139}, {-71,-127}, {-71,-126}, {-71,-125}, {-71,-124}, {-71,-121}, {-71,-120}, {-71,-86}, {-71,-85}, {-71,-84}, {-71,-81}, {-71,-58}, {-71,-57}, {-71,-54}, {-71,-53}, {-71,-52}, {-71,-51}, {-71,-30}, {-71,-29}, {-71,-28}, {-71,137}, {-71,138}, {-71,139}, {-71,140}, {-71,141}, {-71,142}, {-71,143}, {-70,-127}, {-70,-126}, {-70,-125}, {-70,-124}, {-70,-121}, {-70,-120}, {-70,-86}, {-70,-85}, {-70,-81}, {-70,-58}, {-70,-57}, {-70,-54}, {-70,-53}, {-70,-52}, {-70,-51}, {-70,-33}, {-70,-30}, {-70,-29}, {-70,-28}, {-70,127}, {-70,128}, {-70,140}, {-70,141}, {-70,142}, {-70,143}, {-70,144}, {-70,145}, {-70,146}, {-70,147}, {-69,-127}, {-69,-126}, {-69,-125}, {-69,-124}, {-69,-120}, {-69,-119}, {-69,-86}, {-69,-85}, {-69,-81}, {-69,-58}, {-69,-57}, {-69,-54}, {-69,-53}, {-69,-52}, {-69,-51}, {-69,-32}, {-69,-31}, {-69,-30}, {-69,-29}, {-69,-28}, {-69,132}, {-69,133}, {-69,134}, {-69,135}, {-69,142}, {-69,143}, {-69,144}, {-69,145}, {-69,146}, {-69,147}, {-69,148}, {-69,149}, {-69,150}, {-69,151}, {-69,152}, {-68,-126}, {-68,-125}, {-68,-124}, {-68,-120}, {-68,-119}, {-68,-86}, {-68,-85}, {-68,-82}, {-68,-81}, {-68,-58}, {-68,-57}, {-68,-54}, {-68,-53}, {-68,-52}, {-68,-51}, {-68,-30}, {-68,-29}, {-68,-28}, {-68,133}, {-68,134}, {-68,137}, {-68,138}, {-68,139}, {-68,144}, {-68,145}, {-68,146}, {-68,147}, {-68,148}, {-68,149}, {-68,150}, {-68,151}, {-68,152}, {-67,-126}, {-67,-125}, {-67,-124}, {-67,-123}, {-67,-120}, {-67,-119}, {-67,-86}, {-67,-85}, {-67,-82}, {-67,-81}, {-67,-58}, {-67,-57}, {-67,-54}, {-67,-53}, {-67,-52}, {-67,-51}, {-67,-30}, {-67,-29}, {-67,-28}, {-67,125}, {-67,126}, {-67,137}, {-67,138}, {-67,139}, {-67,140}, {-67,146}, {-67,147}, {-67,148}, {-67,149}, {-67,150}, {-67,151}, {-67,152}, {-66,-126}, {-66,-125}, {-66,-124}, {-66,-123}, {-66,-120}, {-66,-119}, {-66,-86}, {-66,-85}, {-66,-82}, {-66,-81}, {-66,-58}, {-66,-57}, {-66,-54}, {-66,-53}, {-66,-52}, {-66,-51}, {-66,-50}, {-66,-30}, {-66,-29}, {-66,-28}, {-66,121}, {-66,123}, {-66,124}, {-66,125}, {-66,126}, {-66,127}, {-66,128}, {-66,129}, {-66,130}, {-66,131}, {-66,137}, {-66,138}, {-66,139}, {-66,140}, {-66,141}, {-66,147}, {-66,148}, {-66,149}, {-66,150}, {-66,151}, {-66,152}, {-65,-126}, {-65,-125}, {-65,-124}, {-65,-123}, {-65,-120}, {-65,-119}, {-65,-118}, {-65,-86}, {-65,-85}, {-65,-82}, {-65,-81}, {-65,-58}, {-65,-57}, {-65,-54}, {-65,-53}, {-65,-52}, {-65,-51}, {-65,-50}, {-65,-49}, {-65,-31}, {-65,-30}, {-65,-29}, {-65,-28}, {-65,140}, {-65,141}, {-65,142}, {-65,148}, {-65,149}, {-65,150}, {-65,151}, {-65,152}, {-64,-126}, {-64,-125}, {-64,-124}, {-64,-123}, {-64,-119}, {-64,-86}, {-64,-85}, {-64,-82}, {-64,-81}, {-64,-58}, {-64,-57}, {-64,-54}, {-64,-53}, {-64,-52}, {-64,-51}, {-64,-50}, {-64,-49}, {-64,-48}, {-64,-47}, {-64,-46}, {-64,-45}, {-64,-30}, {-64,-29}, {-64,-28}, {-64,140}, {-64,141}, {-64,142}, {-64,143}, {-64,145}, {-64,149}, {-64,150}, {-64,151}, {-64,152}, {-63,-126}, {-63,-125}, {-63,-124}, {-63,-123}, {-63,-122}, {-63,-119}, {-63,-86}, {-63,-85}, {-63,-81}, {-63,-54}, {-63,-53}, {-63,-52}, {-63,-51}, {-63,-50}, {-63,-49}, {-63,-48}, {-63,-47}, {-63,-46}, {-63,-45}, {-63,-44}, {-63,-43}, {-63,-42}, {-63,-41}, {-63,-40}, {-63,-39}, {-63,-38}, {-63,-37}, {-63,-36}, {-63,-35}, {-63,-34}, {-63,-33}, {-63,-29}, {-63,-28}, {-63,140}, {-63,141}, {-63,142}, {-63,143}, {-63,145}, {-63,146}, {-63,149}, {-63,150}, {-63,151}, {-63,152}, {-62,-125}, {-62,-124}, {-62,-123}, {-62,-122}, {-62,-119}, {-62,-86}, {-62,-85}, {-62,-81}, {-62,-50}, {-62,-49}, {-62,-48}, {-62,-47}, {-62,-46}, {-62,-45}, {-62,-44}, {-62,-43}, {-62,-42}, {-62,-41}, {-62,-40}, {-62,-39}, {-62,-38}, {-62,-37}, {-62,-36}, {-62,-35}, {-62,-34}, {-62,-33}, {-62,-32}, {-62,-29}, {-62,-28}, {-62,141}, {-62,142}, {-62,143}, {-62,146}, {-62,147}, {-62,150}, {-62,151}, {-62,152}, {-61,-125}, {-61,-124}, {-61,-123}, {-61,-122}, {-61,-119}, {-61,-86}, {-61,-85}, {-61,-84}, {-61,-81}, {-61,-47}, {-61,-46}, {-61,-45}, {-61,-44}, {-61,-43}, {-61,-42}, {-61,-41}, {-61,-40}, {-61,-39}, {-61,-38}, {-61,-37}, {-61,-36}, {-61,-35}, {-61,-34}, {-61,-33}, {-61,-32}, {-61,-31}, {-61,-30}, {-61,-29}, {-61,-28}, {-61,141}, {-61,142}, {-61,143}, {-61,145}, {-61,147}, {-61,150}, {-61,151}, {-61,152}, {-60,-125}, {-60,-124}, {-60,-123}, {-60,-122}, {-60,-119}, {-60,-118}, {-60,-117}, {-60,-86}, {-60,-85}, {-60,-84}, {-60,-81}, {-60,-45}, {-60,-44}, {-60,-43}, {-60,-42}, {-60,-41}, {-60,-40}, {-60,-39}, {-60,-38}, {-60,-37}, {-60,-36}, {-60,-35}, {-60,-34}, {-60,-33}, {-60,-32}, {-60,-31}, {-60,-30}, {-60,-29}, {-60,-28}, {-60,141}, {-60,142}, {-60,143}, {-60,147}, {-60,150}, {-60,151}, {-60,152}, {-59,-125}, {-59,-124}, {-59,-123}, {-59,-122}, {-59,-119}, {-59,-118}, {-59,-117}, {-59,-86}, {-59,-85}, {-59,-84}, {-59,-81}, {-59,-58}, {-59,-54}, {-59,-39}, {-59,-38}, {-59,-37}, {-59,-36}, {-59,-35}, {-59,-34}, {-59,-33}, {-59,-32}, {-59,-31}, {-59,-30}, {-59,-29}, {-59,141}, {-59,142}, {-59,143}, {-59,147}, {-59,150}, {-59,151}, {-59,152}, {-58,-125}, {-58,-124}, {-58,-123}, {-58,-122}, {-58,-118}, {-58,-117}, {-58,-86}, {-58,-85}, {-58,-84}, {-58,-81}, {-58,-58}, {-58,-57}, {-58,-54}, {-58,-53}, {-58,-34}, {-58,-33}, {-58,-32}, {-58,-31}, {-58,-30}, {-58,142}, {-58,143}, {-58,146}, {-58,147}, {-58,150}, {-58,151}, {-58,152}, {-57,-125}, {-57,-124}, {-57,-123}, {-57,-122}, {-57,-121}, {-57,-118}, {-57,-117}, {-57,-86}, {-57,-85}, {-57,-84}, {-57,-81}, {-57,-58}, {-57,-57}, {-57,-54}, {-57,-53}, {-57,-52}, {-57,142}, {-57,143}, {-57,145}, {-57,146}, {-57,147}, {-57,150}, {-57,151}, {-57,152}, {-56,-124}, {-56,-123}, {-56,-122}, {-56,-121}, {-56,-118}, {-56,-117}, {-56,-86}, {-56,-85}, {-56,-84}, {-56,-81}, {-56,-58}, {-56,-57}, {-56,-54}, {-56,-53}, {-56,-52}, {-56,-51}, {-56,-46}, {-56,-45}, {-56,-43}, {-56,142}, {-56,143}, {-56,147}, {-56,150}, {-56,151}, {-56,152}, {-55,-124}, {-55,-123}, {-55,-122}, {-55,-121}, {-55,-118}, {-55,-117}, {-55,-86}, {-55,-85}, {-55,-84}, {-55,-81}, {-55,-58}, {-55,-57}, {-55,-54}, {-55,-53}, {-55,-52}, {-55,-51}, {-55,142}, {-55,143}, {-55,147}, {-55,150}, {-55,151}, {-55,152}, {-54,-124}, {-54,-123}, {-54,-122}, {-54,-121}, {-54,-118}, {-54,-117}, {-54,-87}, {-54,-86}, {-54,-85}, {-54,-84}, {-54,-81}, {-54,-58}, {-54,-54}, {-54,-53}, {-54,-52}, {-54,-51}, {-54,-50}, {-54,142}, {-54,143}, {-54,150}, {-54,151}, {-54,152}, {-53,-124}, {-53,-123}, {-53,-122}, {-53,-121}, {-53,-118}, {-53,-117}, {-53,-87}, {-53,-86}, {-53,-85}, {-53,-84}, {-53,-81}, {-53,-58}, {-53,-54}, {-53,-53}, {-53,-52}, {-53,-37}, {-53,-36}, {-53,-35}, {-53,-34}, {-53,-33}, {-53,-32}, {-53,-31}, {-53,-30}, {-53,142}, {-53,143}, {-53,150}, {-53,151}, {-53,152}, {-52,-124}, {-52,-123}, {-52,-122}, {-52,-121}, {-52,-118}, {-52,-117}, {-52,-86}, {-52,-85}, {-52,-84}, {-52,-81}, {-52,-58}, {-52,-55}, {-52,-54}, {-52,-42}, {-52,-39}, {-52,-38}, {-52,-37}, {-52,-36}, {-52,-35}, {-52,-34}, {-52,-33}, {-52,-32}, {-52,-31}, {-52,-30}, {-52,-29}, {-52,-28}, {-52,142}, {-52,143}, {-52,145}, {-52,147}, {-52,150}, {-52,151}, {-52,152}, {-51,-124}, {-51,-123}, {-51,-122}, {-51,-121}, {-51,-118}, {-51,-117}, {-51,-86}, {-51,-85}, {-51,-58}, {-51,-44}, {-51,-43}, {-51,-42}, {-51,-41}, {-51,-39}, {-51,-38}, {-51,-37}, {-51,-36}, {-51,-35}, {-51,-34}, {-51,-33}, {-51,-32}, {-51,-31}, {-51,-30}, {-51,-29}, {-51,-28}, {-51,142}, {-51,143}, {-51,145}, {-51,146}, {-51,147}, {-51,150}, {-51,151}, {-51,152}, {-50,-123}, {-50,-122}, {-50,-121}, {-50,-118}, {-50,-117}, {-50,-116}, {-50,-86}, {-50,-85}, {-50,-79}, {-50,-78}, {-50,-77}, {-50,-76}, {-50,-75}, {-50,-74}, {-50,-73}, {-50,-72}, {-50,-52}, {-50,-51}, {-50,-50}, {-50,-43}, {-50,-42}, {-50,-41}, {-50,-39}, {-50,-38}, {-50,-37}, {-50,-36}, {-50,-35}, {-50,-32}, {-50,-31}, {-50,-30}, {-50,-29}, {-50,-28}, {-50,142}, {-50,143}, {-50,145}, {-50,146}, {-50,147}, {-50,150}, {-50,151}, {-50,152}, {-49,-123}, {-49,-122}, {-49,-121}, {-49,-117}, {-49,-116}, {-49,-86}, {-49,-85}, {-49,-77}, {-49,-76}, {-49,-75}, {-49,-74}, {-49,-73}, {-49,-72}, {-49,-71}, {-49,-52}, {-49,-51}, {-49,-50}, {-49,-43}, {-49,-42}, {-49,-41}, {-49,-40}, {-49,-38}, {-49,-37}, {-49,-36}, {-49,-35}, {-49,-31}, {-49,-30}, {-49,-29}, {-49,-28}, {-49,142}, {-49,143}, {-49,145}, {-49,147}, {-49,150}, {-49,151}, {-49,152}, {-48,-123}, {-48,-122}, {-48,-121}, {-48,-120}, {-48,-117}, {-48,-116}, {-48,-86}, {-48,-85}, {-48,-84}, {-48,-64}, {-48,-63}, {-48,-62}, {-48,-59}, {-48,-52}, {-48,-51}, {-48,-50}, {-48,-43}, {-48,-42}, {-48,-41}, {-48,-40}, {-48,-38}, {-48,-37}, {-48,-36}, {-48,-35}, {-48,-29}, {-48,-28}, {-48,142}, {-48,143}, {-48,147}, {-48,150}, {-48,151}, {-48,152}, {-47,-123}, {-47,-122}, {-47,-121}, {-47,-120}, {-47,-117}, {-47,-116}, {-47,-87}, {-47,-86}, {-47,-85}, {-47,-84}, {-47,-67}, {-47,-59}, {-47,-55}, {-47,-51}, {-47,-42}, {-47,-41}, {-47,-40}, {-47,-38}, {-47,-37}, {-47,-36}, {-47,-35}, {-47,-34}, {-47,-29}, {-47,-28}, {-47,142}, {-47,143}, {-47,147}, {-47,150}, {-47,151}, {-47,152}, {-46,-123}, {-46,-122}, {-46,-121}, {-46,-120}, {-46,-117}, {-46,-116}, {-46,-115}, {-46,-87}, {-46,-86}, {-46,-85}, {-46,-67}, {-46,-59}, {-46,-58}, {-46,-55}, {-46,-54}, {-46,-46}, {-46,-42}, {-46,-41}, {-46,-40}, {-46,-39}, {-46,-37}, {-46,-36}, {-46,-35}, {-46,-34}, {-46,-29}, {-46,-28}, {-46,142}, {-46,143}, {-46,147}, {-46,150}, {-46,151}, {-46,152}, {-45,-123}, {-45,-122}, {-45,-121}, {-45,-120}, {-45,-116}, {-45,-115}, {-45,-87}, {-45,-86}, {-45,-85}, {-45,-81}, {-45,-80}, {-45,-79}, {-45,-78}, {-45,-77}, {-45,-76}, {-45,-75}, {-45,-74}, {-45,-73}, {-45,-72}, {-45,-67}, {-45,-58}, {-45,-55}, {-45,-54}, {-45,-53}, {-45,-46}, {-45,-42}, {-45,-41}, {-45,-40}, {-45,-39}, {-45,-37}, {-45,-36}, {-45,-35}, {-45,-34}, {-45,-31}, {-45,-30}, {-45,-29}, {-45,-28}, {-45,142}, {-45,143}, {-45,145}, {-45,147}, {-45,150}, {-45,151}, {-45,152}, {-44,-122}, {-44,-121}, {-44,-120}, {-44,-116}, {-44,-115}, {-44,-114}, {-44,-87}, {-44,-86}, {-44,-85}, {-44,-82}, {-44,-81}, {-44,-80}, {-44,-79}, {-44,-78}, {-44,-77}, {-44,-76}, {-44,-75}, {-44,-74}, {-44,-73}, {-44,-72}, {-44,-71}, {-44,-67}, {-44,-58}, {-44,-55}, {-44,-54}, {-44,-53}, {-44,-47}, {-44,-46}, {-44,-45}, {-44,-41}, {-44,-40}, {-44,-39}, {-44,-36}, {-44,-35}, {-44,-34}, {-44,-30}, {-44,-29}, {-44,-28}, {-44,142}, {-44,143}, {-44,145}, {-44,146}, {-44,147}, {-44,150}, {-44,151}, {-44,152}, {-43,-122}, {-43,-121}, {-43,-120}, {-43,-119}, {-43,-116}, {-43,-115}, {-43,-114}, {-43,-87}, {-43,-86}, {-43,-85}, {-43,-82}, {-43,-73}, {-43,-72}, {-43,-71}, {-43,-70}, {-43,-67}, {-43,-59}, {-43,-58}, {-43,-55}, {-43,-54}, {-43,-53}, {-43,-52}, {-43,-47}, {-43,-46}, {-43,-45}, {-43,-41}, {-43,-40}, {-43,-39}, {-43,-38}, {-43,-36}, {-43,-35}, {-43,-34}, {-43,-33}, {-43,-30}, {-43,-29}, {-43,-28}, {-43,142}, {-43,143}, {-43,145}, {-43,146}, {-43,147}, {-43,150}, {-43,151}, {-43,152}, {-42,-122}, {-42,-121}, {-42,-120}, {-42,-119}, {-42,-116}, {-42,-115}, {-42,-114}, {-42,-87}, {-42,-86}, {-42,-82}, {-42,-72}, {-42,-71}, {-42,-70}, {-42,-67}, {-42,-59}, {-42,-55}, {-42,-54}, {-42,-53}, {-42,-52}, {-42,-47}, {-42,-46}, {-42,-45}, {-42,-44}, {-42,-41}, {-42,-40}, {-42,-39}, {-42,-38}, {-42,-36}, {-42,-35}, {-42,-34}, {-42,-33}, {-42,-30}, {-42,-29}, {-42,-28}, {-42,142}, {-42,143}, {-42,145}, {-42,147}, {-42,150}, {-42,151}, {-42,152}, {-41,-122}, {-41,-121}, {-41,-120}, {-41,-119}, {-41,-115}, {-41,-114}, {-41,-88}, {-41,-87}, {-41,-86}, {-41,-83}, {-41,-82}, {-41,-71}, {-41,-70}, {-41,-67}, {-41,-55}, {-41,-54}, {-41,-53}, {-41,-52}, {-41,-51}, {-41,-46}, {-41,-45}, {-41,-44}, {-41,-40}, {-41,-39}, {-41,-38}, {-41,-37}, {-41,-35}, {-41,-34}, {-41,-33}, {-41,-32}, {-41,-31}, {-41,-30}, {-41,-29}, {-41,-28}, {-41,141}, {-41,142}, {-41,143}, {-41,150}, {-41,151}, {-41,152}, {-40,-122}, {-40,-121}, {-40,-120}, {-40,-119}, {-40,-115}, {-40,-114}, {-40,-88}, {-40,-87}, {-40,-86}, {-40,-83}, {-40,-82}, {-40,-71}, {-40,-70}, {-40,-67}, {-40,-55}, {-40,-54}, {-40,-53}, {-40,-52}, {-40,-51}, {-40,-46}, {-40,-45}, {-40,-44}, {-40,-40}, {-40,-39}, {-40,-38}, {-40,-37}, {-40,-35}, {-40,-34}, {-40,-33}, {-40,-32}, {-40,-31}, {-40,-30}, {-40,-29}, {-40,-28}, {-40,141}, {-40,142}, {-40,143}, {-40,150}, {-40,151}, {-40,152}, {-39,-122}, {-39,-121}, {-39,-120}, {-39,-119}, {-39,-118}, {-39,-115}, {-39,-114}, {-39,-88}, {-39,-87}, {-39,-86}, {-39,-83}, {-39,-82}, {-39,-81}, {-39,-80}, {-39,-79}, {-39,-71}, {-39,-70}, {-39,-67}, {-39,-55}, {-39,-54}, {-39,-53}, {-39,-52}, {-39,-51}, {-39,-46}, {-39,-45}, {-39,-44}, {-39,-43}, {-39,-39}, {-39,-38}, {-39,-37}, {-39,-36}, {-39,-34}, {-39,-33}, {-39,-32}, {-39,-31}, {-39,-30}, {-39,-29}, {-39,-28}, {-39,141}, {-39,142}, {-39,150}, {-39,151}, {-39,152}, {-38,-121}, {-38,-120}, {-38,-119}, {-38,-118}, {-38,-115}, {-38,-114}, {-38,-88}, {-38,-87}, {-38,-86}, {-38,-83}, {-38,-81}, {-38,-80}, {-38,-71}, {-38,-70}, {-38,-67}, {-38,-59}, {-38,-58}, {-38,-55}, {-38,-54}, {-38,-53}, {-38,-52}, {-38,-51}, {-38,-50}, {-38,-46}, {-38,-45}, {-38,-44}, {-38,-43}, {-38,-39}, {-38,-38}, {-38,-37}, {-38,-36}, {-38,-34}, {-38,-33}, {-38,-32}, {-38,-31}, {-38,-30}, {-38,-29}, {-38,-28}, {-38,141}, {-38,142}, {-38,147}, {-38,150}, {-38,151}, {-38,152}, {-37,-121}, {-37,-120}, {-37,-119}, {-37,-118}, {-37,-115}, {-37,-114}, {-37,-88}, {-37,-87}, {-37,-83}, {-37,-71}, {-37,-70}, {-37,-67}, {-37,-59}, {-37,-58}, {-37,-55}, {-37,-54}, {-37,-51}, {-37,-46}, {-37,-45}, {-37,-44}, {-37,-43}, {-37,-38}, {-37,-37}, {-37,-36}, {-37,-34}, {-37,-33}, {-37,-32}, {-37,-31}, {-37,-30}, {-37,141}, {-37,142}, {-37,145}, {-37,146}, {-37,150}, {-37,151}, {-37,152}, {-36,-121}, {-36,-120}, {-36,-119}, {-36,-118}, {-36,-114}, {-36,-113}, {-36,-88}, {-36,-87}, {-36,-84}, {-36,-83}, {-36,-71}, {-36,-70}, {-36,-67}, {-36,-59}, {-36,-58}, {-36,-55}, {-36,-54}, {-36,-51}, {-36,-46}, {-36,-45}, {-36,-44}, {-36,-43}, {-36,-38}, {-36,-37}, {-36,-36}, {-36,-33}, {-36,-32}, {-36,-31}, {-36,141}, {-36,142}, {-36,145}, {-36,146}, {-36,149}, {-36,150}, {-36,151}, {-36,152}, {-35,-121}, {-35,-120}, {-35,-119}, {-35,-118}, {-35,-117}, {-35,-114}, {-35,-113}, {-35,-88}, {-35,-87}, {-35,-84}, {-35,-83}, {-35,-71}, {-35,-70}, {-35,-67}, {-35,-59}, {-35,-58}, {-35,-55}, {-35,-54}, {-35,-51}, {-35,-46}, {-35,-45}, {-35,-44}, {-35,-43}, {-35,-37}, {-35,-36}, {-35,-35}, {-35,-33}, {-35,-32}, {-35,141}, {-35,142}, {-35,145}, {-35,149}, {-35,150}, {-35,151}, {-35,152}, {-34,-121}, {-34,-120}, {-34,-119}, {-34,-118}, {-34,-117}, {-34,-114}, {-34,-113}, {-34,-88}, {-34,-87}, {-34,-84}, {-34,-83}, {-34,-82}, {-34,-81}, {-34,-71}, {-34,-70}, {-34,-67}, {-34,-55}, {-34,-54}, {-34,-53}, {-34,-52}, {-34,-51}, {-34,-46}, {-34,-45}, {-34,-44}, {-34,-43}, {-34,-42}, {-34,-37}, {-34,-36}, {-34,-35}, {-34,-33}, {-34,-32}, {-34,-28}, {-34,-27}, {-34,141}, {-34,142}, {-34,150}, {-34,151}, {-34,152}, {-33,-121}, {-33,-120}, {-33,-119}, {-33,-118}, {-33,-117}, {-33,-114}, {-33,-113}, {-33,-88}, {-33,-87}, {-33,-84}, {-33,-83}, {-33,-82}, {-33,-81}, {-33,-71}, {-33,-70}, {-33,-67}, {-33,-55}, {-33,-54}, {-33,-53}, {-33,-52}, {-33,-50}, {-33,-46}, {-33,-45}, {-33,-44}, {-33,-43}, {-33,-42}, {-33,-36}, {-33,-35}, {-33,-28}, {-33,-27}, {-33,140}, {-33,141}, {-33,142}, {-33,150}, {-33,151}, {-33,152}, {-32,-120}, {-32,-119}, {-32,-118}, {-32,-117}, {-32,-114}, {-32,-113}, {-32,-89}, {-32,-88}, {-32,-87}, {-32,-84}, {-32,-71}, {-32,-70}, {-32,-67}, {-32,-59}, {-32,-55}, {-32,-54}, {-32,-53}, {-32,-52}, {-32,-51}, {-32,-49}, {-32,-46}, {-32,-45}, {-32,-42}, {-32,-41}, {-32,-35}, {-32,-34}, {-32,-29}, {-32,-28}, {-32,-27}, {-32,140}, {-32,141}, {-32,142}, {-32,145}, {-32,148}, {-32,150}, {-32,151}, {-32,152}, {-31,-120}, {-31,-119}, {-31,-118}, {-31,-117}, {-31,-114}, {-31,-113}, {-31,-112}, {-31,-89}, {-31,-88}, {-31,-84}, {-31,-71}, {-31,-70}, {-31,-67}, {-31,-59}, {-31,-58}, {-31,-55}, {-31,-54}, {-31,-53}, {-31,-52}, {-31,-51}, {-31,-46}, {-31,-45}, {-31,-42}, {-31,-41}, {-31,-35}, {-31,-34}, {-31,-29}, {-31,-28}, {-31,-27}, {-31,140}, {-31,141}, {-31,142}, {-31,147}, {-31,148}, {-31,151}, {-31,152}, {-31,153}, {-31,154}, {-31,155}, {-30,-120}, {-30,-119}, {-30,-118}, {-30,-117}, {-30,-113}, {-30,-112}, {-30,-89}, {-30,-88}, {-30,-85}, {-30,-84}, {-30,-71}, {-30,-70}, {-30,-67}, {-30,-59}, {-30,-58}, {-30,-55}, {-30,-54}, {-30,-53}, {-30,-52}, {-30,-51}, {-30,-46}, {-30,-45}, {-30,-42}, {-30,-41}, {-30,-40}, {-30,-39}, {-30,-34}, {-30,-29}, {-30,-28}, {-30,-27}, {-30,140}, {-30,141}, {-30,142}, {-30,151}, {-30,152}, {-30,153}, {-30,154}, {-30,155}, {-29,-120}, {-29,-119}, {-29,-118}, {-29,-117}, {-29,-116}, {-29,-113}, {-29,-112}, {-29,-89}, {-29,-88}, {-29,-85}, {-29,-71}, {-29,-70}, {-29,-67}, {-29,-59}, {-29,-58}, {-29,-55}, {-29,-54}, {-29,-53}, {-29,-52}, {-29,-51}, {-29,-46}, {-29,-45}, {-29,-42}, {-29,-41}, {-29,-40}, {-29,-39}, {-29,-38}, {-29,-29}, {-29,-28}, {-29,-27}, {-29,140}, {-29,141}, {-29,152}, {-29,153}, {-29,154}, {-29,155}, {-28,-120}, {-28,-119}, {-28,-118}, {-28,-117}, {-28,-116}, {-28,-113}, {-28,-112}, {-28,-90}, {-28,-89}, {-28,-88}, {-28,-85}, {-28,-84}, {-28,-83}, {-28,-71}, {-28,-70}, {-28,-67}, {-28,-58}, {-28,-55}, {-28,-54}, {-28,-53}, {-28,-52}, {-28,-51}, {-28,-50}, {-28,-46}, {-28,-45}, {-28,-38}, {-28,-37}, {-28,-29}, {-28,-28}, {-28,-27}, {-28,140}, {-28,141}, {-28,147}, {-28,152}, {-28,153}, {-28,154}, {-28,155}, {-27,-120}, {-27,-119}, {-27,-118}, {-27,-117}, {-27,-116}, {-27,-113}, {-27,-112}, {-27,-90}, {-27,-89}, {-27,-85}, {-27,-84}, {-27,-71}, {-27,-70}, {-27,-67}, {-27,-55}, {-27,-54}, {-27,-53}, {-27,-52}, {-27,-51}, {-27,-50}, {-27,-46}, {-27,-45}, {-27,-38}, {-27,-37}, {-27,-36}, {-27,-29}, {-27,-28}, {-27,-27}, {-27,148}, {-27,149}, {-27,152}, {-27,153}, {-27,154}, {-27,155}, {-26,-119}, {-26,-118}, {-26,-117}, {-26,-116}, {-26,-113}, {-26,-112}, {-26,-90}, {-26,-89}, {-26,-86}, {-26,-85}, {-26,-71}, {-26,-70}, {-26,-67}, {-26,-54}, {-26,-53}, {-26,-52}, {-26,-51}, {-26,-50}, {-26,-46}, {-26,-45}, {-26,-39}, {-26,-38}, {-26,-37}, {-26,-28}, {-26,-27}, {-26,148}, {-26,149}, {-26,150}, {-26,153}, {-26,154}, {-26,155}, {-25,-119}, {-25,-118}, {-25,-117}, {-25,-116}, {-25,-113}, {-25,-90}, {-25,-89}, {-25,-86}, {-25,-85}, {-25,-71}, {-25,-70}, {-25,-67}, {-25,-59}, {-25,-58}, {-25,-54}, {-25,-53}, {-25,-52}, {-25,-51}, {-25,-46}, {-25,-45}, {-25,-39}, {-25,-38}, {-25,-37}, {-25,-28}, {-25,-27}, {-25,148}, {-25,149}, {-25,150}, {-25,153}, {-25,154}, {-25,155}, {-24,-119}, {-24,-118}, {-24,-117}, {-24,-116}, {-24,-113}, {-24,-90}, {-24,-89}, {-24,-86}, {-24,-85}, {-24,-84}, {-24,-71}, {-24,-70}, {-24,-67}, {-24,-59}, {-24,-58}, {-24,-55}, {-24,-54}, {-24,-53}, {-24,-52}, {-24,-51}, {-24,-46}, {-24,-45}, {-24,-39}, {-24,-38}, {-24,-27}, {-24,148}, {-24,149}, {-24,150}, {-24,154}, {-24,155}, {-23,-119}, {-23,-118}, {-23,-117}, {-23,-116}, {-23,-113}, {-23,-90}, {-23,-86}, {-23,-85}, {-23,-84}, {-23,-83}, {-23,-71}, {-23,-67}, {-23,-59}, {-23,-58}, {-23,-55}, {-23,-54}, {-23,-51}, {-23,-46}, {-23,-45}, {-23,-39}, {-23,-33}, {-23,149}, {-23,150}, {-23,151}, {-23,154}, {-23,155}, {-22,-119}, {-22,-118}, {-22,-117}, {-22,-116}, {-22,-113}, {-22,-90}, {-22,-86}, {-22,-85}, {-22,-71}, {-22,-67}, {-22,-59}, {-22,-58}, {-22,-55}, {-22,-54}, {-22,-46}, {-22,-45}, {-22,-40}, {-22,-39}, {-22,-34}, {-22,-33}, {-22,-32}, {-22,-25}, {-22,-24}, {-22,-23}, {-22,-22}, {-22,-21}, {-22,24}, {-22,25}, {-22,150}, {-22,151}, {-22,154}, {-22,155}, {-21,-119}, {-21,-118}, {-21,-117}, {-21,-116}, {-21,-113}, {-21,-112}, {-21,-90}, {-21,-87}, {-21,-86}, {-21,-71}, {-21,-67}, {-21,-59}, {-21,-58}, {-21,-55}, {-21,-54}, {-21,-50}, {-21,-46}, {-21,-45}, {-21,-41}, {-21,-40}, {-21,-34}, {-21,-33}, {-21,-32}, {-21,-31}, {-21,-24}, {-21,-23}, {-21,-22}, {-21,-21}, {-21,-20}, {-21,-19}, {-21,-18}, {-21,-10}, {-21,-9}, {-21,-8}, {-21,-7}, {-21,-6}, {-21,-5}, {-21,-4}, {-21,-3}, {-21,-2}, {-21,-1}, {-21,0}, {-21,1}, {-21,2}, {-21,3}, {-21,4}, {-21,11}, {-21,12}, {-21,13}, {-21,14}, {-21,15}, {-21,18}, {-21,19}, {-21,20}, {-21,21}, {-21,25}, {-21,26}, {-21,150}, {-21,151}, {-21,154}, {-21,155}, {-20,-118}, {-20,-117}, {-20,-116}, {-20,-113}, {-20,-112}, {-20,-91}, {-20,-90}, {-20,-87}, {-20,-86}, {-20,-71}, {-20,-67}, {-20,-59}, {-20,-58}, {-20,-55}, {-20,-54}, {-20,-53}, {-20,-50}, {-20,-45}, {-20,-41}, {-20,-40}, {-20,-35}, {-20,-34}, {-20,-33}, {-20,-32}, {-20,-31}, {-20,-30}, {-20,-20}, {-20,-19}, {-20,-18}, {-20,-17}, {-20,-16}, {-20,-15}, {-20,-14}, {-20,-13}, {-20,-12}, {-20,-11}, {-20,-10}, {-20,-9}, {-20,-8}, {-20,-7}, {-20,-6}, {-20,-5}, {-20,-4}, {-20,-3}, {-20,-2}, {-20,-1}, {-20,0}, {-20,1}, {-20,2}, {-20,3}, {-20,4}, {-20,5}, {-20,18}, {-20,19}, {-20,20}, {-20,21}, {-20,22}, {-20,25}, {-20,26}, {-20,150}, {-20,151}, {-20,154}, {-20,155}, {-19,-118}, {-19,-117}, {-19,-116}, {-19,-113}, {-19,-112}, {-19,-111}, {-19,-91}, {-19,-90}, {-19,-87}, {-19,-86}, {-19,-71}, {-19,-67}, {-19,-59}, {-19,-58}, {-19,-55}, {-19,-50}, {-19,-49}, {-19,-45}, {-19,-44}, {-19,-43}, {-19,-42}, {-19,-41}, {-19,-40}, {-19,-35}, {-19,-34}, {-19,-33}, {-19,-32}, {-19,-31}, {-19,-30}, {-19,-29}, {-19,-3}, {-19,-2}, {-19,-1}, {-19,0}, {-19,1}, {-19,2}, {-19,3}, {-19,4}, {-19,5}, {-19,6}, {-19,7}, {-19,17}, {-19,18}, {-19,19}, {-19,20}, {-19,21}, {-19,22}, {-19,25}, {-19,26}, {-19,150}, {-19,151}, {-19,154}, {-19,155}, {-18,-118}, {-18,-117}, {-18,-116}, {-18,-112}, {-18,-111}, {-18,-91}, {-18,-87}, {-18,-86}, {-18,-85}, {-18,-84}, {-18,-71}, {-18,-67}, {-18,-59}, {-18,-58}, {-18,-55}, {-18,-50}, {-18,-49}, {-18,-46}, {-18,-45}, {-18,-44}, {-18,-43}, {-18,-42}, {-18,-41}, {-18,-36}, {-18,-35}, {-18,-34}, {-18,-33}, {-18,-32}, {-18,-31}, {-18,-30}, {-18,-29}, {-18,-28}, {-18,3}, {-18,4}, {-18,5}, {-18,6}, {-18,7}, {-18,8}, {-18,16}, {-18,17}, {-18,18}, {-18,19}, {-18,20}, {-18,21}, {-18,22}, {-18,25}, {-18,26}, {-18,27}, {-18,150}, {-18,151}, {-18,154}, {-18,155}, {-17,-118}, {-17,-117}, {-17,-116}, {-17,-112}, {-17,-92}, {-17,-91}, {-17,-87}, {-17,-86}, {-17,-71}, {-17,-68}, {-17,-67}, {-17,-59}, {-17,-58}, {-17,-55}, {-17,-50}, {-17,-49}, {-17,-46}, {-17,-45}, {-17,-44}, {-17,-43}, {-17,-42}, {-17,-41}, {-17,-36}, {-17,-35}, {-17,-34}, {-17,-33}, {-17,-32}, {-17,-31}, {-17,-30}, {-17,-29}, {-17,-28}, {-17,-27}, {-17,-26}, {-17,-21}, {-17,-20}, {-17,-19}, {-17,-18}, {-17,-17}, {-17,-16}, {-17,-11}, {-17,-10}, {-17,-9}, {-17,-8}, {-17,-7}, {-17,16}, {-17,17}, {-17,18}, {-17,19}, {-17,20}, {-17,21}, {-17,22}, {-17,25}, {-17,26}, {-17,27}, {-17,150}, {-17,151}, {-17,154}, {-17,155}, {-16,-118}, {-16,-117}, {-16,-116}, {-16,-112}, {-16,-92}, {-16,-91}, {-16,-88}, {-16,-87}, {-16,-86}, {-16,-71}, {-16,-68}, {-16,-67}, {-16,-59}, {-16,-58}, {-16,-55}, {-16,-54}, {-16,-50}, {-16,-49}, {-16,-46}, {-16,-45}, {-16,-44}, {-16,-43}, {-16,-42}, {-16,-36}, {-16,-35}, {-16,-34}, {-16,-30}, {-16,-29}, {-16,-28}, {-16,-27}, {-16,-26}, {-16,-25}, {-16,-19}, {-16,-18}, {-16,-17}, {-16,-16}, {-16,-15}, {-16,-14}, {-16,-13}, {-16,-12}, {-16,-9}, {-16,-8}, {-16,-7}, {-16,-6}, {-16,-5}, {-16,-4}, {-16,-3}, {-16,-2}, {-16,-1}, {-16,0}, {-16,1}, {-16,17}, {-16,18}, {-16,19}, {-16,20}, {-16,21}, {-16,22}, {-16,25}, {-16,26}, {-16,27}, {-16,28}, {-16,150}, {-16,151}, {-16,154}, {-16,155}, {-15,-118}, {-15,-117}, {-15,-116}, {-15,-112}, {-15,-92}, {-15,-91}, {-15,-88}, {-15,-87}, {-15,-86}, {-15,-71}, {-15,-68}, {-15,-67}, {-15,-59}, {-15,-58}, {-15,-55}, {-15,-54}, {-15,-50}, {-15,-49}, {-15,-46}, {-15,-45}, {-15,-44}, {-15,-43}, {-15,-42}, {-15,-37}, {-15,-36}, {-15,-35}, {-15,-34}, {-15,-26}, {-15,-25}, {-15,-24}, {-15,-17}, {-15,-16}, {-15,-14}, {-15,-13}, {-15,-12}, {-15,-11}, {-15,-10}, {-15,-9}, {-15,-8}, {-15,-7}, {-15,-6}, {-15,-5}, {-15,-4}, {-15,-3}, {-15,-2}, {-15,-1}, {-15,0}, {-15,1}, {-15,2}, {-15,20}, {-15,21}, {-15,22}, {-15,26}, {-15,27}, {-15,28}, {-15,150}, {-15,151}, {-15,154}, {-15,155}, {-14,-117}, {-14,-116}, {-14,-111}, {-14,-110}, {-14,-92}, {-14,-91}, {-14,-88}, {-14,-87}, {-14,-86}, {-14,-71}, {-14,-68}, {-14,-67}, {-14,-59}, {-14,-58}, {-14,-55}, {-14,-54}, {-14,-53}, {-14,-50}, {-14,-49}, {-14,-46}, {-14,-45}, {-14,-44}, {-14,-43}, {-14,-42}, {-14,-38}, {-14,-37}, {-14,-36}, {-14,-35}, {-14,-25}, {-14,-24}, {-14,-23}, {-14,-22}, {-14,-14}, {-14,-13}, {-14,-12}, {-14,-11}, {-14,-10}, {-14,-9}, {-14,-8}, {-14,-7}, {-14,-6}, {-14,-5}, {-14,-4}, {-14,-3}, {-14,-2}, {-14,-1}, {-14,0}, {-14,7}, {-14,8}, {-14,9}, {-14,11}, {-14,12}, {-14,22}, {-14,26}, {-14,27}, {-14,28}, {-14,29}, {-14,151}, {-14,154}, {-14,155}, {-13,-117}, {-13,-116}, {-13,-115}, {-13,-111}, {-13,-110}, {-13,-109}, {-13,-92}, {-13,-91}, {-13,-88}, {-13,-87}, {-13,-86}, {-13,-85}, {-13,-84}, {-13,-71}, {-13,-68}, {-13,-67}, {-13,-59}, {-13,-58}, {-13,-54}, {-13,-53}, {-13,-50}, {-13,-49}, {-13,-46}, {-13,-45}, {-13,-44}, {-13,-43}, {-13,-38}, {-13,-37}, {-13,-36}, {-13,-24}, {-13,-23}, {-13,-22}, {-13,-14}, {-13,-13}, {-13,-12}, {-13,-11}, {-13,-10}, {-13,-9}, {-13,-8}, {-13,-7}, {-13,-6}, {-13,-5}, {-13,-4}, {-13,-3}, {-13,-2}, {-13,-1}, {-13,5}, {-13,6}, {-13,7}, {-13,8}, {-13,9}, {-13,10}, {-13,11}, {-13,12}, {-13,13}, {-13,14}, {-13,27}, {-13,28}, {-13,29}, {-13,30}, {-13,151}, {-13,154}, {-13,155}, {-12,-117}, {-12,-116}, {-12,-115}, {-12,-110}, {-12,-109}, {-12,-108}, {-12,-107}, {-12,-92}, {-12,-91}, {-12,-88}, {-12,-87}, {-12,-85}, {-12,-84}, {-12,-71}, {-12,-68}, {-12,-67}, {-12,-59}, {-12,-58}, {-12,-54}, {-12,-53}, {-12,-50}, {-12,-49}, {-12,-46}, {-12,-45}, {-12,-44}, {-12,-43}, {-12,-39}, {-12,-38}, {-12,-37}, {-12,-36}, {-12,-27}, {-12,-20}, {-12,-19}, {-12,-11}, {-12,-10}, {-12,-9}, {-12,-8}, {-12,-7}, {-12,-6}, {-12,-5}, {-12,-4}, {-12,4}, {-12,5}, {-12,6}, {-12,7}, {-12,8}, {-12,9}, {-12,10}, {-12,11}, {-12,12}, {-12,13}, {-12,14}, {-12,15}, {-12,28}, {-12,29}, {-12,30}, {-12,151}, {-12,154}, {-12,155}, {-11,-117}, {-11,-116}, {-11,-115}, {-11,-109}, {-11,-108}, {-11,-107}, {-11,-92}, {-11,-91}, {-11,-88}, {-11,-87}, {-11,-71}, {-11,-68}, {-11,-67}, {-11,-59}, {-11,-58}, {-11,-54}, {-11,-53}, {-11,-52}, {-11,-51}, {-11,-50}, {-11,-46}, {-11,-45}, {-11,-44}, {-11,-39}, {-11,-38}, {-11,-37}, {-11,-36}, {-11,-27}, {-11,-20}, {-11,-19}, {-11,-18}, {-11,-17}, {-11,-8}, {-11,-7}, {-11,-6}, {-11,3}, {-11,4}, {-11,5}, {-11,6}, {-11,7}, {-11,8}, {-11,9}, {-11,10}, {-11,11}, {-11,12}, {-11,13}, {-11,14}, {-11,15}, {-11,16}, {-11,17}, {-11,151}, {-11,154}, {-11,155}, {-10,-117}, {-10,-116}, {-10,-115}, {-10,-108}, {-10,-107}, {-10,-106}, {-10,-105}, {-10,-92}, {-10,-88}, {-10,-87}, {-10,-71}, {-10,-68}, {-10,-67}, {-10,-59}, {-10,-58}, {-10,-54}, {-10,-53}, {-10,-52}, {-10,-51}, {-10,-50}, {-10,-46}, {-10,-45}, {-10,-44}, {-10,-39}, {-10,-38}, {-10,-37}, {-10,-36}, {-10,-21}, {-10,-20}, {-10,-19}, {-10,-18}, {-10,-17}, {-10,-16}, {-10,-15}, {-10,-14}, {-10,1}, {-10,2}, {-10,3}, {-10,4}, {-10,5}, {-10,6}, {-10,7}, {-10,8}, {-10,14}, {-10,15}, {-10,16}, {-10,17}, {-10,18}, {-10,19}, {-10,151}, {-10,154}, {-10,155}, {-9,-117}, {-9,-116}, {-9,-115}, {-9,-112}, {-9,-107}, {-9,-106}, {-9,-105}, {-9,-104}, {-9,-103}, {-9,-88}, {-9,-87}, {-9,-71}, {-9,-68}, {-9,-67}, {-9,-59}, {-9,-58}, {-9,-54}, {-9,-53}, {-9,-52}, {-9,-51}, {-9,-50}, {-9,-47}, {-9,-46}, {-9,-45}, {-9,-44}, {-9,-40}, {-9,-39}, {-9,-38}, {-9,-21}, {-9,-20}, {-9,-19}, {-9,-18}, {-9,-17}, {-9,-13}, {-9,-12}, {-9,151}, {-9,154}, {-9,155}, {-8,-116}, {-8,-115}, {-8,-112}, {-8,-111}, {-8,-105}, {-8,-104}, {-8,-103}, {-8,-102}, {-8,-94}, {-8,-93}, {-8,-89}, {-8,-88}, {-8,-87}, {-8,-86}, {-8,-85}, {-8,-71}, {-8,-68}, {-8,-67}, {-8,-59}, {-8,-58}, {-8,-54}, {-8,-53}, {-8,-52}, {-8,-51}, {-8,-50}, {-8,-47}, {-8,-46}, {-8,-45}, {-8,-41}, {-8,-40}, {-8,-39}, {-8,-38}, {-8,-27}, {-8,-26}, {-8,-25}, {-8,-24}, {-8,-23}, {-8,-22}, {-8,-21}, {-8,-20}, {-8,-17}, {-8,-16}, {-8,-15}, {-8,-13}, {-8,-12}, {-8,151}, {-8,154}, {-8,155}, {-7,-116}, {-7,-115}, {-7,-112}, {-7,-111}, {-7,-110}, {-7,-109}, {-7,-104}, {-7,-103}, {-7,-102}, {-7,-101}, {-7,-100}, {-7,-99}, {-7,-94}, {-7,-93}, {-7,-89}, {-7,-88}, {-7,-87}, {-7,-71}, {-7,-68}, {-7,-67}, {-7,-59}, {-7,-58}, {-7,-53}, {-7,-52}, {-7,-51}, {-7,-50}, {-7,-46}, {-7,-45}, {-7,-41}, {-7,-40}, {-7,-39}, {-7,-38}, {-7,-28}, {-7,-27}, {-7,-26}, {-7,-25}, {-7,-24}, {-7,-23}, {-7,-21}, {-7,151}, {-7,154}, {-7,155}, {-6,-116}, {-6,-115}, {-6,-112}, {-6,-111}, {-6,-110}, {-6,-109}, {-6,-108}, {-6,-102}, {-6,-101}, {-6,-100}, {-6,-99}, {-6,-98}, {-6,-94}, {-6,-89}, {-6,-88}, {-6,-71}, {-6,-68}, {-6,-67}, {-6,-59}, {-6,-58}, {-6,-53}, {-6,-52}, {-6,-51}, {-6,-50}, {-6,-46}, {-6,-42}, {-6,-41}, {-6,-40}, {-6,-39}, {-6,-38}, {-6,-32}, {-6,-31}, {-6,-30}, {-6,-29}, {-6,-28}, {-6,-27}, {-6,-26}, {-6,-25}, {-6,-3}, {-6,-2}, {-6,-1}, {-6,23}, {-6,24}, {-6,25}, {-6,26}, {-6,151}, {-6,154}, {-6,155}, {-5,-116}, {-5,-115}, {-5,-112}, {-5,-108}, {-5,-107}, {-5,-106}, {-5,-100}, {-5,-99}, {-5,-98}, {-5,-97}, {-5,-96}, {-5,-95}, {-5,-94}, {-5,-89}, {-5,-88}, {-5,-71}, {-5,-68}, {-5,-67}, {-5,-59}, {-5,-58}, {-5,-53}, {-5,-52}, {-5,-46}, {-5,-42}, {-5,-41}, {-5,-40}, {-5,-39}, {-5,-38}, {-5,-34}, {-5,-33}, {-5,-32}, {-5,-31}, {-5,-30}, {-5,-29}, {-5,-28}, {-5,-7}, {-5,-6}, {-5,-5}, {-5,-4}, {-5,-3}, {-5,-2}, {-5,-1}, {-5,0}, {-5,1}, {-5,2}, {-5,3}, {-5,5}, {-5,6}, {-5,7}, {-5,9}, {-5,20}, {-5,22}, {-5,23}, {-5,24}, {-5,25}, {-5,26}, {-5,27}, {-5,28}, {-5,29}, {-5,30}, {-5,150}, {-5,151}, {-5,154}, {-5,155}, {-4,-116}, {-4,-115}, {-4,-112}, {-4,-106}, {-4,-105}, {-4,-99}, {-4,-98}, {-4,-97}, {-4,-96}, {-4,-95}, {-4,-94}, {-4,-89}, {-4,-88}, {-4,-87}, {-4,-86}, {-4,-71}, {-4,-68}, {-4,-67}, {-4,-59}, {-4,-53}, {-4,-52}, {-4,-43}, {-4,-42}, {-4,-41}, {-4,-40}, {-4,-39}, {-4,-38}, {-4,-37}, {-4,-36}, {-4,-35}, {-4,-34}, {-4,-33}, {-4,-32}, {-4,-10}, {-4,-9}, {-4,-8}, {-4,-7}, {-4,-6}, {-4,-5}, {-4,-4}, {-4,-3}, {-4,-2}, {-4,-1}, {-4,0}, {-4,1}, {-4,2}, {-4,3}, {-4,9}, {-4,10}, {-4,11}, {-4,12}, {-4,13}, {-4,14}, {-4,15}, {-4,16}, {-4,17}, {-4,18}, {-4,19}, {-4,20}, {-4,21}, {-4,22}, {-4,23}, {-4,24}, {-4,25}, {-4,26}, {-4,27}, {-4,29}, {-4,150}, {-4,154}, {-4,155}, {-3,-116}, {-3,-115}, {-3,-112}, {-3,-111}, {-3,-106}, {-3,-105}, {-3,-104}, {-3,-103}, {-3,-97}, {-3,-96}, {-3,-95}, {-3,-94}, {-3,-93}, {-3,-89}, {-3,-88}, {-3,-87}, {-3,-86}, {-3,-71}, {-3,-68}, {-3,-67}, {-3,-59}, {-3,-53}, {-3,-52}, {-3,-43}, {-3,-42}, {-3,-41}, {-3,-40}, {-3,-39}, {-3,-38}, {-3,-37}, {-3,-15}, {-3,-14}, {-3,-13}, {-3,-12}, {-3,-11}, {-3,-10}, {-3,-9}, {-3,-8}, {-3,-7}, {-3,-6}, {-3,-5}, {-3,-4}, {-3,-3}, {-3,-2}, {-3,-1}, {-3,0}, {-3,1}, {-3,2}, {-3,3}, {-3,4}, {-3,5}, {-3,6}, {-3,7}, {-3,8}, {-3,9}, {-3,10}, {-3,11}, {-3,12}, {-3,13}, {-3,14}, {-3,15}, {-3,16}, {-3,17}, {-3,18}, {-3,19}, {-3,20}, {-3,21}, {-3,22}, {-3,23}, {-3,24}, {-3,25}, {-3,26}, {-3,27}, {-3,29}, {-3,150}, {-3,154}, {-3,155}, {-2,-115}, {-2,-112}, {-2,-111}, {-2,-103}, {-2,-102}, {-2,-95}, {-2,-94}, {-2,-93}, {-2,-89}, {-2,-88}, {-2,-71}, {-2,-68}, {-2,-67}, {-2,-59}, {-2,-56}, {-2,-52}, {-2,-44}, {-2,-43}, {-2,-42}, {-2,-41}, {-2,-40}, {-2,-39}, {-2,-36}, {-2,-16}, {-2,-15}, {-2,-14}, {-2,-13}, {-2,-12}, {-2,-11}, {-2,-10}, {-2,-9}, {-2,-8}, {-2,-7}, {-2,-6}, {-2,-5}, {-2,-4}, {-2,-3}, {-2,-2}, {-2,-1}, {-2,0}, {-2,1}, {-2,2}, {-2,3}, {-2,4}, {-2,5}, {-2,6}, {-2,7}, {-2,8}, {-2,9}, {-2,10}, {-2,11}, {-2,12}, {-2,13}, {-2,14}, {-2,15}, {-2,16}, {-2,17}, {-2,18}, {-2,19}, {-2,20}, {-2,21}, {-2,22}, {-2,23}, {-2,24}, {-2,150}, {-2,153}, {-2,154}, {-2,155}, {-1,-115}, {-1,-112}, {-1,-111}, {-1,-110}, {-1,-102}, {-1,-101}, {-1,-100}, {-1,-94}, {-1,-93}, {-1,-89}, {-1,-88}, {-1,-71}, {-1,-68}, {-1,-67}, {-1,-59}, {-1,-56}, {-1,-52}, {-1,-44}, {-1,-43}, {-1,-42}, {-1,-41}, {-1,-40}, {-1,-39}, {-1,-19}, {-1,-18}, {-1,-17}, {-1,-16}, {-1,-15}, {-1,-14}, {-1,-13}, {-1,-12}, {-1,-11}, {-1,-10}, {-1,-9}, {-1,-8}, {-1,-7}, {-1,-6}, {-1,-5}, {-1,-4}, {-1,-3}, {-1,-2}, {-1,2}, {-1,3}, {-1,4}, {-1,5}, {-1,6}, {-1,7}, {-1,8}, {-1,9}, {-1,10}, {-1,11}, {-1,12}, {-1,13}, {-1,14}, {-1,15}, {-1,16}, {-1,17}, {-1,18}, {-1,19}, {-1,20}, {-1,21}, {-1,22}, {-1,26}, {-1,149}, {-1,150}, {-1,153}, {-1,154}, {-1,155}, {0,-115}, {0,-111}, {0,-110}, {0,-100}, {0,-99}, {0,-98}, {0,-89}, {0,-88}, {0,-71}, {0,-68}, {0,-67}, {0,-59}, {0,-56}, {0,-52}, {0,-45}, {0,-44}, {0,-43}, {0,-42}, {0,-22}, {0,-21}, {0,-20}, {0,-19}, {0,-18}, {0,-17}, {0,-16}, {0,-15}, {0,-14}, {0,-13}, {0,-12}, {0,-11}, {0,-10}, {0,-9}, {0,-8}, {0,-7}, {0,-6}, {0,-5}, {0,-4}, {0,-3}, {0,-2}, {0,2}, {0,3}, {0,4}, {0,5}, {0,6}, {0,7}, {0,8}, {0,9}, {0,10}, {0,11}, {0,12}, {0,13}, {0,14}, {0,15}, {0,16}, {0,17}, {0,18}, {0,19}, {0,149}, {0,150}, {0,153}, {0,154}, {0,155}, {1,-115}, {1,-111}, {1,-110}, {1,-98}, {1,-97}, {1,-89}, {1,-88}, {1,-87}, {1,-86}, {1,-71}, {1,-68}, {1,-67}, {1,-59}, {1,-56}, {1,-55}, {1,-23}, {1,-22}, {1,-21}, {1,-20}, {1,-19}, {1,-18}, {1,-17}, {1,-16}, {1,-15}, {1,-14}, {1,-13}, {1,-12}, {1,-11}, {1,-10}, {1,-9}, {1,-8}, {1,-7}, {1,-6}, {1,-5}, {1,-4}, {1,-3}, {1,-2}, {1,2}, {1,3}, {1,4}, {1,5}, {1,6}, {1,7}, {1,8}, {1,9}, {1,10}, {1,11}, {1,12}, {1,13}, {1,14}, {1,15}, {1,16}, {1,17}, {1,149}, {1,150}, {1,153}, {1,154}, {1,155}, {2,-115}, {2,-114}, {2,-111}, {2,-110}, {2,-97}, {2,-96}, {2,-95}, {2,-89}, {2,-88}, {2,-87}, {2,-86}, {2,-71}, {2,-67}, {2,-59}, {2,-56}, {2,-26}, {2,-25}, {2,-24}, {2,-23}, {2,-22}, {2,-21}, {2,-20}, {2,-19}, {2,-18}, {2,-17}, {2,-16}, {2,-15}, {2,-14}, {2,-13}, {2,-12}, {2,-11}, {2,-10}, {2,-9}, {2,-8}, {2,-7}, {2,-6}, {2,-5}, {2,-4}, {2,-3}, {2,-2}, {2,-1}, {2,0}, {2,1}, {2,2}, {2,3}, {2,4}, {2,5}, {2,6}, {2,7}, {2,149}, {2,153}, {2,154}, {2,155}, {3,-115}, {3,-114}, {3,-111}, {3,-110}, {3,-97}, {3,-96}, {3,-95}, {3,-94}, {3,-90}, {3,-89}, {3,-88}, {3,-71}, {3,-67}, {3,-55}, {3,-27}, {3,-26}, {3,-25}, {3,-24}, {3,-23}, {3,-22}, {3,-21}, {3,-20}, {3,-19}, {3,-18}, {3,-6}, {3,-5}, {3,-4}, {3,-3}, {3,-2}, {3,-1}, {3,0}, {3,3}, {3,4}, {3,5}, {3,6}, {3,148}, {3,149}, {3,153}, {3,154}, {3,155}, {4,-114}, {4,-111}, {4,-110}, {4,-96}, {4,-95}, {4,-94}, {4,-93}, {4,-90}, {4,-89}, {4,-88}, {4,-71}, {4,-67}, {4,-44}, {4,-40}, {4,-39}, {4,-38}, {4,-37}, {4,-32}, {4,-30}, {4,-29}, {4,-28}, {4,-27}, {4,-26}, {4,-25}, {4,-24}, {4,-23}, {4,-22}, {4,-21}, {4,-20}, {4,-19}, {4,3}, {4,4}, {4,5}, {4,148}, {4,149}, {4,152}, {4,153}, {4,154}, {4,155}, {5,-114}, {5,-111}, {5,-110}, {5,-95}, {5,-94}, {5,-93}, {5,-89}, {5,-88}, {5,-71}, {5,-67}, {5,-42}, {5,-41}, {5,-40}, {5,-39}, {5,-33}, {5,-31}, {5,-30}, {5,-29}, {5,-28}, {5,-27}, {5,-26}, {5,-25}, {5,-24}, {5,-23}, {5,-22}, {5,-21}, {5,148}, {5,152}, {5,153}, {5,154}, {5,155}, {6,-114}, {6,-110}, {6,-95}, {6,-94}, {6,-93}, {6,-89}, {6,-88}, {6,-87}, {6,-86}, {6,-71}, {6,-67}, {6,-45}, {6,-42}, {6,-41}, {6,-40}, {6,-36}, {6,-34}, {6,-33}, {6,-32}, {6,-31}, {6,-30}, {6,-29}, {6,-28}, {6,-27}, {6,-26}, {6,-25}, {6,-24}, {6,148}, {6,152}, {6,153}, {6,154}, {6,155}, {7,-114}, {7,-94}, {7,-93}, {7,-89}, {7,-88}, {7,-87}, {7,-86}, {7,-71}, {7,-70}, {7,-67}, {7,-47}, {7,-46}, {7,-45}, {7,-41}, {7,-36}, {7,-35}, {7,-34}, {7,-33}, {7,-32}, {7,-31}, {7,-30}, {7,-29}, {7,-28}, {7,-27}, {7,148}, {7,152}, {7,153}, {7,154}, {7,155}, {8,-114}, {8,-113}, {8,-105}, {8,-104}, {8,-103}, {8,-102}, {8,-93}, {8,-89}, {8,-88}, {8,-71}, {8,-70}, {8,-67}, {8,-48}, {8,-47}, {8,-46}, {8,-45}, {8,-44}, {8,-38}, {8,-37}, {8,-36}, {8,-35}, {8,-34}, {8,-33}, {8,-32}, {8,-31}, {8,148}, {8,151}, {8,152}, {8,153}, {8,154}, {8,155}, {9,-114}, {9,-113}, {9,-112}, {9,-104}, {9,-103}, {9,-102}, {9,-101}, {9,-93}, {9,-89}, {9,-88}, {9,-71}, {9,-70}, {9,-67}, {9,-49}, {9,-48}, {9,-47}, {9,-46}, {9,-45}, {9,-44}, {9,-40}, {9,-39}, {9,-38}, {9,-37}, {9,-36}, {9,148}, {9,151}, {9,152}, {10,-114}, {10,-113}, {10,-112}, {10,-111}, {10,-110}, {10,-109}, {10,-108}, {10,-103}, {10,-102}, {10,-101}, {10,-100}, {10,-93}, {10,-92}, {10,-88}, {10,-71}, {10,-70}, {10,-67}, {10,147}, {10,148}, {10,151}, {10,152}, {11,-108}, {11,-107}, {11,-103}, {11,-102}, {11,-101}, {11,-100}, {11,-94}, {11,-93}, {11,-92}, {11,-91}, {11,-88}, {11,-71}, {11,-70}, {11,-67}, {11,147}, {11,148}, {11,151}, {11,152}, {12,-108}, {12,-107}, {12,-106}, {12,-102}, {12,-101}, {12,-100}, {12,-93}, {12,-92}, {12,-91}, {12,-88}, {12,-87}, {12,-86}, {12,-85}, {12,-71}, {12,-70}, {12,-67}, {12,145}, {12,146}, {12,147}, {12,151}, {12,152}, {13,-108}, {13,-107}, {13,-106}, {13,-102}, {13,-101}, {13,-100}, {13,-93}, {13,-92}, {13,-91}, {13,-88}, {13,-87}, {13,-86}, {13,-85}, {13,-71}, {13,-70}, {13,-67}, {13,145}, {13,146}, {13,147}, {13,151}, {13,152}, {14,-108}, {14,-107}, {14,-106}, {14,-105}, {14,-102}, {14,-101}, {14,-100}, {14,-93}, {14,-92}, {14,-91}, {14,-88}, {14,-87}, {14,-71}, {14,-70}, {14,-67}, {14,145}, {14,146}, {14,147}, {14,151}, {14,152}, {15,-108}, {15,-107}, {15,-106}, {15,-105}, {15,-102}, {15,-101}, {15,-100}, {15,-99}, {15,-98}, {15,-92}, {15,-91}, {15,-88}, {15,-71}, {15,-67}, {15,144}, {15,145}, {15,146}, {15,147}, {15,151}, {15,152}, {16,-108}, {16,-107}, {16,-106}, {16,-105}, {16,-102}, {16,-101}, {16,-100}, {16,-99}, {16,-98}, {16,-92}, {16,-91}, {16,-88}, {16,-71}, {16,143}, {16,144}, {16,145}, {16,146}, {16,147}, {16,151}, {16,152}, {17,-107}, {17,-106}, {17,-105}, {17,-101}, {17,-100}, {17,-99}, {17,-98}, {17,-91}, {17,-87}, {17,-85}, {17,-71}, {17,-65}, {17,-64}, {17,-63}, {17,-62}, {17,-61}, {17,-60}, {17,-59}, {17,-58}, {17,-57}, {17,-56}, {17,-55}, {17,-54}, {17,-53}, {17,-13}, {17,-12}, {17,143}, {17,144}, {17,145}, {17,146}, {17,151}, {17,152}, {18,-107}, {18,-106}, {18,-105}, {18,-101}, {18,-100}, {18,-99}, {18,-98}, {18,-97}, {18,-96}, {18,-91}, {18,-87}, {18,-85}, {18,-72}, {18,-71}, {18,-68}, {18,-12}, {18,-11}, {18,143}, {18,144}, {18,145}, {18,146}, {18,151}, {18,152}, {19,-107}, {19,-106}, {19,-105}, {19,-104}, {19,-101}, {19,-100}, {19,-99}, {19,-98}, {19,-97}, {19,-96}, {19,-91}, {19,-90}, {19,-87}, {19,-85}, {19,-72}, {19,-71}, {19,-11}, {19,-10}, {19,143}, {19,144}, {19,145}, {19,146}, {19,150}, {19,151}, {19,152}, {20,-107}, {20,-106}, {20,-105}, {20,-104}, {20,-101}, {20,-100}, {20,-99}, {20,-98}, {20,-97}, {20,-96}, {20,-91}, {20,-90}, {20,-87}, {20,-72}, {20,-71}, {20,-65}, {20,-64}, {20,-63}, {20,-62}, {20,-61}, {20,-60}, {20,-59}, {20,-58}, {20,-57}, {20,-56}, {20,-55}, {20,-54}, {20,-53}, {20,-52}, {20,-51}, {20,-50}, {20,-49}, {20,-48}, {20,-47}, {20,-46}, {20,-45}, {20,-44}, {20,-43}, {20,-24}, {20,-23}, {20,-22}, {20,-21}, {20,-20}, {20,-19}, {20,-10}, {20,-9}, {20,143}, {20,144}, {20,145}, {20,146}, {20,150}, {20,151}, {20,152}, {21,-107}, {21,-106}, {21,-105}, {21,-104}, {21,-101}, {21,-100}, {21,-99}, {21,-98}, {21,-97}, {21,-96}, {21,-91}, {21,-90}, {21,-73}, {21,-72}, {21,-71}, {21,-67}, {21,-42}, {21,-37}, {21,-36}, {21,-35}, {21,-34}, {21,-33}, {21,-32}, {21,-31}, {21,-30}, {21,-29}, {21,-28}, {21,-27}, {21,-26}, {21,-25}, {21,-24}, {21,-23}, {21,-22}, {21,-21}, {21,-20}, {21,-19}, {21,-18}, {21,-17}, {21,-16}, {21,-15}, {21,143}, {21,144}, {21,145}, {21,150}, {21,151}, {21,152}, {22,-107}, {22,-106}, {22,-105}, {22,-104}, {22,-101}, {22,-100}, {22,-99}, {22,-98}, {22,-97}, {22,-96}, {22,-95}, {22,-94}, {22,-93}, {22,-92}, {22,-91}, {22,-90}, {22,-86}, {22,-73}, {22,-72}, {22,-71}, {22,-68}, {22,-67}, {22,-37}, {22,-36}, {22,-35}, {22,-34}, {22,-33}, {22,-32}, {22,-31}, {22,-25}, {22,-24}, {22,-23}, {22,-19}, {22,-18}, {22,-17}, {22,-16}, {22,-15}, {22,-14}, {22,-13}, {22,143}, {22,144}, {22,145}, {22,150}, {22,151}, {22,152}, {23,-106}, {23,-105}, {23,-104}, {23,-100}, {23,-99}, {23,-98}, {23,-97}, {23,-96}, {23,-95}, {23,-94}, {23,-93}, {23,-92}, {23,-91}, {23,-90}, {23,-86}, {23,-73}, {23,-72}, {23,-71}, {23,-68}, {23,-37}, {23,-36}, {23,-35}, {23,-34}, {23,-33}, {23,-19}, {23,-18}, {23,-17}, {23,-16}, {23,-15}, {23,-14}, {23,-13}, {23,-12}, {23,143}, {23,144}, {23,150}, {23,151}, {23,152}, {24,-106}, {24,-105}, {24,-104}, {24,-103}, {24,-100}, {24,-99}, {24,-98}, {24,-95}, {24,-94}, {24,-93}, {24,-92}, {24,-91}, {24,-90}, {24,-86}, {24,-74}, {24,-73}, {24,-72}, {24,-68}, {24,-36}, {24,-35}, {24,-34}, {24,-33}, {24,-16}, {24,-15}, {24,-14}, {24,-13}, {24,-12}, {24,-11}, {24,143}, {24,144}, {24,150}, {24,151}, {24,152}, {25,-106}, {25,-105}, {25,-104}, {25,-103}, {25,-100}, {25,-99}, {25,-98}, {25,-92}, {25,-91}, {25,-90}, {25,-86}, {25,-74}, {25,-73}, {25,-72}, {25,-69}, {25,-36}, {25,-35}, {25,-34}, {25,-33}, {25,-14}, {25,-13}, {25,-11}, {25,-10}, {25,142}, {25,143}, {25,149}, {25,150}, {25,151}, {25,152}, {26,-106}, {26,-105}, {26,-104}, {26,-103}, {26,-100}, {26,-99}, {26,-98}, {26,-92}, {26,-91}, {26,-86}, {26,-85}, {26,-74}, {26,-73}, {26,-72}, {26,-69}, {26,-35}, {26,-34}, {26,-33}, {26,-15}, {26,-14}, {26,-13}, {26,-11}, {26,-10}, {26,-9}, {26,-8}, {26,141}, {26,142}, {26,143}, {26,149}, {26,150}, {26,151}, {26,152}, {27,-106}, {27,-105}, {27,-104}, {27,-103}, {27,-100}, {27,-99}, {27,-98}, {27,-93}, {27,-92}, {27,-91}, {27,-85}, {27,-73}, {27,-72}, {27,-69}, {27,-35}, {27,-34}, {27,-33}, {27,-15}, {27,-14}, {27,-13}, {27,-12}, {27,-11}, {27,-10}, {27,-9}, {27,-8}, {27,140}, {27,141}, {27,142}, {27,147}, {27,149}, {27,150}, {27,151}, {27,152}, {28,-106}, {28,-105}, {28,-104}, {28,-103}, {28,-100}, {28,-99}, {28,-98}, {28,-93}, {28,-92}, {28,-91}, {28,-85}, {28,-73}, {28,-72}, {28,-69}, {28,-38}, {28,-35}, {28,-34}, {28,-33}, {28,-16}, {28,-15}, {28,-14}, {28,-12}, {28,-11}, {28,-10}, {28,-9}, {28,-8}, {28,140}, {28,141}, {28,146}, {28,147}, {28,149}, {28,150}, {28,151}, {28,152}, {29,-105}, {29,-104}, {29,-103}, {29,-100}, {29,-99}, {29,-98}, {29,-93}, {29,-92}, {29,-91}, {29,-85}, {29,-73}, {29,-72}, {29,-69}, {29,-38}, {29,-34}, {29,-33}, {29,-32}, {29,-22}, {29,-17}, {29,-16}, {29,-15}, {29,-14}, {29,-13}, {29,-12}, {29,-11}, {29,-10}, {29,-9}, {29,-8}, {29,54}, {29,55}, {29,56}, {29,57}, {29,58}, {29,59}, {29,60}, {29,61}, {29,62}, {29,63}, {29,64}, {29,65}, {29,66}, {29,72}, {29,73}, {29,74}, {29,75}, {29,76}, {29,77}, {29,82}, {29,83}, {29,84}, {29,85}, {29,86}, {29,87}, {29,88}, {29,89}, {29,90}, {29,91}, {29,92}, {29,93}, {29,94}, {29,95}, {29,96}, {29,97}, {29,98}, {29,99}, {29,100}, {29,101}, {29,102}, {29,103}, {29,104}, {29,105}, {29,106}, {29,107}, {29,108}, {29,109}, {29,110}, {29,111}, {29,112}, {29,113}, {29,114}, {29,115}, {29,116}, {29,117}, {29,118}, {29,119}, {29,120}, {29,121}, {29,122}, {29,123}, {29,124}, {29,125}, {29,126}, {29,127}, {29,128}, {29,129}, {29,130}, {29,131}, {29,132}, {29,133}, {29,134}, {29,135}, {29,136}, {29,137}, {29,138}, {29,139}, {29,140}, {29,145}, {29,146}, {29,147}, {29,149}, {29,150}, {29,151}, {29,152}, {30,-105}, {30,-104}, {30,-103}, {30,-99}, {30,-98}, {30,-93}, {30,-92}, {30,-91}, {30,-85}, {30,-84}, {30,-73}, {30,-72}, {30,-69}, {30,-38}, {30,-34}, {30,-33}, {30,-32}, {30,-31}, {30,-23}, {30,-22}, {30,-21}, {30,-20}, {30,-19}, {30,-18}, {30,-17}, {30,-16}, {30,-15}, {30,-14}, {30,-13}, {30,-12}, {30,-11}, {30,-10}, {30,53}, {30,54}, {30,55}, {30,56}, {30,57}, {30,75}, {30,76}, {30,77}, {30,78}, {30,79}, {30,80}, {30,81}, {30,82}, {30,83}, {30,84}, {30,85}, {30,86}, {30,87}, {30,88}, {30,102}, {30,103}, {30,104}, {30,105}, {30,106}, {30,107}, {30,108}, {30,109}, {30,110}, {30,111}, {30,112}, {30,113}, {30,114}, {30,115}, {30,116}, {30,117}, {30,118}, {30,119}, {30,120}, {30,121}, {30,122}, {30,123}, {30,124}, {30,125}, {30,126}, {30,144}, {30,145}, {30,146}, {30,147}, {30,149}, {30,150}, {30,151}, {30,152}, {31,-105}, {31,-104}, {31,-103}, {31,-99}, {31,-98}, {31,-93}, {31,-92}, {31,-85}, {31,-84}, {31,-73}, {31,-72}, {31,-69}, {31,-68}, {31,-38}, {31,-37}, {31,-33}, {31,-32}, {31,-31}, {31,-30}, {31,-29}, {31,-28}, {31,-27}, {31,-24}, {31,-23}, {31,-22}, {31,-21}, {31,-20}, {31,-19}, {31,-18}, {31,-17}, {31,-16}, {31,-15}, {31,-14}, {31,-13}, {31,53}, {31,54}, {31,55}, {31,145}, {31,146}, {31,149}, {31,150}, {31,151}, {31,152}, {32,-105}, {32,-104}, {32,-103}, {32,-102}, {32,-99}, {32,-98}, {32,-93}, {32,-92}, {32,-85}, {32,-84}, {32,-73}, {32,-72}, {32,-69}, {32,-68}, {32,-38}, {32,-37}, {32,-33}, {32,-32}, {32,-31}, {32,-30}, {32,-29}, {32,-28}, {32,-27}, {32,-26}, {32,-25}, {32,-24}, {32,-23}, {32,-22}, {32,-21}, {32,-20}, {32,-19}, {32,-18}, {32,-17}, {32,-16}, {32,-15}, {32,52}, {32,53}, {32,60}, {32,61}, {32,62}, {32,63}, {32,64}, {32,65}, {32,66}, {32,67}, {32,68}, {32,69}, {32,70}, {32,71}, {32,72}, {32,73}, {32,91}, {32,92}, {32,93}, {32,94}, {32,95}, {32,96}, {32,97}, {32,98}, {32,99}, {32,129}, {32,130}, {32,131}, {32,132}, {32,133}, {32,134}, {32,135}, {32,150}, {32,151}, {32,152}, {33,-105}, {33,-104}, {33,-103}, {33,-102}, {33,-99}, {33,-98}, {33,-93}, {33,-92}, {33,-89}, {33,-88}, {33,-85}, {33,-84}, {33,-83}, {33,-74}, {33,-73}, {33,-72}, {33,-68}, {33,-39}, {33,-38}, {33,-37}, {33,-36}, {33,-33}, {33,-32}, {33,-31}, {33,-30}, {33,-29}, {33,-28}, {33,-27}, {33,-26}, {33,-25}, {33,-24}, {33,-23}, {33,-22}, {33,-21}, {33,-20}, {33,-17}, {33,-10}, {33,-9}, {33,52}, {33,58}, {33,59}, {33,60}, {33,61}, {33,72}, {33,73}, {33,74}, {33,75}, {33,76}, {33,77}, {33,78}, {33,79}, {33,80}, {33,81}, {33,82}, {33,83}, {33,84}, {33,85}, {33,86}, {33,87}, {33,88}, {33,89}, {33,90}, {33,91}, {33,92}, {33,93}, {33,94}, {33,95}, {33,96}, {33,97}, {33,98}, {33,99}, {33,100}, {33,101}, {33,102}, {33,103}, {33,104}, {33,105}, {33,106}, {33,107}, {33,108}, {33,109}, {33,110}, {33,111}, {33,112}, {33,113}, {33,114}, {33,115}, {33,116}, {33,117}, {33,118}, {33,119}, {33,120}, {33,121}, {33,122}, {33,123}, {33,124}, {33,125}, {33,126}, {33,127}, {33,128}, {33,129}, {33,130}, {33,131}, {33,132}, {33,133}, {33,134}, {33,135}, {33,136}, {33,137}, {33,138}, {33,139}, {33,140}, {33,141}, {33,142}, {33,143}, {33,150}, {33,151}, {33,152}, {34,-105}, {34,-104}, {34,-103}, {34,-102}, {34,-99}, {34,-98}, {34,-97}, {34,-96}, {34,-95}, {34,-94}, {34,-93}, {34,-89}, {34,-88}, {34,-84}, {34,-83}, {34,-74}, {34,-73}, {34,-72}, {34,-71}, {34,-68}, {34,-40}, {34,-39}, {34,-38}, {34,-37}, {34,-36}, {34,-33}, {34,-32}, {34,-31}, {34,-30}, {34,-29}, {34,-28}, {34,-27}, {34,-26}, {34,-25}, {34,-24}, {34,-23}, {34,-22}, {34,-11}, {34,-10}, {34,-9}, {34,-8}, {34,52}, {34,56}, {34,150}, {34,151}, {34,152}, {35,-104}, {35,-103}, {35,-102}, {35,-98}, {35,-97}, {35,-96}, {35,-95}, {35,-94}, {35,-93}, {35,-89}, {35,-88}, {35,-84}, {35,-83}, {35,-74}, {35,-73}, {35,-72}, {35,-68}, {35,-40}, {35,-39}, {35,-38}, {35,-37}, {35,-36}, {35,-32}, {35,-31}, {35,-30}, {35,-29}, {35,-28}, {35,-27}, {35,-26}, {35,-13}, {35,-12}, {35,-11}, {35,-10}, {35,-9}, {35,-8}, {35,52}, {35,55}, {35,56}, {35,145}, {35,149}, {35,150}, {35,151}, {35,152}, {36,-104}, {36,-103}, {36,-102}, {36,-98}, {36,-97}, {36,-96}, {36,-95}, {36,-94}, {36,-90}, {36,-89}, {36,-88}, {36,-87}, {36,-84}, {36,-83}, {36,-74}, {36,-73}, {36,-72}, {36,-13}, {36,-12}, {36,-11}, {36,-10}, {36,-9}, {36,-8}, {36,52}, {36,55}, {36,56}, {36,145}, {36,149}, {36,150}, {36,151}, {36,152}, {37,-104}, {37,-103}, {37,-102}, {37,-101}, {37,-98}, {37,-97}, {37,-96}, {37,-95}, {37,-94}, {37,-90}, {37,-89}, {37,-88}, {37,-87}, {37,-84}, {37,-83}, {37,-74}, {37,-73}, {37,-72}, {37,-71}, {37,-16}, {37,-15}, {37,-14}, {37,-13}, {37,-12}, {37,-11}, {37,-10}, {37,-9}, {37,-8}, {37,52}, {37,55}, {37,56}, {37,145}, {37,146}, {37,149}, {37,150}, {37,151}, {37,152}, {38,-104}, {38,-103}, {38,-102}, {38,-101}, {38,-98}, {38,-97}, {38,-96}, {38,-95}, {38,-94}, {38,-91}, {38,-90}, {38,-89}, {38,-88}, {38,-87}, {38,-84}, {38,-83}, {38,-82}, {38,-74}, {38,-73}, {38,-72}, {38,-71}, {38,-18}, {38,-17}, {38,-16}, {38,-15}, {38,-14}, {38,-13}, {38,-12}, {38,-11}, {38,-10}, {38,-9}, {38,52}, {38,55}, {38,56}, {38,145}, {38,146}, {38,149}, {38,150}, {38,151}, {38,152}, {39,-104}, {39,-103}, {39,-102}, {39,-101}, {39,-98}, {39,-97}, {39,-96}, {39,-95}, {39,-91}, {39,-87}, {39,-83}, {39,-82}, {39,-75}, {39,-74}, {39,-73}, {39,-72}, {39,-17}, {39,-16}, {39,-15}, {39,-14}, {39,-13}, {39,-12}, {39,-11}, {39,-9}, {39,-8}, {39,52}, {39,55}, {39,56}, {39,145}, {39,146}, {39,149}, {39,150}, {39,151}, {39,152}, {40,-104}, {40,-103}, {40,-102}, {40,-101}, {40,-97}, {40,-96}, {40,-95}, {40,-91}, {40,-87}, {40,-86}, {40,-83}, {40,-82}, {40,-75}, {40,-74}, {40,-73}, {40,-72}, {40,-69}, {40,-68}, {40,-39}, {40,-38}, {40,-37}, {40,-36}, {40,-35}, {40,-34}, {40,-31}, {40,-30}, {40,-17}, {40,-16}, {40,-15}, {40,-14}, {40,-13}, {40,-12}, {40,-11}, {40,-10}, {40,-9}, {40,-8}, {40,52}, {40,55}, {40,56}, {40,145}, {40,146}, {40,149}, {40,150}, {40,151}, {40,152}, {41,-103}, {41,-102}, {41,-101}, {41,-97}, {41,-96}, {41,-95}, {41,-92}, {41,-91}, {41,-90}, {41,-89}, {41,-88}, {41,-87}, {41,-86}, {41,-83}, {41,-82}, {41,-81}, {41,-75}, {41,-74}, {41,-73}, {41,-72}, {41,-69}, {41,-68}, {41,-39}, {41,-38}, {41,-37}, {41,-36}, {41,-35}, {41,-34}, {41,-31}, {41,-27}, {41,-26}, {41,-15}, {41,-14}, {41,-13}, {41,-12}, {41,-11}, {41,-10}, {41,-9}, {41,-8}, {41,52}, {41,55}, {41,56}, {41,145}, {41,146}, {41,149}, {41,150}, {41,151}, {41,152}, {42,-103}, {42,-102}, {42,-101}, {42,-100}, {42,-97}, {42,-96}, {42,-95}, {42,-92}, {42,-91}, {42,-90}, {42,-89}, {42,-88}, {42,-87}, {42,-86}, {42,-83}, {42,-82}, {42,-81}, {42,-75}, {42,-74}, {42,-73}, {42,-72}, {42,-69}, {42,-68}, {42,-38}, {42,-37}, {42,-36}, {42,-35}, {42,-34}, {42,-27}, {42,-22}, {42,-21}, {42,-20}, {42,-12}, {42,-11}, {42,-10}, {42,-9}, {42,52}, {42,55}, {42,56}, {42,145}, {42,146}, {42,149}, {42,150}, {42,151}, {42,152}, {43,-103}, {43,-102}, {43,-101}, {43,-100}, {43,-97}, {43,-96}, {43,-95}, {43,-92}, {43,-91}, {43,-89}, {43,-88}, {43,-87}, {43,-86}, {43,-82}, {43,-81}, {43,-74}, {43,-73}, {43,-72}, {43,-69}, {43,-68}, {43,-37}, {43,-36}, {43,-35}, {43,-34}, {43,-24}, {43,-23}, {43,-22}, {43,-21}, {43,-20}, {43,-9}, {43,52}, {43,55}, {43,56}, {43,145}, {43,146}, {43,149}, {43,150}, {43,151}, {43,152}, {44,-103}, {44,-102}, {44,-101}, {44,-100}, {44,-97}, {44,-96}, {44,-92}, {44,-91}, {44,-90}, {44,-82}, {44,-81}, {44,-74}, {44,-73}, {44,-72}, {44,-69}, {44,-68}, {44,-37}, {44,-36}, {44,-35}, {44,-34}, {44,-29}, {44,-25}, {44,-24}, {44,-23}, {44,-22}, {44,-21}, {44,-20}, {44,-19}, {44,-18}, {44,-17}, {44,52}, {44,55}, {44,56}, {44,145}, {44,146}, {44,149}, {44,150}, {44,151}, {44,152}, {45,-103}, {45,-100}, {45,-96}, {45,-92}, {45,-91}, {45,-82}, {45,-81}, {45,-74}, {45,-73}, {45,-72}, {45,-69}, {45,-37}, {45,-36}, {45,-35}, {45,-30}, {45,-26}, {45,-25}, {45,-24}, {45,-23}, {45,-22}, {45,-21}, {45,-20}, {45,-19}, {45,-18}, {45,-17}, {45,-16}, {45,-15}, {45,52}, {45,55}, {45,56}, {45,145}, {45,146}, {45,149}, {45,150}, {45,151}, {45,152}, {46,-103}, {46,-100}, {46,-81}, {46,-80}, {46,-74}, {46,-73}, {46,-72}, {46,-69}, {46,-37}, {46,-36}, {46,-35}, {46,-34}, {46,-27}, {46,-26}, {46,-25}, {46,-24}, {46,-23}, {46,-22}, {46,-21}, {46,-20}, {46,-19}, {46,-18}, {46,-17}, {46,-16}, {46,-15}, {46,52}, {46,55}, {46,56}, {46,145}, {46,146}, {46,149}, {46,150}, {46,151}, {46,152}, {47,-99}, {47,-89}, {47,-88}, {47,-87}, {47,-86}, {47,-81}, {47,-80}, {47,-74}, {47,-73}, {47,-72}, {47,-69}, {47,-37}, {47,-36}, {47,-35}, {47,-34}, {47,-27}, {47,-26}, {47,-25}, {47,-24}, {47,-23}, {47,-22}, {47,-21}, {47,-20}, {47,-19}, {47,-9}, {47,-8}, {47,52}, {47,55}, {47,56}, {47,145}, {47,146}, {47,150}, {47,151}, {47,152}, {48,-99}, {48,-90}, {48,-89}, {48,-88}, {48,-87}, {48,-86}, {48,-85}, {48,-81}, {48,-80}, {48,-74}, {48,-73}, {48,-72}, {48,-69}, {48,-37}, {48,-36}, {48,-35}, {48,-29}, {48,-28}, {48,-27}, {48,-26}, {48,-25}, {48,-24}, {48,-23}, {48,-22}, {48,-21}, {48,-13}, {48,-12}, {48,-11}, {48,-10}, {48,-9}, {48,-8}, {48,52}, {48,55}, {48,56}, {48,145}, {48,146}, {48,150}, {48,151}, {48,152}, {49,-99}, {49,-98}, {49,-92}, {49,-91}, {49,-85}, {49,-84}, {49,-80}, {49,-74}, {49,-73}, {49,-72}, {49,-69}, {49,-38}, {49,-37}, {49,-36}, {49,-35}, {49,-30}, {49,-29}, {49,-28}, {49,-27}, {49,-26}, {49,-25}, {49,-24}, {49,-17}, {49,-16}, {49,-15}, {49,-14}, {49,-13}, {49,-12}, {49,-11}, {49,-10}, {49,-9}, {49,-8}, {49,52}, {49,55}, {49,56}, {49,145}, {49,146}, {49,150}, {49,151}, {49,152}, {50,-99}, {50,-98}, {50,-94}, {50,-93}, {50,-84}, {50,-80}, {50,-79}, {50,-73}, {50,-72}, {50,-69}, {50,-38}, {50,-37}, {50,-36}, {50,-29}, {50,-28}, {50,-27}, {50,-26}, {50,-19}, {50,-18}, {50,-17}, {50,-16}, {50,-15}, {50,-14}, {50,-13}, {50,-12}, {50,-11}, {50,-10}, {50,-9}, {50,52}, {50,55}, {50,56}, {50,145}, {50,146}, {50,150}, {50,151}, {50,152}, {51,-98}, {51,-94}, {51,-84}, {51,-83}, {51,-80}, {51,-79}, {51,-73}, {51,-72}, {51,-69}, {51,-39}, {51,-38}, {51,-37}, {51,-36}, {51,-29}, {51,-22}, {51,-21}, {51,-20}, {51,-19}, {51,-18}, {51,-17}, {51,-16}, {51,-15}, {51,-14}, {51,-13}, {51,-12}, {51,-11}, {51,52}, {51,55}, {51,56}, {51,145}, {51,146}, {51,150}, {51,151}, {51,152}, {52,-102}, {52,-94}, {52,-83}, {52,-79}, {52,-73}, {52,-72}, {52,-69}, {52,-39}, {52,-38}, {52,-32}, {52,-24}, {52,-23}, {52,-22}, {52,-21}, {52,-20}, {52,-19}, {52,-18}, {52,-17}, {52,-16}, {52,-15}, {52,-14}, {52,-13}, {52,-12}, {52,52}, {52,55}, {52,56}, {52,145}, {52,146}, {52,150}, {52,151}, {52,152}, {53,-83}, {53,-79}, {53,-78}, {53,-73}, {53,-72}, {53,-69}, {53,-68}, {53,-40}, {53,-34}, {53,-33}, {53,-32}, {53,-27}, {53,-26}, {53,-25}, {53,-24}, {53,-23}, {53,-22}, {53,-21}, {53,-20}, {53,-19}, {53,-18}, {53,-17}, {53,-16}, {53,-15}, {53,-14}, {53,-13}, {53,52}, {53,55}, {53,56}, {53,145}, {53,146}, {53,150}, {53,151}, {53,152}, {54,-83}, {54,-79}, {54,-78}, {54,-73}, {54,-72}, {54,-67}, {54,-42}, {54,-41}, {54,-40}, {54,-35}, {54,-34}, {54,-28}, {54,-27}, {54,-26}, {54,-25}, {54,-24}, {54,-23}, {54,-22}, {54,-21}, {54,-20}, {54,-19}, {54,-18}, {54,-17}, {54,-16}, {54,-15}, {54,-14}, {54,52}, {54,56}, {54,145}, {54,146}, {54,150}, {54,151}, {54,152}, {55,-82}, {55,-79}, {55,-78}, {55,-73}, {55,-72}, {55,-71}, {55,-65}, {55,-64}, {55,-63}, {55,-62}, {55,-61}, {55,-60}, {55,-59}, {55,-58}, {55,-57}, {55,-56}, {55,-55}, {55,-54}, {55,-53}, {55,-52}, {55,-51}, {55,-50}, {55,-49}, {55,-48}, {55,-47}, {55,-46}, {55,-45}, {55,-44}, {55,-43}, {55,-28}, {55,-27}, {55,-26}, {55,-25}, {55,-24}, {55,-23}, {55,-22}, {55,-21}, {55,-20}, {55,-19}, {55,-18}, {55,-17}, {55,-16}, {55,52}, {55,56}, {55,145}, {55,146}, {55,150}, {55,151}, {55,152}, {56,-82}, {56,-79}, {56,-78}, {56,-73}, {56,-72}, {56,-71}, {56,-28}, {56,-27}, {56,-26}, {56,-25}, {56,-24}, {56,-23}, {56,-22}, {56,-21}, {56,-20}, {56,52}, {56,53}, {56,56}, {56,145}, {56,146}, {56,150}, {56,151}, {56,152}, {57,-82}, {57,-78}, {57,-73}, {57,-72}, {57,-71}, {57,-28}, {57,-27}, {57,-26}, {57,-25}, {57,-24}, {57,-23}, {57,-22}, {57,-21}, {57,-17}, {57,-16}, {57,-15}, {57,-14}, {57,-13}, {57,-12}, {57,-11}, {57,-8}, {57,52}, {57,53}, {57,56}, {57,145}, {57,146}, {57,149}, {57,150}, {57,151}, {57,152}, {58,-81}, {58,-78}, {58,-77}, {58,-72}, {58,-71}, {58,-66}, {58,-65}, {58,-64}, {58,-63}, {58,-62}, {58,-54}, {58,-53}, {58,-52}, {58,-51}, {58,-50}, {58,-49}, {58,-48}, {58,-47}, {58,-46}, {58,-45}, {58,-44}, {58,-43}, {58,-42}, {58,-41}, {58,-40}, {58,-39}, {58,-17}, {58,-16}, {58,-15}, {58,-14}, {58,-13}, {58,-12}, {58,-11}, {58,-8}, {58,52}, {58,53}, {58,56}, {58,145}, {58,146}, {58,149}, {58,150}, {58,151}, {58,152}, {59,-81}, {59,-77}, {59,-72}, {59,-71}, {59,-68}, {59,-67}, {59,52}, {59,56}, {59,145}, {59,146}, {59,150}, {59,151}, {59,152}, {60,-81}, {60,-77}, {60,-72}, {60,-71}, {60,-68}, {60,-67}, {60,52}, {60,56}, {60,145}, {60,146}, {60,147}, {60,150}, {60,151}, {60,152}, {61,-77}, {61,-72}, {61,-71}, {61,-70}, {61,-68}, {61,-67}, {61,52}, {61,55}, {61,56}, {61,145}, {61,146}, {61,147}, {61,150}, {61,151}, {61,152}, {62,-80}, {62,-76}, {62,-72}, {62,-71}, {62,-70}, {62,-68}, {62,-67}, {62,52}, {62,55}, {62,145}, {62,146}, {62,147}, {62,150}, {62,151}, {62,152}, {63,-80}, {63,-76}, {63,-72}, {63,-71}, {63,-70}, {63,-68}, {63,-67}, {63,52}, {63,55}, {63,147}, {63,150}, {63,151}, {63,152}, {64,-80}, {64,-79}, {64,-76}, {64,-72}, {64,-71}, {64,-68}, {64,-67}, {64,52}, {64,55}, {64,150}, {64,151}, {64,152}, {65,-79}, {65,-76}, {65,-72}, {65,-71}, {65,-68}, {65,-67}, {65,52}, {65,55}, {65,150}, {65,151}, {65,152}, {66,-76}, {66,-75}, {66,-72}, {66,-71}, {66,-68}, {66,-67}, {66,52}, {66,55}, {66,147}, {66,150}, {66,151}, {66,152}, {67,-75}, {67,-72}, {67,-71}, {67,-68}, {67,-67}, {67,52}, {67,55}, {67,147}, {67,150}, {67,151}, {67,152}, {68,-74}, {68,-73}, {68,-72}, {68,-71}, {68,-68}, {68,-67}, {68,52}, {68,55}, {68,147}, {68,150}, {68,151}, {68,152}, {69,-78}, {69,-73}, {69,-72}, {69,52}, {69,55}, {69,56}, {69,147}, {69,150}, {69,151}, {69,152}, {70,-78}, {70,-77}, {70,52}, {70,56}, {70,146}, {70,147}, {70,150}, {70,151}, {70,152}, {71,-76}, {71,52}, {71,53}, {71,56}, {71,146}, {71,147}, {71,150}, {71,151}, {71,152}, {72,-72}, {72,-71}, {72,-70}, {72,-69}, {72,-68}, {72,-67}, {72,53}, {72,56}, {72,146}, {72,147}, {72,150}, {72,151}, {72,152}, {73,-71}, {73,-70}, {73,-69}, {73,53}, {73,56}, {73,147}, {73,150}, {73,151}, {73,152}, {74,-74}, {74,-71}, {74,-70}, {74,-69}, {74,53}, {74,56}, {74,147}, {74,150}, {74,151}, {74,152}, {75,-79}, {75,-74}, {75,-70}, {75,-69}, {75,-68}, {75,52}, {75,53}, {75,56}, {75,147}, {75,150}, {75,151}, {75,152}, {76,-106}, {76,-74}, {76,-70}, {76,-69}, {76,-68}, {76,-67}, {76,52}, {76,53}, {76,56}, {76,147}, {76,150}, {76,151}, {76,152}, {77,-74}, {77,-73}, {77,-68}, {77,-67}, {77,-66}, {77,-39}, {77,52}, {77,53}, {77,147}, {77,150}, {77,151}, {77,152}, {78,-73}, {78,-72}, {78,-67}, {78,-66}, {78,-39}, {78,-38}, {78,52}, {78,53}, {78,146}, {78,147}, {78,150}, {78,151}, {78,152}, {79,-72}, {79,-38}, {79,52}, {79,53}, {79,146}, {79,147}, {79,150}, {79,151}, {79,152}, {80,-71}, {80,-38}, {80,-37}, {80,52}, {80,56}, {80,146}, {80,147}, {80,150}, {80,151}, {80,152}, {81,-71}, {81,-70}, {81,-69}, {81,52}, {81,56}, {81,147}, {81,150}, {81,151}, {81,152}, {82,-70}, {82,-69}, {82,52}, {82,55}, {82,56}, {82,147}, {82,150}, {82,151}, {82,152}, {83,-69}, {83,-68}, {83,-67}, {83,52}, {83,55}, {83,56}, {83,146}, {83,147}, {83,150}, {83,151}, {83,152}, {84,-67}, {84,-28}, {84,-27}, {84,-26}, {84,-25}, {84,-24}, {84,-23}, {84,-22}, {84,-21}, {84,-20}, {84,-19}, {84,-18}, {84,-17}, {84,-10}, {84,-9}, {84,-8}, {84,-7}, {84,-6}, {84,-5}, {84,-4}, {84,-3}, {84,-2}, {84,-1}, {84,0}, {84,1}, {84,2}, {84,3}, {84,8}, {84,9}, {84,10}, {84,11}, {84,12}, {84,13}, {84,14}, {84,15}, {84,16}, {84,17}, {84,18}, {84,19}, {84,20}, {84,21}, {84,22}, {84,23}, {84,24}, {84,25}, {84,26}, {84,27}, {84,28}, {84,29}, {84,30}, {84,31}, {84,32}, {84,33}, {84,34}, {84,35}, {84,36}, {84,37}, {84,38}, {84,39}, {84,40}, {84,41}, {84,42}, {84,43}, {84,44}, {84,45}, {84,46}, {84,47}, {84,48}, {84,49}, {84,50}, {84,51}, {84,52}, {84,55}, {84,56}, {84,145}, {84,146}, {84,147}, {84,150}, {84,151}, {84,152}, {85,-31}, {85,-26}, {85,-25}, {85,-24}, {85,-23}, {85,-22}, {85,-21}, {85,-20}, {85,-19}, {85,-9}, {85,-8}, {85,-7}, {85,-6}, {85,-5}, {85,-4}, {85,-3}, {85,-2}, {85,-1}, {85,30}, {85,31}, {85,32}, {85,33}, {85,34}, {85,35}, {85,36}, {85,37}, {85,38}, {85,39}, {85,40}, {85,41}, {85,56}, {85,145}, {85,146}, {85,147}, {85,150}, {85,151}, {85,152}, {86,-35}, {86,-31}, {86,-30}, {86,-13}, {86,56}, {86,145}, {86,146}, {86,147}, {86,150}, {86,151}, {86,152}, {87,-31}, {87,-30}, {87,-29}, {87,-28}, {87,-15}, {87,-14}, {87,-13}, {87,-12}, {87,2}, {87,3}, {87,4}, {87,5}, {87,6}, {87,7}, {87,8}, {87,9}, {87,10}, {87,11}, {87,12}, {87,13}, {87,14}, {87,15}, {87,16}, {87,17}, {87,18}, {87,19}, {87,20}, {87,21}, {87,22}, {87,23}, {87,24}, {87,25}, {87,26}, {87,27}, {87,44}, {87,45}, {87,46}, {87,47}, {87,48}, {87,49}, {87,50}, {87,51}, {87,52}, {87,57}, {87,58}, {87,59}, {87,60}, {87,61}, {87,62}, {87,63}, {87,64}, {87,65}, {87,66}, {87,67}, {87,68}, {87,69}, {87,70}, {87,71}, {87,72}, {87,73}, {87,74}, {87,75}, {87,76}, {87,77}, {87,78}, {87,79}, {87,80}, {87,81}, {87,82}, {87,83}, {87,84}, {87,85}, {87,86}, {87,87}, {87,88}, {87,89}, {87,90}, {87,91}, {87,92}, {87,97}, {87,98}, {87,99}, {87,100}, {87,101}, {87,102}, {87,103}, {87,104}, {87,105}, {87,106}, {87,107}, {87,108}, {87,109}, {87,110}, {87,111}, {87,112}, {87,113}, {87,114}, {87,115}, {87,116}, {87,117}, {87,118}, {87,119}, {87,120}, {87,121}, {87,122}, {87,123}, {87,124}, {87,125}, {87,126}, {87,127}, {87,128}, {87,129}, {87,130}, {87,131}, {87,132}, {87,133}, {87,134}, {87,135}, {87,136}, {87,137}, {87,138}, {87,139}, {87,140}, {87,141}, {87,142}, {87,143}, {87,144}, {87,145}, {87,146}, {87,150}, {87,151}, {87,152}, {88,-31}, {88,-30}, {88,-29}, {88,-28}, {88,-27}, {88,-26}, {88,-25}, {88,-24}, {88,-23}, {88,-22}, {88,-21}, {88,-20}, {88,-19}, {88,-18}, {88,-17}, {88,-16}, {88,-15}, {88,-14}, {88,-13}, {88,-12}, {88,-11}, {88,-10}, {88,-9}, {88,-8}, {88,-7}, {88,-6}, {88,-5}, {88,-4}, {88,-3}, {88,-2}, {88,-1}, {88,0}, {88,1}, {88,2}, {88,3}, {88,4}, {88,5}, {88,6}, {88,7}, {88,8}, {88,9}, {88,10}, {88,11}, {88,12}, {88,13}, {88,14}, {88,15}, {88,16}, {88,17}, {88,18}, {88,19}, {88,20}, {88,21}, {88,22}, {88,23}, {88,24}, {88,25}, {88,26}, {88,27}, {88,28}, {88,29}, {88,30}, {88,31}, {88,32}, {88,33}, {88,34}, {88,35}, {88,36}, {88,37}, {88,38}, {88,39}, {88,40}, {88,41}, {88,42}, {88,43}, {88,44}, {88,45}, {88,46}, {88,47}, {88,48}, {88,49}, {88,50}, {88,51}, {88,52}, {88,53}, {88,59}, {88,60}, {88,61}, {88,62}, {88,67}, {88,68}, {88,69}, {88,70}, {88,71}, {88,72}, {88,73}, {88,74}, {88,80}, {88,81}, {88,82}, {88,83}, {88,84}, {88,85}, {88,86}, {88,87}, {88,88}, {88,89}, {88,90}, {88,100}, {88,101}, {88,102}, {88,103}, {88,104}, {88,105}, {88,106}, {88,107}, {88,108}, {88,109}, {88,110}, {88,111}, {88,112}, {88,127}, {88,128}, {88,129}, {88,130}, {88,131}, {88,132}, {88,133}, {88,134}, {88,135}, {88,136}, {88,137}, {88,138}, {88,139}, {88,140}, {88,141}, {88,142}, {88,150}, {88,151}, {88,152}, {89,51}, {89,52}, {89,53}, {89,54}, {89,152}, {90,54}, {90,55}, {90,56}, {90,64}, {90,77}, {90,95}, {90,114}, {90,115}, {90,116}, {90,117}, {90,118}, {90,119}, {90,120}, {90,121}, {90,122}, {90,123}, {90,124}, {90,146}, {90,147}, {90,152}, {91,54}, {91,55}, {91,56}, {91,57}, {91,58}, {91,59}, {91,60}, {91,61}, {91,62}, {91,63}, {91,64}, {91,65}, {91,66}, {91,67}, {91,68}, {91,69}, {91,70}, {91,71}, {91,72}, {91,73}, {91,74}, {91,75}, {91,76}, {91,77}, {91,78}, {91,79}, {91,80}, {91,81}, {91,82}, {91,83}, {91,84}, {91,85}, {91,86}, {91,87}, {91,88}, {91,89}, {91,90}, {91,91}, {91,92}, {91,93}, {91,94}, {91,95}, {91,96}, {91,97}, {91,98}, {91,99}, {91,100}, {91,101}, {91,102}, {91,103}, {91,104}, {91,105}, {91,106}, {91,107}, {91,108}, {91,109}, {91,110}, {91,111}, {91,112}, {91,113}, {91,114}, {91,115}, {91,116}, {91,117}, {91,118}, {91,119}, {91,120}, {91,121}, {91,122}, {91,123}, {91,124}, {91,125}, {91,126}, {91,127}, {91,128}, {91,129}, {91,130}, {91,131}, {91,132}, {91,133}, {91,134}, {91,135}, {91,136}, {91,137}, {91,138}, {91,139}, {91,140}, {91,141}, {91,142}, {91,143}, {91,144}, {91,145}, {91,146}, {91,147}, {91,152}, {92,54}, {92,55}, {92,56}, {92,57}, {92,58}, {92,59}, {92,60}, {92,61}, {92,62}, {92,63}, {92,64}, {92,65}, {92,66}, {92,67}, {92,68}, {92,69}, {92,70}, {92,71}, {92,72}, {92,73}, {92,74}, {92,75}, {92,76}, {92,77}, {92,78}, {92,79}, {92,80}, {92,81}, {92,82}, {92,83}, {92,84}, {92,85}, {92,86}, {92,87}, {92,88}, {92,89}, {92,90}, {92,91}, {92,92}, {92,93}, {92,94}, {92,95}, {92,96}, {92,97}, {92,98}, {92,99}, {92,100}, {92,101}, {92,102}, {92,103}, {92,104}, {92,105}, {92,106}, {92,107}, {92,108}, {92,109}, {92,110}, {92,111}, {92,112}, {92,113}, {92,114}, {92,115}, {92,116}, {92,117}, {92,118}, {92,119}, {92,120}, {92,121}, {92,122}, {92,123}, {92,124}, {92,125}, {92,126}, {92,127}, {92,128}, {92,129}, {92,130}, {92,131}, {92,132}, {92,133}, {92,134}, {92,135}, {92,136}, {92,137}, {92,138}, {92,139}, {92,140}, {92,141}, {92,142}, {92,143}, {92,144}, {92,145}, {92,146}, {92,147}, {92,148}, {92,149}, {92,150}, {92,151}, {92,152}, },
    ["mineral-beige-dirt-6"] = {{-96,33}, {-96,34}, {-96,35}, {-96,36}, {-95,-24}, {-95,-23}, {-95,-22}, {-95,-19}, {-95,-18}, {-95,-10}, {-95,-9}, {-95,9}, {-95,10}, {-95,11}, {-95,12}, {-95,13}, {-95,14}, {-95,15}, {-95,16}, {-95,17}, {-95,21}, {-95,22}, {-95,23}, {-95,24}, {-95,25}, {-95,26}, {-95,27}, {-95,28}, {-95,29}, {-95,30}, {-95,31}, {-95,32}, {-95,33}, {-95,34}, {-95,35}, {-95,36}, {-95,37}, {-95,38}, {-94,-28}, {-94,-27}, {-94,-26}, {-94,-25}, {-94,-24}, {-94,-23}, {-94,-22}, {-94,-21}, {-94,-20}, {-94,-19}, {-94,-18}, {-94,-17}, {-94,-16}, {-94,-15}, {-94,-14}, {-94,-13}, {-94,-12}, {-94,-11}, {-94,-10}, {-94,-9}, {-94,-8}, {-94,-7}, {-94,-6}, {-94,6}, {-94,7}, {-94,8}, {-94,9}, {-94,10}, {-94,11}, {-94,12}, {-94,13}, {-94,14}, {-94,15}, {-94,16}, {-94,17}, {-94,18}, {-94,19}, {-94,20}, {-94,21}, {-94,22}, {-94,23}, {-94,24}, {-94,25}, {-94,26}, {-94,27}, {-94,28}, {-94,29}, {-94,30}, {-94,31}, {-94,32}, {-94,33}, {-94,34}, {-94,38}, {-94,39}, {-94,40}, {-94,41}, {-93,-27}, {-93,-26}, {-93,-25}, {-93,-24}, {-93,-12}, {-93,-11}, {-93,-10}, {-93,-9}, {-93,-8}, {-93,-7}, {-93,-6}, {-93,-5}, {-93,-4}, {-93,-3}, {-93,-2}, {-93,-1}, {-93,0}, {-93,1}, {-93,2}, {-93,3}, {-93,4}, {-93,5}, {-93,6}, {-93,7}, {-93,8}, {-93,9}, {-93,10}, {-93,11}, {-93,12}, {-93,13}, {-93,14}, {-93,15}, {-93,16}, {-93,17}, {-93,18}, {-93,19}, {-93,20}, {-93,21}, {-93,22}, {-93,40}, {-93,41}, {-93,42}, {-92,-29}, {-92,-28}, {-92,-13}, {-92,-12}, {-92,-11}, {-92,-7}, {-92,-6}, {-92,-5}, {-92,-4}, {-92,-3}, {-92,-2}, {-92,-1}, {-92,0}, {-92,1}, {-92,2}, {-92,3}, {-92,4}, {-92,5}, {-92,6}, {-92,8}, {-92,9}, {-92,10}, {-92,11}, {-92,12}, {-92,20}, {-92,21}, {-92,22}, {-92,23}, {-92,40}, {-92,41}, {-92,42}, {-92,43}, {-91,-29}, {-91,-28}, {-91,-14}, {-91,-13}, {-91,-12}, {-91,-11}, {-91,-1}, {-91,0}, {-91,1}, {-91,2}, {-91,3}, {-91,4}, {-91,5}, {-91,7}, {-91,8}, {-91,9}, {-91,10}, {-91,11}, {-91,21}, {-91,22}, {-91,23}, {-91,24}, {-91,40}, {-91,41}, {-91,42}, {-91,43}, {-91,50}, {-91,51}, {-91,52}, {-91,53}, {-91,54}, {-91,55}, {-91,56}, {-91,57}, {-91,58}, {-91,59}, {-91,60}, {-91,61}, {-91,95}, {-91,96}, {-91,97}, {-91,98}, {-91,99}, {-91,100}, {-91,101}, {-91,102}, {-91,103}, {-91,104}, {-90,-29}, {-90,-28}, {-90,-16}, {-90,-15}, {-90,-14}, {-90,-13}, {-90,-12}, {-90,2}, {-90,3}, {-90,4}, {-90,5}, {-90,6}, {-90,7}, {-90,8}, {-90,9}, {-90,22}, {-90,23}, {-90,24}, {-90,25}, {-90,26}, {-90,27}, {-90,28}, {-90,31}, {-90,32}, {-90,33}, {-90,34}, {-90,35}, {-90,40}, {-90,41}, {-90,42}, {-90,43}, {-90,44}, {-90,45}, {-90,46}, {-90,47}, {-90,48}, {-90,49}, {-90,50}, {-90,51}, {-90,52}, {-90,53}, {-90,54}, {-90,55}, {-90,56}, {-90,57}, {-90,58}, {-90,59}, {-90,60}, {-90,61}, {-90,62}, {-90,63}, {-90,87}, {-90,88}, {-90,89}, {-90,90}, {-90,91}, {-90,92}, {-90,93}, {-90,94}, {-90,95}, {-90,96}, {-90,97}, {-90,98}, {-90,99}, {-90,100}, {-90,101}, {-90,102}, {-90,103}, {-90,104}, {-90,105}, {-89,-28}, {-89,-27}, {-89,-26}, {-89,-25}, {-89,-24}, {-89,-23}, {-89,-22}, {-89,-21}, {-89,-20}, {-89,-19}, {-89,-18}, {-89,-17}, {-89,-16}, {-89,-15}, {-89,-14}, {-89,-13}, {-89,-12}, {-89,-11}, {-89,4}, {-89,5}, {-89,6}, {-89,7}, {-89,8}, {-89,23}, {-89,24}, {-89,25}, {-89,26}, {-89,27}, {-89,28}, {-89,29}, {-89,30}, {-89,31}, {-89,32}, {-89,33}, {-89,34}, {-89,35}, {-89,36}, {-89,37}, {-89,38}, {-89,39}, {-89,40}, {-89,41}, {-89,43}, {-89,44}, {-89,45}, {-89,46}, {-89,47}, {-89,48}, {-89,49}, {-89,60}, {-89,61}, {-89,62}, {-89,63}, {-89,64}, {-89,65}, {-89,66}, {-89,67}, {-89,78}, {-89,79}, {-89,80}, {-89,81}, {-89,82}, {-89,83}, {-89,84}, {-89,85}, {-89,86}, {-89,87}, {-89,88}, {-89,89}, {-89,90}, {-89,91}, {-89,92}, {-89,93}, {-89,94}, {-89,95}, {-89,96}, {-89,103}, {-89,104}, {-89,105}, {-89,106}, {-88,-104}, {-88,-103}, {-88,-102}, {-88,-101}, {-88,-29}, {-88,-28}, {-88,-27}, {-88,-26}, {-88,-25}, {-88,-24}, {-88,-23}, {-88,-22}, {-88,-21}, {-88,-20}, {-88,-19}, {-88,-18}, {-88,-17}, {-88,-16}, {-88,-15}, {-88,-14}, {-88,-13}, {-88,-12}, {-88,-11}, {-88,24}, {-88,25}, {-88,26}, {-88,27}, {-88,28}, {-88,29}, {-88,30}, {-88,31}, {-88,32}, {-88,35}, {-88,36}, {-88,37}, {-88,38}, {-88,39}, {-88,40}, {-88,41}, {-88,42}, {-88,43}, {-88,44}, {-88,45}, {-88,46}, {-88,47}, {-88,48}, {-88,49}, {-88,61}, {-88,64}, {-88,65}, {-88,66}, {-88,67}, {-88,68}, {-88,69}, {-88,70}, {-88,71}, {-88,72}, {-88,73}, {-88,74}, {-88,75}, {-88,76}, {-88,77}, {-88,78}, {-88,79}, {-88,80}, {-88,105}, {-88,106}, {-88,107}, {-88,108}, {-87,-106}, {-87,-105}, {-87,-104}, {-87,-103}, {-87,-102}, {-87,-101}, {-87,-100}, {-87,-31}, {-87,-30}, {-87,-29}, {-87,-28}, {-87,-27}, {-87,40}, {-87,41}, {-87,42}, {-87,43}, {-87,44}, {-87,45}, {-87,46}, {-87,47}, {-87,48}, {-87,49}, {-87,50}, {-87,61}, {-87,67}, {-87,68}, {-87,69}, {-87,70}, {-87,71}, {-87,72}, {-87,73}, {-87,74}, {-87,75}, {-87,76}, {-87,107}, {-87,108}, {-87,109}, {-87,110}, {-87,111}, {-87,112}, {-87,113}, {-86,-108}, {-86,-107}, {-86,-106}, {-86,-105}, {-86,-104}, {-86,-102}, {-86,-101}, {-86,-100}, {-86,-99}, {-86,-98}, {-86,-34}, {-86,-33}, {-86,-32}, {-86,-31}, {-86,-30}, {-86,-29}, {-86,-28}, {-86,39}, {-86,40}, {-86,41}, {-86,42}, {-86,47}, {-86,48}, {-86,49}, {-86,50}, {-86,60}, {-86,61}, {-86,67}, {-86,68}, {-86,108}, {-86,109}, {-86,110}, {-86,111}, {-86,112}, {-86,113}, {-86,114}, {-86,115}, {-85,-109}, {-85,-108}, {-85,-107}, {-85,-106}, {-85,-105}, {-85,-101}, {-85,-100}, {-85,-99}, {-85,-98}, {-85,-97}, {-85,-96}, {-85,-38}, {-85,-37}, {-85,-36}, {-85,-35}, {-85,-34}, {-85,-33}, {-85,-32}, {-85,-31}, {-85,-30}, {-85,-29}, {-85,-28}, {-85,39}, {-85,40}, {-85,41}, {-85,47}, {-85,48}, {-85,49}, {-85,50}, {-85,60}, {-85,61}, {-85,62}, {-85,66}, {-85,114}, {-85,115}, {-85,116}, {-84,-121}, {-84,-120}, {-84,-119}, {-84,-118}, {-84,-117}, {-84,-116}, {-84,-115}, {-84,-114}, {-84,-113}, {-84,-112}, {-84,-111}, {-84,-110}, {-84,-109}, {-84,-108}, {-84,-107}, {-84,-99}, {-84,-98}, {-84,-97}, {-84,-96}, {-84,-95}, {-84,-94}, {-84,-45}, {-84,-41}, {-84,-40}, {-84,-39}, {-84,-38}, {-84,-37}, {-84,-36}, {-84,-35}, {-84,-29}, {-84,-28}, {-84,39}, {-84,40}, {-84,48}, {-84,60}, {-84,61}, {-84,62}, {-84,63}, {-84,64}, {-84,65}, {-84,66}, {-84,115}, {-84,116}, {-83,-122}, {-83,-121}, {-83,-120}, {-83,-119}, {-83,-118}, {-83,-117}, {-83,-116}, {-83,-115}, {-83,-114}, {-83,-113}, {-83,-112}, {-83,-111}, {-83,-110}, {-83,-109}, {-83,-108}, {-83,-97}, {-83,-96}, {-83,-95}, {-83,-94}, {-83,-93}, {-83,-92}, {-83,-91}, {-83,-47}, {-83,-43}, {-83,-42}, {-83,-41}, {-83,-40}, {-83,-39}, {-83,-38}, {-83,-29}, {-83,-28}, {-83,39}, {-83,40}, {-83,61}, {-83,62}, {-83,63}, {-83,64}, {-83,65}, {-83,66}, {-83,115}, {-83,116}, {-82,-123}, {-82,-122}, {-82,-121}, {-82,-120}, {-82,-94}, {-82,-93}, {-82,-92}, {-82,-91}, {-82,-90}, {-82,-71}, {-82,-70}, {-82,-69}, {-82,-68}, {-82,-67}, {-82,-45}, {-82,-44}, {-82,-43}, {-82,-42}, {-82,-29}, {-82,-28}, {-82,39}, {-82,40}, {-82,63}, {-82,64}, {-82,65}, {-82,115}, {-82,116}, {-82,117}, {-81,-124}, {-81,-123}, {-81,-122}, {-81,-121}, {-81,-92}, {-81,-91}, {-81,-90}, {-81,-89}, {-81,-88}, {-81,-87}, {-81,-71}, {-81,-70}, {-81,-69}, {-81,-68}, {-81,-48}, {-81,-47}, {-81,-46}, {-81,-29}, {-81,-28}, {-81,39}, {-81,40}, {-81,64}, {-81,65}, {-81,66}, {-80,-124}, {-80,-123}, {-80,-122}, {-80,-90}, {-80,-89}, {-80,-88}, {-80,-87}, {-80,-86}, {-80,-85}, {-80,-84}, {-80,-71}, {-80,-70}, {-80,-69}, {-80,-68}, {-80,-53}, {-80,-50}, {-80,-49}, {-80,-48}, {-80,-29}, {-80,-28}, {-80,39}, {-80,40}, {-80,118}, {-79,-124}, {-79,-123}, {-79,-88}, {-79,-87}, {-79,-86}, {-79,-85}, {-79,-84}, {-79,-83}, {-79,-82}, {-79,-70}, {-79,-69}, {-79,-68}, {-79,-55}, {-79,-51}, {-79,-50}, {-79,-28}, {-79,118}, {-78,-124}, {-78,-123}, {-78,-85}, {-78,-84}, {-78,-83}, {-78,-82}, {-78,-70}, {-78,-69}, {-78,-68}, {-78,-54}, {-78,-53}, {-78,-52}, {-78,-28}, {-78,118}, {-78,119}, {-78,120}, {-78,121}, {-78,122}, {-78,123}, {-77,-124}, {-77,-123}, {-77,-83}, {-77,-82}, {-77,-70}, {-77,-69}, {-77,-55}, {-77,-54}, {-77,-28}, {-77,119}, {-77,120}, {-77,121}, {-77,122}, {-77,123}, {-77,124}, {-76,-124}, {-76,-123}, {-76,-83}, {-76,-82}, {-76,-70}, {-76,-69}, {-76,-55}, {-76,-28}, {-76,119}, {-76,125}, {-75,-124}, {-75,-123}, {-75,-83}, {-75,-82}, {-75,-70}, {-75,-69}, {-75,-56}, {-75,-55}, {-75,-28}, {-75,125}, {-74,-124}, {-74,-123}, {-74,-83}, {-74,-82}, {-74,-70}, {-74,-69}, {-74,-56}, {-74,-55}, {-74,-28}, {-74,-27}, {-74,125}, {-74,126}, {-73,-124}, {-73,-123}, {-73,-122}, {-73,-83}, {-73,-82}, {-73,-70}, {-73,-69}, {-73,-56}, {-73,-55}, {-73,-28}, {-73,-27}, {-73,125}, {-73,126}, {-73,127}, {-73,128}, {-73,129}, {-72,-124}, {-72,-123}, {-72,-122}, {-72,-83}, {-72,-82}, {-72,-70}, {-72,-69}, {-72,-56}, {-72,-55}, {-72,125}, {-72,126}, {-72,127}, {-72,128}, {-72,129}, {-72,130}, {-72,131}, {-72,132}, {-71,-123}, {-71,-122}, {-71,-83}, {-71,-82}, {-71,-56}, {-71,-55}, {-71,125}, {-71,126}, {-71,127}, {-71,128}, {-71,129}, {-71,130}, {-71,131}, {-71,132}, {-71,133}, {-71,134}, {-71,135}, {-71,136}, {-70,-123}, {-70,-122}, {-70,-84}, {-70,-83}, {-70,-82}, {-70,-56}, {-70,-55}, {-70,125}, {-70,126}, {-70,129}, {-70,130}, {-70,131}, {-70,132}, {-70,133}, {-70,134}, {-70,135}, {-70,136}, {-70,137}, {-70,138}, {-70,139}, {-69,-123}, {-69,-122}, {-69,-121}, {-69,-84}, {-69,-83}, {-69,-82}, {-69,-56}, {-69,-55}, {-69,125}, {-69,126}, {-69,127}, {-69,128}, {-69,130}, {-69,131}, {-69,136}, {-69,137}, {-69,138}, {-69,139}, {-69,140}, {-69,141}, {-68,-123}, {-68,-122}, {-68,-121}, {-68,-84}, {-68,-83}, {-68,-56}, {-68,-55}, {-68,125}, {-68,126}, {-68,127}, {-68,128}, {-68,129}, {-68,130}, {-68,131}, {-68,132}, {-68,135}, {-68,136}, {-68,140}, {-68,141}, {-68,142}, {-68,143}, {-67,-122}, {-67,-121}, {-67,-84}, {-67,-83}, {-67,-56}, {-67,-55}, {-67,127}, {-67,128}, {-67,129}, {-67,130}, {-67,131}, {-67,132}, {-67,133}, {-67,134}, {-67,135}, {-67,141}, {-67,142}, {-67,143}, {-67,144}, {-67,145}, {-66,-122}, {-66,-121}, {-66,-84}, {-66,-83}, {-66,-56}, {-66,-55}, {-66,132}, {-66,133}, {-66,134}, {-66,135}, {-66,136}, {-66,142}, {-66,143}, {-66,144}, {-66,145}, {-66,146}, {-65,-122}, {-65,-121}, {-65,-84}, {-65,-83}, {-65,-56}, {-65,-55}, {-65,143}, {-65,144}, {-65,145}, {-65,146}, {-65,147}, {-64,-122}, {-64,-121}, {-64,-120}, {-64,-84}, {-64,-83}, {-64,-56}, {-64,-55}, {-64,144}, {-64,146}, {-64,147}, {-64,148}, {-63,-121}, {-63,-120}, {-63,-84}, {-63,-83}, {-63,-82}, {-63,-57}, {-63,-56}, {-63,-55}, {-63,144}, {-63,147}, {-63,148}, {-62,-121}, {-62,-120}, {-62,-84}, {-62,-83}, {-62,-82}, {-62,-59}, {-62,-58}, {-62,-57}, {-62,-56}, {-62,-55}, {-62,-54}, {-62,-53}, {-62,-52}, {-62,-51}, {-62,144}, {-62,145}, {-62,148}, {-62,149}, {-61,-121}, {-61,-120}, {-61,-83}, {-61,-82}, {-61,-59}, {-61,-58}, {-61,-57}, {-61,-56}, {-61,-55}, {-61,-54}, {-61,-53}, {-61,-52}, {-61,-51}, {-61,-50}, {-61,-49}, {-61,-48}, {-61,144}, {-61,148}, {-61,149}, {-60,-121}, {-60,-120}, {-60,-83}, {-60,-82}, {-60,-57}, {-60,-56}, {-60,-55}, {-60,-54}, {-60,-53}, {-60,-52}, {-60,-51}, {-60,-50}, {-60,-49}, {-60,-48}, {-60,-47}, {-60,-46}, {-60,144}, {-60,148}, {-60,149}, {-59,-121}, {-59,-120}, {-59,-83}, {-59,-82}, {-59,-57}, {-59,-56}, {-59,-55}, {-59,-53}, {-59,-52}, {-59,-51}, {-59,-50}, {-59,-49}, {-59,-48}, {-59,-47}, {-59,-46}, {-59,-45}, {-59,-44}, {-59,-43}, {-59,-42}, {-59,-41}, {-59,-40}, {-59,-28}, {-59,144}, {-59,148}, {-59,149}, {-58,-121}, {-58,-120}, {-58,-119}, {-58,-83}, {-58,-82}, {-58,-56}, {-58,-55}, {-58,-52}, {-58,-51}, {-58,-50}, {-58,-49}, {-58,-48}, {-58,-47}, {-58,-46}, {-58,-45}, {-58,-44}, {-58,-43}, {-58,-42}, {-58,-41}, {-58,-40}, {-58,-39}, {-58,-38}, {-58,-37}, {-58,-36}, {-58,-35}, {-58,-29}, {-58,-28}, {-58,144}, {-58,148}, {-58,149}, {-57,-120}, {-57,-119}, {-57,-83}, {-57,-82}, {-57,-56}, {-57,-55}, {-57,-51}, {-57,-50}, {-57,-49}, {-57,-48}, {-57,-47}, {-57,-46}, {-57,-45}, {-57,-44}, {-57,-43}, {-57,-42}, {-57,-41}, {-57,-40}, {-57,-39}, {-57,-38}, {-57,-37}, {-57,-36}, {-57,-35}, {-57,-34}, {-57,-33}, {-57,-32}, {-57,-31}, {-57,-30}, {-57,-29}, {-57,-28}, {-57,144}, {-57,148}, {-57,149}, {-56,-120}, {-56,-119}, {-56,-83}, {-56,-82}, {-56,-56}, {-56,-55}, {-56,-50}, {-56,-49}, {-56,-48}, {-56,-47}, {-56,-44}, {-56,-42}, {-56,-41}, {-56,-40}, {-56,-39}, {-56,-38}, {-56,-37}, {-56,-36}, {-56,-35}, {-56,-34}, {-56,-33}, {-56,-32}, {-56,-31}, {-56,-30}, {-56,-29}, {-56,-28}, {-56,144}, {-56,145}, {-56,148}, {-56,149}, {-55,-120}, {-55,-119}, {-55,-83}, {-55,-82}, {-55,-56}, {-55,-55}, {-55,-50}, {-55,-49}, {-55,-48}, {-55,-47}, {-55,-46}, {-55,-45}, {-55,-44}, {-55,-43}, {-55,-42}, {-55,-41}, {-55,-40}, {-55,-39}, {-55,-38}, {-55,-37}, {-55,-36}, {-55,-35}, {-55,-34}, {-55,-33}, {-55,-32}, {-55,-31}, {-55,-30}, {-55,-29}, {-55,-28}, {-55,144}, {-55,148}, {-55,149}, {-54,-120}, {-54,-119}, {-54,-83}, {-54,-82}, {-54,-57}, {-54,-56}, {-54,-55}, {-54,-49}, {-54,-48}, {-54,-47}, {-54,-46}, {-54,-45}, {-54,-44}, {-54,-43}, {-54,-42}, {-54,-41}, {-54,-40}, {-54,-39}, {-54,-38}, {-54,-37}, {-54,-36}, {-54,-35}, {-54,-34}, {-54,-33}, {-54,-32}, {-54,-31}, {-54,-30}, {-54,-29}, {-54,-28}, {-54,144}, {-54,148}, {-54,149}, {-53,-120}, {-53,-119}, {-53,-83}, {-53,-82}, {-53,-57}, {-53,-56}, {-53,-55}, {-53,-51}, {-53,-50}, {-53,-49}, {-53,-48}, {-53,-47}, {-53,-46}, {-53,-45}, {-53,-44}, {-53,-43}, {-53,-42}, {-53,-41}, {-53,-40}, {-53,-39}, {-53,-38}, {-53,-29}, {-53,-28}, {-53,144}, {-53,148}, {-53,149}, {-52,-120}, {-52,-119}, {-52,-83}, {-52,-82}, {-52,-57}, {-52,-56}, {-52,-53}, {-52,-52}, {-52,-51}, {-52,-50}, {-52,-49}, {-52,-48}, {-52,-47}, {-52,-46}, {-52,-45}, {-52,-44}, {-52,-43}, {-52,-41}, {-52,-40}, {-52,144}, {-52,148}, {-52,149}, {-51,-120}, {-51,-119}, {-51,-84}, {-51,-83}, {-51,-82}, {-51,-81}, {-51,-70}, {-51,-69}, {-51,-57}, {-51,-56}, {-51,-55}, {-51,-54}, {-51,-53}, {-51,-52}, {-51,-51}, {-51,-50}, {-51,-49}, {-51,-48}, {-51,-47}, {-51,-46}, {-51,-45}, {-51,-40}, {-51,144}, {-51,148}, {-51,149}, {-50,-120}, {-50,-119}, {-50,-84}, {-50,-83}, {-50,-82}, {-50,-81}, {-50,-80}, {-50,-70}, {-50,-69}, {-50,-67}, {-50,-66}, {-50,-65}, {-50,-64}, {-50,-63}, {-50,-62}, {-50,-61}, {-50,-60}, {-50,-59}, {-50,-58}, {-50,-57}, {-50,-56}, {-50,-55}, {-50,-54}, {-50,-53}, {-50,-49}, {-50,-48}, {-50,-47}, {-50,-46}, {-50,-45}, {-50,-44}, {-50,-40}, {-50,144}, {-50,148}, {-50,149}, {-49,-120}, {-49,-119}, {-49,-118}, {-49,-84}, {-49,-83}, {-49,-82}, {-49,-81}, {-49,-80}, {-49,-79}, {-49,-78}, {-49,-70}, {-49,-69}, {-49,-68}, {-49,-67}, {-49,-66}, {-49,-65}, {-49,-64}, {-49,-63}, {-49,-62}, {-49,-61}, {-49,-60}, {-49,-59}, {-49,-58}, {-49,-57}, {-49,-56}, {-49,-55}, {-49,-54}, {-49,-53}, {-49,-49}, {-49,-48}, {-49,-47}, {-49,-46}, {-49,-45}, {-49,-44}, {-49,-39}, {-49,144}, {-49,148}, {-49,149}, {-48,-119}, {-48,-118}, {-48,-83}, {-48,-82}, {-48,-81}, {-48,-80}, {-48,-79}, {-48,-78}, {-48,-77}, {-48,-76}, {-48,-75}, {-48,-74}, {-48,-73}, {-48,-72}, {-48,-71}, {-48,-70}, {-48,-69}, {-48,-68}, {-48,-67}, {-48,-58}, {-48,-57}, {-48,-56}, {-48,-55}, {-48,-54}, {-48,-53}, {-48,-49}, {-48,-48}, {-48,-47}, {-48,-46}, {-48,-45}, {-48,-44}, {-48,-39}, {-48,144}, {-48,148}, {-48,149}, {-47,-119}, {-47,-118}, {-47,-83}, {-47,-82}, {-47,-81}, {-47,-80}, {-47,-79}, {-47,-78}, {-47,-77}, {-47,-76}, {-47,-75}, {-47,-74}, {-47,-73}, {-47,-72}, {-47,-71}, {-47,-70}, {-47,-69}, {-47,-68}, {-47,-58}, {-47,-57}, {-47,-56}, {-47,-54}, {-47,-53}, {-47,-52}, {-47,-50}, {-47,-49}, {-47,-48}, {-47,-47}, {-47,-46}, {-47,-45}, {-47,-44}, {-47,-43}, {-47,-39}, {-47,144}, {-47,148}, {-47,149}, {-46,-119}, {-46,-118}, {-46,-84}, {-46,-83}, {-46,-82}, {-46,-81}, {-46,-80}, {-46,-79}, {-46,-78}, {-46,-77}, {-46,-76}, {-46,-75}, {-46,-74}, {-46,-73}, {-46,-72}, {-46,-71}, {-46,-70}, {-46,-69}, {-46,-68}, {-46,-57}, {-46,-56}, {-46,-53}, {-46,-52}, {-46,-51}, {-46,-50}, {-46,-49}, {-46,-48}, {-46,-47}, {-46,-45}, {-46,-44}, {-46,-43}, {-46,-38}, {-46,144}, {-46,148}, {-46,149}, {-45,-119}, {-45,-118}, {-45,-117}, {-45,-84}, {-45,-83}, {-45,-82}, {-45,-71}, {-45,-70}, {-45,-69}, {-45,-68}, {-45,-57}, {-45,-56}, {-45,-52}, {-45,-51}, {-45,-50}, {-45,-49}, {-45,-48}, {-45,-47}, {-45,-45}, {-45,-44}, {-45,-43}, {-45,-38}, {-45,144}, {-45,148}, {-45,149}, {-44,-119}, {-44,-118}, {-44,-117}, {-44,-84}, {-44,-83}, {-44,-70}, {-44,-69}, {-44,-68}, {-44,-57}, {-44,-56}, {-44,-52}, {-44,-51}, {-44,-50}, {-44,-49}, {-44,-48}, {-44,-44}, {-44,-43}, {-44,-42}, {-44,-38}, {-44,-37}, {-44,144}, {-44,148}, {-44,149}, {-43,-118}, {-43,-117}, {-43,-84}, {-43,-83}, {-43,-69}, {-43,-68}, {-43,-57}, {-43,-56}, {-43,-51}, {-43,-50}, {-43,-49}, {-43,-48}, {-43,-44}, {-43,-43}, {-43,-42}, {-43,-37}, {-43,144}, {-43,148}, {-43,149}, {-42,-118}, {-42,-117}, {-42,-85}, {-42,-84}, {-42,-83}, {-42,-69}, {-42,-68}, {-42,-58}, {-42,-57}, {-42,-56}, {-42,-51}, {-42,-50}, {-42,-49}, {-42,-48}, {-42,-43}, {-42,-42}, {-42,-37}, {-42,144}, {-42,148}, {-42,149}, {-41,-118}, {-41,-117}, {-41,-116}, {-41,-85}, {-41,-84}, {-41,-69}, {-41,-68}, {-41,-59}, {-41,-58}, {-41,-57}, {-41,-56}, {-41,-50}, {-41,-49}, {-41,-48}, {-41,-47}, {-41,-43}, {-41,-42}, {-41,-41}, {-41,-36}, {-41,144}, {-41,148}, {-41,149}, {-40,-118}, {-40,-117}, {-40,-116}, {-40,-85}, {-40,-84}, {-40,-69}, {-40,-68}, {-40,-60}, {-40,-59}, {-40,-58}, {-40,-57}, {-40,-56}, {-40,-50}, {-40,-49}, {-40,-48}, {-40,-47}, {-40,-43}, {-40,-42}, {-40,-41}, {-40,-36}, {-40,144}, {-40,148}, {-40,149}, {-39,-117}, {-39,-116}, {-39,-85}, {-39,-84}, {-39,-69}, {-39,-68}, {-39,-59}, {-39,-58}, {-39,-57}, {-39,-56}, {-39,-50}, {-39,-49}, {-39,-48}, {-39,-47}, {-39,-42}, {-39,-41}, {-39,-40}, {-39,-35}, {-39,143}, {-39,144}, {-39,148}, {-39,149}, {-38,-117}, {-38,-116}, {-38,-85}, {-38,-84}, {-38,-69}, {-38,-68}, {-38,-57}, {-38,-56}, {-38,-49}, {-38,-48}, {-38,-47}, {-38,-42}, {-38,-41}, {-38,-40}, {-38,-35}, {-38,143}, {-38,144}, {-38,148}, {-38,149}, {-37,-117}, {-37,-116}, {-37,-86}, {-37,-85}, {-37,-84}, {-37,-69}, {-37,-68}, {-37,-57}, {-37,-56}, {-37,-50}, {-37,-49}, {-37,-48}, {-37,-47}, {-37,-42}, {-37,-41}, {-37,-40}, {-37,-39}, {-37,-35}, {-37,-29}, {-37,-28}, {-37,-27}, {-37,143}, {-37,144}, {-37,147}, {-37,148}, {-37,149}, {-36,-117}, {-36,-116}, {-36,-115}, {-36,-86}, {-36,-85}, {-36,-69}, {-36,-68}, {-36,-57}, {-36,-56}, {-36,-50}, {-36,-49}, {-36,-48}, {-36,-47}, {-36,-42}, {-36,-41}, {-36,-40}, {-36,-39}, {-36,-35}, {-36,-34}, {-36,-30}, {-36,-29}, {-36,-28}, {-36,-27}, {-36,143}, {-36,144}, {-36,147}, {-36,148}, {-35,-116}, {-35,-115}, {-35,-86}, {-35,-85}, {-35,-69}, {-35,-68}, {-35,-57}, {-35,-56}, {-35,-50}, {-35,-49}, {-35,-48}, {-35,-47}, {-35,-42}, {-35,-41}, {-35,-40}, {-35,-39}, {-35,-38}, {-35,-34}, {-35,-31}, {-35,-30}, {-35,-29}, {-35,-28}, {-35,-27}, {-35,143}, {-35,144}, {-35,148}, {-34,-116}, {-34,-115}, {-34,-86}, {-34,-85}, {-34,-69}, {-34,-68}, {-34,-59}, {-34,-58}, {-34,-57}, {-34,-56}, {-34,-50}, {-34,-49}, {-34,-48}, {-34,-47}, {-34,-41}, {-34,-40}, {-34,-39}, {-34,-38}, {-34,-34}, {-34,-31}, {-34,-30}, {-34,-29}, {-34,143}, {-34,144}, {-34,148}, {-34,149}, {-33,-116}, {-33,-115}, {-33,-86}, {-33,-85}, {-33,-69}, {-33,-68}, {-33,-60}, {-33,-59}, {-33,-58}, {-33,-57}, {-33,-56}, {-33,-51}, {-33,-49}, {-33,-48}, {-33,-47}, {-33,-41}, {-33,-40}, {-33,-39}, {-33,-38}, {-33,-37}, {-33,-34}, {-33,-33}, {-33,-32}, {-33,-31}, {-33,-30}, {-33,-29}, {-33,143}, {-33,144}, {-33,148}, {-33,149}, {-32,-116}, {-32,-115}, {-32,-86}, {-32,-85}, {-32,-69}, {-32,-68}, {-32,-58}, {-32,-57}, {-32,-56}, {-32,-50}, {-32,-48}, {-32,-47}, {-32,-40}, {-32,-39}, {-32,-38}, {-32,-37}, {-32,-36}, {-32,-33}, {-32,-32}, {-32,-31}, {-32,-30}, {-32,143}, {-32,144}, {-32,149}, {-31,-116}, {-31,-115}, {-31,-87}, {-31,-86}, {-31,-85}, {-31,-69}, {-31,-68}, {-31,-57}, {-31,-56}, {-31,-50}, {-31,-49}, {-31,-48}, {-31,-47}, {-31,-40}, {-31,-39}, {-31,-38}, {-31,-37}, {-31,-36}, {-31,-33}, {-31,-32}, {-31,-31}, {-31,-30}, {-31,143}, {-31,144}, {-31,145}, {-31,146}, {-31,149}, {-31,150}, {-30,-116}, {-30,-115}, {-30,-114}, {-30,-87}, {-30,-86}, {-30,-69}, {-30,-68}, {-30,-57}, {-30,-56}, {-30,-50}, {-30,-49}, {-30,-48}, {-30,-47}, {-30,-38}, {-30,-37}, {-30,-36}, {-30,-35}, {-30,-33}, {-30,-32}, {-30,-31}, {-30,-30}, {-30,143}, {-30,144}, {-30,145}, {-30,146}, {-30,147}, {-30,148}, {-30,149}, {-30,150}, {-29,-115}, {-29,-114}, {-29,-87}, {-29,-86}, {-29,-69}, {-29,-68}, {-29,-57}, {-29,-56}, {-29,-50}, {-29,-49}, {-29,-48}, {-29,-47}, {-29,-37}, {-29,-36}, {-29,-35}, {-29,-34}, {-29,-33}, {-29,-32}, {-29,-31}, {-29,-30}, {-29,142}, {-29,143}, {-29,144}, {-29,145}, {-29,146}, {-29,147}, {-29,148}, {-29,149}, {-29,150}, {-29,151}, {-28,-115}, {-28,-114}, {-28,-87}, {-28,-86}, {-28,-69}, {-28,-68}, {-28,-59}, {-28,-57}, {-28,-56}, {-28,-49}, {-28,-48}, {-28,-47}, {-28,-36}, {-28,-35}, {-28,-34}, {-28,-33}, {-28,-32}, {-28,-31}, {-28,-30}, {-28,142}, {-28,143}, {-28,144}, {-28,145}, {-28,146}, {-28,148}, {-28,149}, {-28,150}, {-28,151}, {-27,-115}, {-27,-114}, {-27,-88}, {-27,-87}, {-27,-86}, {-27,-69}, {-27,-68}, {-27,-60}, {-27,-59}, {-27,-58}, {-27,-57}, {-27,-56}, {-27,-49}, {-27,-48}, {-27,-47}, {-27,-35}, {-27,-34}, {-27,-33}, {-27,-32}, {-27,-31}, {-27,-30}, {-27,150}, {-27,151}, {-26,-115}, {-26,-114}, {-26,-88}, {-26,-87}, {-26,-69}, {-26,-68}, {-26,-59}, {-26,-58}, {-26,-57}, {-26,-56}, {-26,-55}, {-26,-49}, {-26,-48}, {-26,-47}, {-26,-36}, {-26,-35}, {-26,-34}, {-26,-33}, {-26,-32}, {-26,-31}, {-26,-30}, {-26,-29}, {-26,151}, {-26,152}, {-25,-115}, {-25,-114}, {-25,-88}, {-25,-87}, {-25,-69}, {-25,-68}, {-25,-57}, {-25,-56}, {-25,-55}, {-25,-50}, {-25,-49}, {-25,-48}, {-25,-47}, {-25,-36}, {-25,-35}, {-25,-34}, {-25,-33}, {-25,-32}, {-25,-31}, {-25,-30}, {-25,-29}, {-25,151}, {-25,152}, {-24,-115}, {-24,-114}, {-24,-88}, {-24,-87}, {-24,-69}, {-24,-68}, {-24,-57}, {-24,-56}, {-24,-50}, {-24,-49}, {-24,-48}, {-24,-47}, {-24,-37}, {-24,-36}, {-24,-35}, {-24,-34}, {-24,-33}, {-24,-32}, {-24,-31}, {-24,-30}, {-24,-29}, {-24,-28}, {-24,151}, {-24,152}, {-24,153}, {-23,-115}, {-23,-114}, {-23,-89}, {-23,-88}, {-23,-87}, {-23,-70}, {-23,-69}, {-23,-68}, {-23,-57}, {-23,-56}, {-23,-50}, {-23,-49}, {-23,-48}, {-23,-47}, {-23,-38}, {-23,-37}, {-23,-36}, {-23,-35}, {-23,-34}, {-23,-32}, {-23,-31}, {-23,-30}, {-23,-29}, {-23,-28}, {-23,-27}, {-23,152}, {-23,153}, {-22,-115}, {-22,-114}, {-22,-89}, {-22,-88}, {-22,-87}, {-22,-70}, {-22,-69}, {-22,-68}, {-22,-57}, {-22,-56}, {-22,-50}, {-22,-49}, {-22,-48}, {-22,-47}, {-22,-38}, {-22,-37}, {-22,-36}, {-22,-35}, {-22,-31}, {-22,-30}, {-22,-29}, {-22,-28}, {-22,-27}, {-22,-26}, {-22,152}, {-22,153}, {-21,-115}, {-21,-114}, {-21,-89}, {-21,-88}, {-21,-70}, {-21,-69}, {-21,-68}, {-21,-57}, {-21,-56}, {-21,-49}, {-21,-48}, {-21,-47}, {-21,-39}, {-21,-38}, {-21,-37}, {-21,-36}, {-21,-35}, {-21,-30}, {-21,-29}, {-21,-28}, {-21,-27}, {-21,-26}, {-21,-25}, {-21,5}, {-21,6}, {-21,7}, {-21,8}, {-21,9}, {-21,10}, {-21,16}, {-21,17}, {-21,22}, {-21,23}, {-21,24}, {-21,152}, {-21,153}, {-20,-115}, {-20,-114}, {-20,-89}, {-20,-88}, {-20,-70}, {-20,-69}, {-20,-68}, {-20,-57}, {-20,-56}, {-20,-49}, {-20,-48}, {-20,-47}, {-20,-46}, {-20,-39}, {-20,-38}, {-20,-37}, {-20,-36}, {-20,-29}, {-20,-28}, {-20,-27}, {-20,-26}, {-20,-25}, {-20,-24}, {-20,-23}, {-20,-22}, {-20,-21}, {-20,6}, {-20,7}, {-20,8}, {-20,9}, {-20,10}, {-20,11}, {-20,12}, {-20,13}, {-20,14}, {-20,15}, {-20,16}, {-20,17}, {-20,23}, {-20,24}, {-20,152}, {-20,153}, {-19,-115}, {-19,-114}, {-19,-89}, {-19,-88}, {-19,-70}, {-19,-69}, {-19,-68}, {-19,-57}, {-19,-56}, {-19,-48}, {-19,-47}, {-19,-46}, {-19,-39}, {-19,-38}, {-19,-37}, {-19,-36}, {-19,-28}, {-19,-27}, {-19,-26}, {-19,-25}, {-19,-24}, {-19,-23}, {-19,-22}, {-19,-21}, {-19,-20}, {-19,-19}, {-19,-18}, {-19,-17}, {-19,-16}, {-19,-15}, {-19,-14}, {-19,-13}, {-19,-12}, {-19,-11}, {-19,-10}, {-19,-9}, {-19,-8}, {-19,-7}, {-19,-6}, {-19,-5}, {-19,-4}, {-19,8}, {-19,9}, {-19,10}, {-19,11}, {-19,12}, {-19,13}, {-19,14}, {-19,15}, {-19,16}, {-19,23}, {-19,24}, {-19,152}, {-19,153}, {-18,-115}, {-18,-114}, {-18,-113}, {-18,-90}, {-18,-89}, {-18,-88}, {-18,-70}, {-18,-69}, {-18,-68}, {-18,-57}, {-18,-56}, {-18,-48}, {-18,-47}, {-18,-40}, {-18,-39}, {-18,-38}, {-18,-37}, {-18,-27}, {-18,-26}, {-18,-25}, {-18,-24}, {-18,-23}, {-18,-22}, {-18,-21}, {-18,-20}, {-18,-19}, {-18,-18}, {-18,-17}, {-18,-16}, {-18,-15}, {-18,-14}, {-18,-13}, {-18,-12}, {-18,-11}, {-18,-10}, {-18,-9}, {-18,-8}, {-18,-7}, {-18,-6}, {-18,-5}, {-18,-4}, {-18,-3}, {-18,-2}, {-18,-1}, {-18,0}, {-18,1}, {-18,2}, {-18,9}, {-18,10}, {-18,11}, {-18,12}, {-18,13}, {-18,14}, {-18,15}, {-18,23}, {-18,24}, {-18,152}, {-18,153}, {-17,-115}, {-17,-114}, {-17,-113}, {-17,-90}, {-17,-89}, {-17,-88}, {-17,-70}, {-17,-69}, {-17,-57}, {-17,-56}, {-17,-48}, {-17,-47}, {-17,-40}, {-17,-39}, {-17,-38}, {-17,-37}, {-17,-25}, {-17,-24}, {-17,-23}, {-17,-22}, {-17,-15}, {-17,-14}, {-17,-13}, {-17,-12}, {-17,-6}, {-17,-5}, {-17,-4}, {-17,-3}, {-17,-2}, {-17,-1}, {-17,0}, {-17,1}, {-17,2}, {-17,3}, {-17,4}, {-17,5}, {-17,6}, {-17,7}, {-17,8}, {-17,9}, {-17,10}, {-17,11}, {-17,12}, {-17,13}, {-17,14}, {-17,15}, {-17,23}, {-17,24}, {-17,152}, {-17,153}, {-16,-115}, {-16,-114}, {-16,-113}, {-16,-90}, {-16,-89}, {-16,-70}, {-16,-69}, {-16,-57}, {-16,-56}, {-16,-48}, {-16,-47}, {-16,-41}, {-16,-40}, {-16,-39}, {-16,-38}, {-16,-37}, {-16,-24}, {-16,-23}, {-16,-22}, {-16,-21}, {-16,-20}, {-16,-11}, {-16,-10}, {-16,2}, {-16,3}, {-16,4}, {-16,5}, {-16,6}, {-16,7}, {-16,8}, {-16,9}, {-16,10}, {-16,11}, {-16,12}, {-16,13}, {-16,14}, {-16,15}, {-16,16}, {-16,23}, {-16,24}, {-16,152}, {-16,153}, {-15,-115}, {-15,-114}, {-15,-113}, {-15,-90}, {-15,-89}, {-15,-70}, {-15,-69}, {-15,-57}, {-15,-56}, {-15,-48}, {-15,-47}, {-15,-41}, {-15,-40}, {-15,-39}, {-15,-38}, {-15,-23}, {-15,-22}, {-15,-21}, {-15,-20}, {-15,-19}, {-15,-18}, {-15,-15}, {-15,3}, {-15,4}, {-15,5}, {-15,6}, {-15,7}, {-15,8}, {-15,9}, {-15,10}, {-15,11}, {-15,12}, {-15,13}, {-15,14}, {-15,15}, {-15,16}, {-15,17}, {-15,18}, {-15,19}, {-15,23}, {-15,24}, {-15,25}, {-15,152}, {-15,153}, {-14,-115}, {-14,-114}, {-14,-113}, {-14,-112}, {-14,-90}, {-14,-89}, {-14,-70}, {-14,-69}, {-14,-57}, {-14,-56}, {-14,-48}, {-14,-47}, {-14,-41}, {-14,-40}, {-14,-39}, {-14,-21}, {-14,-20}, {-14,-19}, {-14,-18}, {-14,-17}, {-14,-16}, {-14,-15}, {-14,1}, {-14,2}, {-14,3}, {-14,4}, {-14,5}, {-14,6}, {-14,10}, {-14,13}, {-14,14}, {-14,15}, {-14,16}, {-14,17}, {-14,18}, {-14,19}, {-14,20}, {-14,21}, {-14,23}, {-14,24}, {-14,25}, {-14,152}, {-14,153}, {-13,-114}, {-13,-113}, {-13,-112}, {-13,-90}, {-13,-89}, {-13,-70}, {-13,-69}, {-13,-57}, {-13,-56}, {-13,-55}, {-13,-48}, {-13,-47}, {-13,-42}, {-13,-41}, {-13,-40}, {-13,-39}, {-13,-21}, {-13,-20}, {-13,-19}, {-13,-18}, {-13,-17}, {-13,-16}, {-13,-15}, {-13,0}, {-13,1}, {-13,2}, {-13,3}, {-13,4}, {-13,15}, {-13,16}, {-13,17}, {-13,18}, {-13,19}, {-13,20}, {-13,21}, {-13,22}, {-13,23}, {-13,24}, {-13,25}, {-13,26}, {-13,152}, {-13,153}, {-12,-114}, {-12,-113}, {-12,-112}, {-12,-111}, {-12,-90}, {-12,-89}, {-12,-70}, {-12,-69}, {-12,-57}, {-12,-56}, {-12,-55}, {-12,-48}, {-12,-47}, {-12,-42}, {-12,-41}, {-12,-40}, {-12,-18}, {-12,-17}, {-12,-16}, {-12,-15}, {-12,-14}, {-12,-13}, {-12,-12}, {-12,-3}, {-12,-2}, {-12,-1}, {-12,0}, {-12,1}, {-12,2}, {-12,3}, {-12,16}, {-12,17}, {-12,18}, {-12,19}, {-12,20}, {-12,21}, {-12,22}, {-12,23}, {-12,24}, {-12,25}, {-12,26}, {-12,27}, {-12,152}, {-12,153}, {-11,-114}, {-11,-113}, {-11,-112}, {-11,-111}, {-11,-110}, {-11,-90}, {-11,-89}, {-11,-70}, {-11,-69}, {-11,-57}, {-11,-56}, {-11,-55}, {-11,-49}, {-11,-48}, {-11,-47}, {-11,-43}, {-11,-42}, {-11,-41}, {-11,-40}, {-11,-16}, {-11,-15}, {-11,-14}, {-11,-13}, {-11,-12}, {-11,-11}, {-11,-10}, {-11,-9}, {-11,-5}, {-11,-4}, {-11,-3}, {-11,-2}, {-11,-1}, {-11,0}, {-11,1}, {-11,2}, {-11,18}, {-11,19}, {-11,20}, {-11,21}, {-11,22}, {-11,23}, {-11,24}, {-11,25}, {-11,26}, {-11,27}, {-11,28}, {-11,29}, {-11,30}, {-11,152}, {-11,153}, {-10,-114}, {-10,-113}, {-10,-112}, {-10,-111}, {-10,-110}, {-10,-109}, {-10,-91}, {-10,-90}, {-10,-89}, {-10,-70}, {-10,-69}, {-10,-57}, {-10,-56}, {-10,-55}, {-10,-49}, {-10,-48}, {-10,-47}, {-10,-43}, {-10,-42}, {-10,-41}, {-10,-40}, {-10,-13}, {-10,-12}, {-10,-11}, {-10,-10}, {-10,-9}, {-10,-8}, {-10,-7}, {-10,-6}, {-10,-5}, {-10,-4}, {-10,-3}, {-10,-2}, {-10,-1}, {-10,0}, {-10,9}, {-10,10}, {-10,11}, {-10,12}, {-10,13}, {-10,20}, {-10,21}, {-10,22}, {-10,23}, {-10,24}, {-10,25}, {-10,26}, {-10,27}, {-10,28}, {-10,29}, {-10,30}, {-10,152}, {-10,153}, {-9,-114}, {-9,-113}, {-9,-111}, {-9,-110}, {-9,-109}, {-9,-108}, {-9,-92}, {-9,-91}, {-9,-90}, {-9,-89}, {-9,-70}, {-9,-69}, {-9,-57}, {-9,-56}, {-9,-55}, {-9,-49}, {-9,-48}, {-9,-43}, {-9,-42}, {-9,-41}, {-9,-16}, {-9,-15}, {-9,-14}, {-9,-11}, {-9,-10}, {-9,-9}, {-9,-8}, {-9,-7}, {-9,-6}, {-9,-5}, {-9,-4}, {-9,-3}, {-9,-2}, {-9,-1}, {-9,0}, {-9,1}, {-9,2}, {-9,3}, {-9,4}, {-9,5}, {-9,6}, {-9,7}, {-9,8}, {-9,9}, {-9,10}, {-9,11}, {-9,12}, {-9,13}, {-9,14}, {-9,15}, {-9,16}, {-9,17}, {-9,18}, {-9,19}, {-9,20}, {-9,21}, {-9,22}, {-9,23}, {-9,24}, {-9,25}, {-9,26}, {-9,27}, {-9,28}, {-9,29}, {-9,30}, {-9,152}, {-9,153}, {-8,-114}, {-8,-113}, {-8,-110}, {-8,-109}, {-8,-108}, {-8,-107}, {-8,-106}, {-8,-92}, {-8,-91}, {-8,-90}, {-8,-70}, {-8,-69}, {-8,-57}, {-8,-56}, {-8,-55}, {-8,-49}, {-8,-48}, {-8,-44}, {-8,-43}, {-8,-42}, {-8,-19}, {-8,-18}, {-8,-14}, {-8,-11}, {-8,-10}, {-8,-9}, {-8,-8}, {-8,-7}, {-8,-6}, {-8,-5}, {-8,-4}, {-8,-3}, {-8,-2}, {-8,-1}, {-8,0}, {-8,1}, {-8,2}, {-8,3}, {-8,4}, {-8,5}, {-8,6}, {-8,7}, {-8,8}, {-8,9}, {-8,10}, {-8,11}, {-8,12}, {-8,13}, {-8,14}, {-8,15}, {-8,16}, {-8,17}, {-8,18}, {-8,19}, {-8,20}, {-8,21}, {-8,22}, {-8,23}, {-8,24}, {-8,25}, {-8,26}, {-8,27}, {-8,28}, {-8,29}, {-8,30}, {-8,152}, {-8,153}, {-7,-114}, {-7,-113}, {-7,-108}, {-7,-107}, {-7,-106}, {-7,-105}, {-7,-92}, {-7,-91}, {-7,-90}, {-7,-70}, {-7,-69}, {-7,-57}, {-7,-56}, {-7,-55}, {-7,-54}, {-7,-49}, {-7,-48}, {-7,-47}, {-7,-44}, {-7,-43}, {-7,-42}, {-7,-22}, {-7,-20}, {-7,-19}, {-7,-18}, {-7,-17}, {-7,-16}, {-7,-15}, {-7,-14}, {-7,-13}, {-7,-12}, {-7,-11}, {-7,-10}, {-7,-9}, {-7,-8}, {-7,-7}, {-7,-6}, {-7,-5}, {-7,-4}, {-7,-3}, {-7,-2}, {-7,-1}, {-7,0}, {-7,1}, {-7,2}, {-7,3}, {-7,4}, {-7,5}, {-7,6}, {-7,7}, {-7,8}, {-7,9}, {-7,10}, {-7,11}, {-7,12}, {-7,13}, {-7,14}, {-7,15}, {-7,16}, {-7,17}, {-7,18}, {-7,19}, {-7,20}, {-7,21}, {-7,22}, {-7,23}, {-7,24}, {-7,25}, {-7,26}, {-7,27}, {-7,28}, {-7,29}, {-7,30}, {-7,152}, {-7,153}, {-6,-114}, {-6,-113}, {-6,-107}, {-6,-106}, {-6,-105}, {-6,-104}, {-6,-103}, {-6,-93}, {-6,-92}, {-6,-91}, {-6,-90}, {-6,-70}, {-6,-69}, {-6,-57}, {-6,-56}, {-6,-55}, {-6,-54}, {-6,-49}, {-6,-48}, {-6,-47}, {-6,-45}, {-6,-44}, {-6,-43}, {-6,-24}, {-6,-23}, {-6,-22}, {-6,-21}, {-6,-20}, {-6,-19}, {-6,-18}, {-6,-17}, {-6,-16}, {-6,-15}, {-6,-14}, {-6,-13}, {-6,-12}, {-6,-11}, {-6,-10}, {-6,-9}, {-6,-8}, {-6,-7}, {-6,-6}, {-6,-5}, {-6,-4}, {-6,0}, {-6,1}, {-6,2}, {-6,3}, {-6,4}, {-6,5}, {-6,6}, {-6,7}, {-6,8}, {-6,9}, {-6,10}, {-6,11}, {-6,12}, {-6,13}, {-6,14}, {-6,15}, {-6,16}, {-6,17}, {-6,18}, {-6,19}, {-6,20}, {-6,21}, {-6,22}, {-6,27}, {-6,28}, {-6,29}, {-6,30}, {-6,152}, {-6,153}, {-5,-114}, {-5,-113}, {-5,-105}, {-5,-104}, {-5,-103}, {-5,-102}, {-5,-101}, {-5,-93}, {-5,-92}, {-5,-91}, {-5,-90}, {-5,-70}, {-5,-69}, {-5,-57}, {-5,-56}, {-5,-55}, {-5,-54}, {-5,-51}, {-5,-50}, {-5,-49}, {-5,-48}, {-5,-47}, {-5,-45}, {-5,-44}, {-5,-43}, {-5,-27}, {-5,-26}, {-5,-25}, {-5,-24}, {-5,-23}, {-5,-22}, {-5,-21}, {-5,-20}, {-5,-19}, {-5,-18}, {-5,-17}, {-5,-16}, {-5,-15}, {-5,-14}, {-5,-13}, {-5,-12}, {-5,-11}, {-5,-10}, {-5,-9}, {-5,-8}, {-5,4}, {-5,8}, {-5,10}, {-5,11}, {-5,12}, {-5,13}, {-5,14}, {-5,15}, {-5,16}, {-5,17}, {-5,18}, {-5,19}, {-5,21}, {-5,152}, {-5,153}, {-4,-114}, {-4,-113}, {-4,-104}, {-4,-103}, {-4,-102}, {-4,-101}, {-4,-100}, {-4,-93}, {-4,-92}, {-4,-91}, {-4,-90}, {-4,-70}, {-4,-69}, {-4,-58}, {-4,-57}, {-4,-56}, {-4,-55}, {-4,-54}, {-4,-51}, {-4,-50}, {-4,-49}, {-4,-48}, {-4,-47}, {-4,-46}, {-4,-45}, {-4,-44}, {-4,-31}, {-4,-30}, {-4,-29}, {-4,-28}, {-4,-27}, {-4,-26}, {-4,-25}, {-4,-24}, {-4,-23}, {-4,-22}, {-4,-21}, {-4,-20}, {-4,-18}, {-4,-17}, {-4,-16}, {-4,-15}, {-4,-14}, {-4,-13}, {-4,-12}, {-4,-11}, {-4,4}, {-4,5}, {-4,6}, {-4,7}, {-4,8}, {-4,151}, {-4,152}, {-4,153}, {-3,-114}, {-3,-113}, {-3,-102}, {-3,-101}, {-3,-100}, {-3,-99}, {-3,-98}, {-3,-92}, {-3,-91}, {-3,-90}, {-3,-70}, {-3,-69}, {-3,-58}, {-3,-57}, {-3,-56}, {-3,-55}, {-3,-54}, {-3,-51}, {-3,-50}, {-3,-49}, {-3,-48}, {-3,-47}, {-3,-46}, {-3,-45}, {-3,-44}, {-3,-36}, {-3,-35}, {-3,-34}, {-3,-33}, {-3,-32}, {-3,-31}, {-3,-30}, {-3,-29}, {-3,-28}, {-3,-27}, {-3,-26}, {-3,-25}, {-3,-24}, {-3,-23}, {-3,-22}, {-3,-21}, {-3,-20}, {-3,-19}, {-3,-18}, {-3,-17}, {-3,-16}, {-3,151}, {-3,152}, {-3,153}, {-2,-114}, {-2,-113}, {-2,-101}, {-2,-100}, {-2,-99}, {-2,-98}, {-2,-97}, {-2,-96}, {-2,-92}, {-2,-91}, {-2,-90}, {-2,-70}, {-2,-69}, {-2,-58}, {-2,-57}, {-2,-55}, {-2,-54}, {-2,-53}, {-2,-51}, {-2,-50}, {-2,-49}, {-2,-48}, {-2,-47}, {-2,-46}, {-2,-45}, {-2,-38}, {-2,-37}, {-2,-35}, {-2,-34}, {-2,-33}, {-2,-32}, {-2,-31}, {-2,-30}, {-2,-29}, {-2,-28}, {-2,-26}, {-2,-25}, {-2,-24}, {-2,-23}, {-2,-22}, {-2,-21}, {-2,-20}, {-2,-19}, {-2,-18}, {-2,-17}, {-2,151}, {-2,152}, {-1,-114}, {-1,-113}, {-1,-99}, {-1,-98}, {-1,-97}, {-1,-96}, {-1,-95}, {-1,-92}, {-1,-91}, {-1,-90}, {-1,-70}, {-1,-69}, {-1,-58}, {-1,-57}, {-1,-55}, {-1,-54}, {-1,-53}, {-1,-51}, {-1,-50}, {-1,-49}, {-1,-48}, {-1,-47}, {-1,-46}, {-1,-45}, {-1,-38}, {-1,-37}, {-1,-36}, {-1,-35}, {-1,-34}, {-1,-33}, {-1,-32}, {-1,-31}, {-1,-30}, {-1,-27}, {-1,-26}, {-1,-25}, {-1,-24}, {-1,-23}, {-1,-22}, {-1,-21}, {-1,-20}, {-1,151}, {-1,152}, {0,-114}, {0,-113}, {0,-112}, {0,-97}, {0,-96}, {0,-95}, {0,-94}, {0,-93}, {0,-92}, {0,-91}, {0,-90}, {0,-70}, {0,-69}, {0,-58}, {0,-57}, {0,-55}, {0,-54}, {0,-53}, {0,-51}, {0,-50}, {0,-49}, {0,-48}, {0,-47}, {0,-46}, {0,-41}, {0,-40}, {0,-39}, {0,-38}, {0,-37}, {0,-36}, {0,-35}, {0,-34}, {0,-33}, {0,-29}, {0,-28}, {0,-27}, {0,-26}, {0,-25}, {0,-24}, {0,-23}, {0,151}, {0,152}, {1,-114}, {1,-113}, {1,-112}, {1,-96}, {1,-95}, {1,-94}, {1,-93}, {1,-92}, {1,-91}, {1,-90}, {1,-70}, {1,-69}, {1,-58}, {1,-57}, {1,-54}, {1,-53}, {1,-52}, {1,-51}, {1,-50}, {1,-49}, {1,-48}, {1,-47}, {1,-46}, {1,-45}, {1,-44}, {1,-43}, {1,-42}, {1,-41}, {1,-40}, {1,-39}, {1,-38}, {1,-37}, {1,-35}, {1,-31}, {1,-30}, {1,-29}, {1,-28}, {1,-27}, {1,-26}, {1,-25}, {1,-24}, {1,151}, {1,152}, {2,-113}, {2,-112}, {2,-94}, {2,-93}, {2,-92}, {2,-91}, {2,-90}, {2,-70}, {2,-69}, {2,-68}, {2,-58}, {2,-57}, {2,-55}, {2,-54}, {2,-53}, {2,-52}, {2,-51}, {2,-50}, {2,-49}, {2,-48}, {2,-47}, {2,-46}, {2,-45}, {2,-44}, {2,-43}, {2,-42}, {2,-41}, {2,-40}, {2,-39}, {2,-38}, {2,-37}, {2,-33}, {2,-32}, {2,-31}, {2,-30}, {2,-29}, {2,-28}, {2,-27}, {2,150}, {2,151}, {2,152}, {3,-113}, {3,-112}, {3,-93}, {3,-92}, {3,-91}, {3,-70}, {3,-69}, {3,-68}, {3,-59}, {3,-58}, {3,-57}, {3,-56}, {3,-54}, {3,-53}, {3,-52}, {3,-51}, {3,-50}, {3,-49}, {3,-48}, {3,-47}, {3,-46}, {3,-45}, {3,-44}, {3,-43}, {3,-42}, {3,-41}, {3,-40}, {3,-39}, {3,-38}, {3,-37}, {3,-36}, {3,-35}, {3,-34}, {3,-33}, {3,-32}, {3,-31}, {3,-30}, {3,-29}, {3,-28}, {3,150}, {3,151}, {3,152}, {4,-113}, {4,-112}, {4,-92}, {4,-91}, {4,-70}, {4,-69}, {4,-68}, {4,-60}, {4,-59}, {4,-58}, {4,-57}, {4,-56}, {4,-55}, {4,-54}, {4,-53}, {4,-52}, {4,-51}, {4,-50}, {4,-49}, {4,-48}, {4,-47}, {4,-46}, {4,-45}, {4,-43}, {4,-42}, {4,-41}, {4,-36}, {4,-35}, {4,-34}, {4,-33}, {4,-31}, {4,150}, {4,151}, {5,-113}, {5,-112}, {5,-92}, {5,-91}, {5,-90}, {5,-70}, {5,-69}, {5,-68}, {5,-59}, {5,-58}, {5,-57}, {5,-56}, {5,-55}, {5,-54}, {5,-53}, {5,-52}, {5,-51}, {5,-50}, {5,-49}, {5,-48}, {5,-47}, {5,-46}, {5,-45}, {5,-44}, {5,-43}, {5,-38}, {5,-37}, {5,-36}, {5,-35}, {5,-34}, {5,-32}, {5,149}, {5,150}, {5,151}, {6,-113}, {6,-112}, {6,-111}, {6,-92}, {6,-91}, {6,-90}, {6,-70}, {6,-69}, {6,-68}, {6,-57}, {6,-56}, {6,-55}, {6,-54}, {6,-53}, {6,-52}, {6,-51}, {6,-50}, {6,-49}, {6,-48}, {6,-47}, {6,-46}, {6,-44}, {6,-43}, {6,-39}, {6,-38}, {6,-37}, {6,-35}, {6,149}, {6,150}, {6,151}, {7,-113}, {7,-112}, {7,-111}, {7,-110}, {7,-92}, {7,-91}, {7,-90}, {7,-69}, {7,-68}, {7,-56}, {7,-55}, {7,-54}, {7,-53}, {7,-52}, {7,-51}, {7,-50}, {7,-49}, {7,-48}, {7,-44}, {7,-43}, {7,-42}, {7,-40}, {7,-39}, {7,-38}, {7,-37}, {7,149}, {7,150}, {7,151}, {8,-112}, {8,-111}, {8,-110}, {8,-109}, {8,-108}, {8,-107}, {8,-106}, {8,-92}, {8,-91}, {8,-90}, {8,-69}, {8,-68}, {8,-54}, {8,-53}, {8,-52}, {8,-51}, {8,-50}, {8,-49}, {8,-43}, {8,-42}, {8,-41}, {8,-40}, {8,-39}, {8,149}, {8,150}, {9,-111}, {9,-110}, {9,-109}, {9,-108}, {9,-107}, {9,-106}, {9,-105}, {9,-92}, {9,-91}, {9,-90}, {9,-69}, {9,-68}, {9,-52}, {9,-51}, {9,-50}, {9,-43}, {9,-42}, {9,-41}, {9,149}, {9,150}, {10,-107}, {10,-106}, {10,-105}, {10,-104}, {10,-91}, {10,-90}, {10,-89}, {10,-69}, {10,-68}, {10,-51}, {10,-42}, {10,149}, {10,150}, {11,-106}, {11,-105}, {11,-104}, {11,-90}, {11,-89}, {11,-69}, {11,-68}, {11,149}, {11,150}, {12,-105}, {12,-104}, {12,-103}, {12,-90}, {12,-89}, {12,-69}, {12,-68}, {12,148}, {12,149}, {12,150}, {13,-105}, {13,-104}, {13,-103}, {13,-90}, {13,-89}, {13,-69}, {13,-68}, {13,148}, {13,149}, {13,150}, {14,-104}, {14,-103}, {14,-90}, {14,-89}, {14,-69}, {14,-68}, {14,148}, {14,149}, {14,150}, {15,-104}, {15,-103}, {15,-90}, {15,-89}, {15,-70}, {15,-69}, {15,-68}, {15,148}, {15,149}, {15,150}, {16,-104}, {16,-103}, {16,-90}, {16,-89}, {16,-70}, {16,-69}, {16,-68}, {16,-67}, {16,-51}, {16,-23}, {16,-15}, {16,-14}, {16,148}, {16,149}, {16,150}, {17,-104}, {17,-103}, {17,-102}, {17,-90}, {17,-89}, {17,-88}, {17,-70}, {17,-69}, {17,-68}, {17,-67}, {17,-66}, {17,-52}, {17,-51}, {17,-50}, {17,-24}, {17,-23}, {17,-22}, {17,-21}, {17,-20}, {17,-19}, {17,-18}, {17,-17}, {17,-16}, {17,-15}, {17,-14}, {17,147}, {17,148}, {17,149}, {17,150}, {18,-104}, {18,-103}, {18,-102}, {18,-90}, {18,-89}, {18,-88}, {18,-70}, {18,-69}, {18,-67}, {18,-66}, {18,-65}, {18,-64}, {18,-63}, {18,-62}, {18,-61}, {18,-60}, {18,-59}, {18,-58}, {18,-57}, {18,-56}, {18,-55}, {18,-54}, {18,-53}, {18,-52}, {18,-51}, {18,-50}, {18,-49}, {18,-48}, {18,-47}, {18,-46}, {18,-45}, {18,-44}, {18,-43}, {18,-42}, {18,-41}, {18,-40}, {18,-39}, {18,-38}, {18,-27}, {18,-26}, {18,-25}, {18,-24}, {18,-23}, {18,-22}, {18,-21}, {18,-20}, {18,-19}, {18,-18}, {18,-17}, {18,-16}, {18,-15}, {18,-14}, {18,147}, {18,148}, {18,149}, {18,150}, {19,-103}, {19,-102}, {19,-89}, {19,-88}, {19,-70}, {19,-69}, {19,-68}, {19,-67}, {19,-66}, {19,-65}, {19,-64}, {19,-63}, {19,-62}, {19,-61}, {19,-60}, {19,-59}, {19,-58}, {19,-57}, {19,-56}, {19,-55}, {19,-54}, {19,-53}, {19,-52}, {19,-51}, {19,-50}, {19,-49}, {19,-48}, {19,-47}, {19,-46}, {19,-45}, {19,-44}, {19,-43}, {19,-42}, {19,-41}, {19,-40}, {19,-39}, {19,-38}, {19,-37}, {19,-36}, {19,-35}, {19,-34}, {19,-33}, {19,-32}, {19,-31}, {19,-30}, {19,-29}, {19,-28}, {19,-27}, {19,-26}, {19,-25}, {19,-24}, {19,-23}, {19,-22}, {19,-21}, {19,-20}, {19,-19}, {19,-18}, {19,-17}, {19,-16}, {19,-15}, {19,-14}, {19,-13}, {19,-12}, {19,147}, {19,148}, {19,149}, {20,-103}, {20,-102}, {20,-89}, {20,-88}, {20,-70}, {20,-69}, {20,-68}, {20,-67}, {20,-66}, {20,-42}, {20,-41}, {20,-40}, {20,-39}, {20,-38}, {20,-37}, {20,-36}, {20,-35}, {20,-34}, {20,-33}, {20,-32}, {20,-31}, {20,-30}, {20,-29}, {20,-28}, {20,-27}, {20,-26}, {20,-25}, {20,-18}, {20,-17}, {20,-16}, {20,-15}, {20,-14}, {20,-13}, {20,-12}, {20,-11}, {20,147}, {20,148}, {20,149}, {21,-103}, {21,-102}, {21,-89}, {21,-88}, {21,-87}, {21,-70}, {21,-69}, {21,-68}, {21,-41}, {21,-40}, {21,-39}, {21,-38}, {21,-14}, {21,-13}, {21,-12}, {21,-11}, {21,-10}, {21,-9}, {21,-8}, {21,146}, {21,147}, {21,148}, {21,149}, {22,-103}, {22,-102}, {22,-89}, {22,-88}, {22,-87}, {22,-70}, {22,-69}, {22,-40}, {22,-39}, {22,-38}, {22,-12}, {22,-11}, {22,-10}, {22,-9}, {22,-8}, {22,146}, {22,147}, {22,148}, {22,149}, {23,-103}, {23,-102}, {23,-101}, {23,-89}, {23,-88}, {23,-87}, {23,-70}, {23,-69}, {23,-40}, {23,-39}, {23,-38}, {23,-11}, {23,-10}, {23,-9}, {23,-8}, {23,145}, {23,146}, {23,147}, {23,149}, {24,-102}, {24,-101}, {24,-89}, {24,-88}, {24,-87}, {24,-71}, {24,-70}, {24,-69}, {24,-39}, {24,-38}, {24,-37}, {24,-10}, {24,-9}, {24,-8}, {24,145}, {24,146}, {24,147}, {24,149}, {25,-102}, {25,-101}, {25,-89}, {25,-88}, {25,-87}, {25,-71}, {25,-70}, {25,-39}, {25,-38}, {25,-37}, {25,-9}, {25,-8}, {25,144}, {25,145}, {25,146}, {25,148}, {26,-102}, {26,-101}, {26,-90}, {26,-89}, {26,-88}, {26,-87}, {26,-71}, {26,-70}, {26,-38}, {26,-37}, {26,-36}, {26,144}, {26,145}, {26,146}, {26,148}, {27,-102}, {27,-101}, {27,-90}, {27,-89}, {27,-88}, {27,-87}, {27,-86}, {27,-71}, {27,-70}, {27,-38}, {27,-37}, {27,-36}, {27,143}, {27,144}, {27,145}, {27,148}, {28,-102}, {28,-101}, {28,-90}, {28,-89}, {28,-88}, {28,-87}, {28,-86}, {28,-71}, {28,-70}, {28,-37}, {28,-36}, {28,142}, {28,143}, {28,144}, {28,145}, {28,148}, {29,-102}, {29,-101}, {29,-90}, {29,-89}, {29,-88}, {29,-87}, {29,-86}, {29,-71}, {29,-70}, {29,-37}, {29,-36}, {29,-35}, {29,67}, {29,68}, {29,69}, {29,70}, {29,71}, {29,141}, {29,142}, {29,143}, {29,144}, {29,148}, {30,-102}, {30,-101}, {30,-100}, {30,-90}, {30,-89}, {30,-88}, {30,-87}, {30,-86}, {30,-71}, {30,-70}, {30,-37}, {30,-36}, {30,-35}, {30,-9}, {30,-8}, {30,58}, {30,59}, {30,60}, {30,61}, {30,62}, {30,63}, {30,64}, {30,65}, {30,66}, {30,67}, {30,68}, {30,69}, {30,70}, {30,71}, {30,72}, {30,73}, {30,74}, {30,89}, {30,90}, {30,91}, {30,92}, {30,93}, {30,94}, {30,95}, {30,96}, {30,97}, {30,98}, {30,99}, {30,100}, {30,101}, {30,127}, {30,128}, {30,129}, {30,130}, {30,131}, {30,132}, {30,133}, {30,134}, {30,135}, {30,136}, {30,137}, {30,138}, {30,139}, {30,140}, {30,141}, {30,142}, {30,143}, {30,148}, {31,-102}, {31,-101}, {31,-100}, {31,-91}, {31,-90}, {31,-89}, {31,-88}, {31,-87}, {31,-86}, {31,-71}, {31,-70}, {31,-36}, {31,-35}, {31,-34}, {31,-12}, {31,-11}, {31,-10}, {31,-9}, {31,-8}, {31,56}, {31,57}, {31,58}, {31,59}, {31,60}, {31,61}, {31,62}, {31,63}, {31,64}, {31,65}, {31,66}, {31,67}, {31,68}, {31,69}, {31,70}, {31,71}, {31,72}, {31,73}, {31,74}, {31,75}, {31,76}, {31,77}, {31,78}, {31,79}, {31,80}, {31,81}, {31,82}, {31,83}, {31,84}, {31,85}, {31,86}, {31,87}, {31,88}, {31,89}, {31,90}, {31,91}, {31,92}, {31,93}, {31,94}, {31,95}, {31,96}, {31,97}, {31,98}, {31,99}, {31,100}, {31,101}, {31,102}, {31,103}, {31,104}, {31,105}, {31,106}, {31,107}, {31,108}, {31,109}, {31,110}, {31,111}, {31,112}, {31,113}, {31,114}, {31,115}, {31,116}, {31,117}, {31,118}, {31,119}, {31,120}, {31,121}, {31,122}, {31,123}, {31,124}, {31,125}, {31,126}, {31,127}, {31,128}, {31,129}, {31,130}, {31,131}, {31,132}, {31,133}, {31,134}, {31,135}, {31,136}, {31,137}, {31,138}, {31,139}, {31,140}, {31,141}, {31,142}, {31,143}, {31,144}, {31,148}, {32,-101}, {32,-100}, {32,-91}, {32,-90}, {32,-89}, {32,-88}, {32,-87}, {32,-86}, {32,-71}, {32,-70}, {32,-36}, {32,-35}, {32,-34}, {32,-14}, {32,-13}, {32,-12}, {32,-11}, {32,-10}, {32,-9}, {32,-8}, {32,54}, {32,55}, {32,56}, {32,57}, {32,58}, {32,59}, {32,74}, {32,75}, {32,76}, {32,77}, {32,78}, {32,79}, {32,80}, {32,81}, {32,82}, {32,83}, {32,84}, {32,85}, {32,86}, {32,87}, {32,88}, {32,89}, {32,90}, {32,100}, {32,101}, {32,102}, {32,103}, {32,104}, {32,105}, {32,106}, {32,107}, {32,108}, {32,109}, {32,110}, {32,111}, {32,112}, {32,113}, {32,114}, {32,115}, {32,116}, {32,117}, {32,118}, {32,119}, {32,120}, {32,121}, {32,122}, {32,123}, {32,124}, {32,125}, {32,126}, {32,127}, {32,128}, {32,136}, {32,137}, {32,138}, {32,139}, {32,140}, {32,141}, {32,142}, {32,143}, {32,144}, {32,145}, {32,146}, {32,148}, {32,149}, {33,-101}, {33,-100}, {33,-91}, {33,-90}, {33,-87}, {33,-86}, {33,-71}, {33,-70}, {33,-69}, {33,-35}, {33,-34}, {33,-19}, {33,-18}, {33,-16}, {33,-15}, {33,-14}, {33,-13}, {33,-12}, {33,-11}, {33,-8}, {33,53}, {33,54}, {33,55}, {33,56}, {33,57}, {33,144}, {33,145}, {33,146}, {33,147}, {33,148}, {33,149}, {34,-101}, {34,-100}, {34,-92}, {34,-91}, {34,-90}, {34,-87}, {34,-86}, {34,-85}, {34,-70}, {34,-69}, {34,-35}, {34,-34}, {34,-21}, {34,-20}, {34,-19}, {34,-18}, {34,-17}, {34,-16}, {34,-15}, {34,-14}, {34,-13}, {34,-12}, {34,53}, {34,54}, {34,55}, {34,145}, {34,146}, {34,147}, {34,148}, {34,149}, {35,-101}, {35,-100}, {35,-99}, {35,-92}, {35,-91}, {35,-90}, {35,-87}, {35,-86}, {35,-85}, {35,-71}, {35,-70}, {35,-69}, {35,-41}, {35,-35}, {35,-34}, {35,-33}, {35,-25}, {35,-24}, {35,-23}, {35,-22}, {35,-21}, {35,-20}, {35,-19}, {35,-18}, {35,-17}, {35,-16}, {35,-15}, {35,-14}, {35,53}, {35,54}, {35,146}, {35,147}, {35,148}, {36,-101}, {36,-100}, {36,-99}, {36,-93}, {36,-92}, {36,-91}, {36,-86}, {36,-85}, {36,-71}, {36,-70}, {36,-69}, {36,-68}, {36,-67}, {36,-42}, {36,-41}, {36,-40}, {36,-39}, {36,-38}, {36,-37}, {36,-36}, {36,-35}, {36,-34}, {36,-33}, {36,-32}, {36,-31}, {36,-30}, {36,-29}, {36,-28}, {36,-27}, {36,-26}, {36,-25}, {36,-24}, {36,-23}, {36,-22}, {36,-21}, {36,-20}, {36,-19}, {36,-18}, {36,-17}, {36,-16}, {36,-15}, {36,-14}, {36,53}, {36,54}, {36,146}, {36,147}, {36,148}, {37,-100}, {37,-99}, {37,-93}, {37,-92}, {37,-91}, {37,-86}, {37,-85}, {37,-70}, {37,-69}, {37,-68}, {37,-67}, {37,-42}, {37,-41}, {37,-40}, {37,-39}, {37,-38}, {37,-37}, {37,-36}, {37,-35}, {37,-34}, {37,-33}, {37,-32}, {37,-31}, {37,-30}, {37,-29}, {37,-28}, {37,-27}, {37,-26}, {37,-25}, {37,-24}, {37,-23}, {37,-22}, {37,-21}, {37,-20}, {37,-19}, {37,-18}, {37,-17}, {37,53}, {37,54}, {37,147}, {37,148}, {38,-100}, {38,-99}, {38,-93}, {38,-92}, {38,-86}, {38,-85}, {38,-70}, {38,-69}, {38,-68}, {38,-67}, {38,-42}, {38,-41}, {38,-40}, {38,-39}, {38,-38}, {38,-37}, {38,-36}, {38,-35}, {38,-34}, {38,-33}, {38,-32}, {38,-31}, {38,-30}, {38,-29}, {38,-28}, {38,-27}, {38,-26}, {38,-25}, {38,-24}, {38,-23}, {38,-22}, {38,-21}, {38,-20}, {38,-19}, {38,-8}, {38,53}, {38,54}, {38,147}, {38,148}, {39,-100}, {39,-99}, {39,-94}, {39,-93}, {39,-92}, {39,-86}, {39,-85}, {39,-84}, {39,-71}, {39,-70}, {39,-69}, {39,-68}, {39,-67}, {39,-42}, {39,-41}, {39,-40}, {39,-39}, {39,-38}, {39,-37}, {39,-36}, {39,-35}, {39,-34}, {39,-33}, {39,-32}, {39,-31}, {39,-30}, {39,-29}, {39,-28}, {39,-27}, {39,-26}, {39,-25}, {39,-24}, {39,-23}, {39,-22}, {39,-21}, {39,-20}, {39,-19}, {39,-18}, {39,53}, {39,54}, {39,147}, {39,148}, {40,-100}, {40,-99}, {40,-98}, {40,-94}, {40,-93}, {40,-92}, {40,-85}, {40,-84}, {40,-71}, {40,-70}, {40,-33}, {40,-32}, {40,-29}, {40,-28}, {40,-27}, {40,-26}, {40,-25}, {40,-24}, {40,-23}, {40,-22}, {40,-21}, {40,-20}, {40,-19}, {40,-18}, {40,53}, {40,54}, {40,147}, {40,148}, {41,-100}, {41,-99}, {41,-98}, {41,-94}, {41,-93}, {41,-85}, {41,-84}, {41,-71}, {41,-70}, {41,-33}, {41,-32}, {41,-30}, {41,-29}, {41,-28}, {41,-25}, {41,-24}, {41,-23}, {41,-22}, {41,-21}, {41,-20}, {41,-19}, {41,-18}, {41,-17}, {41,-16}, {41,53}, {41,54}, {41,147}, {41,148}, {42,-99}, {42,-98}, {42,-94}, {42,-93}, {42,-85}, {42,-84}, {42,-71}, {42,-70}, {42,-33}, {42,-32}, {42,-31}, {42,-30}, {42,-29}, {42,-28}, {42,-26}, {42,-25}, {42,-24}, {42,-23}, {42,-19}, {42,-18}, {42,-17}, {42,-16}, {42,-15}, {42,-14}, {42,-13}, {42,-8}, {42,53}, {42,54}, {42,147}, {42,148}, {43,-99}, {43,-98}, {43,-94}, {43,-93}, {43,-90}, {43,-85}, {43,-84}, {43,-83}, {43,-71}, {43,-70}, {43,-33}, {43,-32}, {43,-31}, {43,-30}, {43,-29}, {43,-28}, {43,-27}, {43,-26}, {43,-25}, {43,-19}, {43,-18}, {43,-17}, {43,-16}, {43,-15}, {43,-14}, {43,-13}, {43,-12}, {43,-11}, {43,-10}, {43,-8}, {43,53}, {43,54}, {43,147}, {43,148}, {44,-99}, {44,-98}, {44,-95}, {44,-94}, {44,-93}, {44,-89}, {44,-88}, {44,-87}, {44,-86}, {44,-85}, {44,-84}, {44,-83}, {44,-71}, {44,-70}, {44,-33}, {44,-32}, {44,-31}, {44,-30}, {44,-28}, {44,-27}, {44,-26}, {44,-16}, {44,-15}, {44,-14}, {44,-13}, {44,-12}, {44,-11}, {44,-10}, {44,-9}, {44,-8}, {44,53}, {44,54}, {44,147}, {44,148}, {45,-99}, {45,-98}, {45,-97}, {45,-95}, {45,-94}, {45,-93}, {45,-90}, {45,-89}, {45,-88}, {45,-87}, {45,-86}, {45,-85}, {45,-84}, {45,-83}, {45,-71}, {45,-70}, {45,-34}, {45,-33}, {45,-32}, {45,-31}, {45,-29}, {45,-28}, {45,-27}, {45,-14}, {45,-13}, {45,-12}, {45,-11}, {45,-10}, {45,-9}, {45,-8}, {45,53}, {45,54}, {45,147}, {45,148}, {46,-99}, {46,-98}, {46,-97}, {46,-96}, {46,-95}, {46,-94}, {46,-93}, {46,-92}, {46,-91}, {46,-90}, {46,-89}, {46,-88}, {46,-87}, {46,-86}, {46,-85}, {46,-84}, {46,-83}, {46,-82}, {46,-71}, {46,-70}, {46,-33}, {46,-32}, {46,-31}, {46,-30}, {46,-29}, {46,-28}, {46,-14}, {46,-13}, {46,-12}, {46,-11}, {46,-10}, {46,-9}, {46,-8}, {46,53}, {46,54}, {46,147}, {46,148}, {47,-98}, {47,-97}, {47,-96}, {47,-95}, {47,-94}, {47,-93}, {47,-92}, {47,-91}, {47,-90}, {47,-85}, {47,-84}, {47,-83}, {47,-82}, {47,-71}, {47,-70}, {47,-33}, {47,-32}, {47,-31}, {47,-30}, {47,-29}, {47,-28}, {47,-18}, {47,-17}, {47,-16}, {47,-15}, {47,-14}, {47,-13}, {47,-12}, {47,-11}, {47,-10}, {47,53}, {47,54}, {47,147}, {47,148}, {47,149}, {48,-98}, {48,-97}, {48,-96}, {48,-95}, {48,-94}, {48,-93}, {48,-92}, {48,-91}, {48,-84}, {48,-83}, {48,-82}, {48,-71}, {48,-70}, {48,-34}, {48,-33}, {48,-32}, {48,-31}, {48,-30}, {48,-20}, {48,-19}, {48,-18}, {48,-17}, {48,-16}, {48,-15}, {48,-14}, {48,53}, {48,54}, {48,147}, {48,148}, {48,149}, {49,-97}, {49,-96}, {49,-95}, {49,-94}, {49,-93}, {49,-83}, {49,-82}, {49,-81}, {49,-71}, {49,-70}, {49,-34}, {49,-33}, {49,-32}, {49,-31}, {49,-23}, {49,-22}, {49,-21}, {49,-20}, {49,-19}, {49,-18}, {49,53}, {49,54}, {49,147}, {49,148}, {49,149}, {50,-97}, {50,-96}, {50,-95}, {50,-83}, {50,-82}, {50,-81}, {50,-71}, {50,-70}, {50,-35}, {50,-34}, {50,-33}, {50,-32}, {50,-31}, {50,-30}, {50,-25}, {50,-24}, {50,-23}, {50,-22}, {50,-21}, {50,-20}, {50,-8}, {50,53}, {50,54}, {50,147}, {50,148}, {50,149}, {51,-97}, {51,-96}, {51,-95}, {51,-82}, {51,-81}, {51,-71}, {51,-70}, {51,-35}, {51,-34}, {51,-33}, {51,-32}, {51,-31}, {51,-30}, {51,-28}, {51,-27}, {51,-26}, {51,-25}, {51,-24}, {51,-23}, {51,-10}, {51,-9}, {51,-8}, {51,53}, {51,54}, {51,147}, {51,148}, {51,149}, {52,-97}, {52,-96}, {52,-95}, {52,-82}, {52,-81}, {52,-80}, {52,-71}, {52,-70}, {52,-37}, {52,-36}, {52,-35}, {52,-34}, {52,-33}, {52,-31}, {52,-30}, {52,-29}, {52,-28}, {52,-27}, {52,-26}, {52,-25}, {52,-11}, {52,-10}, {52,-9}, {52,-8}, {52,53}, {52,54}, {52,147}, {52,148}, {52,149}, {53,-96}, {53,-82}, {53,-81}, {53,-80}, {53,-71}, {53,-70}, {53,-39}, {53,-38}, {53,-37}, {53,-36}, {53,-35}, {53,-31}, {53,-30}, {53,-29}, {53,-28}, {53,-12}, {53,-11}, {53,-10}, {53,-9}, {53,-8}, {53,53}, {53,54}, {53,147}, {53,148}, {53,149}, {54,-82}, {54,-81}, {54,-80}, {54,-71}, {54,-70}, {54,-69}, {54,-68}, {54,-39}, {54,-38}, {54,-37}, {54,-36}, {54,-33}, {54,-32}, {54,-31}, {54,-30}, {54,-29}, {54,-13}, {54,-12}, {54,-11}, {54,-10}, {54,-9}, {54,-8}, {54,53}, {54,54}, {54,55}, {54,147}, {54,148}, {54,149}, {55,-81}, {55,-80}, {55,-70}, {55,-69}, {55,-68}, {55,-67}, {55,-66}, {55,-42}, {55,-41}, {55,-40}, {55,-39}, {55,-38}, {55,-37}, {55,-36}, {55,-35}, {55,-34}, {55,-33}, {55,-32}, {55,-31}, {55,-30}, {55,-29}, {55,-15}, {55,-14}, {55,-13}, {55,-12}, {55,-11}, {55,-10}, {55,-9}, {55,53}, {55,54}, {55,55}, {55,147}, {55,148}, {55,149}, {56,-81}, {56,-80}, {56,-70}, {56,-69}, {56,-68}, {56,-67}, {56,-66}, {56,-65}, {56,-64}, {56,-63}, {56,-62}, {56,-61}, {56,-60}, {56,-59}, {56,-58}, {56,-57}, {56,-56}, {56,-55}, {56,-54}, {56,-53}, {56,-52}, {56,-51}, {56,-50}, {56,-49}, {56,-48}, {56,-47}, {56,-46}, {56,-45}, {56,-44}, {56,-43}, {56,-42}, {56,-41}, {56,-40}, {56,-39}, {56,-38}, {56,-37}, {56,-36}, {56,-35}, {56,-34}, {56,-33}, {56,-31}, {56,-30}, {56,-29}, {56,-19}, {56,-18}, {56,-17}, {56,-16}, {56,-15}, {56,-14}, {56,-13}, {56,-12}, {56,-11}, {56,-10}, {56,-9}, {56,54}, {56,55}, {56,147}, {56,148}, {56,149}, {57,-81}, {57,-80}, {57,-79}, {57,-70}, {57,-69}, {57,-68}, {57,-67}, {57,-66}, {57,-65}, {57,-64}, {57,-63}, {57,-62}, {57,-61}, {57,-60}, {57,-59}, {57,-58}, {57,-57}, {57,-56}, {57,-55}, {57,-54}, {57,-53}, {57,-52}, {57,-51}, {57,-50}, {57,-49}, {57,-48}, {57,-47}, {57,-46}, {57,-45}, {57,-44}, {57,-43}, {57,-42}, {57,-41}, {57,-40}, {57,-39}, {57,-38}, {57,-37}, {57,-36}, {57,-35}, {57,-34}, {57,-30}, {57,-29}, {57,-20}, {57,-19}, {57,-18}, {57,-10}, {57,-9}, {57,54}, {57,55}, {57,147}, {57,148}, {58,-80}, {58,-79}, {58,-70}, {58,-69}, {58,-68}, {58,-67}, {58,-61}, {58,-60}, {58,-59}, {58,-58}, {58,-57}, {58,-56}, {58,-55}, {58,-38}, {58,-37}, {58,-36}, {58,-35}, {58,-10}, {58,-9}, {58,54}, {58,55}, {58,147}, {58,148}, {59,-80}, {59,-79}, {59,-78}, {59,-70}, {59,-69}, {59,-60}, {59,-10}, {59,-9}, {59,53}, {59,54}, {59,55}, {59,147}, {59,148}, {59,149}, {60,-80}, {60,-79}, {60,-78}, {60,-70}, {60,-69}, {60,53}, {60,54}, {60,55}, {60,148}, {60,149}, {61,-80}, {61,-79}, {61,-78}, {61,-69}, {61,53}, {61,54}, {61,148}, {61,149}, {62,-79}, {62,-78}, {62,-77}, {62,-69}, {62,53}, {62,54}, {62,148}, {62,149}, {63,-79}, {63,-78}, {63,-77}, {63,-69}, {63,53}, {63,54}, {63,148}, {63,149}, {64,-78}, {64,-77}, {64,-70}, {64,-69}, {64,53}, {64,54}, {64,148}, {64,149}, {65,-78}, {65,-77}, {65,-70}, {65,-69}, {65,53}, {65,54}, {65,148}, {65,149}, {66,-79}, {66,-78}, {66,-77}, {66,-70}, {66,-69}, {66,53}, {66,54}, {66,148}, {66,149}, {67,-79}, {67,-78}, {67,-77}, {67,-76}, {67,-70}, {67,-69}, {67,53}, {67,54}, {67,148}, {67,149}, {68,-78}, {68,-77}, {68,-76}, {68,-75}, {68,-70}, {68,-69}, {68,53}, {68,54}, {68,148}, {68,149}, {69,-77}, {69,-76}, {69,-75}, {69,-74}, {69,-71}, {69,-70}, {69,-69}, {69,-68}, {69,-67}, {69,53}, {69,54}, {69,148}, {69,149}, {70,-76}, {70,-75}, {70,-74}, {70,-73}, {70,-72}, {70,-71}, {70,-70}, {70,-69}, {70,-68}, {70,-67}, {70,-66}, {70,53}, {70,54}, {70,55}, {70,148}, {70,149}, {71,-75}, {71,-74}, {71,-73}, {71,-72}, {71,-71}, {71,-70}, {71,-69}, {71,-68}, {71,-67}, {71,54}, {71,55}, {71,148}, {71,149}, {72,-75}, {72,-74}, {72,-73}, {72,54}, {72,55}, {72,148}, {72,149}, {73,-74}, {73,-73}, {73,-72}, {73,54}, {73,55}, {73,148}, {73,149}, {74,-73}, {74,-72}, {74,54}, {74,55}, {74,148}, {74,149}, {75,-73}, {75,-72}, {75,-71}, {75,54}, {75,55}, {75,148}, {75,149}, {76,-73}, {76,-72}, {76,-71}, {76,54}, {76,55}, {76,148}, {76,149}, {77,-72}, {77,-71}, {77,-70}, {77,-69}, {77,54}, {77,55}, {77,56}, {77,148}, {77,149}, {78,-71}, {78,-70}, {78,-69}, {78,-68}, {78,54}, {78,55}, {78,56}, {78,57}, {78,148}, {78,149}, {79,-71}, {79,-70}, {79,-69}, {79,-68}, {79,-67}, {79,-66}, {79,54}, {79,55}, {79,56}, {79,148}, {79,149}, {80,-70}, {80,-69}, {80,-68}, {80,-67}, {80,-66}, {80,53}, {80,54}, {80,55}, {80,148}, {80,149}, {81,-68}, {81,-67}, {81,-66}, {81,53}, {81,54}, {81,55}, {81,148}, {81,149}, {82,-68}, {82,-67}, {82,-66}, {82,53}, {82,54}, {82,148}, {82,149}, {83,-66}, {83,-30}, {83,-14}, {83,53}, {83,54}, {83,148}, {83,149}, {84,-66}, {84,-31}, {84,-30}, {84,-29}, {84,-16}, {84,-15}, {84,-14}, {84,-13}, {84,-12}, {84,-11}, {84,4}, {84,5}, {84,6}, {84,7}, {84,53}, {84,54}, {84,148}, {84,149}, {85,-30}, {85,-29}, {85,-28}, {85,-27}, {85,-18}, {85,-17}, {85,-16}, {85,-15}, {85,-14}, {85,-13}, {85,-12}, {85,-11}, {85,-10}, {85,0}, {85,1}, {85,2}, {85,3}, {85,4}, {85,5}, {85,6}, {85,7}, {85,8}, {85,9}, {85,10}, {85,11}, {85,12}, {85,13}, {85,14}, {85,15}, {85,16}, {85,17}, {85,18}, {85,19}, {85,20}, {85,21}, {85,22}, {85,23}, {85,24}, {85,25}, {85,26}, {85,27}, {85,28}, {85,29}, {85,42}, {85,43}, {85,44}, {85,45}, {85,46}, {85,47}, {85,48}, {85,49}, {85,50}, {85,51}, {85,52}, {85,53}, {85,54}, {85,55}, {85,148}, {85,149}, {86,-29}, {86,-28}, {86,-27}, {86,-26}, {86,-25}, {86,-24}, {86,-23}, {86,-22}, {86,-21}, {86,-20}, {86,-19}, {86,-18}, {86,-17}, {86,-16}, {86,-15}, {86,-14}, {86,-12}, {86,-11}, {86,-10}, {86,-9}, {86,-8}, {86,-7}, {86,-6}, {86,-5}, {86,-4}, {86,-3}, {86,-2}, {86,-1}, {86,0}, {86,1}, {86,2}, {86,3}, {86,4}, {86,5}, {86,6}, {86,7}, {86,8}, {86,9}, {86,10}, {86,11}, {86,12}, {86,13}, {86,14}, {86,15}, {86,16}, {86,17}, {86,18}, {86,19}, {86,20}, {86,21}, {86,22}, {86,23}, {86,24}, {86,25}, {86,26}, {86,27}, {86,28}, {86,29}, {86,30}, {86,31}, {86,32}, {86,33}, {86,34}, {86,35}, {86,36}, {86,37}, {86,38}, {86,39}, {86,40}, {86,41}, {86,42}, {86,43}, {86,44}, {86,45}, {86,46}, {86,47}, {86,48}, {86,49}, {86,50}, {86,51}, {86,52}, {86,53}, {86,54}, {86,55}, {86,93}, {86,94}, {86,148}, {86,149}, {87,-27}, {87,-26}, {87,-25}, {87,-24}, {87,-23}, {87,-22}, {87,-21}, {87,-20}, {87,-19}, {87,-18}, {87,-17}, {87,-16}, {87,-11}, {87,-10}, {87,-9}, {87,-8}, {87,-7}, {87,-6}, {87,-5}, {87,-4}, {87,-3}, {87,-2}, {87,-1}, {87,0}, {87,1}, {87,28}, {87,29}, {87,30}, {87,31}, {87,32}, {87,33}, {87,34}, {87,35}, {87,36}, {87,37}, {87,38}, {87,39}, {87,40}, {87,41}, {87,42}, {87,43}, {87,53}, {87,54}, {87,55}, {87,56}, {87,93}, {87,94}, {87,95}, {87,96}, {87,147}, {87,148}, {87,149}, {88,54}, {88,55}, {88,56}, {88,57}, {88,58}, {88,63}, {88,64}, {88,65}, {88,66}, {88,75}, {88,76}, {88,77}, {88,78}, {88,79}, {88,91}, {88,92}, {88,93}, {88,94}, {88,95}, {88,96}, {88,97}, {88,98}, {88,99}, {88,113}, {88,114}, {88,115}, {88,116}, {88,117}, {88,118}, {88,119}, {88,120}, {88,121}, {88,122}, {88,123}, {88,124}, {88,125}, {88,126}, {88,143}, {88,144}, {88,145}, {88,146}, {88,147}, {88,148}, {88,149}, {89,55}, {89,56}, {89,57}, {89,58}, {89,59}, {89,60}, {89,61}, {89,62}, {89,63}, {89,64}, {89,65}, {89,66}, {89,67}, {89,68}, {89,69}, {89,70}, {89,71}, {89,72}, {89,73}, {89,74}, {89,75}, {89,76}, {89,77}, {89,78}, {89,79}, {89,80}, {89,81}, {89,82}, {89,83}, {89,84}, {89,85}, {89,86}, {89,87}, {89,88}, {89,89}, {89,90}, {89,91}, {89,92}, {89,93}, {89,94}, {89,95}, {89,96}, {89,97}, {89,98}, {89,99}, {89,100}, {89,101}, {89,102}, {89,103}, {89,104}, {89,105}, {89,106}, {89,107}, {89,108}, {89,109}, {89,110}, {89,111}, {89,112}, {89,113}, {89,114}, {89,115}, {89,116}, {89,117}, {89,118}, {89,119}, {89,120}, {89,121}, {89,122}, {89,123}, {89,124}, {89,125}, {89,126}, {89,127}, {89,128}, {89,129}, {89,130}, {89,131}, {89,132}, {89,133}, {89,134}, {89,135}, {89,136}, {89,137}, {89,138}, {89,139}, {89,140}, {89,141}, {89,142}, {89,143}, {89,144}, {89,145}, {89,146}, {89,147}, {89,148}, {89,149}, {89,150}, {89,151}, {90,57}, {90,58}, {90,59}, {90,60}, {90,61}, {90,62}, {90,63}, {90,65}, {90,66}, {90,67}, {90,68}, {90,69}, {90,70}, {90,71}, {90,72}, {90,73}, {90,74}, {90,75}, {90,76}, {90,78}, {90,79}, {90,80}, {90,81}, {90,82}, {90,83}, {90,84}, {90,85}, {90,86}, {90,87}, {90,88}, {90,89}, {90,90}, {90,91}, {90,92}, {90,93}, {90,94}, {90,96}, {90,97}, {90,98}, {90,99}, {90,100}, {90,101}, {90,102}, {90,103}, {90,104}, {90,105}, {90,106}, {90,107}, {90,108}, {90,109}, {90,110}, {90,111}, {90,112}, {90,113}, {90,125}, {90,126}, {90,127}, {90,128}, {90,129}, {90,130}, {90,131}, {90,132}, {90,133}, {90,134}, {90,135}, {90,136}, {90,137}, {90,138}, {90,139}, {90,140}, {90,141}, {90,142}, {90,143}, {90,144}, {90,145}, {90,148}, {90,149}, {90,150}, {90,151}, {91,148}, {91,149}, {91,150}, {91,151}, },
    ["mineral-beige-dirt-5"] = {{-93,-23}, {-93,-22}, {-93,-21}, {-93,-20}, {-93,-19}, {-93,-18}, {-93,-17}, {-93,-16}, {-93,-15}, {-93,-14}, {-93,-13}, {-92,-18}, {-92,-17}, {-92,-16}, {-92,-15}, {-92,-14}, {-92,7}, {-91,-18}, {-91,-17}, {-91,-16}, {-91,-15}, {-91,6}, {-90,-18}, {-90,-17}, {-88,33}, {-88,34}, {-87,39}, {-83,60}, {-82,60}, {-82,61}, {-82,62}, {-81,61}, {-81,62}, {-81,63}, {-4,-19}, {-2,-27}, {-1,-29}, {-1,-28}, {0,-32}, {0,-31}, {0,-30}, {1,-36}, {1,-34}, {1,-33}, {1,-32}, {2,-36}, {2,-35}, {2,-34}, {6,-59}, {6,-58}, {7,-59}, {7,-58}, {7,-57}, {8,-59}, {8,-58}, {8,-57}, {8,-56}, {8,-55}, {9,-57}, {9,-56}, {9,-55}, {9,-54}, {9,-53}, {17,-49}, {17,-48}, {17,-47}, {17,-46}, {17,-45}, {17,-44}, {17,-43}, {17,-42}, {17,-41}, {17,-40}, {17,-39}, {17,-38}, {17,-37}, {17,-36}, {17,-35}, {17,-34}, {17,-33}, {17,-32}, {17,-31}, {17,-30}, {17,-29}, {17,-28}, {17,-27}, {17,-26}, {17,-25}, {18,-37}, {18,-36}, {18,-35}, {18,-34}, {18,-33}, {18,-32}, {18,-31}, {18,-30}, {18,-29}, {18,-28}, {23,148}, {24,148}, {25,147}, {26,147}, {27,146}, {31,147}, {32,147}, {56,-32}, {57,-33}, {57,-32}, {57,-31}, },
    ["concrete"] = {{-93,31}, {-93,32}, {-93,33}, {-93,34}, {-93,35}, {-93,36}, {-93,37}, {-93,38}, {-93,39}, {-92,-27}, {-92,-26}, {-92,-25}, {-92,-24}, {-92,-23}, {-92,-22}, {-92,-21}, {-92,-20}, {-92,-19}, {-92,31}, {-92,32}, {-92,33}, {-92,34}, {-92,35}, {-92,36}, {-92,37}, {-92,38}, {-92,39}, {-91,-27}, {-91,-26}, {-91,-25}, {-91,-24}, {-91,-23}, {-91,-22}, {-91,-21}, {-91,-20}, {-91,-19}, {-91,31}, {-91,32}, {-91,33}, {-91,34}, {-91,35}, {-91,36}, {-91,37}, {-91,38}, {-91,39}, {-90,-27}, {-90,-26}, {-90,-25}, {-90,-24}, {-90,-23}, {-90,-22}, {-90,-21}, {-90,-20}, {-90,-19}, {-87,-10}, {-87,-9}, {-87,-8}, {-87,-7}, {-87,-6}, {-87,-5}, {-87,-4}, {-87,-3}, {-87,-2}, {-87,-1}, {-87,0}, {-87,1}, {-87,2}, {-87,3}, {-87,4}, {-87,5}, {-87,6}, {-87,7}, {-87,8}, {-87,9}, {-87,10}, {-87,11}, {-87,12}, {-87,13}, {-87,14}, {-87,15}, {-87,16}, {-87,17}, {-87,18}, {-87,19}, {-87,20}, {-87,21}, {-87,22}, {-86,-11}, {-86,-10}, {-86,-9}, {-86,-8}, {-86,-5}, {-86,-4}, {-86,-3}, {-86,0}, {-86,1}, {-86,2}, {-86,5}, {-86,6}, {-86,7}, {-86,10}, {-86,11}, {-86,12}, {-86,15}, {-86,16}, {-86,17}, {-86,20}, {-86,21}, {-86,22}, {-86,23}, {-86,53}, {-86,54}, {-86,55}, {-86,56}, {-86,57}, {-85,-11}, {-85,-10}, {-85,-9}, {-85,-8}, {-85,-5}, {-85,-4}, {-85,-3}, {-85,0}, {-85,1}, {-85,2}, {-85,5}, {-85,6}, {-85,7}, {-85,10}, {-85,11}, {-85,12}, {-85,15}, {-85,16}, {-85,17}, {-85,20}, {-85,21}, {-85,22}, {-85,23}, {-85,52}, {-85,53}, {-85,54}, {-85,55}, {-85,56}, {-85,57}, {-85,58}, {-84,-11}, {-84,-10}, {-84,-9}, {-84,-8}, {-84,-7}, {-84,-6}, {-84,-5}, {-84,-4}, {-84,-3}, {-84,-2}, {-84,-1}, {-84,0}, {-84,1}, {-84,2}, {-84,3}, {-84,4}, {-84,5}, {-84,6}, {-84,7}, {-84,8}, {-84,9}, {-84,10}, {-84,11}, {-84,12}, {-84,13}, {-84,14}, {-84,15}, {-84,16}, {-84,17}, {-84,18}, {-84,19}, {-84,20}, {-84,21}, {-84,22}, {-84,23}, {-84,52}, {-84,55}, {-84,57}, {-84,94}, {-84,95}, {-83,-11}, {-83,-10}, {-83,-9}, {-83,-8}, {-83,-7}, {-83,-6}, {-83,-5}, {-83,-4}, {-83,-3}, {-83,-2}, {-83,-1}, {-83,0}, {-83,1}, {-83,2}, {-83,3}, {-83,4}, {-83,5}, {-83,6}, {-83,7}, {-83,8}, {-83,9}, {-83,10}, {-83,11}, {-83,12}, {-83,13}, {-83,14}, {-83,15}, {-83,16}, {-83,17}, {-83,18}, {-83,19}, {-83,20}, {-83,21}, {-83,22}, {-83,23}, {-83,24}, {-83,51}, {-83,52}, {-83,94}, {-83,95}, {-82,-11}, {-82,-10}, {-82,-9}, {-82,-8}, {-82,-7}, {-82,-6}, {-82,-5}, {-82,-4}, {-82,-3}, {-82,-2}, {-82,-1}, {-82,0}, {-82,1}, {-82,2}, {-82,3}, {-82,4}, {-82,5}, {-82,6}, {-82,7}, {-82,8}, {-82,9}, {-82,10}, {-82,11}, {-82,12}, {-82,13}, {-82,14}, {-82,15}, {-82,16}, {-82,17}, {-82,18}, {-82,19}, {-82,20}, {-82,21}, {-82,22}, {-82,23}, {-82,51}, {-82,52}, {-82,94}, {-82,95}, {-81,-11}, {-81,-10}, {-81,-9}, {-81,-8}, {-81,-5}, {-81,-4}, {-81,-3}, {-81,0}, {-81,1}, {-81,2}, {-81,5}, {-81,6}, {-81,7}, {-81,10}, {-81,11}, {-81,12}, {-81,15}, {-81,16}, {-81,17}, {-81,20}, {-81,21}, {-81,22}, {-81,23}, {-81,51}, {-81,52}, {-81,69}, {-81,70}, {-81,71}, {-81,73}, {-81,74}, {-81,75}, {-81,76}, {-81,77}, {-81,78}, {-81,79}, {-81,80}, {-81,81}, {-81,82}, {-81,83}, {-81,84}, {-81,85}, {-81,86}, {-81,87}, {-81,88}, {-81,89}, {-81,90}, {-81,92}, {-81,93}, {-81,94}, {-81,95}, {-80,-11}, {-80,-10}, {-80,-9}, {-80,-8}, {-80,-5}, {-80,-4}, {-80,-3}, {-80,0}, {-80,1}, {-80,2}, {-80,5}, {-80,6}, {-80,7}, {-80,10}, {-80,11}, {-80,12}, {-80,15}, {-80,16}, {-80,17}, {-80,20}, {-80,21}, {-80,22}, {-80,23}, {-80,51}, {-80,52}, {-80,69}, {-80,70}, {-80,71}, {-80,73}, {-80,74}, {-80,75}, {-80,76}, {-80,77}, {-80,78}, {-80,79}, {-80,80}, {-80,81}, {-80,82}, {-80,83}, {-80,84}, {-80,85}, {-80,86}, {-80,87}, {-80,88}, {-80,89}, {-80,90}, {-80,92}, {-80,93}, {-80,94}, {-80,95}, {-80,115}, {-80,116}, {-80,117}, {-79,-11}, {-79,-10}, {-79,-9}, {-79,-8}, {-79,-7}, {-79,-6}, {-79,-5}, {-79,-4}, {-79,-3}, {-79,-2}, {-79,-1}, {-79,0}, {-79,1}, {-79,2}, {-79,3}, {-79,4}, {-79,5}, {-79,6}, {-79,7}, {-79,8}, {-79,9}, {-79,10}, {-79,11}, {-79,12}, {-79,13}, {-79,14}, {-79,15}, {-79,16}, {-79,17}, {-79,18}, {-79,19}, {-79,20}, {-79,21}, {-79,22}, {-79,23}, {-79,69}, {-79,70}, {-79,93}, {-79,94}, {-79,95}, {-79,115}, {-79,116}, {-79,117}, {-78,-11}, {-78,-10}, {-78,-9}, {-78,-8}, {-78,-7}, {-78,-6}, {-78,-5}, {-78,-4}, {-78,-3}, {-78,-2}, {-78,-1}, {-78,0}, {-78,1}, {-78,2}, {-78,3}, {-78,4}, {-78,5}, {-78,6}, {-78,7}, {-78,8}, {-78,9}, {-78,10}, {-78,11}, {-78,12}, {-78,13}, {-78,14}, {-78,15}, {-78,16}, {-78,17}, {-78,18}, {-78,19}, {-78,20}, {-78,21}, {-78,22}, {-78,23}, {-78,68}, {-78,69}, {-78,70}, {-78,93}, {-78,94}, {-78,95}, {-78,115}, {-78,116}, {-78,117}, {-77,-11}, {-77,-10}, {-77,-9}, {-77,-8}, {-77,-7}, {-77,-6}, {-77,-5}, {-77,-4}, {-77,-3}, {-77,-2}, {-77,-1}, {-77,0}, {-77,1}, {-77,2}, {-77,3}, {-77,4}, {-77,5}, {-77,6}, {-77,7}, {-77,8}, {-77,9}, {-77,10}, {-77,11}, {-77,12}, {-77,13}, {-77,14}, {-77,15}, {-77,16}, {-77,17}, {-77,18}, {-77,19}, {-77,20}, {-77,21}, {-77,22}, {-77,23}, {-77,24}, {-77,68}, {-77,69}, {-77,70}, {-77,93}, {-77,94}, {-77,95}, {-77,114}, {-77,115}, {-77,116}, {-77,117}, {-76,-11}, {-76,-10}, {-76,-9}, {-76,-8}, {-76,-7}, {-76,-6}, {-76,-5}, {-76,-4}, {-76,-3}, {-76,-2}, {-76,-1}, {-76,0}, {-76,1}, {-76,2}, {-76,3}, {-76,4}, {-76,5}, {-76,6}, {-76,7}, {-76,8}, {-76,9}, {-76,10}, {-76,11}, {-76,12}, {-76,13}, {-76,14}, {-76,15}, {-76,16}, {-76,17}, {-76,18}, {-76,19}, {-76,20}, {-76,21}, {-76,22}, {-76,23}, {-76,41}, {-76,42}, {-76,69}, {-76,70}, {-76,93}, {-76,94}, {-76,95}, {-76,115}, {-76,116}, {-76,117}, {-76,120}, {-76,121}, {-76,122}, {-76,123}, {-76,124}, {-75,5}, {-75,6}, {-75,7}, {-75,68}, {-75,69}, {-75,70}, {-75,93}, {-75,94}, {-75,95}, {-75,115}, {-75,116}, {-75,117}, {-75,120}, {-75,121}, {-75,122}, {-75,123}, {-75,124}, {-74,68}, {-74,69}, {-74,70}, {-74,93}, {-74,94}, {-74,95}, {-74,115}, {-74,116}, {-74,117}, {-74,120}, {-74,121}, {-74,122}, {-74,123}, {-74,124}, {-73,-22}, {-73,-16}, {-73,68}, {-73,69}, {-73,70}, {-73,93}, {-73,94}, {-73,95}, {-73,115}, {-73,116}, {-73,117}, {-73,120}, {-73,121}, {-73,122}, {-73,123}, {-73,124}, {-72,-26}, {-72,-25}, {-72,-24}, {-72,-23}, {-72,-22}, {-72,-21}, {-72,-20}, {-72,-19}, {-72,-18}, {-72,-17}, {-72,-16}, {-72,-15}, {-72,68}, {-72,69}, {-72,70}, {-72,93}, {-72,94}, {-72,95}, {-72,115}, {-72,116}, {-72,117}, {-72,120}, {-72,121}, {-72,122}, {-72,123}, {-72,124}, {-71,-26}, {-71,-25}, {-71,-24}, {-71,-23}, {-71,-22}, {-71,-21}, {-71,-20}, {-71,-19}, {-71,-18}, {-71,-17}, {-71,-16}, {-71,-15}, {-71,68}, {-71,69}, {-71,70}, {-71,93}, {-71,94}, {-71,95}, {-71,115}, {-71,116}, {-71,117}, {-71,120}, {-71,121}, {-71,122}, {-71,123}, {-71,124}, {-70,-26}, {-70,-25}, {-70,-24}, {-70,-23}, {-70,-22}, {-70,-21}, {-70,-20}, {-70,-19}, {-70,-18}, {-70,-17}, {-70,-16}, {-70,-15}, {-70,68}, {-70,69}, {-70,70}, {-70,93}, {-70,94}, {-70,95}, {-70,115}, {-70,116}, {-70,117}, {-70,120}, {-70,121}, {-70,122}, {-70,123}, {-70,124}, {-69,-26}, {-69,-25}, {-69,-24}, {-69,-23}, {-69,-22}, {-69,-21}, {-69,-20}, {-69,-19}, {-69,-18}, {-69,-17}, {-69,-16}, {-69,-15}, {-69,68}, {-69,69}, {-69,70}, {-69,93}, {-69,94}, {-69,95}, {-69,115}, {-69,116}, {-69,117}, {-69,120}, {-69,121}, {-69,122}, {-69,123}, {-69,124}, {-68,-26}, {-68,-23}, {-68,-22}, {-68,-21}, {-68,-18}, {-68,-17}, {-68,-16}, {-68,-15}, {-68,41}, {-68,68}, {-68,69}, {-68,70}, {-68,93}, {-68,94}, {-68,95}, {-68,115}, {-68,116}, {-68,117}, {-68,120}, {-68,121}, {-68,122}, {-68,123}, {-68,124}, {-67,-26}, {-67,-23}, {-67,-22}, {-67,-21}, {-67,-18}, {-67,-17}, {-67,-16}, {-67,-15}, {-67,68}, {-67,69}, {-67,70}, {-67,93}, {-67,94}, {-67,95}, {-67,115}, {-67,116}, {-67,117}, {-67,120}, {-67,121}, {-67,122}, {-67,123}, {-67,124}, {-66,-26}, {-66,-25}, {-66,-24}, {-66,-23}, {-66,-22}, {-66,-21}, {-66,-20}, {-66,-19}, {-66,-18}, {-66,-17}, {-66,-16}, {-66,-15}, {-66,69}, {-66,70}, {-66,93}, {-66,94}, {-66,95}, {-66,115}, {-66,116}, {-66,117}, {-65,-26}, {-65,-25}, {-65,-24}, {-65,-23}, {-65,-22}, {-65,-21}, {-65,-20}, {-65,-19}, {-65,-18}, {-65,-17}, {-65,-16}, {-65,-15}, {-65,68}, {-65,69}, {-65,70}, {-65,93}, {-65,94}, {-65,95}, {-65,116}, {-64,-26}, {-64,-25}, {-64,-24}, {-64,-23}, {-64,-22}, {-64,-21}, {-64,-20}, {-64,-19}, {-64,-18}, {-64,-17}, {-64,-16}, {-64,-15}, {-64,68}, {-64,69}, {-64,70}, {-64,71}, {-64,73}, {-64,74}, {-64,75}, {-64,76}, {-64,77}, {-64,78}, {-64,79}, {-64,80}, {-64,81}, {-64,82}, {-64,83}, {-64,84}, {-64,85}, {-64,86}, {-64,87}, {-64,88}, {-64,89}, {-64,90}, {-64,92}, {-64,93}, {-64,94}, {-64,95}, {-63,-26}, {-63,-23}, {-63,-22}, {-63,-21}, {-63,-18}, {-63,-17}, {-63,-16}, {-63,-15}, {-63,69}, {-63,70}, {-63,71}, {-63,73}, {-63,74}, {-63,75}, {-63,76}, {-63,77}, {-63,78}, {-63,79}, {-63,80}, {-63,81}, {-63,82}, {-63,83}, {-63,84}, {-63,85}, {-63,86}, {-63,87}, {-63,88}, {-63,89}, {-63,90}, {-63,92}, {-63,93}, {-63,94}, {-63,95}, {-62,-26}, {-62,-23}, {-62,-22}, {-62,-21}, {-62,-18}, {-62,-17}, {-62,-16}, {-62,-15}, {-62,81}, {-62,82}, {-62,94}, {-62,95}, {-61,-26}, {-61,-25}, {-61,-24}, {-61,-23}, {-61,-22}, {-61,-21}, {-61,-20}, {-61,-19}, {-61,-18}, {-61,-17}, {-61,-16}, {-61,-15}, {-61,-14}, {-61,37}, {-61,42}, {-61,54}, {-61,55}, {-61,57}, {-61,58}, {-61,59}, {-61,60}, {-61,61}, {-61,62}, {-61,63}, {-61,65}, {-61,66}, {-61,67}, {-61,68}, {-61,69}, {-61,70}, {-61,71}, {-60,-26}, {-60,-25}, {-60,-24}, {-60,-23}, {-60,-22}, {-60,-21}, {-60,-20}, {-60,-19}, {-60,-18}, {-60,-17}, {-60,-16}, {-60,-15}, {-60,-14}, {-60,25}, {-60,42}, {-60,53}, {-60,54}, {-60,55}, {-60,57}, {-60,58}, {-60,59}, {-60,60}, {-60,61}, {-60,62}, {-60,63}, {-60,65}, {-60,66}, {-60,67}, {-60,68}, {-60,69}, {-60,70}, {-60,71}, {-59,-26}, {-59,-25}, {-59,-24}, {-59,-23}, {-59,-22}, {-59,-21}, {-59,-20}, {-59,-19}, {-59,-18}, {-59,-17}, {-59,-16}, {-59,-15}, {-59,-14}, {-59,42}, {-59,43}, {-59,52}, {-59,53}, {-59,54}, {-59,55}, {-59,57}, {-59,58}, {-59,59}, {-59,60}, {-59,61}, {-59,62}, {-59,63}, {-59,65}, {-59,66}, {-59,67}, {-59,68}, {-59,69}, {-59,70}, {-59,71}, {-58,-26}, {-58,-23}, {-58,-22}, {-58,-21}, {-58,-18}, {-58,-17}, {-58,-16}, {-58,-15}, {-58,42}, {-58,43}, {-58,44}, {-58,51}, {-58,52}, {-58,53}, {-58,54}, {-58,55}, {-58,57}, {-58,58}, {-58,59}, {-58,60}, {-58,61}, {-58,62}, {-58,63}, {-58,65}, {-58,66}, {-58,67}, {-58,68}, {-58,69}, {-58,70}, {-58,71}, {-57,-26}, {-57,-23}, {-57,-22}, {-57,-21}, {-57,-18}, {-57,-17}, {-57,-16}, {-57,-15}, {-57,42}, {-57,43}, {-57,44}, {-57,45}, {-57,47}, {-57,48}, {-57,49}, {-57,50}, {-57,51}, {-57,52}, {-57,53}, {-57,54}, {-57,66}, {-57,67}, {-57,68}, {-57,69}, {-57,70}, {-57,71}, {-56,-26}, {-56,-25}, {-56,-24}, {-56,-23}, {-56,-22}, {-56,-21}, {-56,-20}, {-56,-19}, {-56,-18}, {-56,-17}, {-56,-16}, {-56,-15}, {-56,42}, {-56,43}, {-56,44}, {-56,45}, {-56,47}, {-56,48}, {-56,49}, {-56,50}, {-56,51}, {-56,52}, {-56,53}, {-56,67}, {-56,68}, {-56,69}, {-56,70}, {-56,71}, {-56,72}, {-55,-26}, {-55,-25}, {-55,-24}, {-55,-23}, {-55,-22}, {-55,-21}, {-55,-20}, {-55,-19}, {-55,-18}, {-55,-17}, {-55,-16}, {-55,-15}, {-55,42}, {-55,43}, {-55,44}, {-55,45}, {-55,47}, {-55,48}, {-55,49}, {-55,50}, {-55,51}, {-55,52}, {-55,68}, {-55,69}, {-55,70}, {-55,71}, {-55,72}, {-55,73}, {-54,-26}, {-54,-25}, {-54,-24}, {-54,-23}, {-54,-22}, {-54,-21}, {-54,-20}, {-54,-19}, {-54,-18}, {-54,-17}, {-54,-16}, {-54,-15}, {-54,42}, {-54,43}, {-54,44}, {-54,45}, {-54,47}, {-54,48}, {-54,49}, {-54,50}, {-54,51}, {-54,69}, {-54,70}, {-54,71}, {-54,72}, {-54,73}, {-53,-26}, {-53,-23}, {-53,-22}, {-53,-21}, {-53,-18}, {-53,-17}, {-53,-16}, {-53,-15}, {-53,42}, {-53,43}, {-53,44}, {-53,45}, {-53,47}, {-53,48}, {-53,49}, {-53,50}, {-53,70}, {-53,71}, {-53,72}, {-52,-26}, {-52,-23}, {-52,-22}, {-52,-21}, {-52,-18}, {-52,-17}, {-52,-16}, {-52,-15}, {-52,42}, {-52,43}, {-52,44}, {-52,45}, {-52,47}, {-52,48}, {-52,49}, {-52,71}, {-52,72}, {-52,75}, {-52,81}, {-52,82}, {-52,92}, {-51,-26}, {-51,-25}, {-51,-24}, {-51,-23}, {-51,-22}, {-51,-21}, {-51,-20}, {-51,-19}, {-51,-18}, {-51,-17}, {-51,-16}, {-51,-15}, {-51,-14}, {-51,42}, {-51,43}, {-51,44}, {-51,45}, {-51,71}, {-51,72}, {-51,75}, {-51,81}, {-51,82}, {-51,92}, {-50,-26}, {-50,-25}, {-50,-24}, {-50,-23}, {-50,-22}, {-50,-21}, {-50,-20}, {-50,-19}, {-50,-18}, {-50,-17}, {-50,-16}, {-50,-15}, {-50,-14}, {-50,25}, {-50,42}, {-50,43}, {-50,44}, {-50,45}, {-50,47}, {-50,48}, {-50,49}, {-50,71}, {-50,72}, {-50,73}, {-50,75}, {-50,81}, {-50,82}, {-50,92}, {-49,-26}, {-49,-25}, {-49,-24}, {-49,-23}, {-49,-22}, {-49,-21}, {-49,-20}, {-49,-19}, {-49,-18}, {-49,-17}, {-49,-16}, {-49,-15}, {-49,-14}, {-49,37}, {-49,42}, {-49,43}, {-49,44}, {-49,45}, {-49,47}, {-49,48}, {-49,49}, {-49,71}, {-49,72}, {-49,75}, {-49,92}, {-48,-26}, {-48,-23}, {-48,-22}, {-48,-21}, {-48,-18}, {-48,-17}, {-48,-16}, {-48,-15}, {-48,42}, {-48,43}, {-48,44}, {-48,45}, {-48,47}, {-48,48}, {-48,49}, {-48,74}, {-48,75}, {-48,81}, {-48,82}, {-48,92}, {-47,-26}, {-47,-23}, {-47,-22}, {-47,-21}, {-47,-18}, {-47,-17}, {-47,-16}, {-47,-15}, {-47,42}, {-47,43}, {-47,44}, {-47,45}, {-47,47}, {-47,48}, {-47,49}, {-47,69}, {-47,80}, {-47,81}, {-47,82}, {-47,83}, {-47,92}, {-46,-26}, {-46,-25}, {-46,-24}, {-46,-23}, {-46,-22}, {-46,-21}, {-46,-20}, {-46,-19}, {-46,-18}, {-46,-17}, {-46,-16}, {-46,-15}, {-46,42}, {-46,43}, {-46,44}, {-46,45}, {-46,47}, {-46,48}, {-46,49}, {-46,68}, {-46,75}, {-46,76}, {-46,77}, {-46,79}, {-46,80}, {-46,81}, {-46,82}, {-46,83}, {-46,84}, {-46,86}, {-46,87}, {-46,88}, {-46,89}, {-46,91}, {-46,92}, {-45,-26}, {-45,-25}, {-45,-24}, {-45,-23}, {-45,-22}, {-45,-21}, {-45,-20}, {-45,-19}, {-45,-18}, {-45,-17}, {-45,-16}, {-45,-15}, {-45,42}, {-45,43}, {-45,44}, {-45,45}, {-45,47}, {-45,48}, {-45,49}, {-45,68}, {-45,75}, {-45,76}, {-45,77}, {-45,79}, {-45,80}, {-45,81}, {-45,82}, {-45,83}, {-45,84}, {-45,86}, {-45,87}, {-45,88}, {-45,89}, {-45,91}, {-45,92}, {-44,-26}, {-44,-25}, {-44,-24}, {-44,-23}, {-44,-22}, {-44,-21}, {-44,-20}, {-44,-19}, {-44,-18}, {-44,-17}, {-44,-16}, {-44,-15}, {-44,42}, {-44,43}, {-44,44}, {-44,45}, {-44,47}, {-44,48}, {-44,49}, {-44,68}, {-44,75}, {-44,76}, {-44,77}, {-44,79}, {-44,80}, {-44,81}, {-44,82}, {-44,83}, {-44,84}, {-44,86}, {-44,87}, {-44,88}, {-44,89}, {-44,91}, {-44,92}, {-43,-26}, {-43,-23}, {-43,-22}, {-43,-21}, {-43,-18}, {-43,-17}, {-43,-16}, {-43,-15}, {-43,42}, {-43,43}, {-43,44}, {-43,45}, {-43,47}, {-43,48}, {-43,49}, {-43,69}, {-43,80}, {-43,81}, {-43,82}, {-43,83}, {-43,92}, {-42,-26}, {-42,-23}, {-42,-22}, {-42,-21}, {-42,-18}, {-42,-17}, {-42,-16}, {-42,-15}, {-42,42}, {-42,43}, {-42,44}, {-42,45}, {-42,47}, {-42,48}, {-42,49}, {-42,74}, {-42,75}, {-42,81}, {-42,82}, {-42,92}, {-41,-26}, {-41,-25}, {-41,-24}, {-41,-23}, {-41,-22}, {-41,-21}, {-41,-20}, {-41,-19}, {-41,-18}, {-41,-17}, {-41,-16}, {-41,-15}, {-41,42}, {-41,43}, {-41,44}, {-41,45}, {-41,47}, {-41,48}, {-41,49}, {-41,71}, {-41,72}, {-41,75}, {-41,92}, {-40,-26}, {-40,-25}, {-40,-24}, {-40,-23}, {-40,-22}, {-40,-21}, {-40,-20}, {-40,-19}, {-40,-18}, {-40,-17}, {-40,-16}, {-40,-15}, {-40,42}, {-40,43}, {-40,44}, {-40,45}, {-40,47}, {-40,48}, {-40,49}, {-40,71}, {-40,72}, {-40,73}, {-40,75}, {-40,81}, {-40,82}, {-40,92}, {-39,-26}, {-39,-25}, {-39,-24}, {-39,-23}, {-39,-22}, {-39,-21}, {-39,-20}, {-39,-19}, {-39,-18}, {-39,-17}, {-39,-16}, {-39,-15}, {-39,71}, {-39,72}, {-39,75}, {-39,81}, {-39,82}, {-39,92}, {-38,-26}, {-38,-25}, {-38,-24}, {-38,-23}, {-38,-22}, {-38,-21}, {-38,-20}, {-38,-19}, {-38,-18}, {-38,-17}, {-38,-16}, {-38,-15}, {-38,46}, {-38,47}, {-38,48}, {-38,49}, {-38,71}, {-38,72}, {-38,81}, {-38,82}, {-38,92}, {-37,-22}, {-37,-16}, {-37,46}, {-37,47}, {-37,48}, {-37,49}, {-37,50}, {-37,70}, {-37,71}, {-37,72}, {-37,81}, {-37,82}, {-36,47}, {-36,48}, {-36,49}, {-36,50}, {-36,51}, {-36,69}, {-36,70}, {-36,71}, {-36,72}, {-35,5}, {-35,6}, {-35,7}, {-35,8}, {-35,9}, {-35,10}, {-35,11}, {-35,12}, {-35,13}, {-35,14}, {-35,15}, {-35,16}, {-35,17}, {-35,18}, {-35,19}, {-35,20}, {-35,21}, {-35,22}, {-35,23}, {-35,48}, {-35,49}, {-35,50}, {-35,51}, {-35,52}, {-35,68}, {-35,69}, {-35,70}, {-35,71}, {-35,72}, {-34,-11}, {-34,-10}, {-34,-9}, {-34,-8}, {-34,-7}, {-34,-6}, {-34,-5}, {-34,-4}, {-34,-3}, {-34,-2}, {-34,-1}, {-34,0}, {-34,1}, {-34,2}, {-34,3}, {-34,4}, {-34,5}, {-34,6}, {-34,7}, {-34,8}, {-34,9}, {-34,10}, {-34,11}, {-34,12}, {-34,13}, {-34,14}, {-34,15}, {-34,16}, {-34,17}, {-34,18}, {-34,19}, {-34,20}, {-34,21}, {-34,22}, {-34,23}, {-34,49}, {-34,50}, {-34,51}, {-34,52}, {-34,53}, {-34,67}, {-34,68}, {-34,69}, {-34,70}, {-34,71}, {-34,72}, {-33,-11}, {-33,-10}, {-33,-9}, {-33,-8}, {-33,-7}, {-33,-6}, {-33,-5}, {-33,-4}, {-33,-3}, {-33,-2}, {-33,-1}, {-33,0}, {-33,1}, {-33,2}, {-33,3}, {-33,4}, {-33,5}, {-33,6}, {-33,7}, {-33,8}, {-33,9}, {-33,10}, {-33,11}, {-33,12}, {-33,13}, {-33,14}, {-33,15}, {-33,16}, {-33,17}, {-33,18}, {-33,19}, {-33,20}, {-33,21}, {-33,22}, {-33,23}, {-33,24}, {-33,50}, {-33,51}, {-33,52}, {-33,53}, {-33,54}, {-33,66}, {-33,67}, {-33,68}, {-33,69}, {-33,70}, {-33,71}, {-33,72}, {-32,-11}, {-32,-10}, {-32,-9}, {-32,-8}, {-32,-7}, {-32,-6}, {-32,-5}, {-32,-4}, {-32,-3}, {-32,-2}, {-32,-1}, {-32,0}, {-32,1}, {-32,2}, {-32,3}, {-32,4}, {-32,5}, {-32,6}, {-32,7}, {-32,8}, {-32,9}, {-32,10}, {-32,11}, {-32,12}, {-32,13}, {-32,14}, {-32,15}, {-32,16}, {-32,17}, {-32,18}, {-32,19}, {-32,20}, {-32,21}, {-32,22}, {-32,23}, {-32,51}, {-32,52}, {-32,53}, {-32,54}, {-32,55}, {-32,57}, {-32,58}, {-32,59}, {-32,60}, {-32,61}, {-32,62}, {-32,63}, {-32,65}, {-32,66}, {-32,67}, {-32,68}, {-32,69}, {-32,70}, {-32,71}, {-32,72}, {-32,73}, {-31,-11}, {-31,-10}, {-31,-9}, {-31,-8}, {-31,-7}, {-31,-6}, {-31,-5}, {-31,-4}, {-31,-3}, {-31,-2}, {-31,-1}, {-31,0}, {-31,1}, {-31,2}, {-31,3}, {-31,4}, {-31,5}, {-31,6}, {-31,7}, {-31,8}, {-31,9}, {-31,10}, {-31,11}, {-31,12}, {-31,13}, {-31,14}, {-31,15}, {-31,16}, {-31,17}, {-31,18}, {-31,19}, {-31,20}, {-31,21}, {-31,22}, {-31,23}, {-31,52}, {-31,53}, {-31,54}, {-31,55}, {-31,57}, {-31,58}, {-31,59}, {-31,60}, {-31,61}, {-31,62}, {-31,63}, {-31,65}, {-31,66}, {-31,67}, {-31,68}, {-31,69}, {-31,70}, {-31,71}, {-31,72}, {-31,73}, {-30,-11}, {-30,-10}, {-30,-9}, {-30,-8}, {-30,-5}, {-30,-4}, {-30,-3}, {-30,0}, {-30,1}, {-30,2}, {-30,5}, {-30,6}, {-30,7}, {-30,10}, {-30,11}, {-30,12}, {-30,15}, {-30,16}, {-30,17}, {-30,20}, {-30,21}, {-30,22}, {-30,23}, {-30,72}, {-30,73}, {-29,-11}, {-29,-10}, {-29,-9}, {-29,-8}, {-29,-5}, {-29,-4}, {-29,-3}, {-29,0}, {-29,1}, {-29,2}, {-29,5}, {-29,6}, {-29,7}, {-29,10}, {-29,11}, {-29,12}, {-29,15}, {-29,16}, {-29,17}, {-29,20}, {-29,21}, {-29,22}, {-29,23}, {-29,72}, {-29,73}, {-29,116}, {-28,-11}, {-28,-10}, {-28,-9}, {-28,-8}, {-28,-7}, {-28,-6}, {-28,-5}, {-28,-4}, {-28,-3}, {-28,-2}, {-28,-1}, {-28,0}, {-28,1}, {-28,2}, {-28,3}, {-28,4}, {-28,5}, {-28,6}, {-28,7}, {-28,8}, {-28,9}, {-28,10}, {-28,11}, {-28,12}, {-28,13}, {-28,14}, {-28,15}, {-28,16}, {-28,17}, {-28,18}, {-28,19}, {-28,20}, {-28,21}, {-28,22}, {-28,23}, {-28,72}, {-28,73}, {-28,116}, {-28,117}, {-28,118}, {-27,-11}, {-27,-10}, {-27,-9}, {-27,-8}, {-27,-7}, {-27,-6}, {-27,-5}, {-27,-4}, {-27,-3}, {-27,-2}, {-27,-1}, {-27,0}, {-27,1}, {-27,2}, {-27,3}, {-27,4}, {-27,5}, {-27,6}, {-27,7}, {-27,8}, {-27,9}, {-27,10}, {-27,11}, {-27,12}, {-27,13}, {-27,14}, {-27,15}, {-27,16}, {-27,17}, {-27,18}, {-27,19}, {-27,20}, {-27,21}, {-27,22}, {-27,23}, {-27,24}, {-27,72}, {-27,73}, {-27,116}, {-27,117}, {-27,118}, {-26,-11}, {-26,-10}, {-26,-9}, {-26,-8}, {-26,-7}, {-26,-6}, {-26,-5}, {-26,-4}, {-26,-3}, {-26,-2}, {-26,-1}, {-26,0}, {-26,1}, {-26,2}, {-26,3}, {-26,4}, {-26,5}, {-26,6}, {-26,7}, {-26,8}, {-26,9}, {-26,10}, {-26,11}, {-26,12}, {-26,13}, {-26,14}, {-26,15}, {-26,16}, {-26,17}, {-26,18}, {-26,19}, {-26,20}, {-26,21}, {-26,22}, {-26,23}, {-26,72}, {-26,73}, {-26,81}, {-26,82}, {-26,116}, {-26,117}, {-26,140}, {-26,141}, {-26,142}, {-26,143}, {-26,144}, {-26,146}, {-25,-11}, {-25,-10}, {-25,-9}, {-25,-8}, {-25,-5}, {-25,-4}, {-25,-3}, {-25,0}, {-25,1}, {-25,2}, {-25,5}, {-25,6}, {-25,7}, {-25,10}, {-25,11}, {-25,12}, {-25,15}, {-25,16}, {-25,17}, {-25,20}, {-25,21}, {-25,22}, {-25,23}, {-25,72}, {-25,73}, {-25,79}, {-25,80}, {-25,81}, {-25,82}, {-25,83}, {-25,84}, {-25,116}, {-25,117}, {-25,140}, {-25,141}, {-25,142}, {-25,143}, {-25,144}, {-25,146}, {-24,-11}, {-24,-10}, {-24,-9}, {-24,-8}, {-24,-5}, {-24,-4}, {-24,-3}, {-24,0}, {-24,1}, {-24,2}, {-24,5}, {-24,6}, {-24,7}, {-24,10}, {-24,11}, {-24,12}, {-24,15}, {-24,16}, {-24,17}, {-24,20}, {-24,21}, {-24,22}, {-24,23}, {-24,72}, {-24,73}, {-24,74}, {-24,79}, {-24,80}, {-24,81}, {-24,82}, {-24,83}, {-24,84}, {-24,116}, {-24,117}, {-24,140}, {-24,146}, {-23,-10}, {-23,-9}, {-23,-8}, {-23,-7}, {-23,-6}, {-23,-5}, {-23,-4}, {-23,-3}, {-23,-2}, {-23,-1}, {-23,0}, {-23,1}, {-23,2}, {-23,3}, {-23,4}, {-23,5}, {-23,6}, {-23,7}, {-23,8}, {-23,9}, {-23,10}, {-23,11}, {-23,12}, {-23,13}, {-23,14}, {-23,15}, {-23,16}, {-23,17}, {-23,18}, {-23,19}, {-23,20}, {-23,21}, {-23,22}, {-23,23}, {-23,72}, {-23,73}, {-23,74}, {-23,116}, {-23,117}, {-23,140}, {-23,141}, {-23,142}, {-23,143}, {-23,144}, {-23,145}, {-23,146}, {-22,72}, {-22,73}, {-22,74}, {-22,75}, {-22,76}, {-22,77}, {-22,78}, {-22,79}, {-22,80}, {-22,81}, {-22,82}, {-22,83}, {-22,84}, {-22,85}, {-22,86}, {-22,87}, {-22,88}, {-22,89}, {-22,90}, {-22,91}, {-22,92}, {-22,93}, {-22,94}, {-22,95}, {-22,96}, {-22,97}, {-22,98}, {-22,99}, {-22,100}, {-22,101}, {-22,102}, {-22,103}, {-22,104}, {-22,105}, {-22,106}, {-22,107}, {-22,108}, {-22,109}, {-22,110}, {-22,111}, {-22,112}, {-22,113}, {-22,114}, {-22,115}, {-22,116}, {-22,117}, {-22,146}, {-21,72}, {-21,73}, {-21,74}, {-21,75}, {-21,76}, {-21,77}, {-21,78}, {-21,79}, {-21,80}, {-21,81}, {-21,82}, {-21,83}, {-21,84}, {-21,85}, {-21,86}, {-21,87}, {-21,88}, {-21,89}, {-21,90}, {-21,91}, {-21,92}, {-21,93}, {-21,94}, {-21,95}, {-21,96}, {-21,97}, {-21,98}, {-21,99}, {-21,100}, {-21,101}, {-21,102}, {-21,103}, {-21,104}, {-21,105}, {-21,106}, {-21,107}, {-21,108}, {-21,109}, {-21,110}, {-21,111}, {-21,112}, {-21,113}, {-21,114}, {-21,115}, {-21,116}, {-21,117}, {-20,72}, {-20,73}, {-20,74}, {-20,81}, {-20,82}, {-19,72}, {-19,73}, {-19,74}, {-19,81}, {-19,82}, {-18,72}, {-18,73}, {-18,74}, {-18,81}, {-18,82}, {-17,72}, {-17,73}, {-17,74}, {-17,81}, {-17,82}, {-16,72}, {-16,73}, {-16,74}, {-16,81}, {-16,82}, {-15,62}, {-15,64}, {-15,65}, {-15,67}, {-15,72}, {-15,73}, {-15,74}, {-15,81}, {-15,82}, {-14,72}, {-14,73}, {-14,74}, {-14,81}, {-14,82}, {-13,72}, {-13,73}, {-13,74}, {-13,81}, {-13,82}, {-12,72}, {-12,73}, {-12,74}, {-12,81}, {-12,82}, {-11,72}, {-11,73}, {-11,74}, {-11,81}, {-11,82}, {-10,32}, {-10,72}, {-10,73}, {-10,74}, {-10,81}, {-10,82}, {-9,32}, {-9,42}, {-9,56}, {-9,68}, {-9,72}, {-9,73}, {-9,74}, {-9,81}, {-9,82}, {-8,32}, {-8,42}, {-8,56}, {-8,68}, {-8,72}, {-8,73}, {-8,74}, {-8,81}, {-8,82}, {-7,32}, {-7,72}, {-7,73}, {-7,74}, {-7,81}, {-7,82}, {-6,72}, {-6,73}, {-6,74}, {-6,81}, {-6,82}, {-5,74}, {-5,81}, {-5,82}, {-4,81}, {-4,82}, {-3,78}, {-3,79}, {-3,80}, {-3,81}, {-2,48}, {-2,49}, {-2,62}, {-2,64}, {-2,65}, {-2,67}, {-2,78}, {-2,79}, {-2,80}, {-1,48}, {-1,49}, {3,53}, {4,53}, {5,53}, {12,75}, {12,85}, {13,75}, {13,85}, {14,75}, {14,85}, {15,15}, {15,16}, {15,31}, {15,32}, {16,15}, {16,16}, {16,31}, {16,32}, {16,57}, {16,58}, {16,59}, {16,60}, {16,61}, {16,75}, {16,76}, {16,77}, {16,78}, {16,79}, {16,80}, {16,81}, {16,82}, {16,83}, {16,84}, {16,85}, {16,91}, {17,57}, {17,58}, {17,59}, {17,60}, {17,61}, {18,57}, {18,58}, {18,59}, {18,60}, {18,61}, {18,75}, {18,85}, {19,57}, {19,58}, {19,59}, {19,60}, {19,61}, {19,75}, {19,85}, {20,57}, {20,58}, {20,59}, {20,60}, {20,61}, {20,75}, {20,85}, {21,-7}, {22,-7}, {22,57}, {25,-7}, {26,-7}, {26,50}, {26,51}, {26,55}, {29,-7}, {29,2}, {29,46}, {30,-7}, {30,2}, {30,46}, {33,-7}, {34,-7}, {36,-66}, {36,-43}, {37,-66}, {37,-43}, {37,-7}, {38,-66}, {38,-43}, {38,-7}, {39,-66}, {39,-43}, {41,-7}, {42,-7}, {45,-7}, {45,2}, {45,46}, {46,-7}, {46,2}, {46,46}, {49,-7}, {50,-7}, {53,-7}, {54,-7}, {55,-96}, {58,119}, {58,120}, {58,121}, {58,122}, {58,123}, {58,124}, {58,125}, {58,126}, {58,127}, {58,128}, {58,129}, {58,130}, {58,131}, {59,-34}, {59,-33}, {59,-32}, {59,-31}, {59,-30}, {59,-29}, {59,-28}, {59,-27}, {59,-26}, {59,-25}, {59,-24}, {59,-23}, {59,-22}, {59,-21}, {59,-20}, {59,-19}, {59,-18}, {59,15}, {59,16}, {59,31}, {59,32}, {59,119}, {60,15}, {60,16}, {60,31}, {60,32}, {60,118}, {60,119}, {61,119}, {62,119}, {63,119}, {64,119}, {65,100}, {65,119}, {66,119}, {67,88}, {67,119}, {68,-1}, {68,20}, {68,37}, {68,92}, {68,98}, {68,119}, {69,-1}, {69,20}, {69,37}, {69,91}, {69,99}, {69,118}, {69,119}, {70,-65}, {70,2}, {70,3}, {70,4}, {70,5}, {70,6}, {70,7}, {70,8}, {70,23}, {70,24}, {70,25}, {70,26}, {70,27}, {70,28}, {70,29}, {70,36}, {70,40}, {70,41}, {70,42}, {70,43}, {70,44}, {70,45}, {70,119}, {71,2}, {71,3}, {71,4}, {71,5}, {71,6}, {71,7}, {71,8}, {71,23}, {71,24}, {71,25}, {71,26}, {71,27}, {71,28}, {71,29}, {71,40}, {71,41}, {71,42}, {71,43}, {71,44}, {71,45}, {71,46}, {71,119}, {72,2}, {72,3}, {72,4}, {72,5}, {72,6}, {72,7}, {72,8}, {72,23}, {72,24}, {72,25}, {72,26}, {72,27}, {72,28}, {72,29}, {72,36}, {72,40}, {72,41}, {72,42}, {72,43}, {72,44}, {72,45}, {72,119}, {73,2}, {73,3}, {73,4}, {73,5}, {73,6}, {73,7}, {73,8}, {73,23}, {73,24}, {73,25}, {73,26}, {73,27}, {73,28}, {73,29}, {73,36}, {73,40}, {73,41}, {73,42}, {73,43}, {73,44}, {73,45}, {73,122}, {73,123}, {73,124}, {73,125}, {73,126}, {73,127}, {73,128}, {73,129}, {73,130}, {74,2}, {74,3}, {74,4}, {74,5}, {74,6}, {74,7}, {74,8}, {74,23}, {74,24}, {74,25}, {74,26}, {74,27}, {74,28}, {74,29}, {74,30}, {74,36}, {74,40}, {74,41}, {74,42}, {74,43}, {74,44}, {74,45}, {75,-64}, {75,-63}, {75,-62}, {75,-61}, {75,2}, {75,3}, {75,4}, {75,5}, {75,6}, {75,7}, {75,8}, {75,23}, {75,24}, {75,25}, {75,26}, {75,27}, {75,28}, {75,29}, {75,40}, {75,41}, {75,42}, {75,43}, {75,44}, {75,45}, {75,91}, {75,99}, {76,-64}, {76,-63}, {76,-62}, {76,-61}, {76,-60}, {76,-59}, {76,2}, {76,3}, {76,4}, {76,5}, {76,6}, {76,7}, {76,8}, {76,23}, {76,24}, {76,25}, {76,26}, {76,27}, {76,28}, {76,29}, {76,40}, {76,41}, {76,42}, {76,43}, {76,44}, {76,45}, {76,46}, {76,92}, {76,98}, {77,-64}, {77,-63}, {77,-62}, {77,-61}, {77,-60}, {77,-59}, {77,2}, {77,3}, {77,4}, {77,5}, {77,6}, {77,7}, {77,8}, {77,23}, {77,24}, {77,25}, {77,26}, {77,27}, {77,28}, {77,29}, {77,40}, {77,41}, {77,42}, {77,43}, {77,44}, {77,45}, {78,-92}, {78,-64}, {78,-63}, {78,-62}, {78,-61}, {78,-60}, {78,-59}, {78,2}, {78,3}, {78,4}, {78,5}, {78,6}, {78,7}, {78,8}, {78,23}, {78,24}, {78,25}, {78,26}, {78,27}, {78,28}, {78,29}, {78,40}, {78,41}, {78,42}, {78,43}, {78,44}, {78,45}, {79,-64}, {79,-63}, {79,-62}, {79,-61}, {79,-60}, {79,-59}, {79,5}, {79,26}, {79,40}, {79,41}, {79,42}, {79,43}, {79,44}, {79,45}, {79,90}, {79,100}, {80,-64}, {80,-63}, {80,-62}, {80,-61}, {80,-60}, {80,-59}, {81,-64}, {81,-63}, {81,-62}, {81,-61}, {81,-60}, {81,-59}, {82,-64}, {82,-63}, {82,-62}, {82,-61}, {82,-60}, {82,-59}, {83,-64}, {83,-63}, {83,-62}, {83,-61}, {83,-60}, {83,-59}, {84,-64}, {84,-63}, {84,-62}, {84,-61}, {84,-60}, {84,-59}, },
    ["interior-divider"] = {{-89,51}, {-89,52}, {-89,58}, {-89,59}, {-88,51}, {-88,52}, {-88,53}, {-88,54}, {-88,55}, {-88,56}, {-88,57}, {-88,58}, {-88,59}, {-88,96}, {-88,97}, {-88,98}, {-88,99}, {-88,100}, {-88,101}, {-88,102}, {-88,103}, {-87,-26}, {-87,-25}, {-87,-24}, {-87,-23}, {-87,-22}, {-87,-21}, {-87,-20}, {-87,-19}, {-87,-18}, {-87,-17}, {-87,-16}, {-87,-15}, {-87,-14}, {-87,-13}, {-87,-12}, {-87,24}, {-87,25}, {-87,26}, {-87,27}, {-87,28}, {-87,29}, {-87,30}, {-87,31}, {-87,32}, {-87,33}, {-87,34}, {-87,35}, {-87,36}, {-87,37}, {-87,38}, {-87,51}, {-87,52}, {-87,53}, {-87,54}, {-87,55}, {-87,56}, {-87,57}, {-87,58}, {-87,59}, {-87,96}, {-87,97}, {-87,98}, {-87,99}, {-87,100}, {-87,101}, {-87,102}, {-87,103}, {-86,-26}, {-86,-25}, {-86,-24}, {-86,-23}, {-86,-22}, {-86,-21}, {-86,-20}, {-86,-19}, {-86,-18}, {-86,-17}, {-86,-16}, {-86,-15}, {-86,-14}, {-86,-13}, {-86,-12}, {-86,-7}, {-86,-6}, {-86,-2}, {-86,-1}, {-86,3}, {-86,4}, {-86,8}, {-86,9}, {-86,13}, {-86,14}, {-86,18}, {-86,19}, {-86,24}, {-86,25}, {-86,26}, {-86,27}, {-86,28}, {-86,29}, {-86,30}, {-86,31}, {-86,32}, {-86,33}, {-86,34}, {-86,35}, {-86,36}, {-86,37}, {-86,38}, {-86,51}, {-86,52}, {-86,58}, {-86,59}, {-86,93}, {-86,94}, {-86,95}, {-86,96}, {-86,97}, {-86,102}, {-86,103}, {-85,-26}, {-85,-25}, {-85,-13}, {-85,-12}, {-85,-7}, {-85,-6}, {-85,-2}, {-85,-1}, {-85,3}, {-85,4}, {-85,8}, {-85,9}, {-85,13}, {-85,14}, {-85,18}, {-85,19}, {-85,24}, {-85,25}, {-85,28}, {-85,30}, {-85,32}, {-85,34}, {-85,37}, {-85,38}, {-85,93}, {-85,94}, {-85,95}, {-85,96}, {-85,97}, {-85,102}, {-85,103}, {-84,-26}, {-84,-25}, {-84,-13}, {-84,-12}, {-84,24}, {-84,25}, {-84,28}, {-84,30}, {-84,32}, {-84,34}, {-84,37}, {-84,38}, {-84,46}, {-84,47}, {-84,49}, {-84,50}, {-84,53}, {-84,54}, {-84,56}, {-84,58}, {-84,59}, {-84,93}, {-84,96}, {-84,97}, {-84,98}, {-84,99}, {-84,101}, {-84,102}, {-84,103}, {-84,104}, {-84,105}, {-84,106}, {-84,107}, {-84,108}, {-84,109}, {-84,110}, {-84,111}, {-84,112}, {-84,113}, {-84,114}, {-83,-26}, {-83,-25}, {-83,-24}, {-83,-22}, {-83,-21}, {-83,-20}, {-83,-19}, {-83,-18}, {-83,-17}, {-83,-16}, {-83,-13}, {-83,-12}, {-83,28}, {-83,30}, {-83,32}, {-83,34}, {-83,37}, {-83,38}, {-83,46}, {-83,50}, {-83,53}, {-83,56}, {-83,59}, {-83,67}, {-83,68}, {-83,69}, {-83,70}, {-83,71}, {-83,72}, {-83,73}, {-83,74}, {-83,75}, {-83,76}, {-83,77}, {-83,78}, {-83,79}, {-83,80}, {-83,81}, {-83,82}, {-83,83}, {-83,84}, {-83,85}, {-83,86}, {-83,87}, {-83,88}, {-83,89}, {-83,90}, {-83,91}, {-83,92}, {-83,93}, {-83,96}, {-83,97}, {-83,98}, {-83,99}, {-83,101}, {-83,102}, {-83,103}, {-83,104}, {-83,105}, {-83,106}, {-83,107}, {-83,108}, {-83,109}, {-83,110}, {-83,111}, {-83,112}, {-83,113}, {-83,114}, {-82,-26}, {-82,-25}, {-82,-16}, {-82,-13}, {-82,-12}, {-82,24}, {-82,25}, {-82,28}, {-82,30}, {-82,32}, {-82,34}, {-82,37}, {-82,38}, {-82,41}, {-82,42}, {-82,43}, {-82,44}, {-82,45}, {-82,46}, {-82,47}, {-82,48}, {-82,49}, {-82,50}, {-82,53}, {-82,56}, {-82,59}, {-82,66}, {-82,67}, {-82,68}, {-82,69}, {-82,70}, {-82,71}, {-82,72}, {-82,73}, {-82,74}, {-82,75}, {-82,76}, {-82,77}, {-82,78}, {-82,79}, {-82,80}, {-82,81}, {-82,82}, {-82,83}, {-82,84}, {-82,85}, {-82,86}, {-82,87}, {-82,88}, {-82,89}, {-82,90}, {-82,91}, {-82,92}, {-82,93}, {-82,102}, {-82,103}, {-82,113}, {-82,114}, {-81,-26}, {-81,-25}, {-81,-16}, {-81,-13}, {-81,-12}, {-81,-7}, {-81,-6}, {-81,-2}, {-81,-1}, {-81,3}, {-81,4}, {-81,8}, {-81,9}, {-81,13}, {-81,14}, {-81,18}, {-81,19}, {-81,24}, {-81,25}, {-81,30}, {-81,32}, {-81,34}, {-81,37}, {-81,38}, {-81,41}, {-81,42}, {-81,43}, {-81,44}, {-81,45}, {-81,46}, {-81,47}, {-81,48}, {-81,49}, {-81,50}, {-81,53}, {-81,56}, {-81,59}, {-81,102}, {-81,103}, {-81,113}, {-81,114}, {-80,-26}, {-80,-25}, {-80,-24}, {-80,-22}, {-80,-21}, {-80,-20}, {-80,-19}, {-80,-18}, {-80,-17}, {-80,-16}, {-80,-13}, {-80,-12}, {-80,-7}, {-80,-6}, {-80,-2}, {-80,-1}, {-80,3}, {-80,4}, {-80,8}, {-80,9}, {-80,13}, {-80,14}, {-80,18}, {-80,19}, {-80,24}, {-80,25}, {-80,26}, {-80,27}, {-80,28}, {-80,30}, {-80,32}, {-80,34}, {-80,37}, {-80,38}, {-80,41}, {-80,42}, {-80,49}, {-80,50}, {-80,53}, {-80,54}, {-80,55}, {-80,56}, {-80,57}, {-80,58}, {-80,59}, {-80,60}, {-80,61}, {-80,62}, {-80,63}, {-80,64}, {-80,65}, {-80,66}, {-80,67}, {-80,68}, {-80,102}, {-80,103}, {-80,113}, {-80,114}, {-79,-26}, {-79,-25}, {-79,-16}, {-79,-13}, {-79,-12}, {-79,24}, {-79,25}, {-79,28}, {-79,34}, {-79,37}, {-79,38}, {-79,41}, {-79,42}, {-79,43}, {-79,44}, {-79,45}, {-79,46}, {-79,49}, {-79,50}, {-79,51}, {-79,53}, {-79,54}, {-79,55}, {-79,56}, {-79,57}, {-79,58}, {-79,59}, {-79,60}, {-79,61}, {-79,62}, {-79,63}, {-79,64}, {-79,65}, {-79,66}, {-79,67}, {-79,68}, {-79,102}, {-79,103}, {-79,113}, {-79,114}, {-78,-26}, {-78,-25}, {-78,-16}, {-78,-13}, {-78,-12}, {-78,24}, {-78,25}, {-78,28}, {-78,29}, {-78,30}, {-78,31}, {-78,32}, {-78,33}, {-78,34}, {-78,37}, {-78,38}, {-78,41}, {-78,42}, {-78,46}, {-78,49}, {-78,50}, {-78,53}, {-78,60}, {-78,61}, {-78,67}, {-78,102}, {-78,103}, {-78,113}, {-78,114}, {-77,-26}, {-77,-25}, {-77,-24}, {-77,-23}, {-77,-22}, {-77,-21}, {-77,-20}, {-77,-19}, {-77,-18}, {-77,-17}, {-77,-16}, {-77,-13}, {-77,-12}, {-77,37}, {-77,38}, {-77,41}, {-77,42}, {-77,46}, {-77,49}, {-77,50}, {-77,53}, {-77,60}, {-77,61}, {-77,67}, {-77,102}, {-77,103}, {-77,105}, {-77,106}, {-77,107}, {-76,-26}, {-76,-25}, {-76,-18}, {-76,-13}, {-76,-12}, {-76,24}, {-76,25}, {-76,37}, {-76,38}, {-76,49}, {-76,50}, {-76,53}, {-76,54}, {-76,56}, {-76,57}, {-76,58}, {-76,59}, {-76,60}, {-76,61}, {-76,62}, {-76,64}, {-76,65}, {-76,66}, {-76,67}, {-76,68}, {-76,106}, {-76,113}, {-76,114}, {-75,-26}, {-75,-25}, {-75,-18}, {-75,-13}, {-75,-12}, {-75,-11}, {-75,-10}, {-75,-9}, {-75,-8}, {-75,-7}, {-75,-6}, {-75,-5}, {-75,-4}, {-75,-3}, {-75,-2}, {-75,-1}, {-75,0}, {-75,1}, {-75,2}, {-75,3}, {-75,4}, {-75,8}, {-75,9}, {-75,10}, {-75,11}, {-75,12}, {-75,13}, {-75,14}, {-75,15}, {-75,16}, {-75,17}, {-75,18}, {-75,19}, {-75,20}, {-75,21}, {-75,22}, {-75,23}, {-75,24}, {-75,25}, {-75,26}, {-75,27}, {-75,28}, {-75,29}, {-75,30}, {-75,31}, {-75,32}, {-75,33}, {-75,34}, {-75,35}, {-75,36}, {-75,37}, {-75,38}, {-75,41}, {-75,42}, {-75,46}, {-75,49}, {-75,50}, {-75,60}, {-75,61}, {-75,67}, {-75,102}, {-75,103}, {-75,105}, {-75,106}, {-75,107}, {-75,113}, {-75,114}, {-74,-26}, {-74,-25}, {-74,-24}, {-74,-23}, {-74,-21}, {-74,-20}, {-74,-19}, {-74,-18}, {-74,-17}, {-74,-15}, {-74,-14}, {-74,-13}, {-74,-12}, {-74,-11}, {-74,-10}, {-74,-9}, {-74,-8}, {-74,-7}, {-74,-6}, {-74,-5}, {-74,-4}, {-74,-3}, {-74,-2}, {-74,-1}, {-74,0}, {-74,1}, {-74,2}, {-74,3}, {-74,4}, {-74,8}, {-74,9}, {-74,10}, {-74,11}, {-74,12}, {-74,13}, {-74,14}, {-74,15}, {-74,16}, {-74,17}, {-74,18}, {-74,19}, {-74,20}, {-74,21}, {-74,22}, {-74,23}, {-74,24}, {-74,25}, {-74,26}, {-74,27}, {-74,28}, {-74,29}, {-74,30}, {-74,31}, {-74,32}, {-74,33}, {-74,34}, {-74,35}, {-74,36}, {-74,37}, {-74,38}, {-74,41}, {-74,42}, {-74,46}, {-74,49}, {-74,50}, {-74,60}, {-74,61}, {-74,63}, {-74,65}, {-74,67}, {-74,102}, {-74,103}, {-74,113}, {-74,114}, {-73,-71}, {-73,-68}, {-73,-26}, {-73,-25}, {-73,-24}, {-73,-23}, {-73,-21}, {-73,-20}, {-73,-19}, {-73,-18}, {-73,-17}, {-73,-15}, {-73,-14}, {-73,-13}, {-73,-12}, {-73,-11}, {-73,-10}, {-73,-9}, {-73,-8}, {-73,-7}, {-73,-6}, {-73,-5}, {-73,-4}, {-73,-3}, {-73,-2}, {-73,-1}, {-73,0}, {-73,1}, {-73,2}, {-73,3}, {-73,4}, {-73,8}, {-73,9}, {-73,10}, {-73,11}, {-73,12}, {-73,13}, {-73,14}, {-73,15}, {-73,16}, {-73,17}, {-73,18}, {-73,19}, {-73,20}, {-73,21}, {-73,22}, {-73,23}, {-73,24}, {-73,25}, {-73,29}, {-73,30}, {-73,36}, {-73,37}, {-73,41}, {-73,42}, {-73,43}, {-73,44}, {-73,45}, {-73,46}, {-73,47}, {-73,48}, {-73,49}, {-73,50}, {-73,60}, {-73,61}, {-73,67}, {-73,102}, {-73,103}, {-73,110}, {-73,111}, {-73,112}, {-73,113}, {-73,114}, {-72,-80}, {-72,-79}, {-72,-78}, {-72,-76}, {-72,-73}, {-72,-72}, {-72,-71}, {-72,-68}, {-72,-67}, {-72,-66}, {-72,-64}, {-72,-63}, {-72,-61}, {-72,-60}, {-72,-59}, {-72,-14}, {-72,-13}, {-72,-12}, {-72,24}, {-72,25}, {-72,26}, {-72,29}, {-72,30}, {-72,36}, {-72,37}, {-72,41}, {-72,42}, {-72,49}, {-72,50}, {-72,60}, {-72,61}, {-72,67}, {-72,102}, {-72,103}, {-72,104}, {-72,105}, {-72,106}, {-72,107}, {-72,108}, {-72,110}, {-72,111}, {-72,112}, {-72,113}, {-72,114}, {-71,-80}, {-71,-79}, {-71,-78}, {-71,-77}, {-71,-76}, {-71,-75}, {-71,-74}, {-71,-73}, {-71,-72}, {-71,-71}, {-71,-68}, {-71,-67}, {-71,-66}, {-71,-65}, {-71,-64}, {-71,-63}, {-71,-62}, {-71,-61}, {-71,-60}, {-71,-59}, {-71,-14}, {-71,-13}, {-71,-12}, {-71,24}, {-71,25}, {-71,26}, {-71,29}, {-71,30}, {-71,32}, {-71,33}, {-71,34}, {-71,35}, {-71,36}, {-71,37}, {-71,41}, {-71,42}, {-71,43}, {-71,44}, {-71,45}, {-71,46}, {-71,47}, {-71,49}, {-71,50}, {-71,67}, {-71,102}, {-71,103}, {-71,106}, {-71,113}, {-71,114}, {-70,-80}, {-70,-79}, {-70,-78}, {-70,-77}, {-70,-76}, {-70,-75}, {-70,-74}, {-70,-73}, {-70,-72}, {-70,-71}, {-70,-68}, {-70,-67}, {-70,-66}, {-70,-65}, {-70,-64}, {-70,-63}, {-70,-62}, {-70,-61}, {-70,-60}, {-70,-59}, {-70,-14}, {-70,-13}, {-70,-12}, {-70,24}, {-70,25}, {-70,26}, {-70,29}, {-70,30}, {-70,36}, {-70,37}, {-70,41}, {-70,49}, {-70,50}, {-70,60}, {-70,61}, {-70,67}, {-70,102}, {-70,103}, {-70,106}, {-70,113}, {-70,114}, {-69,-79}, {-69,-78}, {-69,-71}, {-69,-68}, {-69,-61}, {-69,-60}, {-69,-14}, {-69,-13}, {-69,-12}, {-69,24}, {-69,25}, {-69,26}, {-69,29}, {-69,30}, {-69,36}, {-69,37}, {-69,41}, {-69,49}, {-69,50}, {-69,60}, {-69,61}, {-69,67}, {-69,96}, {-69,97}, {-69,98}, {-69,99}, {-69,101}, {-69,102}, {-69,103}, {-69,106}, {-69,113}, {-69,114}, {-68,-80}, {-68,-79}, {-68,-78}, {-68,-61}, {-68,-60}, {-68,-59}, {-68,-25}, {-68,-24}, {-68,-20}, {-68,-19}, {-68,-14}, {-68,-13}, {-68,-12}, {-68,24}, {-68,25}, {-68,26}, {-68,29}, {-68,30}, {-68,32}, {-68,33}, {-68,34}, {-68,35}, {-68,36}, {-68,37}, {-68,49}, {-68,50}, {-68,60}, {-68,61}, {-68,67}, {-68,96}, {-68,97}, {-68,98}, {-68,99}, {-68,101}, {-68,102}, {-68,103}, {-68,106}, {-68,113}, {-68,114}, {-67,-80}, {-67,-79}, {-67,-78}, {-67,-61}, {-67,-60}, {-67,-59}, {-67,-25}, {-67,-24}, {-67,-20}, {-67,-19}, {-67,-14}, {-67,-13}, {-67,-12}, {-67,24}, {-67,25}, {-67,26}, {-67,29}, {-67,30}, {-67,36}, {-67,37}, {-67,41}, {-67,49}, {-67,50}, {-67,60}, {-67,61}, {-67,67}, {-67,96}, {-67,97}, {-67,102}, {-67,103}, {-67,106}, {-67,113}, {-67,114}, {-66,-79}, {-66,-78}, {-66,-61}, {-66,-60}, {-66,-14}, {-66,-13}, {-66,-12}, {-66,24}, {-66,25}, {-66,26}, {-66,29}, {-66,30}, {-66,36}, {-66,37}, {-66,41}, {-66,49}, {-66,50}, {-66,51}, {-66,52}, {-66,53}, {-66,54}, {-66,56}, {-66,57}, {-66,58}, {-66,59}, {-66,60}, {-66,61}, {-66,62}, {-66,64}, {-66,65}, {-66,66}, {-66,67}, {-66,68}, {-66,96}, {-66,97}, {-66,102}, {-66,103}, {-66,113}, {-66,114}, {-65,-80}, {-65,-79}, {-65,-78}, {-65,-73}, {-65,-72}, {-65,-67}, {-65,-66}, {-65,-61}, {-65,-60}, {-65,-59}, {-65,-14}, {-65,-13}, {-65,-12}, {-65,24}, {-65,25}, {-65,26}, {-65,29}, {-65,30}, {-65,32}, {-65,33}, {-65,34}, {-65,35}, {-65,36}, {-65,37}, {-65,41}, {-65,42}, {-65,43}, {-65,44}, {-65,45}, {-65,46}, {-65,47}, {-65,49}, {-65,50}, {-65,53}, {-65,57}, {-65,60}, {-65,61}, {-65,67}, {-65,96}, {-65,97}, {-65,98}, {-65,99}, {-65,101}, {-65,102}, {-65,103}, {-65,104}, {-65,105}, {-65,106}, {-65,107}, {-65,108}, {-65,109}, {-65,110}, {-65,111}, {-65,112}, {-65,113}, {-65,114}, {-65,115}, {-65,117}, {-65,118}, {-65,119}, {-65,120}, {-65,121}, {-65,122}, {-65,123}, {-65,124}, {-65,125}, {-65,126}, {-65,127}, {-65,128}, {-65,129}, {-65,130}, {-65,131}, {-65,132}, {-65,133}, {-65,134}, {-65,137}, {-65,138}, {-65,139}, {-64,-80}, {-64,-79}, {-64,-78}, {-64,-73}, {-64,-72}, {-64,-67}, {-64,-66}, {-64,-61}, {-64,-60}, {-64,-59}, {-64,-14}, {-64,-13}, {-64,-12}, {-64,24}, {-64,25}, {-64,26}, {-64,36}, {-64,37}, {-64,41}, {-64,42}, {-64,49}, {-64,50}, {-64,60}, {-64,61}, {-64,67}, {-64,96}, {-64,97}, {-64,98}, {-64,99}, {-64,101}, {-64,102}, {-64,103}, {-64,104}, {-64,105}, {-64,106}, {-64,107}, {-64,108}, {-64,109}, {-64,110}, {-64,111}, {-64,112}, {-64,113}, {-64,114}, {-64,115}, {-64,117}, {-64,118}, {-64,119}, {-64,120}, {-64,121}, {-64,122}, {-64,123}, {-64,124}, {-64,125}, {-64,126}, {-64,127}, {-64,128}, {-64,129}, {-64,130}, {-64,131}, {-64,132}, {-64,133}, {-64,134}, {-64,137}, {-64,138}, {-64,139}, {-63,-79}, {-63,-78}, {-63,-62}, {-63,-61}, {-63,-60}, {-63,-59}, {-63,-58}, {-63,-25}, {-63,-24}, {-63,-20}, {-63,-19}, {-63,-14}, {-63,-13}, {-63,-12}, {-63,24}, {-63,25}, {-63,26}, {-63,29}, {-63,30}, {-63,36}, {-63,37}, {-63,41}, {-63,42}, {-63,43}, {-63,44}, {-63,45}, {-63,46}, {-63,47}, {-63,48}, {-63,49}, {-63,50}, {-63,51}, {-63,52}, {-63,53}, {-63,54}, {-63,55}, {-63,56}, {-63,57}, {-63,58}, {-63,59}, {-63,60}, {-63,61}, {-63,62}, {-63,63}, {-63,64}, {-63,65}, {-63,66}, {-63,67}, {-63,68}, {-63,96}, {-63,97}, {-63,138}, {-63,139}, {-62,-80}, {-62,-79}, {-62,-78}, {-62,-25}, {-62,-24}, {-62,-20}, {-62,-19}, {-62,-14}, {-62,-13}, {-62,-12}, {-62,24}, {-62,25}, {-62,26}, {-62,28}, {-62,29}, {-62,30}, {-62,31}, {-62,32}, {-62,33}, {-62,34}, {-62,35}, {-62,36}, {-62,37}, {-62,41}, {-62,42}, {-62,43}, {-62,44}, {-62,45}, {-62,46}, {-62,47}, {-62,48}, {-62,49}, {-62,50}, {-62,51}, {-62,52}, {-62,53}, {-62,54}, {-62,55}, {-62,56}, {-62,57}, {-62,58}, {-62,59}, {-62,60}, {-62,61}, {-62,62}, {-62,63}, {-62,64}, {-62,65}, {-62,66}, {-62,67}, {-62,68}, {-62,70}, {-62,71}, {-62,72}, {-62,73}, {-62,74}, {-62,75}, {-62,76}, {-62,77}, {-62,78}, {-62,79}, {-62,80}, {-62,83}, {-62,84}, {-62,85}, {-62,86}, {-62,87}, {-62,88}, {-62,89}, {-62,90}, {-62,91}, {-62,92}, {-62,93}, {-62,96}, {-62,97}, {-62,138}, {-62,139}, {-61,-80}, {-61,-79}, {-61,-78}, {-61,24}, {-61,25}, {-61,72}, {-61,73}, {-61,74}, {-61,75}, {-61,76}, {-61,77}, {-61,78}, {-61,79}, {-61,80}, {-61,83}, {-61,84}, {-61,85}, {-61,86}, {-61,87}, {-61,88}, {-61,89}, {-61,90}, {-61,91}, {-61,92}, {-61,93}, {-61,94}, {-61,95}, {-61,96}, {-61,97}, {-61,98}, {-61,99}, {-61,100}, {-61,101}, {-61,102}, {-61,103}, {-61,104}, {-61,105}, {-61,106}, {-61,107}, {-61,108}, {-61,109}, {-61,110}, {-61,111}, {-61,112}, {-61,113}, {-61,114}, {-61,118}, {-61,119}, {-61,120}, {-61,121}, {-61,122}, {-61,123}, {-61,124}, {-61,125}, {-61,128}, {-61,129}, {-61,130}, {-61,131}, {-61,132}, {-61,133}, {-61,134}, {-61,138}, {-61,139}, {-60,-79}, {-60,-78}, {-60,-62}, {-60,-61}, {-60,-60}, {-60,-59}, {-60,-58}, {-60,30}, {-60,32}, {-60,33}, {-60,35}, {-60,36}, {-60,37}, {-60,72}, {-60,73}, {-60,74}, {-60,75}, {-60,76}, {-60,77}, {-60,78}, {-60,79}, {-60,80}, {-60,83}, {-60,84}, {-60,85}, {-60,86}, {-60,87}, {-60,88}, {-60,89}, {-60,90}, {-60,91}, {-60,92}, {-60,93}, {-60,94}, {-60,95}, {-60,96}, {-60,97}, {-60,98}, {-60,99}, {-60,100}, {-60,101}, {-60,102}, {-60,103}, {-60,104}, {-60,105}, {-60,106}, {-60,107}, {-60,108}, {-60,109}, {-60,110}, {-60,111}, {-60,112}, {-60,113}, {-60,114}, {-60,118}, {-60,119}, {-60,125}, {-60,128}, {-60,134}, {-60,138}, {-60,139}, {-59,-80}, {-59,-79}, {-59,-78}, {-59,-73}, {-59,-72}, {-59,-67}, {-59,-66}, {-59,-61}, {-59,-60}, {-59,-59}, {-59,24}, {-59,25}, {-59,30}, {-59,33}, {-59,36}, {-59,37}, {-59,78}, {-59,79}, {-59,83}, {-59,84}, {-59,92}, {-59,93}, {-59,113}, {-59,114}, {-59,118}, {-59,119}, {-59,125}, {-59,128}, {-59,134}, {-59,138}, {-59,139}, {-58,-80}, {-58,-79}, {-58,-78}, {-58,-73}, {-58,-72}, {-58,-67}, {-58,-66}, {-58,-61}, {-58,-60}, {-58,-59}, {-58,-25}, {-58,-24}, {-58,-20}, {-58,-19}, {-58,-14}, {-58,-13}, {-58,-12}, {-58,24}, {-58,25}, {-58,26}, {-58,30}, {-58,33}, {-58,36}, {-58,37}, {-58,78}, {-58,79}, {-58,83}, {-58,84}, {-58,92}, {-58,93}, {-58,95}, {-58,96}, {-58,97}, {-58,98}, {-58,99}, {-58,101}, {-58,102}, {-58,109}, {-58,110}, {-58,111}, {-58,113}, {-58,114}, {-58,118}, {-58,119}, {-58,125}, {-58,128}, {-58,138}, {-58,139}, {-57,-79}, {-57,-78}, {-57,-61}, {-57,-60}, {-57,-25}, {-57,-24}, {-57,-20}, {-57,-19}, {-57,-14}, {-57,-13}, {-57,-12}, {-57,24}, {-57,25}, {-57,26}, {-57,30}, {-57,33}, {-57,36}, {-57,37}, {-57,78}, {-57,79}, {-57,92}, {-57,93}, {-57,98}, {-57,99}, {-57,102}, {-57,109}, {-57,113}, {-57,114}, {-57,118}, {-57,119}, {-57,125}, {-57,128}, {-57,134}, {-57,138}, {-57,139}, {-56,-80}, {-56,-79}, {-56,-78}, {-56,-61}, {-56,-60}, {-56,-59}, {-56,-14}, {-56,-13}, {-56,-12}, {-56,24}, {-56,25}, {-56,26}, {-56,30}, {-56,31}, {-56,32}, {-56,33}, {-56,34}, {-56,35}, {-56,36}, {-56,37}, {-56,78}, {-56,79}, {-56,83}, {-56,84}, {-56,92}, {-56,93}, {-56,94}, {-56,95}, {-56,96}, {-56,97}, {-56,98}, {-56,99}, {-56,102}, {-56,109}, {-56,110}, {-56,111}, {-56,113}, {-56,114}, {-56,118}, {-56,119}, {-56,128}, {-56,134}, {-56,138}, {-56,139}, {-55,-80}, {-55,-79}, {-55,-78}, {-55,-61}, {-55,-60}, {-55,-59}, {-55,-14}, {-55,-13}, {-55,-12}, {-55,24}, {-55,25}, {-55,26}, {-55,36}, {-55,37}, {-55,78}, {-55,79}, {-55,83}, {-55,84}, {-55,92}, {-55,93}, {-55,98}, {-55,99}, {-55,102}, {-55,109}, {-55,113}, {-55,114}, {-55,118}, {-55,119}, {-55,125}, {-55,128}, {-55,129}, {-55,131}, {-55,132}, {-55,133}, {-55,134}, {-55,138}, {-55,139}, {-54,-79}, {-54,-78}, {-54,-71}, {-54,-68}, {-54,-61}, {-54,-60}, {-54,-14}, {-54,-13}, {-54,-12}, {-54,24}, {-54,25}, {-54,26}, {-54,30}, {-54,32}, {-54,33}, {-54,34}, {-54,35}, {-54,36}, {-54,37}, {-54,74}, {-54,75}, {-54,76}, {-54,77}, {-54,78}, {-54,79}, {-54,80}, {-54,83}, {-54,84}, {-54,85}, {-54,86}, {-54,87}, {-54,88}, {-54,89}, {-54,90}, {-54,91}, {-54,92}, {-54,93}, {-54,98}, {-54,99}, {-54,102}, {-54,109}, {-54,113}, {-54,114}, {-54,118}, {-54,119}, {-54,125}, {-54,128}, {-54,134}, {-54,138}, {-54,139}, {-53,-80}, {-53,-79}, {-53,-78}, {-53,-77}, {-53,-76}, {-53,-75}, {-53,-74}, {-53,-73}, {-53,-72}, {-53,-71}, {-53,-68}, {-53,-67}, {-53,-66}, {-53,-65}, {-53,-64}, {-53,-63}, {-53,-62}, {-53,-61}, {-53,-60}, {-53,-59}, {-53,-25}, {-53,-24}, {-53,-20}, {-53,-19}, {-53,-14}, {-53,-13}, {-53,-12}, {-53,24}, {-53,25}, {-53,26}, {-53,30}, {-53,36}, {-53,37}, {-53,73}, {-53,74}, {-53,92}, {-53,93}, {-53,94}, {-53,95}, {-53,96}, {-53,98}, {-53,99}, {-53,100}, {-53,101}, {-53,102}, {-53,103}, {-53,104}, {-53,105}, {-53,107}, {-53,108}, {-53,109}, {-53,110}, {-53,111}, {-53,112}, {-53,113}, {-53,114}, {-53,118}, {-53,119}, {-53,120}, {-53,122}, {-53,123}, {-53,124}, {-53,125}, {-53,128}, {-53,129}, {-53,130}, {-53,131}, {-53,132}, {-53,133}, {-53,134}, {-53,138}, {-53,139}, {-52,-80}, {-52,-79}, {-52,-78}, {-52,-77}, {-52,-76}, {-52,-75}, {-52,-74}, {-52,-73}, {-52,-72}, {-52,-71}, {-52,-68}, {-52,-67}, {-52,-66}, {-52,-65}, {-52,-64}, {-52,-63}, {-52,-62}, {-52,-61}, {-52,-60}, {-52,-59}, {-52,-25}, {-52,-24}, {-52,-20}, {-52,-19}, {-52,-14}, {-52,-13}, {-52,-12}, {-52,24}, {-52,25}, {-52,26}, {-52,30}, {-52,32}, {-52,33}, {-52,34}, {-52,35}, {-52,36}, {-52,37}, {-52,73}, {-52,74}, {-52,93}, {-52,94}, {-52,95}, {-52,96}, {-52,98}, {-52,99}, {-52,100}, {-52,101}, {-52,102}, {-52,103}, {-52,104}, {-52,105}, {-52,107}, {-52,108}, {-52,109}, {-52,110}, {-52,111}, {-52,112}, {-52,113}, {-52,114}, {-52,118}, {-52,119}, {-52,125}, {-52,128}, {-52,134}, {-52,138}, {-52,139}, {-51,-80}, {-51,-79}, {-51,-76}, {-51,-75}, {-51,-73}, {-51,-72}, {-51,-71}, {-51,-68}, {-51,-67}, {-51,-66}, {-51,-64}, {-51,-63}, {-51,-61}, {-51,-60}, {-51,-59}, {-51,24}, {-51,25}, {-51,30}, {-51,36}, {-51,37}, {-51,73}, {-51,74}, {-51,98}, {-51,99}, {-51,113}, {-51,114}, {-51,118}, {-51,119}, {-51,125}, {-51,128}, {-51,134}, {-51,138}, {-51,139}, {-50,-71}, {-50,-68}, {-50,30}, {-50,31}, {-50,32}, {-50,33}, {-50,34}, {-50,35}, {-50,36}, {-50,37}, {-50,98}, {-50,99}, {-50,113}, {-50,114}, {-50,118}, {-50,119}, {-50,120}, {-50,121}, {-50,122}, {-50,123}, {-50,124}, {-50,125}, {-50,128}, {-50,138}, {-50,139}, {-49,24}, {-49,25}, {-49,113}, {-49,114}, {-49,118}, {-49,119}, {-49,125}, {-49,128}, {-49,134}, {-49,138}, {-49,139}, {-48,-66}, {-48,-65}, {-48,-61}, {-48,-60}, {-48,-25}, {-48,-24}, {-48,-20}, {-48,-19}, {-48,-14}, {-48,-13}, {-48,-12}, {-48,24}, {-48,25}, {-48,26}, {-48,30}, {-48,31}, {-48,32}, {-48,33}, {-48,34}, {-48,35}, {-48,36}, {-48,37}, {-48,98}, {-48,99}, {-48,113}, {-48,114}, {-48,118}, {-48,119}, {-48,125}, {-48,128}, {-48,134}, {-48,138}, {-48,139}, {-47,-66}, {-47,-65}, {-47,-61}, {-47,-60}, {-47,-25}, {-47,-24}, {-47,-20}, {-47,-19}, {-47,-14}, {-47,-13}, {-47,-12}, {-47,24}, {-47,25}, {-47,26}, {-47,36}, {-47,37}, {-47,98}, {-47,99}, {-47,113}, {-47,114}, {-47,118}, {-47,119}, {-47,125}, {-47,128}, {-47,129}, {-47,131}, {-47,132}, {-47,133}, {-47,134}, {-47,138}, {-47,139}, {-46,-66}, {-46,-65}, {-46,-61}, {-46,-60}, {-46,-14}, {-46,-13}, {-46,-12}, {-46,24}, {-46,25}, {-46,26}, {-46,30}, {-46,36}, {-46,37}, {-46,98}, {-46,99}, {-46,113}, {-46,114}, {-46,118}, {-46,119}, {-46,125}, {-46,128}, {-46,134}, {-46,138}, {-46,139}, {-45,-66}, {-45,-65}, {-45,-64}, {-45,-63}, {-45,-62}, {-45,-61}, {-45,-60}, {-45,-14}, {-45,-13}, {-45,-12}, {-45,24}, {-45,25}, {-45,26}, {-45,30}, {-45,32}, {-45,33}, {-45,34}, {-45,35}, {-45,36}, {-45,37}, {-45,98}, {-45,99}, {-45,128}, {-45,129}, {-45,130}, {-45,131}, {-45,132}, {-45,133}, {-45,134}, {-45,138}, {-45,139}, {-44,-66}, {-44,-65}, {-44,-64}, {-44,-63}, {-44,-62}, {-44,-61}, {-44,-60}, {-44,-14}, {-44,-13}, {-44,-12}, {-44,24}, {-44,25}, {-44,26}, {-44,30}, {-44,36}, {-44,37}, {-44,98}, {-44,99}, {-44,113}, {-44,114}, {-44,118}, {-44,119}, {-44,125}, {-44,128}, {-44,134}, {-44,138}, {-44,139}, {-43,-81}, {-43,-80}, {-43,-79}, {-43,-78}, {-43,-77}, {-43,-66}, {-43,-65}, {-43,-61}, {-43,-60}, {-43,-25}, {-43,-24}, {-43,-20}, {-43,-19}, {-43,-14}, {-43,-13}, {-43,-12}, {-43,24}, {-43,25}, {-43,26}, {-43,30}, {-43,36}, {-43,37}, {-43,98}, {-43,99}, {-43,113}, {-43,114}, {-43,118}, {-43,119}, {-43,125}, {-43,128}, {-43,134}, {-43,138}, {-43,139}, {-42,-81}, {-42,-80}, {-42,-79}, {-42,-78}, {-42,-77}, {-42,-66}, {-42,-65}, {-42,-61}, {-42,-60}, {-42,-25}, {-42,-24}, {-42,-20}, {-42,-19}, {-42,-14}, {-42,-13}, {-42,-12}, {-42,24}, {-42,25}, {-42,26}, {-42,30}, {-42,32}, {-42,33}, {-42,34}, {-42,35}, {-42,36}, {-42,37}, {-42,98}, {-42,99}, {-42,113}, {-42,114}, {-42,118}, {-42,119}, {-42,120}, {-42,122}, {-42,123}, {-42,124}, {-42,125}, {-42,128}, {-42,138}, {-42,139}, {-41,-79}, {-41,-78}, {-41,-77}, {-41,-66}, {-41,-65}, {-41,-61}, {-41,-60}, {-41,-14}, {-41,-13}, {-41,-12}, {-41,24}, {-41,25}, {-41,26}, {-41,30}, {-41,36}, {-41,37}, {-41,113}, {-41,114}, {-41,118}, {-41,119}, {-41,125}, {-41,128}, {-41,134}, {-41,138}, {-41,139}, {-40,-78}, {-40,-77}, {-40,-76}, {-40,-75}, {-40,-74}, {-40,-73}, {-40,-72}, {-40,-66}, {-40,-65}, {-40,-14}, {-40,-13}, {-40,-12}, {-40,24}, {-40,25}, {-40,26}, {-40,30}, {-40,36}, {-40,37}, {-40,98}, {-40,99}, {-40,113}, {-40,114}, {-40,118}, {-40,119}, {-40,125}, {-40,128}, {-40,134}, {-40,138}, {-40,139}, {-39,-78}, {-39,-77}, {-39,-76}, {-39,-75}, {-39,-74}, {-39,-73}, {-39,-72}, {-39,-66}, {-39,-65}, {-39,-61}, {-39,-60}, {-39,-14}, {-39,-13}, {-39,-12}, {-39,24}, {-39,25}, {-39,26}, {-39,30}, {-39,32}, {-39,33}, {-39,34}, {-39,35}, {-39,36}, {-39,37}, {-39,73}, {-39,74}, {-39,98}, {-39,99}, {-39,113}, {-39,114}, {-39,118}, {-39,119}, {-39,120}, {-39,121}, {-39,122}, {-39,123}, {-39,124}, {-39,125}, {-39,128}, {-39,129}, {-39,131}, {-39,132}, {-39,133}, {-39,134}, {-39,138}, {-39,139}, {-38,-75}, {-38,-74}, {-38,-73}, {-38,-72}, {-38,-66}, {-38,-65}, {-38,-61}, {-38,-60}, {-38,-14}, {-38,-13}, {-38,-12}, {-38,24}, {-38,25}, {-38,26}, {-38,30}, {-38,36}, {-38,37}, {-38,73}, {-38,74}, {-38,75}, {-38,93}, {-38,94}, {-38,95}, {-38,96}, {-38,98}, {-38,99}, {-38,100}, {-38,101}, {-38,102}, {-38,103}, {-38,104}, {-38,105}, {-38,107}, {-38,108}, {-38,109}, {-38,110}, {-38,111}, {-38,112}, {-38,113}, {-38,114}, {-38,118}, {-38,119}, {-38,125}, {-38,128}, {-38,134}, {-38,138}, {-38,139}, {-37,-73}, {-37,-72}, {-37,-66}, {-37,-65}, {-37,-61}, {-37,-60}, {-37,-26}, {-37,-25}, {-37,-24}, {-37,-23}, {-37,-21}, {-37,-20}, {-37,-19}, {-37,-18}, {-37,-17}, {-37,-15}, {-37,-14}, {-37,-13}, {-37,-12}, {-37,-11}, {-37,-10}, {-37,-9}, {-37,-8}, {-37,-7}, {-37,-6}, {-37,-5}, {-37,-4}, {-37,-3}, {-37,-2}, {-37,-1}, {-37,0}, {-37,1}, {-37,2}, {-37,3}, {-37,4}, {-37,24}, {-37,25}, {-37,26}, {-37,30}, {-37,36}, {-37,37}, {-37,73}, {-37,74}, {-37,75}, {-37,92}, {-37,93}, {-37,94}, {-37,95}, {-37,96}, {-37,98}, {-37,99}, {-37,100}, {-37,101}, {-37,102}, {-37,103}, {-37,104}, {-37,105}, {-37,107}, {-37,108}, {-37,109}, {-37,110}, {-37,111}, {-37,112}, {-37,113}, {-37,114}, {-37,118}, {-37,119}, {-37,125}, {-37,128}, {-37,129}, {-37,130}, {-37,131}, {-37,132}, {-37,133}, {-37,134}, {-37,138}, {-37,139}, {-36,-73}, {-36,-72}, {-36,-66}, {-36,-65}, {-36,-64}, {-36,-63}, {-36,-62}, {-36,-61}, {-36,-60}, {-36,-26}, {-36,-25}, {-36,-24}, {-36,-23}, {-36,-21}, {-36,-20}, {-36,-19}, {-36,-18}, {-36,-17}, {-36,-15}, {-36,-14}, {-36,-13}, {-36,-12}, {-36,-11}, {-36,-10}, {-36,-9}, {-36,-8}, {-36,-7}, {-36,-6}, {-36,-5}, {-36,-4}, {-36,-3}, {-36,-2}, {-36,-1}, {-36,0}, {-36,1}, {-36,2}, {-36,3}, {-36,4}, {-36,24}, {-36,25}, {-36,26}, {-36,27}, {-36,28}, {-36,29}, {-36,30}, {-36,31}, {-36,32}, {-36,33}, {-36,34}, {-36,35}, {-36,36}, {-36,37}, {-36,41}, {-36,42}, {-36,43}, {-36,44}, {-36,45}, {-36,46}, {-36,74}, {-36,75}, {-36,76}, {-36,77}, {-36,78}, {-36,79}, {-36,80}, {-36,83}, {-36,84}, {-36,85}, {-36,86}, {-36,87}, {-36,88}, {-36,89}, {-36,90}, {-36,91}, {-36,92}, {-36,93}, {-36,98}, {-36,99}, {-36,102}, {-36,109}, {-36,113}, {-36,114}, {-36,118}, {-36,119}, {-36,128}, {-36,134}, {-36,138}, {-36,139}, {-35,-73}, {-35,-72}, {-35,-66}, {-35,-65}, {-35,-61}, {-35,-60}, {-35,-26}, {-35,-25}, {-35,-18}, {-35,-13}, {-35,-12}, {-35,-11}, {-35,-10}, {-35,-9}, {-35,-8}, {-35,-7}, {-35,-6}, {-35,-5}, {-35,-4}, {-35,-3}, {-35,-2}, {-35,-1}, {-35,0}, {-35,1}, {-35,2}, {-35,3}, {-35,4}, {-35,24}, {-35,25}, {-35,26}, {-35,27}, {-35,28}, {-35,29}, {-35,30}, {-35,31}, {-35,32}, {-35,33}, {-35,34}, {-35,35}, {-35,36}, {-35,37}, {-35,41}, {-35,45}, {-35,46}, {-35,76}, {-35,77}, {-35,86}, {-35,87}, {-35,92}, {-35,93}, {-35,94}, {-35,95}, {-35,96}, {-35,98}, {-35,99}, {-35,102}, {-35,109}, {-35,113}, {-35,114}, {-35,118}, {-35,119}, {-35,125}, {-35,128}, {-35,134}, {-35,138}, {-35,139}, {-34,-73}, {-34,-72}, {-34,-66}, {-34,-65}, {-34,-61}, {-34,-60}, {-34,-26}, {-34,-25}, {-34,-18}, {-34,-13}, {-34,-12}, {-34,24}, {-34,25}, {-34,36}, {-34,37}, {-34,41}, {-34,45}, {-34,46}, {-34,76}, {-34,77}, {-34,92}, {-34,93}, {-34,98}, {-34,99}, {-34,102}, {-34,109}, {-34,110}, {-34,112}, {-34,113}, {-34,114}, {-34,118}, {-34,119}, {-34,125}, {-34,128}, {-34,138}, {-34,139}, {-33,-73}, {-33,-72}, {-33,-66}, {-33,-65}, {-33,-26}, {-33,-25}, {-33,-24}, {-33,-23}, {-33,-22}, {-33,-21}, {-33,-20}, {-33,-19}, {-33,-18}, {-33,-17}, {-33,-16}, {-33,-13}, {-33,-12}, {-33,36}, {-33,37}, {-33,41}, {-33,45}, {-33,46}, {-33,76}, {-33,77}, {-33,86}, {-33,87}, {-33,92}, {-33,93}, {-33,94}, {-33,95}, {-33,96}, {-33,97}, {-33,98}, {-33,99}, {-33,102}, {-33,109}, {-33,113}, {-33,114}, {-33,118}, {-33,119}, {-33,120}, {-33,122}, {-33,123}, {-33,124}, {-33,125}, {-33,128}, {-33,134}, {-33,138}, {-33,139}, {-32,-73}, {-32,-72}, {-32,-66}, {-32,-65}, {-32,-61}, {-32,-60}, {-32,-26}, {-32,-25}, {-32,-16}, {-32,-13}, {-32,-12}, {-32,24}, {-32,25}, {-32,28}, {-32,36}, {-32,37}, {-32,41}, {-32,45}, {-32,46}, {-32,76}, {-32,77}, {-32,86}, {-32,87}, {-32,88}, {-32,89}, {-32,90}, {-32,91}, {-32,92}, {-32,93}, {-32,98}, {-32,99}, {-32,100}, {-32,102}, {-32,109}, {-32,110}, {-32,112}, {-32,113}, {-32,114}, {-32,118}, {-32,119}, {-32,125}, {-32,128}, {-32,134}, {-32,138}, {-32,139}, {-31,-73}, {-31,-72}, {-31,-66}, {-31,-65}, {-31,-61}, {-31,-60}, {-31,-26}, {-31,-25}, {-31,-16}, {-31,-13}, {-31,-12}, {-31,24}, {-31,25}, {-31,28}, {-31,29}, {-31,30}, {-31,31}, {-31,32}, {-31,33}, {-31,34}, {-31,35}, {-31,36}, {-31,37}, {-31,41}, {-31,45}, {-31,46}, {-31,76}, {-31,77}, {-31,86}, {-31,87}, {-31,88}, {-31,89}, {-31,90}, {-31,91}, {-31,92}, {-31,93}, {-31,113}, {-31,114}, {-31,118}, {-31,119}, {-31,125}, {-31,128}, {-31,129}, {-31,131}, {-31,132}, {-31,133}, {-31,134}, {-31,138}, {-31,139}, {-30,-73}, {-30,-72}, {-30,-66}, {-30,-65}, {-30,-64}, {-30,-63}, {-30,-62}, {-30,-61}, {-30,-60}, {-30,-26}, {-30,-25}, {-30,-24}, {-30,-22}, {-30,-21}, {-30,-20}, {-30,-19}, {-30,-18}, {-30,-17}, {-30,-16}, {-30,-13}, {-30,-12}, {-30,-7}, {-30,-6}, {-30,-2}, {-30,-1}, {-30,3}, {-30,4}, {-30,8}, {-30,9}, {-30,13}, {-30,14}, {-30,18}, {-30,19}, {-30,24}, {-30,25}, {-30,26}, {-30,27}, {-30,28}, {-30,36}, {-30,37}, {-30,41}, {-30,42}, {-30,43}, {-30,45}, {-30,46}, {-30,47}, {-30,48}, {-30,49}, {-30,50}, {-30,51}, {-30,52}, {-30,53}, {-30,54}, {-30,55}, {-30,56}, {-30,57}, {-30,58}, {-30,59}, {-30,60}, {-30,61}, {-30,62}, {-30,63}, {-30,64}, {-30,65}, {-30,66}, {-30,67}, {-30,68}, {-30,69}, {-30,70}, {-30,71}, {-30,76}, {-30,77}, {-30,86}, {-30,87}, {-30,91}, {-30,92}, {-30,93}, {-30,94}, {-30,95}, {-30,96}, {-30,97}, {-30,98}, {-30,99}, {-30,100}, {-30,101}, {-30,102}, {-30,103}, {-30,104}, {-30,105}, {-30,106}, {-30,107}, {-30,108}, {-30,109}, {-30,110}, {-30,111}, {-30,112}, {-30,113}, {-30,114}, {-30,115}, {-30,117}, {-30,118}, {-30,119}, {-30,125}, {-30,128}, {-30,134}, {-30,138}, {-30,139}, {-29,-73}, {-29,-72}, {-29,-66}, {-29,-65}, {-29,-61}, {-29,-60}, {-29,-26}, {-29,-25}, {-29,-16}, {-29,-13}, {-29,-12}, {-29,-7}, {-29,-6}, {-29,-2}, {-29,-1}, {-29,3}, {-29,4}, {-29,8}, {-29,9}, {-29,13}, {-29,14}, {-29,18}, {-29,19}, {-29,24}, {-29,25}, {-29,28}, {-29,30}, {-29,32}, {-29,34}, {-29,36}, {-29,37}, {-29,41}, {-29,71}, {-29,76}, {-29,77}, {-29,86}, {-29,87}, {-29,91}, {-29,92}, {-29,93}, {-29,94}, {-29,95}, {-29,96}, {-29,97}, {-29,98}, {-29,99}, {-29,100}, {-29,101}, {-29,102}, {-29,103}, {-29,104}, {-29,105}, {-29,106}, {-29,107}, {-29,108}, {-29,109}, {-29,110}, {-29,111}, {-29,112}, {-29,113}, {-29,114}, {-29,115}, {-29,117}, {-29,118}, {-29,119}, {-29,120}, {-29,121}, {-29,122}, {-29,123}, {-29,124}, {-29,125}, {-29,128}, {-29,129}, {-29,130}, {-29,131}, {-29,132}, {-29,133}, {-29,134}, {-29,138}, {-29,139}, {-28,-73}, {-28,-72}, {-28,-66}, {-28,-65}, {-28,-61}, {-28,-60}, {-28,-26}, {-28,-25}, {-28,-16}, {-28,-13}, {-28,-12}, {-28,24}, {-28,25}, {-28,30}, {-28,32}, {-28,34}, {-28,36}, {-28,37}, {-28,41}, {-28,68}, {-28,71}, {-28,76}, {-28,77}, {-28,86}, {-28,87}, {-28,138}, {-28,139}, {-27,-73}, {-27,-72}, {-27,-66}, {-27,-65}, {-27,-26}, {-27,-25}, {-27,-24}, {-27,-22}, {-27,-21}, {-27,-20}, {-27,-19}, {-27,-18}, {-27,-17}, {-27,-16}, {-27,-13}, {-27,-12}, {-27,28}, {-27,30}, {-27,32}, {-27,34}, {-27,36}, {-27,37}, {-27,41}, {-27,42}, {-27,43}, {-27,45}, {-27,46}, {-27,47}, {-27,48}, {-27,49}, {-27,50}, {-27,51}, {-27,52}, {-27,53}, {-27,54}, {-27,55}, {-27,56}, {-27,57}, {-27,58}, {-27,59}, {-27,60}, {-27,61}, {-27,62}, {-27,63}, {-27,64}, {-27,65}, {-27,66}, {-27,67}, {-27,68}, {-27,71}, {-27,76}, {-27,77}, {-27,78}, {-27,79}, {-27,80}, {-27,83}, {-27,84}, {-27,85}, {-27,86}, {-27,87}, {-27,138}, {-27,139}, {-27,145}, {-27,146}, {-27,147}, {-26,-73}, {-26,-72}, {-26,-66}, {-26,-65}, {-26,-61}, {-26,-60}, {-26,-26}, {-26,-25}, {-26,-13}, {-26,-12}, {-26,24}, {-26,25}, {-26,28}, {-26,30}, {-26,32}, {-26,34}, {-26,36}, {-26,37}, {-26,41}, {-26,57}, {-26,61}, {-26,62}, {-26,68}, {-26,71}, {-26,76}, {-26,77}, {-26,78}, {-26,79}, {-26,80}, {-26,83}, {-26,84}, {-26,85}, {-26,86}, {-26,87}, {-26,118}, {-26,119}, {-26,120}, {-26,121}, {-26,122}, {-26,123}, {-26,124}, {-26,125}, {-26,128}, {-26,129}, {-26,130}, {-26,131}, {-26,132}, {-26,133}, {-26,134}, {-26,138}, {-26,139}, {-26,145}, {-26,147}, {-25,-73}, {-25,-72}, {-25,-66}, {-25,-65}, {-25,-61}, {-25,-60}, {-25,-26}, {-25,-25}, {-25,-13}, {-25,-12}, {-25,-7}, {-25,-6}, {-25,-2}, {-25,-1}, {-25,3}, {-25,4}, {-25,8}, {-25,9}, {-25,13}, {-25,14}, {-25,18}, {-25,19}, {-25,24}, {-25,25}, {-25,28}, {-25,30}, {-25,32}, {-25,34}, {-25,36}, {-25,37}, {-25,41}, {-25,45}, {-25,46}, {-25,47}, {-25,48}, {-25,49}, {-25,50}, {-25,51}, {-25,52}, {-25,53}, {-25,57}, {-25,61}, {-25,62}, {-25,68}, {-25,71}, {-25,78}, {-25,85}, {-25,118}, {-25,119}, {-25,125}, {-25,128}, {-25,134}, {-25,138}, {-25,139}, {-25,145}, {-25,147}, {-24,-73}, {-24,-72}, {-24,-66}, {-24,-65}, {-24,-61}, {-24,-60}, {-24,-26}, {-24,-25}, {-24,-24}, {-24,-23}, {-24,-22}, {-24,-21}, {-24,-20}, {-24,-19}, {-24,-18}, {-24,-17}, {-24,-16}, {-24,-15}, {-24,-14}, {-24,-13}, {-24,-12}, {-24,-7}, {-24,-6}, {-24,-2}, {-24,-1}, {-24,3}, {-24,4}, {-24,8}, {-24,9}, {-24,13}, {-24,14}, {-24,18}, {-24,19}, {-24,24}, {-24,25}, {-24,26}, {-24,27}, {-24,28}, {-24,29}, {-24,30}, {-24,31}, {-24,32}, {-24,33}, {-24,34}, {-24,35}, {-24,36}, {-24,37}, {-24,41}, {-24,45}, {-24,53}, {-24,57}, {-24,68}, {-24,71}, {-24,78}, {-24,85}, {-24,118}, {-24,119}, {-24,125}, {-24,128}, {-24,134}, {-24,138}, {-24,139}, {-24,141}, {-24,142}, {-24,143}, {-24,144}, {-24,145}, {-24,147}, {-23,-73}, {-23,-72}, {-23,-66}, {-23,-65}, {-23,-61}, {-23,-60}, {-23,-26}, {-23,-25}, {-23,-24}, {-23,-23}, {-23,-22}, {-23,-21}, {-23,-20}, {-23,-19}, {-23,-18}, {-23,-17}, {-23,-16}, {-23,-15}, {-23,-14}, {-23,-13}, {-23,-12}, {-23,24}, {-23,25}, {-23,26}, {-23,27}, {-23,28}, {-23,29}, {-23,30}, {-23,31}, {-23,32}, {-23,33}, {-23,34}, {-23,35}, {-23,36}, {-23,37}, {-23,41}, {-23,45}, {-23,53}, {-23,57}, {-23,61}, {-23,62}, {-23,68}, {-23,71}, {-23,78}, {-23,79}, {-23,84}, {-23,85}, {-23,118}, {-23,119}, {-23,128}, {-23,138}, {-23,139}, {-23,147}, {-22,-73}, {-22,-72}, {-22,-66}, {-22,-65}, {-22,-61}, {-22,-60}, {-22,36}, {-22,37}, {-22,41}, {-22,45}, {-22,53}, {-22,57}, {-22,61}, {-22,62}, {-22,68}, {-22,71}, {-22,118}, {-22,119}, {-22,125}, {-22,128}, {-22,134}, {-22,138}, {-22,139}, {-22,140}, {-22,141}, {-22,142}, {-22,143}, {-22,144}, {-22,145}, {-22,147}, {-21,-73}, {-21,-72}, {-21,-66}, {-21,-65}, {-21,-61}, {-21,-60}, {-21,36}, {-21,37}, {-21,38}, {-21,39}, {-21,40}, {-21,41}, {-21,42}, {-21,43}, {-21,44}, {-21,45}, {-21,46}, {-21,47}, {-21,50}, {-21,51}, {-21,52}, {-21,53}, {-21,54}, {-21,55}, {-21,56}, {-21,57}, {-21,58}, {-21,59}, {-21,60}, {-21,61}, {-21,62}, {-21,63}, {-21,64}, {-21,66}, {-21,67}, {-21,68}, {-21,71}, {-21,118}, {-21,119}, {-21,125}, {-21,128}, {-21,134}, {-21,138}, {-21,139}, {-21,141}, {-21,147}, {-20,-73}, {-20,-72}, {-20,-66}, {-20,-65}, {-20,-61}, {-20,-60}, {-20,36}, {-20,37}, {-20,38}, {-20,39}, {-20,40}, {-20,41}, {-20,42}, {-20,43}, {-20,44}, {-20,45}, {-20,46}, {-20,47}, {-20,50}, {-20,51}, {-20,52}, {-20,53}, {-20,54}, {-20,55}, {-20,56}, {-20,57}, {-20,58}, {-20,59}, {-20,60}, {-20,61}, {-20,62}, {-20,63}, {-20,64}, {-20,66}, {-20,67}, {-20,68}, {-20,71}, {-20,118}, {-20,119}, {-20,121}, {-20,122}, {-20,123}, {-20,124}, {-20,125}, {-20,128}, {-20,130}, {-20,131}, {-20,132}, {-20,133}, {-20,134}, {-20,138}, {-20,139}, {-20,141}, {-20,147}, {-19,-73}, {-19,-72}, {-19,-66}, {-19,-65}, {-19,-61}, {-19,-60}, {-19,36}, {-19,37}, {-19,41}, {-19,42}, {-19,55}, {-19,56}, {-19,60}, {-19,61}, {-19,68}, {-19,71}, {-19,118}, {-19,119}, {-19,122}, {-19,125}, {-19,128}, {-19,131}, {-19,134}, {-19,138}, {-19,139}, {-19,141}, {-19,147}, {-18,-73}, {-18,-72}, {-18,-66}, {-18,-65}, {-18,-64}, {-18,-63}, {-18,-62}, {-18,-61}, {-18,-60}, {-18,36}, {-18,37}, {-18,41}, {-18,42}, {-18,68}, {-18,71}, {-18,118}, {-18,119}, {-18,122}, {-18,125}, {-18,128}, {-18,131}, {-18,134}, {-18,138}, {-18,139}, {-18,141}, {-18,147}, {-17,-73}, {-17,-72}, {-17,-66}, {-17,-65}, {-17,-61}, {-17,-60}, {-17,36}, {-17,37}, {-17,41}, {-17,42}, {-17,55}, {-17,56}, {-17,60}, {-17,61}, {-17,68}, {-17,71}, {-17,118}, {-17,119}, {-17,120}, {-17,121}, {-17,122}, {-17,123}, {-17,125}, {-17,128}, {-17,129}, {-17,130}, {-17,131}, {-17,132}, {-17,134}, {-17,138}, {-17,139}, {-17,147}, {-16,-73}, {-16,-72}, {-16,-66}, {-16,-65}, {-16,-61}, {-16,-60}, {-16,31}, {-16,32}, {-16,33}, {-16,34}, {-16,35}, {-16,36}, {-16,37}, {-16,38}, {-16,40}, {-16,41}, {-16,42}, {-16,43}, {-16,44}, {-16,45}, {-16,46}, {-16,47}, {-16,48}, {-16,49}, {-16,50}, {-16,51}, {-16,52}, {-16,53}, {-16,54}, {-16,55}, {-16,56}, {-16,57}, {-16,58}, {-16,59}, {-16,60}, {-16,61}, {-16,68}, {-16,71}, {-16,118}, {-16,119}, {-16,125}, {-16,128}, {-16,134}, {-16,138}, {-16,139}, {-16,141}, {-16,147}, {-15,-73}, {-15,-72}, {-15,-66}, {-15,-65}, {-15,-61}, {-15,-60}, {-15,31}, {-15,33}, {-15,36}, {-15,37}, {-15,38}, {-15,40}, {-15,41}, {-15,42}, {-15,43}, {-15,44}, {-15,45}, {-15,46}, {-15,47}, {-15,48}, {-15,49}, {-15,50}, {-15,51}, {-15,52}, {-15,53}, {-15,54}, {-15,55}, {-15,56}, {-15,57}, {-15,58}, {-15,59}, {-15,60}, {-15,61}, {-15,68}, {-15,71}, {-15,118}, {-15,119}, {-15,125}, {-15,128}, {-15,134}, {-15,138}, {-15,139}, {-15,141}, {-15,147}, {-14,-73}, {-14,-72}, {-14,-66}, {-14,-65}, {-14,-61}, {-14,-60}, {-14,31}, {-14,41}, {-14,42}, {-14,55}, {-14,56}, {-14,68}, {-14,71}, {-14,118}, {-14,119}, {-14,128}, {-14,138}, {-14,139}, {-14,141}, {-14,142}, {-14,143}, {-14,144}, {-14,145}, {-14,146}, {-14,147}, {-13,-73}, {-13,-72}, {-13,-66}, {-13,-65}, {-13,-61}, {-13,-60}, {-13,31}, {-13,33}, {-13,41}, {-13,42}, {-13,55}, {-13,56}, {-13,68}, {-13,71}, {-13,118}, {-13,119}, {-13,125}, {-13,128}, {-13,134}, {-13,138}, {-13,139}, {-13,141}, {-13,147}, {-12,-73}, {-12,-72}, {-12,-66}, {-12,-65}, {-12,-61}, {-12,-60}, {-12,31}, {-12,33}, {-12,37}, {-12,38}, {-12,41}, {-12,42}, {-12,45}, {-12,46}, {-12,51}, {-12,52}, {-12,55}, {-12,56}, {-12,59}, {-12,60}, {-12,68}, {-12,71}, {-12,118}, {-12,119}, {-12,125}, {-12,128}, {-12,134}, {-12,138}, {-12,139}, {-12,141}, {-12,145}, {-12,147}, {-11,-73}, {-11,-72}, {-11,-66}, {-11,-65}, {-11,-61}, {-11,-60}, {-11,31}, {-11,32}, {-11,33}, {-11,37}, {-11,38}, {-11,41}, {-11,42}, {-11,45}, {-11,46}, {-11,51}, {-11,52}, {-11,55}, {-11,56}, {-11,59}, {-11,60}, {-11,68}, {-11,71}, {-11,118}, {-11,119}, {-11,120}, {-11,121}, {-11,122}, {-11,123}, {-11,124}, {-11,125}, {-11,128}, {-11,129}, {-11,130}, {-11,131}, {-11,132}, {-11,133}, {-11,134}, {-11,138}, {-11,139}, {-11,141}, {-11,145}, {-11,147}, {-10,-73}, {-10,-72}, {-10,-66}, {-10,-65}, {-10,-61}, {-10,-60}, {-10,41}, {-10,42}, {-10,55}, {-10,56}, {-10,68}, {-10,71}, {-10,118}, {-10,119}, {-10,125}, {-10,128}, {-10,134}, {-10,138}, {-10,139}, {-10,141}, {-10,145}, {-10,147}, {-9,-73}, {-9,-72}, {-9,-66}, {-9,-65}, {-9,-61}, {-9,-60}, {-9,118}, {-9,119}, {-9,120}, {-9,125}, {-9,128}, {-9,129}, {-9,132}, {-9,133}, {-9,134}, {-9,138}, {-9,139}, {-9,145}, {-9,147}, {-8,-73}, {-8,-72}, {-8,-66}, {-8,-65}, {-8,-61}, {-8,-60}, {-8,118}, {-8,119}, {-8,125}, {-8,128}, {-8,134}, {-8,138}, {-8,139}, {-8,141}, {-8,145}, {-8,147}, {-7,-73}, {-7,-72}, {-7,-66}, {-7,-65}, {-7,-61}, {-7,-60}, {-7,41}, {-7,42}, {-7,55}, {-7,56}, {-7,68}, {-7,71}, {-7,118}, {-7,119}, {-7,128}, {-7,134}, {-7,138}, {-7,139}, {-7,141}, {-7,145}, {-7,147}, {-6,-73}, {-6,-72}, {-6,-66}, {-6,-65}, {-6,-61}, {-6,-60}, {-6,31}, {-6,32}, {-6,33}, {-6,37}, {-6,38}, {-6,41}, {-6,42}, {-6,45}, {-6,46}, {-6,51}, {-6,52}, {-6,55}, {-6,56}, {-6,59}, {-6,60}, {-6,68}, {-6,71}, {-6,118}, {-6,119}, {-6,125}, {-6,128}, {-6,134}, {-6,141}, {-6,142}, {-6,143}, {-6,144}, {-6,145}, {-6,146}, {-6,147}, {-5,-73}, {-5,-72}, {-5,-66}, {-5,-65}, {-5,-61}, {-5,-60}, {-5,31}, {-5,33}, {-5,37}, {-5,38}, {-5,41}, {-5,42}, {-5,45}, {-5,46}, {-5,51}, {-5,52}, {-5,55}, {-5,56}, {-5,59}, {-5,60}, {-5,68}, {-5,69}, {-5,70}, {-5,71}, {-5,72}, {-5,73}, {-5,75}, {-5,76}, {-5,77}, {-5,118}, {-5,119}, {-5,125}, {-5,128}, {-5,134}, {-5,141}, {-5,147}, {-4,-73}, {-4,-72}, {-4,-66}, {-4,-65}, {-4,-61}, {-4,-60}, {-4,31}, {-4,33}, {-4,41}, {-4,42}, {-4,55}, {-4,56}, {-4,68}, {-4,71}, {-4,77}, {-4,90}, {-4,91}, {-4,92}, {-4,93}, {-4,94}, {-4,95}, {-4,96}, {-4,97}, {-4,98}, {-4,99}, {-4,100}, {-4,101}, {-4,102}, {-4,103}, {-4,104}, {-4,105}, {-4,106}, {-4,107}, {-4,108}, {-4,109}, {-4,110}, {-4,111}, {-4,112}, {-4,113}, {-4,114}, {-4,115}, {-4,116}, {-4,117}, {-4,118}, {-4,119}, {-4,125}, {-4,128}, {-4,134}, {-4,138}, {-4,139}, {-4,141}, {-4,147}, {-3,-73}, {-3,-72}, {-3,-66}, {-3,-65}, {-3,-61}, {-3,-60}, {-3,31}, {-3,41}, {-3,42}, {-3,55}, {-3,56}, {-3,68}, {-3,90}, {-3,91}, {-3,92}, {-3,93}, {-3,94}, {-3,95}, {-3,96}, {-3,97}, {-3,98}, {-3,99}, {-3,100}, {-3,101}, {-3,102}, {-3,103}, {-3,104}, {-3,105}, {-3,106}, {-3,107}, {-3,108}, {-3,109}, {-3,110}, {-3,111}, {-3,112}, {-3,113}, {-3,114}, {-3,115}, {-3,116}, {-3,117}, {-3,118}, {-3,119}, {-3,120}, {-3,121}, {-3,122}, {-3,123}, {-3,124}, {-3,125}, {-3,128}, {-3,129}, {-3,131}, {-3,132}, {-3,133}, {-3,134}, {-3,138}, {-3,139}, {-3,147}, {-2,-73}, {-2,-72}, {-2,-66}, {-2,-65}, {-2,-61}, {-2,-60}, {-2,31}, {-2,33}, {-2,36}, {-2,37}, {-2,38}, {-2,39}, {-2,40}, {-2,41}, {-2,42}, {-2,43}, {-2,44}, {-2,45}, {-2,46}, {-2,47}, {-2,50}, {-2,51}, {-2,52}, {-2,53}, {-2,54}, {-2,55}, {-2,56}, {-2,57}, {-2,58}, {-2,59}, {-2,60}, {-2,61}, {-2,68}, {-2,71}, {-2,90}, {-2,91}, {-2,94}, {-2,119}, {-2,125}, {-2,128}, {-2,134}, {-2,138}, {-2,139}, {-2,141}, {-2,147}, {-1,-73}, {-1,-72}, {-1,-66}, {-1,-65}, {-1,-64}, {-1,-62}, {-1,-61}, {-1,-60}, {-1,31}, {-1,32}, {-1,33}, {-1,34}, {-1,35}, {-1,36}, {-1,37}, {-1,38}, {-1,39}, {-1,40}, {-1,41}, {-1,42}, {-1,43}, {-1,44}, {-1,45}, {-1,46}, {-1,47}, {-1,50}, {-1,51}, {-1,52}, {-1,53}, {-1,54}, {-1,55}, {-1,56}, {-1,57}, {-1,58}, {-1,59}, {-1,60}, {-1,61}, {-1,68}, {-1,71}, {-1,72}, {-1,73}, {-1,75}, {-1,76}, {-1,77}, {-1,90}, {-1,91}, {-1,94}, {-1,125}, {-1,134}, {-1,138}, {-1,139}, {-1,141}, {-1,147}, {0,-73}, {0,-72}, {0,-66}, {0,-65}, {0,-61}, {0,-60}, {0,36}, {0,37}, {0,41}, {0,42}, {0,55}, {0,56}, {0,60}, {0,61}, {0,68}, {0,71}, {0,77}, {0,90}, {0,91}, {0,94}, {0,96}, {0,97}, {0,98}, {0,99}, {0,100}, {0,101}, {0,102}, {0,104}, {0,105}, {0,106}, {0,107}, {0,108}, {0,109}, {0,110}, {0,111}, {0,113}, {0,114}, {0,115}, {0,116}, {0,119}, {0,125}, {0,128}, {0,134}, {0,138}, {0,139}, {0,141}, {0,147}, {1,-73}, {1,-72}, {1,-66}, {1,-65}, {1,-61}, {1,-60}, {1,36}, {1,37}, {1,60}, {1,61}, {1,68}, {1,71}, {1,77}, {1,90}, {1,91}, {1,94}, {1,99}, {1,102}, {1,108}, {1,111}, {1,116}, {1,119}, {1,120}, {1,122}, {1,123}, {1,124}, {1,125}, {1,128}, {1,129}, {1,130}, {1,131}, {1,132}, {1,133}, {1,134}, {1,138}, {1,139}, {1,141}, {1,147}, {2,-73}, {2,-72}, {2,-66}, {2,-65}, {2,-61}, {2,-60}, {2,36}, {2,37}, {2,41}, {2,42}, {2,55}, {2,56}, {2,60}, {2,61}, {2,68}, {2,71}, {2,77}, {2,90}, {2,91}, {2,94}, {2,102}, {2,111}, {2,116}, {2,119}, {2,125}, {2,128}, {2,134}, {2,138}, {2,139}, {2,141}, {2,142}, {2,143}, {2,144}, {2,145}, {2,147}, {3,-73}, {3,-72}, {3,-66}, {3,-65}, {3,-61}, {3,-60}, {3,36}, {3,37}, {3,38}, {3,39}, {3,40}, {3,41}, {3,42}, {3,43}, {3,44}, {3,45}, {3,46}, {3,47}, {3,48}, {3,49}, {3,50}, {3,51}, {3,52}, {3,54}, {3,55}, {3,56}, {3,57}, {3,58}, {3,59}, {3,60}, {3,61}, {3,62}, {3,63}, {3,64}, {3,65}, {3,66}, {3,67}, {3,68}, {3,69}, {3,70}, {3,71}, {3,72}, {3,73}, {3,74}, {3,75}, {3,76}, {3,77}, {3,78}, {3,79}, {3,80}, {3,81}, {3,82}, {3,83}, {3,84}, {3,85}, {3,86}, {3,87}, {3,88}, {3,89}, {3,90}, {3,91}, {3,94}, {3,99}, {3,102}, {3,108}, {3,111}, {3,116}, {3,119}, {3,125}, {3,128}, {3,138}, {3,139}, {3,141}, {3,147}, {4,-73}, {4,-72}, {4,-66}, {4,-65}, {4,36}, {4,37}, {4,38}, {4,39}, {4,40}, {4,41}, {4,42}, {4,43}, {4,44}, {4,45}, {4,46}, {4,47}, {4,48}, {4,49}, {4,50}, {4,51}, {4,52}, {4,54}, {4,55}, {4,56}, {4,57}, {4,58}, {4,59}, {4,60}, {4,61}, {4,62}, {4,63}, {4,64}, {4,65}, {4,66}, {4,67}, {4,68}, {4,69}, {4,70}, {4,71}, {4,72}, {4,73}, {4,74}, {4,75}, {4,76}, {4,77}, {4,78}, {4,79}, {4,80}, {4,81}, {4,82}, {4,83}, {4,84}, {4,85}, {4,86}, {4,87}, {4,88}, {4,89}, {4,90}, {4,91}, {4,94}, {4,95}, {4,96}, {4,97}, {4,98}, {4,99}, {4,100}, {4,101}, {4,102}, {4,103}, {4,104}, {4,105}, {4,106}, {4,107}, {4,108}, {4,109}, {4,110}, {4,111}, {4,112}, {4,113}, {4,114}, {4,115}, {4,116}, {4,119}, {4,120}, {4,121}, {4,122}, {4,123}, {4,124}, {4,125}, {4,128}, {4,129}, {4,130}, {4,131}, {4,132}, {4,133}, {4,134}, {4,135}, {4,136}, {4,137}, {4,138}, {4,139}, {4,141}, {4,142}, {4,143}, {4,144}, {4,145}, {4,146}, {4,147}, {5,-73}, {5,-72}, {5,-66}, {5,-65}, {5,-61}, {5,-60}, {5,36}, {5,37}, {5,38}, {5,39}, {5,40}, {5,41}, {5,42}, {5,43}, {5,44}, {5,45}, {5,46}, {5,47}, {5,48}, {5,49}, {5,50}, {5,51}, {5,52}, {5,54}, {5,55}, {5,56}, {5,57}, {5,58}, {5,59}, {5,60}, {5,61}, {5,77}, {5,85}, {5,91}, {5,134}, {5,138}, {5,139}, {5,141}, {5,147}, {6,-73}, {6,-72}, {6,-66}, {6,-65}, {6,-61}, {6,-60}, {6,36}, {6,37}, {6,50}, {6,51}, {6,55}, {6,60}, {6,61}, {6,77}, {6,138}, {6,139}, {6,147}, {7,-73}, {7,-72}, {7,-66}, {7,-65}, {7,-61}, {7,-60}, {7,36}, {7,37}, {7,60}, {7,61}, {7,66}, {7,77}, {7,85}, {7,91}, {7,134}, {7,138}, {7,139}, {7,141}, {7,147}, {8,-73}, {8,-72}, {8,-66}, {8,-65}, {8,-61}, {8,-60}, {8,36}, {8,37}, {8,60}, {8,61}, {8,66}, {8,67}, {8,68}, {8,69}, {8,70}, {8,72}, {8,73}, {8,74}, {8,75}, {8,76}, {8,77}, {8,78}, {8,79}, {8,80}, {8,81}, {8,82}, {8,83}, {8,84}, {8,85}, {8,86}, {8,87}, {8,88}, {8,89}, {8,90}, {8,91}, {8,92}, {8,94}, {8,95}, {8,96}, {8,97}, {8,98}, {8,99}, {8,100}, {8,101}, {8,102}, {8,103}, {8,104}, {8,105}, {8,106}, {8,107}, {8,109}, {8,110}, {8,111}, {8,112}, {8,114}, {8,115}, {8,116}, {8,117}, {8,118}, {8,119}, {8,120}, {8,122}, {8,123}, {8,124}, {8,125}, {8,126}, {8,127}, {8,128}, {8,130}, {8,131}, {8,132}, {8,133}, {8,134}, {8,135}, {8,137}, {8,138}, {8,139}, {8,140}, {8,141}, {8,142}, {8,143}, {8,144}, {8,145}, {8,146}, {8,147}, {9,-73}, {9,-72}, {9,-66}, {9,-65}, {9,-61}, {9,-60}, {9,36}, {9,37}, {9,50}, {9,51}, {9,55}, {9,60}, {9,61}, {9,66}, {9,75}, {9,85}, {9,91}, {9,101}, {9,106}, {9,110}, {9,116}, {9,118}, {9,124}, {9,126}, {9,132}, {9,134}, {9,138}, {9,139}, {10,-73}, {10,-72}, {10,-66}, {10,-65}, {10,-64}, {10,-63}, {10,-62}, {10,-61}, {10,-60}, {10,-59}, {10,-58}, {10,-57}, {10,-56}, {10,-55}, {10,-54}, {10,-53}, {10,-52}, {10,-50}, {10,-49}, {10,-48}, {10,-47}, {10,-46}, {10,-45}, {10,-44}, {10,-43}, {10,-41}, {10,-40}, {10,-39}, {10,-38}, {10,-37}, {10,-36}, {10,-35}, {10,-34}, {10,-33}, {10,-32}, {10,-31}, {10,-30}, {10,-29}, {10,-28}, {10,-27}, {10,-26}, {10,-25}, {10,-24}, {10,-23}, {10,-22}, {10,-21}, {10,-20}, {10,-19}, {10,-18}, {10,-17}, {10,-16}, {10,-15}, {10,-14}, {10,-13}, {10,-12}, {10,-11}, {10,-10}, {10,-9}, {10,-8}, {10,-7}, {10,-6}, {10,-5}, {10,-4}, {10,-3}, {10,-2}, {10,-1}, {10,0}, {10,1}, {10,2}, {10,3}, {10,4}, {10,5}, {10,6}, {10,7}, {10,8}, {10,9}, {10,10}, {10,11}, {10,12}, {10,13}, {10,14}, {10,15}, {10,16}, {10,17}, {10,18}, {10,19}, {10,20}, {10,21}, {10,22}, {10,23}, {10,24}, {10,25}, {10,26}, {10,27}, {10,28}, {10,29}, {10,30}, {10,31}, {10,32}, {10,33}, {10,34}, {10,35}, {10,36}, {10,37}, {10,38}, {10,39}, {10,40}, {10,41}, {10,42}, {10,43}, {10,44}, {10,45}, {10,46}, {10,47}, {10,48}, {10,49}, {10,50}, {10,51}, {10,52}, {10,54}, {10,55}, {10,56}, {10,57}, {10,58}, {10,59}, {10,60}, {10,61}, {10,66}, {10,75}, {10,85}, {10,91}, {10,101}, {10,106}, {10,110}, {10,116}, {10,118}, {10,124}, {10,126}, {10,132}, {10,134}, {10,138}, {10,139}, {11,-73}, {11,-72}, {11,-66}, {11,-65}, {11,-64}, {11,-63}, {11,-62}, {11,-61}, {11,-60}, {11,-59}, {11,-58}, {11,-57}, {11,-56}, {11,-55}, {11,-54}, {11,-53}, {11,-52}, {11,-50}, {11,-49}, {11,-48}, {11,-47}, {11,-46}, {11,-45}, {11,-44}, {11,-43}, {11,-41}, {11,-40}, {11,-39}, {11,-38}, {11,-37}, {11,-36}, {11,-35}, {11,-34}, {11,-33}, {11,-32}, {11,-31}, {11,-30}, {11,-29}, {11,-28}, {11,-27}, {11,-26}, {11,-25}, {11,-24}, {11,-23}, {11,-22}, {11,-21}, {11,-20}, {11,-19}, {11,-18}, {11,-17}, {11,-16}, {11,-15}, {11,-14}, {11,-13}, {11,-12}, {11,-11}, {11,-10}, {11,-9}, {11,-8}, {11,-7}, {11,-6}, {11,-5}, {11,-4}, {11,-3}, {11,-2}, {11,-1}, {11,0}, {11,1}, {11,2}, {11,3}, {11,4}, {11,5}, {11,6}, {11,7}, {11,8}, {11,9}, {11,10}, {11,11}, {11,12}, {11,13}, {11,14}, {11,15}, {11,16}, {11,17}, {11,18}, {11,19}, {11,20}, {11,21}, {11,22}, {11,23}, {11,24}, {11,25}, {11,26}, {11,27}, {11,28}, {11,29}, {11,30}, {11,31}, {11,32}, {11,33}, {11,34}, {11,35}, {11,36}, {11,37}, {11,38}, {11,39}, {11,40}, {11,41}, {11,42}, {11,43}, {11,44}, {11,45}, {11,46}, {11,47}, {11,48}, {11,49}, {11,50}, {11,51}, {11,52}, {11,54}, {11,55}, {11,56}, {11,57}, {11,58}, {11,59}, {11,60}, {11,61}, {11,62}, {11,63}, {11,64}, {11,65}, {11,66}, {11,68}, {11,69}, {11,70}, {11,71}, {11,72}, {11,74}, {11,75}, {11,85}, {11,86}, {11,87}, {11,88}, {11,90}, {11,91}, {11,92}, {11,93}, {11,94}, {11,96}, {11,97}, {11,98}, {11,99}, {11,100}, {11,101}, {11,102}, {11,104}, {11,105}, {11,106}, {11,110}, {11,116}, {11,118}, {11,124}, {11,126}, {11,132}, {11,134}, {11,138}, {11,139}, {12,-73}, {12,-72}, {12,-66}, {12,-65}, {12,-52}, {12,-50}, {12,-30}, {12,-29}, {12,-22}, {12,-21}, {12,-7}, {12,-6}, {12,1}, {12,2}, {12,23}, {12,24}, {12,46}, {12,50}, {12,51}, {12,71}, {12,91}, {12,101}, {12,106}, {12,110}, {12,118}, {12,126}, {12,134}, {12,138}, {12,139}, {13,-73}, {13,-72}, {13,-66}, {13,-65}, {13,-50}, {13,-30}, {13,-29}, {13,-22}, {13,-21}, {13,-7}, {13,-6}, {13,1}, {13,2}, {13,23}, {13,24}, {13,50}, {13,51}, {13,71}, {13,91}, {13,101}, {13,106}, {13,110}, {13,116}, {13,118}, {13,124}, {13,126}, {13,132}, {13,134}, {13,138}, {13,139}, {14,-79}, {14,-78}, {14,-77}, {14,-76}, {14,-75}, {14,-74}, {14,-73}, {14,-72}, {14,-66}, {14,-65}, {14,-52}, {14,-50}, {14,-30}, {14,-29}, {14,-22}, {14,-21}, {14,-7}, {14,-6}, {14,1}, {14,2}, {14,23}, {14,24}, {14,46}, {14,50}, {14,51}, {14,52}, {14,54}, {14,55}, {14,56}, {14,57}, {14,58}, {14,59}, {14,60}, {14,61}, {14,62}, {14,63}, {14,64}, {14,66}, {14,67}, {14,68}, {14,69}, {14,70}, {14,71}, {14,91}, {14,106}, {14,110}, {14,111}, {14,112}, {14,113}, {14,114}, {14,115}, {14,116}, {14,117}, {14,118}, {14,119}, {14,120}, {14,121}, {14,122}, {14,123}, {14,124}, {14,125}, {14,126}, {14,127}, {14,128}, {14,129}, {14,130}, {14,131}, {14,132}, {14,133}, {14,134}, {14,138}, {14,139}, {15,-87}, {15,-86}, {15,-85}, {15,-84}, {15,-83}, {15,-82}, {15,-81}, {15,-80}, {15,-79}, {15,-78}, {15,-77}, {15,-76}, {15,-75}, {15,-74}, {15,-73}, {15,-72}, {15,-66}, {15,-65}, {15,-64}, {15,-63}, {15,-62}, {15,-61}, {15,-60}, {15,-59}, {15,-58}, {15,-57}, {15,-56}, {15,-55}, {15,-54}, {15,-53}, {15,-52}, {15,-50}, {15,-49}, {15,-48}, {15,-47}, {15,-46}, {15,-45}, {15,-44}, {15,-43}, {15,-42}, {15,-41}, {15,-40}, {15,-39}, {15,-38}, {15,-37}, {15,-36}, {15,-35}, {15,-34}, {15,-33}, {15,-32}, {15,-31}, {15,-30}, {15,-29}, {15,-28}, {15,-27}, {15,-26}, {15,-25}, {15,-24}, {15,-22}, {15,-21}, {15,-20}, {15,-19}, {15,-18}, {15,-17}, {15,-16}, {15,-13}, {15,-12}, {15,-11}, {15,-10}, {15,-9}, {15,-8}, {15,-7}, {15,-6}, {15,-5}, {15,-4}, {15,-3}, {15,-2}, {15,0}, {15,1}, {15,2}, {15,3}, {15,4}, {15,5}, {15,6}, {15,7}, {15,8}, {15,9}, {15,10}, {15,11}, {15,12}, {15,13}, {15,14}, {15,17}, {15,18}, {15,19}, {15,20}, {15,21}, {15,22}, {15,23}, {15,24}, {15,25}, {15,26}, {15,27}, {15,28}, {15,29}, {15,30}, {15,33}, {15,34}, {15,35}, {15,36}, {15,37}, {15,38}, {15,39}, {15,40}, {15,41}, {15,42}, {15,43}, {15,44}, {15,45}, {15,46}, {15,50}, {15,51}, {15,55}, {15,63}, {15,67}, {15,71}, {15,91}, {15,101}, {15,106}, {15,138}, {15,139}, {16,-87}, {16,-86}, {16,-85}, {16,-84}, {16,-83}, {16,-82}, {16,-81}, {16,-80}, {16,-79}, {16,-78}, {16,-77}, {16,-76}, {16,-75}, {16,-74}, {16,-73}, {16,-72}, {16,-66}, {16,-65}, {16,-64}, {16,-63}, {16,-62}, {16,-61}, {16,-60}, {16,-59}, {16,-58}, {16,-57}, {16,-56}, {16,-55}, {16,-54}, {16,-53}, {16,-52}, {16,-50}, {16,-49}, {16,-48}, {16,-47}, {16,-46}, {16,-45}, {16,-44}, {16,-43}, {16,-42}, {16,-41}, {16,-40}, {16,-39}, {16,-38}, {16,-37}, {16,-36}, {16,-35}, {16,-34}, {16,-33}, {16,-32}, {16,-31}, {16,-30}, {16,-29}, {16,-28}, {16,-27}, {16,-26}, {16,-25}, {16,-24}, {16,-22}, {16,-21}, {16,-20}, {16,-19}, {16,-18}, {16,-17}, {16,-16}, {16,-13}, {16,-12}, {16,-11}, {16,-10}, {16,-9}, {16,-8}, {16,-7}, {16,-6}, {16,-5}, {16,-4}, {16,-3}, {16,-2}, {16,0}, {16,1}, {16,2}, {16,3}, {16,4}, {16,5}, {16,6}, {16,7}, {16,8}, {16,9}, {16,10}, {16,11}, {16,12}, {16,13}, {16,14}, {16,17}, {16,18}, {16,19}, {16,20}, {16,21}, {16,22}, {16,23}, {16,24}, {16,25}, {16,26}, {16,27}, {16,28}, {16,29}, {16,30}, {16,33}, {16,34}, {16,35}, {16,36}, {16,37}, {16,38}, {16,39}, {16,40}, {16,41}, {16,42}, {16,43}, {16,44}, {16,45}, {16,46}, {16,50}, {16,51}, {16,55}, {16,67}, {16,71}, {16,101}, {16,106}, {16,138}, {16,139}, {17,-86}, {17,-7}, {17,-6}, {17,1}, {17,2}, {17,45}, {17,46}, {17,50}, {17,51}, {17,55}, {17,63}, {17,67}, {17,71}, {17,91}, {17,101}, {17,106}, {17,138}, {17,139}, {18,-86}, {18,-7}, {18,-6}, {18,1}, {18,2}, {18,45}, {18,46}, {18,50}, {18,51}, {18,55}, {18,63}, {18,67}, {18,71}, {18,91}, {18,101}, {18,106}, {18,110}, {18,111}, {18,112}, {18,114}, {18,115}, {18,116}, {18,117}, {18,118}, {18,119}, {18,120}, {18,122}, {18,123}, {18,124}, {18,125}, {18,126}, {18,127}, {18,128}, {18,130}, {18,131}, {18,132}, {18,133}, {18,134}, {18,138}, {18,139}, {19,-86}, {19,-8}, {19,-7}, {19,-6}, {19,-5}, {19,-4}, {19,-3}, {19,-2}, {19,0}, {19,1}, {19,2}, {19,5}, {19,6}, {19,9}, {19,10}, {19,13}, {19,14}, {19,17}, {19,18}, {19,21}, {19,22}, {19,25}, {19,26}, {19,29}, {19,30}, {19,33}, {19,34}, {19,37}, {19,38}, {19,41}, {19,42}, {19,45}, {19,46}, {19,50}, {19,51}, {19,55}, {19,63}, {19,67}, {19,71}, {19,91}, {19,101}, {19,106}, {19,110}, {19,116}, {19,118}, {19,124}, {19,126}, {19,132}, {19,134}, {19,138}, {19,139}, {20,-86}, {20,-85}, {20,-84}, {20,-8}, {20,-7}, {20,-6}, {20,-5}, {20,-4}, {20,-3}, {20,-2}, {20,0}, {20,1}, {20,2}, {20,5}, {20,6}, {20,9}, {20,10}, {20,13}, {20,14}, {20,17}, {20,18}, {20,21}, {20,22}, {20,25}, {20,26}, {20,29}, {20,30}, {20,33}, {20,34}, {20,37}, {20,38}, {20,41}, {20,42}, {20,45}, {20,46}, {20,50}, {20,51}, {20,55}, {20,63}, {20,64}, {20,65}, {20,66}, {20,67}, {20,71}, {20,91}, {20,101}, {20,106}, {20,110}, {20,116}, {20,118}, {20,124}, {20,126}, {20,132}, {20,134}, {20,138}, {20,139}, {21,-86}, {21,-85}, {21,-84}, {21,-66}, {21,-65}, {21,-64}, {21,-63}, {21,-62}, {21,-61}, {21,-60}, {21,-59}, {21,-58}, {21,-57}, {21,-56}, {21,-55}, {21,-54}, {21,-53}, {21,-52}, {21,-51}, {21,-50}, {21,-49}, {21,-48}, {21,-47}, {21,-46}, {21,-45}, {21,-44}, {21,-43}, {21,1}, {21,2}, {21,45}, {21,46}, {21,50}, {21,51}, {21,55}, {21,63}, {21,67}, {21,71}, {21,72}, {21,74}, {21,75}, {21,85}, {21,86}, {21,87}, {21,88}, {21,90}, {21,91}, {21,96}, {21,97}, {21,98}, {21,99}, {21,100}, {21,101}, {21,102}, {21,106}, {21,110}, {21,116}, {21,118}, {21,124}, {21,126}, {21,132}, {21,134}, {21,138}, {21,139}, {22,-85}, {22,-84}, {22,-66}, {22,-65}, {22,-64}, {22,-63}, {22,-62}, {22,-61}, {22,-60}, {22,-59}, {22,-58}, {22,-57}, {22,-56}, {22,-55}, {22,-54}, {22,-53}, {22,-52}, {22,-51}, {22,-50}, {22,-49}, {22,-48}, {22,-47}, {22,-46}, {22,-45}, {22,-44}, {22,-43}, {22,1}, {22,2}, {22,45}, {22,46}, {22,50}, {22,51}, {22,55}, {22,56}, {22,58}, {22,59}, {22,60}, {22,61}, {22,62}, {22,63}, {22,67}, {22,71}, {22,75}, {22,85}, {22,91}, {22,101}, {22,106}, {22,110}, {22,118}, {22,126}, {22,134}, {22,138}, {22,139}, {23,-85}, {23,-84}, {23,-66}, {23,-65}, {23,-64}, {23,-63}, {23,-62}, {23,-61}, {23,-60}, {23,-59}, {23,-58}, {23,-57}, {23,-56}, {23,-55}, {23,-54}, {23,-53}, {23,-52}, {23,-51}, {23,-50}, {23,-49}, {23,-48}, {23,-47}, {23,-46}, {23,-45}, {23,-44}, {23,-43}, {23,-7}, {23,-6}, {23,-3}, {23,-2}, {23,1}, {23,2}, {23,5}, {23,6}, {23,9}, {23,10}, {23,13}, {23,14}, {23,17}, {23,18}, {23,21}, {23,22}, {23,25}, {23,26}, {23,29}, {23,30}, {23,33}, {23,34}, {23,37}, {23,38}, {23,41}, {23,42}, {23,45}, {23,46}, {23,50}, {23,51}, {23,55}, {23,63}, {23,67}, {23,71}, {23,75}, {23,85}, {23,91}, {23,101}, {23,106}, {23,110}, {23,116}, {23,118}, {23,124}, {23,126}, {23,132}, {23,134}, {23,138}, {23,139}, {24,-85}, {24,-84}, {24,-66}, {24,-65}, {24,-64}, {24,-63}, {24,-62}, {24,-61}, {24,-60}, {24,-59}, {24,-58}, {24,-57}, {24,-56}, {24,-55}, {24,-54}, {24,-53}, {24,-52}, {24,-51}, {24,-50}, {24,-49}, {24,-48}, {24,-47}, {24,-46}, {24,-45}, {24,-44}, {24,-43}, {24,-7}, {24,-6}, {24,-3}, {24,-2}, {24,1}, {24,2}, {24,5}, {24,6}, {24,9}, {24,10}, {24,13}, {24,14}, {24,17}, {24,18}, {24,21}, {24,22}, {24,25}, {24,26}, {24,29}, {24,30}, {24,33}, {24,34}, {24,37}, {24,38}, {24,41}, {24,42}, {24,45}, {24,46}, {24,50}, {24,51}, {24,52}, {24,53}, {24,54}, {24,55}, {24,63}, {24,64}, {24,66}, {24,67}, {24,68}, {24,69}, {24,70}, {24,71}, {24,72}, {24,73}, {24,74}, {24,75}, {24,76}, {24,77}, {24,78}, {24,79}, {24,80}, {24,81}, {24,82}, {24,83}, {24,84}, {24,85}, {24,86}, {24,87}, {24,88}, {24,90}, {24,91}, {24,92}, {24,93}, {24,94}, {24,95}, {24,96}, {24,97}, {24,98}, {24,99}, {24,100}, {24,101}, {24,102}, {24,103}, {24,104}, {24,105}, {24,106}, {24,110}, {24,111}, {24,112}, {24,113}, {24,115}, {24,116}, {24,117}, {24,118}, {24,119}, {24,120}, {24,121}, {24,123}, {24,124}, {24,125}, {24,126}, {24,127}, {24,128}, {24,129}, {24,131}, {24,132}, {24,133}, {24,134}, {24,138}, {24,139}, {25,-85}, {25,-84}, {25,-83}, {25,-67}, {25,-66}, {25,-65}, {25,-64}, {25,-63}, {25,-62}, {25,-61}, {25,-60}, {25,-59}, {25,-58}, {25,-57}, {25,-56}, {25,-55}, {25,-54}, {25,-53}, {25,-52}, {25,-51}, {25,-50}, {25,-49}, {25,-48}, {25,-47}, {25,-46}, {25,-45}, {25,-44}, {25,-43}, {25,-42}, {25,1}, {25,2}, {25,45}, {25,46}, {25,50}, {25,51}, {25,55}, {25,63}, {25,75}, {25,80}, {25,95}, {25,106}, {25,110}, {25,118}, {25,126}, {25,134}, {25,138}, {25,139}, {26,-84}, {26,-83}, {26,-66}, {26,-65}, {26,-64}, {26,-63}, {26,-62}, {26,-61}, {26,-60}, {26,-59}, {26,-58}, {26,-57}, {26,-56}, {26,-55}, {26,-54}, {26,-53}, {26,-52}, {26,-51}, {26,-50}, {26,-49}, {26,-48}, {26,-47}, {26,-46}, {26,-45}, {26,-44}, {26,-43}, {26,1}, {26,2}, {26,45}, {26,46}, {26,63}, {26,80}, {26,95}, {26,110}, {26,118}, {26,126}, {26,134}, {26,138}, {26,139}, {27,-84}, {27,-83}, {27,-66}, {27,-65}, {27,-64}, {27,-63}, {27,-62}, {27,-61}, {27,-60}, {27,-59}, {27,-58}, {27,-57}, {27,-56}, {27,-55}, {27,-54}, {27,-53}, {27,-52}, {27,-51}, {27,-50}, {27,-49}, {27,-48}, {27,-47}, {27,-46}, {27,-45}, {27,-44}, {27,-43}, {27,-7}, {27,-6}, {27,-3}, {27,-2}, {27,1}, {27,2}, {27,5}, {27,6}, {27,9}, {27,10}, {27,13}, {27,14}, {27,17}, {27,18}, {27,21}, {27,22}, {27,25}, {27,26}, {27,29}, {27,30}, {27,33}, {27,34}, {27,37}, {27,38}, {27,41}, {27,42}, {27,45}, {27,46}, {27,50}, {27,51}, {27,55}, {27,63}, {27,75}, {27,80}, {27,95}, {27,106}, {27,110}, {27,118}, {27,126}, {27,134}, {27,138}, {27,139}, {28,-84}, {28,-83}, {28,-82}, {28,-67}, {28,-66}, {28,-65}, {28,-64}, {28,-63}, {28,-62}, {28,-61}, {28,-60}, {28,-59}, {28,-58}, {28,-57}, {28,-56}, {28,-55}, {28,-54}, {28,-53}, {28,-52}, {28,-51}, {28,-50}, {28,-49}, {28,-48}, {28,-47}, {28,-46}, {28,-45}, {28,-44}, {28,-43}, {28,-42}, {28,-7}, {28,-6}, {28,-3}, {28,-2}, {28,1}, {28,2}, {28,5}, {28,6}, {28,9}, {28,10}, {28,13}, {28,14}, {28,17}, {28,18}, {28,21}, {28,22}, {28,25}, {28,26}, {28,29}, {28,30}, {28,33}, {28,34}, {28,37}, {28,38}, {28,41}, {28,42}, {28,45}, {28,46}, {28,50}, {28,51}, {28,52}, {28,53}, {28,54}, {28,55}, {28,56}, {28,57}, {28,58}, {28,59}, {28,60}, {28,61}, {28,62}, {28,63}, {28,64}, {28,65}, {28,66}, {28,67}, {28,68}, {28,69}, {28,70}, {28,71}, {28,72}, {28,73}, {28,74}, {28,75}, {28,76}, {28,77}, {28,78}, {28,79}, {28,80}, {28,81}, {28,82}, {28,83}, {28,84}, {28,85}, {28,86}, {28,87}, {28,88}, {28,89}, {28,90}, {28,91}, {28,92}, {28,93}, {28,94}, {28,95}, {28,96}, {28,97}, {28,98}, {28,99}, {28,100}, {28,101}, {28,102}, {28,103}, {28,104}, {28,105}, {28,106}, {28,107}, {28,108}, {28,109}, {28,110}, {28,111}, {28,112}, {28,113}, {28,114}, {28,115}, {28,116}, {28,117}, {28,118}, {28,119}, {28,120}, {28,121}, {28,122}, {28,123}, {28,124}, {28,125}, {28,126}, {28,127}, {28,128}, {28,129}, {28,130}, {28,131}, {28,132}, {28,133}, {28,134}, {28,135}, {28,136}, {28,137}, {28,138}, {28,139}, {29,-84}, {29,-83}, {29,-82}, {29,-66}, {29,-65}, {29,-64}, {29,-63}, {29,-46}, {29,-45}, {29,-44}, {29,-43}, {29,50}, {29,51}, {30,-83}, {30,-82}, {30,-66}, {30,-65}, {30,-64}, {30,-63}, {30,-46}, {30,-45}, {30,-44}, {30,-43}, {30,50}, {30,51}, {31,-83}, {31,-82}, {31,-67}, {31,-66}, {31,-65}, {31,-64}, {31,-63}, {31,-46}, {31,-45}, {31,-44}, {31,-43}, {31,-42}, {31,-7}, {31,-6}, {31,-3}, {31,-2}, {31,1}, {31,2}, {31,5}, {31,6}, {31,9}, {31,10}, {31,13}, {31,14}, {31,17}, {31,18}, {31,21}, {31,22}, {31,25}, {31,26}, {31,29}, {31,30}, {31,33}, {31,34}, {31,37}, {31,38}, {31,41}, {31,42}, {31,45}, {31,46}, {31,50}, {31,51}, {32,-83}, {32,-82}, {32,-81}, {32,-66}, {32,-65}, {32,-64}, {32,-63}, {32,-46}, {32,-45}, {32,-44}, {32,-43}, {32,-7}, {32,-6}, {32,-3}, {32,-2}, {32,1}, {32,2}, {32,5}, {32,6}, {32,9}, {32,10}, {32,13}, {32,14}, {32,17}, {32,18}, {32,21}, {32,22}, {32,25}, {32,26}, {32,29}, {32,30}, {32,33}, {32,34}, {32,37}, {32,38}, {32,41}, {32,42}, {32,45}, {32,46}, {32,50}, {32,51}, {33,-82}, {33,-81}, {33,-66}, {33,-65}, {33,-64}, {33,-63}, {33,-59}, {33,-58}, {33,-57}, {33,-52}, {33,-51}, {33,-50}, {33,-46}, {33,-45}, {33,-44}, {33,-43}, {33,1}, {33,2}, {33,45}, {33,46}, {33,50}, {33,51}, {34,-82}, {34,-81}, {34,-67}, {34,-66}, {34,-65}, {34,-64}, {34,-63}, {34,-59}, {34,-58}, {34,-57}, {34,-52}, {34,-51}, {34,-50}, {34,-46}, {34,-45}, {34,-44}, {34,-43}, {34,-42}, {34,1}, {34,2}, {34,45}, {34,46}, {34,50}, {34,51}, {34,57}, {34,58}, {34,59}, {34,60}, {34,61}, {34,62}, {34,63}, {34,64}, {34,65}, {34,66}, {34,67}, {34,68}, {34,69}, {34,70}, {34,71}, {34,72}, {34,73}, {34,74}, {34,75}, {34,76}, {34,77}, {34,78}, {34,79}, {34,80}, {34,81}, {34,82}, {34,83}, {34,84}, {34,85}, {34,86}, {34,87}, {34,88}, {34,89}, {34,90}, {34,91}, {34,92}, {34,93}, {34,94}, {34,95}, {34,96}, {34,97}, {34,98}, {34,99}, {34,100}, {34,101}, {34,102}, {34,103}, {34,104}, {34,105}, {34,106}, {34,107}, {34,108}, {34,109}, {34,110}, {34,111}, {34,112}, {34,113}, {34,114}, {34,115}, {34,116}, {34,117}, {34,118}, {34,119}, {34,120}, {34,121}, {34,122}, {34,123}, {34,124}, {34,125}, {34,126}, {34,127}, {34,128}, {34,129}, {34,130}, {34,131}, {34,132}, {34,133}, {34,134}, {34,135}, {34,136}, {34,137}, {34,138}, {34,139}, {34,140}, {34,141}, {34,142}, {34,143}, {34,144}, {35,-82}, {35,-81}, {35,-67}, {35,-66}, {35,-65}, {35,-64}, {35,-63}, {35,-59}, {35,-58}, {35,-57}, {35,-52}, {35,-51}, {35,-50}, {35,-46}, {35,-45}, {35,-44}, {35,-43}, {35,-42}, {35,-7}, {35,-6}, {35,-3}, {35,-2}, {35,1}, {35,2}, {35,5}, {35,6}, {35,9}, {35,10}, {35,13}, {35,14}, {35,17}, {35,18}, {35,21}, {35,22}, {35,25}, {35,26}, {35,29}, {35,30}, {35,33}, {35,34}, {35,37}, {35,38}, {35,41}, {35,42}, {35,45}, {35,46}, {35,50}, {35,51}, {35,57}, {35,58}, {35,59}, {35,60}, {35,61}, {35,62}, {35,63}, {35,64}, {35,65}, {35,66}, {35,67}, {35,68}, {35,69}, {35,70}, {35,71}, {35,72}, {35,73}, {35,74}, {35,75}, {35,76}, {35,77}, {35,78}, {35,79}, {35,80}, {35,81}, {35,82}, {35,83}, {35,84}, {35,85}, {35,86}, {35,87}, {35,88}, {35,89}, {35,90}, {35,91}, {35,92}, {35,93}, {35,94}, {35,95}, {35,96}, {35,97}, {35,98}, {35,99}, {35,100}, {35,101}, {35,102}, {35,103}, {35,104}, {35,105}, {35,106}, {35,107}, {35,108}, {35,109}, {35,110}, {35,111}, {35,112}, {35,113}, {35,114}, {35,115}, {35,116}, {35,117}, {35,118}, {35,119}, {35,120}, {35,121}, {35,122}, {35,123}, {35,124}, {35,125}, {35,126}, {35,127}, {35,128}, {35,129}, {35,130}, {35,131}, {35,132}, {35,133}, {35,134}, {35,135}, {35,136}, {35,137}, {35,138}, {35,139}, {35,140}, {35,141}, {35,142}, {35,143}, {35,144}, {36,-82}, {36,-81}, {36,-80}, {36,-7}, {36,-6}, {36,-3}, {36,-2}, {36,1}, {36,2}, {36,5}, {36,6}, {36,9}, {36,10}, {36,13}, {36,14}, {36,17}, {36,18}, {36,21}, {36,22}, {36,25}, {36,26}, {36,29}, {36,30}, {36,33}, {36,34}, {36,37}, {36,38}, {36,41}, {36,42}, {36,45}, {36,46}, {36,50}, {36,51}, {36,57}, {36,58}, {36,62}, {36,68}, {36,74}, {36,75}, {36,79}, {36,80}, {36,88}, {36,96}, {36,104}, {36,105}, {36,109}, {36,127}, {36,139}, {36,143}, {36,144}, {37,-82}, {37,-81}, {37,-80}, {37,1}, {37,2}, {37,45}, {37,46}, {37,50}, {37,51}, {37,57}, {37,58}, {37,68}, {37,74}, {37,75}, {37,79}, {37,80}, {37,104}, {37,105}, {37,127}, {37,143}, {37,144}, {38,-81}, {38,-80}, {38,1}, {38,2}, {38,45}, {38,46}, {38,50}, {38,51}, {38,57}, {38,58}, {38,62}, {38,68}, {38,74}, {38,75}, {38,79}, {38,80}, {38,88}, {38,96}, {38,104}, {38,105}, {38,109}, {38,127}, {38,139}, {38,143}, {38,144}, {39,-81}, {39,-80}, {39,-7}, {39,-6}, {39,-3}, {39,-2}, {39,1}, {39,2}, {39,5}, {39,6}, {39,9}, {39,10}, {39,13}, {39,14}, {39,17}, {39,18}, {39,21}, {39,22}, {39,25}, {39,26}, {39,29}, {39,30}, {39,33}, {39,34}, {39,37}, {39,38}, {39,41}, {39,42}, {39,45}, {39,46}, {39,50}, {39,51}, {39,57}, {39,58}, {39,59}, {39,60}, {39,61}, {39,62}, {39,63}, {39,65}, {39,66}, {39,67}, {39,68}, {39,69}, {39,70}, {39,71}, {39,74}, {39,75}, {39,79}, {39,80}, {39,81}, {39,82}, {39,83}, {39,84}, {39,85}, {39,86}, {39,87}, {39,88}, {39,89}, {39,90}, {39,92}, {39,93}, {39,94}, {39,95}, {39,96}, {39,97}, {39,98}, {39,99}, {39,100}, {39,101}, {39,102}, {39,103}, {39,104}, {39,105}, {39,109}, {39,110}, {39,111}, {39,112}, {39,113}, {39,114}, {39,115}, {39,117}, {39,118}, {39,119}, {39,120}, {39,121}, {39,122}, {39,123}, {39,124}, {39,126}, {39,127}, {39,128}, {39,129}, {39,130}, {39,131}, {39,132}, {39,133}, {39,134}, {39,135}, {39,137}, {39,138}, {39,139}, {39,143}, {39,144}, {40,-81}, {40,-80}, {40,-79}, {40,-67}, {40,-66}, {40,-65}, {40,-64}, {40,-63}, {40,-59}, {40,-58}, {40,-57}, {40,-52}, {40,-51}, {40,-50}, {40,-46}, {40,-45}, {40,-44}, {40,-43}, {40,-42}, {40,-7}, {40,-6}, {40,-3}, {40,-2}, {40,1}, {40,2}, {40,5}, {40,6}, {40,9}, {40,10}, {40,13}, {40,14}, {40,17}, {40,18}, {40,21}, {40,22}, {40,25}, {40,26}, {40,29}, {40,30}, {40,33}, {40,34}, {40,37}, {40,38}, {40,41}, {40,42}, {40,45}, {40,46}, {40,50}, {40,51}, {40,57}, {40,58}, {40,62}, {40,74}, {40,75}, {40,79}, {40,80}, {40,104}, {40,105}, {40,109}, {40,123}, {40,127}, {40,139}, {40,143}, {40,144}, {41,-80}, {41,-79}, {41,-67}, {41,-66}, {41,-65}, {41,-64}, {41,-63}, {41,-59}, {41,-58}, {41,-57}, {41,-52}, {41,-51}, {41,-50}, {41,-46}, {41,-45}, {41,-44}, {41,-43}, {41,-42}, {41,1}, {41,2}, {41,45}, {41,46}, {41,50}, {41,51}, {41,57}, {41,58}, {41,62}, {41,74}, {41,75}, {41,79}, {41,80}, {41,104}, {41,105}, {41,109}, {41,123}, {41,127}, {41,137}, {41,138}, {41,139}, {41,143}, {41,144}, {42,-80}, {42,-79}, {42,-66}, {42,-65}, {42,-64}, {42,-63}, {42,-59}, {42,-58}, {42,-57}, {42,-52}, {42,-51}, {42,-50}, {42,-46}, {42,-45}, {42,-44}, {42,-43}, {42,1}, {42,2}, {42,45}, {42,46}, {42,50}, {42,51}, {42,57}, {42,58}, {42,62}, {42,74}, {42,75}, {42,123}, {42,127}, {42,139}, {42,143}, {42,144}, {43,-80}, {43,-79}, {43,-66}, {43,-65}, {43,-64}, {43,-63}, {43,-46}, {43,-45}, {43,-44}, {43,-43}, {43,-7}, {43,-6}, {43,-3}, {43,-2}, {43,1}, {43,2}, {43,5}, {43,6}, {43,9}, {43,10}, {43,13}, {43,14}, {43,17}, {43,18}, {43,21}, {43,22}, {43,25}, {43,26}, {43,29}, {43,30}, {43,33}, {43,34}, {43,37}, {43,38}, {43,41}, {43,42}, {43,45}, {43,46}, {43,50}, {43,51}, {43,57}, {43,58}, {43,62}, {43,74}, {43,75}, {43,79}, {43,80}, {43,104}, {43,105}, {43,109}, {43,123}, {43,127}, {43,137}, {43,138}, {43,139}, {43,143}, {43,144}, {44,-80}, {44,-79}, {44,-78}, {44,-67}, {44,-66}, {44,-65}, {44,-64}, {44,-63}, {44,-46}, {44,-45}, {44,-44}, {44,-43}, {44,-42}, {44,-7}, {44,-6}, {44,-3}, {44,-2}, {44,1}, {44,2}, {44,5}, {44,6}, {44,9}, {44,10}, {44,13}, {44,14}, {44,17}, {44,18}, {44,21}, {44,22}, {44,25}, {44,26}, {44,29}, {44,30}, {44,33}, {44,34}, {44,37}, {44,38}, {44,41}, {44,42}, {44,45}, {44,46}, {44,50}, {44,51}, {44,57}, {44,58}, {44,74}, {44,75}, {44,79}, {44,80}, {44,104}, {44,105}, {44,109}, {44,123}, {44,127}, {44,139}, {44,143}, {44,144}, {45,-80}, {45,-79}, {45,-78}, {45,-66}, {45,-65}, {45,-64}, {45,-63}, {45,-46}, {45,-45}, {45,-44}, {45,-43}, {45,50}, {45,51}, {45,57}, {45,58}, {45,62}, {45,74}, {45,75}, {45,79}, {45,80}, {45,104}, {45,105}, {45,109}, {45,123}, {45,127}, {45,137}, {45,138}, {45,139}, {45,143}, {45,144}, {46,-79}, {46,-78}, {46,-66}, {46,-65}, {46,-64}, {46,-63}, {46,-46}, {46,-45}, {46,-44}, {46,-43}, {46,50}, {46,51}, {46,57}, {46,58}, {46,62}, {46,74}, {46,75}, {46,79}, {46,80}, {46,104}, {46,105}, {46,109}, {46,123}, {46,127}, {46,139}, {46,143}, {46,144}, {47,-79}, {47,-78}, {47,-67}, {47,-66}, {47,-65}, {47,-64}, {47,-63}, {47,-62}, {47,-61}, {47,-59}, {47,-58}, {47,-57}, {47,-56}, {47,-55}, {47,-54}, {47,-53}, {47,-52}, {47,-51}, {47,-50}, {47,-49}, {47,-48}, {47,-47}, {47,-46}, {47,-45}, {47,-44}, {47,-43}, {47,-42}, {47,-7}, {47,-6}, {47,-3}, {47,-2}, {47,1}, {47,2}, {47,5}, {47,6}, {47,9}, {47,10}, {47,13}, {47,14}, {47,17}, {47,18}, {47,21}, {47,22}, {47,25}, {47,26}, {47,29}, {47,30}, {47,33}, {47,34}, {47,37}, {47,38}, {47,41}, {47,42}, {47,45}, {47,46}, {47,50}, {47,51}, {47,57}, {47,58}, {47,62}, {47,74}, {47,75}, {47,79}, {47,80}, {47,104}, {47,105}, {47,109}, {47,123}, {47,127}, {47,137}, {47,138}, {47,139}, {47,143}, {47,144}, {48,-79}, {48,-78}, {48,-77}, {48,-66}, {48,-65}, {48,-64}, {48,-63}, {48,-62}, {48,-61}, {48,-59}, {48,-58}, {48,-57}, {48,-56}, {48,-55}, {48,-54}, {48,-53}, {48,-52}, {48,-51}, {48,-50}, {48,-49}, {48,-48}, {48,-47}, {48,-46}, {48,-45}, {48,-44}, {48,-43}, {48,-7}, {48,-6}, {48,-3}, {48,-2}, {48,1}, {48,2}, {48,5}, {48,6}, {48,9}, {48,10}, {48,13}, {48,14}, {48,17}, {48,18}, {48,21}, {48,22}, {48,25}, {48,26}, {48,29}, {48,30}, {48,33}, {48,34}, {48,37}, {48,38}, {48,41}, {48,42}, {48,45}, {48,46}, {48,50}, {48,51}, {48,57}, {48,58}, {48,59}, {48,60}, {48,61}, {48,62}, {48,74}, {48,75}, {48,79}, {48,80}, {48,104}, {48,105}, {48,109}, {48,123}, {48,127}, {48,139}, {48,143}, {48,144}, {49,-87}, {49,-86}, {49,-79}, {49,-78}, {49,-77}, {49,-66}, {49,-65}, {49,-64}, {49,-63}, {49,-62}, {49,-61}, {49,-59}, {49,-58}, {49,-57}, {49,-56}, {49,-55}, {49,-54}, {49,-53}, {49,-52}, {49,-51}, {49,-50}, {49,-49}, {49,-48}, {49,-47}, {49,-46}, {49,-45}, {49,-44}, {49,-43}, {49,1}, {49,2}, {49,45}, {49,46}, {49,50}, {49,51}, {49,57}, {49,58}, {49,62}, {49,74}, {49,75}, {49,76}, {49,77}, {49,78}, {49,79}, {49,80}, {49,104}, {49,105}, {49,109}, {49,123}, {49,127}, {49,137}, {49,138}, {49,139}, {49,143}, {49,144}, {50,-88}, {50,-87}, {50,-86}, {50,-85}, {50,-78}, {50,-77}, {50,-67}, {50,-66}, {50,-65}, {50,-64}, {50,-63}, {50,-46}, {50,-45}, {50,-44}, {50,-43}, {50,-42}, {50,1}, {50,2}, {50,45}, {50,46}, {50,50}, {50,51}, {50,57}, {50,58}, {50,62}, {50,74}, {50,75}, {50,79}, {50,80}, {50,104}, {50,105}, {50,109}, {50,123}, {50,127}, {50,139}, {50,143}, {50,144}, {51,-90}, {51,-89}, {51,-88}, {51,-87}, {51,-86}, {51,-85}, {51,-78}, {51,-77}, {51,-66}, {51,-65}, {51,-64}, {51,-63}, {51,-46}, {51,-45}, {51,-44}, {51,-43}, {51,-7}, {51,-6}, {51,-3}, {51,-2}, {51,1}, {51,2}, {51,5}, {51,6}, {51,9}, {51,10}, {51,13}, {51,14}, {51,17}, {51,18}, {51,21}, {51,22}, {51,25}, {51,26}, {51,29}, {51,30}, {51,33}, {51,34}, {51,37}, {51,38}, {51,41}, {51,42}, {51,45}, {51,46}, {51,50}, {51,51}, {51,57}, {51,58}, {51,62}, {51,74}, {51,75}, {51,79}, {51,80}, {51,104}, {51,105}, {51,109}, {51,110}, {51,112}, {51,113}, {51,114}, {51,115}, {51,116}, {51,117}, {51,118}, {51,119}, {51,120}, {51,121}, {51,122}, {51,123}, {51,124}, {51,126}, {51,127}, {51,128}, {51,129}, {51,130}, {51,131}, {51,132}, {51,133}, {51,134}, {51,135}, {51,136}, {51,137}, {51,138}, {51,139}, {51,140}, {51,141}, {51,142}, {51,143}, {51,144}, {52,-91}, {52,-90}, {52,-89}, {52,-88}, {52,-87}, {52,-86}, {52,-85}, {52,-84}, {52,-78}, {52,-77}, {52,-76}, {52,-66}, {52,-65}, {52,-64}, {52,-63}, {52,-62}, {52,-61}, {52,-60}, {52,-59}, {52,-58}, {52,-57}, {52,-56}, {52,-55}, {52,-54}, {52,-53}, {52,-52}, {52,-51}, {52,-50}, {52,-49}, {52,-48}, {52,-47}, {52,-46}, {52,-45}, {52,-44}, {52,-43}, {52,-7}, {52,-6}, {52,-3}, {52,-2}, {52,1}, {52,2}, {52,5}, {52,6}, {52,9}, {52,10}, {52,13}, {52,14}, {52,17}, {52,18}, {52,21}, {52,22}, {52,25}, {52,26}, {52,29}, {52,30}, {52,33}, {52,34}, {52,37}, {52,38}, {52,41}, {52,42}, {52,45}, {52,46}, {52,50}, {52,51}, {52,57}, {52,58}, {52,62}, {52,74}, {52,75}, {52,79}, {52,80}, {52,104}, {52,105}, {52,109}, {52,114}, {52,118}, {52,130}, {52,135}, {52,139}, {52,143}, {52,144}, {53,-101}, {53,-100}, {53,-99}, {53,-98}, {53,-97}, {53,-95}, {53,-94}, {53,-93}, {53,-92}, {53,-91}, {53,-90}, {53,-89}, {53,-88}, {53,-87}, {53,-86}, {53,-85}, {53,-84}, {53,-77}, {53,-76}, {53,-66}, {53,-65}, {53,-64}, {53,-63}, {53,-62}, {53,-61}, {53,-60}, {53,-59}, {53,-58}, {53,-57}, {53,-56}, {53,-55}, {53,-54}, {53,-53}, {53,-52}, {53,-51}, {53,-50}, {53,-49}, {53,-48}, {53,-47}, {53,-46}, {53,-45}, {53,-44}, {53,-43}, {53,1}, {53,2}, {53,45}, {53,46}, {53,50}, {53,51}, {53,57}, {53,58}, {53,62}, {53,74}, {53,75}, {53,79}, {53,80}, {53,104}, {53,105}, {53,114}, {53,130}, {53,143}, {53,144}, {54,-101}, {54,-100}, {54,-99}, {54,-98}, {54,-97}, {54,-95}, {54,-94}, {54,-93}, {54,-92}, {54,-91}, {54,-85}, {54,-84}, {54,-77}, {54,-76}, {54,-66}, {54,-65}, {54,-64}, {54,-63}, {54,-62}, {54,-61}, {54,-60}, {54,-59}, {54,-58}, {54,-57}, {54,-56}, {54,-55}, {54,-54}, {54,-53}, {54,-52}, {54,-51}, {54,-50}, {54,-49}, {54,-48}, {54,-47}, {54,-46}, {54,-45}, {54,-44}, {54,-43}, {54,1}, {54,2}, {54,45}, {54,46}, {54,50}, {54,51}, {54,57}, {54,58}, {54,74}, {54,75}, {54,79}, {54,80}, {54,104}, {54,105}, {54,109}, {54,114}, {54,118}, {54,130}, {54,135}, {54,139}, {54,143}, {54,144}, {55,-101}, {55,-100}, {55,-99}, {55,-98}, {55,-97}, {55,-95}, {55,-94}, {55,-93}, {55,-92}, {55,-85}, {55,-84}, {55,-83}, {55,-77}, {55,-76}, {55,-8}, {55,-7}, {55,-6}, {55,-5}, {55,-4}, {55,-3}, {55,-2}, {55,0}, {55,1}, {55,2}, {55,5}, {55,6}, {55,9}, {55,10}, {55,13}, {55,14}, {55,17}, {55,18}, {55,21}, {55,22}, {55,25}, {55,26}, {55,29}, {55,30}, {55,33}, {55,34}, {55,37}, {55,38}, {55,41}, {55,42}, {55,45}, {55,46}, {55,50}, {55,51}, {55,57}, {55,58}, {55,62}, {55,74}, {55,75}, {55,79}, {55,80}, {55,104}, {55,105}, {55,106}, {55,108}, {55,109}, {55,110}, {55,111}, {55,112}, {55,113}, {55,114}, {55,115}, {55,116}, {55,117}, {55,118}, {55,119}, {55,120}, {55,121}, {55,122}, {55,123}, {55,124}, {55,126}, {55,127}, {55,128}, {55,129}, {55,130}, {55,132}, {55,133}, {55,134}, {55,135}, {55,136}, {55,137}, {55,138}, {55,139}, {55,140}, {55,141}, {55,142}, {55,143}, {55,144}, {56,-100}, {56,-99}, {56,-98}, {56,-94}, {56,-85}, {56,-84}, {56,-83}, {56,-77}, {56,-76}, {56,-75}, {56,-8}, {56,-7}, {56,-6}, {56,-5}, {56,-4}, {56,-3}, {56,-2}, {56,0}, {56,1}, {56,2}, {56,5}, {56,6}, {56,9}, {56,10}, {56,13}, {56,14}, {56,17}, {56,18}, {56,21}, {56,22}, {56,25}, {56,26}, {56,29}, {56,30}, {56,33}, {56,34}, {56,37}, {56,38}, {56,41}, {56,42}, {56,45}, {56,46}, {56,50}, {56,51}, {56,57}, {56,58}, {56,62}, {56,74}, {56,75}, {56,79}, {56,80}, {56,104}, {56,105}, {56,109}, {56,135}, {56,139}, {56,143}, {56,144}, {57,-100}, {57,-99}, {57,-98}, {57,-88}, {57,-87}, {57,-86}, {57,-85}, {57,-84}, {57,-83}, {57,-77}, {57,-76}, {57,-75}, {57,-7}, {57,-6}, {57,1}, {57,2}, {57,45}, {57,46}, {57,50}, {57,51}, {57,57}, {57,58}, {57,62}, {57,74}, {57,75}, {57,79}, {57,80}, {57,104}, {57,105}, {57,109}, {57,143}, {57,144}, {58,-100}, {58,-99}, {58,-98}, {58,-94}, {58,-91}, {58,-90}, {58,-89}, {58,-88}, {58,-84}, {58,-83}, {58,-82}, {58,-76}, {58,-75}, {58,-7}, {58,-6}, {58,1}, {58,2}, {58,45}, {58,46}, {58,50}, {58,51}, {58,57}, {58,58}, {58,62}, {58,74}, {58,75}, {58,79}, {58,80}, {58,104}, {58,105}, {58,109}, {58,115}, {58,116}, {58,117}, {58,118}, {58,132}, {58,133}, {58,134}, {58,135}, {58,139}, {58,143}, {58,144}, {59,-100}, {59,-99}, {59,-98}, {59,-97}, {59,-96}, {59,-94}, {59,-93}, {59,-92}, {59,-91}, {59,-84}, {59,-83}, {59,-82}, {59,-76}, {59,-75}, {59,-66}, {59,-65}, {59,-64}, {59,-63}, {59,-62}, {59,-61}, {59,-59}, {59,-58}, {59,-57}, {59,-56}, {59,-55}, {59,-54}, {59,-53}, {59,-52}, {59,-51}, {59,-50}, {59,-49}, {59,-48}, {59,-47}, {59,-46}, {59,-45}, {59,-44}, {59,-43}, {59,-42}, {59,-41}, {59,-40}, {59,-39}, {59,-38}, {59,-37}, {59,-36}, {59,-35}, {59,-17}, {59,-16}, {59,-15}, {59,-14}, {59,-13}, {59,-12}, {59,-11}, {59,-8}, {59,-7}, {59,-6}, {59,-5}, {59,-4}, {59,-3}, {59,-2}, {59,0}, {59,1}, {59,2}, {59,3}, {59,4}, {59,5}, {59,6}, {59,7}, {59,8}, {59,9}, {59,10}, {59,11}, {59,12}, {59,13}, {59,14}, {59,17}, {59,18}, {59,19}, {59,20}, {59,21}, {59,22}, {59,23}, {59,24}, {59,25}, {59,26}, {59,27}, {59,28}, {59,29}, {59,30}, {59,33}, {59,34}, {59,35}, {59,36}, {59,37}, {59,38}, {59,39}, {59,40}, {59,41}, {59,42}, {59,43}, {59,44}, {59,45}, {59,46}, {59,50}, {59,51}, {59,57}, {59,58}, {59,59}, {59,60}, {59,61}, {59,62}, {59,74}, {59,75}, {59,79}, {59,80}, {59,81}, {59,82}, {59,83}, {59,84}, {59,85}, {59,86}, {59,87}, {59,88}, {59,89}, {59,90}, {59,92}, {59,93}, {59,94}, {59,95}, {59,96}, {59,97}, {59,98}, {59,99}, {59,100}, {59,101}, {59,102}, {59,103}, {59,104}, {59,105}, {59,115}, {59,118}, {59,132}, {59,135}, {59,139}, {59,143}, {59,144}, {60,-102}, {60,-101}, {60,-100}, {60,-99}, {60,-98}, {60,-97}, {60,-93}, {60,-84}, {60,-83}, {60,-82}, {60,-76}, {60,-75}, {60,-74}, {60,-66}, {60,-65}, {60,-64}, {60,-63}, {60,-62}, {60,-61}, {60,-59}, {60,-58}, {60,-57}, {60,-56}, {60,-55}, {60,-54}, {60,-53}, {60,-52}, {60,-51}, {60,-50}, {60,-49}, {60,-48}, {60,-47}, {60,-46}, {60,-45}, {60,-44}, {60,-43}, {60,-42}, {60,-41}, {60,-40}, {60,-39}, {60,-38}, {60,-37}, {60,-36}, {60,-35}, {60,-17}, {60,-16}, {60,-15}, {60,-14}, {60,-13}, {60,-12}, {60,-11}, {60,-8}, {60,-7}, {60,-6}, {60,-5}, {60,-4}, {60,-3}, {60,-2}, {60,0}, {60,1}, {60,2}, {60,3}, {60,4}, {60,5}, {60,6}, {60,7}, {60,8}, {60,9}, {60,10}, {60,11}, {60,12}, {60,13}, {60,14}, {60,17}, {60,18}, {60,19}, {60,20}, {60,21}, {60,22}, {60,23}, {60,24}, {60,25}, {60,26}, {60,27}, {60,28}, {60,29}, {60,30}, {60,33}, {60,34}, {60,35}, {60,36}, {60,37}, {60,38}, {60,39}, {60,40}, {60,41}, {60,42}, {60,43}, {60,44}, {60,45}, {60,46}, {60,50}, {60,51}, {60,57}, {60,58}, {60,62}, {60,74}, {60,75}, {60,79}, {60,80}, {60,104}, {60,105}, {60,109}, {60,115}, {60,132}, {60,135}, {60,139}, {60,143}, {60,144}, {61,-106}, {61,-105}, {61,-104}, {61,-103}, {61,-102}, {61,-101}, {61,-100}, {61,-99}, {61,-98}, {61,-97}, {61,-87}, {61,-86}, {61,-85}, {61,-84}, {61,-83}, {61,-82}, {61,-81}, {61,-76}, {61,-75}, {61,-74}, {61,-66}, {61,-65}, {61,-54}, {61,-36}, {61,-35}, {61,-17}, {61,-16}, {61,-7}, {61,-6}, {61,1}, {61,2}, {61,23}, {61,24}, {61,45}, {61,46}, {61,50}, {61,51}, {61,57}, {61,58}, {61,62}, {61,109}, {61,115}, {61,118}, {61,132}, {61,135}, {61,139}, {61,143}, {61,144}, {62,-109}, {62,-108}, {62,-107}, {62,-106}, {62,-105}, {62,-104}, {62,-103}, {62,-102}, {62,-101}, {62,-100}, {62,-99}, {62,-98}, {62,-97}, {62,-93}, {62,-90}, {62,-89}, {62,-88}, {62,-87}, {62,-83}, {62,-82}, {62,-81}, {62,-75}, {62,-74}, {62,-66}, {62,-65}, {62,-54}, {62,-36}, {62,-35}, {62,-17}, {62,-16}, {62,-7}, {62,-6}, {62,1}, {62,2}, {62,23}, {62,24}, {62,45}, {62,46}, {62,50}, {62,51}, {62,57}, {62,58}, {62,62}, {62,74}, {62,75}, {62,79}, {62,80}, {62,104}, {62,105}, {62,109}, {62,115}, {62,118}, {62,132}, {62,135}, {62,139}, {62,143}, {62,144}, {63,-109}, {63,-108}, {63,-107}, {63,-106}, {63,-105}, {63,-104}, {63,-103}, {63,-102}, {63,-101}, {63,-100}, {63,-99}, {63,-98}, {63,-97}, {63,-96}, {63,-95}, {63,-93}, {63,-92}, {63,-91}, {63,-90}, {63,-83}, {63,-82}, {63,-81}, {63,-75}, {63,-74}, {63,-73}, {63,-66}, {63,-65}, {63,-64}, {63,-62}, {63,-61}, {63,-60}, {63,-59}, {63,-58}, {63,-57}, {63,-56}, {63,-55}, {63,-54}, {63,-53}, {63,-52}, {63,-51}, {63,-49}, {63,-48}, {63,-47}, {63,-46}, {63,-45}, {63,-44}, {63,-43}, {63,-42}, {63,-41}, {63,-40}, {63,-39}, {63,-38}, {63,-36}, {63,-35}, {63,-17}, {63,-16}, {63,-8}, {63,-7}, {63,-6}, {63,-5}, {63,-4}, {63,-3}, {63,-2}, {63,0}, {63,1}, {63,2}, {63,3}, {63,4}, {63,5}, {63,6}, {63,7}, {63,8}, {63,9}, {63,10}, {63,11}, {63,12}, {63,13}, {63,14}, {63,15}, {63,16}, {63,17}, {63,18}, {63,19}, {63,20}, {63,21}, {63,22}, {63,23}, {63,24}, {63,25}, {63,26}, {63,27}, {63,28}, {63,29}, {63,30}, {63,31}, {63,32}, {63,33}, {63,34}, {63,35}, {63,36}, {63,37}, {63,38}, {63,39}, {63,40}, {63,41}, {63,42}, {63,43}, {63,44}, {63,45}, {63,46}, {63,47}, {63,48}, {63,49}, {63,50}, {63,51}, {63,57}, {63,58}, {63,62}, {63,74}, {63,75}, {63,76}, {63,77}, {63,78}, {63,79}, {63,80}, {63,81}, {63,82}, {63,83}, {63,84}, {63,85}, {63,86}, {63,87}, {63,88}, {63,89}, {63,90}, {63,91}, {63,92}, {63,93}, {63,94}, {63,95}, {63,98}, {63,99}, {63,100}, {63,101}, {63,102}, {63,103}, {63,104}, {63,105}, {63,109}, {63,115}, {63,118}, {63,132}, {63,135}, {63,139}, {63,143}, {63,144}, {64,-109}, {64,-108}, {64,-107}, {64,-106}, {64,-105}, {64,-104}, {64,-103}, {64,-102}, {64,-101}, {64,-100}, {64,-99}, {64,-98}, {64,-97}, {64,-96}, {64,-92}, {64,-83}, {64,-82}, {64,-81}, {64,-75}, {64,-74}, {64,-73}, {64,-66}, {64,-65}, {64,-62}, {64,-54}, {64,-51}, {64,-49}, {64,-40}, {64,-39}, {64,-36}, {64,-35}, {64,-34}, {64,-33}, {64,-32}, {64,-31}, {64,-29}, {64,-28}, {64,-27}, {64,-26}, {64,-25}, {64,-24}, {64,-23}, {64,-21}, {64,-20}, {64,-19}, {64,-18}, {64,-17}, {64,-16}, {64,-12}, {64,-11}, {64,-10}, {64,-8}, {64,-7}, {64,-6}, {64,-5}, {64,-4}, {64,-3}, {64,-2}, {64,0}, {64,1}, {64,2}, {64,3}, {64,4}, {64,5}, {64,6}, {64,7}, {64,8}, {64,9}, {64,10}, {64,11}, {64,12}, {64,13}, {64,14}, {64,15}, {64,16}, {64,17}, {64,18}, {64,19}, {64,20}, {64,21}, {64,22}, {64,23}, {64,24}, {64,25}, {64,26}, {64,27}, {64,28}, {64,29}, {64,30}, {64,31}, {64,32}, {64,33}, {64,34}, {64,35}, {64,36}, {64,37}, {64,38}, {64,39}, {64,40}, {64,41}, {64,42}, {64,43}, {64,44}, {64,45}, {64,46}, {64,50}, {64,51}, {64,57}, {64,58}, {64,74}, {64,75}, {64,79}, {64,80}, {64,86}, {64,90}, {64,100}, {64,104}, {64,105}, {64,109}, {64,115}, {64,118}, {64,132}, {64,135}, {64,139}, {64,143}, {64,144}, {65,-108}, {65,-107}, {65,-106}, {65,-105}, {65,-99}, {65,-98}, {65,-97}, {65,-96}, {65,-86}, {65,-85}, {65,-83}, {65,-82}, {65,-81}, {65,-80}, {65,-75}, {65,-74}, {65,-73}, {65,-66}, {65,-65}, {65,-62}, {65,-54}, {65,-51}, {65,-40}, {65,-39}, {65,-36}, {65,-35}, {65,-34}, {65,-33}, {65,-32}, {65,-31}, {65,-29}, {65,-28}, {65,-27}, {65,-26}, {65,-25}, {65,-24}, {65,-23}, {65,-21}, {65,-20}, {65,-19}, {65,-18}, {65,-17}, {65,-16}, {65,-12}, {65,-11}, {65,-7}, {65,-6}, {65,46}, {65,50}, {65,51}, {65,57}, {65,58}, {65,62}, {65,74}, {65,75}, {65,90}, {65,104}, {65,105}, {65,109}, {65,115}, {65,118}, {65,132}, {65,135}, {65,139}, {65,143}, {65,144}, {66,-108}, {66,-107}, {66,-106}, {66,-105}, {66,-99}, {66,-98}, {66,-97}, {66,-96}, {66,-92}, {66,-89}, {66,-88}, {66,-87}, {66,-86}, {66,-82}, {66,-81}, {66,-80}, {66,-74}, {66,-73}, {66,-66}, {66,-65}, {66,-62}, {66,-54}, {66,-51}, {66,-40}, {66,-39}, {66,-36}, {66,-35}, {66,-17}, {66,-16}, {66,-12}, {66,-11}, {66,-7}, {66,-6}, {66,50}, {66,51}, {66,57}, {66,58}, {66,62}, {66,74}, {66,75}, {66,79}, {66,80}, {66,86}, {66,90}, {66,100}, {66,104}, {66,105}, {66,109}, {66,115}, {66,118}, {66,132}, {66,135}, {66,139}, {66,143}, {66,144}, {67,-108}, {67,-107}, {67,-106}, {67,-105}, {67,-104}, {67,-99}, {67,-98}, {67,-97}, {67,-96}, {67,-95}, {67,-94}, {67,-92}, {67,-91}, {67,-90}, {67,-89}, {67,-74}, {67,-73}, {67,-66}, {67,-65}, {67,-62}, {67,-54}, {67,-51}, {67,-49}, {67,-40}, {67,-39}, {67,-36}, {67,-35}, {67,-17}, {67,-16}, {67,-12}, {67,-11}, {67,-7}, {67,-6}, {67,46}, {67,50}, {67,51}, {67,57}, {67,58}, {67,62}, {67,74}, {67,75}, {67,79}, {67,80}, {67,86}, {67,87}, {67,89}, {67,90}, {67,100}, {67,101}, {67,102}, {67,103}, {67,104}, {67,105}, {67,109}, {67,115}, {67,116}, {67,117}, {67,118}, {67,132}, {67,135}, {67,139}, {67,143}, {67,144}, {68,-108}, {68,-107}, {68,-106}, {68,-105}, {68,-104}, {68,-99}, {68,-98}, {68,-97}, {68,-96}, {68,-95}, {68,-91}, {68,-90}, {68,-81}, {68,-80}, {68,-79}, {68,-66}, {68,-65}, {68,-64}, {68,-62}, {68,-61}, {68,-60}, {68,-59}, {68,-57}, {68,-56}, {68,-55}, {68,-54}, {68,-53}, {68,-51}, {68,-50}, {68,-49}, {68,-48}, {68,-47}, {68,-46}, {68,-44}, {68,-43}, {68,-42}, {68,-41}, {68,-40}, {68,-39}, {68,-36}, {68,-35}, {68,-17}, {68,-16}, {68,-12}, {68,-11}, {68,-10}, {68,-8}, {68,-7}, {68,-6}, {68,-5}, {68,-4}, {68,-3}, {68,-2}, {68,0}, {68,1}, {68,2}, {68,3}, {68,4}, {68,5}, {68,6}, {68,7}, {68,8}, {68,9}, {68,10}, {68,11}, {68,12}, {68,13}, {68,14}, {68,15}, {68,16}, {68,17}, {68,18}, {68,19}, {68,21}, {68,22}, {68,23}, {68,24}, {68,25}, {68,26}, {68,27}, {68,28}, {68,29}, {68,30}, {68,31}, {68,32}, {68,33}, {68,34}, {68,35}, {68,36}, {68,38}, {68,39}, {68,40}, {68,41}, {68,42}, {68,43}, {68,44}, {68,45}, {68,46}, {68,50}, {68,51}, {68,57}, {68,58}, {68,62}, {68,74}, {68,75}, {68,79}, {68,80}, {68,86}, {68,104}, {68,105}, {68,109}, {68,115}, {68,118}, {68,132}, {68,135}, {68,139}, {68,143}, {68,144}, {69,-107}, {69,-106}, {69,-105}, {69,-104}, {69,-98}, {69,-97}, {69,-96}, {69,-95}, {69,-91}, {69,-90}, {69,-84}, {69,-83}, {69,-82}, {69,-81}, {69,-80}, {69,-79}, {69,-66}, {69,-65}, {69,-40}, {69,-39}, {69,-36}, {69,-35}, {69,-17}, {69,-16}, {69,-12}, {69,-11}, {69,-8}, {69,-7}, {69,-6}, {69,-5}, {69,-4}, {69,-3}, {69,-2}, {69,0}, {69,1}, {69,2}, {69,3}, {69,4}, {69,5}, {69,6}, {69,7}, {69,8}, {69,9}, {69,10}, {69,11}, {69,12}, {69,13}, {69,14}, {69,15}, {69,16}, {69,17}, {69,18}, {69,19}, {69,21}, {69,22}, {69,23}, {69,24}, {69,25}, {69,26}, {69,27}, {69,28}, {69,29}, {69,30}, {69,31}, {69,32}, {69,33}, {69,34}, {69,35}, {69,36}, {69,38}, {69,39}, {69,40}, {69,41}, {69,42}, {69,43}, {69,44}, {69,45}, {69,46}, {69,50}, {69,51}, {69,57}, {69,58}, {69,59}, {69,60}, {69,61}, {69,62}, {69,74}, {69,75}, {69,79}, {69,80}, {69,86}, {69,104}, {69,105}, {69,106}, {69,107}, {69,108}, {69,109}, {69,110}, {69,111}, {69,112}, {69,113}, {69,114}, {69,115}, {69,132}, {69,135}, {69,136}, {69,137}, {69,138}, {69,139}, {69,140}, {69,141}, {69,142}, {69,143}, {69,144}, {70,-107}, {70,-106}, {70,-105}, {70,-104}, {70,-98}, {70,-97}, {70,-96}, {70,-95}, {70,-91}, {70,-90}, {70,-87}, {70,-86}, {70,-85}, {70,-84}, {70,-83}, {70,-82}, {70,-81}, {70,-80}, {70,-79}, {70,-40}, {70,-39}, {70,-38}, {70,-36}, {70,-35}, {70,-17}, {70,-16}, {70,-12}, {70,-11}, {70,-7}, {70,-6}, {70,-2}, {70,11}, {70,15}, {70,19}, {70,30}, {70,46}, {70,47}, {70,48}, {70,49}, {70,50}, {70,51}, {70,57}, {70,58}, {70,62}, {70,74}, {70,75}, {70,79}, {70,80}, {70,86}, {70,109}, {70,118}, {70,132}, {70,143}, {70,144}, {71,-107}, {71,-106}, {71,-105}, {71,-104}, {71,-98}, {71,-97}, {71,-96}, {71,-95}, {71,-91}, {71,-90}, {71,-89}, {71,-88}, {71,-87}, {71,-86}, {71,-85}, {71,-84}, {71,-83}, {71,-82}, {71,-81}, {71,-80}, {71,-79}, {71,-78}, {71,-66}, {71,-65}, {71,-58}, {71,-57}, {71,-56}, {71,-55}, {71,-54}, {71,-51}, {71,-50}, {71,-49}, {71,-48}, {71,-36}, {71,-35}, {71,-17}, {71,-16}, {71,-12}, {71,-11}, {71,-2}, {71,-1}, {71,0}, {71,1}, {71,11}, {71,15}, {71,19}, {71,20}, {71,21}, {71,22}, {71,30}, {71,36}, {71,37}, {71,38}, {71,39}, {71,50}, {71,51}, {71,57}, {71,58}, {71,62}, {71,74}, {71,75}, {71,79}, {71,80}, {71,86}, {71,104}, {71,105}, {71,118}, {71,132}, {71,143}, {71,144}, {72,-107}, {72,-106}, {72,-105}, {72,-104}, {72,-97}, {72,-96}, {72,-95}, {72,-94}, {72,-93}, {72,-91}, {72,-90}, {72,-89}, {72,-88}, {72,-87}, {72,-86}, {72,-85}, {72,-84}, {72,-83}, {72,-80}, {72,-79}, {72,-78}, {72,-66}, {72,-65}, {72,-58}, {72,-51}, {72,-40}, {72,-39}, {72,-36}, {72,-35}, {72,-17}, {72,-16}, {72,-12}, {72,-11}, {72,-2}, {72,11}, {72,15}, {72,19}, {72,30}, {72,46}, {72,50}, {72,51}, {72,57}, {72,58}, {72,62}, {72,74}, {72,75}, {72,79}, {72,80}, {72,86}, {72,104}, {72,105}, {72,109}, {72,118}, {72,132}, {72,143}, {72,144}, {73,-106}, {73,-105}, {73,-104}, {73,-97}, {73,-96}, {73,-95}, {73,-94}, {73,-89}, {73,-88}, {73,-87}, {73,-80}, {73,-79}, {73,-78}, {73,-66}, {73,-65}, {73,-58}, {73,-51}, {73,-40}, {73,-39}, {73,-36}, {73,-35}, {73,-17}, {73,-16}, {73,-12}, {73,-11}, {73,-7}, {73,-6}, {73,-2}, {73,11}, {73,15}, {73,19}, {73,30}, {73,46}, {73,50}, {73,51}, {73,57}, {73,58}, {73,62}, {73,74}, {73,75}, {73,79}, {73,80}, {73,86}, {73,104}, {73,105}, {73,109}, {73,110}, {73,111}, {73,112}, {73,113}, {73,114}, {73,115}, {73,116}, {73,117}, {73,118}, {73,119}, {73,120}, {73,121}, {73,131}, {73,132}, {73,133}, {73,134}, {73,135}, {73,136}, {73,137}, {73,138}, {73,139}, {73,140}, {73,142}, {73,143}, {73,144}, {74,-106}, {74,-105}, {74,-104}, {74,-103}, {74,-102}, {74,-101}, {74,-99}, {74,-98}, {74,-97}, {74,-96}, {74,-95}, {74,-94}, {74,-89}, {74,-88}, {74,-87}, {74,-86}, {74,-79}, {74,-78}, {74,-77}, {74,-66}, {74,-65}, {74,-58}, {74,-51}, {74,-40}, {74,-39}, {74,-36}, {74,-35}, {74,-17}, {74,-16}, {74,-12}, {74,-11}, {74,-7}, {74,-6}, {74,-2}, {74,11}, {74,46}, {74,47}, {74,48}, {74,49}, {74,50}, {74,51}, {74,57}, {74,58}, {74,74}, {74,75}, {74,79}, {74,80}, {74,86}, {74,104}, {74,105}, {74,109}, {74,119}, {74,139}, {74,143}, {74,144}, {75,-106}, {75,-105}, {75,-104}, {75,-103}, {75,-102}, {75,-96}, {75,-95}, {75,-94}, {75,-89}, {75,-88}, {75,-87}, {75,-86}, {75,-78}, {75,-77}, {75,-66}, {75,-65}, {75,-60}, {75,-59}, {75,-58}, {75,-57}, {75,-56}, {75,-55}, {75,-53}, {75,-52}, {75,-51}, {75,-50}, {75,-49}, {75,-48}, {75,-47}, {75,-46}, {75,-45}, {75,-44}, {75,-43}, {75,-42}, {75,-41}, {75,-40}, {75,-39}, {75,-38}, {75,-37}, {75,-36}, {75,-35}, {75,-17}, {75,-16}, {75,-12}, {75,-11}, {75,-7}, {75,-6}, {75,-2}, {75,11}, {75,15}, {75,19}, {75,30}, {75,36}, {75,46}, {75,50}, {75,51}, {75,57}, {75,58}, {75,62}, {75,74}, {75,75}, {75,79}, {75,80}, {75,86}, {75,104}, {75,105}, {75,109}, {75,143}, {75,144}, {76,-105}, {76,-104}, {76,-103}, {76,-102}, {76,-96}, {76,-95}, {76,-94}, {76,-89}, {76,-88}, {76,-87}, {76,-86}, {76,-78}, {76,-77}, {76,-66}, {76,-65}, {76,-58}, {76,-53}, {76,-52}, {76,-51}, {76,-50}, {76,-49}, {76,-48}, {76,-47}, {76,-46}, {76,-45}, {76,-44}, {76,-43}, {76,-42}, {76,-41}, {76,-40}, {76,-39}, {76,-38}, {76,-37}, {76,-36}, {76,-35}, {76,-17}, {76,-16}, {76,-12}, {76,-11}, {76,-7}, {76,-6}, {76,-2}, {76,11}, {76,15}, {76,19}, {76,30}, {76,36}, {76,50}, {76,51}, {76,57}, {76,58}, {76,59}, {76,61}, {76,62}, {76,74}, {76,75}, {76,79}, {76,80}, {76,86}, {76,104}, {76,105}, {76,109}, {76,119}, {76,139}, {76,143}, {76,144}, {77,-105}, {77,-104}, {77,-103}, {77,-102}, {77,-96}, {77,-95}, {77,-94}, {77,-93}, {77,-92}, {77,-89}, {77,-88}, {77,-78}, {77,-77}, {77,-76}, {77,-58}, {77,-53}, {77,-52}, {77,-36}, {77,-35}, {77,-34}, {77,-33}, {77,-32}, {77,-31}, {77,-29}, {77,-28}, {77,-27}, {77,-26}, {77,-25}, {77,-24}, {77,-23}, {77,-21}, {77,-20}, {77,-19}, {77,-18}, {77,-17}, {77,-16}, {77,-12}, {77,-11}, {77,-7}, {77,-6}, {77,-2}, {77,11}, {77,15}, {77,19}, {77,30}, {77,36}, {77,46}, {77,50}, {77,51}, {77,57}, {77,58}, {77,62}, {77,74}, {77,75}, {77,79}, {77,80}, {77,81}, {77,82}, {77,83}, {77,84}, {77,85}, {77,86}, {77,87}, {77,88}, {77,89}, {77,90}, {77,100}, {77,101}, {77,102}, {77,103}, {77,104}, {77,105}, {77,109}, {77,119}, {77,121}, {77,122}, {77,123}, {77,124}, {77,125}, {77,126}, {77,127}, {77,128}, {77,129}, {77,130}, {77,131}, {77,139}, {77,143}, {77,144}, {78,-105}, {78,-104}, {78,-103}, {78,-102}, {78,-101}, {78,-89}, {78,-88}, {78,-78}, {78,-77}, {78,-76}, {78,-58}, {78,-53}, {78,-52}, {78,-36}, {78,-35}, {78,-34}, {78,-33}, {78,-32}, {78,-31}, {78,-29}, {78,-28}, {78,-27}, {78,-26}, {78,-25}, {78,-24}, {78,-23}, {78,-21}, {78,-20}, {78,-19}, {78,-18}, {78,-17}, {78,-16}, {78,-12}, {78,-11}, {78,-7}, {78,-6}, {78,-2}, {78,11}, {78,15}, {78,19}, {78,30}, {78,36}, {78,46}, {78,50}, {78,51}, {78,62}, {78,74}, {78,75}, {78,79}, {78,80}, {78,86}, {78,90}, {78,100}, {78,104}, {78,105}, {78,109}, {78,119}, {78,131}, {78,139}, {78,143}, {78,144}, {79,-105}, {79,-104}, {79,-103}, {79,-102}, {79,-101}, {79,-96}, {79,-95}, {79,-94}, {79,-93}, {79,-92}, {79,-91}, {79,-90}, {79,-89}, {79,-88}, {79,-77}, {79,-76}, {79,-58}, {79,-53}, {79,-52}, {79,-36}, {79,-35}, {79,-26}, {79,-17}, {79,-16}, {79,-15}, {79,-13}, {79,-12}, {79,-11}, {79,-10}, {79,-9}, {79,-8}, {79,-7}, {79,-6}, {79,-5}, {79,-3}, {79,-2}, {79,-1}, {79,0}, {79,1}, {79,2}, {79,3}, {79,4}, {79,6}, {79,7}, {79,8}, {79,9}, {79,10}, {79,11}, {79,12}, {79,13}, {79,15}, {79,17}, {79,18}, {79,19}, {79,20}, {79,21}, {79,22}, {79,23}, {79,24}, {79,25}, {79,27}, {79,28}, {79,29}, {79,30}, {79,31}, {79,33}, {79,34}, {79,35}, {79,36}, {79,37}, {79,38}, {79,39}, {79,46}, {79,50}, {79,51}, {79,57}, {79,58}, {79,62}, {79,74}, {79,75}, {79,104}, {79,105}, {79,109}, {79,119}, {79,131}, {79,139}, {79,143}, {79,144}, {80,-105}, {80,-104}, {80,-103}, {80,-102}, {80,-101}, {80,-100}, {80,-99}, {80,-98}, {80,-97}, {80,-96}, {80,-95}, {80,-94}, {80,-93}, {80,-92}, {80,-91}, {80,-90}, {80,-89}, {80,-88}, {80,-77}, {80,-76}, {80,-75}, {80,-58}, {80,-56}, {80,-55}, {80,-54}, {80,-53}, {80,-52}, {80,-36}, {80,-35}, {80,-26}, {80,-17}, {80,-16}, {80,-12}, {80,-11}, {80,1}, {80,9}, {80,15}, {80,22}, {80,30}, {80,39}, {80,46}, {80,50}, {80,51}, {80,57}, {80,58}, {80,62}, {80,74}, {80,75}, {80,79}, {80,80}, {80,86}, {80,90}, {80,100}, {80,104}, {80,105}, {80,109}, {80,119}, {80,131}, {80,139}, {80,143}, {80,144}, {81,-104}, {81,-103}, {81,-102}, {81,-101}, {81,-100}, {81,-99}, {81,-98}, {81,-97}, {81,-96}, {81,-95}, {81,-94}, {81,-93}, {81,-92}, {81,-77}, {81,-76}, {81,-75}, {81,-58}, {81,-55}, {81,-54}, {81,-53}, {81,-52}, {81,-36}, {81,-35}, {81,-26}, {81,-17}, {81,-16}, {81,-12}, {81,-11}, {81,1}, {81,9}, {81,15}, {81,22}, {81,30}, {81,39}, {81,46}, {81,50}, {81,51}, {81,57}, {81,58}, {81,59}, {81,61}, {81,62}, {81,63}, {81,64}, {81,65}, {81,66}, {81,67}, {81,68}, {81,69}, {81,70}, {81,71}, {81,72}, {81,73}, {81,74}, {81,75}, {81,76}, {81,77}, {81,78}, {81,79}, {81,80}, {81,81}, {81,82}, {81,83}, {81,84}, {81,85}, {81,86}, {81,88}, {81,89}, {81,90}, {81,91}, {81,92}, {81,93}, {81,94}, {81,95}, {81,96}, {81,97}, {81,99}, {81,100}, {81,101}, {81,102}, {81,103}, {81,104}, {81,105}, {81,109}, {81,110}, {81,112}, {81,113}, {81,114}, {81,115}, {81,116}, {81,117}, {81,118}, {81,119}, {81,120}, {81,122}, {81,123}, {81,124}, {81,125}, {81,126}, {81,127}, {81,128}, {81,129}, {81,131}, {81,132}, {81,133}, {81,134}, {81,135}, {81,136}, {81,138}, {81,139}, {81,140}, {81,142}, {81,143}, {81,144}, {82,-104}, {82,-103}, {82,-102}, {82,-101}, {82,-100}, {82,-99}, {82,-98}, {82,-97}, {82,-96}, {82,-76}, {82,-75}, {82,-58}, {82,-55}, {82,-54}, {82,-53}, {82,-36}, {82,-35}, {82,-34}, {82,-33}, {82,-32}, {82,-31}, {82,-29}, {82,-28}, {82,-27}, {82,-26}, {82,-25}, {82,-24}, {82,-23}, {82,-22}, {82,-21}, {82,-20}, {82,-19}, {82,-18}, {82,-17}, {82,-16}, {82,-15}, {82,-13}, {82,-12}, {82,-11}, {82,-10}, {82,-9}, {82,-8}, {82,-7}, {82,-6}, {82,-5}, {82,-4}, {82,-3}, {82,-2}, {82,-1}, {82,0}, {82,1}, {82,2}, {82,3}, {82,4}, {82,5}, {82,6}, {82,7}, {82,8}, {82,9}, {82,10}, {82,11}, {82,12}, {82,13}, {82,14}, {82,15}, {82,16}, {82,17}, {82,18}, {82,19}, {82,20}, {82,21}, {82,22}, {82,23}, {82,24}, {82,25}, {82,26}, {82,27}, {82,28}, {82,29}, {82,30}, {82,31}, {82,32}, {82,33}, {82,34}, {82,35}, {82,36}, {82,37}, {82,38}, {82,39}, {82,40}, {82,41}, {82,42}, {82,43}, {82,44}, {82,45}, {82,46}, {82,47}, {82,48}, {82,49}, {82,50}, {82,51}, {82,57}, {82,58}, {82,62}, {82,74}, {82,88}, {82,96}, {82,104}, {82,105}, {82,109}, {82,115}, {82,119}, {82,126}, {82,131}, {82,135}, {82,139}, {82,143}, {82,144}, {83,-104}, {83,-103}, {83,-102}, {83,-101}, {83,-100}, {83,-76}, {83,-75}, {83,-74}, {83,-58}, {83,-57}, {83,-56}, {83,-55}, {83,-54}, {83,-53}, {83,-36}, {83,-35}, {83,-34}, {83,-33}, {83,-32}, {83,-31}, {83,-29}, {83,-28}, {83,-27}, {83,-26}, {83,-25}, {83,-24}, {83,-23}, {83,-22}, {83,-21}, {83,-20}, {83,-19}, {83,-18}, {83,-17}, {83,-16}, {83,-15}, {83,-13}, {83,-12}, {83,-11}, {83,-10}, {83,-9}, {83,-8}, {83,-7}, {83,-6}, {83,-5}, {83,-4}, {83,-3}, {83,-2}, {83,-1}, {83,0}, {83,1}, {83,2}, {83,3}, {83,4}, {83,5}, {83,6}, {83,7}, {83,8}, {83,9}, {83,10}, {83,11}, {83,12}, {83,13}, {83,14}, {83,15}, {83,16}, {83,17}, {83,18}, {83,19}, {83,20}, {83,21}, {83,22}, {83,23}, {83,24}, {83,25}, {83,26}, {83,27}, {83,28}, {83,29}, {83,30}, {83,31}, {83,32}, {83,33}, {83,34}, {83,35}, {83,36}, {83,37}, {83,38}, {83,39}, {83,40}, {83,41}, {83,42}, {83,43}, {83,44}, {83,45}, {83,46}, {83,47}, {83,48}, {83,49}, {83,50}, {83,51}, {83,57}, {83,58}, {83,88}, {83,109}, {83,119}, {83,126}, {83,135}, {83,139}, {83,143}, {83,144}, {84,-76}, {84,-75}, {84,-74}, {84,-58}, {84,-57}, {84,-56}, {84,-55}, {84,-54}, {84,-36}, {84,-35}, {84,57}, {84,58}, {84,62}, {84,74}, {84,88}, {84,96}, {84,104}, {84,105}, {84,109}, {84,115}, {84,119}, {84,126}, {84,131}, {84,135}, {84,139}, {84,143}, {84,144}, {85,-75}, {85,-74}, {85,-73}, {85,-72}, {85,-71}, {85,-70}, {85,-69}, {85,-68}, {85,-67}, {85,-66}, {85,-65}, {85,-64}, {85,-63}, {85,-62}, {85,-61}, {85,-60}, {85,-59}, {85,-58}, {85,-57}, {85,-56}, {85,-55}, {85,57}, {85,58}, {85,59}, {85,60}, {85,61}, {85,62}, {85,63}, {85,64}, {85,65}, {85,66}, {85,67}, {85,68}, {85,69}, {85,70}, {85,71}, {85,72}, {85,73}, {85,74}, {85,75}, {85,76}, {85,77}, {85,78}, {85,79}, {85,80}, {85,81}, {85,82}, {85,83}, {85,84}, {85,85}, {85,86}, {85,87}, {85,88}, {85,89}, {85,90}, {85,91}, {85,92}, {85,95}, {85,96}, {85,97}, {85,98}, {85,99}, {85,100}, {85,101}, {85,102}, {85,103}, {85,104}, {85,105}, {85,106}, {85,107}, {85,108}, {85,109}, {85,110}, {85,111}, {85,112}, {85,113}, {85,114}, {85,115}, {85,116}, {85,117}, {85,118}, {85,119}, {85,120}, {85,121}, {85,122}, {85,123}, {85,124}, {85,125}, {85,126}, {85,127}, {85,128}, {85,129}, {85,130}, {85,131}, {85,132}, {85,133}, {85,134}, {85,135}, {85,136}, {85,137}, {85,138}, {85,139}, {85,140}, {85,141}, {85,142}, {85,143}, {85,144}, {86,-75}, {86,-74}, {86,-73}, {86,-72}, {86,-71}, {86,-70}, {86,-69}, {86,-68}, {86,-67}, {86,-66}, {86,-65}, {86,-64}, {86,-63}, {86,-62}, {86,-61}, {86,-60}, {86,-59}, {86,-58}, {86,-57}, {86,57}, {86,58}, {86,59}, {86,60}, {86,61}, {86,62}, {86,63}, {86,64}, {86,65}, {86,66}, {86,67}, {86,68}, {86,69}, {86,70}, {86,71}, {86,72}, {86,73}, {86,74}, {86,75}, {86,76}, {86,77}, {86,78}, {86,79}, {86,80}, {86,81}, {86,82}, {86,83}, {86,84}, {86,85}, {86,86}, {86,87}, {86,88}, {86,89}, {86,90}, {86,91}, {86,92}, {86,95}, {86,96}, {86,97}, {86,98}, {86,99}, {86,100}, {86,101}, {86,102}, {86,103}, {86,104}, {86,105}, {86,106}, {86,107}, {86,108}, {86,109}, {86,110}, {86,111}, {86,112}, {86,113}, {86,114}, {86,115}, {86,116}, {86,117}, {86,118}, {86,119}, {86,120}, {86,121}, {86,122}, {86,123}, {86,124}, {86,125}, {86,126}, {86,127}, {86,128}, {86,129}, {86,130}, {86,131}, {86,132}, {86,133}, {86,134}, {86,135}, {86,136}, {86,137}, {86,138}, {86,139}, {86,140}, {86,141}, {86,142}, {86,143}, {86,144}, },
    ["stone-path"] = {{-88,-10}, {-88,-9}, {-88,-8}, {-88,-7}, {-88,-6}, {-88,-5}, {-88,-4}, {-88,-3}, {-88,-2}, {-88,-1}, {-88,0}, {-88,1}, {-88,2}, {-88,3}, {-88,4}, {-88,5}, {-88,6}, {-88,7}, {-88,8}, {-88,9}, {-88,10}, {-88,11}, {-88,12}, {-88,13}, {-88,14}, {-88,15}, {-88,16}, {-88,17}, {-88,18}, {-88,19}, {-88,20}, {-88,21}, {-88,22}, {-87,-11}, {-87,23}, {-85,51}, {-85,59}, {-84,51}, {-82,96}, {-81,67}, {-81,68}, {-81,72}, {-81,91}, {-81,96}, {-81,115}, {-81,116}, {-81,117}, {-80,72}, {-80,91}, {-80,96}, {-79,71}, {-79,92}, {-79,96}, {-78,71}, {-78,92}, {-78,96}, {-77,71}, {-77,92}, {-77,96}, {-77,118}, {-76,71}, {-76,92}, {-76,96}, {-75,71}, {-75,92}, {-75,96}, {-74,5}, {-74,6}, {-74,7}, {-74,71}, {-74,92}, {-74,96}, {-73,71}, {-73,92}, {-73,96}, {-72,-27}, {-72,71}, {-72,92}, {-72,96}, {-71,-27}, {-71,71}, {-71,92}, {-71,96}, {-70,-27}, {-70,71}, {-70,92}, {-70,96}, {-69,-27}, {-69,71}, {-69,92}, {-68,-27}, {-68,71}, {-68,92}, {-67,-27}, {-67,71}, {-67,92}, {-66,-27}, {-66,71}, {-66,92}, {-65,-27}, {-65,71}, {-65,92}, {-65,135}, {-65,136}, {-64,-27}, {-64,72}, {-64,91}, {-63,-27}, {-63,72}, {-63,91}, {-62,-27}, {-62,69}, {-61,-27}, {-61,-13}, {-61,56}, {-61,64}, {-60,-27}, {-60,-13}, {-60,56}, {-60,64}, {-59,-27}, {-59,-13}, {-59,56}, {-59,64}, {-58,-27}, {-57,-27}, {-57,46}, {-56,-27}, {-56,46}, {-55,-27}, {-55,46}, {-54,-27}, {-54,46}, {-53,-27}, {-53,46}, {-53,76}, {-53,77}, {-53,78}, {-53,79}, {-53,80}, {-53,83}, {-53,84}, {-53,85}, {-53,86}, {-53,87}, {-53,88}, {-53,89}, {-53,90}, {-53,91}, {-53,97}, {-53,106}, {-52,-27}, {-52,46}, {-52,97}, {-52,106}, {-51,-27}, {-51,-13}, {-51,46}, {-51,47}, {-51,48}, {-51,93}, {-50,-27}, {-50,-13}, {-50,46}, {-50,74}, {-50,93}, {-49,-27}, {-49,-13}, {-49,46}, {-49,73}, {-49,74}, {-49,81}, {-49,82}, {-49,93}, {-48,-27}, {-48,46}, {-48,72}, {-48,73}, {-48,93}, {-47,-27}, {-47,46}, {-47,68}, {-47,73}, {-47,74}, {-47,93}, {-46,-27}, {-46,46}, {-46,67}, {-46,74}, {-46,78}, {-46,85}, {-46,90}, {-46,93}, {-45,-27}, {-45,46}, {-45,67}, {-45,74}, {-45,78}, {-45,85}, {-45,90}, {-45,93}, {-45,114}, {-44,-27}, {-44,46}, {-44,67}, {-44,74}, {-44,78}, {-44,85}, {-44,90}, {-44,93}, {-43,-27}, {-43,46}, {-43,68}, {-43,73}, {-43,74}, {-43,93}, {-42,-27}, {-42,46}, {-42,72}, {-42,73}, {-42,93}, {-41,-27}, {-41,46}, {-41,73}, {-41,74}, {-41,81}, {-41,82}, {-41,93}, {-40,-27}, {-40,46}, {-40,74}, {-40,93}, {-39,-27}, {-39,41}, {-39,42}, {-39,43}, {-39,44}, {-39,45}, {-39,46}, {-39,47}, {-39,48}, {-39,93}, {-38,-27}, {-38,97}, {-38,106}, {-37,76}, {-37,77}, {-37,78}, {-37,79}, {-37,80}, {-37,83}, {-37,84}, {-37,85}, {-37,86}, {-37,87}, {-37,88}, {-37,89}, {-37,90}, {-37,91}, {-37,97}, {-37,106}, {-36,5}, {-36,6}, {-36,7}, {-36,8}, {-36,9}, {-31,56}, {-31,64}, {-28,115}, {-27,115}, {-27,140}, {-27,141}, {-27,142}, {-27,143}, {-27,144}, {-26,115}, {-25,115}, {-24,115}, {-23,-11}, {-23,80}, {-23,81}, {-23,82}, {-23,83}, {-23,115}, {-22,-10}, {-22,-9}, {-22,-8}, {-22,-7}, {-22,-6}, {-22,-5}, {-22,-4}, {-22,-3}, {-22,-2}, {-22,-1}, {-22,0}, {-22,1}, {-22,2}, {-22,3}, {-22,4}, {-22,5}, {-22,6}, {-22,7}, {-22,8}, {-22,9}, {-22,10}, {-22,11}, {-22,12}, {-22,13}, {-22,14}, {-22,15}, {-22,16}, {-22,17}, {-22,18}, {-22,19}, {-22,20}, {-22,21}, {-22,22}, {-22,23}, {-10,31}, {-9,31}, {-9,71}, {-8,31}, {-8,71}, {-7,31}, {-3,77}, {-2,77}, {9,76}, {9,84}, {10,76}, {10,84}, {11,76}, {11,84}, {12,76}, {12,84}, {13,76}, {13,84}, {19,76}, {19,84}, {20,76}, {20,84}, {21,76}, {21,84}, {22,76}, {22,84}, {23,76}, {23,84}, {54,-96}, {58,-34}, {58,-33}, {58,-32}, {58,-31}, {58,-30}, {58,-29}, {58,-28}, {58,-27}, {58,-26}, {58,-25}, {58,-24}, {58,-23}, {58,-22}, {58,-21}, {58,-20}, {58,-19}, {58,-18}, {67,-80}, {68,93}, {68,97}, {69,92}, {69,98}, {70,91}, {70,99}, {74,91}, {74,99}, {75,92}, {75,98}, {76,93}, {76,97}, {77,-65}, {78,-65}, {79,-65}, {80,-65}, {81,-65}, {82,-65}, {83,-65}, {84,-65}, },
    ["black-refined-concrete"] = {{-86,98}, {-86,99}, {-86,100}, {-86,101}, {-85,-24}, {-85,-23}, {-85,-22}, {-85,-21}, {-85,-20}, {-85,-19}, {-85,-18}, {-85,-17}, {-85,-16}, {-85,-15}, {-85,-14}, {-85,26}, {-85,27}, {-85,29}, {-85,31}, {-85,33}, {-85,35}, {-85,36}, {-85,98}, {-85,99}, {-85,100}, {-85,101}, {-84,-24}, {-84,-23}, {-84,-22}, {-84,-21}, {-84,-20}, {-84,-19}, {-84,-18}, {-84,-17}, {-84,-16}, {-84,-15}, {-84,-14}, {-84,26}, {-84,27}, {-84,29}, {-84,31}, {-84,33}, {-84,35}, {-84,36}, {-84,100}, {-83,-23}, {-83,-15}, {-83,-14}, {-83,26}, {-83,27}, {-83,29}, {-83,31}, {-83,33}, {-83,35}, {-83,36}, {-82,-24}, {-82,-23}, {-82,-22}, {-82,-21}, {-82,-20}, {-82,-19}, {-82,-18}, {-82,-17}, {-82,-15}, {-82,-14}, {-82,26}, {-82,27}, {-82,29}, {-82,31}, {-82,33}, {-82,35}, {-82,36}, {-81,-24}, {-81,-23}, {-81,-22}, {-81,-21}, {-81,-20}, {-81,-19}, {-81,-18}, {-81,-17}, {-81,-15}, {-81,-14}, {-81,26}, {-81,27}, {-81,28}, {-81,29}, {-81,31}, {-81,33}, {-81,35}, {-81,36}, {-80,-23}, {-80,-15}, {-80,-14}, {-80,29}, {-80,31}, {-80,33}, {-80,35}, {-80,36}, {-80,43}, {-80,44}, {-80,45}, {-80,46}, {-80,47}, {-80,48}, {-79,-24}, {-79,-23}, {-79,-22}, {-79,-21}, {-79,-20}, {-79,-19}, {-79,-18}, {-79,-17}, {-79,-15}, {-79,-14}, {-79,26}, {-79,27}, {-79,29}, {-79,30}, {-79,31}, {-79,32}, {-79,33}, {-79,35}, {-79,36}, {-79,47}, {-79,48}, {-79,52}, {-78,-24}, {-78,-23}, {-78,-22}, {-78,-21}, {-78,-20}, {-78,-19}, {-78,-18}, {-78,-17}, {-78,-15}, {-78,-14}, {-78,26}, {-78,27}, {-78,35}, {-78,36}, {-78,43}, {-78,44}, {-78,45}, {-78,47}, {-78,48}, {-78,51}, {-78,52}, {-78,54}, {-78,55}, {-78,56}, {-78,57}, {-78,58}, {-78,59}, {-78,62}, {-78,63}, {-78,64}, {-78,65}, {-78,66}, {-77,-15}, {-77,-14}, {-77,26}, {-77,27}, {-77,28}, {-77,29}, {-77,30}, {-77,31}, {-77,32}, {-77,33}, {-77,34}, {-77,35}, {-77,36}, {-77,43}, {-77,44}, {-77,45}, {-77,47}, {-77,48}, {-77,51}, {-77,52}, {-77,54}, {-77,55}, {-77,56}, {-77,57}, {-77,58}, {-77,59}, {-77,62}, {-77,63}, {-77,64}, {-77,65}, {-77,66}, {-76,-24}, {-76,-23}, {-76,-22}, {-76,-21}, {-76,-20}, {-76,-19}, {-76,-17}, {-76,-16}, {-76,-15}, {-76,-14}, {-76,26}, {-76,27}, {-76,28}, {-76,29}, {-76,30}, {-76,31}, {-76,32}, {-76,33}, {-76,34}, {-76,35}, {-76,36}, {-76,43}, {-76,44}, {-76,45}, {-76,46}, {-76,47}, {-76,48}, {-75,-24}, {-75,-23}, {-75,-22}, {-75,-21}, {-75,-20}, {-75,-19}, {-75,-17}, {-75,-16}, {-75,-15}, {-75,-14}, {-75,43}, {-75,44}, {-75,45}, {-75,47}, {-75,48}, {-74,43}, {-74,44}, {-74,45}, {-74,47}, {-74,48}, {-73,26}, {-73,27}, {-73,28}, {-73,31}, {-73,32}, {-73,33}, {-73,34}, {-73,35}, {-72,27}, {-72,28}, {-72,31}, {-72,32}, {-72,33}, {-72,34}, {-72,35}, {-72,43}, {-72,44}, {-72,45}, {-72,46}, {-72,47}, {-72,48}, {-71,27}, {-71,28}, {-71,31}, {-71,48}, {-71,104}, {-71,105}, {-70,-70}, {-70,-69}, {-70,27}, {-70,28}, {-70,31}, {-70,32}, {-70,33}, {-70,34}, {-70,35}, {-70,42}, {-70,43}, {-70,44}, {-70,45}, {-70,46}, {-70,47}, {-70,48}, {-70,104}, {-70,105}, {-69,-77}, {-69,-76}, {-69,-75}, {-69,-74}, {-69,-73}, {-69,-72}, {-69,-70}, {-69,-69}, {-69,-67}, {-69,-66}, {-69,-65}, {-69,-64}, {-69,-63}, {-69,-62}, {-69,27}, {-69,28}, {-69,31}, {-69,32}, {-69,33}, {-69,34}, {-69,35}, {-69,42}, {-69,43}, {-69,44}, {-69,45}, {-69,46}, {-69,47}, {-69,48}, {-69,104}, {-69,105}, {-68,-77}, {-68,-76}, {-68,-75}, {-68,-74}, {-68,-73}, {-68,-72}, {-68,-71}, {-68,-70}, {-68,-69}, {-68,-68}, {-68,-67}, {-68,-66}, {-68,-65}, {-68,-64}, {-68,-63}, {-68,-62}, {-68,27}, {-68,28}, {-68,31}, {-68,42}, {-68,43}, {-68,44}, {-68,45}, {-68,46}, {-68,47}, {-68,48}, {-68,100}, {-68,104}, {-68,105}, {-67,-77}, {-67,-76}, {-67,-74}, {-67,-73}, {-67,-71}, {-67,-70}, {-67,-69}, {-67,-68}, {-67,-66}, {-67,-65}, {-67,-63}, {-67,-62}, {-67,27}, {-67,28}, {-67,31}, {-67,32}, {-67,33}, {-67,34}, {-67,35}, {-67,42}, {-67,43}, {-67,44}, {-67,45}, {-67,46}, {-67,47}, {-67,48}, {-67,98}, {-67,99}, {-67,100}, {-67,101}, {-67,104}, {-67,105}, {-66,-77}, {-66,-76}, {-66,-75}, {-66,-74}, {-66,-73}, {-66,-72}, {-66,-71}, {-66,-70}, {-66,-69}, {-66,-68}, {-66,-67}, {-66,-66}, {-66,-65}, {-66,-64}, {-66,-63}, {-66,-62}, {-66,27}, {-66,28}, {-66,31}, {-66,32}, {-66,33}, {-66,34}, {-66,35}, {-66,42}, {-66,43}, {-66,44}, {-66,45}, {-66,46}, {-66,47}, {-66,48}, {-66,98}, {-66,99}, {-66,100}, {-66,101}, {-66,104}, {-66,105}, {-65,-77}, {-65,-76}, {-65,-75}, {-65,-74}, {-65,-71}, {-65,-70}, {-65,-69}, {-65,-68}, {-65,-65}, {-65,-64}, {-65,-63}, {-65,-62}, {-65,27}, {-65,28}, {-65,31}, {-65,48}, {-65,51}, {-65,52}, {-65,54}, {-65,55}, {-65,56}, {-65,58}, {-65,59}, {-65,62}, {-65,63}, {-65,64}, {-65,65}, {-65,66}, {-65,100}, {-64,-77}, {-64,-76}, {-64,-74}, {-64,-71}, {-64,-70}, {-64,-69}, {-64,-68}, {-64,-65}, {-64,-63}, {-64,-62}, {-64,27}, {-64,28}, {-64,29}, {-64,30}, {-64,31}, {-64,32}, {-64,33}, {-64,34}, {-64,35}, {-64,43}, {-64,44}, {-64,45}, {-64,46}, {-64,47}, {-64,48}, {-64,51}, {-64,52}, {-64,53}, {-64,54}, {-64,55}, {-64,56}, {-64,57}, {-64,58}, {-64,59}, {-64,62}, {-64,63}, {-64,64}, {-64,65}, {-64,66}, {-64,100}, {-63,-77}, {-63,-76}, {-63,-75}, {-63,-74}, {-63,-73}, {-63,-72}, {-63,-71}, {-63,-70}, {-63,-69}, {-63,-68}, {-63,-67}, {-63,-66}, {-63,-65}, {-63,-64}, {-63,-63}, {-63,27}, {-63,28}, {-63,31}, {-63,32}, {-63,33}, {-63,34}, {-63,35}, {-63,98}, {-63,99}, {-63,100}, {-63,101}, {-63,102}, {-63,103}, {-63,104}, {-63,105}, {-63,106}, {-63,107}, {-63,108}, {-63,109}, {-63,110}, {-63,111}, {-63,112}, {-63,113}, {-63,114}, {-63,115}, {-63,116}, {-63,117}, {-63,118}, {-63,119}, {-63,120}, {-63,121}, {-63,122}, {-63,123}, {-63,124}, {-63,125}, {-63,126}, {-63,127}, {-63,128}, {-63,129}, {-63,130}, {-63,131}, {-63,132}, {-63,133}, {-63,134}, {-63,135}, {-63,136}, {-63,137}, {-62,-77}, {-62,-76}, {-62,-75}, {-62,-74}, {-62,-73}, {-62,-72}, {-62,-71}, {-62,-70}, {-62,-69}, {-62,-68}, {-62,-67}, {-62,-66}, {-62,-65}, {-62,-64}, {-62,-63}, {-62,-62}, {-62,-61}, {-62,27}, {-62,98}, {-62,99}, {-62,100}, {-62,101}, {-62,102}, {-62,103}, {-62,104}, {-62,105}, {-62,106}, {-62,107}, {-62,108}, {-62,109}, {-62,110}, {-62,111}, {-62,112}, {-62,113}, {-62,114}, {-62,115}, {-62,116}, {-62,117}, {-62,118}, {-62,119}, {-62,120}, {-62,121}, {-62,122}, {-62,123}, {-62,124}, {-62,125}, {-62,126}, {-62,127}, {-62,128}, {-62,129}, {-62,130}, {-62,131}, {-62,132}, {-62,133}, {-62,134}, {-62,135}, {-62,136}, {-62,137}, {-61,-77}, {-61,-76}, {-61,-75}, {-61,-74}, {-61,-73}, {-61,-72}, {-61,-71}, {-61,-70}, {-61,-69}, {-61,-68}, {-61,-67}, {-61,-66}, {-61,-65}, {-61,-64}, {-61,-63}, {-61,-62}, {-61,-61}, {-61,26}, {-61,27}, {-61,28}, {-61,29}, {-61,30}, {-61,31}, {-61,32}, {-61,33}, {-61,34}, {-61,35}, {-61,36}, {-61,115}, {-61,116}, {-61,117}, {-61,126}, {-61,127}, {-61,135}, {-61,136}, {-61,137}, {-60,-77}, {-60,-76}, {-60,-75}, {-60,-74}, {-60,-73}, {-60,-72}, {-60,-71}, {-60,-70}, {-60,-69}, {-60,-68}, {-60,-67}, {-60,-66}, {-60,-65}, {-60,-64}, {-60,-63}, {-60,26}, {-60,27}, {-60,28}, {-60,29}, {-60,31}, {-60,34}, {-60,115}, {-60,116}, {-60,117}, {-60,126}, {-60,127}, {-60,135}, {-60,136}, {-60,137}, {-59,-77}, {-59,-76}, {-59,-74}, {-59,-71}, {-59,-70}, {-59,-69}, {-59,-68}, {-59,-65}, {-59,-63}, {-59,-62}, {-59,26}, {-59,27}, {-59,28}, {-59,29}, {-59,31}, {-59,32}, {-59,34}, {-59,35}, {-59,85}, {-59,86}, {-59,87}, {-59,88}, {-59,89}, {-59,90}, {-59,91}, {-59,94}, {-59,95}, {-59,96}, {-59,97}, {-59,98}, {-59,99}, {-59,100}, {-59,101}, {-59,102}, {-59,103}, {-59,104}, {-59,105}, {-59,106}, {-59,107}, {-59,108}, {-59,109}, {-59,110}, {-59,111}, {-59,112}, {-59,115}, {-59,116}, {-59,117}, {-59,126}, {-59,127}, {-59,135}, {-59,136}, {-59,137}, {-58,-77}, {-58,-76}, {-58,-75}, {-58,-74}, {-58,-71}, {-58,-70}, {-58,-69}, {-58,-68}, {-58,-65}, {-58,-64}, {-58,-63}, {-58,-62}, {-58,27}, {-58,28}, {-58,29}, {-58,31}, {-58,32}, {-58,34}, {-58,35}, {-58,85}, {-58,86}, {-58,87}, {-58,88}, {-58,89}, {-58,90}, {-58,91}, {-58,94}, {-58,100}, {-58,103}, {-58,104}, {-58,105}, {-58,106}, {-58,107}, {-58,108}, {-58,112}, {-58,115}, {-58,116}, {-58,117}, {-58,126}, {-58,127}, {-58,135}, {-58,136}, {-58,137}, {-57,-77}, {-57,-76}, {-57,-75}, {-57,-74}, {-57,-73}, {-57,-72}, {-57,-71}, {-57,-70}, {-57,-69}, {-57,-68}, {-57,-67}, {-57,-66}, {-57,-65}, {-57,-64}, {-57,-63}, {-57,-62}, {-57,27}, {-57,28}, {-57,29}, {-57,31}, {-57,32}, {-57,34}, {-57,35}, {-57,84}, {-57,85}, {-57,86}, {-57,87}, {-57,88}, {-57,89}, {-57,90}, {-57,91}, {-57,94}, {-57,95}, {-57,96}, {-57,97}, {-57,100}, {-57,101}, {-57,103}, {-57,104}, {-57,105}, {-57,106}, {-57,107}, {-57,108}, {-57,110}, {-57,111}, {-57,112}, {-57,115}, {-57,116}, {-57,117}, {-57,126}, {-57,127}, {-57,135}, {-57,136}, {-57,137}, {-56,-77}, {-56,-76}, {-56,-74}, {-56,-73}, {-56,-71}, {-56,-70}, {-56,-69}, {-56,-68}, {-56,-66}, {-56,-65}, {-56,-63}, {-56,-62}, {-56,27}, {-56,28}, {-56,29}, {-56,85}, {-56,86}, {-56,87}, {-56,88}, {-56,89}, {-56,90}, {-56,91}, {-56,100}, {-56,101}, {-56,103}, {-56,104}, {-56,105}, {-56,106}, {-56,107}, {-56,108}, {-56,112}, {-56,115}, {-56,116}, {-56,117}, {-56,126}, {-56,127}, {-56,135}, {-56,136}, {-56,137}, {-55,-77}, {-55,-76}, {-55,-75}, {-55,-74}, {-55,-73}, {-55,-72}, {-55,-71}, {-55,-70}, {-55,-69}, {-55,-68}, {-55,-67}, {-55,-66}, {-55,-65}, {-55,-64}, {-55,-63}, {-55,-62}, {-55,27}, {-55,28}, {-55,29}, {-55,30}, {-55,31}, {-55,32}, {-55,33}, {-55,34}, {-55,35}, {-55,85}, {-55,86}, {-55,87}, {-55,88}, {-55,89}, {-55,90}, {-55,91}, {-55,94}, {-55,95}, {-55,96}, {-55,97}, {-55,100}, {-55,101}, {-55,103}, {-55,104}, {-55,105}, {-55,106}, {-55,107}, {-55,108}, {-55,110}, {-55,111}, {-55,112}, {-55,115}, {-55,116}, {-55,117}, {-55,126}, {-55,127}, {-55,135}, {-55,136}, {-55,137}, {-54,-77}, {-54,-76}, {-54,-75}, {-54,-74}, {-54,-73}, {-54,-72}, {-54,-70}, {-54,-69}, {-54,-67}, {-54,-66}, {-54,-65}, {-54,-64}, {-54,-63}, {-54,-62}, {-54,27}, {-54,28}, {-54,29}, {-54,31}, {-54,94}, {-54,95}, {-54,96}, {-54,97}, {-54,100}, {-54,101}, {-54,103}, {-54,104}, {-54,105}, {-54,106}, {-54,107}, {-54,108}, {-54,110}, {-54,111}, {-54,112}, {-54,115}, {-54,116}, {-54,117}, {-54,126}, {-54,127}, {-54,129}, {-54,130}, {-54,131}, {-54,132}, {-54,133}, {-54,135}, {-54,136}, {-54,137}, {-53,-70}, {-53,-69}, {-53,27}, {-53,28}, {-53,29}, {-53,31}, {-53,32}, {-53,33}, {-53,34}, {-53,35}, {-53,115}, {-53,116}, {-53,117}, {-53,126}, {-53,127}, {-53,135}, {-53,136}, {-53,137}, {-52,27}, {-52,28}, {-52,29}, {-52,31}, {-52,115}, {-52,116}, {-52,117}, {-52,120}, {-52,121}, {-52,122}, {-52,123}, {-52,124}, {-52,126}, {-52,127}, {-52,135}, {-52,136}, {-52,137}, {-51,26}, {-51,27}, {-51,28}, {-51,29}, {-51,31}, {-51,32}, {-51,33}, {-51,34}, {-51,35}, {-51,115}, {-51,116}, {-51,117}, {-51,120}, {-51,121}, {-51,122}, {-51,123}, {-51,124}, {-51,126}, {-51,127}, {-51,135}, {-51,136}, {-51,137}, {-50,26}, {-50,27}, {-50,28}, {-50,29}, {-50,115}, {-50,116}, {-50,117}, {-50,126}, {-50,127}, {-50,135}, {-50,136}, {-50,137}, {-49,26}, {-49,27}, {-49,28}, {-49,29}, {-49,30}, {-49,31}, {-49,32}, {-49,33}, {-49,34}, {-49,35}, {-49,36}, {-49,115}, {-49,116}, {-49,117}, {-49,126}, {-49,127}, {-49,135}, {-49,136}, {-49,137}, {-48,27}, {-48,28}, {-48,29}, {-48,115}, {-48,116}, {-48,117}, {-48,126}, {-48,127}, {-48,135}, {-48,136}, {-48,137}, {-47,27}, {-47,28}, {-47,29}, {-47,30}, {-47,31}, {-47,32}, {-47,33}, {-47,34}, {-47,35}, {-47,115}, {-47,116}, {-47,117}, {-47,126}, {-47,127}, {-47,135}, {-47,136}, {-47,137}, {-46,27}, {-46,28}, {-46,29}, {-46,31}, {-46,32}, {-46,33}, {-46,34}, {-46,35}, {-46,115}, {-46,116}, {-46,117}, {-46,126}, {-46,127}, {-46,129}, {-46,130}, {-46,131}, {-46,132}, {-46,133}, {-46,135}, {-46,136}, {-46,137}, {-45,27}, {-45,28}, {-45,29}, {-45,31}, {-45,115}, {-45,116}, {-45,117}, {-45,118}, {-45,126}, {-45,127}, {-45,135}, {-45,136}, {-45,137}, {-44,27}, {-44,28}, {-44,29}, {-44,31}, {-44,32}, {-44,33}, {-44,34}, {-44,35}, {-44,115}, {-44,116}, {-44,117}, {-44,126}, {-44,127}, {-44,135}, {-44,136}, {-44,137}, {-43,-64}, {-43,-63}, {-43,-62}, {-43,27}, {-43,28}, {-43,29}, {-43,31}, {-43,32}, {-43,33}, {-43,34}, {-43,35}, {-43,115}, {-43,116}, {-43,117}, {-43,126}, {-43,127}, {-43,135}, {-43,136}, {-43,137}, {-42,-64}, {-42,-63}, {-42,-62}, {-42,27}, {-42,28}, {-42,29}, {-42,31}, {-42,115}, {-42,116}, {-42,117}, {-42,126}, {-42,127}, {-42,135}, {-42,136}, {-42,137}, {-41,-64}, {-41,-63}, {-41,-62}, {-41,27}, {-41,28}, {-41,29}, {-41,31}, {-41,32}, {-41,33}, {-41,34}, {-41,35}, {-41,115}, {-41,116}, {-41,117}, {-41,120}, {-41,121}, {-41,122}, {-41,123}, {-41,124}, {-41,126}, {-41,127}, {-41,135}, {-41,136}, {-41,137}, {-40,-64}, {-40,-63}, {-40,-62}, {-40,27}, {-40,28}, {-40,29}, {-40,31}, {-40,32}, {-40,33}, {-40,34}, {-40,35}, {-40,115}, {-40,116}, {-40,117}, {-40,120}, {-40,121}, {-40,122}, {-40,123}, {-40,124}, {-40,126}, {-40,127}, {-40,135}, {-40,136}, {-40,137}, {-39,-64}, {-39,-63}, {-39,-62}, {-39,27}, {-39,28}, {-39,29}, {-39,31}, {-39,115}, {-39,116}, {-39,117}, {-39,126}, {-39,127}, {-39,135}, {-39,136}, {-39,137}, {-38,-64}, {-38,-63}, {-38,-62}, {-38,27}, {-38,28}, {-38,29}, {-38,31}, {-38,32}, {-38,33}, {-38,34}, {-38,35}, {-38,115}, {-38,116}, {-38,117}, {-38,126}, {-38,127}, {-38,129}, {-38,130}, {-38,131}, {-38,132}, {-38,133}, {-38,135}, {-38,136}, {-38,137}, {-37,-64}, {-37,-63}, {-37,-62}, {-37,27}, {-37,28}, {-37,29}, {-37,31}, {-37,32}, {-37,33}, {-37,34}, {-37,35}, {-37,115}, {-37,116}, {-37,117}, {-37,126}, {-37,127}, {-37,135}, {-37,136}, {-37,137}, {-36,94}, {-36,95}, {-36,96}, {-36,97}, {-36,100}, {-36,101}, {-36,103}, {-36,104}, {-36,105}, {-36,106}, {-36,107}, {-36,108}, {-36,110}, {-36,111}, {-36,112}, {-36,115}, {-36,116}, {-36,117}, {-36,126}, {-36,127}, {-36,135}, {-36,136}, {-36,137}, {-35,-64}, {-35,-63}, {-35,-62}, {-35,-24}, {-35,-23}, {-35,-22}, {-35,-21}, {-35,-20}, {-35,-19}, {-35,-17}, {-35,-16}, {-35,-15}, {-35,-14}, {-35,42}, {-35,43}, {-35,44}, {-35,88}, {-35,89}, {-35,90}, {-35,91}, {-35,97}, {-35,100}, {-35,101}, {-35,103}, {-35,104}, {-35,105}, {-35,106}, {-35,107}, {-35,108}, {-35,110}, {-35,111}, {-35,112}, {-35,115}, {-35,116}, {-35,117}, {-35,126}, {-35,127}, {-35,135}, {-35,136}, {-35,137}, {-34,-64}, {-34,-63}, {-34,-62}, {-34,-24}, {-34,-23}, {-34,-22}, {-34,-21}, {-34,-20}, {-34,-19}, {-34,-17}, {-34,-16}, {-34,-15}, {-34,-14}, {-34,26}, {-34,27}, {-34,28}, {-34,29}, {-34,30}, {-34,31}, {-34,32}, {-34,33}, {-34,34}, {-34,35}, {-34,42}, {-34,43}, {-34,44}, {-34,87}, {-34,88}, {-34,89}, {-34,90}, {-34,91}, {-34,94}, {-34,95}, {-34,96}, {-34,97}, {-34,100}, {-34,101}, {-34,103}, {-34,104}, {-34,105}, {-34,106}, {-34,107}, {-34,108}, {-34,111}, {-34,115}, {-34,116}, {-34,117}, {-34,126}, {-34,127}, {-34,135}, {-34,136}, {-34,137}, {-33,-64}, {-33,-63}, {-33,-62}, {-33,-15}, {-33,-14}, {-33,26}, {-33,27}, {-33,28}, {-33,29}, {-33,30}, {-33,31}, {-33,32}, {-33,33}, {-33,34}, {-33,35}, {-33,42}, {-33,43}, {-33,44}, {-33,88}, {-33,89}, {-33,90}, {-33,91}, {-33,100}, {-33,101}, {-33,103}, {-33,104}, {-33,105}, {-33,106}, {-33,107}, {-33,108}, {-33,110}, {-33,111}, {-33,112}, {-33,115}, {-33,116}, {-33,117}, {-33,126}, {-33,127}, {-33,135}, {-33,136}, {-33,137}, {-32,-64}, {-32,-63}, {-32,-62}, {-32,-24}, {-32,-23}, {-32,-22}, {-32,-21}, {-32,-20}, {-32,-19}, {-32,-18}, {-32,-17}, {-32,-15}, {-32,-14}, {-32,26}, {-32,27}, {-32,29}, {-32,30}, {-32,31}, {-32,32}, {-32,33}, {-32,34}, {-32,35}, {-32,42}, {-32,43}, {-32,44}, {-32,94}, {-32,95}, {-32,96}, {-32,97}, {-32,101}, {-32,103}, {-32,104}, {-32,105}, {-32,106}, {-32,107}, {-32,108}, {-32,111}, {-32,115}, {-32,116}, {-32,117}, {-32,120}, {-32,121}, {-32,122}, {-32,123}, {-32,124}, {-32,126}, {-32,127}, {-32,135}, {-32,136}, {-32,137}, {-31,-64}, {-31,-63}, {-31,-62}, {-31,-24}, {-31,-23}, {-31,-22}, {-31,-21}, {-31,-20}, {-31,-19}, {-31,-18}, {-31,-17}, {-31,-15}, {-31,-14}, {-31,26}, {-31,27}, {-31,42}, {-31,43}, {-31,44}, {-31,94}, {-31,95}, {-31,96}, {-31,97}, {-31,98}, {-31,99}, {-31,100}, {-31,101}, {-31,102}, {-31,103}, {-31,104}, {-31,105}, {-31,106}, {-31,107}, {-31,108}, {-31,109}, {-31,110}, {-31,111}, {-31,112}, {-31,115}, {-31,116}, {-31,117}, {-31,120}, {-31,121}, {-31,122}, {-31,123}, {-31,124}, {-31,126}, {-31,127}, {-31,135}, {-31,136}, {-31,137}, {-30,-23}, {-30,-15}, {-30,-14}, {-30,29}, {-30,30}, {-30,31}, {-30,32}, {-30,33}, {-30,34}, {-30,35}, {-30,44}, {-30,120}, {-30,121}, {-30,122}, {-30,123}, {-30,124}, {-30,126}, {-30,127}, {-30,129}, {-30,130}, {-30,131}, {-30,132}, {-30,133}, {-30,135}, {-30,136}, {-30,137}, {-29,-64}, {-29,-63}, {-29,-62}, {-29,-24}, {-29,-23}, {-29,-22}, {-29,-21}, {-29,-20}, {-29,-19}, {-29,-18}, {-29,-17}, {-29,-15}, {-29,-14}, {-29,26}, {-29,27}, {-29,29}, {-29,31}, {-29,33}, {-29,35}, {-29,42}, {-29,43}, {-29,44}, {-29,45}, {-29,46}, {-29,47}, {-29,48}, {-29,49}, {-29,50}, {-29,51}, {-29,52}, {-29,53}, {-29,54}, {-29,55}, {-29,56}, {-29,57}, {-29,58}, {-29,59}, {-29,60}, {-29,61}, {-29,62}, {-29,63}, {-29,64}, {-29,65}, {-29,66}, {-29,67}, {-29,68}, {-29,69}, {-29,70}, {-29,126}, {-29,127}, {-29,135}, {-29,136}, {-29,137}, {-28,-64}, {-28,-63}, {-28,-62}, {-28,-24}, {-28,-23}, {-28,-22}, {-28,-21}, {-28,-20}, {-28,-19}, {-28,-18}, {-28,-17}, {-28,-15}, {-28,-14}, {-28,26}, {-28,27}, {-28,28}, {-28,29}, {-28,31}, {-28,33}, {-28,35}, {-28,42}, {-28,43}, {-28,44}, {-28,45}, {-28,46}, {-28,47}, {-28,48}, {-28,49}, {-28,50}, {-28,51}, {-28,52}, {-28,53}, {-28,54}, {-28,55}, {-28,56}, {-28,57}, {-28,58}, {-28,59}, {-28,60}, {-28,61}, {-28,62}, {-28,63}, {-28,64}, {-28,65}, {-28,66}, {-28,67}, {-28,69}, {-28,70}, {-28,120}, {-28,121}, {-28,122}, {-28,123}, {-28,124}, {-28,125}, {-28,126}, {-28,127}, {-28,128}, {-28,129}, {-28,130}, {-28,131}, {-28,132}, {-28,133}, {-28,134}, {-28,135}, {-28,136}, {-28,137}, {-27,-64}, {-27,-63}, {-27,-62}, {-27,-23}, {-27,-15}, {-27,-14}, {-27,26}, {-27,27}, {-27,29}, {-27,31}, {-27,33}, {-27,35}, {-27,44}, {-27,69}, {-27,70}, {-27,120}, {-27,121}, {-27,122}, {-27,123}, {-27,124}, {-27,125}, {-27,126}, {-27,127}, {-27,128}, {-27,129}, {-27,130}, {-27,131}, {-27,132}, {-27,133}, {-27,134}, {-27,135}, {-27,136}, {-27,137}, {-26,-64}, {-26,-63}, {-26,-62}, {-26,-24}, {-26,-23}, {-26,-22}, {-26,-21}, {-26,-20}, {-26,-19}, {-26,-18}, {-26,-17}, {-26,-16}, {-26,-15}, {-26,-14}, {-26,26}, {-26,27}, {-26,29}, {-26,31}, {-26,33}, {-26,35}, {-26,42}, {-26,43}, {-26,44}, {-26,45}, {-26,46}, {-26,47}, {-26,48}, {-26,49}, {-26,50}, {-26,51}, {-26,52}, {-26,53}, {-26,54}, {-26,55}, {-26,56}, {-26,58}, {-26,59}, {-26,60}, {-26,63}, {-26,64}, {-26,65}, {-26,66}, {-26,67}, {-26,69}, {-26,70}, {-26,126}, {-26,127}, {-26,135}, {-26,136}, {-26,137}, {-25,-64}, {-25,-63}, {-25,-62}, {-25,-24}, {-25,-23}, {-25,-22}, {-25,-21}, {-25,-20}, {-25,-19}, {-25,-18}, {-25,-17}, {-25,-16}, {-25,-15}, {-25,-14}, {-25,26}, {-25,27}, {-25,29}, {-25,31}, {-25,33}, {-25,35}, {-25,42}, {-25,43}, {-25,44}, {-25,54}, {-25,55}, {-25,56}, {-25,58}, {-25,59}, {-25,60}, {-25,63}, {-25,64}, {-25,65}, {-25,66}, {-25,67}, {-25,69}, {-25,70}, {-25,126}, {-25,127}, {-25,135}, {-25,136}, {-25,137}, {-24,-64}, {-24,-63}, {-24,-62}, {-24,42}, {-24,43}, {-24,44}, {-24,46}, {-24,47}, {-24,48}, {-24,49}, {-24,50}, {-24,51}, {-24,52}, {-24,54}, {-24,55}, {-24,56}, {-24,58}, {-24,59}, {-24,60}, {-24,61}, {-24,62}, {-24,63}, {-24,64}, {-24,65}, {-24,66}, {-24,67}, {-24,69}, {-24,70}, {-24,126}, {-24,127}, {-24,135}, {-24,136}, {-24,137}, {-23,-64}, {-23,-63}, {-23,-62}, {-23,42}, {-23,43}, {-23,44}, {-23,46}, {-23,47}, {-23,48}, {-23,49}, {-23,50}, {-23,51}, {-23,52}, {-23,54}, {-23,55}, {-23,56}, {-23,58}, {-23,59}, {-23,60}, {-23,63}, {-23,64}, {-23,65}, {-23,66}, {-23,67}, {-23,69}, {-23,70}, {-23,126}, {-23,127}, {-23,135}, {-23,136}, {-23,137}, {-22,-64}, {-22,-63}, {-22,-62}, {-22,42}, {-22,43}, {-22,44}, {-22,46}, {-22,47}, {-22,48}, {-22,49}, {-22,50}, {-22,51}, {-22,52}, {-22,54}, {-22,55}, {-22,56}, {-22,58}, {-22,59}, {-22,60}, {-22,63}, {-22,64}, {-22,65}, {-22,66}, {-22,67}, {-22,69}, {-22,70}, {-22,126}, {-22,127}, {-22,135}, {-22,136}, {-22,137}, {-21,-64}, {-21,-63}, {-21,-62}, {-21,48}, {-21,49}, {-21,65}, {-21,69}, {-21,70}, {-21,126}, {-21,127}, {-21,135}, {-21,136}, {-21,137}, {-21,140}, {-21,142}, {-21,143}, {-21,144}, {-21,145}, {-21,146}, {-20,-64}, {-20,-63}, {-20,-62}, {-20,48}, {-20,49}, {-20,69}, {-20,70}, {-20,126}, {-20,127}, {-20,135}, {-20,136}, {-20,137}, {-20,140}, {-20,142}, {-20,143}, {-20,144}, {-20,145}, {-20,146}, {-19,-64}, {-19,-63}, {-19,-62}, {-19,38}, {-19,39}, {-19,40}, {-19,43}, {-19,44}, {-19,45}, {-19,46}, {-19,47}, {-19,48}, {-19,49}, {-19,50}, {-19,51}, {-19,52}, {-19,53}, {-19,54}, {-19,57}, {-19,58}, {-19,59}, {-19,69}, {-19,70}, {-19,120}, {-19,121}, {-19,123}, {-19,124}, {-19,126}, {-19,127}, {-19,129}, {-19,130}, {-19,132}, {-19,133}, {-19,135}, {-19,136}, {-19,137}, {-19,140}, {-19,142}, {-19,143}, {-19,144}, {-19,145}, {-19,146}, {-18,38}, {-18,39}, {-18,40}, {-18,43}, {-18,44}, {-18,45}, {-18,46}, {-18,47}, {-18,48}, {-18,49}, {-18,50}, {-18,51}, {-18,52}, {-18,53}, {-18,54}, {-18,55}, {-18,56}, {-18,57}, {-18,58}, {-18,59}, {-18,60}, {-18,69}, {-18,70}, {-18,120}, {-18,121}, {-18,123}, {-18,124}, {-18,126}, {-18,127}, {-18,129}, {-18,130}, {-18,132}, {-18,133}, {-18,135}, {-18,136}, {-18,137}, {-18,140}, {-18,142}, {-18,143}, {-18,144}, {-18,145}, {-18,146}, {-17,-64}, {-17,-63}, {-17,-62}, {-17,38}, {-17,39}, {-17,40}, {-17,43}, {-17,44}, {-17,45}, {-17,46}, {-17,47}, {-17,48}, {-17,49}, {-17,50}, {-17,51}, {-17,52}, {-17,53}, {-17,54}, {-17,57}, {-17,58}, {-17,59}, {-17,69}, {-17,70}, {-17,124}, {-17,126}, {-17,127}, {-17,133}, {-17,135}, {-17,136}, {-17,137}, {-17,140}, {-17,141}, {-17,142}, {-17,143}, {-17,144}, {-17,145}, {-17,146}, {-16,-64}, {-16,-63}, {-16,-62}, {-16,39}, {-16,69}, {-16,70}, {-16,126}, {-16,127}, {-16,135}, {-16,136}, {-16,137}, {-16,140}, {-16,142}, {-16,143}, {-16,144}, {-16,145}, {-16,146}, {-15,-64}, {-15,-63}, {-15,-62}, {-15,69}, {-15,70}, {-15,126}, {-15,127}, {-15,135}, {-15,136}, {-15,137}, {-15,140}, {-15,142}, {-15,143}, {-15,144}, {-15,145}, {-15,146}, {-14,-64}, {-14,-63}, {-14,-62}, {-14,69}, {-14,70}, {-14,126}, {-14,127}, {-14,135}, {-14,136}, {-14,137}, {-14,140}, {-13,-64}, {-13,-63}, {-13,-62}, {-13,69}, {-13,70}, {-13,126}, {-13,127}, {-13,135}, {-13,136}, {-13,137}, {-13,140}, {-13,142}, {-13,143}, {-13,144}, {-13,145}, {-13,146}, {-12,-64}, {-12,-63}, {-12,-62}, {-12,69}, {-12,70}, {-12,126}, {-12,127}, {-12,135}, {-12,136}, {-12,137}, {-12,140}, {-12,142}, {-12,143}, {-12,144}, {-12,146}, {-11,-64}, {-11,-63}, {-11,-62}, {-11,69}, {-11,70}, {-11,126}, {-11,127}, {-11,135}, {-11,136}, {-11,137}, {-11,140}, {-11,142}, {-11,143}, {-11,144}, {-11,146}, {-10,-64}, {-10,-63}, {-10,-62}, {-10,120}, {-10,121}, {-10,122}, {-10,123}, {-10,124}, {-10,126}, {-10,127}, {-10,129}, {-10,130}, {-10,131}, {-10,132}, {-10,133}, {-10,135}, {-10,136}, {-10,137}, {-10,140}, {-10,142}, {-10,143}, {-10,144}, {-10,146}, {-9,-64}, {-9,-63}, {-9,-62}, {-9,121}, {-9,122}, {-9,123}, {-9,124}, {-9,126}, {-9,127}, {-9,130}, {-9,131}, {-9,135}, {-9,136}, {-9,137}, {-9,140}, {-9,141}, {-9,142}, {-9,143}, {-9,144}, {-9,146}, {-8,-64}, {-8,-63}, {-8,-62}, {-8,126}, {-8,127}, {-8,135}, {-8,136}, {-8,137}, {-8,140}, {-8,142}, {-8,143}, {-8,144}, {-8,146}, {-7,-64}, {-7,-63}, {-7,-62}, {-7,126}, {-7,127}, {-7,135}, {-7,136}, {-7,137}, {-7,140}, {-7,142}, {-7,143}, {-7,144}, {-7,146}, {-6,-64}, {-6,-63}, {-6,-62}, {-6,69}, {-6,70}, {-6,126}, {-6,127}, {-6,135}, {-6,136}, {-6,137}, {-6,138}, {-6,139}, {-6,140}, {-5,-64}, {-5,-63}, {-5,-62}, {-5,126}, {-5,127}, {-5,135}, {-5,136}, {-5,137}, {-5,138}, {-5,139}, {-5,140}, {-5,142}, {-5,143}, {-5,144}, {-5,145}, {-5,146}, {-4,-64}, {-4,-63}, {-4,-62}, {-4,69}, {-4,70}, {-4,126}, {-4,127}, {-4,135}, {-4,136}, {-4,137}, {-4,140}, {-4,142}, {-4,143}, {-4,144}, {-4,145}, {-4,146}, {-3,-64}, {-3,-63}, {-3,-62}, {-3,69}, {-3,70}, {-3,126}, {-3,127}, {-3,135}, {-3,136}, {-3,137}, {-3,140}, {-3,141}, {-3,142}, {-3,143}, {-3,144}, {-3,145}, {-3,146}, {-2,-64}, {-2,-63}, {-2,-62}, {-2,69}, {-2,70}, {-2,92}, {-2,93}, {-2,95}, {-2,96}, {-2,97}, {-2,98}, {-2,99}, {-2,100}, {-2,101}, {-2,102}, {-2,103}, {-2,104}, {-2,105}, {-2,106}, {-2,107}, {-2,108}, {-2,109}, {-2,110}, {-2,111}, {-2,112}, {-2,113}, {-2,114}, {-2,115}, {-2,116}, {-2,117}, {-2,118}, {-2,120}, {-2,121}, {-2,122}, {-2,123}, {-2,124}, {-2,126}, {-2,127}, {-2,129}, {-2,130}, {-2,131}, {-2,132}, {-2,133}, {-2,135}, {-2,136}, {-2,137}, {-2,140}, {-2,142}, {-2,143}, {-2,144}, {-2,145}, {-2,146}, {-1,-63}, {-1,69}, {-1,70}, {-1,92}, {-1,93}, {-1,95}, {-1,96}, {-1,97}, {-1,98}, {-1,99}, {-1,100}, {-1,101}, {-1,102}, {-1,103}, {-1,104}, {-1,105}, {-1,106}, {-1,107}, {-1,108}, {-1,109}, {-1,110}, {-1,111}, {-1,112}, {-1,113}, {-1,114}, {-1,115}, {-1,116}, {-1,117}, {-1,118}, {-1,119}, {-1,120}, {-1,121}, {-1,122}, {-1,123}, {-1,124}, {-1,126}, {-1,127}, {-1,128}, {-1,129}, {-1,130}, {-1,131}, {-1,132}, {-1,133}, {-1,135}, {-1,136}, {-1,137}, {-1,140}, {-1,142}, {-1,143}, {-1,144}, {-1,145}, {-1,146}, {0,-64}, {0,-63}, {0,-62}, {0,38}, {0,39}, {0,40}, {0,43}, {0,44}, {0,45}, {0,46}, {0,47}, {0,48}, {0,49}, {0,50}, {0,51}, {0,52}, {0,53}, {0,54}, {0,57}, {0,58}, {0,59}, {0,69}, {0,70}, {0,92}, {0,93}, {0,95}, {0,103}, {0,112}, {0,117}, {0,118}, {0,120}, {0,121}, {0,122}, {0,123}, {0,124}, {0,126}, {0,127}, {0,129}, {0,130}, {0,131}, {0,132}, {0,133}, {0,135}, {0,136}, {0,137}, {0,140}, {0,142}, {0,143}, {0,144}, {0,145}, {0,146}, {1,-64}, {1,-63}, {1,-62}, {1,38}, {1,39}, {1,40}, {1,41}, {1,42}, {1,43}, {1,44}, {1,45}, {1,46}, {1,47}, {1,48}, {1,49}, {1,50}, {1,51}, {1,52}, {1,53}, {1,54}, {1,55}, {1,56}, {1,57}, {1,58}, {1,59}, {1,69}, {1,70}, {1,92}, {1,93}, {1,95}, {1,96}, {1,97}, {1,98}, {1,100}, {1,101}, {1,103}, {1,104}, {1,105}, {1,106}, {1,107}, {1,109}, {1,110}, {1,112}, {1,113}, {1,114}, {1,115}, {1,117}, {1,118}, {1,121}, {1,126}, {1,127}, {1,135}, {1,136}, {1,137}, {1,140}, {1,142}, {1,143}, {1,144}, {1,145}, {1,146}, {2,-64}, {2,-63}, {2,-62}, {2,38}, {2,39}, {2,40}, {2,43}, {2,44}, {2,45}, {2,46}, {2,47}, {2,48}, {2,49}, {2,50}, {2,51}, {2,52}, {2,53}, {2,54}, {2,57}, {2,58}, {2,59}, {2,69}, {2,70}, {2,92}, {2,93}, {2,95}, {2,96}, {2,97}, {2,98}, {2,99}, {2,100}, {2,101}, {2,103}, {2,104}, {2,105}, {2,106}, {2,107}, {2,108}, {2,109}, {2,110}, {2,112}, {2,113}, {2,114}, {2,115}, {2,117}, {2,118}, {2,120}, {2,121}, {2,122}, {2,123}, {2,124}, {2,126}, {2,127}, {2,129}, {2,130}, {2,131}, {2,132}, {2,133}, {2,135}, {2,136}, {2,137}, {2,140}, {2,146}, {3,-64}, {3,-63}, {3,-62}, {3,92}, {3,93}, {3,95}, {3,96}, {3,97}, {3,98}, {3,100}, {3,101}, {3,103}, {3,104}, {3,105}, {3,106}, {3,107}, {3,109}, {3,110}, {3,112}, {3,113}, {3,114}, {3,115}, {3,117}, {3,118}, {3,120}, {3,121}, {3,122}, {3,123}, {3,124}, {3,126}, {3,127}, {3,129}, {3,130}, {3,131}, {3,132}, {3,133}, {3,134}, {3,135}, {3,136}, {3,137}, {3,140}, {3,142}, {3,143}, {3,144}, {3,145}, {3,146}, {4,-64}, {4,-63}, {4,-62}, {4,92}, {4,93}, {4,117}, {4,118}, {4,126}, {4,127}, {4,140}, {5,-64}, {5,-63}, {5,-62}, {5,62}, {5,63}, {5,64}, {5,65}, {5,66}, {5,67}, {5,68}, {5,69}, {5,70}, {5,71}, {5,72}, {5,73}, {5,74}, {5,75}, {5,76}, {5,78}, {5,79}, {5,80}, {5,81}, {5,82}, {5,83}, {5,84}, {5,86}, {5,87}, {5,88}, {5,89}, {5,90}, {5,92}, {5,93}, {5,94}, {5,95}, {5,96}, {5,97}, {5,98}, {5,99}, {5,100}, {5,101}, {5,102}, {5,103}, {5,104}, {5,105}, {5,106}, {5,107}, {5,108}, {5,109}, {5,110}, {5,111}, {5,112}, {5,113}, {5,114}, {5,115}, {5,116}, {5,117}, {5,118}, {5,119}, {5,120}, {5,121}, {5,122}, {5,123}, {5,124}, {5,125}, {5,126}, {5,127}, {5,128}, {5,129}, {5,130}, {5,131}, {5,132}, {5,133}, {5,135}, {5,136}, {5,137}, {5,140}, {5,142}, {5,143}, {5,144}, {5,145}, {5,146}, {6,-64}, {6,-63}, {6,-62}, {6,38}, {6,39}, {6,40}, {6,41}, {6,42}, {6,43}, {6,44}, {6,45}, {6,46}, {6,47}, {6,48}, {6,49}, {6,52}, {6,53}, {6,54}, {6,56}, {6,57}, {6,58}, {6,59}, {6,62}, {6,63}, {6,64}, {6,65}, {6,66}, {6,67}, {6,68}, {6,69}, {6,70}, {6,71}, {6,72}, {6,73}, {6,74}, {6,75}, {6,76}, {6,78}, {6,79}, {6,80}, {6,81}, {6,82}, {6,83}, {6,84}, {6,85}, {6,86}, {6,87}, {6,88}, {6,89}, {6,90}, {6,91}, {6,92}, {6,93}, {6,94}, {6,95}, {6,96}, {6,97}, {6,98}, {6,99}, {6,100}, {6,101}, {6,102}, {6,103}, {6,104}, {6,105}, {6,106}, {6,107}, {6,108}, {6,109}, {6,110}, {6,111}, {6,112}, {6,113}, {6,114}, {6,115}, {6,116}, {6,117}, {6,118}, {6,119}, {6,120}, {6,121}, {6,122}, {6,123}, {6,124}, {6,125}, {6,126}, {6,127}, {6,128}, {6,129}, {6,130}, {6,131}, {6,132}, {6,133}, {6,134}, {6,135}, {6,136}, {6,137}, {6,140}, {6,141}, {6,142}, {6,143}, {6,144}, {6,145}, {6,146}, {7,-64}, {7,-63}, {7,-62}, {7,38}, {7,39}, {7,40}, {7,41}, {7,42}, {7,43}, {7,44}, {7,45}, {7,46}, {7,47}, {7,48}, {7,49}, {7,50}, {7,51}, {7,52}, {7,53}, {7,54}, {7,55}, {7,56}, {7,57}, {7,58}, {7,59}, {7,62}, {7,63}, {7,64}, {7,65}, {7,67}, {7,68}, {7,69}, {7,70}, {7,71}, {7,72}, {7,73}, {7,74}, {7,75}, {7,76}, {7,78}, {7,79}, {7,80}, {7,81}, {7,82}, {7,83}, {7,84}, {7,86}, {7,87}, {7,88}, {7,89}, {7,90}, {7,92}, {7,93}, {7,94}, {7,95}, {7,96}, {7,97}, {7,98}, {7,99}, {7,100}, {7,101}, {7,102}, {7,103}, {7,104}, {7,105}, {7,106}, {7,107}, {7,108}, {7,109}, {7,110}, {7,111}, {7,112}, {7,113}, {7,114}, {7,115}, {7,116}, {7,117}, {7,118}, {7,119}, {7,120}, {7,121}, {7,122}, {7,123}, {7,124}, {7,125}, {7,126}, {7,127}, {7,128}, {7,129}, {7,130}, {7,131}, {7,132}, {7,133}, {7,135}, {7,136}, {7,137}, {7,140}, {7,142}, {7,143}, {7,144}, {7,145}, {7,146}, {8,-64}, {8,-63}, {8,-62}, {8,38}, {8,39}, {8,40}, {8,41}, {8,42}, {8,43}, {8,44}, {8,45}, {8,46}, {8,47}, {8,48}, {8,49}, {8,50}, {8,51}, {8,52}, {8,53}, {8,54}, {8,55}, {8,56}, {8,57}, {8,58}, {8,59}, {8,62}, {8,63}, {8,64}, {8,65}, {8,71}, {8,93}, {8,108}, {8,136}, {9,-64}, {9,-63}, {9,-62}, {9,38}, {9,39}, {9,40}, {9,41}, {9,42}, {9,43}, {9,44}, {9,45}, {9,46}, {9,47}, {9,48}, {9,49}, {9,52}, {9,53}, {9,54}, {9,56}, {9,57}, {9,58}, {9,59}, {9,62}, {9,63}, {9,64}, {9,65}, {9,67}, {9,68}, {9,69}, {9,70}, {9,71}, {9,72}, {9,73}, {9,74}, {9,86}, {9,87}, {9,88}, {9,89}, {9,90}, {9,92}, {9,93}, {9,94}, {9,95}, {9,96}, {9,97}, {9,98}, {9,99}, {9,100}, {9,102}, {9,103}, {9,104}, {9,105}, {9,107}, {9,108}, {9,109}, {9,117}, {9,125}, {9,133}, {9,135}, {9,136}, {9,137}, {10,53}, {10,62}, {10,63}, {10,64}, {10,65}, {10,67}, {10,68}, {10,69}, {10,70}, {10,71}, {10,72}, {10,73}, {10,74}, {10,86}, {10,87}, {10,88}, {10,89}, {10,90}, {10,92}, {10,93}, {10,94}, {10,95}, {10,96}, {10,97}, {10,98}, {10,99}, {10,100}, {10,102}, {10,103}, {10,104}, {10,105}, {10,107}, {10,108}, {10,109}, {10,117}, {10,125}, {10,133}, {10,135}, {10,136}, {10,137}, {11,53}, {11,67}, {11,103}, {11,107}, {11,108}, {11,109}, {11,117}, {11,125}, {11,133}, {11,135}, {11,136}, {11,137}, {12,-64}, {12,-63}, {12,-62}, {12,-61}, {12,-60}, {12,-59}, {12,-58}, {12,-57}, {12,-56}, {12,-55}, {12,-54}, {12,-53}, {12,-51}, {12,-49}, {12,-48}, {12,-47}, {12,-46}, {12,-45}, {12,-44}, {12,-43}, {12,-42}, {12,-41}, {12,-40}, {12,-39}, {12,-38}, {12,-37}, {12,-36}, {12,-35}, {12,-34}, {12,-33}, {12,-32}, {12,-31}, {12,-28}, {12,-27}, {12,-26}, {12,-25}, {12,-24}, {12,-23}, {12,-20}, {12,-19}, {12,-18}, {12,-17}, {12,-16}, {12,-15}, {12,-14}, {12,-13}, {12,-12}, {12,-11}, {12,-10}, {12,-9}, {12,-8}, {12,-5}, {12,-4}, {12,-3}, {12,-2}, {12,-1}, {12,0}, {12,3}, {12,4}, {12,5}, {12,6}, {12,7}, {12,8}, {12,9}, {12,10}, {12,11}, {12,12}, {12,13}, {12,14}, {12,15}, {12,16}, {12,17}, {12,18}, {12,19}, {12,20}, {12,21}, {12,22}, {12,25}, {12,26}, {12,27}, {12,28}, {12,29}, {12,30}, {12,31}, {12,32}, {12,33}, {12,34}, {12,35}, {12,36}, {12,37}, {12,38}, {12,39}, {12,40}, {12,41}, {12,42}, {12,43}, {12,44}, {12,45}, {12,47}, {12,48}, {12,49}, {12,52}, {12,53}, {12,54}, {12,55}, {12,56}, {12,57}, {12,58}, {12,59}, {12,60}, {12,61}, {12,62}, {12,63}, {12,64}, {12,65}, {12,66}, {12,67}, {12,68}, {12,69}, {12,70}, {12,102}, {12,103}, {12,104}, {12,105}, {12,107}, {12,108}, {12,109}, {12,117}, {12,125}, {12,133}, {12,135}, {12,136}, {12,137}, {13,-64}, {13,-63}, {13,-62}, {13,-61}, {13,-60}, {13,-59}, {13,-58}, {13,-57}, {13,-56}, {13,-55}, {13,-54}, {13,-53}, {13,-52}, {13,-51}, {13,-49}, {13,-48}, {13,-47}, {13,-46}, {13,-45}, {13,-44}, {13,-43}, {13,-42}, {13,-41}, {13,-40}, {13,-39}, {13,-38}, {13,-37}, {13,-36}, {13,-35}, {13,-34}, {13,-33}, {13,-32}, {13,-31}, {13,-28}, {13,-27}, {13,-26}, {13,-25}, {13,-24}, {13,-23}, {13,-20}, {13,-19}, {13,-18}, {13,-17}, {13,-16}, {13,-15}, {13,-14}, {13,-13}, {13,-12}, {13,-11}, {13,-10}, {13,-9}, {13,-8}, {13,-5}, {13,-4}, {13,-3}, {13,-2}, {13,-1}, {13,0}, {13,3}, {13,4}, {13,5}, {13,6}, {13,7}, {13,8}, {13,9}, {13,10}, {13,11}, {13,12}, {13,13}, {13,14}, {13,15}, {13,16}, {13,17}, {13,18}, {13,19}, {13,20}, {13,21}, {13,22}, {13,25}, {13,26}, {13,27}, {13,28}, {13,29}, {13,30}, {13,31}, {13,32}, {13,33}, {13,34}, {13,35}, {13,36}, {13,37}, {13,38}, {13,39}, {13,40}, {13,41}, {13,42}, {13,43}, {13,44}, {13,45}, {13,46}, {13,47}, {13,48}, {13,49}, {13,52}, {13,53}, {13,54}, {13,55}, {13,56}, {13,57}, {13,58}, {13,59}, {13,60}, {13,61}, {13,62}, {13,63}, {13,64}, {13,65}, {13,66}, {13,67}, {13,68}, {13,69}, {13,70}, {13,102}, {13,103}, {13,104}, {13,105}, {13,107}, {13,108}, {13,109}, {13,117}, {13,125}, {13,133}, {13,135}, {13,136}, {13,137}, {14,-64}, {14,-63}, {14,-62}, {14,-61}, {14,-60}, {14,-59}, {14,-58}, {14,-57}, {14,-56}, {14,-55}, {14,-54}, {14,-53}, {14,-51}, {14,-49}, {14,-48}, {14,-47}, {14,-46}, {14,-45}, {14,-44}, {14,-43}, {14,-42}, {14,-41}, {14,-40}, {14,-39}, {14,-38}, {14,-37}, {14,-36}, {14,-35}, {14,-34}, {14,-33}, {14,-32}, {14,-31}, {14,-28}, {14,-27}, {14,-26}, {14,-25}, {14,-24}, {14,-23}, {14,-20}, {14,-19}, {14,-18}, {14,-17}, {14,-16}, {14,-15}, {14,-14}, {14,-13}, {14,-12}, {14,-11}, {14,-10}, {14,-9}, {14,-8}, {14,-5}, {14,-4}, {14,-3}, {14,-2}, {14,-1}, {14,0}, {14,3}, {14,4}, {14,5}, {14,6}, {14,7}, {14,8}, {14,9}, {14,10}, {14,11}, {14,12}, {14,13}, {14,14}, {14,15}, {14,16}, {14,17}, {14,18}, {14,19}, {14,20}, {14,21}, {14,22}, {14,25}, {14,26}, {14,27}, {14,28}, {14,29}, {14,30}, {14,31}, {14,32}, {14,33}, {14,34}, {14,35}, {14,36}, {14,37}, {14,38}, {14,39}, {14,40}, {14,41}, {14,42}, {14,43}, {14,44}, {14,45}, {14,47}, {14,48}, {14,49}, {14,53}, {14,65}, {14,102}, {14,103}, {14,104}, {14,105}, {14,107}, {14,108}, {14,109}, {14,135}, {14,136}, {14,137}, {15,47}, {15,48}, {15,49}, {15,52}, {15,53}, {15,54}, {15,64}, {15,65}, {15,66}, {15,68}, {15,69}, {15,70}, {15,102}, {15,103}, {15,104}, {15,105}, {15,107}, {15,108}, {15,109}, {15,110}, {15,111}, {15,112}, {15,113}, {15,114}, {15,115}, {15,116}, {15,117}, {15,118}, {15,119}, {15,120}, {15,121}, {15,122}, {15,123}, {15,124}, {15,125}, {15,126}, {15,127}, {15,128}, {15,129}, {15,130}, {15,131}, {15,132}, {15,133}, {15,134}, {15,135}, {15,136}, {15,137}, {16,-1}, {16,47}, {16,48}, {16,49}, {16,52}, {16,53}, {16,54}, {16,64}, {16,65}, {16,66}, {16,68}, {16,69}, {16,70}, {16,102}, {16,103}, {16,104}, {16,105}, {16,107}, {16,108}, {16,109}, {16,110}, {16,111}, {16,112}, {16,113}, {16,114}, {16,115}, {16,116}, {16,117}, {16,118}, {16,119}, {16,120}, {16,121}, {16,122}, {16,123}, {16,124}, {16,125}, {16,126}, {16,127}, {16,128}, {16,129}, {16,130}, {16,131}, {16,132}, {16,133}, {16,134}, {16,135}, {16,136}, {16,137}, {17,-5}, {17,-4}, {17,-3}, {17,-2}, {17,-1}, {17,0}, {17,47}, {17,48}, {17,49}, {17,52}, {17,53}, {17,54}, {17,64}, {17,65}, {17,66}, {17,68}, {17,69}, {17,70}, {17,102}, {17,103}, {17,104}, {17,105}, {17,107}, {17,108}, {17,109}, {17,110}, {17,111}, {17,112}, {17,113}, {17,114}, {17,115}, {17,116}, {17,117}, {17,118}, {17,119}, {17,120}, {17,121}, {17,122}, {17,123}, {17,124}, {17,125}, {17,126}, {17,127}, {17,128}, {17,129}, {17,130}, {17,131}, {17,132}, {17,133}, {17,134}, {17,135}, {17,136}, {17,137}, {18,-5}, {18,-4}, {18,-3}, {18,-2}, {18,-1}, {18,0}, {18,47}, {18,48}, {18,49}, {18,52}, {18,53}, {18,54}, {18,64}, {18,65}, {18,66}, {18,68}, {18,69}, {18,70}, {18,102}, {18,103}, {18,104}, {18,105}, {18,107}, {18,108}, {18,109}, {18,135}, {18,136}, {18,137}, {19,-1}, {19,47}, {19,48}, {19,49}, {19,52}, {19,53}, {19,54}, {19,64}, {19,65}, {19,66}, {19,68}, {19,69}, {19,70}, {19,102}, {19,103}, {19,104}, {19,105}, {19,107}, {19,108}, {19,109}, {19,117}, {19,125}, {19,133}, {19,135}, {19,136}, {19,137}, {20,47}, {20,48}, {20,49}, {20,52}, {20,53}, {20,54}, {20,68}, {20,69}, {20,70}, {20,102}, {20,103}, {20,104}, {20,105}, {20,107}, {20,108}, {20,109}, {20,117}, {20,125}, {20,133}, {20,135}, {20,136}, {20,137}, {21,47}, {21,48}, {21,49}, {21,52}, {21,53}, {21,54}, {21,64}, {21,65}, {21,66}, {21,68}, {21,69}, {21,70}, {21,103}, {21,104}, {21,105}, {21,107}, {21,108}, {21,109}, {21,117}, {21,125}, {21,133}, {21,135}, {21,136}, {21,137}, {22,47}, {22,48}, {22,49}, {22,52}, {22,53}, {22,54}, {22,64}, {22,65}, {22,66}, {22,68}, {22,69}, {22,70}, {22,86}, {22,87}, {22,88}, {22,89}, {22,90}, {22,92}, {22,93}, {22,94}, {22,95}, {22,96}, {22,97}, {22,98}, {22,99}, {22,100}, {22,102}, {22,103}, {22,104}, {22,105}, {22,107}, {22,108}, {22,109}, {22,117}, {22,125}, {22,133}, {22,135}, {22,136}, {22,137}, {23,47}, {23,48}, {23,49}, {23,52}, {23,53}, {23,54}, {23,56}, {23,57}, {23,58}, {23,59}, {23,60}, {23,61}, {23,62}, {23,64}, {23,65}, {23,66}, {23,68}, {23,69}, {23,70}, {23,86}, {23,87}, {23,88}, {23,89}, {23,90}, {23,92}, {23,93}, {23,94}, {23,95}, {23,96}, {23,97}, {23,98}, {23,99}, {23,100}, {23,102}, {23,103}, {23,104}, {23,105}, {23,107}, {23,108}, {23,109}, {23,117}, {23,125}, {23,133}, {23,135}, {23,136}, {23,137}, {24,47}, {24,48}, {24,49}, {24,56}, {24,57}, {24,58}, {24,59}, {24,60}, {24,61}, {24,62}, {24,65}, {24,89}, {24,107}, {24,108}, {24,109}, {24,135}, {24,136}, {24,137}, {25,47}, {25,48}, {25,49}, {25,52}, {25,53}, {25,54}, {25,56}, {25,57}, {25,58}, {25,59}, {25,60}, {25,61}, {25,62}, {25,64}, {25,65}, {25,66}, {25,67}, {25,68}, {25,69}, {25,70}, {25,71}, {25,72}, {25,73}, {25,74}, {25,76}, {25,77}, {25,78}, {25,79}, {25,81}, {25,82}, {25,83}, {25,84}, {25,85}, {25,86}, {25,87}, {25,88}, {25,89}, {25,90}, {25,91}, {25,92}, {25,93}, {25,94}, {25,96}, {25,97}, {25,98}, {25,99}, {25,100}, {25,101}, {25,102}, {25,103}, {25,104}, {25,105}, {25,107}, {25,108}, {25,109}, {25,111}, {25,112}, {25,113}, {25,114}, {25,115}, {25,116}, {25,117}, {25,119}, {25,120}, {25,121}, {25,122}, {25,123}, {25,124}, {25,125}, {25,127}, {25,128}, {25,129}, {25,130}, {25,131}, {25,132}, {25,133}, {25,135}, {25,136}, {25,137}, {26,47}, {26,48}, {26,49}, {26,52}, {26,53}, {26,54}, {26,56}, {26,57}, {26,58}, {26,59}, {26,60}, {26,61}, {26,62}, {26,64}, {26,65}, {26,66}, {26,67}, {26,68}, {26,69}, {26,70}, {26,71}, {26,72}, {26,73}, {26,74}, {26,75}, {26,76}, {26,77}, {26,78}, {26,79}, {26,81}, {26,82}, {26,83}, {26,84}, {26,85}, {26,86}, {26,87}, {26,88}, {26,89}, {26,90}, {26,91}, {26,92}, {26,93}, {26,94}, {26,96}, {26,97}, {26,98}, {26,99}, {26,100}, {26,101}, {26,102}, {26,103}, {26,104}, {26,105}, {26,106}, {26,107}, {26,108}, {26,109}, {26,111}, {26,112}, {26,113}, {26,114}, {26,115}, {26,116}, {26,117}, {26,119}, {26,120}, {26,121}, {26,122}, {26,123}, {26,124}, {26,125}, {26,127}, {26,128}, {26,129}, {26,130}, {26,131}, {26,132}, {26,133}, {26,135}, {26,136}, {26,137}, {27,47}, {27,48}, {27,49}, {27,52}, {27,53}, {27,54}, {27,56}, {27,57}, {27,58}, {27,59}, {27,60}, {27,61}, {27,62}, {27,64}, {27,65}, {27,66}, {27,67}, {27,68}, {27,69}, {27,70}, {27,71}, {27,72}, {27,73}, {27,74}, {27,76}, {27,77}, {27,78}, {27,79}, {27,81}, {27,82}, {27,83}, {27,84}, {27,85}, {27,86}, {27,87}, {27,88}, {27,89}, {27,90}, {27,91}, {27,92}, {27,93}, {27,94}, {27,96}, {27,97}, {27,98}, {27,99}, {27,100}, {27,101}, {27,102}, {27,103}, {27,104}, {27,105}, {27,107}, {27,108}, {27,109}, {27,111}, {27,112}, {27,113}, {27,114}, {27,115}, {27,116}, {27,117}, {27,119}, {27,120}, {27,121}, {27,122}, {27,123}, {27,124}, {27,125}, {27,127}, {27,128}, {27,129}, {27,130}, {27,131}, {27,132}, {27,133}, {27,135}, {27,136}, {27,137}, {28,47}, {28,48}, {28,49}, {29,47}, {29,48}, {29,49}, {30,47}, {30,48}, {30,49}, {31,47}, {31,48}, {31,49}, {32,47}, {32,48}, {32,49}, {33,47}, {33,48}, {33,49}, {34,47}, {34,48}, {34,49}, {35,47}, {35,48}, {35,49}, {36,47}, {36,48}, {36,49}, {36,59}, {36,60}, {36,61}, {36,63}, {36,64}, {36,65}, {36,66}, {36,67}, {36,69}, {36,70}, {36,71}, {36,72}, {36,73}, {36,76}, {36,77}, {36,78}, {36,81}, {36,82}, {36,83}, {36,84}, {36,85}, {36,86}, {36,87}, {36,89}, {36,90}, {36,91}, {36,92}, {36,93}, {36,94}, {36,95}, {36,97}, {36,98}, {36,99}, {36,100}, {36,101}, {36,102}, {36,103}, {36,106}, {36,107}, {36,108}, {36,110}, {36,111}, {36,112}, {36,113}, {36,114}, {36,115}, {36,116}, {36,117}, {36,118}, {36,119}, {36,120}, {36,121}, {36,122}, {36,123}, {36,124}, {36,125}, {36,126}, {36,128}, {36,129}, {36,130}, {36,131}, {36,132}, {36,133}, {36,134}, {36,135}, {36,136}, {36,137}, {36,138}, {36,140}, {36,141}, {36,142}, {37,47}, {37,48}, {37,49}, {37,59}, {37,60}, {37,61}, {37,62}, {37,63}, {37,64}, {37,65}, {37,66}, {37,67}, {37,69}, {37,70}, {37,71}, {37,72}, {37,73}, {37,76}, {37,77}, {37,78}, {37,81}, {37,82}, {37,83}, {37,84}, {37,85}, {37,86}, {37,87}, {37,88}, {37,89}, {37,90}, {37,91}, {37,92}, {37,93}, {37,94}, {37,95}, {37,96}, {37,97}, {37,98}, {37,99}, {37,100}, {37,101}, {37,102}, {37,103}, {37,106}, {37,107}, {37,108}, {37,109}, {37,110}, {37,111}, {37,112}, {37,113}, {37,114}, {37,115}, {37,116}, {37,117}, {37,118}, {37,119}, {37,120}, {37,121}, {37,122}, {37,123}, {37,124}, {37,125}, {37,126}, {37,128}, {37,129}, {37,130}, {37,131}, {37,132}, {37,133}, {37,134}, {37,135}, {37,136}, {37,137}, {37,138}, {37,139}, {37,140}, {37,141}, {37,142}, {38,47}, {38,48}, {38,49}, {38,59}, {38,60}, {38,61}, {38,63}, {38,64}, {38,65}, {38,66}, {38,67}, {38,69}, {38,70}, {38,71}, {38,72}, {38,73}, {38,76}, {38,77}, {38,78}, {38,81}, {38,82}, {38,83}, {38,84}, {38,85}, {38,86}, {38,87}, {38,89}, {38,90}, {38,91}, {38,92}, {38,93}, {38,94}, {38,95}, {38,97}, {38,98}, {38,99}, {38,100}, {38,101}, {38,102}, {38,103}, {38,106}, {38,107}, {38,108}, {38,110}, {38,111}, {38,112}, {38,113}, {38,114}, {38,115}, {38,116}, {38,117}, {38,118}, {38,119}, {38,120}, {38,121}, {38,122}, {38,123}, {38,124}, {38,125}, {38,126}, {38,128}, {38,129}, {38,130}, {38,131}, {38,132}, {38,133}, {38,134}, {38,135}, {38,136}, {38,137}, {38,138}, {38,140}, {38,141}, {38,142}, {39,47}, {39,48}, {39,49}, {39,76}, {39,77}, {39,78}, {39,106}, {39,107}, {39,108}, {39,125}, {39,140}, {39,141}, {39,142}, {40,47}, {40,48}, {40,49}, {40,59}, {40,60}, {40,61}, {40,76}, {40,77}, {40,78}, {40,106}, {40,107}, {40,108}, {40,124}, {40,125}, {40,126}, {40,140}, {40,141}, {40,142}, {41,47}, {41,48}, {41,49}, {41,59}, {41,60}, {41,61}, {41,76}, {41,77}, {41,78}, {41,106}, {41,107}, {41,108}, {41,124}, {41,125}, {41,126}, {41,140}, {41,141}, {41,142}, {42,47}, {42,48}, {42,49}, {42,59}, {42,60}, {42,61}, {42,76}, {42,77}, {42,78}, {42,79}, {42,105}, {42,106}, {42,107}, {42,108}, {42,124}, {42,125}, {42,126}, {42,140}, {42,141}, {42,142}, {43,47}, {43,48}, {43,49}, {43,59}, {43,60}, {43,61}, {43,76}, {43,77}, {43,78}, {43,106}, {43,107}, {43,108}, {43,124}, {43,125}, {43,126}, {43,140}, {43,141}, {43,142}, {44,47}, {44,48}, {44,49}, {44,59}, {44,60}, {44,61}, {44,76}, {44,77}, {44,78}, {44,106}, {44,107}, {44,108}, {44,124}, {44,125}, {44,126}, {44,140}, {44,141}, {44,142}, {45,47}, {45,48}, {45,49}, {45,59}, {45,60}, {45,61}, {45,76}, {45,77}, {45,78}, {45,106}, {45,107}, {45,108}, {45,124}, {45,125}, {45,126}, {45,140}, {45,141}, {45,142}, {46,47}, {46,48}, {46,49}, {46,59}, {46,60}, {46,61}, {46,76}, {46,77}, {46,78}, {46,106}, {46,107}, {46,108}, {46,124}, {46,125}, {46,126}, {46,140}, {46,141}, {46,142}, {47,47}, {47,48}, {47,49}, {47,59}, {47,60}, {47,61}, {47,76}, {47,77}, {47,78}, {47,106}, {47,107}, {47,108}, {47,124}, {47,125}, {47,126}, {47,140}, {47,141}, {47,142}, {48,47}, {48,48}, {48,49}, {48,76}, {48,77}, {48,78}, {48,106}, {48,107}, {48,108}, {48,124}, {48,125}, {48,126}, {48,140}, {48,141}, {48,142}, {49,-60}, {49,47}, {49,48}, {49,49}, {49,59}, {49,60}, {49,61}, {49,106}, {49,107}, {49,108}, {49,124}, {49,125}, {49,126}, {49,140}, {49,141}, {49,142}, {50,-62}, {50,-61}, {50,-60}, {50,-59}, {50,-58}, {50,-57}, {50,-56}, {50,-55}, {50,-54}, {50,-53}, {50,-52}, {50,-51}, {50,-50}, {50,-49}, {50,-48}, {50,-47}, {50,47}, {50,48}, {50,49}, {50,59}, {50,60}, {50,61}, {50,76}, {50,77}, {50,78}, {50,106}, {50,107}, {50,108}, {50,124}, {50,125}, {50,126}, {50,140}, {50,141}, {50,142}, {51,-62}, {51,-61}, {51,-60}, {51,-59}, {51,-58}, {51,-57}, {51,-56}, {51,-55}, {51,-54}, {51,-53}, {51,-52}, {51,-51}, {51,-50}, {51,-49}, {51,-48}, {51,-47}, {51,47}, {51,48}, {51,49}, {51,59}, {51,60}, {51,61}, {51,76}, {51,77}, {51,78}, {51,106}, {51,107}, {51,108}, {51,125}, {52,47}, {52,48}, {52,49}, {52,59}, {52,60}, {52,61}, {52,76}, {52,77}, {52,78}, {52,106}, {52,107}, {52,108}, {52,110}, {52,111}, {52,112}, {52,113}, {52,115}, {52,116}, {52,117}, {52,119}, {52,120}, {52,121}, {52,122}, {52,123}, {52,124}, {52,125}, {52,126}, {52,127}, {52,128}, {52,129}, {52,131}, {52,132}, {52,133}, {52,134}, {52,136}, {52,137}, {52,138}, {52,140}, {52,141}, {52,142}, {53,47}, {53,48}, {53,49}, {53,59}, {53,60}, {53,61}, {53,76}, {53,77}, {53,78}, {53,106}, {53,107}, {53,108}, {53,109}, {53,110}, {53,111}, {53,112}, {53,113}, {53,115}, {53,116}, {53,117}, {53,118}, {53,119}, {53,120}, {53,121}, {53,122}, {53,123}, {53,124}, {53,125}, {53,126}, {53,127}, {53,128}, {53,129}, {53,131}, {53,132}, {53,133}, {53,134}, {53,135}, {53,136}, {53,137}, {53,138}, {53,139}, {53,140}, {53,141}, {53,142}, {54,-90}, {54,-89}, {54,-88}, {54,-87}, {54,-86}, {54,47}, {54,48}, {54,49}, {54,59}, {54,60}, {54,61}, {54,76}, {54,77}, {54,78}, {54,106}, {54,107}, {54,108}, {54,110}, {54,111}, {54,112}, {54,113}, {54,115}, {54,116}, {54,117}, {54,119}, {54,120}, {54,121}, {54,122}, {54,123}, {54,124}, {54,125}, {54,126}, {54,127}, {54,128}, {54,129}, {54,131}, {54,132}, {54,133}, {54,134}, {54,136}, {54,137}, {54,138}, {54,140}, {54,141}, {54,142}, {55,-91}, {55,-90}, {55,-89}, {55,-88}, {55,-87}, {55,-86}, {55,47}, {55,48}, {55,49}, {55,59}, {55,60}, {55,61}, {55,76}, {55,77}, {55,78}, {55,107}, {56,-93}, {56,-92}, {56,-91}, {56,-90}, {56,-89}, {56,-88}, {56,-87}, {56,-86}, {56,-1}, {56,47}, {56,48}, {56,49}, {56,59}, {56,60}, {56,61}, {56,76}, {56,77}, {56,78}, {56,106}, {56,107}, {56,108}, {56,136}, {56,137}, {56,138}, {56,140}, {56,141}, {56,142}, {57,-93}, {57,-92}, {57,-91}, {57,-90}, {57,-89}, {57,-5}, {57,-4}, {57,-3}, {57,-2}, {57,-1}, {57,0}, {57,47}, {57,48}, {57,49}, {57,59}, {57,60}, {57,61}, {57,76}, {57,77}, {57,78}, {57,106}, {57,107}, {57,108}, {57,135}, {57,136}, {57,137}, {57,138}, {57,139}, {57,140}, {57,141}, {57,142}, {58,-93}, {58,-92}, {58,-87}, {58,-86}, {58,-85}, {58,-5}, {58,-4}, {58,-3}, {58,-2}, {58,-1}, {58,0}, {58,47}, {58,48}, {58,49}, {58,59}, {58,60}, {58,61}, {58,76}, {58,77}, {58,78}, {58,106}, {58,107}, {58,108}, {58,136}, {58,137}, {58,138}, {58,140}, {58,141}, {58,142}, {59,-90}, {59,-89}, {59,-88}, {59,-87}, {59,-86}, {59,-85}, {59,-1}, {59,47}, {59,48}, {59,49}, {59,76}, {59,77}, {59,78}, {59,106}, {59,107}, {59,108}, {59,116}, {59,117}, {59,133}, {59,134}, {59,136}, {59,137}, {59,138}, {59,140}, {59,141}, {59,142}, {60,-92}, {60,-91}, {60,-90}, {60,-89}, {60,-88}, {60,-87}, {60,-86}, {60,-85}, {60,-1}, {60,47}, {60,48}, {60,49}, {60,59}, {60,60}, {60,61}, {60,76}, {60,77}, {60,78}, {60,81}, {60,82}, {60,83}, {60,84}, {60,85}, {60,86}, {60,87}, {60,88}, {60,89}, {60,90}, {60,91}, {60,92}, {60,93}, {60,94}, {60,95}, {60,96}, {60,97}, {60,98}, {60,99}, {60,100}, {60,101}, {60,102}, {60,103}, {60,106}, {60,107}, {60,108}, {60,116}, {60,117}, {60,133}, {60,134}, {60,136}, {60,137}, {60,138}, {60,140}, {60,141}, {60,142}, {61,-92}, {61,-91}, {61,-90}, {61,-89}, {61,-88}, {61,-64}, {61,-63}, {61,-62}, {61,-61}, {61,-60}, {61,-59}, {61,-58}, {61,-57}, {61,-56}, {61,-55}, {61,-53}, {61,-52}, {61,-51}, {61,-50}, {61,-49}, {61,-48}, {61,-47}, {61,-46}, {61,-45}, {61,-44}, {61,-43}, {61,-42}, {61,-41}, {61,-40}, {61,-39}, {61,-38}, {61,-37}, {61,-15}, {61,-14}, {61,-13}, {61,-12}, {61,-11}, {61,-10}, {61,-9}, {61,-8}, {61,-5}, {61,-4}, {61,-3}, {61,-2}, {61,-1}, {61,0}, {61,3}, {61,4}, {61,5}, {61,6}, {61,7}, {61,8}, {61,9}, {61,10}, {61,11}, {61,12}, {61,13}, {61,14}, {61,15}, {61,16}, {61,17}, {61,18}, {61,19}, {61,20}, {61,21}, {61,22}, {61,25}, {61,26}, {61,27}, {61,28}, {61,29}, {61,30}, {61,31}, {61,32}, {61,33}, {61,34}, {61,35}, {61,36}, {61,37}, {61,38}, {61,39}, {61,40}, {61,41}, {61,42}, {61,43}, {61,44}, {61,47}, {61,48}, {61,49}, {61,59}, {61,60}, {61,61}, {61,75}, {61,76}, {61,77}, {61,78}, {61,79}, {61,80}, {61,81}, {61,82}, {61,83}, {61,84}, {61,85}, {61,86}, {61,87}, {61,88}, {61,89}, {61,90}, {61,91}, {61,92}, {61,93}, {61,94}, {61,95}, {61,96}, {61,97}, {61,98}, {61,99}, {61,100}, {61,101}, {61,102}, {61,103}, {61,104}, {61,105}, {61,106}, {61,107}, {61,108}, {61,116}, {61,117}, {61,133}, {61,134}, {61,136}, {61,137}, {61,138}, {61,140}, {61,141}, {61,142}, {62,-92}, {62,-91}, {62,-86}, {62,-85}, {62,-84}, {62,-64}, {62,-63}, {62,-62}, {62,-61}, {62,-60}, {62,-59}, {62,-58}, {62,-57}, {62,-56}, {62,-55}, {62,-53}, {62,-52}, {62,-51}, {62,-50}, {62,-49}, {62,-48}, {62,-47}, {62,-46}, {62,-45}, {62,-44}, {62,-43}, {62,-42}, {62,-41}, {62,-40}, {62,-39}, {62,-38}, {62,-37}, {62,-15}, {62,-14}, {62,-13}, {62,-12}, {62,-11}, {62,-10}, {62,-9}, {62,-8}, {62,-5}, {62,-4}, {62,-3}, {62,-2}, {62,-1}, {62,0}, {62,3}, {62,4}, {62,5}, {62,6}, {62,7}, {62,8}, {62,9}, {62,10}, {62,11}, {62,12}, {62,13}, {62,14}, {62,15}, {62,16}, {62,17}, {62,18}, {62,19}, {62,20}, {62,21}, {62,22}, {62,25}, {62,26}, {62,27}, {62,28}, {62,29}, {62,30}, {62,31}, {62,32}, {62,33}, {62,34}, {62,35}, {62,36}, {62,37}, {62,38}, {62,39}, {62,40}, {62,41}, {62,42}, {62,43}, {62,44}, {62,47}, {62,48}, {62,49}, {62,59}, {62,60}, {62,61}, {62,76}, {62,77}, {62,78}, {62,81}, {62,82}, {62,83}, {62,84}, {62,85}, {62,86}, {62,87}, {62,88}, {62,89}, {62,90}, {62,91}, {62,92}, {62,93}, {62,94}, {62,95}, {62,96}, {62,97}, {62,98}, {62,99}, {62,100}, {62,101}, {62,102}, {62,103}, {62,106}, {62,107}, {62,108}, {62,116}, {62,117}, {62,133}, {62,134}, {62,136}, {62,137}, {62,138}, {62,140}, {62,141}, {62,142}, {63,-89}, {63,-88}, {63,-87}, {63,-86}, {63,-85}, {63,-84}, {63,-63}, {63,-50}, {63,-37}, {63,-15}, {63,-14}, {63,-13}, {63,-12}, {63,-11}, {63,-10}, {63,-9}, {63,-1}, {63,59}, {63,60}, {63,61}, {63,106}, {63,107}, {63,108}, {63,116}, {63,117}, {63,133}, {63,134}, {63,136}, {63,137}, {63,138}, {63,140}, {63,141}, {63,142}, {64,-91}, {64,-90}, {64,-89}, {64,-88}, {64,-87}, {64,-86}, {64,-85}, {64,-84}, {64,-64}, {64,-63}, {64,-61}, {64,-60}, {64,-59}, {64,-58}, {64,-57}, {64,-56}, {64,-55}, {64,-53}, {64,-52}, {64,-50}, {64,-48}, {64,-47}, {64,-46}, {64,-45}, {64,-44}, {64,-43}, {64,-42}, {64,-41}, {64,-38}, {64,-37}, {64,-15}, {64,-14}, {64,-13}, {64,-9}, {64,-1}, {64,47}, {64,48}, {64,49}, {64,59}, {64,60}, {64,61}, {64,76}, {64,77}, {64,78}, {64,87}, {64,88}, {64,89}, {64,101}, {64,102}, {64,103}, {64,106}, {64,107}, {64,108}, {64,116}, {64,117}, {64,133}, {64,134}, {64,136}, {64,137}, {64,138}, {64,140}, {64,141}, {64,142}, {65,-104}, {65,-103}, {65,-102}, {65,-101}, {65,-100}, {65,-91}, {65,-90}, {65,-89}, {65,-88}, {65,-87}, {65,-84}, {65,-64}, {65,-63}, {65,-61}, {65,-60}, {65,-59}, {65,-58}, {65,-57}, {65,-56}, {65,-55}, {65,-53}, {65,-52}, {65,-50}, {65,-49}, {65,-48}, {65,-47}, {65,-46}, {65,-45}, {65,-44}, {65,-43}, {65,-42}, {65,-41}, {65,-38}, {65,-37}, {65,-15}, {65,-14}, {65,-13}, {65,-10}, {65,-9}, {65,-8}, {65,-5}, {65,-4}, {65,-3}, {65,-2}, {65,-1}, {65,0}, {65,1}, {65,2}, {65,3}, {65,4}, {65,5}, {65,6}, {65,7}, {65,8}, {65,9}, {65,10}, {65,11}, {65,12}, {65,13}, {65,14}, {65,15}, {65,16}, {65,17}, {65,18}, {65,19}, {65,20}, {65,21}, {65,22}, {65,23}, {65,24}, {65,25}, {65,26}, {65,27}, {65,28}, {65,29}, {65,30}, {65,31}, {65,32}, {65,33}, {65,34}, {65,35}, {65,36}, {65,37}, {65,38}, {65,39}, {65,40}, {65,41}, {65,42}, {65,43}, {65,44}, {65,45}, {65,47}, {65,48}, {65,49}, {65,59}, {65,60}, {65,61}, {65,76}, {65,77}, {65,78}, {65,79}, {65,87}, {65,88}, {65,89}, {65,101}, {65,102}, {65,103}, {65,106}, {65,107}, {65,108}, {65,116}, {65,117}, {65,133}, {65,134}, {65,136}, {65,137}, {65,138}, {65,140}, {65,141}, {65,142}, {66,-104}, {66,-103}, {66,-102}, {66,-101}, {66,-100}, {66,-91}, {66,-90}, {66,-85}, {66,-84}, {66,-83}, {66,-64}, {66,-63}, {66,-61}, {66,-60}, {66,-59}, {66,-58}, {66,-57}, {66,-56}, {66,-55}, {66,-53}, {66,-52}, {66,-50}, {66,-49}, {66,-48}, {66,-47}, {66,-46}, {66,-45}, {66,-44}, {66,-43}, {66,-42}, {66,-41}, {66,-38}, {66,-37}, {66,-15}, {66,-14}, {66,-13}, {66,-10}, {66,-9}, {66,-8}, {66,-5}, {66,-4}, {66,-3}, {66,-2}, {66,-1}, {66,0}, {66,1}, {66,2}, {66,3}, {66,4}, {66,5}, {66,6}, {66,7}, {66,8}, {66,9}, {66,10}, {66,11}, {66,12}, {66,13}, {66,14}, {66,15}, {66,16}, {66,17}, {66,18}, {66,19}, {66,20}, {66,21}, {66,22}, {66,23}, {66,24}, {66,25}, {66,26}, {66,27}, {66,28}, {66,29}, {66,30}, {66,31}, {66,32}, {66,33}, {66,34}, {66,35}, {66,36}, {66,37}, {66,38}, {66,39}, {66,40}, {66,41}, {66,42}, {66,43}, {66,44}, {66,45}, {66,46}, {66,47}, {66,48}, {66,49}, {66,59}, {66,60}, {66,61}, {66,76}, {66,77}, {66,78}, {66,87}, {66,88}, {66,89}, {66,101}, {66,102}, {66,103}, {66,106}, {66,107}, {66,108}, {66,116}, {66,117}, {66,133}, {66,134}, {66,136}, {66,137}, {66,138}, {66,140}, {66,141}, {66,142}, {67,-103}, {67,-102}, {67,-101}, {67,-100}, {67,-88}, {67,-87}, {67,-86}, {67,-85}, {67,-84}, {67,-83}, {67,-82}, {67,-64}, {67,-63}, {67,-61}, {67,-60}, {67,-59}, {67,-58}, {67,-57}, {67,-56}, {67,-55}, {67,-53}, {67,-52}, {67,-50}, {67,-48}, {67,-47}, {67,-46}, {67,-45}, {67,-44}, {67,-43}, {67,-42}, {67,-41}, {67,-38}, {67,-37}, {67,-15}, {67,-14}, {67,-13}, {67,-10}, {67,-9}, {67,-8}, {67,-5}, {67,-4}, {67,-3}, {67,-2}, {67,-1}, {67,0}, {67,1}, {67,2}, {67,3}, {67,4}, {67,5}, {67,6}, {67,7}, {67,8}, {67,9}, {67,10}, {67,11}, {67,12}, {67,13}, {67,14}, {67,15}, {67,16}, {67,17}, {67,18}, {67,19}, {67,20}, {67,21}, {67,22}, {67,23}, {67,24}, {67,25}, {67,26}, {67,27}, {67,28}, {67,29}, {67,30}, {67,31}, {67,32}, {67,33}, {67,34}, {67,35}, {67,36}, {67,37}, {67,38}, {67,39}, {67,40}, {67,41}, {67,42}, {67,43}, {67,44}, {67,45}, {67,47}, {67,48}, {67,49}, {67,59}, {67,60}, {67,61}, {67,76}, {67,77}, {67,78}, {67,106}, {67,107}, {67,108}, {67,133}, {67,134}, {67,136}, {67,137}, {67,138}, {67,140}, {67,141}, {67,142}, {68,-103}, {68,-102}, {68,-101}, {68,-100}, {68,-89}, {68,-88}, {68,-87}, {68,-86}, {68,-85}, {68,-84}, {68,-83}, {68,-82}, {68,-38}, {68,-37}, {68,-15}, {68,-14}, {68,-13}, {68,-9}, {68,47}, {68,48}, {68,49}, {68,59}, {68,60}, {68,61}, {68,76}, {68,77}, {68,78}, {68,106}, {68,107}, {68,108}, {68,116}, {68,117}, {68,133}, {68,134}, {68,136}, {68,137}, {68,138}, {68,140}, {68,141}, {68,142}, {69,-103}, {69,-102}, {69,-101}, {69,-100}, {69,-99}, {69,-89}, {69,-88}, {69,-87}, {69,-86}, {69,-85}, {69,-38}, {69,-37}, {69,-15}, {69,-14}, {69,-13}, {69,-10}, {69,-9}, {69,47}, {69,48}, {69,49}, {69,76}, {69,77}, {69,78}, {69,116}, {69,117}, {69,133}, {69,134}, {70,-103}, {70,-102}, {70,-101}, {70,-100}, {70,-99}, {70,-89}, {70,-88}, {70,-37}, {70,-15}, {70,-14}, {70,-13}, {70,-10}, {70,-9}, {70,-8}, {70,-5}, {70,-4}, {70,-3}, {70,12}, {70,13}, {70,14}, {70,16}, {70,17}, {70,18}, {70,31}, {70,32}, {70,33}, {70,34}, {70,35}, {70,59}, {70,60}, {70,61}, {70,76}, {70,77}, {70,78}, {70,105}, {70,106}, {70,107}, {70,108}, {70,110}, {70,111}, {70,112}, {70,113}, {70,114}, {70,115}, {70,116}, {70,117}, {70,133}, {70,134}, {70,135}, {70,136}, {70,137}, {70,138}, {70,139}, {70,140}, {70,141}, {70,142}, {71,-103}, {71,-102}, {71,-101}, {71,-100}, {71,-99}, {71,-39}, {71,-38}, {71,-37}, {71,-15}, {71,-14}, {71,-13}, {71,-10}, {71,-9}, {71,-8}, {71,-7}, {71,-6}, {71,-5}, {71,-4}, {71,-3}, {71,12}, {71,13}, {71,14}, {71,16}, {71,17}, {71,18}, {71,31}, {71,32}, {71,33}, {71,34}, {71,35}, {71,47}, {71,48}, {71,49}, {71,59}, {71,60}, {71,61}, {71,76}, {71,77}, {71,78}, {71,106}, {71,107}, {71,108}, {71,109}, {71,110}, {71,111}, {71,112}, {71,113}, {71,114}, {71,115}, {71,116}, {71,117}, {71,133}, {71,134}, {71,135}, {71,136}, {71,137}, {71,138}, {71,139}, {71,140}, {71,141}, {71,142}, {72,-103}, {72,-102}, {72,-101}, {72,-100}, {72,-99}, {72,-98}, {72,-57}, {72,-56}, {72,-55}, {72,-54}, {72,-53}, {72,-52}, {72,-38}, {72,-37}, {72,-15}, {72,-14}, {72,-13}, {72,-10}, {72,-9}, {72,-8}, {72,-7}, {72,-6}, {72,-5}, {72,-4}, {72,-3}, {72,12}, {72,13}, {72,14}, {72,16}, {72,17}, {72,18}, {72,31}, {72,32}, {72,33}, {72,34}, {72,35}, {72,47}, {72,48}, {72,49}, {72,59}, {72,60}, {72,61}, {72,76}, {72,77}, {72,78}, {72,106}, {72,107}, {72,108}, {72,110}, {72,111}, {72,112}, {72,113}, {72,114}, {72,115}, {72,116}, {72,117}, {72,133}, {72,134}, {72,135}, {72,136}, {72,137}, {72,138}, {72,139}, {72,140}, {72,141}, {72,142}, {73,-103}, {73,-102}, {73,-101}, {73,-100}, {73,-99}, {73,-98}, {73,-57}, {73,-56}, {73,-55}, {73,-54}, {73,-53}, {73,-52}, {73,-38}, {73,-37}, {73,-15}, {73,-14}, {73,-13}, {73,-10}, {73,-9}, {73,-8}, {73,-5}, {73,-4}, {73,-3}, {73,12}, {73,13}, {73,14}, {73,16}, {73,17}, {73,18}, {73,31}, {73,32}, {73,33}, {73,34}, {73,35}, {73,47}, {73,48}, {73,49}, {73,59}, {73,60}, {73,61}, {73,76}, {73,77}, {73,78}, {73,106}, {73,107}, {73,108}, {73,141}, {74,-100}, {74,-57}, {74,-56}, {74,-55}, {74,-54}, {74,-53}, {74,-52}, {74,-38}, {74,-37}, {74,-15}, {74,-14}, {74,-13}, {74,-10}, {74,-9}, {74,-8}, {74,-5}, {74,-4}, {74,-3}, {74,12}, {74,13}, {74,14}, {74,15}, {74,16}, {74,17}, {74,18}, {74,31}, {74,32}, {74,33}, {74,34}, {74,35}, {74,59}, {74,60}, {74,61}, {74,76}, {74,77}, {74,78}, {74,106}, {74,107}, {74,108}, {74,140}, {74,141}, {74,142}, {75,-101}, {75,-100}, {75,-99}, {75,-98}, {75,-97}, {75,-54}, {75,-15}, {75,-14}, {75,-13}, {75,-10}, {75,-9}, {75,-8}, {75,-5}, {75,-4}, {75,-3}, {75,12}, {75,13}, {75,14}, {75,16}, {75,17}, {75,18}, {75,31}, {75,32}, {75,33}, {75,34}, {75,35}, {75,47}, {75,48}, {75,49}, {75,59}, {75,60}, {75,61}, {75,76}, {75,77}, {75,78}, {75,106}, {75,107}, {75,108}, {75,140}, {75,141}, {75,142}, {76,-101}, {76,-100}, {76,-99}, {76,-98}, {76,-97}, {76,-57}, {76,-56}, {76,-55}, {76,-54}, {76,-15}, {76,-14}, {76,-13}, {76,-10}, {76,-9}, {76,-8}, {76,-5}, {76,-4}, {76,-3}, {76,12}, {76,13}, {76,14}, {76,16}, {76,17}, {76,18}, {76,31}, {76,32}, {76,33}, {76,34}, {76,35}, {76,47}, {76,48}, {76,49}, {76,60}, {76,76}, {76,77}, {76,78}, {76,106}, {76,107}, {76,108}, {76,140}, {76,141}, {76,142}, {77,-101}, {77,-100}, {77,-99}, {77,-98}, {77,-97}, {77,-57}, {77,-56}, {77,-55}, {77,-54}, {77,-37}, {77,-15}, {77,-14}, {77,-13}, {77,-10}, {77,-9}, {77,-8}, {77,-5}, {77,-4}, {77,-3}, {77,12}, {77,13}, {77,14}, {77,16}, {77,17}, {77,18}, {77,31}, {77,32}, {77,33}, {77,34}, {77,35}, {77,47}, {77,48}, {77,49}, {77,59}, {77,60}, {77,61}, {77,76}, {77,77}, {77,78}, {77,106}, {77,107}, {77,108}, {77,140}, {77,141}, {77,142}, {78,-100}, {78,-99}, {78,-98}, {78,-97}, {78,-96}, {78,-95}, {78,-94}, {78,-93}, {78,-57}, {78,-56}, {78,-55}, {78,-54}, {78,-37}, {78,-30}, {78,-22}, {78,-15}, {78,-14}, {78,-13}, {78,-10}, {78,-9}, {78,-8}, {78,-5}, {78,-4}, {78,-3}, {78,12}, {78,13}, {78,14}, {78,16}, {78,17}, {78,18}, {78,31}, {78,32}, {78,33}, {78,34}, {78,35}, {78,47}, {78,48}, {78,49}, {78,58}, {78,59}, {78,60}, {78,61}, {78,76}, {78,77}, {78,78}, {78,81}, {78,82}, {78,83}, {78,84}, {78,85}, {78,87}, {78,88}, {78,89}, {78,101}, {78,102}, {78,103}, {78,106}, {78,107}, {78,108}, {78,120}, {78,121}, {78,122}, {78,123}, {78,124}, {78,125}, {78,126}, {78,127}, {78,128}, {78,129}, {78,130}, {78,140}, {78,141}, {78,142}, {79,-100}, {79,-99}, {79,-98}, {79,-97}, {79,-57}, {79,-56}, {79,-55}, {79,-54}, {79,-37}, {79,-34}, {79,-33}, {79,-32}, {79,-31}, {79,-30}, {79,-29}, {79,-28}, {79,-27}, {79,-25}, {79,-24}, {79,-23}, {79,-22}, {79,-21}, {79,-20}, {79,-19}, {79,-18}, {79,-14}, {79,-4}, {79,14}, {79,16}, {79,32}, {79,47}, {79,48}, {79,49}, {79,59}, {79,60}, {79,61}, {79,76}, {79,77}, {79,78}, {79,79}, {79,80}, {79,81}, {79,82}, {79,83}, {79,84}, {79,85}, {79,86}, {79,87}, {79,88}, {79,89}, {79,101}, {79,102}, {79,103}, {79,106}, {79,107}, {79,108}, {79,120}, {79,121}, {79,122}, {79,123}, {79,124}, {79,125}, {79,126}, {79,127}, {79,128}, {79,129}, {79,130}, {79,140}, {79,141}, {79,142}, {80,-57}, {80,-34}, {80,-33}, {80,-32}, {80,-31}, {80,-30}, {80,-29}, {80,-28}, {80,-27}, {80,-25}, {80,-24}, {80,-23}, {80,-22}, {80,-21}, {80,-20}, {80,-19}, {80,-18}, {80,-15}, {80,-14}, {80,-13}, {80,-10}, {80,-9}, {80,-8}, {80,-7}, {80,-6}, {80,-5}, {80,-4}, {80,-3}, {80,-2}, {80,-1}, {80,0}, {80,2}, {80,3}, {80,4}, {80,5}, {80,6}, {80,7}, {80,8}, {80,10}, {80,11}, {80,12}, {80,13}, {80,14}, {80,16}, {80,17}, {80,18}, {80,19}, {80,20}, {80,21}, {80,23}, {80,24}, {80,25}, {80,26}, {80,27}, {80,28}, {80,29}, {80,31}, {80,32}, {80,33}, {80,34}, {80,35}, {80,36}, {80,37}, {80,38}, {80,40}, {80,41}, {80,42}, {80,43}, {80,44}, {80,45}, {80,47}, {80,48}, {80,49}, {80,59}, {80,60}, {80,61}, {80,76}, {80,77}, {80,78}, {80,81}, {80,82}, {80,83}, {80,84}, {80,85}, {80,87}, {80,88}, {80,89}, {80,101}, {80,102}, {80,103}, {80,106}, {80,107}, {80,108}, {80,120}, {80,121}, {80,122}, {80,123}, {80,124}, {80,125}, {80,126}, {80,127}, {80,128}, {80,129}, {80,130}, {80,140}, {80,141}, {80,142}, {81,-57}, {81,-56}, {81,-34}, {81,-33}, {81,-32}, {81,-31}, {81,-30}, {81,-29}, {81,-28}, {81,-27}, {81,-25}, {81,-24}, {81,-23}, {81,-22}, {81,-21}, {81,-20}, {81,-19}, {81,-18}, {81,-15}, {81,-14}, {81,-13}, {81,-10}, {81,-9}, {81,-8}, {81,-7}, {81,-6}, {81,-5}, {81,-4}, {81,-3}, {81,-2}, {81,-1}, {81,0}, {81,2}, {81,3}, {81,4}, {81,5}, {81,6}, {81,7}, {81,8}, {81,10}, {81,11}, {81,12}, {81,13}, {81,14}, {81,16}, {81,17}, {81,18}, {81,19}, {81,20}, {81,21}, {81,23}, {81,24}, {81,25}, {81,26}, {81,27}, {81,28}, {81,29}, {81,31}, {81,32}, {81,33}, {81,34}, {81,35}, {81,36}, {81,37}, {81,38}, {81,40}, {81,41}, {81,42}, {81,43}, {81,44}, {81,45}, {81,47}, {81,48}, {81,49}, {81,60}, {81,87}, {81,106}, {81,107}, {81,108}, {81,121}, {81,130}, {81,141}, {82,-57}, {82,-56}, {82,59}, {82,60}, {82,61}, {82,63}, {82,64}, {82,65}, {82,66}, {82,67}, {82,68}, {82,69}, {82,70}, {82,71}, {82,72}, {82,73}, {82,75}, {82,76}, {82,77}, {82,78}, {82,79}, {82,80}, {82,81}, {82,82}, {82,83}, {82,84}, {82,85}, {82,86}, {82,87}, {82,89}, {82,90}, {82,91}, {82,92}, {82,93}, {82,94}, {82,95}, {82,97}, {82,98}, {82,99}, {82,100}, {82,101}, {82,102}, {82,103}, {82,106}, {82,107}, {82,108}, {82,110}, {82,111}, {82,112}, {82,113}, {82,114}, {82,116}, {82,117}, {82,118}, {82,120}, {82,121}, {82,122}, {82,123}, {82,124}, {82,125}, {82,127}, {82,128}, {82,129}, {82,130}, {82,132}, {82,133}, {82,134}, {82,136}, {82,137}, {82,138}, {82,140}, {82,141}, {82,142}, {83,59}, {83,60}, {83,61}, {83,62}, {83,63}, {83,64}, {83,65}, {83,66}, {83,67}, {83,68}, {83,69}, {83,70}, {83,71}, {83,72}, {83,73}, {83,74}, {83,75}, {83,76}, {83,77}, {83,78}, {83,79}, {83,80}, {83,81}, {83,82}, {83,83}, {83,84}, {83,85}, {83,86}, {83,87}, {83,89}, {83,90}, {83,91}, {83,92}, {83,93}, {83,94}, {83,95}, {83,96}, {83,97}, {83,98}, {83,99}, {83,100}, {83,101}, {83,102}, {83,103}, {83,104}, {83,105}, {83,106}, {83,107}, {83,108}, {83,110}, {83,111}, {83,112}, {83,113}, {83,114}, {83,115}, {83,116}, {83,117}, {83,118}, {83,120}, {83,121}, {83,122}, {83,123}, {83,124}, {83,125}, {83,127}, {83,128}, {83,129}, {83,130}, {83,131}, {83,132}, {83,133}, {83,134}, {83,136}, {83,137}, {83,138}, {83,140}, {83,141}, {83,142}, {84,59}, {84,60}, {84,61}, {84,63}, {84,64}, {84,65}, {84,66}, {84,67}, {84,68}, {84,69}, {84,70}, {84,71}, {84,72}, {84,73}, {84,75}, {84,76}, {84,77}, {84,78}, {84,79}, {84,80}, {84,81}, {84,82}, {84,83}, {84,84}, {84,85}, {84,86}, {84,87}, {84,89}, {84,90}, {84,91}, {84,92}, {84,93}, {84,94}, {84,95}, {84,97}, {84,98}, {84,99}, {84,100}, {84,101}, {84,102}, {84,103}, {84,106}, {84,107}, {84,108}, {84,110}, {84,111}, {84,112}, {84,113}, {84,114}, {84,116}, {84,117}, {84,118}, {84,120}, {84,121}, {84,122}, {84,123}, {84,124}, {84,125}, {84,127}, {84,128}, {84,129}, {84,130}, {84,132}, {84,133}, {84,134}, {84,136}, {84,137}, {84,138}, {84,140}, {84,141}, {84,142}, },
    ["vegetation-green-grass-2"] = {{-85,104}, {-84,92}, {-81,60}, {-79,72}, {-79,75}, {-79,76}, {-79,77}, {-79,78}, {-79,79}, {-79,80}, {-79,81}, {-79,82}, {-79,83}, {-79,84}, {-79,85}, {-79,86}, {-79,87}, {-79,88}, {-79,89}, {-79,90}, {-79,91}, {-78,-113}, {-78,74}, {-78,75}, {-78,78}, {-78,83}, {-78,84}, {-78,85}, {-78,86}, {-78,87}, {-78,88}, {-78,89}, {-78,90}, {-78,91}, {-77,-112}, {-77,-111}, {-77,-103}, {-77,-102}, {-77,72}, {-77,73}, {-77,88}, {-77,91}, {-76,-110}, {-76,-109}, {-76,-108}, {-76,-103}, {-76,-93}, {-76,72}, {-76,73}, {-76,88}, {-76,118}, {-75,-107}, {-75,72}, {-75,73}, {-75,76}, {-75,118}, {-74,-106}, {-74,-99}, {-74,72}, {-74,87}, {-74,118}, {-73,72}, {-73,91}, {-73,118}, {-73,119}, {-72,72}, {-72,91}, {-72,118}, {-72,119}, {-71,-91}, {-71,72}, {-71,91}, {-71,118}, {-71,119}, {-70,-98}, {-70,-91}, {-70,72}, {-70,91}, {-70,118}, {-70,119}, {-69,-109}, {-69,-108}, {-69,72}, {-69,73}, {-69,88}, {-69,89}, {-69,90}, {-69,118}, {-69,119}, {-68,-98}, {-68,-97}, {-68,-96}, {-68,72}, {-68,87}, {-68,88}, {-68,89}, {-68,118}, {-68,119}, {-67,-96}, {-67,-95}, {-67,72}, {-67,73}, {-67,74}, {-67,75}, {-67,85}, {-67,86}, {-67,87}, {-67,88}, {-67,118}, {-67,119}, {-66,-113}, {-66,-112}, {-66,72}, {-66,73}, {-66,74}, {-66,75}, {-66,82}, {-66,83}, {-66,84}, {-66,85}, {-66,86}, {-66,118}, {-66,119}, {-66,120}, {-66,122}, {-65,-111}, {-65,-110}, {-65,-101}, {-65,72}, {-65,73}, {-65,74}, {-65,75}, {-65,76}, {-65,77}, {-65,78}, {-65,79}, {-65,80}, {-65,81}, {-65,82}, {-64,-109}, {-64,-108}, {-64,-101}, {-64,-100}, {-62,-105}, {-62,-104}, {-61,-105}, {-61,-104}, {-61,43}, {-61,44}, {-61,45}, {-61,46}, {-61,47}, {-61,48}, {-61,49}, {-61,50}, {-61,51}, {-61,52}, {-61,53}, {-60,-95}, {-60,-94}, {-60,43}, {-60,44}, {-60,45}, {-60,46}, {-60,47}, {-60,48}, {-60,49}, {-60,50}, {-60,51}, {-60,52}, {-59,44}, {-59,45}, {-59,46}, {-59,47}, {-59,48}, {-59,49}, {-59,50}, {-59,51}, {-59,74}, {-58,-98}, {-58,45}, {-58,46}, {-58,47}, {-58,48}, {-58,49}, {-58,50}, {-58,74}, {-57,-108}, {-57,-107}, {-57,-98}, {-57,-97}, {-57,72}, {-57,73}, {-57,74}, {-57,75}, {-57,76}, {-56,-107}, {-56,-106}, {-56,-97}, {-56,-96}, {-56,73}, {-56,74}, {-56,75}, {-55,-105}, {-55,-104}, {-55,-95}, {-55,-94}, {-55,-93}, {-55,74}, {-55,75}, {-54,-104}, {-54,-94}, {-54,-93}, {-53,-104}, {-53,-103}, {-52,-111}, {-52,-110}, {-52,-103}, {-52,-102}, {-51,-110}, {-51,-109}, {-51,-108}, {-51,-101}, {-51,-100}, {-50,-100}, {-50,-99}, {-50,-98}, {-50,-96}, {-50,-95}, {-49,-106}, {-49,-98}, {-49,-97}, {-49,-96}, {-49,-95}, {-48,-106}, {-48,-105}, {-48,-104}, {-48,-95}, {-48,-94}, {-48,-93}, {-48,-92}, {-47,-104}, {-47,-103}, {-47,-95}, {-47,-94}, {-47,-93}, {-47,-92}, {-47,-91}, {-46,-103}, {-46,-91}, {-44,-100}, {-44,-99}, {-44,-98}, {-44,-97}, {-43,-106}, {-43,-105}, {-43,-99}, {-43,-98}, {-43,-97}, {-43,-96}, {-42,-106}, {-42,-105}, {-42,-104}, {-42,-96}, {-42,-95}, {-41,-103}, {-41,-102}, {-41,-95}, {-41,-94}, {-41,-93}, {-40,-102}, {-40,-101}, {-38,-107}, {-38,-106}, {-38,-99}, {-38,-98}, {-37,-106}, {-37,-99}, {-37,-98}, {-37,-97}, {-37,-95}, {-37,-75}, {-37,-74}, {-36,-102}, {-36,-96}, {-36,-95}, {-36,-94}, {-36,-93}, {-36,-77}, {-36,-76}, {-36,-75}, {-36,-74}, {-35,-102}, {-35,-101}, {-35,-100}, {-35,-95}, {-35,-94}, {-35,-93}, {-35,-92}, {-35,-77}, {-35,-76}, {-35,-75}, {-35,-74}, {-35,47}, {-34,-100}, {-34,-99}, {-34,-93}, {-34,47}, {-34,48}, {-34,73}, {-33,-99}, {-33,47}, {-33,48}, {-33,49}, {-33,73}, {-32,-107}, {-32,-106}, {-32,-105}, {-32,-98}, {-32,-97}, {-32,-76}, {-32,-75}, {-32,47}, {-32,48}, {-32,49}, {-32,50}, {-31,-105}, {-31,-104}, {-31,-103}, {-31,-97}, {-31,-96}, {-31,-79}, {-31,-78}, {-31,-76}, {-31,-75}, {-31,47}, {-31,48}, {-31,49}, {-31,50}, {-31,51}, {-30,-103}, {-30,-102}, {-30,-101}, {-30,-79}, {-30,-78}, {-30,-76}, {-30,-75}, {-30,74}, {-30,75}, {-29,-101}, {-29,-76}, {-29,-75}, {-29,74}, {-29,75}, {-28,-98}, {-28,74}, {-28,75}, {-28,105}, {-28,106}, {-28,107}, {-28,108}, {-28,109}, {-28,110}, {-27,-98}, {-27,-97}, {-27,-96}, {-27,74}, {-27,75}, {-27,99}, {-27,105}, {-27,106}, {-27,107}, {-27,108}, {-27,109}, {-27,110}, {-26,-107}, {-26,-106}, {-26,-105}, {-26,-96}, {-26,-95}, {-26,-79}, {-26,-78}, {-26,-77}, {-26,-76}, {-26,-75}, {-26,-74}, {-26,74}, {-26,75}, {-26,91}, {-26,92}, {-26,99}, {-26,104}, {-26,105}, {-26,106}, {-26,107}, {-26,108}, {-26,109}, {-26,110}, {-26,111}, {-26,112}, {-26,113}, {-26,114}, {-25,-104}, {-25,-103}, {-25,-79}, {-25,-78}, {-25,-77}, {-25,-76}, {-25,-75}, {-25,-74}, {-25,74}, {-25,75}, {-25,76}, {-25,77}, {-25,86}, {-25,91}, {-25,92}, {-25,94}, {-25,95}, {-25,96}, {-25,97}, {-25,99}, {-25,100}, {-25,101}, {-25,102}, {-25,103}, {-25,104}, {-25,105}, {-25,106}, {-25,107}, {-25,109}, {-25,110}, {-25,111}, {-25,112}, {-25,113}, {-25,114}, {-24,-103}, {-24,-102}, {-24,-101}, {-24,75}, {-24,76}, {-24,77}, {-24,86}, {-24,91}, {-24,92}, {-24,93}, {-24,94}, {-24,95}, {-24,96}, {-24,97}, {-24,98}, {-24,99}, {-24,100}, {-24,101}, {-24,102}, {-24,103}, {-24,104}, {-24,105}, {-24,106}, {-24,107}, {-24,108}, {-24,109}, {-24,110}, {-24,111}, {-24,112}, {-24,113}, {-24,114}, {-23,-101}, {-23,-100}, {-23,-99}, {-23,75}, {-23,76}, {-23,77}, {-23,86}, {-23,87}, {-23,88}, {-23,89}, {-23,90}, {-23,91}, {-23,92}, {-23,93}, {-23,94}, {-23,95}, {-23,96}, {-23,97}, {-23,98}, {-23,99}, {-23,100}, {-23,101}, {-23,102}, {-23,103}, {-23,104}, {-23,105}, {-23,106}, {-23,107}, {-23,108}, {-23,109}, {-23,110}, {-23,111}, {-23,112}, {-23,113}, {-23,114}, {-22,-99}, {-22,-98}, {-22,-97}, {-22,-80}, {-21,-97}, {-21,-82}, {-21,-81}, {-21,-80}, {-21,-79}, {-21,-78}, {-21,-77}, {-21,-76}, {-21,-75}, {-21,-74}, {-20,-106}, {-20,-105}, {-20,-104}, {-20,-81}, {-20,-80}, {-20,-77}, {-20,-76}, {-20,-75}, {-20,-74}, {-20,35}, {-20,75}, {-20,76}, {-20,77}, {-20,78}, {-20,79}, {-20,80}, {-20,89}, {-20,90}, {-20,91}, {-20,92}, {-20,93}, {-20,94}, {-20,95}, {-20,96}, {-20,97}, {-20,98}, {-20,99}, {-20,100}, {-20,101}, {-20,102}, {-20,103}, {-20,104}, {-20,105}, {-20,106}, {-20,107}, {-20,108}, {-20,109}, {-20,110}, {-20,111}, {-20,112}, {-20,113}, {-20,114}, {-20,115}, {-20,116}, {-20,117}, {-19,-104}, {-19,-103}, {-19,35}, {-19,75}, {-19,76}, {-19,77}, {-19,78}, {-19,79}, {-19,80}, {-19,85}, {-19,86}, {-19,87}, {-19,88}, {-19,89}, {-19,90}, {-19,91}, {-19,92}, {-19,93}, {-19,94}, {-19,95}, {-19,96}, {-19,102}, {-19,103}, {-19,104}, {-19,105}, {-19,106}, {-19,107}, {-19,108}, {-19,109}, {-19,110}, {-19,111}, {-19,112}, {-19,113}, {-19,114}, {-19,115}, {-19,116}, {-19,117}, {-18,-102}, {-18,-101}, {-18,35}, {-18,75}, {-18,80}, {-18,86}, {-18,87}, {-18,88}, {-18,89}, {-18,90}, {-18,91}, {-18,93}, {-18,104}, {-18,105}, {-18,106}, {-18,107}, {-18,108}, {-18,109}, {-18,112}, {-18,113}, {-18,114}, {-18,115}, {-18,116}, {-18,117}, {-17,-101}, {-17,-100}, {-17,35}, {-17,75}, {-17,80}, {-17,85}, {-17,86}, {-17,87}, {-17,88}, {-17,104}, {-17,105}, {-17,106}, {-17,107}, {-17,108}, {-17,109}, {-17,110}, {-17,111}, {-17,112}, {-17,113}, {-17,114}, {-17,115}, {-17,116}, {-17,117}, {-16,-100}, {-16,-99}, {-16,-80}, {-16,-79}, {-16,-78}, {-16,-77}, {-16,-76}, {-16,-75}, {-16,-74}, {-16,75}, {-16,80}, {-16,85}, {-16,86}, {-16,89}, {-16,106}, {-16,107}, {-16,108}, {-16,109}, {-16,110}, {-16,112}, {-16,113}, {-16,114}, {-16,115}, {-16,116}, {-15,-97}, {-15,-96}, {-15,-95}, {-15,-80}, {-15,-79}, {-15,-78}, {-15,-77}, {-15,-76}, {-15,-75}, {-15,-74}, {-15,75}, {-15,80}, {-15,84}, {-15,107}, {-15,108}, {-15,109}, {-15,110}, {-15,114}, {-15,115}, {-15,116}, {-14,-97}, {-14,-96}, {-14,-95}, {-14,75}, {-14,80}, {-14,83}, {-14,84}, {-14,86}, {-14,104}, {-14,107}, {-14,108}, {-14,109}, {-14,115}, {-13,-103}, {-13,-102}, {-13,75}, {-13,80}, {-13,83}, {-13,84}, {-13,85}, {-13,86}, {-13,97}, {-13,107}, {-13,108}, {-13,109}, {-13,110}, {-12,-102}, {-12,-101}, {-12,75}, {-12,76}, {-12,79}, {-12,80}, {-12,83}, {-12,84}, {-12,85}, {-12,86}, {-12,106}, {-12,108}, {-12,109}, {-11,-83}, {-11,-82}, {-11,-81}, {-11,-80}, {-11,-79}, {-11,-78}, {-11,-77}, {-11,-75}, {-11,-74}, {-11,75}, {-11,76}, {-11,79}, {-11,80}, {-11,83}, {-11,84}, {-11,85}, {-11,86}, {-11,103}, {-11,109}, {-11,148}, {-10,-83}, {-10,-82}, {-10,-81}, {-10,-80}, {-10,-79}, {-10,-78}, {-10,-77}, {-10,-75}, {-10,-74}, {-10,75}, {-10,76}, {-10,77}, {-10,78}, {-10,79}, {-10,80}, {-10,83}, {-10,84}, {-10,85}, {-10,109}, {-10,115}, {-10,148}, {-9,75}, {-9,76}, {-9,77}, {-9,78}, {-9,79}, {-9,80}, {-9,83}, {-9,84}, {-9,85}, {-9,86}, {-9,115}, {-8,77}, {-8,78}, {-8,79}, {-8,80}, {-8,83}, {-8,84}, {-8,85}, {-8,101}, {-8,102}, {-8,105}, {-8,109}, {-7,78}, {-7,79}, {-7,80}, {-7,83}, {-7,84}, {-7,85}, {-7,102}, {-7,103}, {-7,104}, {-7,105}, {-7,106}, {-7,107}, {-7,109}, {-7,110}, {-6,-80}, {-6,-79}, {-6,-77}, {-6,-76}, {-6,-75}, {-6,-74}, {-6,79}, {-6,80}, {-6,83}, {-6,84}, {-6,85}, {-6,86}, {-6,91}, {-6,92}, {-6,93}, {-6,94}, {-6,103}, {-6,104}, {-6,105}, {-6,106}, {-6,107}, {-6,108}, {-5,-83}, {-5,-80}, {-5,-79}, {-5,-77}, {-5,-76}, {-5,-75}, {-5,-74}, {-5,80}, {-5,83}, {-5,84}, {-5,85}, {-5,86}, {-5,88}, {-5,89}, {-5,91}, {-5,92}, {-4,80}, {-4,83}, {-4,84}, {-4,85}, {-4,87}, {-3,82}, {-3,83}, {-3,88}, {-3,89}, {-2,-75}, {-2,-74}, {-2,81}, {-2,82}, {-2,83}, {-2,87}, {-2,88}, {-2,89}, {-1,-83}, {-1,-82}, {-1,-79}, {-1,-78}, {-1,-77}, {-1,-76}, {-1,-75}, {-1,-74}, {-1,78}, {-1,79}, {-1,80}, {-1,81}, {-1,82}, {-1,83}, {-1,84}, {-1,85}, {0,-83}, {0,-82}, {0,-79}, {0,-78}, {0,-77}, {0,-76}, {0,35}, {0,79}, {0,80}, {0,81}, {0,82}, {0,83}, {0,84}, {0,85}, {1,79}, {1,80}, {1,81}, {1,82}, {1,83}, {1,84}, {2,83}, {2,84}, {2,85}, {3,-85}, {3,-84}, {4,-85}, {4,-84}, {4,-83}, {4,-82}, {4,-80}, {4,-79}, {4,-78}, {4,-75}, {4,-74}, {4,34}, {5,-83}, {5,-82}, {5,-80}, {5,-79}, {5,-78}, {5,-75}, {5,-74}, {5,34}, {5,35}, {6,34}, {6,35}, {7,30}, {8,30}, {9,-80}, {9,-79}, {9,-75}, {9,-74}, {9,-19}, {9,-18}, {9,-17}, {9,-16}, {9,13}, {9,14}, {9,15}, {9,16}, {9,17}, {9,18}, {9,22}, {9,23}, {9,24}, {9,26}, {9,29}, {9,30}, {9,31}, {9,140}, {9,141}, {9,142}, {10,-80}, {10,-79}, {10,-76}, {10,-75}, {10,-74}, {10,140}, {11,-76}, {11,-75}, {11,-74}, {11,140}, {12,-77}, {12,-76}, {12,-75}, {12,-74}, {12,140}, {13,-78}, {13,-77}, {13,-76}, {13,-75}, {13,-74}, {13,140}, {17,-82}, {17,-81}, {18,-83}, {18,-82}, {18,-81}, {19,-84}, {19,-83}, {19,-82}, {25,-24}, {25,-23}, {26,-27}, {26,-24}, {26,-23}, {29,52}, {29,53}, {30,52}, {59,120}, {59,121}, {60,120}, {60,127}, {60,128}, {63,120}, {68,120}, {68,130}, {69,129}, {69,130}, },
    ["refined-concrete"] = {{-83,25}, {-83,47}, {-83,48}, {-83,49}, {-83,54}, {-83,55}, {-83,57}, {-83,58}, {-83,100}, {-82,54}, {-82,55}, {-82,57}, {-82,58}, {-82,97}, {-82,98}, {-82,99}, {-82,100}, {-82,101}, {-82,104}, {-82,105}, {-82,106}, {-82,107}, {-82,108}, {-82,109}, {-82,110}, {-82,111}, {-82,112}, {-81,54}, {-81,55}, {-81,57}, {-81,58}, {-81,97}, {-81,98}, {-81,99}, {-81,100}, {-81,101}, {-81,104}, {-81,105}, {-81,106}, {-81,107}, {-81,108}, {-81,109}, {-81,110}, {-81,111}, {-81,112}, {-80,97}, {-80,98}, {-80,99}, {-80,100}, {-80,101}, {-80,104}, {-80,105}, {-80,106}, {-80,107}, {-80,108}, {-80,109}, {-80,110}, {-80,111}, {-80,112}, {-79,39}, {-79,40}, {-79,97}, {-79,98}, {-79,99}, {-79,100}, {-79,101}, {-79,104}, {-79,105}, {-79,106}, {-79,107}, {-79,108}, {-79,109}, {-79,110}, {-79,111}, {-79,112}, {-78,39}, {-78,40}, {-78,97}, {-78,98}, {-78,99}, {-78,100}, {-78,101}, {-78,104}, {-78,105}, {-78,106}, {-78,107}, {-78,108}, {-78,109}, {-78,110}, {-78,111}, {-78,112}, {-77,25}, {-77,39}, {-77,40}, {-77,97}, {-77,98}, {-77,99}, {-77,100}, {-77,101}, {-77,104}, {-77,108}, {-77,109}, {-77,110}, {-77,111}, {-77,112}, {-77,113}, {-76,39}, {-76,40}, {-76,51}, {-76,52}, {-76,55}, {-76,63}, {-76,97}, {-76,98}, {-76,99}, {-76,100}, {-76,101}, {-76,102}, {-76,103}, {-76,104}, {-76,105}, {-76,107}, {-76,108}, {-76,109}, {-76,110}, {-76,111}, {-76,112}, {-75,39}, {-75,40}, {-75,51}, {-75,52}, {-75,53}, {-75,54}, {-75,55}, {-75,56}, {-75,57}, {-75,58}, {-75,59}, {-75,62}, {-75,63}, {-75,64}, {-75,65}, {-75,66}, {-75,97}, {-75,98}, {-75,99}, {-75,100}, {-75,101}, {-75,104}, {-75,108}, {-75,109}, {-75,110}, {-75,111}, {-75,112}, {-74,-22}, {-74,-16}, {-74,39}, {-74,40}, {-74,51}, {-74,52}, {-74,53}, {-74,54}, {-74,55}, {-74,56}, {-74,57}, {-74,58}, {-74,59}, {-74,62}, {-74,64}, {-74,66}, {-74,97}, {-74,98}, {-74,99}, {-74,100}, {-74,101}, {-74,104}, {-74,105}, {-74,106}, {-74,107}, {-74,108}, {-74,109}, {-74,110}, {-74,111}, {-74,112}, {-73,5}, {-73,6}, {-73,7}, {-73,38}, {-73,39}, {-73,40}, {-73,51}, {-73,52}, {-73,53}, {-73,54}, {-73,55}, {-73,56}, {-73,57}, {-73,58}, {-73,59}, {-73,62}, {-73,63}, {-73,64}, {-73,65}, {-73,66}, {-73,97}, {-73,98}, {-73,99}, {-73,100}, {-73,101}, {-73,104}, {-73,105}, {-73,106}, {-73,107}, {-73,108}, {-73,109}, {-72,-11}, {-72,-10}, {-72,-9}, {-72,-8}, {-72,-7}, {-72,-6}, {-72,-5}, {-72,-4}, {-72,-3}, {-72,-2}, {-72,-1}, {-72,0}, {-72,1}, {-72,2}, {-72,3}, {-72,4}, {-72,5}, {-72,6}, {-72,7}, {-72,8}, {-72,9}, {-72,10}, {-72,11}, {-72,12}, {-72,13}, {-72,14}, {-72,15}, {-72,16}, {-72,17}, {-72,18}, {-72,19}, {-72,20}, {-72,21}, {-72,22}, {-72,23}, {-72,38}, {-72,39}, {-72,40}, {-72,51}, {-72,52}, {-72,53}, {-72,54}, {-72,55}, {-72,56}, {-72,57}, {-72,58}, {-72,59}, {-72,62}, {-72,63}, {-72,64}, {-72,65}, {-72,66}, {-72,97}, {-72,98}, {-72,99}, {-72,100}, {-72,101}, {-72,109}, {-71,-70}, {-71,-69}, {-71,-11}, {-71,-10}, {-71,-9}, {-71,-8}, {-71,-7}, {-71,-6}, {-71,-5}, {-71,-4}, {-71,-3}, {-71,-2}, {-71,-1}, {-71,0}, {-71,1}, {-71,2}, {-71,3}, {-71,4}, {-71,5}, {-71,6}, {-71,7}, {-71,8}, {-71,9}, {-71,10}, {-71,11}, {-71,12}, {-71,13}, {-71,14}, {-71,15}, {-71,16}, {-71,17}, {-71,18}, {-71,19}, {-71,20}, {-71,21}, {-71,22}, {-71,23}, {-71,38}, {-71,39}, {-71,40}, {-71,51}, {-71,52}, {-71,53}, {-71,54}, {-71,55}, {-71,56}, {-71,57}, {-71,58}, {-71,59}, {-71,60}, {-71,61}, {-71,62}, {-71,63}, {-71,64}, {-71,65}, {-71,66}, {-71,97}, {-71,98}, {-71,99}, {-71,100}, {-71,101}, {-71,107}, {-71,108}, {-71,109}, {-71,110}, {-71,111}, {-71,112}, {-70,-11}, {-70,-10}, {-70,-9}, {-70,-8}, {-70,-7}, {-70,-6}, {-70,-5}, {-70,-4}, {-70,-3}, {-70,-2}, {-70,-1}, {-70,0}, {-70,1}, {-70,2}, {-70,3}, {-70,4}, {-70,5}, {-70,6}, {-70,7}, {-70,8}, {-70,9}, {-70,10}, {-70,11}, {-70,12}, {-70,13}, {-70,14}, {-70,15}, {-70,16}, {-70,17}, {-70,18}, {-70,19}, {-70,20}, {-70,21}, {-70,22}, {-70,23}, {-70,38}, {-70,39}, {-70,40}, {-70,51}, {-70,52}, {-70,53}, {-70,54}, {-70,55}, {-70,56}, {-70,57}, {-70,58}, {-70,59}, {-70,62}, {-70,63}, {-70,64}, {-70,65}, {-70,66}, {-70,97}, {-70,98}, {-70,99}, {-70,100}, {-70,101}, {-70,107}, {-70,108}, {-70,109}, {-70,110}, {-70,111}, {-70,112}, {-69,-11}, {-69,-10}, {-69,-9}, {-69,-8}, {-69,-7}, {-69,-6}, {-69,-5}, {-69,-4}, {-69,-3}, {-69,-2}, {-69,-1}, {-69,0}, {-69,1}, {-69,2}, {-69,3}, {-69,4}, {-69,5}, {-69,6}, {-69,7}, {-69,8}, {-69,9}, {-69,10}, {-69,11}, {-69,12}, {-69,13}, {-69,14}, {-69,15}, {-69,16}, {-69,17}, {-69,18}, {-69,19}, {-69,20}, {-69,21}, {-69,22}, {-69,23}, {-69,38}, {-69,39}, {-69,40}, {-69,51}, {-69,52}, {-69,53}, {-69,54}, {-69,55}, {-69,56}, {-69,57}, {-69,58}, {-69,59}, {-69,62}, {-69,63}, {-69,64}, {-69,65}, {-69,66}, {-69,100}, {-69,107}, {-69,108}, {-69,109}, {-69,110}, {-69,111}, {-69,112}, {-68,-11}, {-68,-10}, {-68,-9}, {-68,-8}, {-68,-7}, {-68,-6}, {-68,-5}, {-68,-4}, {-68,-3}, {-68,-2}, {-68,-1}, {-68,0}, {-68,1}, {-68,2}, {-68,3}, {-68,4}, {-68,5}, {-68,6}, {-68,7}, {-68,8}, {-68,9}, {-68,10}, {-68,11}, {-68,12}, {-68,13}, {-68,14}, {-68,15}, {-68,16}, {-68,17}, {-68,18}, {-68,19}, {-68,20}, {-68,21}, {-68,22}, {-68,23}, {-68,38}, {-68,39}, {-68,40}, {-68,51}, {-68,52}, {-68,53}, {-68,54}, {-68,55}, {-68,56}, {-68,57}, {-68,58}, {-68,59}, {-68,62}, {-68,63}, {-68,64}, {-68,65}, {-68,66}, {-68,107}, {-68,108}, {-68,109}, {-68,110}, {-68,111}, {-68,112}, {-67,-75}, {-67,-72}, {-67,-67}, {-67,-64}, {-67,-11}, {-67,-10}, {-67,-9}, {-67,-8}, {-67,-7}, {-67,-6}, {-67,-5}, {-67,-4}, {-67,-3}, {-67,-2}, {-67,-1}, {-67,0}, {-67,1}, {-67,2}, {-67,3}, {-67,4}, {-67,5}, {-67,6}, {-67,7}, {-67,8}, {-67,9}, {-67,10}, {-67,11}, {-67,12}, {-67,13}, {-67,14}, {-67,15}, {-67,16}, {-67,17}, {-67,18}, {-67,19}, {-67,20}, {-67,21}, {-67,22}, {-67,23}, {-67,38}, {-67,39}, {-67,40}, {-67,51}, {-67,52}, {-67,53}, {-67,54}, {-67,55}, {-67,56}, {-67,57}, {-67,58}, {-67,59}, {-67,62}, {-67,63}, {-67,64}, {-67,65}, {-67,66}, {-67,107}, {-67,108}, {-67,109}, {-67,110}, {-67,111}, {-67,112}, {-66,-11}, {-66,-10}, {-66,-9}, {-66,-8}, {-66,-7}, {-66,-6}, {-66,-5}, {-66,-4}, {-66,-3}, {-66,-2}, {-66,-1}, {-66,0}, {-66,1}, {-66,2}, {-66,3}, {-66,4}, {-66,5}, {-66,6}, {-66,7}, {-66,8}, {-66,9}, {-66,10}, {-66,11}, {-66,12}, {-66,13}, {-66,14}, {-66,15}, {-66,16}, {-66,17}, {-66,18}, {-66,19}, {-66,20}, {-66,21}, {-66,22}, {-66,23}, {-66,38}, {-66,39}, {-66,40}, {-66,55}, {-66,63}, {-66,106}, {-66,107}, {-66,108}, {-66,109}, {-66,110}, {-66,111}, {-66,112}, {-65,-11}, {-65,-10}, {-65,-9}, {-65,-8}, {-65,-7}, {-65,-6}, {-65,-5}, {-65,-4}, {-65,-3}, {-65,-2}, {-65,-1}, {-65,0}, {-65,1}, {-65,2}, {-65,3}, {-65,4}, {-65,5}, {-65,6}, {-65,7}, {-65,8}, {-65,9}, {-65,10}, {-65,11}, {-65,12}, {-65,13}, {-65,14}, {-65,15}, {-65,16}, {-65,17}, {-65,18}, {-65,19}, {-65,20}, {-65,21}, {-65,22}, {-65,23}, {-65,38}, {-65,39}, {-65,40}, {-64,-75}, {-64,-64}, {-64,-11}, {-64,-10}, {-64,-9}, {-64,-8}, {-64,-7}, {-64,-6}, {-64,-5}, {-64,-4}, {-64,-3}, {-64,-2}, {-64,-1}, {-64,0}, {-64,1}, {-64,2}, {-64,3}, {-64,4}, {-64,5}, {-64,6}, {-64,7}, {-64,8}, {-64,9}, {-64,10}, {-64,11}, {-64,12}, {-64,13}, {-64,14}, {-64,15}, {-64,16}, {-64,17}, {-64,18}, {-64,19}, {-64,20}, {-64,21}, {-64,22}, {-64,23}, {-64,38}, {-64,39}, {-64,40}, {-64,116}, {-64,135}, {-64,136}, {-63,-11}, {-63,-10}, {-63,-9}, {-63,-8}, {-63,-7}, {-63,-6}, {-63,-5}, {-63,-4}, {-63,-3}, {-63,-2}, {-63,-1}, {-63,0}, {-63,1}, {-63,2}, {-63,3}, {-63,4}, {-63,5}, {-63,6}, {-63,7}, {-63,8}, {-63,9}, {-63,10}, {-63,11}, {-63,12}, {-63,13}, {-63,14}, {-63,15}, {-63,16}, {-63,17}, {-63,18}, {-63,19}, {-63,20}, {-63,21}, {-63,22}, {-63,23}, {-63,38}, {-63,39}, {-63,40}, {-62,-60}, {-62,-11}, {-62,-10}, {-62,-9}, {-62,-8}, {-62,-7}, {-62,-6}, {-62,-5}, {-62,-4}, {-62,-3}, {-62,-2}, {-62,-1}, {-62,0}, {-62,1}, {-62,2}, {-62,3}, {-62,4}, {-62,5}, {-62,6}, {-62,7}, {-62,8}, {-62,9}, {-62,10}, {-62,11}, {-62,12}, {-62,13}, {-62,14}, {-62,15}, {-62,16}, {-62,17}, {-62,18}, {-62,19}, {-62,20}, {-62,21}, {-62,22}, {-62,23}, {-62,38}, {-62,39}, {-62,40}, {-61,-60}, {-61,-12}, {-61,-11}, {-61,-10}, {-61,-9}, {-61,-8}, {-61,-7}, {-61,-6}, {-61,-5}, {-61,-4}, {-61,-3}, {-61,-2}, {-61,-1}, {-61,0}, {-61,1}, {-61,2}, {-61,3}, {-61,4}, {-61,5}, {-61,6}, {-61,7}, {-61,8}, {-61,9}, {-61,10}, {-61,11}, {-61,12}, {-61,13}, {-61,14}, {-61,15}, {-61,16}, {-61,17}, {-61,18}, {-61,19}, {-61,20}, {-61,21}, {-61,22}, {-61,23}, {-61,38}, {-61,39}, {-61,40}, {-61,41}, {-61,81}, {-61,82}, {-60,-12}, {-60,-11}, {-60,-10}, {-60,-9}, {-60,-8}, {-60,-7}, {-60,-6}, {-60,-5}, {-60,-4}, {-60,-3}, {-60,-2}, {-60,-1}, {-60,0}, {-60,1}, {-60,2}, {-60,3}, {-60,4}, {-60,5}, {-60,6}, {-60,7}, {-60,8}, {-60,9}, {-60,10}, {-60,11}, {-60,12}, {-60,13}, {-60,14}, {-60,15}, {-60,16}, {-60,17}, {-60,18}, {-60,19}, {-60,20}, {-60,21}, {-60,22}, {-60,23}, {-60,24}, {-60,38}, {-60,39}, {-60,40}, {-60,41}, {-60,81}, {-60,82}, {-60,120}, {-60,121}, {-60,122}, {-60,123}, {-60,124}, {-60,129}, {-60,130}, {-60,131}, {-60,132}, {-60,133}, {-59,-75}, {-59,-64}, {-59,-12}, {-59,-11}, {-59,-10}, {-59,-9}, {-59,-8}, {-59,-7}, {-59,-6}, {-59,-5}, {-59,-4}, {-59,-3}, {-59,-2}, {-59,-1}, {-59,0}, {-59,1}, {-59,2}, {-59,3}, {-59,4}, {-59,5}, {-59,6}, {-59,7}, {-59,8}, {-59,9}, {-59,10}, {-59,11}, {-59,12}, {-59,13}, {-59,14}, {-59,15}, {-59,16}, {-59,17}, {-59,18}, {-59,19}, {-59,20}, {-59,21}, {-59,22}, {-59,23}, {-59,38}, {-59,39}, {-59,40}, {-59,41}, {-59,80}, {-59,81}, {-59,82}, {-59,120}, {-59,121}, {-59,122}, {-59,123}, {-59,124}, {-59,129}, {-59,130}, {-59,131}, {-59,132}, {-59,133}, {-58,-11}, {-58,-10}, {-58,-9}, {-58,-8}, {-58,-7}, {-58,-6}, {-58,-5}, {-58,-4}, {-58,-3}, {-58,-2}, {-58,-1}, {-58,0}, {-58,1}, {-58,2}, {-58,3}, {-58,4}, {-58,5}, {-58,6}, {-58,7}, {-58,8}, {-58,9}, {-58,10}, {-58,11}, {-58,12}, {-58,13}, {-58,14}, {-58,15}, {-58,16}, {-58,17}, {-58,18}, {-58,19}, {-58,20}, {-58,21}, {-58,22}, {-58,23}, {-58,38}, {-58,39}, {-58,40}, {-58,41}, {-58,80}, {-58,81}, {-58,82}, {-58,120}, {-58,121}, {-58,122}, {-58,123}, {-58,124}, {-58,129}, {-58,130}, {-58,131}, {-58,132}, {-58,133}, {-58,134}, {-57,-11}, {-57,-10}, {-57,-9}, {-57,-8}, {-57,-7}, {-57,-6}, {-57,-5}, {-57,-4}, {-57,-3}, {-57,-2}, {-57,-1}, {-57,0}, {-57,1}, {-57,2}, {-57,3}, {-57,4}, {-57,5}, {-57,6}, {-57,7}, {-57,8}, {-57,9}, {-57,10}, {-57,11}, {-57,12}, {-57,13}, {-57,14}, {-57,15}, {-57,16}, {-57,17}, {-57,18}, {-57,19}, {-57,20}, {-57,21}, {-57,22}, {-57,23}, {-57,38}, {-57,39}, {-57,40}, {-57,41}, {-57,80}, {-57,81}, {-57,82}, {-57,83}, {-57,120}, {-57,121}, {-57,122}, {-57,123}, {-57,124}, {-57,129}, {-57,130}, {-57,131}, {-57,132}, {-57,133}, {-56,-75}, {-56,-72}, {-56,-67}, {-56,-64}, {-56,-11}, {-56,-10}, {-56,-9}, {-56,-8}, {-56,-7}, {-56,-6}, {-56,-5}, {-56,-4}, {-56,-3}, {-56,-2}, {-56,-1}, {-56,0}, {-56,1}, {-56,2}, {-56,3}, {-56,4}, {-56,5}, {-56,6}, {-56,7}, {-56,8}, {-56,9}, {-56,10}, {-56,11}, {-56,12}, {-56,13}, {-56,14}, {-56,15}, {-56,16}, {-56,17}, {-56,18}, {-56,19}, {-56,20}, {-56,21}, {-56,22}, {-56,23}, {-56,38}, {-56,39}, {-56,40}, {-56,41}, {-56,80}, {-56,81}, {-56,82}, {-56,120}, {-56,121}, {-56,122}, {-56,123}, {-56,124}, {-56,125}, {-56,129}, {-56,130}, {-56,131}, {-56,132}, {-56,133}, {-55,-11}, {-55,-10}, {-55,-9}, {-55,-8}, {-55,-7}, {-55,-6}, {-55,-5}, {-55,-4}, {-55,-3}, {-55,-2}, {-55,-1}, {-55,0}, {-55,1}, {-55,2}, {-55,3}, {-55,4}, {-55,5}, {-55,6}, {-55,7}, {-55,8}, {-55,9}, {-55,10}, {-55,11}, {-55,12}, {-55,13}, {-55,14}, {-55,15}, {-55,16}, {-55,17}, {-55,18}, {-55,19}, {-55,20}, {-55,21}, {-55,22}, {-55,23}, {-55,38}, {-55,39}, {-55,40}, {-55,41}, {-55,80}, {-55,81}, {-55,82}, {-55,120}, {-55,121}, {-55,122}, {-55,123}, {-55,124}, {-55,130}, {-54,-11}, {-54,-10}, {-54,-9}, {-54,-8}, {-54,-7}, {-54,-6}, {-54,-5}, {-54,-4}, {-54,-3}, {-54,-2}, {-54,-1}, {-54,0}, {-54,1}, {-54,2}, {-54,3}, {-54,4}, {-54,5}, {-54,6}, {-54,7}, {-54,8}, {-54,9}, {-54,10}, {-54,11}, {-54,12}, {-54,13}, {-54,14}, {-54,15}, {-54,16}, {-54,17}, {-54,18}, {-54,19}, {-54,20}, {-54,21}, {-54,22}, {-54,23}, {-54,38}, {-54,39}, {-54,40}, {-54,41}, {-54,81}, {-54,82}, {-54,120}, {-54,121}, {-54,122}, {-54,123}, {-54,124}, {-53,-11}, {-53,-10}, {-53,-9}, {-53,-8}, {-53,-7}, {-53,-6}, {-53,-5}, {-53,-4}, {-53,-3}, {-53,-2}, {-53,-1}, {-53,0}, {-53,1}, {-53,2}, {-53,3}, {-53,4}, {-53,5}, {-53,6}, {-53,7}, {-53,8}, {-53,9}, {-53,10}, {-53,11}, {-53,12}, {-53,13}, {-53,14}, {-53,15}, {-53,16}, {-53,17}, {-53,18}, {-53,19}, {-53,20}, {-53,21}, {-53,22}, {-53,23}, {-53,38}, {-53,39}, {-53,40}, {-53,41}, {-53,75}, {-53,81}, {-53,82}, {-53,121}, {-52,-70}, {-52,-69}, {-52,-11}, {-52,-10}, {-52,-9}, {-52,-8}, {-52,-7}, {-52,-6}, {-52,-5}, {-52,-4}, {-52,-3}, {-52,-2}, {-52,-1}, {-52,0}, {-52,1}, {-52,2}, {-52,3}, {-52,4}, {-52,5}, {-52,6}, {-52,7}, {-52,8}, {-52,9}, {-52,10}, {-52,11}, {-52,12}, {-52,13}, {-52,14}, {-52,15}, {-52,16}, {-52,17}, {-52,18}, {-52,19}, {-52,20}, {-52,21}, {-52,22}, {-52,23}, {-52,38}, {-52,39}, {-52,40}, {-52,41}, {-52,129}, {-52,130}, {-52,131}, {-52,132}, {-52,133}, {-51,-12}, {-51,-11}, {-51,-10}, {-51,-9}, {-51,-8}, {-51,-7}, {-51,-6}, {-51,-5}, {-51,-4}, {-51,-3}, {-51,-2}, {-51,-1}, {-51,0}, {-51,1}, {-51,2}, {-51,3}, {-51,4}, {-51,5}, {-51,6}, {-51,7}, {-51,8}, {-51,9}, {-51,10}, {-51,11}, {-51,12}, {-51,13}, {-51,14}, {-51,15}, {-51,16}, {-51,17}, {-51,18}, {-51,19}, {-51,20}, {-51,21}, {-51,22}, {-51,23}, {-51,38}, {-51,39}, {-51,40}, {-51,41}, {-51,94}, {-51,95}, {-51,96}, {-51,97}, {-51,100}, {-51,101}, {-51,102}, {-51,103}, {-51,104}, {-51,105}, {-51,106}, {-51,107}, {-51,108}, {-51,109}, {-51,110}, {-51,111}, {-51,112}, {-51,129}, {-51,130}, {-51,131}, {-51,132}, {-51,133}, {-50,-12}, {-50,-11}, {-50,-10}, {-50,-9}, {-50,-8}, {-50,-7}, {-50,-6}, {-50,-5}, {-50,-4}, {-50,-3}, {-50,-2}, {-50,-1}, {-50,0}, {-50,1}, {-50,2}, {-50,3}, {-50,4}, {-50,5}, {-50,6}, {-50,7}, {-50,8}, {-50,9}, {-50,10}, {-50,11}, {-50,12}, {-50,13}, {-50,14}, {-50,15}, {-50,16}, {-50,17}, {-50,18}, {-50,19}, {-50,20}, {-50,21}, {-50,22}, {-50,23}, {-50,24}, {-50,38}, {-50,39}, {-50,40}, {-50,41}, {-50,94}, {-50,95}, {-50,96}, {-50,97}, {-50,100}, {-50,101}, {-50,102}, {-50,103}, {-50,104}, {-50,105}, {-50,106}, {-50,107}, {-50,108}, {-50,109}, {-50,110}, {-50,111}, {-50,112}, {-50,129}, {-50,130}, {-50,131}, {-50,132}, {-50,133}, {-50,134}, {-49,-12}, {-49,-11}, {-49,-10}, {-49,-9}, {-49,-8}, {-49,-7}, {-49,-6}, {-49,-5}, {-49,-4}, {-49,-3}, {-49,-2}, {-49,-1}, {-49,0}, {-49,1}, {-49,2}, {-49,3}, {-49,4}, {-49,5}, {-49,6}, {-49,7}, {-49,8}, {-49,9}, {-49,10}, {-49,11}, {-49,12}, {-49,13}, {-49,14}, {-49,15}, {-49,16}, {-49,17}, {-49,18}, {-49,19}, {-49,20}, {-49,21}, {-49,22}, {-49,23}, {-49,38}, {-49,39}, {-49,40}, {-49,41}, {-49,94}, {-49,95}, {-49,96}, {-49,97}, {-49,98}, {-49,99}, {-49,100}, {-49,101}, {-49,102}, {-49,103}, {-49,104}, {-49,105}, {-49,106}, {-49,107}, {-49,108}, {-49,109}, {-49,110}, {-49,111}, {-49,112}, {-49,120}, {-49,121}, {-49,122}, {-49,123}, {-49,124}, {-49,129}, {-49,130}, {-49,131}, {-49,132}, {-49,133}, {-48,-11}, {-48,-10}, {-48,-9}, {-48,-8}, {-48,-7}, {-48,-6}, {-48,-5}, {-48,-4}, {-48,-3}, {-48,-2}, {-48,-1}, {-48,0}, {-48,1}, {-48,2}, {-48,3}, {-48,4}, {-48,5}, {-48,6}, {-48,7}, {-48,8}, {-48,9}, {-48,10}, {-48,11}, {-48,12}, {-48,13}, {-48,14}, {-48,15}, {-48,16}, {-48,17}, {-48,18}, {-48,19}, {-48,20}, {-48,21}, {-48,22}, {-48,23}, {-48,38}, {-48,39}, {-48,40}, {-48,41}, {-48,94}, {-48,95}, {-48,96}, {-48,97}, {-48,100}, {-48,101}, {-48,102}, {-48,103}, {-48,104}, {-48,105}, {-48,106}, {-48,107}, {-48,108}, {-48,109}, {-48,110}, {-48,111}, {-48,112}, {-48,120}, {-48,121}, {-48,122}, {-48,123}, {-48,124}, {-48,129}, {-48,130}, {-48,131}, {-48,132}, {-48,133}, {-47,-64}, {-47,-63}, {-47,-62}, {-47,-11}, {-47,-10}, {-47,-9}, {-47,-8}, {-47,-7}, {-47,-6}, {-47,-5}, {-47,-4}, {-47,-3}, {-47,-2}, {-47,-1}, {-47,0}, {-47,1}, {-47,2}, {-47,3}, {-47,4}, {-47,5}, {-47,6}, {-47,7}, {-47,8}, {-47,9}, {-47,10}, {-47,11}, {-47,12}, {-47,13}, {-47,14}, {-47,15}, {-47,16}, {-47,17}, {-47,18}, {-47,19}, {-47,20}, {-47,21}, {-47,22}, {-47,23}, {-47,38}, {-47,39}, {-47,40}, {-47,41}, {-47,70}, {-47,71}, {-47,72}, {-47,94}, {-47,95}, {-47,96}, {-47,97}, {-47,100}, {-47,101}, {-47,102}, {-47,103}, {-47,104}, {-47,105}, {-47,106}, {-47,107}, {-47,108}, {-47,109}, {-47,110}, {-47,111}, {-47,112}, {-47,120}, {-47,121}, {-47,122}, {-47,123}, {-47,124}, {-47,130}, {-46,-64}, {-46,-63}, {-46,-62}, {-46,-11}, {-46,-10}, {-46,-9}, {-46,-8}, {-46,-7}, {-46,-6}, {-46,-5}, {-46,-4}, {-46,-3}, {-46,-2}, {-46,-1}, {-46,0}, {-46,1}, {-46,2}, {-46,3}, {-46,4}, {-46,5}, {-46,6}, {-46,7}, {-46,8}, {-46,9}, {-46,10}, {-46,11}, {-46,12}, {-46,13}, {-46,14}, {-46,15}, {-46,16}, {-46,17}, {-46,18}, {-46,19}, {-46,20}, {-46,21}, {-46,22}, {-46,23}, {-46,38}, {-46,39}, {-46,40}, {-46,41}, {-46,69}, {-46,70}, {-46,71}, {-46,72}, {-46,73}, {-46,94}, {-46,95}, {-46,96}, {-46,97}, {-46,100}, {-46,101}, {-46,102}, {-46,103}, {-46,104}, {-46,105}, {-46,106}, {-46,107}, {-46,108}, {-46,109}, {-46,110}, {-46,111}, {-46,112}, {-46,120}, {-46,121}, {-46,122}, {-46,123}, {-46,124}, {-45,-11}, {-45,-10}, {-45,-9}, {-45,-8}, {-45,-7}, {-45,-6}, {-45,-5}, {-45,-4}, {-45,-3}, {-45,-2}, {-45,-1}, {-45,0}, {-45,1}, {-45,2}, {-45,3}, {-45,4}, {-45,5}, {-45,6}, {-45,7}, {-45,8}, {-45,9}, {-45,10}, {-45,11}, {-45,12}, {-45,13}, {-45,14}, {-45,15}, {-45,16}, {-45,17}, {-45,18}, {-45,19}, {-45,20}, {-45,21}, {-45,22}, {-45,23}, {-45,38}, {-45,39}, {-45,40}, {-45,41}, {-45,69}, {-45,70}, {-45,71}, {-45,72}, {-45,73}, {-45,94}, {-45,95}, {-45,96}, {-45,97}, {-45,100}, {-45,101}, {-45,102}, {-45,103}, {-45,104}, {-45,105}, {-45,106}, {-45,107}, {-45,108}, {-45,109}, {-45,110}, {-45,111}, {-45,112}, {-45,113}, {-45,119}, {-45,120}, {-45,121}, {-45,122}, {-45,123}, {-45,124}, {-45,125}, {-44,-11}, {-44,-10}, {-44,-9}, {-44,-8}, {-44,-7}, {-44,-6}, {-44,-5}, {-44,-4}, {-44,-3}, {-44,-2}, {-44,-1}, {-44,0}, {-44,1}, {-44,2}, {-44,3}, {-44,4}, {-44,5}, {-44,6}, {-44,7}, {-44,8}, {-44,9}, {-44,10}, {-44,11}, {-44,12}, {-44,13}, {-44,14}, {-44,15}, {-44,16}, {-44,17}, {-44,18}, {-44,19}, {-44,20}, {-44,21}, {-44,22}, {-44,23}, {-44,38}, {-44,39}, {-44,40}, {-44,41}, {-44,69}, {-44,70}, {-44,71}, {-44,72}, {-44,73}, {-44,94}, {-44,95}, {-44,96}, {-44,97}, {-44,100}, {-44,101}, {-44,102}, {-44,103}, {-44,104}, {-44,105}, {-44,106}, {-44,107}, {-44,108}, {-44,109}, {-44,110}, {-44,111}, {-44,112}, {-44,120}, {-44,121}, {-44,122}, {-44,123}, {-44,124}, {-44,129}, {-44,130}, {-44,131}, {-44,132}, {-44,133}, {-43,-11}, {-43,-10}, {-43,-9}, {-43,-8}, {-43,-7}, {-43,-6}, {-43,-5}, {-43,-4}, {-43,-3}, {-43,-2}, {-43,-1}, {-43,0}, {-43,1}, {-43,2}, {-43,3}, {-43,4}, {-43,5}, {-43,6}, {-43,7}, {-43,8}, {-43,9}, {-43,10}, {-43,11}, {-43,12}, {-43,13}, {-43,14}, {-43,15}, {-43,16}, {-43,17}, {-43,18}, {-43,19}, {-43,20}, {-43,21}, {-43,22}, {-43,23}, {-43,38}, {-43,39}, {-43,40}, {-43,41}, {-43,70}, {-43,71}, {-43,72}, {-43,94}, {-43,95}, {-43,96}, {-43,97}, {-43,100}, {-43,101}, {-43,102}, {-43,103}, {-43,104}, {-43,105}, {-43,106}, {-43,107}, {-43,108}, {-43,109}, {-43,110}, {-43,111}, {-43,112}, {-43,120}, {-43,121}, {-43,122}, {-43,123}, {-43,124}, {-43,129}, {-43,130}, {-43,131}, {-43,132}, {-43,133}, {-42,-11}, {-42,-10}, {-42,-9}, {-42,-8}, {-42,-7}, {-42,-6}, {-42,-5}, {-42,-4}, {-42,-3}, {-42,-2}, {-42,-1}, {-42,0}, {-42,1}, {-42,2}, {-42,3}, {-42,4}, {-42,5}, {-42,6}, {-42,7}, {-42,8}, {-42,9}, {-42,10}, {-42,11}, {-42,12}, {-42,13}, {-42,14}, {-42,15}, {-42,16}, {-42,17}, {-42,18}, {-42,19}, {-42,20}, {-42,21}, {-42,22}, {-42,23}, {-42,38}, {-42,39}, {-42,40}, {-42,41}, {-42,94}, {-42,95}, {-42,96}, {-42,97}, {-42,100}, {-42,101}, {-42,102}, {-42,103}, {-42,104}, {-42,105}, {-42,106}, {-42,107}, {-42,108}, {-42,109}, {-42,110}, {-42,111}, {-42,112}, {-42,121}, {-42,129}, {-42,130}, {-42,131}, {-42,132}, {-42,133}, {-42,134}, {-41,-11}, {-41,-10}, {-41,-9}, {-41,-8}, {-41,-7}, {-41,-6}, {-41,-5}, {-41,-4}, {-41,-3}, {-41,-2}, {-41,-1}, {-41,0}, {-41,1}, {-41,2}, {-41,3}, {-41,4}, {-41,5}, {-41,6}, {-41,7}, {-41,8}, {-41,9}, {-41,10}, {-41,11}, {-41,12}, {-41,13}, {-41,14}, {-41,15}, {-41,16}, {-41,17}, {-41,18}, {-41,19}, {-41,20}, {-41,21}, {-41,22}, {-41,23}, {-41,38}, {-41,39}, {-41,40}, {-41,41}, {-41,94}, {-41,95}, {-41,96}, {-41,97}, {-41,98}, {-41,99}, {-41,100}, {-41,101}, {-41,102}, {-41,103}, {-41,104}, {-41,105}, {-41,106}, {-41,107}, {-41,108}, {-41,109}, {-41,110}, {-41,111}, {-41,112}, {-41,129}, {-41,130}, {-41,131}, {-41,132}, {-41,133}, {-40,-61}, {-40,-11}, {-40,-10}, {-40,-9}, {-40,-8}, {-40,-7}, {-40,-6}, {-40,-5}, {-40,-4}, {-40,-3}, {-40,-2}, {-40,-1}, {-40,0}, {-40,1}, {-40,2}, {-40,3}, {-40,4}, {-40,5}, {-40,6}, {-40,7}, {-40,8}, {-40,9}, {-40,10}, {-40,11}, {-40,12}, {-40,13}, {-40,14}, {-40,15}, {-40,16}, {-40,17}, {-40,18}, {-40,19}, {-40,20}, {-40,21}, {-40,22}, {-40,23}, {-40,38}, {-40,39}, {-40,40}, {-40,41}, {-40,94}, {-40,95}, {-40,96}, {-40,97}, {-40,100}, {-40,101}, {-40,102}, {-40,103}, {-40,104}, {-40,105}, {-40,106}, {-40,107}, {-40,108}, {-40,109}, {-40,110}, {-40,111}, {-40,112}, {-40,129}, {-40,130}, {-40,131}, {-40,132}, {-40,133}, {-39,-11}, {-39,-10}, {-39,-9}, {-39,-8}, {-39,-7}, {-39,-6}, {-39,-5}, {-39,-4}, {-39,-3}, {-39,-2}, {-39,-1}, {-39,0}, {-39,1}, {-39,2}, {-39,3}, {-39,4}, {-39,5}, {-39,6}, {-39,7}, {-39,8}, {-39,9}, {-39,10}, {-39,11}, {-39,12}, {-39,13}, {-39,14}, {-39,15}, {-39,16}, {-39,17}, {-39,18}, {-39,19}, {-39,20}, {-39,21}, {-39,22}, {-39,23}, {-39,38}, {-39,39}, {-39,40}, {-39,94}, {-39,95}, {-39,96}, {-39,97}, {-39,100}, {-39,101}, {-39,102}, {-39,103}, {-39,104}, {-39,105}, {-39,106}, {-39,107}, {-39,108}, {-39,109}, {-39,110}, {-39,111}, {-39,112}, {-39,130}, {-38,-11}, {-38,-10}, {-38,-9}, {-38,-8}, {-38,-7}, {-38,-6}, {-38,-5}, {-38,-4}, {-38,-3}, {-38,-2}, {-38,-1}, {-38,0}, {-38,1}, {-38,2}, {-38,3}, {-38,4}, {-38,5}, {-38,6}, {-38,7}, {-38,8}, {-38,9}, {-38,10}, {-38,11}, {-38,12}, {-38,13}, {-38,14}, {-38,15}, {-38,16}, {-38,17}, {-38,18}, {-38,19}, {-38,20}, {-38,21}, {-38,22}, {-38,23}, {-38,38}, {-38,39}, {-38,40}, {-38,41}, {-38,42}, {-38,43}, {-38,44}, {-38,45}, {-38,120}, {-38,121}, {-38,122}, {-38,123}, {-38,124}, {-37,5}, {-37,6}, {-37,7}, {-37,8}, {-37,9}, {-37,10}, {-37,11}, {-37,12}, {-37,13}, {-37,14}, {-37,15}, {-37,16}, {-37,17}, {-37,18}, {-37,19}, {-37,20}, {-37,21}, {-37,22}, {-37,23}, {-37,38}, {-37,39}, {-37,40}, {-37,41}, {-37,42}, {-37,43}, {-37,44}, {-37,45}, {-37,120}, {-37,121}, {-37,122}, {-37,123}, {-37,124}, {-36,-22}, {-36,-16}, {-36,10}, {-36,11}, {-36,12}, {-36,13}, {-36,14}, {-36,15}, {-36,16}, {-36,17}, {-36,18}, {-36,19}, {-36,20}, {-36,21}, {-36,22}, {-36,23}, {-36,38}, {-36,39}, {-36,40}, {-36,81}, {-36,82}, {-36,120}, {-36,121}, {-36,122}, {-36,123}, {-36,124}, {-36,125}, {-36,129}, {-36,130}, {-36,131}, {-36,132}, {-36,133}, {-35,38}, {-35,39}, {-35,40}, {-35,78}, {-35,79}, {-35,80}, {-35,81}, {-35,82}, {-35,83}, {-35,84}, {-35,85}, {-35,120}, {-35,121}, {-35,122}, {-35,123}, {-35,124}, {-35,129}, {-35,130}, {-35,131}, {-35,132}, {-35,133}, {-34,38}, {-34,39}, {-34,40}, {-34,78}, {-34,79}, {-34,80}, {-34,81}, {-34,82}, {-34,83}, {-34,84}, {-34,85}, {-34,86}, {-34,120}, {-34,121}, {-34,122}, {-34,123}, {-34,124}, {-34,129}, {-34,130}, {-34,131}, {-34,132}, {-34,133}, {-34,134}, {-33,-61}, {-33,25}, {-33,38}, {-33,39}, {-33,40}, {-33,78}, {-33,79}, {-33,80}, {-33,81}, {-33,82}, {-33,83}, {-33,84}, {-33,85}, {-33,121}, {-33,129}, {-33,130}, {-33,131}, {-33,132}, {-33,133}, {-32,38}, {-32,39}, {-32,40}, {-32,78}, {-32,79}, {-32,80}, {-32,81}, {-32,82}, {-32,83}, {-32,84}, {-32,85}, {-32,129}, {-32,130}, {-32,131}, {-32,132}, {-32,133}, {-31,38}, {-31,39}, {-31,40}, {-31,78}, {-31,79}, {-31,80}, {-31,81}, {-31,82}, {-31,83}, {-31,84}, {-31,85}, {-31,130}, {-30,38}, {-30,39}, {-30,40}, {-30,78}, {-30,79}, {-30,80}, {-30,81}, {-30,82}, {-30,83}, {-30,84}, {-30,85}, {-30,116}, {-29,38}, {-29,39}, {-29,40}, {-29,78}, {-29,79}, {-29,80}, {-29,81}, {-29,82}, {-29,83}, {-29,84}, {-29,85}, {-28,38}, {-28,39}, {-28,40}, {-28,78}, {-28,79}, {-28,80}, {-28,81}, {-28,82}, {-28,83}, {-28,84}, {-28,85}, {-28,119}, {-27,-61}, {-27,25}, {-27,38}, {-27,39}, {-27,40}, {-27,81}, {-27,82}, {-27,119}, {-26,38}, {-26,39}, {-26,40}, {-25,38}, {-25,39}, {-25,40}, {-25,120}, {-25,121}, {-25,122}, {-25,123}, {-25,124}, {-25,129}, {-25,130}, {-25,131}, {-25,132}, {-25,133}, {-24,38}, {-24,39}, {-24,40}, {-24,120}, {-24,121}, {-24,122}, {-24,123}, {-24,124}, {-24,129}, {-24,130}, {-24,131}, {-24,132}, {-24,133}, {-23,38}, {-23,39}, {-23,40}, {-23,120}, {-23,121}, {-23,122}, {-23,123}, {-23,124}, {-23,125}, {-23,129}, {-23,130}, {-23,131}, {-23,132}, {-23,133}, {-23,134}, {-22,38}, {-22,39}, {-22,40}, {-22,120}, {-22,121}, {-22,122}, {-22,123}, {-22,124}, {-22,129}, {-22,130}, {-22,131}, {-22,132}, {-22,133}, {-21,120}, {-21,121}, {-21,122}, {-21,123}, {-21,124}, {-21,129}, {-21,130}, {-21,131}, {-21,132}, {-21,133}, {-20,65}, {-20,120}, {-20,129}, {-19,62}, {-19,63}, {-19,64}, {-19,65}, {-19,66}, {-19,67}, {-18,61}, {-18,62}, {-18,63}, {-18,64}, {-18,65}, {-18,66}, {-18,67}, {-17,62}, {-17,63}, {-17,64}, {-17,65}, {-17,66}, {-17,67}, {-16,62}, {-16,63}, {-16,64}, {-16,65}, {-16,66}, {-16,67}, {-16,120}, {-16,121}, {-16,122}, {-16,123}, {-16,124}, {-16,129}, {-16,130}, {-16,131}, {-16,132}, {-16,133}, {-15,32}, {-15,34}, {-15,35}, {-15,39}, {-15,63}, {-15,66}, {-15,120}, {-15,121}, {-15,122}, {-15,123}, {-15,124}, {-15,129}, {-15,130}, {-15,131}, {-15,132}, {-15,133}, {-14,32}, {-14,33}, {-14,34}, {-14,35}, {-14,36}, {-14,37}, {-14,38}, {-14,39}, {-14,40}, {-14,43}, {-14,44}, {-14,45}, {-14,46}, {-14,47}, {-14,48}, {-14,49}, {-14,50}, {-14,51}, {-14,52}, {-14,53}, {-14,54}, {-14,57}, {-14,58}, {-14,59}, {-14,60}, {-14,61}, {-14,62}, {-14,63}, {-14,64}, {-14,65}, {-14,66}, {-14,67}, {-14,120}, {-14,121}, {-14,122}, {-14,123}, {-14,124}, {-14,125}, {-14,129}, {-14,130}, {-14,131}, {-14,132}, {-14,133}, {-14,134}, {-13,32}, {-13,34}, {-13,35}, {-13,36}, {-13,37}, {-13,38}, {-13,39}, {-13,40}, {-13,43}, {-13,44}, {-13,45}, {-13,46}, {-13,47}, {-13,48}, {-13,49}, {-13,50}, {-13,51}, {-13,52}, {-13,53}, {-13,54}, {-13,57}, {-13,58}, {-13,59}, {-13,60}, {-13,61}, {-13,62}, {-13,63}, {-13,64}, {-13,65}, {-13,66}, {-13,67}, {-13,120}, {-13,121}, {-13,122}, {-13,123}, {-13,124}, {-13,129}, {-13,130}, {-13,131}, {-13,132}, {-13,133}, {-12,32}, {-12,34}, {-12,35}, {-12,36}, {-12,39}, {-12,40}, {-12,43}, {-12,44}, {-12,47}, {-12,48}, {-12,49}, {-12,50}, {-12,53}, {-12,54}, {-12,57}, {-12,58}, {-12,61}, {-12,62}, {-12,63}, {-12,64}, {-12,65}, {-12,66}, {-12,67}, {-12,120}, {-12,121}, {-12,122}, {-12,123}, {-12,124}, {-12,129}, {-12,130}, {-12,131}, {-12,132}, {-12,133}, {-11,34}, {-11,35}, {-11,36}, {-11,39}, {-11,40}, {-11,43}, {-11,44}, {-11,47}, {-11,48}, {-11,49}, {-11,50}, {-11,53}, {-11,54}, {-11,57}, {-11,58}, {-11,61}, {-11,62}, {-11,63}, {-11,64}, {-11,65}, {-11,66}, {-11,67}, {-10,33}, {-10,34}, {-10,35}, {-10,36}, {-10,37}, {-10,38}, {-10,39}, {-10,40}, {-10,43}, {-10,44}, {-10,45}, {-10,46}, {-10,47}, {-10,48}, {-10,49}, {-10,50}, {-10,51}, {-10,52}, {-10,53}, {-10,54}, {-10,57}, {-10,58}, {-10,59}, {-10,60}, {-10,61}, {-10,62}, {-10,63}, {-10,64}, {-10,65}, {-10,66}, {-10,67}, {-10,69}, {-10,70}, {-9,33}, {-9,34}, {-9,35}, {-9,36}, {-9,37}, {-9,38}, {-9,39}, {-9,40}, {-9,41}, {-9,43}, {-9,44}, {-9,45}, {-9,46}, {-9,47}, {-9,48}, {-9,49}, {-9,50}, {-9,51}, {-9,52}, {-9,53}, {-9,54}, {-9,55}, {-9,57}, {-9,58}, {-9,59}, {-9,60}, {-9,61}, {-9,62}, {-9,63}, {-9,64}, {-9,65}, {-9,66}, {-9,67}, {-9,69}, {-9,70}, {-8,33}, {-8,34}, {-8,35}, {-8,36}, {-8,37}, {-8,38}, {-8,39}, {-8,40}, {-8,41}, {-8,43}, {-8,44}, {-8,45}, {-8,46}, {-8,47}, {-8,48}, {-8,49}, {-8,50}, {-8,51}, {-8,52}, {-8,53}, {-8,54}, {-8,55}, {-8,57}, {-8,58}, {-8,59}, {-8,60}, {-8,61}, {-8,62}, {-8,63}, {-8,64}, {-8,65}, {-8,66}, {-8,67}, {-8,69}, {-8,70}, {-8,120}, {-8,121}, {-8,122}, {-8,123}, {-8,124}, {-8,129}, {-8,130}, {-8,131}, {-8,132}, {-8,133}, {-7,33}, {-7,34}, {-7,35}, {-7,36}, {-7,37}, {-7,38}, {-7,39}, {-7,40}, {-7,43}, {-7,44}, {-7,45}, {-7,46}, {-7,47}, {-7,48}, {-7,49}, {-7,50}, {-7,51}, {-7,52}, {-7,53}, {-7,54}, {-7,57}, {-7,58}, {-7,59}, {-7,60}, {-7,61}, {-7,62}, {-7,63}, {-7,64}, {-7,65}, {-7,66}, {-7,67}, {-7,69}, {-7,70}, {-7,120}, {-7,121}, {-7,122}, {-7,123}, {-7,124}, {-7,125}, {-7,129}, {-7,130}, {-7,131}, {-7,132}, {-7,133}, {-6,34}, {-6,35}, {-6,36}, {-6,39}, {-6,40}, {-6,43}, {-6,44}, {-6,47}, {-6,48}, {-6,49}, {-6,50}, {-6,53}, {-6,54}, {-6,57}, {-6,58}, {-6,61}, {-6,62}, {-6,63}, {-6,64}, {-6,65}, {-6,66}, {-6,67}, {-6,120}, {-6,121}, {-6,122}, {-6,123}, {-6,124}, {-6,129}, {-6,130}, {-6,131}, {-6,132}, {-6,133}, {-5,32}, {-5,34}, {-5,35}, {-5,36}, {-5,39}, {-5,40}, {-5,43}, {-5,44}, {-5,47}, {-5,48}, {-5,49}, {-5,50}, {-5,53}, {-5,54}, {-5,57}, {-5,58}, {-5,61}, {-5,62}, {-5,63}, {-5,64}, {-5,65}, {-5,66}, {-5,67}, {-5,120}, {-5,121}, {-5,122}, {-5,123}, {-5,124}, {-5,129}, {-5,130}, {-5,131}, {-5,132}, {-5,133}, {-4,32}, {-4,34}, {-4,35}, {-4,36}, {-4,37}, {-4,38}, {-4,39}, {-4,40}, {-4,43}, {-4,44}, {-4,45}, {-4,46}, {-4,47}, {-4,48}, {-4,49}, {-4,50}, {-4,51}, {-4,52}, {-4,53}, {-4,54}, {-4,57}, {-4,58}, {-4,59}, {-4,60}, {-4,61}, {-4,62}, {-4,63}, {-4,64}, {-4,65}, {-4,66}, {-4,67}, {-4,72}, {-4,73}, {-4,74}, {-4,75}, {-4,76}, {-4,120}, {-4,121}, {-4,122}, {-4,123}, {-4,124}, {-4,129}, {-4,130}, {-4,131}, {-4,132}, {-4,133}, {-3,32}, {-3,33}, {-3,34}, {-3,35}, {-3,36}, {-3,37}, {-3,38}, {-3,39}, {-3,40}, {-3,43}, {-3,44}, {-3,45}, {-3,46}, {-3,47}, {-3,48}, {-3,49}, {-3,50}, {-3,51}, {-3,52}, {-3,53}, {-3,54}, {-3,57}, {-3,58}, {-3,59}, {-3,60}, {-3,61}, {-3,62}, {-3,63}, {-3,64}, {-3,65}, {-3,66}, {-3,67}, {-3,71}, {-3,72}, {-3,73}, {-3,74}, {-3,75}, {-3,76}, {-3,130}, {-2,32}, {-2,34}, {-2,35}, {-2,63}, {-2,66}, {-2,72}, {-2,73}, {-2,74}, {-2,75}, {-2,76}, {-1,62}, {-1,63}, {-1,64}, {-1,65}, {-1,66}, {-1,67}, {-1,74}, {0,62}, {0,63}, {0,64}, {0,65}, {0,66}, {0,67}, {0,72}, {0,73}, {0,74}, {0,75}, {0,76}, {1,62}, {1,63}, {1,64}, {1,65}, {1,66}, {1,67}, {1,72}, {1,73}, {1,74}, {1,75}, {1,76}, {2,62}, {2,63}, {2,64}, {2,65}, {2,66}, {2,67}, {2,72}, {2,73}, {2,74}, {2,75}, {2,76}, {4,-61}, {8,113}, {8,121}, {8,129}, {9,111}, {9,112}, {9,113}, {9,114}, {9,115}, {9,119}, {9,120}, {9,121}, {9,122}, {9,123}, {9,127}, {9,128}, {9,129}, {9,130}, {9,131}, {10,111}, {10,112}, {10,113}, {10,114}, {10,115}, {10,119}, {10,120}, {10,121}, {10,122}, {10,123}, {10,127}, {10,128}, {10,129}, {10,130}, {10,131}, {11,-51}, {11,-42}, {11,73}, {11,89}, {11,95}, {11,111}, {11,112}, {11,113}, {11,114}, {11,115}, {11,119}, {11,120}, {11,121}, {11,122}, {11,123}, {11,127}, {11,128}, {11,129}, {11,130}, {11,131}, {12,72}, {12,73}, {12,74}, {12,86}, {12,87}, {12,88}, {12,89}, {12,90}, {12,92}, {12,93}, {12,94}, {12,95}, {12,96}, {12,97}, {12,98}, {12,99}, {12,100}, {12,111}, {12,112}, {12,113}, {12,114}, {12,115}, {12,116}, {12,119}, {12,120}, {12,121}, {12,122}, {12,123}, {12,124}, {12,127}, {12,128}, {12,129}, {12,130}, {12,131}, {12,132}, {13,72}, {13,73}, {13,74}, {13,86}, {13,87}, {13,88}, {13,89}, {13,90}, {13,92}, {13,93}, {13,94}, {13,95}, {13,96}, {13,97}, {13,98}, {13,99}, {13,100}, {13,111}, {13,112}, {13,113}, {13,114}, {13,115}, {13,119}, {13,120}, {13,121}, {13,122}, {13,123}, {13,127}, {13,128}, {13,129}, {13,130}, {13,131}, {14,72}, {14,73}, {14,74}, {14,86}, {14,87}, {14,88}, {14,89}, {14,90}, {14,92}, {14,93}, {14,94}, {14,95}, {14,96}, {14,97}, {14,98}, {14,99}, {14,100}, {14,101}, {15,-51}, {15,-23}, {15,-15}, {15,-14}, {15,-1}, {15,56}, {15,57}, {15,58}, {15,59}, {15,60}, {15,61}, {15,62}, {15,72}, {15,73}, {15,74}, {15,86}, {15,87}, {15,88}, {15,89}, {15,90}, {15,92}, {15,93}, {15,94}, {15,95}, {15,96}, {15,97}, {15,98}, {15,99}, {15,100}, {16,56}, {16,62}, {16,63}, {16,72}, {16,73}, {16,74}, {16,86}, {16,87}, {16,88}, {16,89}, {16,90}, {16,92}, {16,93}, {16,94}, {16,95}, {16,96}, {16,97}, {16,98}, {16,99}, {16,100}, {17,3}, {17,4}, {17,5}, {17,6}, {17,7}, {17,8}, {17,9}, {17,10}, {17,11}, {17,12}, {17,13}, {17,14}, {17,15}, {17,16}, {17,17}, {17,18}, {17,19}, {17,20}, {17,21}, {17,22}, {17,23}, {17,24}, {17,25}, {17,26}, {17,27}, {17,28}, {17,29}, {17,30}, {17,31}, {17,32}, {17,33}, {17,34}, {17,35}, {17,36}, {17,37}, {17,38}, {17,39}, {17,40}, {17,41}, {17,42}, {17,43}, {17,44}, {17,56}, {17,62}, {17,72}, {17,73}, {17,74}, {17,86}, {17,87}, {17,88}, {17,89}, {17,90}, {17,92}, {17,93}, {17,94}, {17,95}, {17,96}, {17,97}, {17,98}, {17,99}, {17,100}, {18,3}, {18,4}, {18,5}, {18,6}, {18,7}, {18,8}, {18,9}, {18,10}, {18,11}, {18,12}, {18,13}, {18,14}, {18,15}, {18,16}, {18,17}, {18,18}, {18,19}, {18,20}, {18,21}, {18,22}, {18,23}, {18,24}, {18,25}, {18,26}, {18,27}, {18,28}, {18,29}, {18,30}, {18,31}, {18,32}, {18,33}, {18,34}, {18,35}, {18,36}, {18,37}, {18,38}, {18,39}, {18,40}, {18,41}, {18,42}, {18,43}, {18,44}, {18,56}, {18,62}, {18,72}, {18,73}, {18,74}, {18,86}, {18,87}, {18,88}, {18,89}, {18,90}, {18,92}, {18,93}, {18,94}, {18,95}, {18,96}, {18,97}, {18,98}, {18,99}, {18,100}, {18,113}, {18,121}, {18,129}, {19,3}, {19,4}, {19,7}, {19,8}, {19,11}, {19,12}, {19,15}, {19,16}, {19,19}, {19,20}, {19,23}, {19,24}, {19,27}, {19,28}, {19,31}, {19,32}, {19,35}, {19,36}, {19,39}, {19,40}, {19,43}, {19,44}, {19,56}, {19,62}, {19,72}, {19,73}, {19,74}, {19,86}, {19,87}, {19,88}, {19,89}, {19,90}, {19,92}, {19,93}, {19,94}, {19,95}, {19,96}, {19,97}, {19,98}, {19,99}, {19,100}, {19,111}, {19,112}, {19,113}, {19,114}, {19,115}, {19,119}, {19,120}, {19,121}, {19,122}, {19,123}, {19,127}, {19,128}, {19,129}, {19,130}, {19,131}, {20,-1}, {20,3}, {20,4}, {20,7}, {20,8}, {20,11}, {20,12}, {20,15}, {20,16}, {20,19}, {20,20}, {20,23}, {20,24}, {20,27}, {20,28}, {20,31}, {20,32}, {20,35}, {20,36}, {20,39}, {20,40}, {20,43}, {20,44}, {20,56}, {20,62}, {20,72}, {20,73}, {20,74}, {20,86}, {20,87}, {20,88}, {20,89}, {20,90}, {20,92}, {20,93}, {20,94}, {20,95}, {20,96}, {20,97}, {20,98}, {20,99}, {20,100}, {20,111}, {20,112}, {20,113}, {20,114}, {20,115}, {20,119}, {20,120}, {20,121}, {20,122}, {20,123}, {20,127}, {20,128}, {20,129}, {20,130}, {20,131}, {21,-6}, {21,-5}, {21,-4}, {21,-3}, {21,-2}, {21,-1}, {21,0}, {21,3}, {21,4}, {21,5}, {21,6}, {21,7}, {21,8}, {21,9}, {21,10}, {21,11}, {21,12}, {21,13}, {21,14}, {21,15}, {21,16}, {21,17}, {21,18}, {21,19}, {21,20}, {21,21}, {21,22}, {21,23}, {21,24}, {21,25}, {21,26}, {21,27}, {21,28}, {21,29}, {21,30}, {21,31}, {21,32}, {21,33}, {21,34}, {21,35}, {21,36}, {21,37}, {21,38}, {21,39}, {21,40}, {21,41}, {21,42}, {21,43}, {21,44}, {21,56}, {21,57}, {21,58}, {21,59}, {21,60}, {21,61}, {21,62}, {21,73}, {21,89}, {21,92}, {21,93}, {21,94}, {21,95}, {21,111}, {21,112}, {21,113}, {21,114}, {21,115}, {21,119}, {21,120}, {21,121}, {21,122}, {21,123}, {21,127}, {21,128}, {21,129}, {21,130}, {21,131}, {22,-6}, {22,-5}, {22,-4}, {22,-3}, {22,-2}, {22,-1}, {22,0}, {22,3}, {22,4}, {22,5}, {22,6}, {22,7}, {22,8}, {22,9}, {22,10}, {22,11}, {22,12}, {22,13}, {22,14}, {22,15}, {22,16}, {22,17}, {22,18}, {22,19}, {22,20}, {22,21}, {22,22}, {22,23}, {22,24}, {22,25}, {22,26}, {22,27}, {22,28}, {22,29}, {22,30}, {22,31}, {22,32}, {22,33}, {22,34}, {22,35}, {22,36}, {22,37}, {22,38}, {22,39}, {22,40}, {22,41}, {22,42}, {22,43}, {22,44}, {22,72}, {22,73}, {22,74}, {22,111}, {22,112}, {22,113}, {22,114}, {22,115}, {22,116}, {22,119}, {22,120}, {22,121}, {22,122}, {22,123}, {22,124}, {22,127}, {22,128}, {22,129}, {22,130}, {22,131}, {22,132}, {23,-5}, {23,-4}, {23,-1}, {23,0}, {23,3}, {23,4}, {23,7}, {23,8}, {23,11}, {23,12}, {23,15}, {23,16}, {23,19}, {23,20}, {23,23}, {23,24}, {23,27}, {23,28}, {23,31}, {23,32}, {23,35}, {23,36}, {23,39}, {23,40}, {23,43}, {23,44}, {23,72}, {23,73}, {23,74}, {23,111}, {23,112}, {23,113}, {23,114}, {23,115}, {23,119}, {23,120}, {23,121}, {23,122}, {23,123}, {23,127}, {23,128}, {23,129}, {23,130}, {23,131}, {24,-5}, {24,-4}, {24,-1}, {24,0}, {24,3}, {24,4}, {24,7}, {24,8}, {24,11}, {24,12}, {24,15}, {24,16}, {24,19}, {24,20}, {24,23}, {24,24}, {24,27}, {24,28}, {24,31}, {24,32}, {24,35}, {24,36}, {24,39}, {24,40}, {24,43}, {24,44}, {24,114}, {24,122}, {24,130}, {25,-6}, {25,-5}, {25,-4}, {25,-3}, {25,-2}, {25,-1}, {25,0}, {25,3}, {25,4}, {25,5}, {25,6}, {25,7}, {25,8}, {25,9}, {25,10}, {25,11}, {25,12}, {25,13}, {25,14}, {25,15}, {25,16}, {25,17}, {25,18}, {25,19}, {25,20}, {25,21}, {25,22}, {25,23}, {25,24}, {25,25}, {25,26}, {25,27}, {25,28}, {25,29}, {25,30}, {25,31}, {25,32}, {25,33}, {25,34}, {25,35}, {25,36}, {25,37}, {25,38}, {25,39}, {25,40}, {25,41}, {25,42}, {25,43}, {25,44}, {26,-6}, {26,-5}, {26,-4}, {26,-3}, {26,-2}, {26,-1}, {26,0}, {26,3}, {26,4}, {26,5}, {26,6}, {26,7}, {26,8}, {26,9}, {26,10}, {26,11}, {26,12}, {26,13}, {26,14}, {26,15}, {26,16}, {26,17}, {26,18}, {26,19}, {26,20}, {26,21}, {26,22}, {26,23}, {26,24}, {26,25}, {26,26}, {26,27}, {26,28}, {26,29}, {26,30}, {26,31}, {26,32}, {26,33}, {26,34}, {26,35}, {26,36}, {26,37}, {26,38}, {26,39}, {26,40}, {26,41}, {26,42}, {26,43}, {26,44}, {27,-5}, {27,-4}, {27,-1}, {27,0}, {27,3}, {27,4}, {27,7}, {27,8}, {27,11}, {27,12}, {27,15}, {27,16}, {27,19}, {27,20}, {27,23}, {27,24}, {27,27}, {27,28}, {27,31}, {27,32}, {27,35}, {27,36}, {27,39}, {27,40}, {27,43}, {27,44}, {28,-5}, {28,-4}, {28,-1}, {28,0}, {28,3}, {28,4}, {28,7}, {28,8}, {28,11}, {28,12}, {28,15}, {28,16}, {28,19}, {28,20}, {28,23}, {28,24}, {28,27}, {28,28}, {28,31}, {28,32}, {28,35}, {28,36}, {28,39}, {28,40}, {28,43}, {28,44}, {29,-62}, {29,-61}, {29,-60}, {29,-59}, {29,-58}, {29,-57}, {29,-56}, {29,-55}, {29,-54}, {29,-53}, {29,-52}, {29,-51}, {29,-50}, {29,-49}, {29,-48}, {29,-47}, {29,-6}, {29,-5}, {29,-4}, {29,-3}, {29,-2}, {29,-1}, {29,0}, {29,1}, {29,3}, {29,4}, {29,5}, {29,6}, {29,7}, {29,8}, {29,9}, {29,10}, {29,11}, {29,12}, {29,13}, {29,14}, {29,15}, {29,16}, {29,17}, {29,18}, {29,19}, {29,20}, {29,21}, {29,22}, {29,23}, {29,24}, {29,25}, {29,26}, {29,27}, {29,28}, {29,29}, {29,30}, {29,31}, {29,32}, {29,33}, {29,34}, {29,35}, {29,36}, {29,37}, {29,38}, {29,39}, {29,40}, {29,41}, {29,42}, {29,43}, {29,44}, {29,45}, {30,-62}, {30,-61}, {30,-60}, {30,-59}, {30,-58}, {30,-57}, {30,-56}, {30,-55}, {30,-54}, {30,-53}, {30,-52}, {30,-51}, {30,-50}, {30,-49}, {30,-48}, {30,-47}, {30,-6}, {30,-5}, {30,-4}, {30,-3}, {30,-2}, {30,-1}, {30,0}, {30,1}, {30,3}, {30,4}, {30,5}, {30,6}, {30,7}, {30,8}, {30,9}, {30,10}, {30,11}, {30,12}, {30,13}, {30,14}, {30,15}, {30,16}, {30,17}, {30,18}, {30,19}, {30,20}, {30,21}, {30,22}, {30,23}, {30,24}, {30,25}, {30,26}, {30,27}, {30,28}, {30,29}, {30,30}, {30,31}, {30,32}, {30,33}, {30,34}, {30,35}, {30,36}, {30,37}, {30,38}, {30,39}, {30,40}, {30,41}, {30,42}, {30,43}, {30,44}, {30,45}, {31,-62}, {31,-61}, {31,-60}, {31,-59}, {31,-58}, {31,-57}, {31,-56}, {31,-55}, {31,-54}, {31,-53}, {31,-52}, {31,-51}, {31,-50}, {31,-49}, {31,-48}, {31,-47}, {31,-5}, {31,-4}, {31,-1}, {31,0}, {31,3}, {31,4}, {31,7}, {31,8}, {31,11}, {31,12}, {31,15}, {31,16}, {31,19}, {31,20}, {31,23}, {31,24}, {31,27}, {31,28}, {31,31}, {31,32}, {31,35}, {31,36}, {31,39}, {31,40}, {31,43}, {31,44}, {32,-62}, {32,-61}, {32,-60}, {32,-59}, {32,-58}, {32,-57}, {32,-56}, {32,-55}, {32,-54}, {32,-53}, {32,-52}, {32,-51}, {32,-50}, {32,-49}, {32,-48}, {32,-47}, {32,-5}, {32,-4}, {32,-1}, {32,0}, {32,3}, {32,4}, {32,7}, {32,8}, {32,11}, {32,12}, {32,15}, {32,16}, {32,19}, {32,20}, {32,23}, {32,24}, {32,27}, {32,28}, {32,31}, {32,32}, {32,35}, {32,36}, {32,39}, {32,40}, {32,43}, {32,44}, {33,-62}, {33,-61}, {33,-60}, {33,-56}, {33,-55}, {33,-54}, {33,-53}, {33,-49}, {33,-48}, {33,-47}, {33,-6}, {33,-5}, {33,-4}, {33,-3}, {33,-2}, {33,-1}, {33,0}, {33,3}, {33,4}, {33,5}, {33,6}, {33,7}, {33,8}, {33,9}, {33,10}, {33,11}, {33,12}, {33,13}, {33,14}, {33,15}, {33,16}, {33,17}, {33,18}, {33,19}, {33,20}, {33,21}, {33,22}, {33,23}, {33,24}, {33,25}, {33,26}, {33,27}, {33,28}, {33,29}, {33,30}, {33,31}, {33,32}, {33,33}, {33,34}, {33,35}, {33,36}, {33,37}, {33,38}, {33,39}, {33,40}, {33,41}, {33,42}, {33,43}, {33,44}, {34,-62}, {34,-61}, {34,-60}, {34,-56}, {34,-55}, {34,-54}, {34,-53}, {34,-49}, {34,-48}, {34,-47}, {34,-6}, {34,-5}, {34,-4}, {34,-3}, {34,-2}, {34,-1}, {34,0}, {34,3}, {34,4}, {34,5}, {34,6}, {34,7}, {34,8}, {34,9}, {34,10}, {34,11}, {34,12}, {34,13}, {34,14}, {34,15}, {34,16}, {34,17}, {34,18}, {34,19}, {34,20}, {34,21}, {34,22}, {34,23}, {34,24}, {34,25}, {34,26}, {34,27}, {34,28}, {34,29}, {34,30}, {34,31}, {34,32}, {34,33}, {34,34}, {34,35}, {34,36}, {34,37}, {34,38}, {34,39}, {34,40}, {34,41}, {34,42}, {34,43}, {34,44}, {35,-62}, {35,-61}, {35,-60}, {35,-56}, {35,-55}, {35,-54}, {35,-53}, {35,-49}, {35,-48}, {35,-47}, {35,-5}, {35,-4}, {35,-1}, {35,0}, {35,3}, {35,4}, {35,7}, {35,8}, {35,11}, {35,12}, {35,15}, {35,16}, {35,19}, {35,20}, {35,23}, {35,24}, {35,27}, {35,28}, {35,31}, {35,32}, {35,35}, {35,36}, {35,39}, {35,40}, {35,43}, {35,44}, {36,-65}, {36,-64}, {36,-63}, {36,-62}, {36,-61}, {36,-60}, {36,-59}, {36,-58}, {36,-57}, {36,-56}, {36,-55}, {36,-54}, {36,-53}, {36,-52}, {36,-51}, {36,-50}, {36,-49}, {36,-48}, {36,-47}, {36,-46}, {36,-45}, {36,-44}, {36,-5}, {36,-4}, {36,-1}, {36,0}, {36,3}, {36,4}, {36,7}, {36,8}, {36,11}, {36,12}, {36,15}, {36,16}, {36,19}, {36,20}, {36,23}, {36,24}, {36,27}, {36,28}, {36,31}, {36,32}, {36,35}, {36,36}, {36,39}, {36,40}, {36,43}, {36,44}, {37,-65}, {37,-64}, {37,-63}, {37,-62}, {37,-61}, {37,-60}, {37,-59}, {37,-58}, {37,-57}, {37,-56}, {37,-55}, {37,-54}, {37,-53}, {37,-52}, {37,-51}, {37,-50}, {37,-49}, {37,-48}, {37,-47}, {37,-46}, {37,-45}, {37,-44}, {37,-6}, {37,-5}, {37,-4}, {37,-3}, {37,-2}, {37,-1}, {37,0}, {37,3}, {37,4}, {37,5}, {37,6}, {37,7}, {37,8}, {37,9}, {37,10}, {37,11}, {37,12}, {37,13}, {37,14}, {37,15}, {37,16}, {37,17}, {37,18}, {37,19}, {37,20}, {37,21}, {37,22}, {37,23}, {37,24}, {37,25}, {37,26}, {37,27}, {37,28}, {37,29}, {37,30}, {37,31}, {37,32}, {37,33}, {37,34}, {37,35}, {37,36}, {37,37}, {37,38}, {37,39}, {37,40}, {37,41}, {37,42}, {37,43}, {37,44}, {38,-65}, {38,-64}, {38,-63}, {38,-62}, {38,-61}, {38,-60}, {38,-59}, {38,-58}, {38,-57}, {38,-56}, {38,-55}, {38,-54}, {38,-53}, {38,-52}, {38,-51}, {38,-50}, {38,-49}, {38,-48}, {38,-47}, {38,-46}, {38,-45}, {38,-44}, {38,-6}, {38,-5}, {38,-4}, {38,-3}, {38,-2}, {38,-1}, {38,0}, {38,3}, {38,4}, {38,5}, {38,6}, {38,7}, {38,8}, {38,9}, {38,10}, {38,11}, {38,12}, {38,13}, {38,14}, {38,15}, {38,16}, {38,17}, {38,18}, {38,19}, {38,20}, {38,21}, {38,22}, {38,23}, {38,24}, {38,25}, {38,26}, {38,27}, {38,28}, {38,29}, {38,30}, {38,31}, {38,32}, {38,33}, {38,34}, {38,35}, {38,36}, {38,37}, {38,38}, {38,39}, {38,40}, {38,41}, {38,42}, {38,43}, {38,44}, {39,-65}, {39,-64}, {39,-63}, {39,-62}, {39,-61}, {39,-60}, {39,-59}, {39,-58}, {39,-57}, {39,-56}, {39,-55}, {39,-54}, {39,-53}, {39,-52}, {39,-51}, {39,-50}, {39,-49}, {39,-48}, {39,-47}, {39,-46}, {39,-45}, {39,-44}, {39,-5}, {39,-4}, {39,-1}, {39,0}, {39,3}, {39,4}, {39,7}, {39,8}, {39,11}, {39,12}, {39,15}, {39,16}, {39,19}, {39,20}, {39,23}, {39,24}, {39,27}, {39,28}, {39,31}, {39,32}, {39,35}, {39,36}, {39,39}, {39,40}, {39,43}, {39,44}, {39,64}, {39,72}, {39,73}, {39,91}, {39,116}, {39,136}, {40,-62}, {40,-61}, {40,-60}, {40,-56}, {40,-55}, {40,-54}, {40,-53}, {40,-49}, {40,-48}, {40,-47}, {40,-5}, {40,-4}, {40,-1}, {40,0}, {40,3}, {40,4}, {40,7}, {40,8}, {40,11}, {40,12}, {40,15}, {40,16}, {40,19}, {40,20}, {40,23}, {40,24}, {40,27}, {40,28}, {40,31}, {40,32}, {40,35}, {40,36}, {40,39}, {40,40}, {40,43}, {40,44}, {40,63}, {40,64}, {40,65}, {40,66}, {40,67}, {40,68}, {40,69}, {40,70}, {40,71}, {40,72}, {40,73}, {40,81}, {40,82}, {40,83}, {40,84}, {40,85}, {40,86}, {40,87}, {40,88}, {40,89}, {40,90}, {40,91}, {40,92}, {40,93}, {40,94}, {40,95}, {40,96}, {40,97}, {40,98}, {40,99}, {40,100}, {40,101}, {40,102}, {40,103}, {40,110}, {40,111}, {40,112}, {40,113}, {40,114}, {40,115}, {40,116}, {40,117}, {40,118}, {40,119}, {40,120}, {40,121}, {40,122}, {40,128}, {40,129}, {40,130}, {40,131}, {40,132}, {40,133}, {40,134}, {40,135}, {40,136}, {40,137}, {40,138}, {41,-62}, {41,-61}, {41,-60}, {41,-56}, {41,-55}, {41,-54}, {41,-53}, {41,-49}, {41,-48}, {41,-47}, {41,-6}, {41,-5}, {41,-4}, {41,-3}, {41,-2}, {41,-1}, {41,0}, {41,3}, {41,4}, {41,5}, {41,6}, {41,7}, {41,8}, {41,9}, {41,10}, {41,11}, {41,12}, {41,13}, {41,14}, {41,15}, {41,16}, {41,17}, {41,18}, {41,19}, {41,20}, {41,21}, {41,22}, {41,23}, {41,24}, {41,25}, {41,26}, {41,27}, {41,28}, {41,29}, {41,30}, {41,31}, {41,32}, {41,33}, {41,34}, {41,35}, {41,36}, {41,37}, {41,38}, {41,39}, {41,40}, {41,41}, {41,42}, {41,43}, {41,44}, {41,63}, {41,64}, {41,65}, {41,66}, {41,67}, {41,68}, {41,69}, {41,70}, {41,71}, {41,72}, {41,73}, {41,81}, {41,82}, {41,83}, {41,84}, {41,85}, {41,86}, {41,87}, {41,88}, {41,89}, {41,90}, {41,91}, {41,92}, {41,93}, {41,94}, {41,95}, {41,96}, {41,97}, {41,98}, {41,99}, {41,100}, {41,101}, {41,102}, {41,103}, {41,110}, {41,111}, {41,112}, {41,113}, {41,114}, {41,115}, {41,116}, {41,117}, {41,118}, {41,119}, {41,120}, {41,121}, {41,122}, {41,128}, {41,129}, {41,130}, {41,131}, {41,132}, {41,133}, {41,134}, {41,135}, {41,136}, {42,-62}, {42,-61}, {42,-60}, {42,-56}, {42,-55}, {42,-54}, {42,-53}, {42,-49}, {42,-48}, {42,-47}, {42,-6}, {42,-5}, {42,-4}, {42,-3}, {42,-2}, {42,-1}, {42,0}, {42,3}, {42,4}, {42,5}, {42,6}, {42,7}, {42,8}, {42,9}, {42,10}, {42,11}, {42,12}, {42,13}, {42,14}, {42,15}, {42,16}, {42,17}, {42,18}, {42,19}, {42,20}, {42,21}, {42,22}, {42,23}, {42,24}, {42,25}, {42,26}, {42,27}, {42,28}, {42,29}, {42,30}, {42,31}, {42,32}, {42,33}, {42,34}, {42,35}, {42,36}, {42,37}, {42,38}, {42,39}, {42,40}, {42,41}, {42,42}, {42,43}, {42,44}, {42,63}, {42,64}, {42,65}, {42,66}, {42,67}, {42,68}, {42,69}, {42,70}, {42,71}, {42,72}, {42,73}, {42,80}, {42,81}, {42,82}, {42,83}, {42,84}, {42,85}, {42,86}, {42,87}, {42,88}, {42,89}, {42,90}, {42,91}, {42,92}, {42,93}, {42,94}, {42,95}, {42,96}, {42,97}, {42,98}, {42,99}, {42,100}, {42,101}, {42,102}, {42,103}, {42,104}, {42,109}, {42,110}, {42,111}, {42,112}, {42,113}, {42,114}, {42,115}, {42,116}, {42,117}, {42,118}, {42,119}, {42,120}, {42,121}, {42,122}, {42,128}, {42,129}, {42,130}, {42,131}, {42,132}, {42,133}, {42,134}, {42,135}, {42,136}, {42,137}, {42,138}, {43,-62}, {43,-61}, {43,-60}, {43,-59}, {43,-58}, {43,-57}, {43,-56}, {43,-55}, {43,-54}, {43,-53}, {43,-52}, {43,-51}, {43,-50}, {43,-49}, {43,-48}, {43,-47}, {43,-5}, {43,-4}, {43,-1}, {43,0}, {43,3}, {43,4}, {43,7}, {43,8}, {43,11}, {43,12}, {43,15}, {43,16}, {43,19}, {43,20}, {43,23}, {43,24}, {43,27}, {43,28}, {43,31}, {43,32}, {43,35}, {43,36}, {43,39}, {43,40}, {43,43}, {43,44}, {43,63}, {43,64}, {43,65}, {43,66}, {43,67}, {43,68}, {43,69}, {43,70}, {43,71}, {43,72}, {43,73}, {43,81}, {43,82}, {43,83}, {43,84}, {43,85}, {43,86}, {43,87}, {43,88}, {43,89}, {43,90}, {43,91}, {43,92}, {43,93}, {43,94}, {43,95}, {43,96}, {43,97}, {43,98}, {43,99}, {43,100}, {43,101}, {43,102}, {43,103}, {43,110}, {43,111}, {43,112}, {43,113}, {43,114}, {43,115}, {43,116}, {43,117}, {43,118}, {43,119}, {43,120}, {43,121}, {43,122}, {43,128}, {43,129}, {43,130}, {43,131}, {43,132}, {43,133}, {43,134}, {43,135}, {43,136}, {44,-62}, {44,-61}, {44,-60}, {44,-59}, {44,-58}, {44,-57}, {44,-56}, {44,-55}, {44,-54}, {44,-53}, {44,-52}, {44,-51}, {44,-50}, {44,-49}, {44,-48}, {44,-47}, {44,-5}, {44,-4}, {44,-1}, {44,0}, {44,3}, {44,4}, {44,7}, {44,8}, {44,11}, {44,12}, {44,15}, {44,16}, {44,19}, {44,20}, {44,23}, {44,24}, {44,27}, {44,28}, {44,31}, {44,32}, {44,35}, {44,36}, {44,39}, {44,40}, {44,43}, {44,44}, {44,62}, {44,63}, {44,64}, {44,65}, {44,66}, {44,67}, {44,68}, {44,69}, {44,70}, {44,71}, {44,72}, {44,73}, {44,81}, {44,82}, {44,83}, {44,84}, {44,85}, {44,86}, {44,87}, {44,88}, {44,89}, {44,90}, {44,91}, {44,92}, {44,93}, {44,94}, {44,95}, {44,96}, {44,97}, {44,98}, {44,99}, {44,100}, {44,101}, {44,102}, {44,103}, {44,110}, {44,111}, {44,112}, {44,113}, {44,114}, {44,115}, {44,116}, {44,117}, {44,118}, {44,119}, {44,120}, {44,121}, {44,122}, {44,128}, {44,129}, {44,130}, {44,131}, {44,132}, {44,133}, {44,134}, {44,135}, {44,136}, {44,137}, {44,138}, {45,-62}, {45,-61}, {45,-60}, {45,-59}, {45,-58}, {45,-57}, {45,-56}, {45,-55}, {45,-54}, {45,-53}, {45,-52}, {45,-51}, {45,-50}, {45,-49}, {45,-48}, {45,-47}, {45,-6}, {45,-5}, {45,-4}, {45,-3}, {45,-2}, {45,-1}, {45,0}, {45,1}, {45,3}, {45,4}, {45,5}, {45,6}, {45,7}, {45,8}, {45,9}, {45,10}, {45,11}, {45,12}, {45,13}, {45,14}, {45,15}, {45,16}, {45,17}, {45,18}, {45,19}, {45,20}, {45,21}, {45,22}, {45,23}, {45,24}, {45,25}, {45,26}, {45,27}, {45,28}, {45,29}, {45,30}, {45,31}, {45,32}, {45,33}, {45,34}, {45,35}, {45,36}, {45,37}, {45,38}, {45,39}, {45,40}, {45,41}, {45,42}, {45,43}, {45,44}, {45,45}, {45,63}, {45,64}, {45,65}, {45,66}, {45,67}, {45,68}, {45,69}, {45,70}, {45,71}, {45,72}, {45,73}, {45,81}, {45,82}, {45,83}, {45,84}, {45,85}, {45,86}, {45,87}, {45,88}, {45,89}, {45,90}, {45,91}, {45,92}, {45,93}, {45,94}, {45,95}, {45,96}, {45,97}, {45,98}, {45,99}, {45,100}, {45,101}, {45,102}, {45,103}, {45,110}, {45,111}, {45,112}, {45,113}, {45,114}, {45,115}, {45,116}, {45,117}, {45,118}, {45,119}, {45,120}, {45,121}, {45,122}, {45,128}, {45,129}, {45,130}, {45,131}, {45,132}, {45,133}, {45,134}, {45,135}, {45,136}, {46,-62}, {46,-61}, {46,-60}, {46,-59}, {46,-58}, {46,-57}, {46,-56}, {46,-55}, {46,-54}, {46,-53}, {46,-52}, {46,-51}, {46,-50}, {46,-49}, {46,-48}, {46,-47}, {46,-6}, {46,-5}, {46,-4}, {46,-3}, {46,-2}, {46,-1}, {46,0}, {46,1}, {46,3}, {46,4}, {46,5}, {46,6}, {46,7}, {46,8}, {46,9}, {46,10}, {46,11}, {46,12}, {46,13}, {46,14}, {46,15}, {46,16}, {46,17}, {46,18}, {46,19}, {46,20}, {46,21}, {46,22}, {46,23}, {46,24}, {46,25}, {46,26}, {46,27}, {46,28}, {46,29}, {46,30}, {46,31}, {46,32}, {46,33}, {46,34}, {46,35}, {46,36}, {46,37}, {46,38}, {46,39}, {46,40}, {46,41}, {46,42}, {46,43}, {46,44}, {46,45}, {46,63}, {46,64}, {46,65}, {46,66}, {46,67}, {46,68}, {46,69}, {46,70}, {46,71}, {46,72}, {46,73}, {46,81}, {46,82}, {46,83}, {46,84}, {46,85}, {46,86}, {46,87}, {46,88}, {46,89}, {46,90}, {46,91}, {46,92}, {46,93}, {46,94}, {46,95}, {46,96}, {46,97}, {46,98}, {46,99}, {46,100}, {46,101}, {46,102}, {46,103}, {46,110}, {46,111}, {46,112}, {46,113}, {46,114}, {46,115}, {46,116}, {46,117}, {46,118}, {46,119}, {46,120}, {46,121}, {46,122}, {46,128}, {46,129}, {46,130}, {46,131}, {46,132}, {46,133}, {46,134}, {46,135}, {46,136}, {46,137}, {46,138}, {47,-60}, {47,-5}, {47,-4}, {47,-1}, {47,0}, {47,3}, {47,4}, {47,7}, {47,8}, {47,11}, {47,12}, {47,15}, {47,16}, {47,19}, {47,20}, {47,23}, {47,24}, {47,27}, {47,28}, {47,31}, {47,32}, {47,35}, {47,36}, {47,39}, {47,40}, {47,43}, {47,44}, {47,63}, {47,64}, {47,65}, {47,66}, {47,67}, {47,68}, {47,69}, {47,70}, {47,71}, {47,72}, {47,73}, {47,81}, {47,82}, {47,83}, {47,84}, {47,85}, {47,86}, {47,87}, {47,88}, {47,89}, {47,90}, {47,91}, {47,92}, {47,93}, {47,94}, {47,95}, {47,96}, {47,97}, {47,98}, {47,99}, {47,100}, {47,101}, {47,102}, {47,103}, {47,110}, {47,111}, {47,112}, {47,113}, {47,114}, {47,115}, {47,116}, {47,117}, {47,118}, {47,119}, {47,120}, {47,121}, {47,122}, {47,128}, {47,129}, {47,130}, {47,131}, {47,132}, {47,133}, {47,134}, {47,135}, {47,136}, {48,-60}, {48,-5}, {48,-4}, {48,-1}, {48,0}, {48,3}, {48,4}, {48,7}, {48,8}, {48,11}, {48,12}, {48,15}, {48,16}, {48,19}, {48,20}, {48,23}, {48,24}, {48,27}, {48,28}, {48,31}, {48,32}, {48,35}, {48,36}, {48,39}, {48,40}, {48,43}, {48,44}, {48,63}, {48,64}, {48,65}, {48,66}, {48,67}, {48,68}, {48,69}, {48,70}, {48,71}, {48,72}, {48,73}, {48,81}, {48,82}, {48,83}, {48,84}, {48,85}, {48,86}, {48,87}, {48,88}, {48,89}, {48,90}, {48,91}, {48,92}, {48,93}, {48,94}, {48,95}, {48,96}, {48,97}, {48,98}, {48,99}, {48,100}, {48,101}, {48,102}, {48,103}, {48,110}, {48,111}, {48,112}, {48,113}, {48,114}, {48,115}, {48,116}, {48,117}, {48,118}, {48,119}, {48,120}, {48,121}, {48,122}, {48,128}, {48,129}, {48,130}, {48,131}, {48,132}, {48,133}, {48,134}, {48,135}, {48,136}, {48,137}, {48,138}, {49,-6}, {49,-5}, {49,-4}, {49,-3}, {49,-2}, {49,-1}, {49,0}, {49,3}, {49,4}, {49,5}, {49,6}, {49,7}, {49,8}, {49,9}, {49,10}, {49,11}, {49,12}, {49,13}, {49,14}, {49,15}, {49,16}, {49,17}, {49,18}, {49,19}, {49,20}, {49,21}, {49,22}, {49,23}, {49,24}, {49,25}, {49,26}, {49,27}, {49,28}, {49,29}, {49,30}, {49,31}, {49,32}, {49,33}, {49,34}, {49,35}, {49,36}, {49,37}, {49,38}, {49,39}, {49,40}, {49,41}, {49,42}, {49,43}, {49,44}, {49,63}, {49,64}, {49,65}, {49,66}, {49,67}, {49,68}, {49,69}, {49,70}, {49,71}, {49,72}, {49,73}, {49,81}, {49,82}, {49,83}, {49,84}, {49,85}, {49,86}, {49,87}, {49,88}, {49,89}, {49,90}, {49,91}, {49,92}, {49,93}, {49,94}, {49,95}, {49,96}, {49,97}, {49,98}, {49,99}, {49,100}, {49,101}, {49,102}, {49,103}, {49,110}, {49,111}, {49,112}, {49,113}, {49,114}, {49,115}, {49,116}, {49,117}, {49,118}, {49,119}, {49,120}, {49,121}, {49,122}, {49,128}, {49,129}, {49,130}, {49,131}, {49,132}, {49,133}, {49,134}, {49,135}, {49,136}, {50,-6}, {50,-5}, {50,-4}, {50,-3}, {50,-2}, {50,-1}, {50,0}, {50,3}, {50,4}, {50,5}, {50,6}, {50,7}, {50,8}, {50,9}, {50,10}, {50,11}, {50,12}, {50,13}, {50,14}, {50,15}, {50,16}, {50,17}, {50,18}, {50,19}, {50,20}, {50,21}, {50,22}, {50,23}, {50,24}, {50,25}, {50,26}, {50,27}, {50,28}, {50,29}, {50,30}, {50,31}, {50,32}, {50,33}, {50,34}, {50,35}, {50,36}, {50,37}, {50,38}, {50,39}, {50,40}, {50,41}, {50,42}, {50,43}, {50,44}, {50,63}, {50,64}, {50,65}, {50,66}, {50,67}, {50,68}, {50,69}, {50,70}, {50,71}, {50,72}, {50,73}, {50,81}, {50,82}, {50,83}, {50,84}, {50,85}, {50,86}, {50,87}, {50,88}, {50,89}, {50,90}, {50,91}, {50,92}, {50,93}, {50,94}, {50,95}, {50,96}, {50,97}, {50,98}, {50,99}, {50,100}, {50,101}, {50,102}, {50,103}, {50,110}, {50,111}, {50,112}, {50,113}, {50,114}, {50,115}, {50,116}, {50,117}, {50,118}, {50,119}, {50,120}, {50,121}, {50,122}, {50,128}, {50,129}, {50,130}, {50,131}, {50,132}, {50,133}, {50,134}, {50,135}, {50,136}, {50,137}, {50,138}, {51,-5}, {51,-4}, {51,-1}, {51,0}, {51,3}, {51,4}, {51,7}, {51,8}, {51,11}, {51,12}, {51,15}, {51,16}, {51,19}, {51,20}, {51,23}, {51,24}, {51,27}, {51,28}, {51,31}, {51,32}, {51,35}, {51,36}, {51,39}, {51,40}, {51,43}, {51,44}, {51,63}, {51,64}, {51,65}, {51,66}, {51,67}, {51,68}, {51,69}, {51,70}, {51,71}, {51,72}, {51,73}, {51,81}, {51,82}, {51,83}, {51,84}, {51,85}, {51,86}, {51,87}, {51,88}, {51,89}, {51,90}, {51,91}, {51,92}, {51,93}, {51,94}, {51,95}, {51,96}, {51,97}, {51,98}, {51,99}, {51,100}, {51,101}, {51,102}, {51,103}, {51,111}, {52,-5}, {52,-4}, {52,-1}, {52,0}, {52,3}, {52,4}, {52,7}, {52,8}, {52,11}, {52,12}, {52,15}, {52,16}, {52,19}, {52,20}, {52,23}, {52,24}, {52,27}, {52,28}, {52,31}, {52,32}, {52,35}, {52,36}, {52,39}, {52,40}, {52,43}, {52,44}, {52,63}, {52,64}, {52,65}, {52,66}, {52,67}, {52,68}, {52,69}, {52,70}, {52,71}, {52,72}, {52,73}, {52,81}, {52,82}, {52,83}, {52,84}, {52,85}, {52,86}, {52,87}, {52,88}, {52,89}, {52,90}, {52,91}, {52,92}, {52,93}, {52,94}, {52,95}, {52,96}, {52,97}, {52,98}, {52,99}, {52,100}, {52,101}, {52,102}, {52,103}, {53,-6}, {53,-5}, {53,-4}, {53,-3}, {53,-2}, {53,-1}, {53,0}, {53,3}, {53,4}, {53,5}, {53,6}, {53,7}, {53,8}, {53,9}, {53,10}, {53,11}, {53,12}, {53,13}, {53,14}, {53,15}, {53,16}, {53,17}, {53,18}, {53,19}, {53,20}, {53,21}, {53,22}, {53,23}, {53,24}, {53,25}, {53,26}, {53,27}, {53,28}, {53,29}, {53,30}, {53,31}, {53,32}, {53,33}, {53,34}, {53,35}, {53,36}, {53,37}, {53,38}, {53,39}, {53,40}, {53,41}, {53,42}, {53,43}, {53,44}, {53,63}, {53,64}, {53,65}, {53,66}, {53,67}, {53,68}, {53,69}, {53,70}, {53,71}, {53,72}, {53,73}, {53,81}, {53,82}, {53,83}, {53,84}, {53,85}, {53,86}, {53,87}, {53,88}, {53,89}, {53,90}, {53,91}, {53,92}, {53,93}, {53,94}, {53,95}, {53,96}, {53,97}, {53,98}, {53,99}, {53,100}, {53,101}, {53,102}, {53,103}, {54,-6}, {54,-5}, {54,-4}, {54,-3}, {54,-2}, {54,-1}, {54,0}, {54,3}, {54,4}, {54,5}, {54,6}, {54,7}, {54,8}, {54,9}, {54,10}, {54,11}, {54,12}, {54,13}, {54,14}, {54,15}, {54,16}, {54,17}, {54,18}, {54,19}, {54,20}, {54,21}, {54,22}, {54,23}, {54,24}, {54,25}, {54,26}, {54,27}, {54,28}, {54,29}, {54,30}, {54,31}, {54,32}, {54,33}, {54,34}, {54,35}, {54,36}, {54,37}, {54,38}, {54,39}, {54,40}, {54,41}, {54,42}, {54,43}, {54,44}, {54,62}, {54,63}, {54,64}, {54,65}, {54,66}, {54,67}, {54,68}, {54,69}, {54,70}, {54,71}, {54,72}, {54,73}, {54,81}, {54,82}, {54,83}, {54,84}, {54,85}, {54,86}, {54,87}, {54,88}, {54,89}, {54,90}, {54,91}, {54,92}, {54,93}, {54,94}, {54,95}, {54,96}, {54,97}, {54,98}, {54,99}, {54,100}, {54,101}, {54,102}, {54,103}, {55,-1}, {55,3}, {55,4}, {55,7}, {55,8}, {55,11}, {55,12}, {55,15}, {55,16}, {55,19}, {55,20}, {55,23}, {55,24}, {55,27}, {55,28}, {55,31}, {55,32}, {55,35}, {55,36}, {55,39}, {55,40}, {55,43}, {55,44}, {55,63}, {55,64}, {55,65}, {55,66}, {55,67}, {55,68}, {55,69}, {55,70}, {55,71}, {55,72}, {55,73}, {55,81}, {55,82}, {55,83}, {55,84}, {55,85}, {55,86}, {55,87}, {55,88}, {55,89}, {55,90}, {55,91}, {55,92}, {55,93}, {55,94}, {55,95}, {55,96}, {55,97}, {55,98}, {55,99}, {55,100}, {55,101}, {55,102}, {55,103}, {55,125}, {55,131}, {56,-97}, {56,-96}, {56,-95}, {56,3}, {56,4}, {56,7}, {56,8}, {56,11}, {56,12}, {56,15}, {56,16}, {56,19}, {56,20}, {56,23}, {56,24}, {56,27}, {56,28}, {56,31}, {56,32}, {56,35}, {56,36}, {56,39}, {56,40}, {56,43}, {56,44}, {56,63}, {56,64}, {56,65}, {56,66}, {56,67}, {56,68}, {56,69}, {56,70}, {56,71}, {56,72}, {56,73}, {56,81}, {56,82}, {56,83}, {56,84}, {56,85}, {56,86}, {56,87}, {56,88}, {56,89}, {56,90}, {56,91}, {56,92}, {56,93}, {56,94}, {56,95}, {56,96}, {56,97}, {56,98}, {56,99}, {56,100}, {56,101}, {56,102}, {56,103}, {56,110}, {56,111}, {56,112}, {56,113}, {56,114}, {56,115}, {56,116}, {56,117}, {56,118}, {56,119}, {56,120}, {56,121}, {56,122}, {56,123}, {56,124}, {56,125}, {56,126}, {56,127}, {56,128}, {56,129}, {56,130}, {56,131}, {56,132}, {56,133}, {56,134}, {57,-97}, {57,-96}, {57,-95}, {57,-94}, {57,3}, {57,4}, {57,5}, {57,6}, {57,7}, {57,8}, {57,9}, {57,10}, {57,11}, {57,12}, {57,13}, {57,14}, {57,15}, {57,16}, {57,17}, {57,18}, {57,19}, {57,20}, {57,21}, {57,22}, {57,23}, {57,24}, {57,25}, {57,26}, {57,27}, {57,28}, {57,29}, {57,30}, {57,31}, {57,32}, {57,33}, {57,34}, {57,35}, {57,36}, {57,37}, {57,38}, {57,39}, {57,40}, {57,41}, {57,42}, {57,43}, {57,44}, {57,63}, {57,64}, {57,65}, {57,66}, {57,67}, {57,68}, {57,69}, {57,70}, {57,71}, {57,72}, {57,73}, {57,81}, {57,82}, {57,83}, {57,84}, {57,85}, {57,86}, {57,87}, {57,88}, {57,89}, {57,90}, {57,91}, {57,92}, {57,93}, {57,94}, {57,95}, {57,96}, {57,97}, {57,98}, {57,99}, {57,100}, {57,101}, {57,102}, {57,103}, {57,110}, {57,111}, {57,112}, {57,113}, {57,114}, {57,115}, {57,116}, {57,117}, {57,118}, {57,119}, {57,120}, {57,121}, {57,122}, {57,123}, {57,124}, {57,125}, {57,126}, {57,127}, {57,128}, {57,129}, {57,130}, {57,131}, {57,132}, {57,133}, {57,134}, {58,-97}, {58,-96}, {58,-95}, {58,3}, {58,4}, {58,5}, {58,6}, {58,7}, {58,8}, {58,9}, {58,10}, {58,11}, {58,12}, {58,13}, {58,14}, {58,15}, {58,16}, {58,17}, {58,18}, {58,19}, {58,20}, {58,21}, {58,22}, {58,23}, {58,24}, {58,25}, {58,26}, {58,27}, {58,28}, {58,29}, {58,30}, {58,31}, {58,32}, {58,33}, {58,34}, {58,35}, {58,36}, {58,37}, {58,38}, {58,39}, {58,40}, {58,41}, {58,42}, {58,43}, {58,44}, {58,63}, {58,64}, {58,65}, {58,66}, {58,67}, {58,68}, {58,69}, {58,70}, {58,71}, {58,72}, {58,73}, {58,81}, {58,82}, {58,83}, {58,84}, {58,85}, {58,86}, {58,87}, {58,88}, {58,89}, {58,90}, {58,91}, {58,92}, {58,93}, {58,94}, {58,95}, {58,96}, {58,97}, {58,98}, {58,99}, {58,100}, {58,101}, {58,102}, {58,103}, {58,110}, {58,111}, {58,112}, {58,113}, {58,114}, {59,-95}, {59,63}, {59,64}, {59,65}, {59,66}, {59,67}, {59,68}, {59,69}, {59,70}, {59,71}, {59,72}, {59,73}, {59,91}, {59,109}, {59,110}, {59,111}, {59,112}, {59,113}, {59,114}, {60,-96}, {60,-95}, {60,-94}, {60,-60}, {60,-34}, {60,-33}, {60,-32}, {60,-31}, {60,-30}, {60,-29}, {60,-28}, {60,-27}, {60,-26}, {60,-25}, {60,-24}, {60,-23}, {60,-22}, {60,-21}, {60,-20}, {60,-19}, {60,-18}, {60,-10}, {60,-9}, {60,63}, {60,64}, {60,65}, {60,66}, {60,67}, {60,68}, {60,69}, {60,70}, {60,71}, {60,72}, {60,73}, {60,110}, {60,111}, {60,112}, {60,113}, {60,114}, {61,-96}, {61,-95}, {61,-94}, {61,-93}, {61,-34}, {61,-33}, {61,-32}, {61,-31}, {61,-30}, {61,-29}, {61,-28}, {61,-27}, {61,-26}, {61,-25}, {61,-24}, {61,-23}, {61,-22}, {61,-21}, {61,-20}, {61,-19}, {61,-18}, {61,63}, {61,64}, {61,65}, {61,66}, {61,67}, {61,68}, {61,69}, {61,70}, {61,71}, {61,72}, {61,73}, {61,74}, {61,110}, {61,111}, {61,112}, {61,113}, {61,114}, {62,-96}, {62,-95}, {62,-94}, {62,-34}, {62,-33}, {62,-32}, {62,-31}, {62,-30}, {62,-29}, {62,-28}, {62,-27}, {62,-26}, {62,-25}, {62,-24}, {62,-23}, {62,-22}, {62,-21}, {62,-20}, {62,-19}, {62,-18}, {62,63}, {62,64}, {62,65}, {62,66}, {62,67}, {62,68}, {62,69}, {62,70}, {62,71}, {62,72}, {62,73}, {62,110}, {62,111}, {62,112}, {62,113}, {62,114}, {63,-94}, {63,-34}, {63,-33}, {63,-32}, {63,-31}, {63,-30}, {63,-29}, {63,-28}, {63,-27}, {63,-26}, {63,-25}, {63,-24}, {63,-23}, {63,-22}, {63,-21}, {63,-20}, {63,-19}, {63,-18}, {63,63}, {63,64}, {63,65}, {63,66}, {63,67}, {63,68}, {63,69}, {63,70}, {63,71}, {63,72}, {63,73}, {63,96}, {63,97}, {63,110}, {63,111}, {63,112}, {63,113}, {63,114}, {64,-95}, {64,-94}, {64,-93}, {64,-30}, {64,-22}, {64,62}, {64,63}, {64,64}, {64,65}, {64,66}, {64,67}, {64,68}, {64,69}, {64,70}, {64,71}, {64,72}, {64,73}, {64,81}, {64,82}, {64,83}, {64,84}, {64,85}, {64,91}, {64,92}, {64,93}, {64,94}, {64,95}, {64,96}, {64,97}, {64,98}, {64,99}, {64,110}, {64,111}, {64,112}, {64,113}, {64,114}, {65,-95}, {65,-94}, {65,-93}, {65,-92}, {65,-30}, {65,-22}, {65,63}, {65,64}, {65,65}, {65,66}, {65,67}, {65,68}, {65,69}, {65,70}, {65,71}, {65,72}, {65,73}, {65,80}, {65,81}, {65,82}, {65,83}, {65,84}, {65,85}, {65,86}, {65,91}, {65,92}, {65,93}, {65,94}, {65,95}, {65,96}, {65,97}, {65,98}, {65,99}, {65,110}, {65,111}, {65,112}, {65,113}, {65,114}, {66,-95}, {66,-94}, {66,-93}, {66,-34}, {66,-33}, {66,-32}, {66,-31}, {66,-30}, {66,-29}, {66,-28}, {66,-27}, {66,-26}, {66,-25}, {66,-24}, {66,-23}, {66,-22}, {66,-21}, {66,-20}, {66,-19}, {66,-18}, {66,63}, {66,64}, {66,65}, {66,66}, {66,67}, {66,68}, {66,69}, {66,70}, {66,71}, {66,72}, {66,73}, {66,81}, {66,82}, {66,83}, {66,84}, {66,85}, {66,91}, {66,92}, {66,93}, {66,94}, {66,95}, {66,96}, {66,97}, {66,98}, {66,99}, {66,110}, {66,111}, {66,112}, {66,113}, {66,114}, {67,-93}, {67,-81}, {67,-34}, {67,-33}, {67,-32}, {67,-31}, {67,-30}, {67,-29}, {67,-28}, {67,-27}, {67,-26}, {67,-25}, {67,-24}, {67,-23}, {67,-22}, {67,-21}, {67,-20}, {67,-19}, {67,-18}, {67,63}, {67,64}, {67,65}, {67,66}, {67,67}, {67,68}, {67,69}, {67,70}, {67,71}, {67,72}, {67,73}, {67,81}, {67,82}, {67,83}, {67,84}, {67,85}, {67,91}, {67,92}, {67,93}, {67,94}, {67,95}, {67,96}, {67,97}, {67,98}, {67,99}, {67,110}, {67,111}, {67,112}, {67,113}, {67,114}, {68,-94}, {68,-93}, {68,-92}, {68,-63}, {68,-58}, {68,-52}, {68,-45}, {68,-34}, {68,-33}, {68,-32}, {68,-31}, {68,-30}, {68,-29}, {68,-28}, {68,-27}, {68,-26}, {68,-25}, {68,-24}, {68,-23}, {68,-22}, {68,-21}, {68,-20}, {68,-19}, {68,-18}, {68,63}, {68,64}, {68,65}, {68,66}, {68,67}, {68,68}, {68,69}, {68,70}, {68,71}, {68,72}, {68,73}, {68,81}, {68,82}, {68,83}, {68,84}, {68,85}, {68,87}, {68,88}, {68,89}, {68,90}, {68,91}, {68,99}, {68,100}, {68,101}, {68,102}, {68,103}, {68,110}, {68,111}, {68,112}, {68,113}, {68,114}, {69,-94}, {69,-93}, {69,-92}, {69,-64}, {69,-63}, {69,-62}, {69,-61}, {69,-60}, {69,-59}, {69,-58}, {69,-57}, {69,-56}, {69,-55}, {69,-54}, {69,-53}, {69,-52}, {69,-51}, {69,-50}, {69,-49}, {69,-48}, {69,-47}, {69,-46}, {69,-45}, {69,-44}, {69,-43}, {69,-42}, {69,-41}, {69,-34}, {69,-33}, {69,-32}, {69,-31}, {69,-30}, {69,-29}, {69,-28}, {69,-27}, {69,-26}, {69,-25}, {69,-24}, {69,-23}, {69,-22}, {69,-21}, {69,-20}, {69,-19}, {69,-18}, {69,63}, {69,64}, {69,65}, {69,66}, {69,67}, {69,68}, {69,69}, {69,70}, {69,71}, {69,72}, {69,73}, {69,81}, {69,82}, {69,83}, {69,84}, {69,85}, {69,87}, {69,88}, {69,89}, {69,90}, {69,100}, {69,101}, {69,102}, {69,103}, {70,-94}, {70,-93}, {70,-92}, {70,-64}, {70,-63}, {70,-62}, {70,-61}, {70,-60}, {70,-59}, {70,-58}, {70,-57}, {70,-56}, {70,-55}, {70,-54}, {70,-53}, {70,-52}, {70,-51}, {70,-50}, {70,-49}, {70,-48}, {70,-47}, {70,-46}, {70,-45}, {70,-44}, {70,-43}, {70,-42}, {70,-41}, {70,-34}, {70,-33}, {70,-32}, {70,-31}, {70,-30}, {70,-29}, {70,-28}, {70,-27}, {70,-26}, {70,-25}, {70,-24}, {70,-23}, {70,-22}, {70,-21}, {70,-20}, {70,-19}, {70,-18}, {70,-1}, {70,0}, {70,1}, {70,9}, {70,10}, {70,20}, {70,21}, {70,22}, {70,37}, {70,38}, {70,39}, {70,63}, {70,64}, {70,65}, {70,66}, {70,67}, {70,68}, {70,69}, {70,70}, {70,71}, {70,72}, {70,73}, {70,81}, {70,82}, {70,83}, {70,84}, {70,85}, {70,87}, {70,88}, {70,89}, {70,90}, {70,100}, {70,101}, {70,102}, {70,103}, {70,104}, {71,-94}, {71,-93}, {71,-92}, {71,-64}, {71,-63}, {71,-62}, {71,-61}, {71,-60}, {71,-59}, {71,-53}, {71,-52}, {71,-47}, {71,-46}, {71,-45}, {71,-44}, {71,-43}, {71,-42}, {71,-41}, {71,-40}, {71,-34}, {71,-33}, {71,-32}, {71,-31}, {71,-30}, {71,-29}, {71,-28}, {71,-27}, {71,-26}, {71,-25}, {71,-24}, {71,-23}, {71,-22}, {71,-21}, {71,-20}, {71,-19}, {71,-18}, {71,9}, {71,10}, {71,63}, {71,64}, {71,65}, {71,66}, {71,67}, {71,68}, {71,69}, {71,70}, {71,71}, {71,72}, {71,73}, {71,81}, {71,82}, {71,83}, {71,84}, {71,85}, {71,87}, {71,88}, {71,89}, {71,90}, {71,100}, {71,101}, {71,102}, {71,103}, {72,-92}, {72,-64}, {72,-63}, {72,-62}, {72,-61}, {72,-60}, {72,-59}, {72,-50}, {72,-49}, {72,-48}, {72,-47}, {72,-46}, {72,-45}, {72,-44}, {72,-43}, {72,-42}, {72,-41}, {72,-34}, {72,-33}, {72,-32}, {72,-31}, {72,-30}, {72,-29}, {72,-28}, {72,-27}, {72,-26}, {72,-25}, {72,-24}, {72,-23}, {72,-22}, {72,-21}, {72,-20}, {72,-19}, {72,-18}, {72,-1}, {72,0}, {72,1}, {72,9}, {72,10}, {72,20}, {72,21}, {72,22}, {72,37}, {72,38}, {72,39}, {72,63}, {72,64}, {72,65}, {72,66}, {72,67}, {72,68}, {72,69}, {72,70}, {72,71}, {72,72}, {72,73}, {72,81}, {72,82}, {72,83}, {72,84}, {72,85}, {72,87}, {72,88}, {72,89}, {72,90}, {72,100}, {72,101}, {72,102}, {72,103}, {73,-93}, {73,-92}, {73,-91}, {73,-90}, {73,-64}, {73,-63}, {73,-62}, {73,-61}, {73,-60}, {73,-59}, {73,-50}, {73,-49}, {73,-48}, {73,-47}, {73,-46}, {73,-45}, {73,-44}, {73,-43}, {73,-42}, {73,-41}, {73,-34}, {73,-33}, {73,-32}, {73,-31}, {73,-30}, {73,-29}, {73,-28}, {73,-27}, {73,-26}, {73,-25}, {73,-24}, {73,-23}, {73,-22}, {73,-21}, {73,-20}, {73,-19}, {73,-18}, {73,-1}, {73,0}, {73,1}, {73,9}, {73,10}, {73,20}, {73,21}, {73,22}, {73,37}, {73,38}, {73,39}, {73,63}, {73,64}, {73,65}, {73,66}, {73,67}, {73,68}, {73,69}, {73,70}, {73,71}, {73,72}, {73,73}, {73,81}, {73,82}, {73,83}, {73,84}, {73,85}, {73,87}, {73,88}, {73,89}, {73,90}, {73,100}, {73,101}, {73,102}, {73,103}, {74,-93}, {74,-92}, {74,-91}, {74,-90}, {74,-64}, {74,-63}, {74,-62}, {74,-61}, {74,-60}, {74,-59}, {74,-50}, {74,-49}, {74,-48}, {74,-47}, {74,-46}, {74,-45}, {74,-44}, {74,-43}, {74,-42}, {74,-41}, {74,-34}, {74,-33}, {74,-32}, {74,-31}, {74,-30}, {74,-29}, {74,-28}, {74,-27}, {74,-26}, {74,-25}, {74,-24}, {74,-23}, {74,-22}, {74,-21}, {74,-20}, {74,-19}, {74,-18}, {74,-1}, {74,0}, {74,1}, {74,9}, {74,10}, {74,19}, {74,20}, {74,21}, {74,22}, {74,37}, {74,38}, {74,39}, {74,62}, {74,63}, {74,64}, {74,65}, {74,66}, {74,67}, {74,68}, {74,69}, {74,70}, {74,71}, {74,72}, {74,73}, {74,81}, {74,82}, {74,83}, {74,84}, {74,85}, {74,87}, {74,88}, {74,89}, {74,90}, {74,100}, {74,101}, {74,102}, {74,103}, {74,110}, {74,111}, {74,112}, {74,113}, {74,114}, {74,115}, {74,116}, {74,117}, {74,118}, {74,120}, {74,121}, {74,122}, {74,123}, {74,124}, {74,125}, {74,126}, {74,127}, {74,128}, {74,129}, {74,130}, {74,131}, {74,132}, {74,133}, {74,134}, {74,135}, {74,136}, {74,137}, {74,138}, {75,-93}, {75,-92}, {75,-91}, {75,-90}, {75,-34}, {75,-33}, {75,-32}, {75,-31}, {75,-30}, {75,-29}, {75,-28}, {75,-27}, {75,-26}, {75,-25}, {75,-24}, {75,-23}, {75,-22}, {75,-21}, {75,-20}, {75,-19}, {75,-18}, {75,-1}, {75,0}, {75,1}, {75,9}, {75,10}, {75,20}, {75,21}, {75,22}, {75,37}, {75,38}, {75,39}, {75,63}, {75,64}, {75,65}, {75,66}, {75,67}, {75,68}, {75,69}, {75,70}, {75,71}, {75,72}, {75,73}, {75,81}, {75,82}, {75,83}, {75,84}, {75,85}, {75,87}, {75,88}, {75,89}, {75,90}, {75,100}, {75,101}, {75,102}, {75,103}, {75,110}, {75,111}, {75,112}, {75,113}, {75,114}, {75,115}, {75,116}, {75,117}, {75,118}, {75,119}, {75,120}, {75,121}, {75,122}, {75,123}, {75,124}, {75,125}, {75,126}, {75,127}, {75,128}, {75,129}, {75,130}, {75,131}, {75,132}, {75,133}, {75,134}, {75,135}, {75,136}, {75,137}, {75,138}, {75,139}, {76,-93}, {76,-92}, {76,-91}, {76,-90}, {76,-34}, {76,-33}, {76,-32}, {76,-31}, {76,-30}, {76,-29}, {76,-28}, {76,-27}, {76,-26}, {76,-25}, {76,-24}, {76,-23}, {76,-22}, {76,-21}, {76,-20}, {76,-19}, {76,-18}, {76,-1}, {76,0}, {76,1}, {76,9}, {76,10}, {76,20}, {76,21}, {76,22}, {76,37}, {76,38}, {76,39}, {76,63}, {76,64}, {76,65}, {76,66}, {76,67}, {76,68}, {76,69}, {76,70}, {76,71}, {76,72}, {76,73}, {76,81}, {76,82}, {76,83}, {76,84}, {76,85}, {76,87}, {76,88}, {76,89}, {76,90}, {76,91}, {76,99}, {76,100}, {76,101}, {76,102}, {76,103}, {76,110}, {76,111}, {76,112}, {76,113}, {76,114}, {76,115}, {76,116}, {76,117}, {76,118}, {76,120}, {76,121}, {76,122}, {76,123}, {76,124}, {76,125}, {76,126}, {76,127}, {76,128}, {76,129}, {76,130}, {76,131}, {76,132}, {76,133}, {76,134}, {76,135}, {76,136}, {76,137}, {76,138}, {77,-91}, {77,-90}, {77,-30}, {77,-22}, {77,-1}, {77,0}, {77,1}, {77,9}, {77,10}, {77,20}, {77,21}, {77,22}, {77,37}, {77,38}, {77,39}, {77,63}, {77,64}, {77,65}, {77,66}, {77,67}, {77,68}, {77,69}, {77,70}, {77,71}, {77,72}, {77,73}, {77,91}, {77,92}, {77,93}, {77,94}, {77,95}, {77,96}, {77,97}, {77,98}, {77,99}, {77,110}, {77,111}, {77,112}, {77,113}, {77,114}, {77,115}, {77,116}, {77,117}, {77,118}, {77,120}, {77,132}, {77,133}, {77,134}, {77,135}, {77,136}, {77,137}, {77,138}, {78,-91}, {78,-90}, {78,-1}, {78,0}, {78,1}, {78,9}, {78,10}, {78,20}, {78,21}, {78,22}, {78,37}, {78,38}, {78,39}, {78,63}, {78,64}, {78,65}, {78,66}, {78,67}, {78,68}, {78,69}, {78,70}, {78,71}, {78,72}, {78,73}, {78,91}, {78,92}, {78,93}, {78,94}, {78,95}, {78,96}, {78,97}, {78,98}, {78,99}, {78,110}, {78,111}, {78,112}, {78,113}, {78,114}, {78,115}, {78,116}, {78,117}, {78,118}, {78,132}, {78,133}, {78,134}, {78,135}, {78,136}, {78,137}, {78,138}, {79,63}, {79,64}, {79,65}, {79,66}, {79,67}, {79,68}, {79,69}, {79,70}, {79,71}, {79,72}, {79,73}, {79,91}, {79,92}, {79,93}, {79,94}, {79,95}, {79,96}, {79,97}, {79,98}, {79,99}, {79,110}, {79,111}, {79,112}, {79,113}, {79,114}, {79,115}, {79,116}, {79,117}, {79,118}, {79,132}, {79,133}, {79,134}, {79,135}, {79,136}, {79,137}, {79,138}, {80,63}, {80,64}, {80,65}, {80,66}, {80,67}, {80,68}, {80,69}, {80,70}, {80,71}, {80,72}, {80,73}, {80,91}, {80,92}, {80,93}, {80,94}, {80,95}, {80,96}, {80,97}, {80,98}, {80,99}, {80,110}, {80,111}, {80,112}, {80,113}, {80,114}, {80,115}, {80,116}, {80,117}, {80,118}, {80,132}, {80,133}, {80,134}, {80,135}, {80,136}, {80,137}, {80,138}, {81,98}, {81,111}, {81,137}, {82,-30}, {82,-14}, {85,93}, {85,94}, },
    ["vegetation-green-grass-4"] = {{-81,-103}, {-81,-102}, {-80,-102}, {-80,-101}, {-80,-100}, {-80,-99}, {-79,-106}, {-79,-99}, {-79,-98}, {-78,-114}, {-78,-112}, {-78,-104}, {-78,-97}, {-77,-113}, {-77,-110}, {-77,-109}, {-77,-95}, {-77,87}, {-76,-111}, {-76,-102}, {-76,-101}, {-76,-100}, {-76,-92}, {-76,87}, {-75,-116}, {-75,-108}, {-75,-106}, {-75,-101}, {-75,-100}, {-75,-99}, {-75,-98}, {-75,-91}, {-74,-116}, {-74,-115}, {-74,-114}, {-74,-113}, {-74,-105}, {-74,-100}, {-74,-98}, {-74,-97}, {-74,88}, {-74,119}, {-73,-116}, {-73,-115}, {-73,-114}, {-73,-113}, {-73,-112}, {-73,-111}, {-73,-105}, {-73,-104}, {-73,-95}, {-72,-113}, {-72,-112}, {-72,-111}, {-72,-110}, {-72,-103}, {-72,-102}, {-72,-93}, {-71,-111}, {-71,-110}, {-71,-109}, {-71,-108}, {-71,-101}, {-71,-100}, {-71,-92}, {-70,-110}, {-70,-109}, {-70,-108}, {-70,-107}, {-70,-99}, {-69,-116}, {-69,-115}, {-69,-107}, {-69,-106}, {-69,-98}, {-69,-97}, {-69,-96}, {-69,-91}, {-69,-90}, {-69,-89}, {-69,85}, {-69,129}, {-68,-116}, {-68,-115}, {-68,-114}, {-68,-113}, {-68,-107}, {-68,-106}, {-68,-105}, {-68,-104}, {-68,-95}, {-68,-89}, {-68,73}, {-67,-114}, {-67,-113}, {-67,-112}, {-67,-105}, {-67,-104}, {-67,-103}, {-67,-94}, {-67,76}, {-67,80}, {-67,136}, {-66,-114}, {-66,-111}, {-66,-110}, {-66,-104}, {-66,-103}, {-66,-102}, {-66,-94}, {-66,-93}, {-66,-92}, {-66,76}, {-66,77}, {-66,81}, {-65,-109}, {-65,-108}, {-65,-103}, {-65,-102}, {-65,-93}, {-65,-92}, {-65,-91}, {-65,-90}, {-64,-110}, {-64,-107}, {-64,-99}, {-64,-91}, {-64,-90}, {-63,-108}, {-63,-107}, {-63,-106}, {-63,-105}, {-63,-100}, {-63,-99}, {-63,-98}, {-63,-97}, {-63,-96}, {-62,-107}, {-62,-106}, {-62,-103}, {-62,-98}, {-62,-97}, {-62,-96}, {-62,-95}, {-62,-94}, {-61,-114}, {-61,-113}, {-61,-106}, {-61,-103}, {-61,-102}, {-61,-97}, {-61,-96}, {-61,-95}, {-61,-94}, {-61,-93}, {-60,-114}, {-60,-113}, {-60,-112}, {-60,-104}, {-60,-103}, {-60,-102}, {-60,-101}, {-60,-93}, {-60,-92}, {-60,-91}, {-59,-112}, {-59,-111}, {-59,-102}, {-59,-101}, {-59,-100}, {-59,-99}, {-59,-93}, {-59,-92}, {-59,-91}, {-59,-90}, {-58,-111}, {-58,-110}, {-58,-109}, {-58,-101}, {-58,-100}, {-58,-99}, {-58,-97}, {-58,-91}, {-58,-90}, {-58,-89}, {-57,-109}, {-57,-100}, {-57,-99}, {-57,-96}, {-57,-95}, {-57,-90}, {-57,-89}, {-56,-108}, {-56,-105}, {-56,-95}, {-56,-94}, {-55,-114}, {-55,-107}, {-55,-106}, {-55,-103}, {-55,-97}, {-55,-96}, {-55,-92}, {-54,-114}, {-54,-113}, {-54,-112}, {-54,-106}, {-54,-105}, {-54,-103}, {-54,-102}, {-54,-96}, {-54,-95}, {-54,-92}, {-54,-91}, {-53,-114}, {-53,-113}, {-53,-112}, {-53,-111}, {-53,-105}, {-53,-102}, {-53,-101}, {-53,-93}, {-53,-92}, {-53,-91}, {-53,-90}, {-52,-112}, {-52,-109}, {-52,-101}, {-52,-100}, {-52,-92}, {-52,-91}, {-52,-90}, {-51,-112}, {-51,-111}, {-51,-99}, {-51,-98}, {-51,-90}, {-50,-109}, {-50,-108}, {-50,-107}, {-50,-101}, {-50,-97}, {-49,-108}, {-49,-107}, {-49,-105}, {-49,-99}, {-49,-94}, {-49,-93}, {-48,-103}, {-48,-97}, {-48,-96}, {-48,-91}, {-47,-102}, {-46,-112}, {-46,-111}, {-46,-102}, {-46,-101}, {-46,-100}, {-46,-93}, {-46,-92}, {-46,-90}, {-45,-111}, {-45,-110}, {-45,-109}, {-45,-101}, {-45,-100}, {-45,-99}, {-45,-90}, {-44,-109}, {-44,-108}, {-44,-107}, {-44,-90}, {-43,-107}, {-42,-103}, {-42,-97}, {-42,-94}, {-41,-110}, {-41,-104}, {-41,-101}, {-41,-96}, {-40,-110}, {-40,-109}, {-40,-108}, {-40,-103}, {-40,-100}, {-40,-94}, {-40,-93}, {-40,-92}, {-40,-91}, {-39,-109}, {-39,-108}, {-39,-107}, {-39,-102}, {-39,-101}, {-39,-100}, {-39,-99}, {-38,-108}, {-38,-105}, {-38,-100}, {-38,-97}, {-38,-96}, {-37,-105}, {-37,-104}, {-37,-96}, {-36,-105}, {-36,-104}, {-36,-103}, {-36,-97}, {-36,-92}, {-35,-110}, {-35,-109}, {-35,-103}, {-35,-79}, {-35,-78}, {-34,-110}, {-34,-109}, {-34,-108}, {-34,-101}, {-34,-92}, {-33,-110}, {-33,-109}, {-33,-108}, {-33,-107}, {-33,-100}, {-33,-98}, {-33,-97}, {-32,-109}, {-32,-108}, {-32,-96}, {-31,-107}, {-31,-106}, {-31,-95}, {-31,-94}, {-31,-80}, {-31,-77}, {-30,-104}, {-30,-95}, {-30,-94}, {-30,-93}, {-30,-92}, {-30,-80}, {-30,-77}, {-29,-102}, {-29,-100}, {-29,-93}, {-28,-109}, {-28,-108}, {-28,-101}, {-28,-100}, {-28,-99}, {-27,-109}, {-27,-108}, {-27,-107}, {-27,-106}, {-27,-99}, {-26,-104}, {-26,-97}, {-26,-94}, {-26,-93}, {-26,-80}, {-26,97}, {-26,98}, {-25,-105}, {-25,-102}, {-25,-96}, {-25,-95}, {-25,-94}, {-25,-93}, {-25,-81}, {-25,-80}, {-25,93}, {-25,98}, {-25,108}, {-24,-100}, {-24,-93}, {-23,-109}, {-23,-98}, {-22,-109}, {-22,-108}, {-22,-107}, {-21,-108}, {-21,-107}, {-21,-106}, {-21,-105}, {-21,-96}, {-20,-103}, {-20,-95}, {-20,-94}, {-20,-82}, {-20,-79}, {-20,-78}, {-20,34}, {-19,-105}, {-19,-102}, {-19,34}, {-18,-104}, {-18,-103}, {-18,110}, {-18,111}, {-17,-108}, {-17,-102}, {-16,-107}, {-16,-106}, {-16,-98}, {-16,-97}, {-16,-96}, {-16,-82}, {-16,-81}, {-15,-106}, {-15,-99}, {-15,-98}, {-15,-82}, {-15,-81}, {-15,113}, {-14,-105}, {-14,-104}, {-14,-103}, {-14,114}, {-13,-104}, {-13,-101}, {-13,-95}, {-12,-103}, {-12,-100}, {-12,-99}, {-11,-101}, {-11,-100}, {-11,-99}, {-11,-98}, {-11,-76}, {-10,-100}, {-10,-99}, {-10,-98}, {-10,-97}, {-10,-76}, {-6,-84}, {-6,-83}, {-6,-82}, {-6,-81}, {-6,-78}, {-5,-84}, {-5,-82}, {-5,-81}, {-5,-78}, {-3,86}, {-1,-84}, {-1,-81}, {-1,-80}, {0,-84}, {0,-81}, {0,-80}, {0,-75}, {1,-105}, {1,-104}, {2,-104}, {3,-103}, {3,-102}, {4,-104}, {4,-103}, {4,-102}, {4,-101}, {4,-100}, {4,-99}, {4,-81}, {4,-77}, {4,-76}, {5,-99}, {5,-98}, {5,-85}, {5,-84}, {5,-81}, {5,-77}, {5,-76}, {5,33}, {6,-97}, {6,31}, {6,32}, {6,33}, {7,-98}, {7,-97}, {7,-96}, {7,31}, {8,-97}, {8,-96}, {8,-18}, {8,23}, {8,24}, {8,29}, {9,-96}, {9,-95}, {9,-84}, {9,-83}, {9,-82}, {9,-81}, {9,-78}, {9,-77}, {9,-76}, {9,12}, {9,25}, {10,-95}, {10,-84}, {10,-83}, {10,-82}, {10,-81}, {10,-78}, {10,-77}, {10,141}, {11,-95}, {12,-95}, {12,-94}, {17,-80}, {18,140}, {23,-83}, {24,-83}, {26,-82}, {26,-42}, {27,-82}, {27,-42}, {29,-42}, {30,-42}, {31,-81}, {31,52}, {32,-42}, {33,-42}, {42,-42}, {43,-42}, {45,-42}, {46,-42}, {48,-42}, {49,-42}, {62,131}, {63,131}, {67,131}, {70,129}, },
    ["vegetation-green-grass-1"] = {{-79,73}, {-79,74}, {-78,72}, {-78,73}, {-69,91}, {-68,90}, {-68,91}, {-67,89}, {-67,90}, {-67,91}, {-66,87}, {-66,88}, {-66,89}, {-66,90}, {-66,91}, {-65,83}, {-65,84}, {-65,85}, {-65,86}, {-65,87}, {-65,88}, {-65,89}, {-65,90}, {-65,91}, {-59,72}, {-59,73}, {-59,75}, {-59,76}, {-59,77}, {-58,72}, {-58,73}, {-58,75}, {-58,76}, {-58,77}, {-57,77}, {-56,76}, {-56,77}, {-55,76}, {-55,77}, {-36,73}, {-35,73}, {-35,74}, {-35,75}, {-34,74}, {-34,75}, {-33,74}, {-33,75}, {-32,74}, {-32,75}, {-31,74}, {-31,75}, {-30,88}, {-30,89}, {-30,90}, {-29,88}, {-29,89}, {-29,90}, {-28,88}, {-28,89}, {-28,90}, {-28,91}, {-28,92}, {-28,93}, {-28,94}, {-28,95}, {-28,96}, {-28,97}, {-28,98}, {-28,99}, {-28,100}, {-28,101}, {-28,102}, {-28,103}, {-28,104}, {-28,111}, {-28,112}, {-28,113}, {-28,114}, {-27,88}, {-27,89}, {-27,90}, {-27,91}, {-27,92}, {-27,93}, {-27,94}, {-27,95}, {-27,96}, {-27,97}, {-27,98}, {-27,100}, {-27,101}, {-27,102}, {-27,103}, {-27,104}, {-27,111}, {-27,112}, {-27,113}, {-27,114}, {-26,88}, {-26,89}, {-26,90}, {-26,93}, {-26,94}, {-26,95}, {-26,96}, {-26,100}, {-26,101}, {-26,102}, {-26,103}, {-25,87}, {-25,88}, {-25,89}, {-25,90}, {-24,87}, {-24,88}, {-24,89}, {-24,90}, {-22,33}, {-22,34}, {-22,35}, {-21,34}, {-21,35}, {-20,83}, {-20,84}, {-20,85}, {-20,86}, {-20,87}, {-20,88}, {-19,83}, {-19,84}, {-19,97}, {-19,98}, {-19,99}, {-19,100}, {-19,101}, {-18,76}, {-18,77}, {-18,78}, {-18,79}, {-18,83}, {-18,84}, {-18,85}, {-18,95}, {-18,96}, {-18,97}, {-18,98}, {-18,99}, {-18,102}, {-18,103}, {-17,76}, {-17,77}, {-17,78}, {-17,79}, {-17,83}, {-17,84}, {-17,90}, {-17,98}, {-17,102}, {-17,103}, {-16,76}, {-16,77}, {-16,78}, {-16,79}, {-16,83}, {-16,84}, {-16,97}, {-16,99}, {-16,100}, {-16,117}, {-15,76}, {-15,77}, {-15,78}, {-15,79}, {-15,83}, {-15,117}, {-14,76}, {-14,77}, {-14,78}, {-14,79}, {-14,87}, {-14,116}, {-14,117}, {-13,76}, {-13,77}, {-13,78}, {-13,79}, {-13,87}, {-13,111}, {-13,116}, {-13,117}, {-12,77}, {-12,78}, {-12,87}, {-12,88}, {-12,110}, {-12,111}, {-12,112}, {-12,116}, {-12,117}, {-11,77}, {-11,78}, {-11,110}, {-11,111}, {-11,112}, {-11,113}, {-11,117}, {-10,110}, {-10,111}, {-10,112}, {-10,113}, {-10,117}, {-9,87}, {-9,88}, {-9,110}, {-9,111}, {-9,112}, {-9,113}, {-9,116}, {-9,117}, {-8,75}, {-8,76}, {-8,86}, {-8,89}, {-8,99}, {-8,100}, {-8,110}, {-8,111}, {-8,112}, {-8,113}, {-8,114}, {-8,115}, {-8,116}, {-8,117}, {-7,75}, {-7,76}, {-7,77}, {-7,88}, {-7,97}, {-7,98}, {-7,99}, {-7,100}, {-7,101}, {-7,111}, {-7,112}, {-7,113}, {-7,114}, {-7,115}, {-7,116}, {-7,117}, {-6,75}, {-6,76}, {-6,77}, {-6,78}, {-6,95}, {-6,96}, {-6,97}, {-6,98}, {-6,99}, {-6,100}, {-6,101}, {-6,102}, {-6,109}, {-6,110}, {-6,111}, {-6,112}, {-6,113}, {-6,114}, {-6,115}, {-6,116}, {-6,117}, {-5,78}, {-5,79}, {-5,93}, {-5,94}, {-5,95}, {-5,96}, {-5,97}, {-5,98}, {-5,99}, {-5,100}, {-5,101}, {-5,102}, {-5,103}, {-5,104}, {-5,105}, {-5,106}, {-5,107}, {-5,108}, {-5,109}, {-5,110}, {-5,111}, {-5,112}, {-5,113}, {-5,114}, {-5,115}, {-5,116}, {-5,117}, {-4,78}, {-4,79}, {-1,86}, {-1,87}, {-1,88}, {-1,89}, {0,78}, {0,86}, {0,87}, {0,88}, {0,89}, {1,35}, {1,78}, {1,85}, {1,86}, {1,87}, {1,88}, {1,89}, {2,35}, {2,78}, {2,79}, {2,80}, {2,81}, {2,82}, {2,86}, {2,87}, {2,88}, {2,89}, {3,35}, {4,35}, {7,32}, {7,33}, {7,34}, {7,35}, {8,31}, {8,32}, {8,33}, {8,34}, {8,35}, {9,-59}, {9,-58}, {9,27}, {9,32}, {9,33}, {9,34}, {9,35}, {17,-84}, {17,-83}, {18,-84}, {59,125}, {59,126}, {59,127}, {59,128}, {59,129}, {59,130}, {60,131}, {61,131}, {68,131}, {69,131}, {70,128}, {70,130}, {70,131}, {71,128}, {71,129}, {71,130}, {71,131}, {72,120}, {72,126}, {72,127}, {72,128}, {72,129}, {72,130}, {72,131}, },
    ["water-mud"] = {{-74,81}, {-73,80}, {-73,81}, {-73,82}, {-73,83}, {-72,80}, {-72,81}, {-72,82}, {-72,83}, {-71,79}, {-71,80}, {-71,82}, {-14,92}, {-14,93}, {-13,91}, {-13,92}, {-13,93}, {-13,94}, {-12,92}, {-12,93}, {-12,94}, {-11,92}, {-11,93}, {-11,94}, {-10,94}, {-10,95}, {-10,96}, {62,124}, {62,125}, {63,124}, {63,125}, {63,126}, {63,128}, {64,124}, {64,125}, {64,126}, {64,127}, {65,125}, {65,126}, {66,124}, {66,125}, {67,124}, {68,123}, {68,124}, },
    ["water"] = {{-58,56}, {-58,64}, {-57,57}, {-57,58}, {-57,59}, {-57,60}, {-57,61}, {-57,62}, {-57,63}, {-57,64}, {-57,65}, {-56,57}, {-56,58}, {-56,60}, {-56,61}, {-56,62}, {-56,63}, {-56,64}, {-56,65}, {-56,66}, {-55,59}, {-55,60}, {-55,61}, {-55,63}, {-55,64}, {-55,65}, {-55,66}, {-55,67}, {-54,59}, {-54,60}, {-54,61}, {-54,62}, {-54,63}, {-54,64}, {-54,65}, {-54,66}, {-54,67}, {-54,68}, {-53,62}, {-53,63}, {-53,64}, {-53,65}, {-53,66}, {-53,67}, {-53,68}, {-53,69}, {-52,62}, {-52,64}, {-52,65}, {-52,66}, {-52,67}, {-52,68}, {-52,69}, {-52,70}, {-52,76}, {-52,77}, {-52,78}, {-52,79}, {-52,80}, {-52,83}, {-52,84}, {-52,85}, {-52,86}, {-52,87}, {-52,88}, {-52,89}, {-52,90}, {-52,91}, {-51,49}, {-51,62}, {-51,65}, {-51,66}, {-51,67}, {-51,68}, {-51,69}, {-51,70}, {-51,76}, {-51,77}, {-51,78}, {-51,79}, {-51,80}, {-51,83}, {-51,84}, {-51,85}, {-51,86}, {-51,87}, {-51,88}, {-51,89}, {-51,90}, {-51,91}, {-50,62}, {-50,63}, {-50,64}, {-50,65}, {-50,66}, {-50,67}, {-50,68}, {-50,69}, {-50,70}, {-50,76}, {-50,77}, {-50,78}, {-50,79}, {-50,80}, {-50,83}, {-50,84}, {-50,85}, {-50,86}, {-50,87}, {-50,88}, {-50,89}, {-50,90}, {-50,91}, {-49,62}, {-49,64}, {-49,66}, {-49,67}, {-49,68}, {-49,69}, {-49,70}, {-49,76}, {-49,77}, {-49,78}, {-49,79}, {-49,80}, {-49,83}, {-49,84}, {-49,85}, {-49,86}, {-49,87}, {-49,88}, {-49,89}, {-49,90}, {-49,91}, {-48,64}, {-48,67}, {-48,68}, {-48,69}, {-48,70}, {-48,71}, {-48,76}, {-48,77}, {-48,78}, {-48,79}, {-48,80}, {-48,83}, {-48,84}, {-48,85}, {-48,86}, {-48,87}, {-48,88}, {-48,89}, {-48,90}, {-48,91}, {-47,64}, {-47,65}, {-47,66}, {-47,67}, {-47,75}, {-47,76}, {-47,77}, {-47,78}, {-47,79}, {-47,84}, {-47,85}, {-47,86}, {-47,87}, {-47,88}, {-47,89}, {-47,90}, {-47,91}, {-46,62}, {-46,66}, {-45,64}, {-45,66}, {-44,64}, {-44,65}, {-44,66}, {-43,65}, {-43,66}, {-43,67}, {-43,75}, {-43,76}, {-43,77}, {-43,78}, {-43,79}, {-43,84}, {-43,85}, {-43,86}, {-43,87}, {-43,88}, {-43,89}, {-43,90}, {-43,91}, {-42,63}, {-42,64}, {-42,66}, {-42,68}, {-42,69}, {-42,70}, {-42,71}, {-42,76}, {-42,77}, {-42,78}, {-42,79}, {-42,80}, {-42,83}, {-42,84}, {-42,85}, {-42,86}, {-42,87}, {-42,88}, {-42,89}, {-42,90}, {-42,91}, {-41,64}, {-41,66}, {-41,67}, {-41,68}, {-41,69}, {-41,70}, {-41,76}, {-41,77}, {-41,78}, {-41,79}, {-41,80}, {-41,83}, {-41,84}, {-41,85}, {-41,86}, {-41,87}, {-41,88}, {-41,89}, {-41,90}, {-41,91}, {-40,63}, {-40,64}, {-40,65}, {-40,66}, {-40,67}, {-40,68}, {-40,69}, {-40,70}, {-40,76}, {-40,77}, {-40,78}, {-40,79}, {-40,80}, {-40,83}, {-40,84}, {-40,85}, {-40,86}, {-40,87}, {-40,88}, {-40,89}, {-40,90}, {-40,91}, {-39,49}, {-39,62}, {-39,63}, {-39,65}, {-39,66}, {-39,67}, {-39,68}, {-39,69}, {-39,70}, {-39,76}, {-39,77}, {-39,78}, {-39,79}, {-39,80}, {-39,83}, {-39,84}, {-39,85}, {-39,86}, {-39,87}, {-39,88}, {-39,89}, {-39,90}, {-39,91}, {-38,62}, {-38,63}, {-38,64}, {-38,65}, {-38,66}, {-38,67}, {-38,68}, {-38,69}, {-38,70}, {-38,76}, {-38,77}, {-38,78}, {-38,79}, {-38,80}, {-38,83}, {-38,84}, {-38,85}, {-38,86}, {-38,87}, {-38,88}, {-38,89}, {-38,90}, {-38,91}, {-37,62}, {-37,64}, {-37,65}, {-37,66}, {-37,67}, {-37,68}, {-37,69}, {-36,61}, {-36,62}, {-36,63}, {-36,64}, {-36,65}, {-36,66}, {-36,67}, {-36,68}, {-35,59}, {-35,60}, {-35,64}, {-35,65}, {-35,66}, {-35,67}, {-34,57}, {-34,58}, {-34,61}, {-34,62}, {-34,63}, {-34,64}, {-34,65}, {-34,66}, {-33,56}, {-33,57}, {-33,58}, {-33,59}, {-33,60}, {-33,61}, {-33,62}, {-33,63}, {-33,64}, {-33,65}, {-32,56}, {-32,64}, {9,77}, {9,78}, {9,79}, {9,80}, {9,81}, {9,82}, {9,83}, {10,77}, {10,78}, {10,79}, {10,80}, {10,81}, {10,82}, {10,83}, {11,77}, {11,78}, {11,79}, {11,80}, {11,81}, {11,82}, {11,83}, {12,78}, {12,79}, {12,80}, {12,81}, {12,82}, {13,78}, {13,79}, {13,80}, {13,81}, {13,82}, {14,78}, {14,79}, {14,80}, {14,81}, {14,82}, {15,75}, {15,76}, {15,77}, {15,78}, {15,79}, {15,80}, {15,81}, {15,82}, {15,83}, {15,84}, {15,85}, {17,75}, {17,76}, {17,77}, {17,78}, {17,79}, {17,80}, {17,81}, {17,82}, {17,83}, {17,84}, {17,85}, {18,78}, {18,79}, {18,80}, {18,81}, {18,82}, {19,78}, {19,79}, {19,80}, {19,81}, {19,82}, {20,78}, {20,79}, {20,80}, {20,81}, {20,82}, {21,77}, {21,78}, {21,79}, {21,80}, {21,81}, {21,82}, {21,83}, {22,77}, {22,78}, {22,79}, {22,80}, {22,81}, {22,82}, {22,83}, {23,77}, {23,78}, {23,79}, {23,80}, {23,81}, {23,82}, {23,83}, {69,94}, {69,95}, {69,96}, {70,93}, {70,94}, {70,95}, {70,96}, {70,97}, {71,92}, {71,93}, {71,94}, {71,95}, {71,96}, {71,97}, {71,98}, {72,92}, {72,93}, {72,94}, {72,95}, {72,96}, {72,97}, {72,98}, {73,92}, {73,93}, {73,94}, {73,95}, {73,96}, {73,97}, {73,98}, {74,93}, {74,94}, {74,95}, {74,96}, {74,97}, {75,94}, {75,95}, {75,96}, },
    ["deepwater"] = {{-57,55}, {-57,56}, {-56,54}, {-56,55}, {-56,56}, {-56,59}, {-55,53}, {-55,54}, {-55,55}, {-55,56}, {-55,57}, {-55,58}, {-55,62}, {-54,52}, {-54,53}, {-54,54}, {-54,55}, {-54,56}, {-54,57}, {-54,58}, {-53,51}, {-53,52}, {-53,53}, {-53,54}, {-53,55}, {-53,56}, {-53,57}, {-53,58}, {-53,59}, {-53,60}, {-53,61}, {-52,50}, {-52,51}, {-52,52}, {-52,53}, {-52,54}, {-52,55}, {-52,56}, {-52,57}, {-52,58}, {-52,59}, {-52,60}, {-52,61}, {-52,63}, {-51,50}, {-51,51}, {-51,52}, {-51,53}, {-51,54}, {-51,55}, {-51,56}, {-51,57}, {-51,58}, {-51,59}, {-51,60}, {-51,61}, {-51,63}, {-51,64}, {-50,50}, {-50,51}, {-50,52}, {-50,53}, {-50,54}, {-50,55}, {-50,56}, {-50,57}, {-50,58}, {-50,59}, {-50,60}, {-50,61}, {-49,50}, {-49,51}, {-49,52}, {-49,53}, {-49,54}, {-49,55}, {-49,56}, {-49,57}, {-49,58}, {-49,59}, {-49,60}, {-49,61}, {-49,63}, {-49,65}, {-48,50}, {-48,51}, {-48,52}, {-48,53}, {-48,54}, {-48,55}, {-48,56}, {-48,57}, {-48,58}, {-48,59}, {-48,60}, {-48,61}, {-48,62}, {-48,63}, {-48,65}, {-48,66}, {-47,50}, {-47,51}, {-47,52}, {-47,53}, {-47,54}, {-47,55}, {-47,56}, {-47,57}, {-47,58}, {-47,59}, {-47,60}, {-47,61}, {-47,62}, {-47,63}, {-46,50}, {-46,51}, {-46,52}, {-46,53}, {-46,54}, {-46,55}, {-46,56}, {-46,57}, {-46,58}, {-46,59}, {-46,60}, {-46,61}, {-46,63}, {-46,64}, {-46,65}, {-45,50}, {-45,51}, {-45,52}, {-45,53}, {-45,54}, {-45,55}, {-45,56}, {-45,57}, {-45,58}, {-45,59}, {-45,60}, {-45,61}, {-45,62}, {-45,63}, {-45,65}, {-44,50}, {-44,51}, {-44,52}, {-44,53}, {-44,54}, {-44,55}, {-44,56}, {-44,57}, {-44,58}, {-44,59}, {-44,60}, {-44,61}, {-44,62}, {-44,63}, {-43,50}, {-43,51}, {-43,52}, {-43,53}, {-43,54}, {-43,55}, {-43,56}, {-43,57}, {-43,58}, {-43,59}, {-43,60}, {-43,61}, {-43,62}, {-43,63}, {-43,64}, {-42,50}, {-42,51}, {-42,52}, {-42,53}, {-42,54}, {-42,55}, {-42,56}, {-42,57}, {-42,58}, {-42,59}, {-42,60}, {-42,61}, {-42,62}, {-42,65}, {-42,67}, {-41,50}, {-41,51}, {-41,52}, {-41,53}, {-41,54}, {-41,55}, {-41,56}, {-41,57}, {-41,58}, {-41,59}, {-41,60}, {-41,61}, {-41,62}, {-41,63}, {-41,65}, {-40,50}, {-40,51}, {-40,52}, {-40,53}, {-40,54}, {-40,55}, {-40,56}, {-40,57}, {-40,58}, {-40,59}, {-40,60}, {-40,61}, {-40,62}, {-39,50}, {-39,51}, {-39,52}, {-39,53}, {-39,54}, {-39,55}, {-39,56}, {-39,57}, {-39,58}, {-39,59}, {-39,60}, {-39,61}, {-39,64}, {-38,50}, {-38,51}, {-38,52}, {-38,53}, {-38,54}, {-38,55}, {-38,56}, {-38,57}, {-38,58}, {-38,59}, {-38,60}, {-38,61}, {-37,51}, {-37,52}, {-37,53}, {-37,54}, {-37,55}, {-37,56}, {-37,57}, {-37,58}, {-37,59}, {-37,60}, {-37,61}, {-37,63}, {-36,52}, {-36,53}, {-36,54}, {-36,55}, {-36,56}, {-36,57}, {-36,58}, {-36,59}, {-36,60}, {-35,53}, {-35,54}, {-35,55}, {-35,56}, {-35,57}, {-35,58}, {-35,61}, {-35,62}, {-35,63}, {-34,54}, {-34,55}, {-34,56}, {-34,59}, {-34,60}, {-33,55}, },
    ["water-shallow"] = {{12,77}, {12,83}, {13,77}, {13,83}, {14,76}, {14,77}, {14,83}, {14,84}, {18,76}, {18,77}, {18,83}, {18,84}, {19,77}, {19,83}, {20,77}, {20,83}, {68,94}, {68,95}, {68,96}, {69,93}, {69,97}, {70,92}, {70,98}, {71,91}, {71,99}, {72,91}, {72,99}, {73,91}, {73,99}, {74,92}, {74,98}, {75,93}, {75,97}, {76,94}, {76,95}, {76,96}, },
  },
  blueprint_strings = {
    { xadj = -2, yadj = 14, force_override = "ignore",
      string = "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"
    }
  }
}
return persepolis
