-- Note: Default entity force will be 'capture', if a player character get near and there are no enemies the player will capture the entity.
local satellite2 = {
  center = {x = 0, y = -1},
  landing_offset = {-21,-8}, -- only used in the satelliet blueprint, not normal ruins
  force_name = "friendly",
  clear_entity_areas = {
    {{-32,-32},{32,32}},
  },
  ---@param surface LuaSurface
  ---@param ruin_position MapPosition.0
  ---@param ruin RuinInfo
  prebuild = function(surface, ruin_position, ruin) -- surface, position, self (DO NOT MODFY SELF)
    -- function that runs before tiles and entities are added
    -- reveal larger tahn normal radius
    surface.request_to_generate_chunks(ruin_position, 4)
    surface.force_generate_chunk_requests() -- must be generated to place
  end,
  ---@param surface LuaSurface
  ---@param ruin_position MapPosition.0
  ---@param ruin RuinInfo
  ---@param built_entities Collection<LuaEntity>
  postbuild = function(surface, ruin_position, ruin, built_entities)

    local container_items = {
      {
        {name = "automation-science-pack", count = 400},
        {name = "logistic-science-pack", count = 400},
        {name = "chemical-science-pack", count = 400},
        {name = mod_prefix.."rocket-science-pack", count = 400},
      },
      {
        {name = "se-space-manufactory", count =  1},
        {name = "iron-plate", count =  500},
        {name = "copper-plate", count =  500},
        {name = mod_prefix.."beryllium-plate", count = 500},
      },
      {
        {name = mod_prefix.."vulcanite-block", count = 100},
        {name = "sulfur", count =  500},
        {name = "stone", count =  500},
        {name = "coal", count =  500},
      },
      {
        {name = mod_prefix.."space-platform-plating", count = 200},
        {name = mod_prefix.."space-platform-scaffold", count = 200},
        {name = mod_prefix.."space-rail", count = 100},
        {name = "solar-panel", count = 10},
      },
      {
        {name = mod_prefix.."space-pipe", count = 400},
        {name = mod_prefix.."deep-space-transport-belt-yellow", count = 200},
        {name = mod_prefix.."deep-space-splitter-yellow", count = 10},
        {name = mod_prefix.."deep-space-underground-belt-yellow", count = 20},
      },
      {
        {name = mod_prefix.."pylon", count = 10},
        {name = mod_prefix.."pylon-substation", count = 1},
        {name = mod_prefix.."pylon-construction", count = 1},
      },
      {
        {name = mod_prefix.."space-capsule", count = 1},
        {name = "cargo-landing-pad", count = 1},
        {name = mod_prefix.."delivery-cannon-chest", count = 1},
      },
      {
        {name = "water-barrel", count = 200},
        {name = "lubricant-barrel", count = 10},
        {name = "heavy-oil-barrel", count = 100},
      },
      {
        {name = "raw-fish", count = 10},
        {name = mod_prefix.."medpack-4", count = 10},
      },
      {
        {name = mod_prefix.."biogun", count=1},
        {name = mod_prefix.."bloater-ammo", count=200},
        {name = mod_prefix.."cryogun", count=1},
        {name = mod_prefix.."cryogun-ammo", count=200},
      },
    }

    if script.active_mods["Krastorio2"] then
      table.insert(container_items, {
        {name = "kr-advanced-lab", count = 1},
        {name = "se-recycling-facility", count = 1},
      })
    else
      table.insert(container_items, {
        {name = "se-space-science-lab", count = 1},
        {name = "se-recycling-facility", count = 1},
      })
    end

    local containers = {}
    for entity in pairs(built_entities) do
      local entity_name = entity.name
      local entity_type = entity.type
      if entity_type == "container" or entity_type == "logistic-container" then
        table.insert(containers, entity)
      end
      if entity_name == "se-water-ice" then
        entity.amount = math.random(800, 1400)
      end
      if entity_type == "simple-entity-with-force" then
        entity.force = "neutral"
      end
    end

    util.shuffle(containers)
    for i = 1, math.min(#containers, #container_items) do
      local container = containers[i]
      local insert_items = container_items[i]
      for _, item in pairs(insert_items) do
        container.insert({name = item.name, count = item.count or 1})
      end
    end
  end,
  tiles = {
    ["se-space"] = {{-63,0}, {-63,1}, {-63,2}, {-63,3}, {-63,4}, {-63,5}, {-63,6}, {-63,7}, {-63,8}, {-63,9}, {-62,-21}, {-62,-20}, {-62,-19}, {-62,-6}, {-62,-5}, {-62,-4}, {-62,-3}, {-62,-2}, {-62,-1}, {-62,0}, {-62,1}, {-62,2}, {-62,3}, {-62,4}, {-62,5}, {-62,6}, {-62,7}, {-62,8}, {-62,9}, {-62,10}, {-62,11}, {-62,12}, {-62,13}, {-61,-23}, {-61,-22}, {-61,-21}, {-61,-20}, {-61,-19}, {-61,-18}, {-61,-17}, {-61,-16}, {-61,-15}, {-61,-14}, {-61,-13}, {-61,-12}, {-61,-11}, {-61,-10}, {-61,-9}, {-61,-8}, {-61,-7}, {-61,-6}, {-61,-5}, {-61,-4}, {-61,-3}, {-61,-2}, {-61,-1}, {-61,0}, {-61,1}, {-61,2}, {-61,3}, {-61,4}, {-61,5}, {-61,6}, {-61,7}, {-61,8}, {-61,9}, {-61,10}, {-61,11}, {-61,12}, {-61,13}, {-61,14}, {-61,15}, {-61,16}, {-61,37}, {-61,38}, {-61,39}, {-60,-25}, {-60,-24}, {-60,-23}, {-60,-22}, {-60,-21}, {-60,-20}, {-60,-19}, {-60,-18}, {-60,-17}, {-60,-16}, {-60,-15}, {-60,-14}, {-60,-13}, {-60,-12}, {-60,-11}, {-60,-10}, {-60,-9}, {-60,-8}, {-60,-7}, {-60,-6}, {-60,-5}, {-60,-4}, {-60,-3}, {-60,-2}, {-60,-1}, {-60,0}, {-60,1}, {-60,2}, {-60,3}, {-60,4}, {-60,5}, {-60,6}, {-60,7}, {-60,8}, {-60,9}, {-60,10}, {-60,11}, {-60,12}, {-60,13}, {-60,14}, {-60,15}, {-60,16}, {-60,17}, {-60,18}, {-60,19}, {-60,20}, {-60,21}, {-60,22}, {-60,23}, {-60,24}, {-60,25}, {-60,26}, {-60,27}, {-60,28}, {-60,29}, {-60,30}, {-60,31}, {-60,32}, {-60,33}, {-60,34}, {-60,35}, {-60,36}, {-60,37}, {-60,38}, {-60,39}, {-60,40}, {-59,-27}, {-59,-26}, {-59,-25}, {-59,-24}, {-59,-23}, {-59,-22}, {-59,-21}, {-59,-20}, {-59,-19}, {-59,-18}, {-59,-17}, {-59,-16}, {-59,-15}, {-59,-14}, {-59,-13}, {-59,-12}, {-59,-11}, {-59,-10}, {-59,-9}, {-59,-8}, {-59,-7}, {-59,-6}, {-59,-5}, {-59,-4}, {-59,-3}, {-59,-2}, {-59,-1}, {-59,0}, {-59,1}, {-59,2}, {-59,3}, {-59,4}, {-59,5}, {-59,6}, {-59,7}, {-59,8}, {-59,9}, {-59,10}, {-59,11}, {-59,12}, {-59,13}, {-59,14}, {-59,15}, {-59,16}, {-59,17}, {-59,18}, {-59,19}, {-59,20}, {-59,21}, {-59,22}, {-59,23}, {-59,24}, {-59,25}, {-59,26}, {-59,27}, {-59,28}, {-59,29}, {-59,30}, {-59,31}, {-59,32}, {-59,33}, {-59,34}, {-59,35}, {-59,36}, {-59,37}, {-59,38}, {-59,39}, {-59,40}, {-59,41}, {-58,-28}, {-58,-27}, {-58,-26}, {-58,-25}, {-58,-24}, {-58,-23}, {-58,-22}, {-58,-21}, {-58,-20}, {-58,-19}, {-58,-18}, {-58,-17}, {-58,-16}, {-58,-15}, {-58,-14}, {-58,-13}, {-58,-12}, {-58,-11}, {-58,-10}, {-58,-9}, {-58,-8}, {-58,-7}, {-58,-6}, {-58,-5}, {-58,-4}, {-58,-3}, {-58,-2}, {-58,-1}, {-58,0}, {-58,1}, {-58,2}, {-58,3}, {-58,4}, {-58,5}, {-58,6}, {-58,7}, {-58,8}, {-58,9}, {-58,10}, {-58,11}, {-58,12}, {-58,13}, {-58,14}, {-58,15}, {-58,16}, {-58,17}, {-58,18}, {-58,19}, {-58,20}, {-58,21}, {-58,22}, {-58,23}, {-58,24}, {-58,25}, {-58,26}, {-58,27}, {-58,28}, {-58,29}, {-58,30}, {-58,31}, {-58,32}, {-58,33}, {-58,34}, {-58,35}, {-58,36}, {-58,37}, {-58,38}, {-58,39}, {-58,40}, {-58,41}, {-58,42}, {-57,-29}, {-57,-28}, {-57,-27}, {-57,-26}, {-57,-25}, {-57,-24}, {-57,-23}, {-57,-22}, {-57,-21}, {-57,-20}, {-57,-19}, {-57,-18}, {-57,-17}, {-57,-16}, {-57,-15}, {-57,-14}, {-57,-13}, {-57,-12}, {-57,-11}, {-57,-10}, {-57,-9}, {-57,-8}, {-57,-7}, {-57,-6}, {-57,-5}, {-57,-4}, {-57,-3}, {-57,-2}, {-57,-1}, {-57,0}, {-57,1}, {-57,2}, {-57,3}, {-57,4}, {-57,5}, {-57,6}, {-57,7}, {-57,8}, {-57,9}, {-57,10}, {-57,11}, {-57,12}, {-57,13}, {-57,14}, {-57,15}, {-57,16}, {-57,17}, {-57,18}, {-57,19}, {-57,20}, {-57,21}, {-57,22}, {-57,23}, {-57,24}, {-57,25}, {-57,26}, {-57,27}, {-57,28}, {-57,29}, {-57,30}, {-57,31}, {-57,32}, {-57,33}, {-57,34}, {-57,35}, {-57,36}, {-57,37}, {-57,38}, {-57,39}, {-57,40}, {-57,41}, {-57,42}, {-57,43}, {-57,44}, {-56,-30}, {-56,-29}, {-56,-28}, {-56,-27}, {-56,-26}, {-56,-25}, {-56,-24}, {-56,-23}, {-56,-22}, {-56,-21}, {-56,-20}, {-56,-19}, {-56,-18}, {-56,-17}, {-56,-16}, {-56,-15}, {-56,-14}, {-56,-13}, {-56,-12}, {-56,-11}, {-56,-10}, {-56,-9}, {-56,-8}, {-56,-7}, {-56,-6}, {-56,-5}, {-56,-4}, {-56,-3}, {-56,-2}, {-56,-1}, {-56,0}, {-56,1}, {-56,2}, {-56,3}, {-56,4}, {-56,5}, {-56,6}, {-56,7}, {-56,8}, {-56,9}, {-56,10}, {-56,11}, {-56,12}, {-56,13}, {-56,14}, {-56,15}, {-56,16}, {-56,17}, {-56,18}, {-56,19}, {-56,20}, {-56,21}, {-56,22}, {-56,23}, {-56,24}, {-56,25}, {-56,26}, {-56,27}, {-56,28}, {-56,29}, {-56,30}, {-56,31}, {-56,32}, {-56,33}, {-56,34}, {-56,35}, {-56,36}, {-56,37}, {-56,38}, {-56,39}, {-56,40}, {-56,41}, {-56,42}, {-56,43}, {-56,44}, {-56,45}, {-55,-32}, {-55,-31}, {-55,-30}, {-55,-29}, {-55,-28}, {-55,-27}, {-55,-26}, {-55,-25}, {-55,-24}, {-55,-23}, {-55,-22}, {-55,-21}, {-55,-20}, {-55,-19}, {-55,-18}, {-55,-17}, {-55,-16}, {-55,-15}, {-55,-14}, {-55,-13}, {-55,-12}, {-55,-11}, {-55,-10}, {-55,-9}, {-55,-8}, {-55,-7}, {-55,-6}, {-55,-5}, {-55,-4}, {-55,-3}, {-55,-2}, {-55,-1}, {-55,0}, {-55,1}, {-55,2}, {-55,3}, {-55,4}, {-55,5}, {-55,6}, {-55,7}, {-55,8}, {-55,9}, {-55,10}, {-55,11}, {-55,12}, {-55,13}, {-55,14}, {-55,15}, {-55,16}, {-55,17}, {-55,18}, {-55,19}, {-55,20}, {-55,21}, {-55,22}, {-55,23}, {-55,24}, {-55,25}, {-55,26}, {-55,27}, {-55,28}, {-55,29}, {-55,30}, {-55,31}, {-55,32}, {-55,33}, {-55,34}, {-55,35}, {-55,36}, {-55,37}, {-55,38}, {-55,39}, {-55,40}, {-55,41}, {-55,42}, {-55,43}, {-55,44}, {-55,45}, {-55,46}, {-54,-34}, {-54,-33}, {-54,-32}, {-54,-31}, {-54,-30}, {-54,-29}, {-54,-28}, {-54,-27}, {-54,-26}, {-54,-25}, {-54,-24}, {-54,-23}, {-54,-22}, {-54,-21}, {-54,-20}, {-54,-19}, {-54,-18}, {-54,-17}, {-54,-16}, {-54,-15}, {-54,-14}, {-54,-13}, {-54,-12}, {-54,-11}, {-54,-10}, {-54,-9}, {-54,-8}, {-54,-7}, {-54,-6}, {-54,-5}, {-54,-4}, {-54,-3}, {-54,-2}, {-54,-1}, {-54,0}, {-54,1}, {-54,2}, {-54,3}, {-54,4}, {-54,5}, {-54,6}, {-54,7}, {-54,8}, {-54,9}, {-54,10}, {-54,11}, {-54,12}, {-54,13}, {-54,14}, {-54,15}, {-54,16}, {-54,17}, {-54,18}, {-54,19}, {-54,20}, {-54,21}, {-54,22}, {-54,23}, {-54,24}, {-54,25}, {-54,26}, {-54,27}, {-54,28}, {-54,29}, {-54,30}, {-54,31}, {-54,32}, {-54,33}, {-54,34}, {-54,35}, {-54,36}, {-54,37}, {-54,38}, {-54,39}, {-54,40}, {-54,41}, {-54,42}, {-54,43}, {-54,44}, {-54,45}, {-54,46}, {-53,-36}, {-53,-35}, {-53,-34}, {-53,-33}, {-53,-32}, {-53,-31}, {-53,-30}, {-53,-29}, {-53,-28}, {-53,-27}, {-53,-26}, {-53,-25}, {-53,-24}, {-53,-23}, {-53,-22}, {-53,-21}, {-53,-20}, {-53,-19}, {-53,-18}, {-53,-17}, {-53,-16}, {-53,-15}, {-53,-14}, {-53,-13}, {-53,-12}, {-53,-11}, {-53,-10}, {-53,-9}, {-53,-8}, {-53,-7}, {-53,-6}, {-53,-5}, {-53,-4}, {-53,-3}, {-53,-2}, {-53,-1}, {-53,0}, {-53,1}, {-53,2}, {-53,3}, {-53,4}, {-53,5}, {-53,6}, {-53,7}, {-53,8}, {-53,9}, {-53,10}, {-53,11}, {-53,12}, {-53,13}, {-53,14}, {-53,15}, {-53,16}, {-53,17}, {-53,18}, {-53,19}, {-53,20}, {-53,21}, {-53,22}, {-53,23}, {-53,24}, {-53,25}, {-53,26}, {-53,27}, {-53,28}, {-53,29}, {-53,30}, {-53,31}, {-53,32}, {-53,33}, {-53,34}, {-53,35}, {-53,36}, {-53,37}, {-53,38}, {-53,39}, {-53,40}, {-53,41}, {-53,42}, {-53,43}, {-53,44}, {-53,45}, {-53,46}, {-53,47}, {-52,-39}, {-52,-38}, {-52,-37}, {-52,-36}, {-52,-35}, {-52,-34}, {-52,-33}, {-52,-32}, {-52,-31}, {-52,-30}, {-52,-29}, {-52,-28}, {-52,-27}, {-52,-26}, {-52,-25}, {-52,-24}, {-52,-23}, {-52,-22}, {-52,-21}, {-52,-20}, {-52,-19}, {-52,-18}, {-52,-17}, {-52,-16}, {-52,-15}, {-52,-14}, {-52,-13}, {-52,-12}, {-52,-11}, {-52,-10}, {-52,-9}, {-52,-8}, {-52,-7}, {-52,-6}, {-52,-5}, {-52,-4}, {-52,-3}, {-52,-2}, {-52,-1}, {-52,0}, {-52,1}, {-52,2}, {-52,3}, {-52,4}, {-52,5}, {-52,6}, {-52,7}, {-52,8}, {-52,9}, {-52,10}, {-52,11}, {-52,12}, {-52,13}, {-52,14}, {-52,15}, {-52,16}, {-52,17}, {-52,18}, {-52,19}, {-52,20}, {-52,21}, {-52,22}, {-52,23}, {-52,24}, {-52,25}, {-52,26}, {-52,27}, {-52,28}, {-52,29}, {-52,30}, {-52,31}, {-52,32}, {-52,33}, {-52,34}, {-52,35}, {-52,36}, {-52,37}, {-52,38}, {-52,39}, {-52,40}, {-52,41}, {-52,42}, {-52,43}, {-52,44}, {-52,45}, {-52,46}, {-52,47}, {-51,-41}, {-51,-40}, {-51,-39}, {-51,-38}, {-51,-37}, {-51,-36}, {-51,-35}, {-51,-34}, {-51,-33}, {-51,-32}, {-51,-31}, {-51,-30}, {-51,-29}, {-51,-28}, {-51,-27}, {-51,-26}, {-51,-25}, {-51,-24}, {-51,-23}, {-51,-22}, {-51,-21}, {-51,-20}, {-51,-19}, {-51,-18}, {-51,-17}, {-51,-16}, {-51,-15}, {-51,-14}, {-51,-13}, {-51,-12}, {-51,-11}, {-51,-10}, {-51,-9}, {-51,-8}, {-51,-7}, {-51,-6}, {-51,-5}, {-51,-4}, {-51,-3}, {-51,-2}, {-51,-1}, {-51,0}, {-51,1}, {-51,2}, {-51,3}, {-51,4}, {-51,5}, {-51,6}, {-51,7}, {-51,8}, {-51,9}, {-51,10}, {-51,11}, {-51,12}, {-51,13}, {-51,14}, {-51,15}, {-51,16}, {-51,17}, {-51,18}, {-51,19}, {-51,20}, {-51,21}, {-51,22}, {-51,23}, {-51,24}, {-51,25}, {-51,26}, {-51,27}, {-51,28}, {-51,29}, {-51,30}, {-51,31}, {-51,32}, {-51,33}, {-51,34}, {-51,35}, {-51,36}, {-51,37}, {-51,38}, {-51,39}, {-51,40}, {-51,41}, {-51,42}, {-51,43}, {-51,44}, {-51,45}, {-51,46}, {-51,47}, {-51,48}, {-50,-42}, {-50,-41}, {-50,-40}, {-50,-39}, {-50,-38}, {-50,-37}, {-50,-36}, {-50,-35}, {-50,-34}, {-50,-33}, {-50,-32}, {-50,-31}, {-50,-30}, {-50,-29}, {-50,-28}, {-50,-27}, {-50,-26}, {-50,-25}, {-50,-24}, {-50,-23}, {-50,-22}, {-50,-21}, {-50,-20}, {-50,-19}, {-50,-18}, {-50,-17}, {-50,-16}, {-50,-15}, {-50,-14}, {-50,-13}, {-50,-12}, {-50,-11}, {-50,-10}, {-50,-9}, {-50,-8}, {-50,-7}, {-50,-6}, {-50,-5}, {-50,-4}, {-50,-3}, {-50,-2}, {-50,-1}, {-50,0}, {-50,1}, {-50,2}, {-50,3}, {-50,4}, {-50,5}, {-50,6}, {-50,7}, {-50,8}, {-50,9}, {-50,10}, {-50,11}, {-50,12}, {-50,13}, {-50,14}, {-50,15}, {-50,16}, {-50,17}, {-50,18}, {-50,19}, {-50,20}, {-50,21}, {-50,22}, {-50,23}, {-50,24}, {-50,25}, {-50,26}, {-50,27}, {-50,28}, {-50,29}, {-50,30}, {-50,31}, {-50,32}, {-50,33}, {-50,34}, {-50,35}, {-50,36}, {-50,37}, {-50,38}, {-50,39}, {-50,40}, {-50,41}, {-50,42}, {-50,43}, {-50,44}, {-50,45}, {-50,46}, {-50,47}, {-50,48}, {-49,-43}, {-49,-42}, {-49,-41}, {-49,-40}, {-49,-39}, {-49,-38}, {-49,-37}, {-49,-36}, {-49,-35}, {-49,-34}, {-49,-33}, {-49,-32}, {-49,-31}, {-49,-30}, {-49,-29}, {-49,-28}, {-49,-27}, {-49,-26}, {-49,-25}, {-49,-24}, {-49,-23}, {-49,-22}, {-49,-21}, {-49,-20}, {-49,-19}, {-49,-18}, {-49,-17}, {-49,-16}, {-49,-15}, {-49,-14}, {-49,-13}, {-49,-12}, {-49,-11}, {-49,-10}, {-49,-9}, {-49,-8}, {-49,-7}, {-49,-6}, {-49,-5}, {-49,-4}, {-49,-3}, {-49,-2}, {-49,-1}, {-49,0}, {-49,1}, {-49,2}, {-49,3}, {-49,4}, {-49,5}, {-49,6}, {-49,7}, {-49,8}, {-49,9}, {-49,10}, {-49,11}, {-49,12}, {-49,13}, {-49,14}, {-49,15}, {-49,16}, {-49,17}, {-49,18}, {-49,19}, {-49,20}, {-49,21}, {-49,22}, {-49,23}, {-49,24}, {-49,25}, {-49,26}, {-49,27}, {-49,28}, {-49,29}, {-49,30}, {-49,31}, {-49,32}, {-49,33}, {-49,34}, {-49,35}, {-49,36}, {-49,37}, {-49,38}, {-49,39}, {-49,40}, {-49,41}, {-49,42}, {-49,43}, {-49,44}, {-49,45}, {-49,46}, {-49,47}, {-49,48}, {-49,49}, {-48,-44}, {-48,-43}, {-48,-42}, {-48,-41}, {-48,-40}, {-48,-39}, {-48,-38}, {-48,-37}, {-48,-36}, {-48,-35}, {-48,-34}, {-48,-33}, {-48,-32}, {-48,-31}, {-48,-30}, {-48,-29}, {-48,-28}, {-48,-27}, {-48,-26}, {-48,-25}, {-48,-24}, {-48,-23}, {-48,-22}, {-48,-21}, {-48,-20}, {-48,-19}, {-48,-18}, {-48,-17}, {-48,-16}, {-48,-15}, {-48,-14}, {-48,-13}, {-48,-12}, {-48,-11}, {-48,-10}, {-48,-9}, {-48,-8}, {-48,-7}, {-48,-6}, {-48,-5}, {-48,-4}, {-48,-3}, {-48,-2}, {-48,-1}, {-48,0}, {-48,1}, {-48,2}, {-48,3}, {-48,4}, {-48,5}, {-48,6}, {-48,7}, {-48,8}, {-48,9}, {-48,10}, {-48,11}, {-48,12}, {-48,13}, {-48,14}, {-48,15}, {-48,16}, {-48,17}, {-48,18}, {-48,19}, {-48,20}, {-48,21}, {-48,22}, {-48,23}, {-48,24}, {-48,25}, {-48,26}, {-48,27}, {-48,28}, {-48,29}, {-48,30}, {-48,31}, {-48,32}, {-48,33}, {-48,34}, {-48,35}, {-48,36}, {-48,37}, {-48,38}, {-48,39}, {-48,40}, {-48,41}, {-48,42}, {-48,43}, {-48,44}, {-48,45}, {-48,46}, {-48,47}, {-48,48}, {-48,49}, {-47,-45}, {-47,-44}, {-47,-43}, {-47,-42}, {-47,-41}, {-47,-40}, {-47,-39}, {-47,-38}, {-47,-37}, {-47,-36}, {-47,-35}, {-47,-34}, {-47,-33}, {-47,-32}, {-47,-31}, {-47,-30}, {-47,-29}, {-47,-28}, {-47,-27}, {-47,-26}, {-47,-25}, {-47,-24}, {-47,-23}, {-47,-22}, {-47,-21}, {-47,-20}, {-47,-19}, {-47,-18}, {-47,-17}, {-47,-16}, {-47,-15}, {-47,-14}, {-47,-13}, {-47,-12}, {-47,-11}, {-47,-10}, {-47,-9}, {-47,-8}, {-47,-7}, {-47,-6}, {-47,-5}, {-47,-4}, {-47,-3}, {-47,-2}, {-47,-1}, {-47,0}, {-47,1}, {-47,2}, {-47,3}, {-47,4}, {-47,5}, {-47,6}, {-47,7}, {-47,8}, {-47,9}, {-47,10}, {-47,11}, {-47,12}, {-47,13}, {-47,14}, {-47,15}, {-47,16}, {-47,17}, {-47,18}, {-47,19}, {-47,20}, {-47,21}, {-47,22}, {-47,23}, {-47,24}, {-47,25}, {-47,26}, {-47,27}, {-47,28}, {-47,29}, {-47,30}, {-47,31}, {-47,32}, {-47,33}, {-47,34}, {-47,35}, {-47,36}, {-47,37}, {-47,38}, {-47,39}, {-47,40}, {-47,41}, {-47,42}, {-47,43}, {-47,44}, {-47,45}, {-47,46}, {-47,47}, {-47,48}, {-47,49}, {-47,50}, {-46,-46}, {-46,-45}, {-46,-44}, {-46,-43}, {-46,-42}, {-46,-41}, {-46,-40}, {-46,-39}, {-46,-38}, {-46,-37}, {-46,-36}, {-46,-35}, {-46,-34}, {-46,-33}, {-46,-32}, {-46,-31}, {-46,-30}, {-46,-29}, {-46,-28}, {-46,-27}, {-46,-26}, {-46,-25}, {-46,-24}, {-46,-23}, {-46,-22}, {-46,-21}, {-46,-20}, {-46,-19}, {-46,-18}, {-46,-17}, {-46,-16}, {-46,-15}, {-46,-14}, {-46,-13}, {-46,-12}, {-46,-11}, {-46,-10}, {-46,-9}, {-46,-8}, {-46,-7}, {-46,-6}, {-46,-5}, {-46,-4}, {-46,-3}, {-46,-2}, {-46,-1}, {-46,0}, {-46,1}, {-46,2}, {-46,3}, {-46,4}, {-46,5}, {-46,6}, {-46,7}, {-46,8}, {-46,9}, {-46,10}, {-46,11}, {-46,12}, {-46,13}, {-46,14}, {-46,15}, {-46,16}, {-46,17}, {-46,18}, {-46,19}, {-46,20}, {-46,21}, {-46,22}, {-46,23}, {-46,24}, {-46,25}, {-46,26}, {-46,27}, {-46,28}, {-46,29}, {-46,30}, {-46,31}, {-46,32}, {-46,33}, {-46,34}, {-46,35}, {-46,36}, {-46,37}, {-46,38}, {-46,39}, {-46,40}, {-46,41}, {-46,42}, {-46,43}, {-46,44}, {-46,45}, {-46,46}, {-46,47}, {-46,48}, {-46,49}, {-46,50}, {-46,51}, {-45,-47}, {-45,-46}, {-45,-45}, {-45,-44}, {-45,-43}, {-45,-42}, {-45,-41}, {-45,-40}, {-45,-39}, {-45,-38}, {-45,-37}, {-45,-36}, {-45,-35}, {-45,-34}, {-45,-33}, {-45,-32}, {-45,-31}, {-45,-30}, {-45,-29}, {-45,-28}, {-45,-27}, {-45,-26}, {-45,-25}, {-45,-24}, {-45,-23}, {-45,-22}, {-45,-21}, {-45,-20}, {-45,-19}, {-45,-18}, {-45,-17}, {-45,-16}, {-45,-15}, {-45,-14}, {-45,-13}, {-45,-12}, {-45,-11}, {-45,-10}, {-45,-9}, {-45,-8}, {-45,-7}, {-45,-6}, {-45,-5}, {-45,-4}, {-45,-3}, {-45,-2}, {-45,-1}, {-45,0}, {-45,1}, {-45,2}, {-45,3}, {-45,4}, {-45,5}, {-45,6}, {-45,7}, {-45,8}, {-45,9}, {-45,10}, {-45,11}, {-45,12}, {-45,13}, {-45,14}, {-45,15}, {-45,16}, {-45,17}, {-45,18}, {-45,19}, {-45,20}, {-45,21}, {-45,22}, {-45,23}, {-45,24}, {-45,25}, {-45,26}, {-45,27}, {-45,28}, {-45,29}, {-45,30}, {-45,31}, {-45,32}, {-45,33}, {-45,34}, {-45,35}, {-45,36}, {-45,37}, {-45,38}, {-45,39}, {-45,40}, {-45,41}, {-45,42}, {-45,43}, {-45,44}, {-45,45}, {-45,46}, {-45,47}, {-45,48}, {-45,49}, {-45,50}, {-45,51}, {-45,52}, {-44,-49}, {-44,-48}, {-44,-47}, {-44,-46}, {-44,-45}, {-44,-44}, {-44,-43}, {-44,-42}, {-44,-41}, {-44,-40}, {-44,-39}, {-44,-38}, {-44,-37}, {-44,-36}, {-44,-35}, {-44,-34}, {-44,-33}, {-44,-32}, {-44,-31}, {-44,-30}, {-44,-29}, {-44,-28}, {-44,-27}, {-44,-26}, {-44,-25}, {-44,-24}, {-44,-23}, {-44,-22}, {-44,-21}, {-44,-20}, {-44,-19}, {-44,-18}, {-44,-17}, {-44,-16}, {-44,-15}, {-44,-14}, {-44,-13}, {-44,-12}, {-44,-11}, {-44,-10}, {-44,-9}, {-44,-8}, {-44,-7}, {-44,-6}, {-44,-5}, {-44,-4}, {-44,-3}, {-44,-2}, {-44,-1}, {-44,0}, {-44,1}, {-44,2}, {-44,3}, {-44,4}, {-44,5}, {-44,6}, {-44,7}, {-44,8}, {-44,9}, {-44,10}, {-44,11}, {-44,12}, {-44,13}, {-44,14}, {-44,15}, {-44,16}, {-44,17}, {-44,18}, {-44,19}, {-44,20}, {-44,21}, {-44,22}, {-44,23}, {-44,24}, {-44,25}, {-44,26}, {-44,27}, {-44,28}, {-44,29}, {-44,30}, {-44,31}, {-44,32}, {-44,33}, {-44,34}, {-44,35}, {-44,36}, {-44,37}, {-44,38}, {-44,39}, {-44,40}, {-44,41}, {-44,42}, {-44,43}, {-44,44}, {-44,45}, {-44,46}, {-44,47}, {-44,48}, {-44,49}, {-44,50}, {-44,51}, {-44,52}, {-44,53}, {-43,-50}, {-43,-49}, {-43,-48}, {-43,-47}, {-43,-46}, {-43,-45}, {-43,-44}, {-43,-43}, {-43,-42}, {-43,-41}, {-43,-40}, {-43,-39}, {-43,-38}, {-43,-37}, {-43,-36}, {-43,-35}, {-43,-34}, {-43,-33}, {-43,-32}, {-43,-31}, {-43,-30}, {-43,-29}, {-43,-28}, {-43,-27}, {-43,-26}, {-43,-25}, {-43,-24}, {-43,-23}, {-43,-22}, {-43,-21}, {-43,-20}, {-43,-19}, {-43,-18}, {-43,-17}, {-43,-16}, {-43,-15}, {-43,-14}, {-43,-13}, {-43,-12}, {-43,-11}, {-43,-10}, {-43,-9}, {-43,-8}, {-43,-7}, {-43,-6}, {-43,-5}, {-43,-4}, {-43,-3}, {-43,-2}, {-43,-1}, {-43,0}, {-43,1}, {-43,2}, {-43,3}, {-43,4}, {-43,5}, {-43,6}, {-43,7}, {-43,8}, {-43,9}, {-43,10}, {-43,11}, {-43,12}, {-43,13}, {-43,14}, {-43,15}, {-43,16}, {-43,17}, {-43,18}, {-43,19}, {-43,20}, {-43,21}, {-43,22}, {-43,23}, {-43,24}, {-43,25}, {-43,26}, {-43,27}, {-43,28}, {-43,29}, {-43,30}, {-43,31}, {-43,32}, {-43,33}, {-43,34}, {-43,35}, {-43,36}, {-43,37}, {-43,38}, {-43,39}, {-43,40}, {-43,41}, {-43,42}, {-43,43}, {-43,44}, {-43,45}, {-43,46}, {-43,47}, {-43,48}, {-43,49}, {-43,50}, {-43,51}, {-43,52}, {-43,53}, {-42,-52}, {-42,-51}, {-42,-50}, {-42,-49}, {-42,-48}, {-42,-47}, {-42,-46}, {-42,-45}, {-42,-44}, {-42,-43}, {-42,-42}, {-42,-41}, {-42,-40}, {-42,-39}, {-42,-38}, {-42,-37}, {-42,-36}, {-42,-35}, {-42,-34}, {-42,-33}, {-42,-32}, {-42,-31}, {-42,-30}, {-42,-29}, {-42,-28}, {-42,-27}, {-42,-26}, {-42,-25}, {-42,-24}, {-42,-23}, {-42,-22}, {-42,-21}, {-42,-20}, {-42,-19}, {-42,-18}, {-42,-17}, {-42,-16}, {-42,-15}, {-42,-14}, {-42,-13}, {-42,-12}, {-42,-11}, {-42,-10}, {-42,-9}, {-42,-8}, {-42,-7}, {-42,-6}, {-42,-5}, {-42,-4}, {-42,-3}, {-42,-2}, {-42,-1}, {-42,0}, {-42,1}, {-42,2}, {-42,3}, {-42,4}, {-42,5}, {-42,6}, {-42,7}, {-42,8}, {-42,9}, {-42,10}, {-42,11}, {-42,12}, {-42,13}, {-42,14}, {-42,15}, {-42,16}, {-42,17}, {-42,18}, {-42,19}, {-42,20}, {-42,21}, {-42,22}, {-42,23}, {-42,24}, {-42,25}, {-42,26}, {-42,27}, {-42,28}, {-42,29}, {-42,30}, {-42,31}, {-42,32}, {-42,33}, {-42,34}, {-42,35}, {-42,36}, {-42,37}, {-42,38}, {-42,39}, {-42,40}, {-42,41}, {-42,42}, {-42,43}, {-42,44}, {-42,45}, {-42,46}, {-42,47}, {-42,48}, {-42,49}, {-42,50}, {-42,51}, {-42,52}, {-42,53}, {-42,54}, {-41,-52}, {-41,-51}, {-41,-50}, {-41,-49}, {-41,-48}, {-41,-47}, {-41,-46}, {-41,-45}, {-41,-44}, {-41,-43}, {-41,-42}, {-41,-41}, {-41,-40}, {-41,-39}, {-41,-38}, {-41,-37}, {-41,-36}, {-41,-35}, {-41,-34}, {-41,-33}, {-41,-32}, {-41,-31}, {-41,-30}, {-41,-29}, {-41,-28}, {-41,-27}, {-41,-26}, {-41,-25}, {-41,-24}, {-41,-23}, {-41,-22}, {-41,-21}, {-41,-20}, {-41,-19}, {-41,-18}, {-41,-17}, {-41,-16}, {-41,-15}, {-41,-14}, {-41,-13}, {-41,-12}, {-41,-11}, {-41,-10}, {-41,-9}, {-41,-8}, {-41,-7}, {-41,-6}, {-41,-5}, {-41,-4}, {-41,-3}, {-41,-2}, {-41,-1}, {-41,0}, {-41,1}, {-41,2}, {-41,3}, {-41,4}, {-41,5}, {-41,6}, {-41,7}, {-41,8}, {-41,9}, {-41,10}, {-41,11}, {-41,12}, {-41,13}, {-41,14}, {-41,15}, {-41,16}, {-41,17}, {-41,18}, {-41,19}, {-41,20}, {-41,21}, {-41,22}, {-41,23}, {-41,24}, {-41,25}, {-41,26}, {-41,27}, {-41,28}, {-41,29}, {-41,30}, {-41,31}, {-41,32}, {-41,33}, {-41,34}, {-41,35}, {-41,36}, {-41,37}, {-41,38}, {-41,39}, {-41,40}, {-41,41}, {-41,42}, {-41,43}, {-41,44}, {-41,45}, {-41,46}, {-41,47}, {-41,48}, {-41,49}, {-41,50}, {-41,51}, {-41,52}, {-41,53}, {-41,54}, {-41,55}, {-40,-52}, {-40,-51}, {-40,-50}, {-40,-49}, {-40,-48}, {-40,-47}, {-40,-46}, {-40,-45}, {-40,-44}, {-40,-43}, {-40,-42}, {-40,-41}, {-40,-40}, {-40,-39}, {-40,-38}, {-40,-37}, {-40,-36}, {-40,-35}, {-40,-34}, {-40,-33}, {-40,-32}, {-40,-31}, {-40,-30}, {-40,-29}, {-40,-28}, {-40,-27}, {-40,-26}, {-40,-25}, {-40,-24}, {-40,-23}, {-40,-22}, {-40,-21}, {-40,-20}, {-40,-19}, {-40,-18}, {-40,-17}, {-40,-16}, {-40,-15}, {-40,-14}, {-40,-13}, {-40,-12}, {-40,-11}, {-40,-10}, {-40,-9}, {-40,-8}, {-40,-7}, {-40,-6}, {-40,-5}, {-40,-4}, {-40,-3}, {-40,-2}, {-40,-1}, {-40,0}, {-40,1}, {-40,2}, {-40,3}, {-40,4}, {-40,5}, {-40,6}, {-40,7}, {-40,8}, {-40,9}, {-40,10}, {-40,11}, {-40,12}, {-40,13}, {-40,14}, {-40,15}, {-40,16}, {-40,17}, {-40,18}, {-40,19}, {-40,20}, {-40,21}, {-40,22}, {-40,23}, {-40,24}, {-40,25}, {-40,26}, {-40,27}, {-40,28}, {-40,29}, {-40,30}, {-40,31}, {-40,32}, {-40,33}, {-40,34}, {-40,35}, {-40,36}, {-40,37}, {-40,38}, {-40,39}, {-40,40}, {-40,41}, {-40,42}, {-40,43}, {-40,44}, {-40,45}, {-40,46}, {-40,47}, {-40,48}, {-40,49}, {-40,50}, {-40,51}, {-40,52}, {-40,53}, {-40,54}, {-40,55}, {-40,56}, {-39,-52}, {-39,-51}, {-39,-50}, {-39,-49}, {-39,-48}, {-39,-47}, {-39,-46}, {-39,-45}, {-39,-44}, {-39,-43}, {-39,-42}, {-39,-41}, {-39,-40}, {-39,-39}, {-39,-38}, {-39,-37}, {-39,-36}, {-39,-35}, {-39,-34}, {-39,-33}, {-39,-32}, {-39,-31}, {-39,-30}, {-39,-29}, {-39,-28}, {-39,-27}, {-39,-26}, {-39,-25}, {-39,-24}, {-39,-23}, {-39,-22}, {-39,-21}, {-39,-20}, {-39,-19}, {-39,-18}, {-39,-17}, {-39,-16}, {-39,-15}, {-39,-14}, {-39,-13}, {-39,-12}, {-39,-11}, {-39,-10}, {-39,-9}, {-39,-8}, {-39,-7}, {-39,-6}, {-39,-5}, {-39,-4}, {-39,-3}, {-39,-2}, {-39,-1}, {-39,0}, {-39,1}, {-39,2}, {-39,3}, {-39,4}, {-39,5}, {-39,6}, {-39,7}, {-39,8}, {-39,9}, {-39,10}, {-39,11}, {-39,12}, {-39,13}, {-39,14}, {-39,15}, {-39,16}, {-39,17}, {-39,18}, {-39,19}, {-39,20}, {-39,21}, {-39,22}, {-39,23}, {-39,24}, {-39,25}, {-39,26}, {-39,27}, {-39,28}, {-39,29}, {-39,30}, {-39,31}, {-39,32}, {-39,33}, {-39,34}, {-39,35}, {-39,36}, {-39,37}, {-39,38}, {-39,39}, {-39,40}, {-39,41}, {-39,42}, {-39,43}, {-39,44}, {-39,45}, {-39,46}, {-39,47}, {-39,48}, {-39,49}, {-39,50}, {-39,51}, {-39,52}, {-39,53}, {-39,54}, {-39,55}, {-39,56}, {-39,57}, {-38,-52}, {-38,-51}, {-38,-50}, {-38,-49}, {-38,-48}, {-38,-47}, {-38,-46}, {-38,-45}, {-38,-44}, {-38,-43}, {-38,-42}, {-38,-41}, {-38,-40}, {-38,-39}, {-38,-38}, {-38,-37}, {-38,-36}, {-38,-35}, {-38,-34}, {-38,-33}, {-38,-32}, {-38,-31}, {-38,-30}, {-38,-29}, {-38,-28}, {-38,-27}, {-38,-26}, {-38,-25}, {-38,-24}, {-38,-23}, {-38,-22}, {-38,-21}, {-38,-20}, {-38,-19}, {-38,-18}, {-38,-17}, {-38,-16}, {-38,-15}, {-38,-14}, {-38,-13}, {-38,-12}, {-38,-11}, {-38,-10}, {-38,-9}, {-38,-8}, {-38,-7}, {-38,-6}, {-38,-5}, {-38,-4}, {-38,-3}, {-38,-2}, {-38,-1}, {-38,0}, {-38,1}, {-38,2}, {-38,3}, {-38,4}, {-38,5}, {-38,6}, {-38,7}, {-38,8}, {-38,9}, {-38,10}, {-38,11}, {-38,12}, {-38,13}, {-38,14}, {-38,15}, {-38,16}, {-38,17}, {-38,18}, {-38,19}, {-38,20}, {-38,21}, {-38,22}, {-38,23}, {-38,24}, {-38,25}, {-38,26}, {-38,27}, {-38,28}, {-38,29}, {-38,30}, {-38,31}, {-38,32}, {-38,33}, {-38,34}, {-38,35}, {-38,36}, {-38,37}, {-38,38}, {-38,39}, {-38,40}, {-38,41}, {-38,42}, {-38,43}, {-38,44}, {-38,45}, {-38,46}, {-38,47}, {-38,48}, {-38,49}, {-38,50}, {-38,51}, {-38,52}, {-38,53}, {-38,54}, {-38,55}, {-38,56}, {-38,57}, {-37,-52}, {-37,-51}, {-37,-50}, {-37,-49}, {-37,-48}, {-37,-47}, {-37,-46}, {-37,-45}, {-37,-44}, {-37,-43}, {-37,-42}, {-37,-41}, {-37,-40}, {-37,-39}, {-37,-38}, {-37,-37}, {-37,-36}, {-37,-35}, {-37,-34}, {-37,-33}, {-37,-32}, {-37,-31}, {-37,-30}, {-37,-29}, {-37,-28}, {-37,-27}, {-37,-26}, {-37,-25}, {-37,-24}, {-37,-23}, {-37,-22}, {-37,-21}, {-37,-20}, {-37,-19}, {-37,-18}, {-37,-17}, {-37,-16}, {-37,-15}, {-37,-14}, {-37,-13}, {-37,-12}, {-37,-11}, {-37,-10}, {-37,-9}, {-37,-8}, {-37,-7}, {-37,-6}, {-37,-5}, {-37,-4}, {-37,-3}, {-37,-2}, {-37,-1}, {-37,0}, {-37,1}, {-37,2}, {-37,3}, {-37,4}, {-37,5}, {-37,6}, {-37,7}, {-37,8}, {-37,9}, {-37,10}, {-37,11}, {-37,12}, {-37,13}, {-37,14}, {-37,15}, {-37,16}, {-37,17}, {-37,18}, {-37,19}, {-37,20}, {-37,21}, {-37,22}, {-37,23}, {-37,24}, {-37,25}, {-37,26}, {-37,27}, {-37,28}, {-37,29}, {-37,30}, {-37,31}, {-37,32}, {-37,33}, {-37,34}, {-37,35}, {-37,36}, {-37,37}, {-37,38}, {-37,39}, {-37,40}, {-37,41}, {-37,42}, {-37,43}, {-37,44}, {-37,45}, {-37,46}, {-37,47}, {-37,48}, {-37,49}, {-37,50}, {-37,51}, {-37,52}, {-37,53}, {-37,54}, {-37,55}, {-37,56}, {-37,57}, {-37,58}, {-36,-52}, {-36,-51}, {-36,-50}, {-36,-49}, {-36,-48}, {-36,-47}, {-36,-46}, {-36,-45}, {-36,-44}, {-36,-43}, {-36,-42}, {-36,-41}, {-36,-40}, {-36,-39}, {-36,-38}, {-36,-37}, {-36,-36}, {-36,-35}, {-36,-34}, {-36,-33}, {-36,-32}, {-36,-31}, {-36,-30}, {-36,-29}, {-36,-28}, {-36,-27}, {-36,-26}, {-36,-25}, {-36,-24}, {-36,-23}, {-36,-22}, {-36,-21}, {-36,-20}, {-36,-19}, {-36,-18}, {-36,-17}, {-36,-16}, {-36,-15}, {-36,-14}, {-36,-13}, {-36,-12}, {-36,-11}, {-36,-10}, {-36,-9}, {-36,-8}, {-36,-7}, {-36,-6}, {-36,-5}, {-36,-4}, {-36,-3}, {-36,-2}, {-36,-1}, {-36,0}, {-36,1}, {-36,2}, {-36,3}, {-36,4}, {-36,5}, {-36,6}, {-36,7}, {-36,8}, {-36,9}, {-36,10}, {-36,11}, {-36,12}, {-36,13}, {-36,14}, {-36,15}, {-36,16}, {-36,17}, {-36,18}, {-36,19}, {-36,20}, {-36,21}, {-36,22}, {-36,23}, {-36,24}, {-36,25}, {-36,26}, {-36,27}, {-36,28}, {-36,29}, {-36,30}, {-36,31}, {-36,32}, {-36,33}, {-36,34}, {-36,35}, {-36,36}, {-36,37}, {-36,38}, {-36,39}, {-36,40}, {-36,41}, {-36,42}, {-36,43}, {-36,44}, {-36,45}, {-36,46}, {-36,47}, {-36,48}, {-36,49}, {-36,50}, {-36,51}, {-36,52}, {-36,53}, {-36,54}, {-36,55}, {-36,56}, {-36,57}, {-36,58}, {-35,-53}, {-35,-52}, {-35,-51}, {-35,-50}, {-35,-49}, {-35,-48}, {-35,-47}, {-35,-46}, {-35,-45}, {-35,-44}, {-35,-43}, {-35,-42}, {-35,-41}, {-35,-40}, {-35,-39}, {-35,-38}, {-35,-37}, {-35,-36}, {-35,-35}, {-35,-34}, {-35,-33}, {-35,-32}, {-35,-31}, {-35,-30}, {-35,-29}, {-35,-28}, {-35,-27}, {-35,-26}, {-35,-25}, {-35,-24}, {-35,-23}, {-35,-22}, {-35,-21}, {-35,-20}, {-35,-19}, {-35,-18}, {-35,-17}, {-35,-16}, {-35,-15}, {-35,-14}, {-35,-13}, {-35,-12}, {-35,-11}, {-35,-10}, {-35,-9}, {-35,-8}, {-35,-7}, {-35,-6}, {-35,-5}, {-35,-4}, {-35,-3}, {-35,-2}, {-35,-1}, {-35,0}, {-35,1}, {-35,2}, {-35,3}, {-35,4}, {-35,5}, {-35,6}, {-35,7}, {-35,8}, {-35,9}, {-35,10}, {-35,11}, {-35,12}, {-35,13}, {-35,14}, {-35,15}, {-35,16}, {-35,17}, {-35,18}, {-35,19}, {-35,20}, {-35,21}, {-35,22}, {-35,23}, {-35,24}, {-35,25}, {-35,26}, {-35,27}, {-35,28}, {-35,29}, {-35,30}, {-35,31}, {-35,32}, {-35,33}, {-35,34}, {-35,35}, {-35,36}, {-35,37}, {-35,38}, {-35,39}, {-35,40}, {-35,41}, {-35,42}, {-35,43}, {-35,44}, {-35,45}, {-35,46}, {-35,47}, {-35,48}, {-35,49}, {-35,50}, {-35,51}, {-35,52}, {-35,53}, {-35,54}, {-35,55}, {-35,56}, {-35,57}, {-35,58}, {-35,59}, {-34,-53}, {-34,-52}, {-34,-51}, {-34,-50}, {-34,-49}, {-34,-48}, {-34,-47}, {-34,-46}, {-34,-45}, {-34,-44}, {-34,-43}, {-34,-42}, {-34,-41}, {-34,-40}, {-34,-39}, {-34,-38}, {-34,-37}, {-34,-36}, {-34,-35}, {-34,-34}, {-34,-33}, {-34,-32}, {-34,-31}, {-34,-30}, {-34,-29}, {-34,-28}, {-34,-27}, {-34,-26}, {-34,-25}, {-34,-24}, {-34,-23}, {-34,-22}, {-34,-21}, {-34,-20}, {-34,-19}, {-34,-18}, {-34,-17}, {-34,-16}, {-34,-15}, {-34,-14}, {-34,-13}, {-34,-12}, {-34,-11}, {-34,-10}, {-34,-9}, {-34,-8}, {-34,-7}, {-34,-6}, {-34,-5}, {-34,-4}, {-34,-3}, {-34,-2}, {-34,-1}, {-34,0}, {-34,1}, {-34,2}, {-34,3}, {-34,4}, {-34,5}, {-34,6}, {-34,7}, {-34,8}, {-34,9}, {-34,10}, {-34,11}, {-34,12}, {-34,13}, {-34,14}, {-34,15}, {-34,16}, {-34,17}, {-34,18}, {-34,19}, {-34,20}, {-34,21}, {-34,22}, {-34,23}, {-34,24}, {-34,25}, {-34,26}, {-34,27}, {-34,28}, {-34,29}, {-34,30}, {-34,31}, {-34,32}, {-34,33}, {-34,34}, {-34,35}, {-34,36}, {-34,37}, {-34,38}, {-34,39}, {-34,40}, {-34,41}, {-34,42}, {-34,43}, {-34,44}, {-34,45}, {-34,46}, {-34,47}, {-34,48}, {-34,49}, {-34,50}, {-34,51}, {-34,52}, {-34,53}, {-34,54}, {-34,55}, {-34,56}, {-34,57}, {-34,58}, {-34,59}, {-34,60}, {-33,-53}, {-33,-52}, {-33,-51}, {-33,-50}, {-33,-49}, {-33,-48}, {-33,-47}, {-33,-46}, {-33,-45}, {-33,-44}, {-33,-43}, {-33,-42}, {-33,-41}, {-33,-40}, {-33,-39}, {-33,-38}, {-33,-37}, {-33,-36}, {-33,-35}, {-33,-34}, {-33,-33}, {-33,-32}, {-33,-31}, {-33,-30}, {-33,-29}, {-33,-28}, {-33,-27}, {-33,-26}, {-33,-25}, {-33,-24}, {-33,-23}, {-33,-22}, {-33,-21}, {-33,-20}, {-33,-19}, {-33,-18}, {-33,-17}, {-33,-16}, {-33,-15}, {-33,-14}, {-33,-13}, {-33,-12}, {-33,-11}, {-33,-10}, {-33,-9}, {-33,-8}, {-33,-7}, {-33,-6}, {-33,-5}, {-33,-4}, {-33,-3}, {-33,-2}, {-33,-1}, {-33,0}, {-33,1}, {-33,2}, {-33,3}, {-33,4}, {-33,5}, {-33,6}, {-33,7}, {-33,8}, {-33,9}, {-33,10}, {-33,11}, {-33,12}, {-33,13}, {-33,14}, {-33,15}, {-33,16}, {-33,17}, {-33,18}, {-33,19}, {-33,20}, {-33,21}, {-33,22}, {-33,23}, {-33,24}, {-33,25}, {-33,26}, {-33,27}, {-33,28}, {-33,29}, {-33,30}, {-33,31}, {-33,32}, {-33,33}, {-33,34}, {-33,35}, {-33,36}, {-33,37}, {-33,38}, {-33,39}, {-33,40}, {-33,41}, {-33,42}, {-33,43}, {-33,44}, {-33,45}, {-33,46}, {-33,47}, {-33,48}, {-33,49}, {-33,50}, {-33,51}, {-33,52}, {-33,53}, {-33,54}, {-33,55}, {-33,56}, {-33,57}, {-33,58}, {-33,59}, {-33,60}, {-32,-54}, {-32,-53}, {-32,-52}, {-32,-51}, {-32,-50}, {-32,-49}, {-32,-48}, {-32,-47}, {-32,-46}, {-32,-45}, {-32,-44}, {-32,-43}, {-32,-42}, {-32,-41}, {-32,-40}, {-32,-39}, {-32,-38}, {-32,-37}, {-32,-36}, {-32,-35}, {-32,-34}, {-32,-33}, {-32,-32}, {-32,-31}, {-32,-30}, {-32,-29}, {-32,-28}, {-32,-27}, {-32,-26}, {-32,-25}, {-32,-24}, {-32,-23}, {-32,-22}, {-32,-21}, {-32,-20}, {-32,-19}, {-32,-18}, {-32,-17}, {-32,-16}, {-32,-15}, {-32,-14}, {-32,-13}, {-32,-12}, {-32,-11}, {-32,-10}, {-32,-9}, {-32,-8}, {-32,-7}, {-32,-6}, {-32,-5}, {-32,-4}, {-32,-3}, {-32,-2}, {-32,-1}, {-32,0}, {-32,1}, {-32,2}, {-32,3}, {-32,4}, {-32,5}, {-32,6}, {-32,7}, {-32,8}, {-32,9}, {-32,10}, {-32,11}, {-32,12}, {-32,13}, {-32,14}, {-32,15}, {-32,16}, {-32,17}, {-32,18}, {-32,19}, {-32,20}, {-32,21}, {-32,22}, {-32,23}, {-32,24}, {-32,25}, {-32,26}, {-32,27}, {-32,28}, {-32,29}, {-32,30}, {-32,31}, {-32,32}, {-32,33}, {-32,34}, {-32,35}, {-32,36}, {-32,37}, {-32,38}, {-32,39}, {-32,40}, {-32,41}, {-32,42}, {-32,43}, {-32,44}, {-32,45}, {-32,46}, {-32,47}, {-32,48}, {-32,49}, {-32,50}, {-32,51}, {-32,52}, {-32,53}, {-32,54}, {-32,55}, {-32,56}, {-32,57}, {-32,58}, {-32,59}, {-32,60}, {-32,61}, {-31,-54}, {-31,-53}, {-31,-52}, {-31,-51}, {-31,-50}, {-31,-49}, {-31,-48}, {-31,-47}, {-31,-46}, {-31,-45}, {-31,-44}, {-31,-43}, {-31,-42}, {-31,-41}, {-31,-40}, {-31,-39}, {-31,-38}, {-31,-37}, {-31,-36}, {-31,-35}, {-31,-34}, {-31,-33}, {-31,-32}, {-31,-31}, {-31,-30}, {-31,-29}, {-31,-28}, {-31,-27}, {-31,-26}, {-31,-25}, {-31,-24}, {-31,-23}, {-31,-22}, {-31,-21}, {-31,-20}, {-31,-19}, {-31,-18}, {-31,-17}, {-31,-16}, {-31,-15}, {-31,-14}, {-31,-13}, {-31,-8}, {-31,-7}, {-31,-6}, {-31,-5}, {-31,-4}, {-31,-3}, {-31,-2}, {-31,-1}, {-31,0}, {-31,12}, {-31,13}, {-31,14}, {-31,15}, {-31,16}, {-31,17}, {-31,18}, {-31,19}, {-31,20}, {-31,21}, {-31,22}, {-31,23}, {-31,24}, {-31,25}, {-31,26}, {-31,27}, {-31,28}, {-31,29}, {-31,30}, {-31,31}, {-31,32}, {-31,33}, {-31,34}, {-31,35}, {-31,36}, {-31,37}, {-31,38}, {-31,39}, {-31,40}, {-31,41}, {-31,42}, {-31,43}, {-31,44}, {-31,45}, {-31,46}, {-31,47}, {-31,48}, {-31,49}, {-31,50}, {-31,51}, {-31,52}, {-31,53}, {-31,54}, {-31,55}, {-31,56}, {-31,57}, {-31,58}, {-31,59}, {-31,60}, {-31,61}, {-30,-55}, {-30,-54}, {-30,-53}, {-30,-52}, {-30,-51}, {-30,-50}, {-30,-49}, {-30,-48}, {-30,-47}, {-30,-46}, {-30,-45}, {-30,-44}, {-30,-43}, {-30,-42}, {-30,-41}, {-30,-40}, {-30,-39}, {-30,-38}, {-30,-37}, {-30,-36}, {-30,-35}, {-30,-34}, {-30,-33}, {-30,-32}, {-30,-31}, {-30,-30}, {-30,-29}, {-30,-28}, {-30,-27}, {-30,-26}, {-30,-25}, {-30,-24}, {-30,-23}, {-30,-22}, {-30,-21}, {-30,-20}, {-30,-19}, {-30,-18}, {-30,-17}, {-30,-16}, {-30,-15}, {-30,-14}, {-30,-7}, {-30,-6}, {-30,-5}, {-30,-4}, {-30,-3}, {-30,15}, {-30,16}, {-30,17}, {-30,18}, {-30,19}, {-30,20}, {-30,21}, {-30,22}, {-30,23}, {-30,24}, {-30,25}, {-30,26}, {-30,27}, {-30,28}, {-30,29}, {-30,30}, {-30,31}, {-30,32}, {-30,33}, {-30,34}, {-30,35}, {-30,36}, {-30,37}, {-30,38}, {-30,39}, {-30,40}, {-30,41}, {-30,42}, {-30,43}, {-30,44}, {-30,45}, {-30,46}, {-30,47}, {-30,48}, {-30,49}, {-30,50}, {-30,51}, {-30,52}, {-30,53}, {-30,54}, {-30,55}, {-30,56}, {-30,57}, {-30,58}, {-30,59}, {-30,60}, {-30,61}, {-29,-55}, {-29,-54}, {-29,-53}, {-29,-52}, {-29,-51}, {-29,-50}, {-29,-49}, {-29,-48}, {-29,-47}, {-29,-46}, {-29,-45}, {-29,-44}, {-29,-43}, {-29,-42}, {-29,-41}, {-29,-40}, {-29,-39}, {-29,-38}, {-29,-37}, {-29,-36}, {-29,-35}, {-29,-34}, {-29,-33}, {-29,-32}, {-29,-31}, {-29,-30}, {-29,-29}, {-29,-28}, {-29,-27}, {-29,-26}, {-29,-25}, {-29,-24}, {-29,-18}, {-29,-17}, {-29,-16}, {-29,-15}, {-29,-14}, {-29,-7}, {-29,-6}, {-29,-5}, {-29,-4}, {-29,16}, {-29,17}, {-29,18}, {-29,19}, {-29,20}, {-29,21}, {-29,22}, {-29,23}, {-29,24}, {-29,25}, {-29,26}, {-29,27}, {-29,28}, {-29,29}, {-29,30}, {-29,31}, {-29,32}, {-29,33}, {-29,34}, {-29,35}, {-29,36}, {-29,37}, {-29,38}, {-29,39}, {-29,40}, {-29,41}, {-29,42}, {-29,43}, {-29,44}, {-29,45}, {-29,46}, {-29,47}, {-29,48}, {-29,49}, {-29,50}, {-29,51}, {-29,52}, {-29,53}, {-29,54}, {-29,55}, {-29,56}, {-29,57}, {-29,58}, {-29,59}, {-29,60}, {-29,61}, {-28,-55}, {-28,-54}, {-28,-53}, {-28,-52}, {-28,-51}, {-28,-50}, {-28,-49}, {-28,-48}, {-28,-47}, {-28,-46}, {-28,-45}, {-28,-44}, {-28,-43}, {-28,-42}, {-28,-41}, {-28,-40}, {-28,-39}, {-28,-38}, {-28,-37}, {-28,-36}, {-28,-35}, {-28,-34}, {-28,-33}, {-28,-32}, {-28,-31}, {-28,-30}, {-28,-29}, {-28,-28}, {-28,-27}, {-28,-26}, {-28,-25}, {-28,-16}, {-28,-15}, {-28,-14}, {-28,-7}, {-28,-6}, {-28,-5}, {-28,-4}, {-28,17}, {-28,18}, {-28,19}, {-28,20}, {-28,21}, {-28,22}, {-28,23}, {-28,24}, {-28,25}, {-28,26}, {-28,27}, {-28,28}, {-28,29}, {-28,30}, {-28,31}, {-28,32}, {-28,33}, {-28,34}, {-28,35}, {-28,36}, {-28,37}, {-28,38}, {-28,39}, {-28,40}, {-28,41}, {-28,42}, {-28,43}, {-28,44}, {-28,45}, {-28,46}, {-28,47}, {-28,48}, {-28,49}, {-28,50}, {-28,51}, {-28,52}, {-28,53}, {-28,54}, {-28,55}, {-28,56}, {-28,57}, {-28,58}, {-28,59}, {-28,60}, {-28,61}, {-27,-56}, {-27,-55}, {-27,-54}, {-27,-53}, {-27,-52}, {-27,-51}, {-27,-50}, {-27,-49}, {-27,-48}, {-27,-47}, {-27,-46}, {-27,-45}, {-27,-44}, {-27,-43}, {-27,-42}, {-27,-41}, {-27,-40}, {-27,-39}, {-27,-38}, {-27,-37}, {-27,-36}, {-27,-35}, {-27,-34}, {-27,-33}, {-27,-32}, {-27,-31}, {-27,-30}, {-27,-29}, {-27,-28}, {-27,-27}, {-27,-26}, {-27,-25}, {-27,-16}, {-27,-15}, {-27,-14}, {-27,-7}, {-27,-6}, {-27,-5}, {-27,18}, {-27,19}, {-27,20}, {-27,21}, {-27,22}, {-27,23}, {-27,24}, {-27,25}, {-27,26}, {-27,27}, {-27,28}, {-27,29}, {-27,30}, {-27,31}, {-27,32}, {-27,33}, {-27,34}, {-27,35}, {-27,36}, {-27,37}, {-27,38}, {-27,39}, {-27,40}, {-27,41}, {-27,42}, {-27,43}, {-27,44}, {-27,45}, {-27,46}, {-27,47}, {-27,48}, {-27,49}, {-27,50}, {-27,51}, {-27,52}, {-27,53}, {-27,54}, {-27,55}, {-27,56}, {-27,57}, {-27,58}, {-27,59}, {-27,60}, {-27,61}, {-26,-56}, {-26,-55}, {-26,-54}, {-26,-53}, {-26,-52}, {-26,-51}, {-26,-50}, {-26,-49}, {-26,-48}, {-26,-47}, {-26,-46}, {-26,-45}, {-26,-44}, {-26,-43}, {-26,-42}, {-26,-41}, {-26,-40}, {-26,-39}, {-26,-38}, {-26,-37}, {-26,-36}, {-26,-35}, {-26,-34}, {-26,-33}, {-26,-32}, {-26,-31}, {-26,-30}, {-26,-29}, {-26,-28}, {-26,-27}, {-26,-26}, {-26,-15}, {-26,-14}, {-26,-13}, {-26,-7}, {-26,-6}, {-26,19}, {-26,20}, {-26,21}, {-26,22}, {-26,23}, {-26,24}, {-26,25}, {-26,26}, {-26,27}, {-26,28}, {-26,29}, {-26,30}, {-26,31}, {-26,32}, {-26,33}, {-26,34}, {-26,35}, {-26,36}, {-26,37}, {-26,38}, {-26,39}, {-26,40}, {-26,41}, {-26,42}, {-26,43}, {-26,44}, {-26,45}, {-26,46}, {-26,47}, {-26,48}, {-26,49}, {-26,50}, {-26,51}, {-26,52}, {-26,53}, {-26,54}, {-26,55}, {-26,56}, {-26,57}, {-26,58}, {-26,59}, {-26,60}, {-26,61}, {-25,-57}, {-25,-56}, {-25,-55}, {-25,-54}, {-25,-53}, {-25,-52}, {-25,-51}, {-25,-50}, {-25,-49}, {-25,-48}, {-25,-47}, {-25,-46}, {-25,-45}, {-25,-44}, {-25,-43}, {-25,-42}, {-25,-41}, {-25,-40}, {-25,-39}, {-25,-38}, {-25,-37}, {-25,-36}, {-25,-35}, {-25,-34}, {-25,-33}, {-25,-32}, {-25,-31}, {-25,-30}, {-25,-29}, {-25,-28}, {-25,-15}, {-25,-14}, {-25,-13}, {-25,-12}, {-25,-11}, {-25,-10}, {-25,-9}, {-25,-8}, {-25,20}, {-25,21}, {-25,22}, {-25,23}, {-25,24}, {-25,25}, {-25,26}, {-25,27}, {-25,28}, {-25,29}, {-25,30}, {-25,31}, {-25,32}, {-25,33}, {-25,34}, {-25,35}, {-25,36}, {-25,37}, {-25,38}, {-25,39}, {-25,40}, {-25,41}, {-25,42}, {-25,43}, {-25,44}, {-25,45}, {-25,46}, {-25,47}, {-25,48}, {-25,49}, {-25,50}, {-25,51}, {-25,52}, {-25,53}, {-25,54}, {-25,55}, {-25,56}, {-25,57}, {-25,58}, {-25,59}, {-25,60}, {-25,61}, {-24,-57}, {-24,-56}, {-24,-55}, {-24,-54}, {-24,-53}, {-24,-52}, {-24,-51}, {-24,-50}, {-24,-49}, {-24,-48}, {-24,-47}, {-24,-46}, {-24,-45}, {-24,-44}, {-24,-43}, {-24,-42}, {-24,-41}, {-24,-40}, {-24,-39}, {-24,-38}, {-24,-37}, {-24,-36}, {-24,-35}, {-24,-34}, {-24,-33}, {-24,-32}, {-24,-31}, {-24,-30}, {-24,-29}, {-24,-15}, {-24,-14}, {-24,-13}, {-24,-12}, {-24,-11}, {-24,-10}, {-24,-9}, {-24,-8}, {-24,21}, {-24,22}, {-24,23}, {-24,24}, {-24,25}, {-24,26}, {-24,27}, {-24,28}, {-24,29}, {-24,30}, {-24,31}, {-24,32}, {-24,33}, {-24,34}, {-24,35}, {-24,36}, {-24,37}, {-24,38}, {-24,39}, {-24,40}, {-24,41}, {-24,42}, {-24,43}, {-24,44}, {-24,45}, {-24,46}, {-24,47}, {-24,48}, {-24,49}, {-24,50}, {-24,51}, {-24,52}, {-24,53}, {-24,54}, {-24,55}, {-24,56}, {-24,57}, {-24,58}, {-24,59}, {-24,60}, {-24,61}, {-23,-58}, {-23,-57}, {-23,-56}, {-23,-55}, {-23,-54}, {-23,-53}, {-23,-52}, {-23,-51}, {-23,-50}, {-23,-49}, {-23,-48}, {-23,-47}, {-23,-46}, {-23,-45}, {-23,-44}, {-23,-43}, {-23,-42}, {-23,-41}, {-23,-40}, {-23,-39}, {-23,-38}, {-23,-37}, {-23,-36}, {-23,-35}, {-23,-34}, {-23,-33}, {-23,-32}, {-23,-31}, {-23,-30}, {-23,-14}, {-23,-13}, {-23,-12}, {-23,-11}, {-23,-10}, {-23,-9}, {-23,-8}, {-23,27}, {-23,28}, {-23,29}, {-23,30}, {-23,31}, {-23,32}, {-23,33}, {-23,34}, {-23,35}, {-23,36}, {-23,37}, {-23,38}, {-23,39}, {-23,40}, {-23,41}, {-23,42}, {-23,43}, {-23,44}, {-23,45}, {-23,46}, {-23,47}, {-23,48}, {-23,49}, {-23,50}, {-23,51}, {-23,52}, {-23,53}, {-23,54}, {-23,55}, {-23,56}, {-23,57}, {-23,58}, {-23,59}, {-23,60}, {-23,61}, {-22,-59}, {-22,-58}, {-22,-57}, {-22,-56}, {-22,-55}, {-22,-54}, {-22,-53}, {-22,-52}, {-22,-51}, {-22,-50}, {-22,-49}, {-22,-48}, {-22,-47}, {-22,-46}, {-22,-45}, {-22,-44}, {-22,-43}, {-22,-42}, {-22,-41}, {-22,-40}, {-22,-39}, {-22,-38}, {-22,-37}, {-22,-36}, {-22,-35}, {-22,-34}, {-22,-33}, {-22,-32}, {-22,-31}, {-22,-14}, {-22,-13}, {-22,-12}, {-22,-11}, {-22,-10}, {-22,-9}, {-22,-8}, {-22,29}, {-22,30}, {-22,31}, {-22,32}, {-22,33}, {-22,34}, {-22,35}, {-22,36}, {-22,37}, {-22,38}, {-22,39}, {-22,40}, {-22,41}, {-22,42}, {-22,43}, {-22,44}, {-22,45}, {-22,46}, {-22,47}, {-22,48}, {-22,49}, {-22,50}, {-22,51}, {-22,52}, {-22,53}, {-22,54}, {-22,55}, {-22,56}, {-22,57}, {-22,58}, {-22,59}, {-22,60}, {-22,61}, {-21,-60}, {-21,-59}, {-21,-58}, {-21,-57}, {-21,-56}, {-21,-55}, {-21,-54}, {-21,-53}, {-21,-52}, {-21,-51}, {-21,-50}, {-21,-49}, {-21,-48}, {-21,-47}, {-21,-46}, {-21,-45}, {-21,-44}, {-21,-43}, {-21,-42}, {-21,-41}, {-21,-40}, {-21,-39}, {-21,-38}, {-21,-37}, {-21,-36}, {-21,-35}, {-21,-34}, {-21,-33}, {-21,-32}, {-21,-31}, {-21,-14}, {-21,-13}, {-21,-12}, {-21,-11}, {-21,-10}, {-21,-9}, {-21,31}, {-21,32}, {-21,33}, {-21,34}, {-21,35}, {-21,36}, {-21,37}, {-21,38}, {-21,39}, {-21,40}, {-21,41}, {-21,42}, {-21,43}, {-21,44}, {-21,45}, {-21,46}, {-21,47}, {-21,48}, {-21,49}, {-21,50}, {-21,51}, {-21,52}, {-21,53}, {-21,54}, {-21,55}, {-21,56}, {-21,57}, {-21,58}, {-21,59}, {-21,60}, {-21,61}, {-20,-61}, {-20,-60}, {-20,-59}, {-20,-58}, {-20,-57}, {-20,-56}, {-20,-55}, {-20,-54}, {-20,-53}, {-20,-52}, {-20,-51}, {-20,-50}, {-20,-49}, {-20,-48}, {-20,-47}, {-20,-46}, {-20,-45}, {-20,-44}, {-20,-43}, {-20,-42}, {-20,-41}, {-20,-40}, {-20,-39}, {-20,-38}, {-20,-37}, {-20,-36}, {-20,-35}, {-20,-34}, {-20,-33}, {-20,-32}, {-20,-14}, {-20,-13}, {-20,-12}, {-20,-11}, {-20,-10}, {-20,-9}, {-20,31}, {-20,32}, {-20,33}, {-20,34}, {-20,35}, {-20,36}, {-20,37}, {-20,38}, {-20,39}, {-20,40}, {-20,41}, {-20,42}, {-20,43}, {-20,44}, {-20,45}, {-20,46}, {-20,47}, {-20,48}, {-20,49}, {-20,50}, {-20,51}, {-20,52}, {-20,53}, {-20,54}, {-20,55}, {-20,56}, {-20,57}, {-20,58}, {-20,59}, {-20,60}, {-20,61}, {-19,-61}, {-19,-60}, {-19,-59}, {-19,-58}, {-19,-57}, {-19,-56}, {-19,-55}, {-19,-54}, {-19,-53}, {-19,-52}, {-19,-51}, {-19,-50}, {-19,-49}, {-19,-48}, {-19,-47}, {-19,-46}, {-19,-45}, {-19,-44}, {-19,-43}, {-19,-42}, {-19,-41}, {-19,-40}, {-19,-39}, {-19,-38}, {-19,-37}, {-19,-36}, {-19,-35}, {-19,-34}, {-19,-33}, {-19,-32}, {-19,-14}, {-19,-13}, {-19,-12}, {-19,-11}, {-19,-10}, {-19,27}, {-19,28}, {-19,29}, {-19,30}, {-19,32}, {-19,33}, {-19,34}, {-19,35}, {-19,36}, {-19,37}, {-19,38}, {-19,39}, {-19,40}, {-19,41}, {-19,42}, {-19,43}, {-19,44}, {-19,45}, {-19,46}, {-19,47}, {-19,48}, {-19,49}, {-19,50}, {-19,51}, {-19,52}, {-19,53}, {-19,54}, {-19,55}, {-19,56}, {-19,57}, {-19,58}, {-19,59}, {-19,60}, {-19,61}, {-18,-62}, {-18,-61}, {-18,-60}, {-18,-59}, {-18,-58}, {-18,-57}, {-18,-56}, {-18,-55}, {-18,-54}, {-18,-53}, {-18,-52}, {-18,-51}, {-18,-50}, {-18,-49}, {-18,-48}, {-18,-47}, {-18,-46}, {-18,-45}, {-18,-44}, {-18,-43}, {-18,-42}, {-18,-41}, {-18,-40}, {-18,-39}, {-18,-38}, {-18,-37}, {-18,-36}, {-18,-35}, {-18,-34}, {-18,-33}, {-18,26}, {-18,27}, {-18,28}, {-18,29}, {-18,30}, {-18,31}, {-18,32}, {-18,33}, {-18,34}, {-18,35}, {-18,36}, {-18,37}, {-18,38}, {-18,39}, {-18,40}, {-18,41}, {-18,42}, {-18,43}, {-18,44}, {-18,45}, {-18,46}, {-18,47}, {-18,48}, {-18,49}, {-18,50}, {-18,51}, {-18,52}, {-18,53}, {-18,54}, {-18,55}, {-18,56}, {-18,57}, {-18,58}, {-18,59}, {-18,60}, {-18,61}, {-17,-63}, {-17,-62}, {-17,-61}, {-17,-60}, {-17,-59}, {-17,-58}, {-17,-57}, {-17,-56}, {-17,-55}, {-17,-54}, {-17,-53}, {-17,-52}, {-17,-51}, {-17,-50}, {-17,-49}, {-17,-48}, {-17,-47}, {-17,-46}, {-17,-45}, {-17,-44}, {-17,-43}, {-17,-42}, {-17,-41}, {-17,-40}, {-17,-39}, {-17,-38}, {-17,-37}, {-17,-36}, {-17,-35}, {-17,-34}, {-17,-33}, {-17,26}, {-17,27}, {-17,28}, {-17,29}, {-17,30}, {-17,31}, {-17,32}, {-17,33}, {-17,34}, {-17,35}, {-17,36}, {-17,37}, {-17,38}, {-17,39}, {-17,40}, {-17,41}, {-17,42}, {-17,43}, {-17,44}, {-17,45}, {-17,46}, {-17,47}, {-17,48}, {-17,49}, {-17,50}, {-17,51}, {-17,52}, {-17,53}, {-17,54}, {-17,55}, {-17,56}, {-17,57}, {-17,58}, {-17,59}, {-17,60}, {-17,61}, {-16,-63}, {-16,-62}, {-16,-61}, {-16,-60}, {-16,-59}, {-16,-58}, {-16,-57}, {-16,-56}, {-16,-55}, {-16,-54}, {-16,-53}, {-16,-52}, {-16,-51}, {-16,-50}, {-16,-49}, {-16,-48}, {-16,-47}, {-16,-46}, {-16,-45}, {-16,-44}, {-16,-43}, {-16,-42}, {-16,-41}, {-16,-40}, {-16,-39}, {-16,-38}, {-16,-37}, {-16,-36}, {-16,-35}, {-16,-34}, {-16,-33}, {-16,-13}, {-16,-12}, {-16,-11}, {-16,-10}, {-16,26}, {-16,27}, {-16,28}, {-16,29}, {-16,30}, {-16,31}, {-16,32}, {-16,33}, {-16,34}, {-16,35}, {-16,36}, {-16,37}, {-16,38}, {-16,39}, {-16,40}, {-16,41}, {-16,42}, {-16,43}, {-16,44}, {-16,45}, {-16,46}, {-16,47}, {-16,48}, {-16,49}, {-16,50}, {-16,51}, {-16,52}, {-16,53}, {-16,54}, {-16,55}, {-16,56}, {-16,57}, {-16,58}, {-16,59}, {-16,60}, {-16,61}, {-15,-63}, {-15,-62}, {-15,-61}, {-15,-60}, {-15,-59}, {-15,-58}, {-15,-57}, {-15,-56}, {-15,-55}, {-15,-54}, {-15,-53}, {-15,-52}, {-15,-51}, {-15,-50}, {-15,-49}, {-15,-48}, {-15,-47}, {-15,-46}, {-15,-45}, {-15,-44}, {-15,-43}, {-15,-42}, {-15,-41}, {-15,-40}, {-15,-39}, {-15,-38}, {-15,-37}, {-15,-36}, {-15,-35}, {-15,-34}, {-15,-33}, {-15,-13}, {-15,-12}, {-15,-11}, {-15,-10}, {-15,27}, {-15,28}, {-15,29}, {-15,30}, {-15,31}, {-15,32}, {-15,33}, {-15,34}, {-15,35}, {-15,36}, {-15,37}, {-15,38}, {-15,39}, {-15,40}, {-15,41}, {-15,42}, {-15,43}, {-15,44}, {-15,45}, {-15,46}, {-15,47}, {-15,48}, {-15,49}, {-15,50}, {-15,51}, {-15,52}, {-15,53}, {-15,54}, {-15,55}, {-15,56}, {-15,57}, {-15,58}, {-15,59}, {-15,60}, {-15,61}, {-14,-63}, {-14,-62}, {-14,-61}, {-14,-60}, {-14,-59}, {-14,-58}, {-14,-57}, {-14,-56}, {-14,-55}, {-14,-54}, {-14,-53}, {-14,-52}, {-14,-51}, {-14,-50}, {-14,-49}, {-14,-48}, {-14,-47}, {-14,-46}, {-14,-45}, {-14,-44}, {-14,-43}, {-14,-42}, {-14,-41}, {-14,-40}, {-14,-39}, {-14,-38}, {-14,-37}, {-14,-36}, {-14,-35}, {-14,-34}, {-14,-33}, {-14,-13}, {-14,-12}, {-14,-11}, {-14,-10}, {-14,25}, {-14,26}, {-14,27}, {-14,28}, {-14,29}, {-14,30}, {-14,31}, {-14,32}, {-14,33}, {-14,34}, {-14,35}, {-14,36}, {-14,37}, {-14,38}, {-14,39}, {-14,40}, {-14,41}, {-14,42}, {-14,43}, {-14,44}, {-14,45}, {-14,46}, {-14,47}, {-14,48}, {-14,49}, {-14,50}, {-14,51}, {-14,52}, {-14,53}, {-14,54}, {-14,55}, {-14,56}, {-14,57}, {-14,58}, {-14,59}, {-14,60}, {-14,61}, {-13,-63}, {-13,-62}, {-13,-61}, {-13,-60}, {-13,-59}, {-13,-58}, {-13,-57}, {-13,-56}, {-13,-55}, {-13,-54}, {-13,-53}, {-13,-52}, {-13,-51}, {-13,-50}, {-13,-49}, {-13,-48}, {-13,-47}, {-13,-46}, {-13,-45}, {-13,-44}, {-13,-43}, {-13,-42}, {-13,-41}, {-13,-40}, {-13,-39}, {-13,-38}, {-13,-37}, {-13,-36}, {-13,-35}, {-13,-34}, {-13,-33}, {-13,-13}, {-13,-12}, {-13,-11}, {-13,-10}, {-13,25}, {-13,26}, {-13,27}, {-13,28}, {-13,29}, {-13,30}, {-13,31}, {-13,32}, {-13,33}, {-13,34}, {-13,35}, {-13,36}, {-13,37}, {-13,38}, {-13,39}, {-13,40}, {-13,41}, {-13,42}, {-13,43}, {-13,44}, {-13,45}, {-13,46}, {-13,47}, {-13,48}, {-13,49}, {-13,50}, {-13,51}, {-13,52}, {-13,53}, {-13,54}, {-13,55}, {-13,56}, {-13,57}, {-13,58}, {-13,59}, {-13,60}, {-13,61}, {-13,62}, {-12,-63}, {-12,-62}, {-12,-61}, {-12,-60}, {-12,-59}, {-12,-58}, {-12,-57}, {-12,-56}, {-12,-55}, {-12,-54}, {-12,-53}, {-12,-52}, {-12,-51}, {-12,-50}, {-12,-49}, {-12,-48}, {-12,-47}, {-12,-46}, {-12,-45}, {-12,-44}, {-12,-43}, {-12,-42}, {-12,-41}, {-12,-40}, {-12,-39}, {-12,-38}, {-12,-37}, {-12,-36}, {-12,-35}, {-12,-34}, {-12,-33}, {-12,25}, {-12,26}, {-12,27}, {-12,28}, {-12,29}, {-12,30}, {-12,31}, {-12,32}, {-12,33}, {-12,34}, {-12,35}, {-12,36}, {-12,37}, {-12,38}, {-12,39}, {-12,40}, {-12,41}, {-12,42}, {-12,43}, {-12,44}, {-12,45}, {-12,46}, {-12,47}, {-12,48}, {-12,49}, {-12,50}, {-12,51}, {-12,52}, {-12,53}, {-12,54}, {-12,55}, {-12,56}, {-12,57}, {-12,58}, {-12,59}, {-12,60}, {-12,61}, {-12,62}, {-11,-63}, {-11,-62}, {-11,-61}, {-11,-60}, {-11,-59}, {-11,-58}, {-11,-57}, {-11,-56}, {-11,-55}, {-11,-54}, {-11,-53}, {-11,-52}, {-11,-51}, {-11,-50}, {-11,-49}, {-11,-48}, {-11,-47}, {-11,-46}, {-11,-45}, {-11,-44}, {-11,-43}, {-11,-42}, {-11,-41}, {-11,-40}, {-11,-39}, {-11,-38}, {-11,-37}, {-11,-36}, {-11,-35}, {-11,-34}, {-11,-33}, {-11,25}, {-11,26}, {-11,27}, {-11,28}, {-11,29}, {-11,30}, {-11,31}, {-11,32}, {-11,33}, {-11,34}, {-11,35}, {-11,36}, {-11,37}, {-11,38}, {-11,39}, {-11,40}, {-11,41}, {-11,42}, {-11,43}, {-11,44}, {-11,45}, {-11,46}, {-11,47}, {-11,48}, {-11,49}, {-11,50}, {-11,51}, {-11,52}, {-11,53}, {-11,54}, {-11,55}, {-11,56}, {-11,57}, {-11,58}, {-11,59}, {-11,60}, {-11,61}, {-11,62}, {-10,-63}, {-10,-62}, {-10,-61}, {-10,-60}, {-10,-59}, {-10,-58}, {-10,-57}, {-10,-56}, {-10,-55}, {-10,-54}, {-10,-53}, {-10,-52}, {-10,-51}, {-10,-50}, {-10,-49}, {-10,-48}, {-10,-47}, {-10,-46}, {-10,-45}, {-10,-44}, {-10,-43}, {-10,-42}, {-10,-41}, {-10,-40}, {-10,-39}, {-10,-38}, {-10,-37}, {-10,-36}, {-10,-35}, {-10,-34}, {-10,-33}, {-10,-32}, {-10,-13}, {-10,-12}, {-10,-11}, {-10,27}, {-10,28}, {-10,29}, {-10,30}, {-10,31}, {-10,32}, {-10,33}, {-10,34}, {-10,35}, {-10,36}, {-10,37}, {-10,38}, {-10,39}, {-10,40}, {-10,41}, {-10,42}, {-10,43}, {-10,44}, {-10,45}, {-10,46}, {-10,47}, {-10,48}, {-10,49}, {-10,50}, {-10,51}, {-10,52}, {-10,53}, {-10,54}, {-10,55}, {-10,56}, {-10,57}, {-10,58}, {-10,59}, {-10,60}, {-10,61}, {-10,62}, {-10,63}, {-9,-63}, {-9,-62}, {-9,-61}, {-9,-60}, {-9,-59}, {-9,-58}, {-9,-57}, {-9,-56}, {-9,-55}, {-9,-54}, {-9,-53}, {-9,-52}, {-9,-51}, {-9,-50}, {-9,-49}, {-9,-48}, {-9,-47}, {-9,-46}, {-9,-45}, {-9,-44}, {-9,-43}, {-9,-42}, {-9,-41}, {-9,-40}, {-9,-39}, {-9,-38}, {-9,-37}, {-9,-36}, {-9,-35}, {-9,-34}, {-9,-33}, {-9,-32}, {-9,-14}, {-9,-13}, {-9,-12}, {-9,-11}, {-9,26}, {-9,27}, {-9,28}, {-9,29}, {-9,30}, {-9,31}, {-9,32}, {-9,33}, {-9,34}, {-9,35}, {-9,36}, {-9,37}, {-9,38}, {-9,39}, {-9,40}, {-9,41}, {-9,42}, {-9,43}, {-9,44}, {-9,45}, {-9,46}, {-9,47}, {-9,48}, {-9,49}, {-9,50}, {-9,51}, {-9,52}, {-9,53}, {-9,54}, {-9,55}, {-9,56}, {-9,57}, {-9,58}, {-9,59}, {-9,60}, {-9,61}, {-9,62}, {-9,63}, {-8,-63}, {-8,-62}, {-8,-61}, {-8,-60}, {-8,-59}, {-8,-58}, {-8,-57}, {-8,-56}, {-8,-55}, {-8,-54}, {-8,-53}, {-8,-52}, {-8,-51}, {-8,-50}, {-8,-49}, {-8,-48}, {-8,-47}, {-8,-46}, {-8,-45}, {-8,-44}, {-8,-43}, {-8,-42}, {-8,-41}, {-8,-40}, {-8,-39}, {-8,-38}, {-8,-37}, {-8,-36}, {-8,-35}, {-8,-34}, {-8,-33}, {-8,-32}, {-8,-14}, {-8,-13}, {-8,-12}, {-8,-11}, {-8,-10}, {-8,26}, {-8,27}, {-8,28}, {-8,29}, {-8,30}, {-8,31}, {-8,32}, {-8,33}, {-8,34}, {-8,35}, {-8,36}, {-8,37}, {-8,38}, {-8,39}, {-8,40}, {-8,41}, {-8,42}, {-8,43}, {-8,44}, {-8,45}, {-8,46}, {-8,47}, {-8,48}, {-8,49}, {-8,50}, {-8,51}, {-8,52}, {-8,53}, {-8,54}, {-8,55}, {-8,56}, {-8,57}, {-8,58}, {-8,59}, {-8,60}, {-8,61}, {-8,62}, {-8,63}, {-7,-63}, {-7,-62}, {-7,-61}, {-7,-60}, {-7,-59}, {-7,-58}, {-7,-57}, {-7,-56}, {-7,-55}, {-7,-54}, {-7,-53}, {-7,-52}, {-7,-51}, {-7,-50}, {-7,-49}, {-7,-48}, {-7,-47}, {-7,-46}, {-7,-45}, {-7,-44}, {-7,-43}, {-7,-42}, {-7,-41}, {-7,-40}, {-7,-39}, {-7,-38}, {-7,-37}, {-7,-36}, {-7,-35}, {-7,-34}, {-7,-33}, {-7,-32}, {-7,-14}, {-7,-13}, {-7,-12}, {-7,-11}, {-7,-10}, {-7,26}, {-7,27}, {-7,28}, {-7,29}, {-7,30}, {-7,31}, {-7,32}, {-7,33}, {-7,34}, {-7,35}, {-7,36}, {-7,37}, {-7,38}, {-7,39}, {-7,40}, {-7,41}, {-7,42}, {-7,43}, {-7,44}, {-7,45}, {-7,46}, {-7,47}, {-7,48}, {-7,49}, {-7,50}, {-7,51}, {-7,52}, {-7,53}, {-7,54}, {-7,55}, {-7,56}, {-7,57}, {-7,58}, {-7,59}, {-7,60}, {-7,61}, {-7,62}, {-7,63}, {-6,-63}, {-6,-62}, {-6,-61}, {-6,-60}, {-6,-59}, {-6,-58}, {-6,-57}, {-6,-56}, {-6,-55}, {-6,-54}, {-6,-53}, {-6,-52}, {-6,-51}, {-6,-50}, {-6,-49}, {-6,-48}, {-6,-47}, {-6,-46}, {-6,-45}, {-6,-44}, {-6,-43}, {-6,-42}, {-6,-41}, {-6,-40}, {-6,-39}, {-6,-38}, {-6,-37}, {-6,-36}, {-6,-35}, {-6,-34}, {-6,-33}, {-6,-32}, {-6,-31}, {-6,27}, {-6,28}, {-6,29}, {-6,30}, {-6,32}, {-6,33}, {-6,34}, {-6,35}, {-6,36}, {-6,37}, {-6,38}, {-6,39}, {-6,40}, {-6,41}, {-6,42}, {-6,43}, {-6,44}, {-6,45}, {-6,46}, {-6,47}, {-6,48}, {-6,49}, {-6,50}, {-6,51}, {-6,52}, {-6,53}, {-6,54}, {-6,55}, {-6,56}, {-6,57}, {-6,58}, {-6,59}, {-6,60}, {-6,61}, {-6,62}, {-6,63}, {-5,-63}, {-5,-62}, {-5,-61}, {-5,-60}, {-5,-59}, {-5,-58}, {-5,-57}, {-5,-56}, {-5,-55}, {-5,-54}, {-5,-53}, {-5,-52}, {-5,-51}, {-5,-50}, {-5,-49}, {-5,-48}, {-5,-47}, {-5,-46}, {-5,-45}, {-5,-44}, {-5,-43}, {-5,-42}, {-5,-41}, {-5,-40}, {-5,-39}, {-5,-38}, {-5,-37}, {-5,-36}, {-5,-35}, {-5,-34}, {-5,-33}, {-5,-32}, {-5,-31}, {-5,31}, {-5,32}, {-5,33}, {-5,34}, {-5,35}, {-5,36}, {-5,37}, {-5,38}, {-5,39}, {-5,40}, {-5,41}, {-5,42}, {-5,43}, {-5,44}, {-5,45}, {-5,46}, {-5,47}, {-5,48}, {-5,49}, {-5,50}, {-5,51}, {-5,52}, {-5,53}, {-5,54}, {-5,55}, {-5,56}, {-5,57}, {-5,58}, {-5,59}, {-5,60}, {-5,61}, {-5,62}, {-5,63}, {-4,-63}, {-4,-62}, {-4,-61}, {-4,-60}, {-4,-59}, {-4,-58}, {-4,-57}, {-4,-56}, {-4,-55}, {-4,-54}, {-4,-53}, {-4,-52}, {-4,-51}, {-4,-50}, {-4,-49}, {-4,-48}, {-4,-47}, {-4,-46}, {-4,-45}, {-4,-44}, {-4,-43}, {-4,-42}, {-4,-41}, {-4,-40}, {-4,-39}, {-4,-38}, {-4,-37}, {-4,-36}, {-4,-35}, {-4,-34}, {-4,-33}, {-4,-32}, {-4,-31}, {-4,-14}, {-4,-13}, {-4,-12}, {-4,-11}, {-4,-10}, {-4,-9}, {-4,31}, {-4,32}, {-4,33}, {-4,34}, {-4,35}, {-4,36}, {-4,37}, {-4,38}, {-4,39}, {-4,40}, {-4,41}, {-4,42}, {-4,43}, {-4,44}, {-4,45}, {-4,46}, {-4,47}, {-4,48}, {-4,49}, {-4,50}, {-4,51}, {-4,52}, {-4,53}, {-4,54}, {-4,55}, {-4,56}, {-4,57}, {-4,58}, {-4,59}, {-4,60}, {-4,61}, {-4,62}, {-3,-63}, {-3,-62}, {-3,-61}, {-3,-60}, {-3,-59}, {-3,-58}, {-3,-57}, {-3,-56}, {-3,-55}, {-3,-54}, {-3,-53}, {-3,-52}, {-3,-51}, {-3,-50}, {-3,-49}, {-3,-48}, {-3,-47}, {-3,-46}, {-3,-45}, {-3,-44}, {-3,-43}, {-3,-42}, {-3,-41}, {-3,-40}, {-3,-39}, {-3,-38}, {-3,-37}, {-3,-36}, {-3,-35}, {-3,-34}, {-3,-33}, {-3,-32}, {-3,-31}, {-3,-30}, {-3,-29}, {-3,-15}, {-3,-14}, {-3,-13}, {-3,-12}, {-3,-11}, {-3,-10}, {-3,-9}, {-3,30}, {-3,31}, {-3,32}, {-3,33}, {-3,34}, {-3,35}, {-3,36}, {-3,37}, {-3,38}, {-3,39}, {-3,40}, {-3,41}, {-3,42}, {-3,43}, {-3,44}, {-3,45}, {-3,46}, {-3,47}, {-3,48}, {-3,49}, {-3,50}, {-3,51}, {-3,52}, {-3,53}, {-3,54}, {-3,55}, {-3,56}, {-3,57}, {-3,58}, {-3,59}, {-3,60}, {-3,61}, {-3,62}, {-2,-63}, {-2,-62}, {-2,-61}, {-2,-60}, {-2,-59}, {-2,-58}, {-2,-57}, {-2,-56}, {-2,-55}, {-2,-54}, {-2,-53}, {-2,-52}, {-2,-51}, {-2,-50}, {-2,-49}, {-2,-48}, {-2,-47}, {-2,-46}, {-2,-45}, {-2,-44}, {-2,-43}, {-2,-42}, {-2,-41}, {-2,-40}, {-2,-39}, {-2,-38}, {-2,-37}, {-2,-36}, {-2,-35}, {-2,-34}, {-2,-33}, {-2,-32}, {-2,-31}, {-2,-30}, {-2,-29}, {-2,-16}, {-2,-15}, {-2,-14}, {-2,-13}, {-2,-12}, {-2,-11}, {-2,-10}, {-2,-9}, {-2,28}, {-2,29}, {-2,30}, {-2,31}, {-2,32}, {-2,33}, {-2,34}, {-2,35}, {-2,36}, {-2,37}, {-2,38}, {-2,39}, {-2,40}, {-2,41}, {-2,42}, {-2,43}, {-2,44}, {-2,45}, {-2,46}, {-2,47}, {-2,48}, {-2,49}, {-2,50}, {-2,51}, {-2,52}, {-2,53}, {-2,54}, {-2,55}, {-2,56}, {-2,57}, {-2,58}, {-2,59}, {-2,60}, {-2,61}, {-2,62}, {-1,-63}, {-1,-62}, {-1,-61}, {-1,-60}, {-1,-59}, {-1,-58}, {-1,-57}, {-1,-56}, {-1,-55}, {-1,-54}, {-1,-53}, {-1,-52}, {-1,-51}, {-1,-50}, {-1,-49}, {-1,-48}, {-1,-47}, {-1,-46}, {-1,-45}, {-1,-44}, {-1,-43}, {-1,-42}, {-1,-41}, {-1,-40}, {-1,-39}, {-1,-38}, {-1,-37}, {-1,-36}, {-1,-35}, {-1,-34}, {-1,-33}, {-1,-32}, {-1,-31}, {-1,-30}, {-1,-29}, {-1,-19}, {-1,-18}, {-1,-17}, {-1,-16}, {-1,-15}, {-1,-14}, {-1,-13}, {-1,-12}, {-1,-11}, {-1,-10}, {-1,-9}, {-1,27}, {-1,28}, {-1,29}, {-1,30}, {-1,31}, {-1,32}, {-1,33}, {-1,34}, {-1,35}, {-1,36}, {-1,37}, {-1,38}, {-1,39}, {-1,40}, {-1,41}, {-1,42}, {-1,43}, {-1,44}, {-1,45}, {-1,46}, {-1,47}, {-1,48}, {-1,49}, {-1,50}, {-1,51}, {-1,52}, {-1,53}, {-1,54}, {-1,55}, {-1,56}, {-1,57}, {-1,58}, {-1,59}, {-1,60}, {-1,61}, {-1,62}, {0,-63}, {0,-62}, {0,-61}, {0,-60}, {0,-59}, {0,-58}, {0,-57}, {0,-56}, {0,-55}, {0,-54}, {0,-53}, {0,-52}, {0,-51}, {0,-50}, {0,-49}, {0,-48}, {0,-47}, {0,-46}, {0,-45}, {0,-44}, {0,-43}, {0,-42}, {0,-41}, {0,-40}, {0,-39}, {0,-38}, {0,-37}, {0,-36}, {0,-35}, {0,-34}, {0,-33}, {0,-32}, {0,-31}, {0,-30}, {0,-29}, {0,-28}, {0,-19}, {0,-18}, {0,-17}, {0,-16}, {0,-15}, {0,-14}, {0,-13}, {0,-12}, {0,-11}, {0,-10}, {0,-9}, {0,28}, {0,29}, {0,30}, {0,31}, {0,32}, {0,33}, {0,34}, {0,35}, {0,36}, {0,37}, {0,38}, {0,39}, {0,40}, {0,41}, {0,42}, {0,43}, {0,44}, {0,45}, {0,46}, {0,47}, {0,48}, {0,49}, {0,50}, {0,51}, {0,52}, {0,53}, {0,54}, {0,55}, {0,56}, {0,57}, {0,58}, {0,59}, {0,60}, {0,61}, {1,-63}, {1,-62}, {1,-61}, {1,-60}, {1,-59}, {1,-58}, {1,-57}, {1,-56}, {1,-55}, {1,-54}, {1,-53}, {1,-52}, {1,-51}, {1,-50}, {1,-49}, {1,-48}, {1,-47}, {1,-46}, {1,-45}, {1,-44}, {1,-43}, {1,-42}, {1,-41}, {1,-40}, {1,-39}, {1,-38}, {1,-37}, {1,-36}, {1,-35}, {1,-34}, {1,-33}, {1,-32}, {1,-31}, {1,-30}, {1,-29}, {1,-28}, {1,-27}, {1,-20}, {1,-19}, {1,-18}, {1,-17}, {1,-16}, {1,-15}, {1,-14}, {1,-13}, {1,-12}, {1,-11}, {1,-10}, {1,-9}, {1,29}, {1,30}, {1,31}, {1,32}, {1,33}, {1,34}, {1,35}, {1,36}, {1,37}, {1,38}, {1,39}, {1,40}, {1,41}, {1,42}, {1,43}, {1,44}, {1,45}, {1,46}, {1,47}, {1,48}, {1,49}, {1,50}, {1,51}, {1,52}, {1,53}, {1,54}, {1,55}, {1,56}, {1,57}, {1,58}, {1,59}, {1,60}, {1,61}, {2,-62}, {2,-61}, {2,-60}, {2,-59}, {2,-58}, {2,-57}, {2,-56}, {2,-55}, {2,-54}, {2,-53}, {2,-52}, {2,-51}, {2,-50}, {2,-49}, {2,-48}, {2,-47}, {2,-46}, {2,-45}, {2,-44}, {2,-43}, {2,-42}, {2,-41}, {2,-40}, {2,-39}, {2,-38}, {2,-37}, {2,-36}, {2,-35}, {2,-34}, {2,-33}, {2,-32}, {2,-31}, {2,-30}, {2,-29}, {2,-28}, {2,-27}, {2,-26}, {2,-25}, {2,-23}, {2,-22}, {2,-21}, {2,-20}, {2,-19}, {2,-18}, {2,-17}, {2,-16}, {2,-15}, {2,-14}, {2,-13}, {2,-12}, {2,-11}, {2,-10}, {2,-9}, {2,27}, {2,28}, {2,29}, {2,30}, {2,31}, {2,32}, {2,33}, {2,34}, {2,35}, {2,36}, {2,37}, {2,38}, {2,39}, {2,40}, {2,41}, {2,42}, {2,43}, {2,44}, {2,45}, {2,46}, {2,47}, {2,48}, {2,49}, {2,50}, {2,51}, {2,52}, {2,53}, {2,54}, {2,55}, {2,56}, {2,57}, {2,58}, {2,59}, {2,60}, {2,61}, {3,-62}, {3,-61}, {3,-60}, {3,-59}, {3,-58}, {3,-57}, {3,-56}, {3,-55}, {3,-54}, {3,-53}, {3,-52}, {3,-51}, {3,-50}, {3,-49}, {3,-48}, {3,-47}, {3,-46}, {3,-45}, {3,-44}, {3,-43}, {3,-42}, {3,-41}, {3,-40}, {3,-39}, {3,-38}, {3,-37}, {3,-36}, {3,-35}, {3,-34}, {3,-33}, {3,-32}, {3,-31}, {3,-30}, {3,-29}, {3,-28}, {3,-27}, {3,-26}, {3,-25}, {3,-24}, {3,-23}, {3,-22}, {3,-21}, {3,-20}, {3,-19}, {3,-18}, {3,-17}, {3,-16}, {3,-15}, {3,-14}, {3,-13}, {3,-12}, {3,-11}, {3,-10}, {3,-9}, {3,27}, {3,28}, {3,29}, {3,30}, {3,31}, {3,32}, {3,33}, {3,34}, {3,35}, {3,36}, {3,37}, {3,38}, {3,39}, {3,40}, {3,41}, {3,42}, {3,43}, {3,44}, {3,45}, {3,46}, {3,47}, {3,48}, {3,49}, {3,50}, {3,51}, {3,52}, {3,53}, {3,54}, {3,55}, {3,56}, {3,57}, {3,58}, {3,59}, {3,60}, {3,61}, {4,-62}, {4,-61}, {4,-60}, {4,-59}, {4,-58}, {4,-57}, {4,-56}, {4,-55}, {4,-54}, {4,-53}, {4,-52}, {4,-51}, {4,-50}, {4,-49}, {4,-48}, {4,-47}, {4,-46}, {4,-45}, {4,-44}, {4,-43}, {4,-42}, {4,-41}, {4,-40}, {4,-39}, {4,-38}, {4,-37}, {4,-36}, {4,-35}, {4,-34}, {4,-33}, {4,-32}, {4,-31}, {4,-30}, {4,-29}, {4,-28}, {4,-27}, {4,-26}, {4,-25}, {4,-24}, {4,-23}, {4,-22}, {4,-21}, {4,-20}, {4,-19}, {4,-18}, {4,-17}, {4,-16}, {4,-15}, {4,-14}, {4,-13}, {4,-12}, {4,-11}, {4,-10}, {4,-9}, {4,27}, {4,28}, {4,29}, {4,30}, {4,31}, {4,32}, {4,33}, {4,34}, {4,35}, {4,36}, {4,37}, {4,38}, {4,39}, {4,40}, {4,41}, {4,42}, {4,43}, {4,44}, {4,45}, {4,46}, {4,47}, {4,48}, {4,49}, {4,50}, {4,51}, {4,52}, {4,53}, {4,54}, {4,55}, {4,56}, {4,57}, {4,58}, {4,59}, {4,60}, {5,-62}, {5,-61}, {5,-60}, {5,-59}, {5,-58}, {5,-57}, {5,-56}, {5,-55}, {5,-54}, {5,-53}, {5,-52}, {5,-51}, {5,-50}, {5,-49}, {5,-48}, {5,-47}, {5,-46}, {5,-45}, {5,-44}, {5,-43}, {5,-42}, {5,-41}, {5,-40}, {5,-39}, {5,-38}, {5,-37}, {5,-36}, {5,-35}, {5,-34}, {5,-33}, {5,-32}, {5,-28}, {5,-27}, {5,-23}, {5,-22}, {5,-21}, {5,-20}, {5,-19}, {5,-18}, {5,-17}, {5,-16}, {5,-15}, {5,-14}, {5,-13}, {5,-12}, {5,-11}, {5,28}, {5,29}, {5,30}, {5,31}, {5,32}, {5,33}, {5,34}, {5,35}, {5,36}, {5,37}, {5,38}, {5,39}, {5,40}, {5,41}, {5,42}, {5,43}, {5,44}, {5,45}, {5,46}, {5,47}, {5,48}, {5,49}, {5,50}, {5,51}, {5,52}, {5,53}, {5,54}, {5,55}, {5,56}, {5,57}, {5,58}, {5,59}, {5,60}, {6,-62}, {6,-61}, {6,-60}, {6,-59}, {6,-58}, {6,-57}, {6,-56}, {6,-55}, {6,-54}, {6,-53}, {6,-52}, {6,-51}, {6,-50}, {6,-49}, {6,-48}, {6,-47}, {6,-46}, {6,-45}, {6,-44}, {6,-43}, {6,-42}, {6,-41}, {6,-40}, {6,-39}, {6,-38}, {6,-37}, {6,-36}, {6,-35}, {6,-34}, {6,-33}, {6,-32}, {6,-28}, {6,-27}, {6,-23}, {6,-22}, {6,-21}, {6,-20}, {6,-19}, {6,-18}, {6,-17}, {6,-16}, {6,-15}, {6,-14}, {6,-13}, {6,-12}, {6,28}, {6,29}, {6,30}, {6,31}, {6,32}, {6,33}, {6,34}, {6,35}, {6,36}, {6,37}, {6,38}, {6,39}, {6,40}, {6,41}, {6,42}, {6,43}, {6,44}, {6,45}, {6,46}, {6,47}, {6,48}, {6,49}, {6,50}, {6,51}, {6,52}, {6,53}, {6,54}, {6,55}, {6,56}, {6,57}, {6,58}, {6,59}, {6,60}, {7,-62}, {7,-61}, {7,-60}, {7,-59}, {7,-58}, {7,-57}, {7,-56}, {7,-55}, {7,-54}, {7,-53}, {7,-52}, {7,-51}, {7,-50}, {7,-49}, {7,-48}, {7,-47}, {7,-46}, {7,-45}, {7,-44}, {7,-43}, {7,-42}, {7,-41}, {7,-40}, {7,-39}, {7,-38}, {7,-37}, {7,-36}, {7,-35}, {7,-34}, {7,-33}, {7,-32}, {7,-28}, {7,-27}, {7,-23}, {7,-22}, {7,-21}, {7,-20}, {7,-19}, {7,-18}, {7,-17}, {7,-16}, {7,-15}, {7,-14}, {7,-13}, {7,-12}, {7,29}, {7,30}, {7,31}, {7,32}, {7,33}, {7,34}, {7,35}, {7,36}, {7,37}, {7,38}, {7,39}, {7,40}, {7,41}, {7,42}, {7,43}, {7,44}, {7,45}, {7,46}, {7,47}, {7,48}, {7,49}, {7,50}, {7,51}, {7,52}, {7,53}, {7,54}, {7,55}, {7,56}, {7,57}, {7,58}, {7,59}, {8,-62}, {8,-61}, {8,-60}, {8,-59}, {8,-58}, {8,-57}, {8,-56}, {8,-55}, {8,-54}, {8,-53}, {8,-52}, {8,-51}, {8,-50}, {8,-49}, {8,-48}, {8,-47}, {8,-46}, {8,-45}, {8,-44}, {8,-43}, {8,-42}, {8,-41}, {8,-40}, {8,-39}, {8,-38}, {8,-37}, {8,-36}, {8,-35}, {8,-34}, {8,-33}, {8,-28}, {8,-27}, {8,-22}, {8,-21}, {8,-20}, {8,-19}, {8,-18}, {8,-17}, {8,-16}, {8,-15}, {8,29}, {8,30}, {8,31}, {8,32}, {8,33}, {8,34}, {8,35}, {8,36}, {8,37}, {8,38}, {8,39}, {8,40}, {8,41}, {8,42}, {8,43}, {8,44}, {8,45}, {8,46}, {8,47}, {8,48}, {8,49}, {8,50}, {8,51}, {8,52}, {8,53}, {8,54}, {8,55}, {8,56}, {8,57}, {8,58}, {8,59}, {9,-62}, {9,-61}, {9,-60}, {9,-59}, {9,-58}, {9,-57}, {9,-56}, {9,-55}, {9,-54}, {9,-53}, {9,-52}, {9,-51}, {9,-50}, {9,-49}, {9,-48}, {9,-47}, {9,-46}, {9,-45}, {9,-44}, {9,-43}, {9,-42}, {9,-41}, {9,-40}, {9,-39}, {9,-38}, {9,-37}, {9,-36}, {9,-35}, {9,-34}, {9,-33}, {9,-28}, {9,-27}, {9,-22}, {9,-21}, {9,-20}, {9,-19}, {9,-18}, {9,-17}, {9,30}, {9,31}, {9,32}, {9,33}, {9,34}, {9,35}, {9,36}, {9,37}, {9,38}, {9,39}, {9,40}, {9,41}, {9,42}, {9,43}, {9,44}, {9,45}, {9,46}, {9,47}, {9,48}, {9,49}, {9,50}, {9,51}, {9,52}, {9,53}, {9,54}, {9,55}, {9,56}, {9,57}, {9,58}, {9,59}, {10,-62}, {10,-61}, {10,-60}, {10,-59}, {10,-58}, {10,-57}, {10,-56}, {10,-55}, {10,-54}, {10,-53}, {10,-52}, {10,-51}, {10,-50}, {10,-49}, {10,-48}, {10,-47}, {10,-46}, {10,-45}, {10,-44}, {10,-43}, {10,-42}, {10,-41}, {10,-40}, {10,-39}, {10,-38}, {10,-37}, {10,-36}, {10,-35}, {10,-34}, {10,-33}, {10,-28}, {10,-27}, {10,-22}, {10,-21}, {10,-20}, {10,-19}, {10,-18}, {10,-17}, {10,30}, {10,31}, {10,32}, {10,33}, {10,34}, {10,35}, {10,36}, {10,37}, {10,38}, {10,39}, {10,40}, {10,41}, {10,42}, {10,43}, {10,44}, {10,45}, {10,46}, {10,47}, {10,48}, {10,49}, {10,50}, {10,51}, {10,52}, {10,53}, {10,54}, {10,55}, {10,56}, {10,57}, {10,58}, {10,59}, {11,-62}, {11,-61}, {11,-60}, {11,-59}, {11,-58}, {11,-57}, {11,-56}, {11,-55}, {11,-54}, {11,-53}, {11,-52}, {11,-51}, {11,-50}, {11,-49}, {11,-48}, {11,-47}, {11,-46}, {11,-45}, {11,-44}, {11,-43}, {11,-42}, {11,-41}, {11,-40}, {11,-39}, {11,-38}, {11,-37}, {11,-36}, {11,-35}, {11,-34}, {11,-33}, {11,-28}, {11,-27}, {11,-22}, {11,-21}, {11,-20}, {11,-19}, {11,-18}, {11,30}, {11,31}, {11,32}, {11,33}, {11,34}, {11,35}, {11,36}, {11,37}, {11,38}, {11,39}, {11,40}, {11,41}, {11,42}, {11,43}, {11,44}, {11,45}, {11,46}, {11,47}, {11,48}, {11,49}, {11,50}, {11,51}, {11,52}, {11,53}, {11,54}, {11,55}, {11,56}, {11,57}, {11,58}, {11,59}, {12,-62}, {12,-61}, {12,-60}, {12,-59}, {12,-58}, {12,-57}, {12,-56}, {12,-55}, {12,-54}, {12,-53}, {12,-52}, {12,-51}, {12,-50}, {12,-49}, {12,-48}, {12,-47}, {12,-46}, {12,-45}, {12,-44}, {12,-43}, {12,-42}, {12,-41}, {12,-40}, {12,-39}, {12,-38}, {12,-37}, {12,-36}, {12,-35}, {12,-34}, {12,-33}, {12,-28}, {12,-27}, {12,-22}, {12,-21}, {12,-20}, {12,-19}, {12,-18}, {12,30}, {12,31}, {12,32}, {12,33}, {12,34}, {12,35}, {12,36}, {12,37}, {12,38}, {12,39}, {12,40}, {12,41}, {12,42}, {12,43}, {12,44}, {12,45}, {12,46}, {12,47}, {12,48}, {12,49}, {12,50}, {12,51}, {12,52}, {12,53}, {12,54}, {12,55}, {12,56}, {12,57}, {12,58}, {12,59}, {13,-62}, {13,-61}, {13,-60}, {13,-59}, {13,-58}, {13,-57}, {13,-56}, {13,-55}, {13,-54}, {13,-53}, {13,-52}, {13,-51}, {13,-50}, {13,-49}, {13,-48}, {13,-47}, {13,-46}, {13,-45}, {13,-44}, {13,-43}, {13,-42}, {13,-41}, {13,-40}, {13,-39}, {13,-38}, {13,-37}, {13,-36}, {13,-35}, {13,-34}, {13,-33}, {13,-28}, {13,-27}, {13,-22}, {13,-21}, {13,-20}, {13,30}, {13,31}, {13,32}, {13,33}, {13,34}, {13,35}, {13,36}, {13,37}, {13,38}, {13,39}, {13,40}, {13,41}, {13,42}, {13,43}, {13,44}, {13,45}, {13,46}, {13,47}, {13,48}, {13,49}, {13,50}, {13,51}, {13,52}, {13,53}, {13,54}, {13,55}, {13,56}, {13,57}, {13,58}, {13,59}, {14,-62}, {14,-61}, {14,-60}, {14,-59}, {14,-58}, {14,-57}, {14,-56}, {14,-55}, {14,-54}, {14,-53}, {14,-52}, {14,-51}, {14,-50}, {14,-49}, {14,-48}, {14,-47}, {14,-46}, {14,-45}, {14,-44}, {14,-43}, {14,-42}, {14,-41}, {14,-40}, {14,-39}, {14,-38}, {14,-37}, {14,-36}, {14,-35}, {14,-34}, {14,-33}, {14,-28}, {14,-27}, {14,-22}, {14,-21}, {14,-20}, {14,30}, {14,31}, {14,32}, {14,33}, {14,34}, {14,35}, {14,36}, {14,37}, {14,38}, {14,39}, {14,40}, {14,41}, {14,42}, {14,43}, {14,44}, {14,45}, {14,46}, {14,47}, {14,48}, {14,49}, {14,50}, {14,51}, {14,52}, {14,53}, {14,54}, {14,55}, {14,56}, {14,57}, {14,58}, {14,59}, {15,-62}, {15,-61}, {15,-60}, {15,-59}, {15,-58}, {15,-57}, {15,-56}, {15,-55}, {15,-54}, {15,-53}, {15,-52}, {15,-51}, {15,-50}, {15,-49}, {15,-48}, {15,-47}, {15,-46}, {15,-45}, {15,-44}, {15,-43}, {15,-42}, {15,-41}, {15,-40}, {15,-39}, {15,-38}, {15,-37}, {15,-36}, {15,-35}, {15,-34}, {15,-33}, {15,-28}, {15,-27}, {15,-22}, {15,-21}, {15,-20}, {15,31}, {15,32}, {15,33}, {15,34}, {15,35}, {15,36}, {15,37}, {15,38}, {15,39}, {15,40}, {15,41}, {15,42}, {15,43}, {15,44}, {15,45}, {15,46}, {15,47}, {15,48}, {15,49}, {15,50}, {15,51}, {15,52}, {15,53}, {15,54}, {15,55}, {15,56}, {15,57}, {15,58}, {15,59}, {16,-62}, {16,-61}, {16,-60}, {16,-59}, {16,-58}, {16,-57}, {16,-56}, {16,-55}, {16,-54}, {16,-53}, {16,-52}, {16,-51}, {16,-50}, {16,-49}, {16,-48}, {16,-47}, {16,-46}, {16,-45}, {16,-44}, {16,-43}, {16,-42}, {16,-41}, {16,-40}, {16,-39}, {16,-38}, {16,-37}, {16,-36}, {16,-35}, {16,-34}, {16,-33}, {16,-32}, {16,-29}, {16,-28}, {16,-27}, {16,-26}, {16,-23}, {16,-22}, {16,-21}, {16,-20}, {16,31}, {16,32}, {16,33}, {16,34}, {16,35}, {16,36}, {16,37}, {16,38}, {16,39}, {16,40}, {16,41}, {16,42}, {16,43}, {16,44}, {16,45}, {16,46}, {16,47}, {16,48}, {16,49}, {16,50}, {16,51}, {16,52}, {16,53}, {16,54}, {16,55}, {16,56}, {16,57}, {16,58}, {16,59}, {17,-62}, {17,-61}, {17,-60}, {17,-59}, {17,-58}, {17,-57}, {17,-56}, {17,-55}, {17,-54}, {17,-53}, {17,-52}, {17,-51}, {17,-50}, {17,-49}, {17,-48}, {17,-47}, {17,-46}, {17,-45}, {17,-44}, {17,-43}, {17,-42}, {17,-41}, {17,-40}, {17,-39}, {17,-38}, {17,-37}, {17,-36}, {17,-35}, {17,-34}, {17,-33}, {17,-32}, {17,31}, {17,32}, {17,33}, {17,34}, {17,35}, {17,36}, {17,37}, {17,38}, {17,39}, {17,40}, {17,41}, {17,42}, {17,43}, {17,44}, {17,45}, {17,46}, {17,47}, {17,48}, {17,49}, {17,50}, {17,51}, {17,52}, {17,53}, {17,54}, {17,55}, {17,56}, {17,57}, {17,58}, {17,59}, {18,-62}, {18,-61}, {18,-60}, {18,-59}, {18,-58}, {18,-57}, {18,-56}, {18,-55}, {18,-54}, {18,-53}, {18,-52}, {18,-51}, {18,-50}, {18,-49}, {18,-48}, {18,-47}, {18,-46}, {18,-45}, {18,-44}, {18,-43}, {18,-42}, {18,-41}, {18,-40}, {18,-39}, {18,-38}, {18,-37}, {18,-36}, {18,-35}, {18,-34}, {18,-33}, {18,-32}, {18,31}, {18,32}, {18,33}, {18,34}, {18,35}, {18,36}, {18,37}, {18,38}, {18,39}, {18,40}, {18,41}, {18,42}, {18,43}, {18,44}, {18,45}, {18,46}, {18,47}, {18,48}, {18,49}, {18,50}, {18,51}, {18,52}, {18,53}, {18,54}, {18,55}, {18,56}, {18,57}, {18,58}, {18,59}, {19,-62}, {19,-61}, {19,-60}, {19,-59}, {19,-58}, {19,-57}, {19,-56}, {19,-55}, {19,-54}, {19,-53}, {19,-52}, {19,-51}, {19,-50}, {19,-49}, {19,-48}, {19,-47}, {19,-46}, {19,-45}, {19,-44}, {19,-43}, {19,-42}, {19,-41}, {19,-40}, {19,-39}, {19,-38}, {19,-37}, {19,-36}, {19,-35}, {19,-34}, {19,-33}, {19,-32}, {19,-29}, {19,-28}, {19,-27}, {19,-26}, {19,-23}, {19,-22}, {19,-21}, {19,31}, {19,32}, {19,33}, {19,34}, {19,35}, {19,36}, {19,37}, {19,38}, {19,39}, {19,40}, {19,41}, {19,42}, {19,43}, {19,44}, {19,45}, {19,46}, {19,47}, {19,48}, {19,49}, {19,50}, {19,51}, {19,52}, {19,53}, {19,54}, {19,55}, {19,56}, {19,57}, {19,58}, {19,59}, {20,-61}, {20,-60}, {20,-59}, {20,-58}, {20,-57}, {20,-56}, {20,-55}, {20,-54}, {20,-53}, {20,-52}, {20,-51}, {20,-50}, {20,-49}, {20,-48}, {20,-47}, {20,-46}, {20,-45}, {20,-44}, {20,-43}, {20,-42}, {20,-41}, {20,-40}, {20,-39}, {20,-38}, {20,-37}, {20,-36}, {20,-35}, {20,-34}, {20,-33}, {20,-28}, {20,-27}, {20,-22}, {20,-21}, {20,-20}, {20,31}, {20,32}, {20,33}, {20,34}, {20,35}, {20,36}, {20,37}, {20,38}, {20,39}, {20,40}, {20,41}, {20,42}, {20,43}, {20,44}, {20,45}, {20,46}, {20,47}, {20,48}, {20,49}, {20,50}, {20,51}, {20,52}, {20,53}, {20,54}, {20,55}, {20,56}, {20,57}, {20,58}, {20,59}, {21,-61}, {21,-60}, {21,-59}, {21,-58}, {21,-57}, {21,-56}, {21,-55}, {21,-54}, {21,-53}, {21,-52}, {21,-51}, {21,-50}, {21,-49}, {21,-48}, {21,-47}, {21,-46}, {21,-45}, {21,-44}, {21,-43}, {21,-42}, {21,-41}, {21,-40}, {21,-39}, {21,-38}, {21,-37}, {21,-36}, {21,-35}, {21,-34}, {21,-33}, {21,-28}, {21,-27}, {21,-22}, {21,-21}, {21,-20}, {21,32}, {21,33}, {21,34}, {21,35}, {21,36}, {21,37}, {21,38}, {21,39}, {21,40}, {21,41}, {21,42}, {21,43}, {21,44}, {21,45}, {21,46}, {21,47}, {21,48}, {21,49}, {21,50}, {21,51}, {21,52}, {21,53}, {21,54}, {21,55}, {21,56}, {21,57}, {21,58}, {21,59}, {22,-61}, {22,-60}, {22,-59}, {22,-58}, {22,-57}, {22,-56}, {22,-55}, {22,-54}, {22,-53}, {22,-52}, {22,-51}, {22,-50}, {22,-49}, {22,-48}, {22,-47}, {22,-46}, {22,-45}, {22,-44}, {22,-43}, {22,-42}, {22,-41}, {22,-40}, {22,-39}, {22,-38}, {22,-37}, {22,-36}, {22,-35}, {22,-34}, {22,-33}, {22,-28}, {22,-27}, {22,-22}, {22,-21}, {22,-20}, {22,-19}, {22,32}, {22,33}, {22,34}, {22,35}, {22,36}, {22,37}, {22,38}, {22,39}, {22,40}, {22,41}, {22,42}, {22,43}, {22,44}, {22,45}, {22,46}, {22,47}, {22,48}, {22,49}, {22,50}, {22,51}, {22,52}, {22,53}, {22,54}, {22,55}, {22,56}, {22,57}, {22,58}, {22,59}, {23,-60}, {23,-59}, {23,-58}, {23,-57}, {23,-56}, {23,-55}, {23,-54}, {23,-53}, {23,-52}, {23,-51}, {23,-50}, {23,-49}, {23,-48}, {23,-47}, {23,-46}, {23,-45}, {23,-44}, {23,-43}, {23,-42}, {23,-41}, {23,-40}, {23,-39}, {23,-38}, {23,-37}, {23,-36}, {23,-35}, {23,-34}, {23,-33}, {23,-28}, {23,-27}, {23,-22}, {23,-21}, {23,-20}, {23,-19}, {23,-18}, {23,32}, {23,33}, {23,34}, {23,35}, {23,36}, {23,37}, {23,38}, {23,39}, {23,40}, {23,41}, {23,42}, {23,43}, {23,44}, {23,45}, {23,46}, {23,47}, {23,48}, {23,49}, {23,50}, {23,51}, {23,52}, {23,53}, {23,54}, {23,55}, {23,56}, {23,57}, {23,58}, {23,59}, {24,-60}, {24,-59}, {24,-58}, {24,-57}, {24,-56}, {24,-55}, {24,-54}, {24,-53}, {24,-52}, {24,-51}, {24,-50}, {24,-49}, {24,-48}, {24,-47}, {24,-46}, {24,-45}, {24,-44}, {24,-43}, {24,-42}, {24,-41}, {24,-40}, {24,-39}, {24,-38}, {24,-37}, {24,-36}, {24,-35}, {24,-34}, {24,-33}, {24,-28}, {24,-27}, {24,-22}, {24,-21}, {24,-20}, {24,-19}, {24,-18}, {24,32}, {24,33}, {24,34}, {24,35}, {24,36}, {24,37}, {24,38}, {24,39}, {24,40}, {24,41}, {24,42}, {24,43}, {24,44}, {24,45}, {24,46}, {24,47}, {24,48}, {24,49}, {24,50}, {24,51}, {24,52}, {24,53}, {24,54}, {24,55}, {24,56}, {24,57}, {24,58}, {24,59}, {25,-60}, {25,-59}, {25,-58}, {25,-57}, {25,-56}, {25,-55}, {25,-54}, {25,-53}, {25,-52}, {25,-51}, {25,-50}, {25,-49}, {25,-48}, {25,-47}, {25,-46}, {25,-45}, {25,-44}, {25,-43}, {25,-42}, {25,-41}, {25,-40}, {25,-39}, {25,-38}, {25,-37}, {25,-36}, {25,-35}, {25,-34}, {25,-33}, {25,-28}, {25,-27}, {25,-22}, {25,-21}, {25,-20}, {25,-19}, {25,-18}, {25,-17}, {25,-16}, {25,32}, {25,33}, {25,34}, {25,35}, {25,36}, {25,37}, {25,38}, {25,39}, {25,40}, {25,41}, {25,42}, {25,43}, {25,44}, {25,45}, {25,46}, {25,47}, {25,48}, {25,49}, {25,50}, {25,51}, {25,52}, {25,53}, {25,54}, {25,55}, {25,56}, {25,57}, {25,58}, {25,59}, {26,-60}, {26,-59}, {26,-58}, {26,-57}, {26,-56}, {26,-55}, {26,-54}, {26,-53}, {26,-52}, {26,-51}, {26,-50}, {26,-49}, {26,-48}, {26,-47}, {26,-46}, {26,-45}, {26,-44}, {26,-43}, {26,-42}, {26,-41}, {26,-40}, {26,-39}, {26,-38}, {26,-37}, {26,-36}, {26,-35}, {26,-34}, {26,-33}, {26,-28}, {26,-27}, {26,-22}, {26,-21}, {26,-20}, {26,-19}, {26,-18}, {26,-17}, {26,-16}, {26,27}, {26,28}, {26,29}, {26,32}, {26,33}, {26,34}, {26,35}, {26,36}, {26,37}, {26,38}, {26,39}, {26,40}, {26,41}, {26,42}, {26,43}, {26,44}, {26,45}, {26,46}, {26,47}, {26,48}, {26,49}, {26,50}, {26,51}, {26,52}, {26,53}, {26,54}, {26,55}, {26,56}, {26,57}, {26,58}, {26,59}, {26,60}, {27,-60}, {27,-59}, {27,-58}, {27,-57}, {27,-56}, {27,-55}, {27,-54}, {27,-53}, {27,-52}, {27,-51}, {27,-50}, {27,-49}, {27,-48}, {27,-47}, {27,-46}, {27,-45}, {27,-44}, {27,-43}, {27,-42}, {27,-41}, {27,-40}, {27,-39}, {27,-38}, {27,-37}, {27,-36}, {27,-35}, {27,-34}, {27,-33}, {27,-28}, {27,-27}, {27,-22}, {27,-21}, {27,-20}, {27,-19}, {27,-18}, {27,-17}, {27,-16}, {27,23}, {27,24}, {27,25}, {27,26}, {27,27}, {27,28}, {27,29}, {27,30}, {27,31}, {27,32}, {27,33}, {27,34}, {27,35}, {27,36}, {27,37}, {27,38}, {27,39}, {27,40}, {27,41}, {27,42}, {27,43}, {27,44}, {27,45}, {27,46}, {27,47}, {27,48}, {27,49}, {27,50}, {27,51}, {27,52}, {27,53}, {27,54}, {27,55}, {27,56}, {27,57}, {27,58}, {27,59}, {27,60}, {28,-60}, {28,-59}, {28,-58}, {28,-57}, {28,-56}, {28,-55}, {28,-54}, {28,-53}, {28,-52}, {28,-51}, {28,-50}, {28,-49}, {28,-48}, {28,-47}, {28,-46}, {28,-45}, {28,-44}, {28,-43}, {28,-42}, {28,-41}, {28,-40}, {28,-39}, {28,-38}, {28,-37}, {28,-36}, {28,-35}, {28,-34}, {28,-33}, {28,-32}, {28,-28}, {28,-27}, {28,-23}, {28,-22}, {28,-21}, {28,-20}, {28,-19}, {28,-18}, {28,-17}, {28,-16}, {28,-15}, {28,22}, {28,23}, {28,24}, {28,25}, {28,26}, {28,27}, {28,28}, {28,29}, {28,30}, {28,31}, {28,32}, {28,33}, {28,34}, {28,35}, {28,36}, {28,37}, {28,38}, {28,39}, {28,40}, {28,41}, {28,42}, {28,43}, {28,44}, {28,45}, {28,46}, {28,47}, {28,48}, {28,49}, {28,50}, {28,51}, {28,52}, {28,53}, {28,54}, {28,55}, {28,56}, {28,57}, {28,58}, {28,59}, {28,60}, {29,-60}, {29,-59}, {29,-58}, {29,-57}, {29,-56}, {29,-55}, {29,-54}, {29,-53}, {29,-52}, {29,-51}, {29,-50}, {29,-49}, {29,-48}, {29,-47}, {29,-46}, {29,-45}, {29,-44}, {29,-43}, {29,-42}, {29,-41}, {29,-40}, {29,-39}, {29,-38}, {29,-37}, {29,-36}, {29,-35}, {29,-34}, {29,-33}, {29,-32}, {29,-28}, {29,-27}, {29,-23}, {29,-22}, {29,-21}, {29,-20}, {29,-19}, {29,-18}, {29,-17}, {29,-16}, {29,-15}, {29,-14}, {29,-13}, {29,-12}, {29,-11}, {29,-10}, {29,20}, {29,21}, {29,22}, {29,23}, {29,24}, {29,25}, {29,26}, {29,27}, {29,28}, {29,29}, {29,30}, {29,31}, {29,32}, {29,33}, {29,34}, {29,35}, {29,36}, {29,37}, {29,38}, {29,39}, {29,40}, {29,41}, {29,42}, {29,43}, {29,44}, {29,45}, {29,46}, {29,47}, {29,48}, {29,49}, {29,50}, {29,51}, {29,52}, {29,53}, {29,54}, {29,55}, {29,56}, {29,57}, {29,58}, {29,59}, {29,60}, {30,-60}, {30,-59}, {30,-58}, {30,-57}, {30,-56}, {30,-55}, {30,-54}, {30,-53}, {30,-52}, {30,-51}, {30,-50}, {30,-49}, {30,-48}, {30,-47}, {30,-46}, {30,-45}, {30,-44}, {30,-43}, {30,-42}, {30,-41}, {30,-40}, {30,-39}, {30,-38}, {30,-37}, {30,-36}, {30,-35}, {30,-34}, {30,-33}, {30,-32}, {30,-28}, {30,-27}, {30,-23}, {30,-22}, {30,-21}, {30,-20}, {30,-19}, {30,-18}, {30,-17}, {30,-16}, {30,-15}, {30,-14}, {30,-13}, {30,-12}, {30,-11}, {30,-10}, {30,-9}, {30,15}, {30,16}, {30,17}, {30,18}, {30,19}, {30,20}, {30,21}, {30,22}, {30,23}, {30,24}, {30,25}, {30,26}, {30,27}, {30,28}, {30,29}, {30,30}, {30,31}, {30,32}, {30,33}, {30,34}, {30,35}, {30,36}, {30,37}, {30,38}, {30,39}, {30,40}, {30,41}, {30,42}, {30,43}, {30,44}, {30,45}, {30,46}, {30,47}, {30,48}, {30,49}, {30,50}, {30,51}, {30,52}, {30,53}, {30,54}, {30,55}, {30,56}, {30,57}, {30,58}, {30,59}, {30,60}, {31,-60}, {31,-59}, {31,-58}, {31,-57}, {31,-56}, {31,-55}, {31,-54}, {31,-53}, {31,-52}, {31,-51}, {31,-50}, {31,-49}, {31,-48}, {31,-47}, {31,-46}, {31,-45}, {31,-44}, {31,-43}, {31,-42}, {31,-41}, {31,-40}, {31,-39}, {31,-38}, {31,-37}, {31,-36}, {31,-35}, {31,-34}, {31,-33}, {31,-32}, {31,-31}, {31,-30}, {31,-29}, {31,-28}, {31,-27}, {31,-26}, {31,-25}, {31,-24}, {31,-23}, {31,-22}, {31,-21}, {31,-20}, {31,-19}, {31,-18}, {31,-17}, {31,-16}, {31,-15}, {31,-14}, {31,-13}, {31,-12}, {31,-11}, {31,-10}, {31,-9}, {31,-8}, {31,-7}, {31,-6}, {31,0}, {31,1}, {31,2}, {31,14}, {31,15}, {31,16}, {31,17}, {31,18}, {31,19}, {31,20}, {31,21}, {31,22}, {31,23}, {31,24}, {31,25}, {31,26}, {31,27}, {31,28}, {31,29}, {31,30}, {31,31}, {31,32}, {31,33}, {31,34}, {31,35}, {31,36}, {31,37}, {31,38}, {31,39}, {31,40}, {31,41}, {31,42}, {31,43}, {31,44}, {31,45}, {31,46}, {31,47}, {31,48}, {31,49}, {31,50}, {31,51}, {31,52}, {31,53}, {31,54}, {31,55}, {31,56}, {31,57}, {31,58}, {31,59}, {31,60}, {32,-60}, {32,-59}, {32,-58}, {32,-57}, {32,-56}, {32,-55}, {32,-54}, {32,-53}, {32,-52}, {32,-51}, {32,-50}, {32,-49}, {32,-48}, {32,-47}, {32,-46}, {32,-45}, {32,-44}, {32,-43}, {32,-42}, {32,-41}, {32,-40}, {32,-39}, {32,-38}, {32,-37}, {32,-36}, {32,-35}, {32,-34}, {32,-33}, {32,-32}, {32,-31}, {32,-30}, {32,-29}, {32,-28}, {32,-27}, {32,-26}, {32,-25}, {32,-24}, {32,-23}, {32,-22}, {32,-21}, {32,-20}, {32,-19}, {32,-18}, {32,-17}, {32,-16}, {32,-15}, {32,-14}, {32,-13}, {32,-12}, {32,-11}, {32,-10}, {32,-9}, {32,-8}, {32,-7}, {32,-6}, {32,-5}, {32,-4}, {32,-3}, {32,-2}, {32,-1}, {32,0}, {32,1}, {32,2}, {32,3}, {32,4}, {32,5}, {32,6}, {32,7}, {32,8}, {32,9}, {32,10}, {32,11}, {32,12}, {32,13}, {32,14}, {32,15}, {32,16}, {32,17}, {32,18}, {32,19}, {32,20}, {32,21}, {32,22}, {32,23}, {32,24}, {32,25}, {32,26}, {32,27}, {32,28}, {32,29}, {32,30}, {32,31}, {32,32}, {32,33}, {32,34}, {32,35}, {32,36}, {32,37}, {32,38}, {32,39}, {32,40}, {32,41}, {32,42}, {32,43}, {32,44}, {32,45}, {32,46}, {32,47}, {32,48}, {32,49}, {32,50}, {32,51}, {32,52}, {32,53}, {32,54}, {32,55}, {32,56}, {32,57}, {32,58}, {32,59}, {32,60}, {33,-59}, {33,-58}, {33,-57}, {33,-56}, {33,-55}, {33,-54}, {33,-53}, {33,-52}, {33,-51}, {33,-50}, {33,-49}, {33,-48}, {33,-47}, {33,-46}, {33,-45}, {33,-44}, {33,-43}, {33,-42}, {33,-41}, {33,-40}, {33,-39}, {33,-38}, {33,-37}, {33,-36}, {33,-35}, {33,-34}, {33,-33}, {33,-32}, {33,-31}, {33,-30}, {33,-29}, {33,-28}, {33,-27}, {33,-26}, {33,-25}, {33,-24}, {33,-23}, {33,-22}, {33,-21}, {33,-20}, {33,-19}, {33,-18}, {33,-17}, {33,-16}, {33,-15}, {33,-14}, {33,-13}, {33,-12}, {33,-11}, {33,-10}, {33,-9}, {33,-8}, {33,-7}, {33,-6}, {33,-5}, {33,-4}, {33,-3}, {33,-2}, {33,-1}, {33,0}, {33,1}, {33,2}, {33,3}, {33,4}, {33,5}, {33,6}, {33,7}, {33,8}, {33,9}, {33,10}, {33,11}, {33,12}, {33,13}, {33,14}, {33,15}, {33,16}, {33,17}, {33,18}, {33,19}, {33,20}, {33,21}, {33,22}, {33,23}, {33,24}, {33,25}, {33,26}, {33,27}, {33,28}, {33,29}, {33,30}, {33,31}, {33,32}, {33,33}, {33,34}, {33,35}, {33,36}, {33,37}, {33,38}, {33,39}, {33,40}, {33,41}, {33,42}, {33,43}, {33,44}, {33,45}, {33,46}, {33,47}, {33,48}, {33,49}, {33,50}, {33,51}, {33,52}, {33,53}, {33,54}, {33,55}, {33,56}, {33,57}, {33,58}, {33,59}, {33,60}, {34,-57}, {34,-56}, {34,-55}, {34,-54}, {34,-53}, {34,-52}, {34,-51}, {34,-50}, {34,-49}, {34,-48}, {34,-47}, {34,-46}, {34,-45}, {34,-44}, {34,-43}, {34,-42}, {34,-41}, {34,-40}, {34,-39}, {34,-38}, {34,-37}, {34,-36}, {34,-35}, {34,-34}, {34,-33}, {34,-32}, {34,-31}, {34,-30}, {34,-29}, {34,-28}, {34,-27}, {34,-26}, {34,-25}, {34,-24}, {34,-23}, {34,-22}, {34,-21}, {34,-20}, {34,-19}, {34,-18}, {34,-17}, {34,-16}, {34,-15}, {34,-14}, {34,-13}, {34,-12}, {34,-11}, {34,-10}, {34,-9}, {34,-8}, {34,-7}, {34,-6}, {34,-5}, {34,-4}, {34,-3}, {34,-2}, {34,-1}, {34,0}, {34,1}, {34,2}, {34,3}, {34,4}, {34,5}, {34,6}, {34,7}, {34,8}, {34,9}, {34,10}, {34,11}, {34,12}, {34,13}, {34,14}, {34,15}, {34,16}, {34,17}, {34,18}, {34,19}, {34,20}, {34,21}, {34,22}, {34,23}, {34,24}, {34,25}, {34,26}, {34,27}, {34,28}, {34,29}, {34,30}, {34,31}, {34,32}, {34,33}, {34,34}, {34,35}, {34,36}, {34,37}, {34,38}, {34,39}, {34,40}, {34,41}, {34,42}, {34,43}, {34,44}, {34,45}, {34,46}, {34,47}, {34,48}, {34,49}, {34,50}, {34,51}, {34,52}, {34,53}, {34,54}, {34,55}, {34,56}, {34,57}, {34,58}, {34,59}, {34,60}, {35,-56}, {35,-55}, {35,-54}, {35,-53}, {35,-52}, {35,-51}, {35,-50}, {35,-49}, {35,-48}, {35,-47}, {35,-46}, {35,-45}, {35,-44}, {35,-43}, {35,-42}, {35,-41}, {35,-40}, {35,-39}, {35,-38}, {35,-37}, {35,-36}, {35,-35}, {35,-34}, {35,-33}, {35,-32}, {35,-31}, {35,-30}, {35,-29}, {35,-28}, {35,-27}, {35,-26}, {35,-25}, {35,-24}, {35,-23}, {35,-22}, {35,-21}, {35,-20}, {35,-19}, {35,-18}, {35,-17}, {35,-16}, {35,-15}, {35,-14}, {35,-13}, {35,-12}, {35,-11}, {35,-10}, {35,-9}, {35,-8}, {35,-7}, {35,-6}, {35,-5}, {35,-4}, {35,-3}, {35,-2}, {35,-1}, {35,0}, {35,1}, {35,2}, {35,3}, {35,4}, {35,5}, {35,6}, {35,7}, {35,8}, {35,9}, {35,10}, {35,11}, {35,12}, {35,13}, {35,14}, {35,15}, {35,16}, {35,17}, {35,18}, {35,19}, {35,20}, {35,21}, {35,22}, {35,23}, {35,24}, {35,25}, {35,26}, {35,27}, {35,28}, {35,29}, {35,30}, {35,31}, {35,32}, {35,33}, {35,34}, {35,35}, {35,36}, {35,37}, {35,38}, {35,39}, {35,40}, {35,41}, {35,42}, {35,43}, {35,44}, {35,45}, {35,46}, {35,47}, {35,48}, {35,49}, {35,50}, {35,51}, {35,52}, {35,53}, {35,54}, {35,55}, {35,56}, {35,57}, {35,58}, {35,59}, {35,60}, {36,-54}, {36,-53}, {36,-52}, {36,-51}, {36,-50}, {36,-49}, {36,-48}, {36,-47}, {36,-46}, {36,-45}, {36,-44}, {36,-43}, {36,-42}, {36,-41}, {36,-40}, {36,-39}, {36,-38}, {36,-37}, {36,-36}, {36,-35}, {36,-34}, {36,-33}, {36,-32}, {36,-31}, {36,-30}, {36,-29}, {36,-28}, {36,-27}, {36,-26}, {36,-25}, {36,-24}, {36,-23}, {36,-22}, {36,-21}, {36,-20}, {36,-19}, {36,-18}, {36,-17}, {36,-16}, {36,-15}, {36,-14}, {36,-13}, {36,-12}, {36,-11}, {36,-10}, {36,-9}, {36,-8}, {36,-7}, {36,-6}, {36,-5}, {36,-4}, {36,-3}, {36,-2}, {36,-1}, {36,0}, {36,1}, {36,2}, {36,3}, {36,4}, {36,5}, {36,6}, {36,7}, {36,8}, {36,9}, {36,10}, {36,11}, {36,12}, {36,13}, {36,14}, {36,15}, {36,16}, {36,17}, {36,18}, {36,19}, {36,20}, {36,21}, {36,22}, {36,23}, {36,24}, {36,25}, {36,26}, {36,27}, {36,28}, {36,29}, {36,30}, {36,31}, {36,32}, {36,33}, {36,34}, {36,35}, {36,36}, {36,37}, {36,38}, {36,39}, {36,40}, {36,41}, {36,42}, {36,43}, {36,44}, {36,45}, {36,46}, {36,47}, {36,48}, {36,49}, {36,50}, {36,51}, {36,52}, {36,53}, {36,54}, {36,55}, {36,56}, {36,57}, {36,58}, {36,59}, {37,-53}, {37,-52}, {37,-51}, {37,-50}, {37,-49}, {37,-48}, {37,-47}, {37,-46}, {37,-45}, {37,-44}, {37,-43}, {37,-42}, {37,-41}, {37,-40}, {37,-39}, {37,-38}, {37,-37}, {37,-36}, {37,-35}, {37,-34}, {37,-33}, {37,-32}, {37,-31}, {37,-30}, {37,-29}, {37,-28}, {37,-27}, {37,-26}, {37,-25}, {37,-24}, {37,-23}, {37,-22}, {37,-21}, {37,-20}, {37,-19}, {37,-18}, {37,-17}, {37,-16}, {37,-15}, {37,-14}, {37,-13}, {37,-12}, {37,-11}, {37,-10}, {37,-9}, {37,-8}, {37,-7}, {37,-6}, {37,-5}, {37,-4}, {37,-3}, {37,-2}, {37,-1}, {37,0}, {37,1}, {37,2}, {37,3}, {37,4}, {37,5}, {37,6}, {37,7}, {37,8}, {37,9}, {37,10}, {37,11}, {37,12}, {37,13}, {37,14}, {37,15}, {37,16}, {37,17}, {37,18}, {37,19}, {37,20}, {37,21}, {37,22}, {37,23}, {37,24}, {37,25}, {37,26}, {37,27}, {37,28}, {37,29}, {37,30}, {37,31}, {37,32}, {37,33}, {37,34}, {37,35}, {37,36}, {37,37}, {37,38}, {37,39}, {37,40}, {37,41}, {37,42}, {37,43}, {37,44}, {37,45}, {37,46}, {37,47}, {37,48}, {37,49}, {37,50}, {37,51}, {37,52}, {37,53}, {37,54}, {37,55}, {37,56}, {37,57}, {37,58}, {37,59}, {38,-52}, {38,-51}, {38,-50}, {38,-49}, {38,-48}, {38,-47}, {38,-46}, {38,-45}, {38,-44}, {38,-43}, {38,-42}, {38,-41}, {38,-40}, {38,-39}, {38,-38}, {38,-37}, {38,-36}, {38,-35}, {38,-34}, {38,-33}, {38,-32}, {38,-31}, {38,-30}, {38,-29}, {38,-28}, {38,-27}, {38,-26}, {38,-25}, {38,-24}, {38,-23}, {38,-22}, {38,-21}, {38,-20}, {38,-19}, {38,-18}, {38,-17}, {38,-16}, {38,-15}, {38,-14}, {38,-13}, {38,-12}, {38,-11}, {38,-10}, {38,-9}, {38,-8}, {38,-7}, {38,-6}, {38,-5}, {38,-4}, {38,-3}, {38,-2}, {38,-1}, {38,0}, {38,1}, {38,2}, {38,3}, {38,4}, {38,5}, {38,6}, {38,7}, {38,8}, {38,9}, {38,10}, {38,11}, {38,12}, {38,13}, {38,14}, {38,15}, {38,16}, {38,17}, {38,18}, {38,19}, {38,20}, {38,21}, {38,22}, {38,23}, {38,24}, {38,25}, {38,26}, {38,27}, {38,28}, {38,29}, {38,30}, {38,31}, {38,32}, {38,33}, {38,34}, {38,35}, {38,36}, {38,37}, {38,38}, {38,39}, {38,40}, {38,41}, {38,42}, {38,43}, {38,44}, {38,45}, {38,46}, {38,47}, {38,48}, {38,49}, {38,50}, {38,51}, {38,52}, {38,53}, {38,54}, {38,55}, {38,56}, {38,57}, {38,58}, {39,-51}, {39,-50}, {39,-49}, {39,-48}, {39,-47}, {39,-46}, {39,-45}, {39,-44}, {39,-43}, {39,-42}, {39,-41}, {39,-40}, {39,-39}, {39,-38}, {39,-37}, {39,-36}, {39,-35}, {39,-34}, {39,-33}, {39,-32}, {39,-31}, {39,-30}, {39,-29}, {39,-28}, {39,-27}, {39,-26}, {39,-25}, {39,-24}, {39,-23}, {39,-22}, {39,-21}, {39,-20}, {39,-19}, {39,-18}, {39,-17}, {39,-16}, {39,-15}, {39,-14}, {39,-13}, {39,-12}, {39,-11}, {39,-10}, {39,-9}, {39,-8}, {39,-7}, {39,-6}, {39,-5}, {39,-4}, {39,-3}, {39,-2}, {39,-1}, {39,0}, {39,1}, {39,2}, {39,3}, {39,4}, {39,5}, {39,6}, {39,7}, {39,8}, {39,9}, {39,10}, {39,11}, {39,12}, {39,13}, {39,14}, {39,15}, {39,16}, {39,17}, {39,18}, {39,19}, {39,20}, {39,21}, {39,22}, {39,23}, {39,24}, {39,25}, {39,26}, {39,27}, {39,28}, {39,29}, {39,30}, {39,31}, {39,32}, {39,33}, {39,34}, {39,35}, {39,36}, {39,37}, {39,38}, {39,39}, {39,40}, {39,41}, {39,42}, {39,43}, {39,44}, {39,45}, {39,46}, {39,47}, {39,48}, {39,49}, {39,50}, {39,51}, {39,52}, {39,53}, {39,54}, {39,55}, {39,56}, {39,57}, {39,58}, {40,-50}, {40,-49}, {40,-48}, {40,-47}, {40,-46}, {40,-45}, {40,-44}, {40,-43}, {40,-42}, {40,-41}, {40,-40}, {40,-39}, {40,-38}, {40,-37}, {40,-36}, {40,-35}, {40,-34}, {40,-33}, {40,-32}, {40,-31}, {40,-30}, {40,-29}, {40,-28}, {40,-27}, {40,-26}, {40,-25}, {40,-24}, {40,-23}, {40,-22}, {40,-21}, {40,-20}, {40,-19}, {40,-18}, {40,-17}, {40,-16}, {40,-15}, {40,-14}, {40,-13}, {40,-12}, {40,-11}, {40,-10}, {40,-9}, {40,-8}, {40,-7}, {40,-6}, {40,-5}, {40,-4}, {40,-3}, {40,-2}, {40,-1}, {40,0}, {40,1}, {40,2}, {40,3}, {40,4}, {40,5}, {40,6}, {40,7}, {40,8}, {40,9}, {40,10}, {40,11}, {40,12}, {40,13}, {40,14}, {40,15}, {40,16}, {40,17}, {40,18}, {40,19}, {40,20}, {40,21}, {40,22}, {40,23}, {40,24}, {40,25}, {40,26}, {40,27}, {40,28}, {40,29}, {40,30}, {40,31}, {40,32}, {40,33}, {40,34}, {40,35}, {40,36}, {40,37}, {40,38}, {40,39}, {40,40}, {40,41}, {40,42}, {40,43}, {40,44}, {40,45}, {40,46}, {40,47}, {40,48}, {40,49}, {40,50}, {40,51}, {40,52}, {40,53}, {40,54}, {40,55}, {40,56}, {40,57}, {41,-49}, {41,-48}, {41,-47}, {41,-46}, {41,-45}, {41,-44}, {41,-43}, {41,-42}, {41,-41}, {41,-40}, {41,-39}, {41,-38}, {41,-37}, {41,-36}, {41,-35}, {41,-34}, {41,-33}, {41,-32}, {41,-31}, {41,-30}, {41,-29}, {41,-28}, {41,-27}, {41,-26}, {41,-25}, {41,-24}, {41,-23}, {41,-22}, {41,-21}, {41,-20}, {41,-19}, {41,-18}, {41,-17}, {41,-16}, {41,-15}, {41,-14}, {41,-13}, {41,-12}, {41,-11}, {41,-10}, {41,-9}, {41,-8}, {41,-7}, {41,-6}, {41,-5}, {41,-4}, {41,-3}, {41,-2}, {41,-1}, {41,0}, {41,1}, {41,2}, {41,3}, {41,4}, {41,5}, {41,6}, {41,7}, {41,8}, {41,9}, {41,10}, {41,11}, {41,12}, {41,13}, {41,14}, {41,15}, {41,16}, {41,17}, {41,18}, {41,19}, {41,20}, {41,21}, {41,22}, {41,23}, {41,24}, {41,25}, {41,26}, {41,27}, {41,28}, {41,29}, {41,30}, {41,31}, {41,32}, {41,33}, {41,34}, {41,35}, {41,36}, {41,37}, {41,38}, {41,39}, {41,40}, {41,41}, {41,42}, {41,43}, {41,44}, {41,45}, {41,46}, {41,47}, {41,48}, {41,49}, {41,50}, {41,51}, {41,52}, {41,53}, {41,54}, {41,55}, {41,56}, {41,57}, {42,-48}, {42,-47}, {42,-46}, {42,-45}, {42,-44}, {42,-43}, {42,-42}, {42,-41}, {42,-40}, {42,-39}, {42,-38}, {42,-37}, {42,-36}, {42,-35}, {42,-34}, {42,-33}, {42,-32}, {42,-31}, {42,-30}, {42,-29}, {42,-28}, {42,-27}, {42,-26}, {42,-25}, {42,-24}, {42,-23}, {42,-22}, {42,-21}, {42,-20}, {42,-19}, {42,-18}, {42,-17}, {42,-16}, {42,-15}, {42,-14}, {42,-13}, {42,-12}, {42,-11}, {42,-10}, {42,-9}, {42,-8}, {42,-7}, {42,-6}, {42,-5}, {42,-4}, {42,-3}, {42,-2}, {42,-1}, {42,0}, {42,1}, {42,2}, {42,3}, {42,4}, {42,5}, {42,6}, {42,7}, {42,8}, {42,9}, {42,10}, {42,11}, {42,12}, {42,13}, {42,14}, {42,15}, {42,16}, {42,17}, {42,18}, {42,19}, {42,20}, {42,21}, {42,22}, {42,23}, {42,24}, {42,25}, {42,26}, {42,27}, {42,28}, {42,29}, {42,30}, {42,31}, {42,32}, {42,33}, {42,34}, {42,35}, {42,36}, {42,37}, {42,38}, {42,39}, {42,40}, {42,41}, {42,42}, {42,43}, {42,44}, {42,45}, {42,46}, {42,47}, {42,48}, {42,49}, {42,50}, {42,51}, {42,52}, {42,53}, {42,54}, {42,55}, {42,56}, {43,-47}, {43,-46}, {43,-45}, {43,-44}, {43,-43}, {43,-42}, {43,-41}, {43,-40}, {43,-39}, {43,-38}, {43,-37}, {43,-36}, {43,-35}, {43,-34}, {43,-33}, {43,-32}, {43,-31}, {43,-30}, {43,-29}, {43,-28}, {43,-27}, {43,-26}, {43,-25}, {43,-24}, {43,-23}, {43,-22}, {43,-21}, {43,-20}, {43,-19}, {43,-18}, {43,-17}, {43,-16}, {43,-15}, {43,-14}, {43,-13}, {43,-12}, {43,-11}, {43,-10}, {43,-9}, {43,-8}, {43,-7}, {43,-6}, {43,-5}, {43,-4}, {43,-3}, {43,-2}, {43,-1}, {43,0}, {43,1}, {43,2}, {43,3}, {43,4}, {43,5}, {43,6}, {43,7}, {43,8}, {43,9}, {43,10}, {43,11}, {43,12}, {43,13}, {43,14}, {43,15}, {43,16}, {43,17}, {43,18}, {43,19}, {43,20}, {43,21}, {43,22}, {43,23}, {43,24}, {43,25}, {43,26}, {43,27}, {43,28}, {43,29}, {43,30}, {43,31}, {43,32}, {43,33}, {43,34}, {43,35}, {43,36}, {43,37}, {43,38}, {43,39}, {43,40}, {43,41}, {43,42}, {43,43}, {43,44}, {43,45}, {43,46}, {43,47}, {43,48}, {43,49}, {43,50}, {43,51}, {43,52}, {43,53}, {43,54}, {43,55}, {43,56}, {44,-46}, {44,-45}, {44,-44}, {44,-43}, {44,-42}, {44,-41}, {44,-40}, {44,-39}, {44,-38}, {44,-37}, {44,-36}, {44,-35}, {44,-34}, {44,-33}, {44,-32}, {44,-31}, {44,-30}, {44,-29}, {44,-28}, {44,-27}, {44,-26}, {44,-25}, {44,-24}, {44,-23}, {44,-22}, {44,-21}, {44,-20}, {44,-19}, {44,-18}, {44,-17}, {44,-16}, {44,-15}, {44,-14}, {44,-13}, {44,-12}, {44,-11}, {44,-10}, {44,-9}, {44,-8}, {44,-7}, {44,-6}, {44,-5}, {44,-4}, {44,-3}, {44,-2}, {44,-1}, {44,0}, {44,1}, {44,2}, {44,3}, {44,4}, {44,5}, {44,6}, {44,7}, {44,8}, {44,9}, {44,10}, {44,11}, {44,12}, {44,13}, {44,14}, {44,15}, {44,16}, {44,17}, {44,18}, {44,19}, {44,20}, {44,21}, {44,22}, {44,23}, {44,24}, {44,25}, {44,26}, {44,27}, {44,28}, {44,29}, {44,30}, {44,31}, {44,32}, {44,33}, {44,34}, {44,35}, {44,36}, {44,37}, {44,38}, {44,39}, {44,40}, {44,41}, {44,42}, {44,43}, {44,44}, {44,45}, {44,46}, {44,47}, {44,48}, {44,49}, {44,50}, {44,51}, {44,52}, {44,53}, {44,54}, {44,55}, {45,-45}, {45,-44}, {45,-43}, {45,-42}, {45,-41}, {45,-40}, {45,-39}, {45,-38}, {45,-37}, {45,-36}, {45,-35}, {45,-34}, {45,-33}, {45,-32}, {45,-31}, {45,-30}, {45,-29}, {45,-28}, {45,-27}, {45,-26}, {45,-25}, {45,-24}, {45,-23}, {45,-22}, {45,-21}, {45,-20}, {45,-19}, {45,-18}, {45,-17}, {45,-16}, {45,-15}, {45,-14}, {45,-13}, {45,-12}, {45,-11}, {45,-10}, {45,-9}, {45,-8}, {45,-7}, {45,-6}, {45,-5}, {45,-4}, {45,-3}, {45,-2}, {45,-1}, {45,0}, {45,1}, {45,2}, {45,3}, {45,4}, {45,5}, {45,6}, {45,7}, {45,8}, {45,9}, {45,10}, {45,11}, {45,12}, {45,13}, {45,14}, {45,15}, {45,16}, {45,17}, {45,18}, {45,19}, {45,20}, {45,21}, {45,22}, {45,23}, {45,24}, {45,25}, {45,26}, {45,27}, {45,28}, {45,29}, {45,30}, {45,31}, {45,32}, {45,33}, {45,34}, {45,35}, {45,36}, {45,37}, {45,38}, {45,39}, {45,40}, {45,41}, {45,42}, {45,43}, {45,44}, {45,45}, {45,46}, {45,47}, {45,48}, {45,49}, {45,50}, {45,51}, {45,52}, {45,53}, {45,54}, {45,55}, {46,-44}, {46,-43}, {46,-42}, {46,-41}, {46,-40}, {46,-39}, {46,-38}, {46,-37}, {46,-36}, {46,-35}, {46,-34}, {46,-33}, {46,-32}, {46,-31}, {46,-30}, {46,-29}, {46,-28}, {46,-27}, {46,-26}, {46,-25}, {46,-24}, {46,-23}, {46,-22}, {46,-21}, {46,-20}, {46,-19}, {46,-18}, {46,-17}, {46,-16}, {46,-15}, {46,-14}, {46,-13}, {46,-12}, {46,-11}, {46,-10}, {46,-9}, {46,-8}, {46,-7}, {46,-6}, {46,-5}, {46,-4}, {46,-3}, {46,-2}, {46,-1}, {46,0}, {46,1}, {46,2}, {46,3}, {46,4}, {46,5}, {46,6}, {46,7}, {46,8}, {46,9}, {46,10}, {46,11}, {46,12}, {46,13}, {46,14}, {46,15}, {46,16}, {46,17}, {46,18}, {46,19}, {46,20}, {46,21}, {46,22}, {46,23}, {46,24}, {46,25}, {46,26}, {46,27}, {46,28}, {46,29}, {46,30}, {46,31}, {46,32}, {46,33}, {46,34}, {46,35}, {46,36}, {46,37}, {46,38}, {46,39}, {46,40}, {46,41}, {46,42}, {46,43}, {46,44}, {46,45}, {46,46}, {46,47}, {46,48}, {46,49}, {46,50}, {46,51}, {46,52}, {46,53}, {46,54}, {46,55}, {47,-43}, {47,-42}, {47,-41}, {47,-40}, {47,-39}, {47,-38}, {47,-37}, {47,-36}, {47,-35}, {47,-34}, {47,-33}, {47,-32}, {47,-31}, {47,-30}, {47,-29}, {47,-28}, {47,-27}, {47,-26}, {47,-25}, {47,-24}, {47,-23}, {47,-22}, {47,-21}, {47,-20}, {47,-19}, {47,-18}, {47,-17}, {47,-16}, {47,-15}, {47,-14}, {47,-13}, {47,-12}, {47,-11}, {47,-10}, {47,-9}, {47,-8}, {47,-7}, {47,-6}, {47,-5}, {47,-4}, {47,-3}, {47,-2}, {47,-1}, {47,0}, {47,1}, {47,2}, {47,3}, {47,4}, {47,5}, {47,6}, {47,7}, {47,8}, {47,9}, {47,10}, {47,11}, {47,12}, {47,13}, {47,14}, {47,15}, {47,16}, {47,17}, {47,18}, {47,19}, {47,20}, {47,21}, {47,22}, {47,23}, {47,24}, {47,25}, {47,26}, {47,27}, {47,28}, {47,29}, {47,30}, {47,31}, {47,32}, {47,33}, {47,34}, {47,35}, {47,36}, {47,37}, {47,38}, {47,39}, {47,40}, {47,41}, {47,42}, {47,43}, {47,44}, {47,45}, {47,46}, {47,47}, {47,48}, {47,49}, {47,50}, {47,51}, {47,52}, {47,53}, {47,54}, {48,-43}, {48,-42}, {48,-41}, {48,-40}, {48,-39}, {48,-38}, {48,-37}, {48,-36}, {48,-35}, {48,-34}, {48,-33}, {48,-32}, {48,-31}, {48,-30}, {48,-29}, {48,-28}, {48,-27}, {48,-26}, {48,-25}, {48,-24}, {48,-23}, {48,-22}, {48,-21}, {48,-20}, {48,-19}, {48,-18}, {48,-17}, {48,-16}, {48,-15}, {48,-14}, {48,-13}, {48,-12}, {48,-11}, {48,-10}, {48,-9}, {48,-8}, {48,-7}, {48,-6}, {48,-5}, {48,-4}, {48,-3}, {48,-2}, {48,-1}, {48,0}, {48,1}, {48,2}, {48,3}, {48,4}, {48,5}, {48,6}, {48,7}, {48,8}, {48,9}, {48,10}, {48,11}, {48,12}, {48,13}, {48,14}, {48,15}, {48,16}, {48,17}, {48,18}, {48,19}, {48,20}, {48,21}, {48,22}, {48,23}, {48,24}, {48,25}, {48,26}, {48,27}, {48,28}, {48,29}, {48,30}, {48,31}, {48,32}, {48,33}, {48,34}, {48,35}, {48,36}, {48,37}, {48,38}, {48,39}, {48,40}, {48,41}, {48,42}, {48,43}, {48,44}, {48,45}, {48,46}, {48,47}, {48,48}, {48,49}, {48,50}, {48,51}, {48,52}, {48,53}, {48,54}, {49,-42}, {49,-41}, {49,-40}, {49,-39}, {49,-38}, {49,-37}, {49,-36}, {49,-35}, {49,-34}, {49,-33}, {49,-32}, {49,-31}, {49,-30}, {49,-29}, {49,-28}, {49,-27}, {49,-26}, {49,-25}, {49,-24}, {49,-23}, {49,-22}, {49,-21}, {49,-20}, {49,-19}, {49,-18}, {49,-17}, {49,-16}, {49,-15}, {49,-14}, {49,-13}, {49,-12}, {49,-11}, {49,-10}, {49,-9}, {49,-8}, {49,-7}, {49,-6}, {49,-5}, {49,-4}, {49,-3}, {49,-2}, {49,-1}, {49,0}, {49,1}, {49,2}, {49,3}, {49,4}, {49,5}, {49,6}, {49,7}, {49,8}, {49,9}, {49,10}, {49,11}, {49,12}, {49,13}, {49,14}, {49,15}, {49,16}, {49,17}, {49,18}, {49,19}, {49,20}, {49,21}, {49,22}, {49,23}, {49,24}, {49,25}, {49,26}, {49,27}, {49,28}, {49,29}, {49,30}, {49,31}, {49,32}, {49,33}, {49,34}, {49,35}, {49,36}, {49,37}, {49,38}, {49,39}, {49,40}, {49,41}, {49,42}, {49,43}, {49,44}, {49,45}, {49,46}, {49,47}, {49,48}, {49,49}, {49,50}, {49,51}, {49,52}, {49,53}, {49,54}, {50,-42}, {50,-41}, {50,-40}, {50,-39}, {50,-38}, {50,-37}, {50,-36}, {50,-35}, {50,-34}, {50,-33}, {50,-32}, {50,-31}, {50,-30}, {50,-29}, {50,-28}, {50,-27}, {50,-26}, {50,-25}, {50,-24}, {50,-23}, {50,-22}, {50,-21}, {50,-20}, {50,-19}, {50,-18}, {50,-17}, {50,-16}, {50,-15}, {50,-14}, {50,-13}, {50,-12}, {50,-11}, {50,-10}, {50,-9}, {50,-8}, {50,-7}, {50,-6}, {50,-5}, {50,-4}, {50,-3}, {50,-2}, {50,-1}, {50,0}, {50,1}, {50,2}, {50,3}, {50,4}, {50,5}, {50,6}, {50,7}, {50,8}, {50,9}, {50,10}, {50,11}, {50,12}, {50,13}, {50,14}, {50,15}, {50,16}, {50,17}, {50,18}, {50,19}, {50,20}, {50,21}, {50,22}, {50,23}, {50,24}, {50,25}, {50,26}, {50,27}, {50,28}, {50,29}, {50,30}, {50,31}, {50,32}, {50,33}, {50,34}, {50,35}, {50,36}, {50,37}, {50,38}, {50,39}, {50,40}, {50,41}, {50,42}, {50,43}, {50,44}, {50,45}, {50,46}, {50,47}, {50,48}, {50,49}, {50,50}, {50,51}, {50,52}, {50,53}, {51,-41}, {51,-40}, {51,-39}, {51,-38}, {51,-37}, {51,-36}, {51,-35}, {51,-34}, {51,-33}, {51,-32}, {51,-31}, {51,-30}, {51,-29}, {51,-28}, {51,-27}, {51,-26}, {51,-25}, {51,-24}, {51,-23}, {51,-22}, {51,-21}, {51,-20}, {51,-19}, {51,-18}, {51,-17}, {51,-16}, {51,-15}, {51,-14}, {51,-13}, {51,-12}, {51,-11}, {51,-10}, {51,-9}, {51,-8}, {51,-7}, {51,-6}, {51,-5}, {51,-4}, {51,-3}, {51,-2}, {51,-1}, {51,0}, {51,1}, {51,2}, {51,3}, {51,4}, {51,5}, {51,6}, {51,7}, {51,8}, {51,9}, {51,10}, {51,11}, {51,12}, {51,13}, {51,14}, {51,15}, {51,16}, {51,17}, {51,18}, {51,19}, {51,20}, {51,21}, {51,22}, {51,23}, {51,24}, {51,25}, {51,26}, {51,27}, {51,28}, {51,29}, {51,30}, {51,31}, {51,32}, {51,33}, {51,34}, {51,35}, {51,36}, {51,37}, {51,38}, {51,39}, {51,40}, {51,41}, {51,42}, {51,43}, {51,44}, {51,45}, {51,46}, {51,47}, {51,48}, {51,49}, {51,50}, {51,51}, {51,52}, {52,-40}, {52,-39}, {52,-38}, {52,-37}, {52,-36}, {52,-35}, {52,-34}, {52,-33}, {52,-32}, {52,-31}, {52,-30}, {52,-29}, {52,-28}, {52,-27}, {52,-26}, {52,-25}, {52,-24}, {52,-23}, {52,-22}, {52,-21}, {52,-20}, {52,-19}, {52,-18}, {52,-17}, {52,-16}, {52,-15}, {52,-14}, {52,-13}, {52,-12}, {52,-11}, {52,-10}, {52,-9}, {52,-8}, {52,-7}, {52,-6}, {52,-5}, {52,-4}, {52,-3}, {52,-2}, {52,-1}, {52,0}, {52,1}, {52,2}, {52,3}, {52,4}, {52,5}, {52,6}, {52,7}, {52,8}, {52,9}, {52,10}, {52,11}, {52,12}, {52,13}, {52,14}, {52,15}, {52,16}, {52,17}, {52,18}, {52,19}, {52,20}, {52,21}, {52,22}, {52,23}, {52,24}, {52,25}, {52,26}, {52,27}, {52,28}, {52,29}, {52,30}, {52,31}, {52,32}, {52,33}, {52,34}, {52,35}, {52,36}, {52,37}, {52,38}, {52,39}, {52,40}, {52,41}, {52,42}, {52,43}, {52,44}, {52,45}, {52,46}, {52,47}, {52,48}, {52,49}, {52,50}, {52,51}, {53,-40}, {53,-39}, {53,-38}, {53,-37}, {53,-36}, {53,-35}, {53,-34}, {53,-33}, {53,-32}, {53,-31}, {53,-30}, {53,-29}, {53,-28}, {53,-27}, {53,-26}, {53,-25}, {53,-24}, {53,-23}, {53,-22}, {53,-21}, {53,-20}, {53,-19}, {53,-18}, {53,-17}, {53,-16}, {53,-15}, {53,-14}, {53,-13}, {53,-12}, {53,-11}, {53,-10}, {53,-9}, {53,-8}, {53,-7}, {53,-6}, {53,-5}, {53,-4}, {53,-3}, {53,-2}, {53,-1}, {53,0}, {53,1}, {53,2}, {53,3}, {53,4}, {53,5}, {53,6}, {53,7}, {53,8}, {53,9}, {53,10}, {53,11}, {53,12}, {53,13}, {53,14}, {53,15}, {53,16}, {53,17}, {53,18}, {53,19}, {53,20}, {53,21}, {53,22}, {53,23}, {53,24}, {53,25}, {53,26}, {53,27}, {53,28}, {53,29}, {53,30}, {53,31}, {53,32}, {53,33}, {53,34}, {53,35}, {53,36}, {53,37}, {53,38}, {53,39}, {53,40}, {53,41}, {53,42}, {53,43}, {53,44}, {53,45}, {53,46}, {53,47}, {53,48}, {53,49}, {53,50}, {54,-39}, {54,-38}, {54,-37}, {54,-36}, {54,-35}, {54,-34}, {54,-33}, {54,-32}, {54,-31}, {54,-30}, {54,-29}, {54,-28}, {54,-27}, {54,-26}, {54,-25}, {54,-24}, {54,-23}, {54,-22}, {54,-21}, {54,-20}, {54,-19}, {54,-18}, {54,-17}, {54,-16}, {54,-15}, {54,-14}, {54,-13}, {54,-12}, {54,-11}, {54,-10}, {54,-9}, {54,-8}, {54,-7}, {54,-6}, {54,-5}, {54,-4}, {54,-3}, {54,-2}, {54,-1}, {54,0}, {54,1}, {54,2}, {54,3}, {54,4}, {54,5}, {54,6}, {54,7}, {54,8}, {54,9}, {54,10}, {54,11}, {54,12}, {54,13}, {54,14}, {54,15}, {54,16}, {54,17}, {54,18}, {54,19}, {54,20}, {54,21}, {54,22}, {54,23}, {54,24}, {54,25}, {54,26}, {54,27}, {54,28}, {54,29}, {54,30}, {54,31}, {54,32}, {54,33}, {54,34}, {54,35}, {54,36}, {54,37}, {54,38}, {54,39}, {54,40}, {54,41}, {54,42}, {54,43}, {54,44}, {54,45}, {54,46}, {54,47}, {54,48}, {54,49}, {54,50}, {55,-39}, {55,-38}, {55,-37}, {55,-36}, {55,-35}, {55,-34}, {55,-33}, {55,-32}, {55,-31}, {55,-30}, {55,-29}, {55,-28}, {55,-27}, {55,-26}, {55,-25}, {55,-24}, {55,-23}, {55,-22}, {55,-21}, {55,-20}, {55,-19}, {55,-18}, {55,-17}, {55,-16}, {55,-15}, {55,-14}, {55,-13}, {55,-12}, {55,-11}, {55,-10}, {55,-9}, {55,-8}, {55,-7}, {55,-6}, {55,-5}, {55,-4}, {55,-3}, {55,-2}, {55,-1}, {55,0}, {55,1}, {55,2}, {55,3}, {55,4}, {55,5}, {55,6}, {55,7}, {55,8}, {55,9}, {55,10}, {55,11}, {55,12}, {55,13}, {55,14}, {55,15}, {55,16}, {55,17}, {55,18}, {55,19}, {55,20}, {55,21}, {55,22}, {55,23}, {55,24}, {55,25}, {55,26}, {55,27}, {55,28}, {55,29}, {55,30}, {55,31}, {55,32}, {55,33}, {55,34}, {55,35}, {55,36}, {55,37}, {55,38}, {55,39}, {55,40}, {55,41}, {55,42}, {55,43}, {55,44}, {55,45}, {55,46}, {55,47}, {55,48}, {55,49}, {56,-38}, {56,-37}, {56,-36}, {56,-35}, {56,-34}, {56,-33}, {56,-32}, {56,-31}, {56,-30}, {56,-17}, {56,-16}, {56,-15}, {56,-14}, {56,-13}, {56,-12}, {56,-11}, {56,-10}, {56,-9}, {56,-8}, {56,-7}, {56,-6}, {56,-5}, {56,-4}, {56,-3}, {56,-2}, {56,-1}, {56,0}, {56,1}, {56,2}, {56,3}, {56,4}, {56,5}, {56,6}, {56,7}, {56,8}, {56,9}, {56,10}, {56,11}, {56,12}, {56,13}, {56,14}, {56,15}, {56,16}, {56,17}, {56,18}, {56,19}, {56,20}, {56,21}, {56,22}, {56,23}, {56,24}, {56,25}, {56,26}, {56,27}, {56,28}, {56,29}, {56,30}, {56,31}, {56,32}, {56,33}, {56,34}, {56,35}, {56,36}, {56,37}, {56,38}, {56,39}, {56,40}, {56,41}, {56,42}, {56,43}, {56,44}, {56,45}, {56,46}, {56,47}, {56,48}, {56,49}, {57,-38}, {57,-37}, {57,-36}, {57,-35}, {57,-34}, {57,-14}, {57,-13}, {57,-12}, {57,-11}, {57,-10}, {57,-9}, {57,-8}, {57,-7}, {57,-6}, {57,-5}, {57,-4}, {57,-3}, {57,-2}, {57,-1}, {57,0}, {57,1}, {57,2}, {57,3}, {57,4}, {57,5}, {57,6}, {57,7}, {57,8}, {57,9}, {57,10}, {57,11}, {57,12}, {57,13}, {57,14}, {57,15}, {57,16}, {57,17}, {57,18}, {57,19}, {57,20}, {57,21}, {57,22}, {57,23}, {57,24}, {57,25}, {57,26}, {57,27}, {57,28}, {57,29}, {57,30}, {57,31}, {57,32}, {57,33}, {57,34}, {57,35}, {57,36}, {57,37}, {57,38}, {57,39}, {57,40}, {57,41}, {57,42}, {57,43}, {57,44}, {57,45}, {57,46}, {57,47}, {57,48}, {58,-11}, {58,-10}, {58,-9}, {58,-8}, {58,-7}, {58,-6}, {58,-5}, {58,-4}, {58,-3}, {58,-2}, {58,-1}, {58,0}, {58,1}, {58,2}, {58,3}, {58,4}, {58,5}, {58,6}, {58,7}, {58,8}, {58,9}, {58,10}, {58,11}, {58,12}, {58,13}, {58,14}, {58,15}, {58,16}, {58,17}, {58,18}, {58,19}, {58,20}, {58,21}, {58,22}, {58,23}, {58,24}, {58,25}, {58,26}, {58,27}, {58,28}, {58,29}, {58,30}, {58,31}, {58,32}, {58,33}, {58,34}, {58,35}, {58,36}, {58,37}, {58,38}, {58,39}, {58,40}, {58,41}, {58,42}, {58,43}, {58,44}, {58,45}, {58,46}, {58,47}, {59,-9}, {59,-8}, {59,-7}, {59,-6}, {59,-5}, {59,-4}, {59,-3}, {59,-2}, {59,-1}, {59,0}, {59,1}, {59,2}, {59,3}, {59,4}, {59,5}, {59,6}, {59,7}, {59,8}, {59,9}, {59,10}, {59,11}, {59,12}, {59,13}, {59,14}, {59,15}, {59,16}, {59,34}, {59,35}, {59,36}, {59,37}, {59,38}, {59,39}, {59,40}, {59,41}, {59,42}, {59,43}, {59,44}, {59,45}, {60,-7}, {60,-6}, {60,-5}, {60,-4}, {60,-3}, {60,-2}, {60,-1}, {60,0}, {60,1}, {60,2}, {60,3}, {60,4}, {60,5}, {60,6}, {60,7}, {60,8}, {60,9}, {60,10}, {60,11}, {60,12}, {60,13}, {60,37}, {60,38}, {60,39}, {60,40}, {60,41}, {60,42}, {60,43}, {60,44}, {61,-5}, {61,-4}, {61,-3}, {61,-2}, {61,-1}, {61,0}, {61,1}, {61,2}, {61,3}, {61,4}, {61,5}, {61,6}, {61,7}, {61,8}, {61,9}, {61,10}, {61,11}, {62,3}, {62,4}, {62,5}, {62,6}, {62,7}, {62,8}, {62,9}, },
    ["se-asteroid"] = {{-31,1}, {-31,2}, {-31,3}, {-31,4}, {-31,5}, {-31,6}, {-31,7}, {-31,8}, {-31,9}, {-31,10}, {-31,11}, {-30,-2}, {-30,-1}, {-30,0}, {-30,1}, {-30,2}, {-30,3}, {-30,4}, {-30,5}, {-30,6}, {-30,7}, {-30,8}, {-30,9}, {-30,10}, {-30,11}, {-30,12}, {-30,13}, {-30,14}, {-29,-23}, {-29,-22}, {-29,-21}, {-29,-20}, {-29,-19}, {-29,-3}, {-29,-2}, {-29,-1}, {-29,0}, {-29,1}, {-29,2}, {-29,3}, {-29,4}, {-29,5}, {-29,6}, {-29,7}, {-29,8}, {-29,9}, {-29,10}, {-29,11}, {-29,12}, {-29,13}, {-29,14}, {-29,15}, {-28,-24}, {-28,-23}, {-28,-22}, {-28,-21}, {-28,-20}, {-28,-19}, {-28,-18}, {-28,-17}, {-28,-3}, {-28,-2}, {-28,-1}, {-28,0}, {-28,1}, {-28,2}, {-28,3}, {-28,4}, {-28,5}, {-28,6}, {-28,7}, {-28,8}, {-28,9}, {-28,10}, {-28,11}, {-28,12}, {-28,13}, {-28,14}, {-28,15}, {-28,16}, {-27,-24}, {-27,-23}, {-27,-22}, {-27,-21}, {-27,-20}, {-27,-19}, {-27,-18}, {-27,-17}, {-27,-4}, {-27,-3}, {-27,-2}, {-27,-1}, {-27,0}, {-27,1}, {-27,2}, {-27,3}, {-27,4}, {-27,5}, {-27,6}, {-27,7}, {-27,8}, {-27,9}, {-27,10}, {-27,11}, {-27,12}, {-27,13}, {-27,14}, {-27,15}, {-27,16}, {-27,17}, {-26,-25}, {-26,-24}, {-26,-23}, {-26,-22}, {-26,-21}, {-26,-20}, {-26,-19}, {-26,-18}, {-26,-17}, {-26,-16}, {-26,-5}, {-26,-4}, {-26,-3}, {-26,-2}, {-26,-1}, {-26,0}, {-26,1}, {-26,2}, {-26,3}, {-26,4}, {-26,5}, {-26,6}, {-26,7}, {-26,8}, {-26,9}, {-26,10}, {-26,11}, {-26,12}, {-26,13}, {-26,14}, {-26,15}, {-26,16}, {-26,17}, {-26,18}, {-25,-27}, {-25,-26}, {-25,-25}, {-25,-24}, {-25,-23}, {-25,-22}, {-25,-21}, {-25,-20}, {-25,-19}, {-25,-18}, {-25,-17}, {-25,-16}, {-25,-5}, {-25,-4}, {-25,-3}, {-25,-2}, {-25,-1}, {-25,0}, {-25,1}, {-25,2}, {-25,3}, {-25,4}, {-25,5}, {-25,6}, {-25,7}, {-25,8}, {-25,9}, {-25,10}, {-25,11}, {-25,12}, {-25,13}, {-25,14}, {-25,15}, {-25,16}, {-25,17}, {-25,18}, {-25,19}, {-24,-28}, {-24,-27}, {-24,-26}, {-24,-25}, {-24,-24}, {-24,-23}, {-24,-22}, {-24,-21}, {-24,-20}, {-24,-19}, {-24,-18}, {-24,-17}, {-24,-16}, {-24,-6}, {-24,-5}, {-24,-4}, {-24,-3}, {-24,-2}, {-24,-1}, {-24,0}, {-24,1}, {-24,2}, {-24,3}, {-24,4}, {-24,5}, {-24,6}, {-24,7}, {-24,8}, {-24,9}, {-24,10}, {-24,11}, {-24,12}, {-24,13}, {-24,14}, {-24,15}, {-24,16}, {-24,17}, {-24,18}, {-24,19}, {-24,20}, {-23,-29}, {-23,-28}, {-23,-27}, {-23,-26}, {-23,-25}, {-23,-24}, {-23,-23}, {-23,-22}, {-23,-21}, {-23,-20}, {-23,-19}, {-23,-18}, {-23,-17}, {-23,-16}, {-23,-15}, {-23,-7}, {-23,-6}, {-23,-5}, {-23,-4}, {-23,-3}, {-23,-2}, {-23,-1}, {-23,0}, {-23,1}, {-23,2}, {-23,3}, {-23,4}, {-23,5}, {-23,6}, {-23,7}, {-23,8}, {-23,9}, {-23,10}, {-23,11}, {-23,12}, {-23,13}, {-23,14}, {-23,15}, {-23,16}, {-23,17}, {-23,18}, {-23,19}, {-23,20}, {-23,21}, {-22,-30}, {-22,-29}, {-22,-28}, {-22,-27}, {-22,-26}, {-22,-25}, {-22,-24}, {-22,-23}, {-22,-22}, {-22,-21}, {-22,-20}, {-22,-19}, {-22,-18}, {-22,-17}, {-22,-16}, {-22,-15}, {-22,-7}, {-22,-6}, {-22,-5}, {-22,-4}, {-22,-3}, {-22,-2}, {-22,-1}, {-22,0}, {-22,1}, {-22,2}, {-22,3}, {-22,4}, {-22,5}, {-22,6}, {-22,7}, {-22,8}, {-22,9}, {-22,10}, {-22,11}, {-22,12}, {-22,13}, {-22,14}, {-22,15}, {-22,16}, {-22,17}, {-22,18}, {-22,19}, {-22,20}, {-22,21}, {-22,22}, {-21,-30}, {-21,-29}, {-21,-28}, {-21,-27}, {-21,-26}, {-21,-25}, {-21,-24}, {-21,-23}, {-21,-22}, {-21,-21}, {-21,-20}, {-21,-19}, {-21,-18}, {-21,-17}, {-21,-16}, {-21,-15}, {-21,-8}, {-21,-7}, {-21,-6}, {-21,-5}, {-21,-4}, {-21,-3}, {-21,-2}, {-21,-1}, {-21,0}, {-21,1}, {-21,2}, {-21,3}, {-21,4}, {-21,5}, {-21,6}, {-21,7}, {-21,8}, {-21,9}, {-21,10}, {-21,11}, {-21,12}, {-21,13}, {-21,14}, {-21,15}, {-21,16}, {-21,17}, {-21,18}, {-21,19}, {-21,20}, {-21,21}, {-21,22}, {-20,-31}, {-20,-30}, {-20,-29}, {-20,-28}, {-20,-27}, {-20,-26}, {-20,-25}, {-20,-24}, {-20,-23}, {-20,-22}, {-20,-21}, {-20,-20}, {-20,-19}, {-20,-18}, {-20,-17}, {-20,-16}, {-20,-15}, {-20,-8}, {-20,-7}, {-20,-6}, {-20,-5}, {-20,-4}, {-20,-3}, {-20,-2}, {-20,-1}, {-20,0}, {-20,1}, {-20,2}, {-20,3}, {-20,4}, {-20,5}, {-20,6}, {-20,7}, {-20,8}, {-20,9}, {-20,10}, {-20,11}, {-20,12}, {-20,13}, {-20,14}, {-20,15}, {-20,16}, {-20,17}, {-20,18}, {-20,19}, {-20,20}, {-20,21}, {-20,22}, {-19,-31}, {-19,-30}, {-19,-29}, {-19,-28}, {-19,-27}, {-19,-26}, {-19,-25}, {-19,-24}, {-19,-23}, {-19,-22}, {-19,-21}, {-19,-20}, {-19,-19}, {-19,-18}, {-19,-17}, {-19,-16}, {-19,-15}, {-19,-9}, {-19,-8}, {-19,-7}, {-19,-6}, {-19,-5}, {-19,-4}, {-19,-3}, {-19,-2}, {-19,-1}, {-19,0}, {-19,1}, {-19,2}, {-19,3}, {-19,4}, {-19,5}, {-19,6}, {-19,7}, {-19,8}, {-19,9}, {-19,10}, {-19,11}, {-19,12}, {-19,13}, {-19,14}, {-19,15}, {-19,16}, {-19,17}, {-19,18}, {-19,19}, {-19,20}, {-19,21}, {-19,22}, {-18,-32}, {-18,-31}, {-18,-30}, {-18,-29}, {-18,-28}, {-18,-27}, {-18,-26}, {-18,-25}, {-18,-24}, {-18,-23}, {-18,-22}, {-18,-21}, {-18,-20}, {-18,-19}, {-18,-18}, {-18,-17}, {-18,-16}, {-18,-15}, {-18,-14}, {-18,-9}, {-18,-8}, {-18,-7}, {-18,-6}, {-18,-5}, {-18,-4}, {-18,-3}, {-18,-2}, {-18,-1}, {-18,0}, {-18,1}, {-18,2}, {-18,3}, {-18,4}, {-18,5}, {-18,6}, {-18,7}, {-18,8}, {-18,9}, {-18,10}, {-18,11}, {-18,12}, {-18,13}, {-18,14}, {-18,15}, {-18,16}, {-18,17}, {-18,18}, {-18,19}, {-18,20}, {-18,21}, {-18,22}, {-17,-32}, {-17,-31}, {-17,-30}, {-17,-29}, {-17,-28}, {-17,-27}, {-17,-26}, {-17,-25}, {-17,-24}, {-17,-23}, {-17,-22}, {-17,-21}, {-17,-20}, {-17,-19}, {-17,-18}, {-17,-17}, {-17,-16}, {-17,-15}, {-17,-14}, {-17,-9}, {-17,-8}, {-17,-7}, {-17,-6}, {-17,-5}, {-17,-4}, {-17,-3}, {-17,-2}, {-17,-1}, {-17,0}, {-17,1}, {-17,2}, {-17,3}, {-17,4}, {-17,5}, {-17,6}, {-17,7}, {-17,8}, {-17,9}, {-17,10}, {-17,11}, {-17,12}, {-17,13}, {-17,14}, {-17,15}, {-17,16}, {-17,17}, {-17,18}, {-17,19}, {-17,20}, {-17,21}, {-17,22}, {-16,-32}, {-16,-31}, {-16,-30}, {-16,-29}, {-16,-28}, {-16,-27}, {-16,-26}, {-16,-25}, {-16,-24}, {-16,-23}, {-16,-22}, {-16,-21}, {-16,-20}, {-16,-19}, {-16,-18}, {-16,-17}, {-16,-16}, {-16,-15}, {-16,-14}, {-16,-9}, {-16,-8}, {-16,-7}, {-16,-6}, {-16,-5}, {-16,-4}, {-16,-3}, {-16,-2}, {-16,-1}, {-16,0}, {-16,1}, {-16,2}, {-16,3}, {-16,4}, {-16,5}, {-16,6}, {-16,7}, {-16,8}, {-16,9}, {-16,10}, {-16,11}, {-16,12}, {-16,13}, {-16,14}, {-16,15}, {-16,16}, {-16,17}, {-16,18}, {-16,19}, {-16,20}, {-16,21}, {-16,22}, {-15,-32}, {-15,-31}, {-15,-30}, {-15,-29}, {-15,-28}, {-15,-27}, {-15,-26}, {-15,-25}, {-15,-24}, {-15,-23}, {-15,-22}, {-15,-21}, {-15,-20}, {-15,-19}, {-15,-18}, {-15,-17}, {-15,-16}, {-15,-15}, {-15,-14}, {-15,-9}, {-15,-8}, {-15,-7}, {-15,-6}, {-15,-5}, {-15,-4}, {-15,-3}, {-15,-2}, {-15,-1}, {-15,0}, {-15,1}, {-15,2}, {-15,3}, {-15,4}, {-15,5}, {-15,6}, {-15,7}, {-15,8}, {-15,9}, {-15,10}, {-15,11}, {-15,12}, {-15,13}, {-15,14}, {-15,15}, {-15,16}, {-15,17}, {-15,18}, {-15,19}, {-15,20}, {-15,21}, {-15,22}, {-14,-32}, {-14,-31}, {-14,-30}, {-14,-29}, {-14,-28}, {-14,-27}, {-14,-26}, {-14,-25}, {-14,-24}, {-14,-23}, {-14,-22}, {-14,-21}, {-14,-20}, {-14,-19}, {-14,-18}, {-14,-17}, {-14,-16}, {-14,-15}, {-14,-14}, {-14,-9}, {-14,-8}, {-14,-7}, {-14,-6}, {-14,-5}, {-14,-4}, {-14,-3}, {-14,-2}, {-14,-1}, {-14,0}, {-14,1}, {-14,2}, {-14,3}, {-14,4}, {-14,5}, {-14,6}, {-14,7}, {-14,8}, {-14,9}, {-14,10}, {-14,11}, {-14,12}, {-14,13}, {-14,14}, {-14,15}, {-14,16}, {-14,17}, {-14,18}, {-14,19}, {-14,20}, {-14,21}, {-14,22}, {-13,-32}, {-13,-31}, {-13,-30}, {-13,-29}, {-13,-28}, {-13,-27}, {-13,-26}, {-13,-25}, {-13,-24}, {-13,-23}, {-13,-22}, {-13,-21}, {-13,-20}, {-13,-19}, {-13,-18}, {-13,-17}, {-13,-16}, {-13,-15}, {-13,-14}, {-13,-9}, {-13,-8}, {-13,-7}, {-13,-6}, {-13,-5}, {-13,-4}, {-13,-3}, {-13,-2}, {-13,-1}, {-13,0}, {-13,1}, {-13,2}, {-13,3}, {-13,4}, {-13,5}, {-13,6}, {-13,7}, {-13,8}, {-13,9}, {-13,10}, {-13,11}, {-13,12}, {-13,13}, {-13,14}, {-13,15}, {-13,16}, {-13,17}, {-13,18}, {-13,19}, {-13,20}, {-13,21}, {-13,22}, {-12,-32}, {-12,-31}, {-12,-30}, {-12,-29}, {-12,-28}, {-12,-27}, {-12,-26}, {-12,-25}, {-12,-24}, {-12,-23}, {-12,-22}, {-12,-21}, {-12,-20}, {-12,-19}, {-12,-18}, {-12,-17}, {-12,-16}, {-12,-15}, {-12,-14}, {-12,-10}, {-12,-9}, {-12,-8}, {-12,-7}, {-12,-6}, {-12,-5}, {-12,-4}, {-12,-3}, {-12,-2}, {-12,-1}, {-12,0}, {-12,1}, {-12,2}, {-12,3}, {-12,4}, {-12,5}, {-12,6}, {-12,7}, {-12,8}, {-12,9}, {-12,10}, {-12,11}, {-12,12}, {-12,13}, {-12,14}, {-12,15}, {-12,16}, {-12,17}, {-12,18}, {-12,19}, {-12,20}, {-12,21}, {-12,22}, {-11,-32}, {-11,-31}, {-11,-30}, {-11,-29}, {-11,-28}, {-11,-27}, {-11,-26}, {-11,-25}, {-11,-24}, {-11,-23}, {-11,-22}, {-11,-21}, {-11,-20}, {-11,-19}, {-11,-18}, {-11,-17}, {-11,-16}, {-11,-15}, {-11,-14}, {-11,-10}, {-11,-9}, {-11,-8}, {-11,-7}, {-11,-6}, {-11,-5}, {-11,-4}, {-11,-3}, {-11,-2}, {-11,-1}, {-11,0}, {-11,1}, {-11,2}, {-11,3}, {-11,4}, {-11,5}, {-11,6}, {-11,7}, {-11,8}, {-11,9}, {-11,10}, {-11,11}, {-11,12}, {-11,13}, {-11,14}, {-11,15}, {-11,16}, {-11,17}, {-11,18}, {-11,19}, {-11,20}, {-11,21}, {-11,22}, {-10,-31}, {-10,-30}, {-10,-29}, {-10,-28}, {-10,-27}, {-10,-26}, {-10,-25}, {-10,-24}, {-10,-23}, {-10,-22}, {-10,-21}, {-10,-20}, {-10,-19}, {-10,-18}, {-10,-17}, {-10,-16}, {-10,-15}, {-10,-14}, {-10,-10}, {-10,-9}, {-10,-8}, {-10,-7}, {-10,-6}, {-10,-5}, {-10,-4}, {-10,-3}, {-10,-2}, {-10,-1}, {-10,0}, {-10,1}, {-10,2}, {-10,3}, {-10,4}, {-10,5}, {-10,6}, {-10,7}, {-10,8}, {-10,9}, {-10,10}, {-10,11}, {-10,12}, {-10,13}, {-10,14}, {-10,15}, {-10,16}, {-10,17}, {-10,18}, {-10,19}, {-10,20}, {-10,21}, {-10,22}, {-9,-31}, {-9,-30}, {-9,-29}, {-9,-28}, {-9,-27}, {-9,-26}, {-9,-25}, {-9,-24}, {-9,-23}, {-9,-22}, {-9,-21}, {-9,-20}, {-9,-19}, {-9,-18}, {-9,-17}, {-9,-16}, {-9,-15}, {-9,-10}, {-9,-9}, {-9,-8}, {-9,-7}, {-9,-6}, {-9,-5}, {-9,-4}, {-9,-3}, {-9,-2}, {-9,-1}, {-9,0}, {-9,1}, {-9,2}, {-9,3}, {-9,4}, {-9,5}, {-9,6}, {-9,7}, {-9,8}, {-9,9}, {-9,10}, {-9,11}, {-9,12}, {-9,13}, {-9,14}, {-9,15}, {-9,16}, {-9,17}, {-9,18}, {-9,19}, {-9,20}, {-9,21}, {-9,22}, {-8,-31}, {-8,-30}, {-8,-29}, {-8,-28}, {-8,-27}, {-8,-26}, {-8,-25}, {-8,-24}, {-8,-23}, {-8,-22}, {-8,-21}, {-8,-20}, {-8,-19}, {-8,-18}, {-8,-17}, {-8,-16}, {-8,-15}, {-8,-9}, {-8,-8}, {-8,-7}, {-8,-6}, {-8,-5}, {-8,-4}, {-8,-3}, {-8,-2}, {-8,-1}, {-8,0}, {-8,1}, {-8,2}, {-8,3}, {-8,4}, {-8,5}, {-8,6}, {-8,7}, {-8,8}, {-8,9}, {-8,10}, {-8,11}, {-8,12}, {-8,13}, {-8,14}, {-8,15}, {-8,16}, {-8,17}, {-8,18}, {-8,19}, {-8,20}, {-8,21}, {-8,22}, {-7,-31}, {-7,-30}, {-7,-29}, {-7,-28}, {-7,-27}, {-7,-26}, {-7,-25}, {-7,-24}, {-7,-23}, {-7,-22}, {-7,-21}, {-7,-20}, {-7,-19}, {-7,-18}, {-7,-17}, {-7,-16}, {-7,-15}, {-7,-9}, {-7,-8}, {-7,-7}, {-7,-6}, {-7,-5}, {-7,-4}, {-7,-3}, {-7,-2}, {-7,-1}, {-7,0}, {-7,1}, {-7,2}, {-7,3}, {-7,4}, {-7,5}, {-7,6}, {-7,7}, {-7,8}, {-7,9}, {-7,10}, {-7,11}, {-7,12}, {-7,13}, {-7,14}, {-7,15}, {-7,16}, {-7,17}, {-7,18}, {-7,19}, {-7,20}, {-7,21}, {-7,22}, {-6,-30}, {-6,-29}, {-6,-28}, {-6,-27}, {-6,-26}, {-6,-25}, {-6,-24}, {-6,-23}, {-6,-22}, {-6,-21}, {-6,-20}, {-6,-19}, {-6,-18}, {-6,-17}, {-6,-16}, {-6,-15}, {-6,-9}, {-6,-8}, {-6,-7}, {-6,-6}, {-6,-5}, {-6,-4}, {-6,-3}, {-6,-2}, {-6,-1}, {-6,0}, {-6,1}, {-6,2}, {-6,3}, {-6,4}, {-6,5}, {-6,6}, {-6,7}, {-6,8}, {-6,9}, {-6,10}, {-6,11}, {-6,12}, {-6,13}, {-6,14}, {-6,15}, {-6,16}, {-6,17}, {-6,18}, {-6,19}, {-6,20}, {-6,21}, {-6,22}, {-5,-30}, {-5,-29}, {-5,-28}, {-5,-27}, {-5,-26}, {-5,-25}, {-5,-24}, {-5,-23}, {-5,-22}, {-5,-21}, {-5,-20}, {-5,-19}, {-5,-18}, {-5,-17}, {-5,-16}, {-5,-15}, {-5,-9}, {-5,-8}, {-5,-7}, {-5,-6}, {-5,-5}, {-5,-4}, {-5,-3}, {-5,-2}, {-5,-1}, {-5,0}, {-5,1}, {-5,2}, {-5,3}, {-5,4}, {-5,5}, {-5,6}, {-5,7}, {-5,8}, {-5,9}, {-5,10}, {-5,11}, {-5,12}, {-5,13}, {-5,14}, {-5,15}, {-5,16}, {-5,17}, {-5,18}, {-5,19}, {-5,20}, {-5,21}, {-5,22}, {-4,-30}, {-4,-29}, {-4,-28}, {-4,-27}, {-4,-26}, {-4,-25}, {-4,-24}, {-4,-23}, {-4,-22}, {-4,-21}, {-4,-20}, {-4,-19}, {-4,-18}, {-4,-17}, {-4,-16}, {-4,-15}, {-4,-8}, {-4,-7}, {-4,-6}, {-4,-5}, {-4,-4}, {-4,-3}, {-4,-2}, {-4,-1}, {-4,0}, {-4,1}, {-4,2}, {-4,3}, {-4,4}, {-4,5}, {-4,6}, {-4,7}, {-4,8}, {-4,9}, {-4,10}, {-4,11}, {-4,12}, {-4,13}, {-4,14}, {-4,15}, {-4,16}, {-4,17}, {-4,18}, {-4,19}, {-4,20}, {-4,21}, {-4,22}, {-4,23}, {-3,-28}, {-3,-27}, {-3,-26}, {-3,-25}, {-3,-24}, {-3,-23}, {-3,-22}, {-3,-21}, {-3,-20}, {-3,-19}, {-3,-18}, {-3,-17}, {-3,-16}, {-3,-8}, {-3,-7}, {-3,-6}, {-3,-5}, {-3,-4}, {-3,-3}, {-3,-2}, {-3,-1}, {-3,0}, {-3,1}, {-3,2}, {-3,3}, {-3,4}, {-3,5}, {-3,6}, {-3,7}, {-3,8}, {-3,9}, {-3,10}, {-3,11}, {-3,12}, {-3,13}, {-3,14}, {-3,15}, {-3,16}, {-3,17}, {-3,18}, {-3,19}, {-3,20}, {-3,21}, {-3,22}, {-3,23}, {-2,-28}, {-2,-27}, {-2,-26}, {-2,-25}, {-2,-24}, {-2,-23}, {-2,-22}, {-2,-21}, {-2,-20}, {-2,-19}, {-2,-18}, {-2,-17}, {-2,-8}, {-2,-7}, {-2,-6}, {-2,-5}, {-2,-4}, {-2,-3}, {-2,-2}, {-2,-1}, {-2,0}, {-2,1}, {-2,2}, {-2,3}, {-2,4}, {-2,5}, {-2,6}, {-2,7}, {-2,8}, {-2,9}, {-2,10}, {-2,11}, {-2,12}, {-2,13}, {-2,14}, {-2,15}, {-2,16}, {-2,17}, {-2,18}, {-2,19}, {-2,20}, {-2,21}, {-2,22}, {-2,23}, {-2,24}, {-1,-28}, {-1,-27}, {-1,-26}, {-1,-25}, {-1,-24}, {-1,-23}, {-1,-22}, {-1,-21}, {-1,-20}, {-1,-8}, {-1,-7}, {-1,-6}, {-1,-5}, {-1,-4}, {-1,-3}, {-1,-2}, {-1,-1}, {-1,0}, {-1,1}, {-1,2}, {-1,3}, {-1,4}, {-1,5}, {-1,6}, {-1,7}, {-1,8}, {-1,9}, {-1,10}, {-1,11}, {-1,12}, {-1,13}, {-1,14}, {-1,15}, {-1,16}, {-1,17}, {-1,18}, {-1,19}, {-1,20}, {-1,21}, {-1,22}, {-1,23}, {-1,24}, {0,-27}, {0,-26}, {0,-25}, {0,-24}, {0,-23}, {0,-22}, {0,-21}, {0,-20}, {0,-8}, {0,-7}, {0,-6}, {0,-5}, {0,-4}, {0,-3}, {0,-2}, {0,-1}, {0,0}, {0,1}, {0,2}, {0,3}, {0,4}, {0,5}, {0,6}, {0,7}, {0,8}, {0,9}, {0,10}, {0,11}, {0,12}, {0,13}, {0,14}, {0,15}, {0,16}, {0,17}, {0,18}, {0,19}, {0,20}, {0,21}, {0,22}, {0,23}, {0,24}, {1,-26}, {1,-25}, {1,-24}, {1,-23}, {1,-22}, {1,-21}, {1,-8}, {1,-7}, {1,-6}, {1,-5}, {1,-4}, {1,-3}, {1,-2}, {1,-1}, {1,0}, {1,1}, {1,2}, {1,3}, {1,4}, {1,5}, {1,6}, {1,7}, {1,8}, {1,9}, {1,10}, {1,11}, {1,12}, {1,13}, {1,14}, {1,15}, {1,16}, {1,17}, {1,18}, {1,19}, {1,20}, {1,21}, {1,22}, {1,23}, {1,24}, {1,25}, {2,-24}, {2,-8}, {2,-7}, {2,-6}, {2,-5}, {2,-4}, {2,-3}, {2,-2}, {2,-1}, {2,0}, {2,1}, {2,2}, {2,3}, {2,4}, {2,5}, {2,6}, {2,7}, {2,8}, {2,9}, {2,10}, {2,11}, {2,12}, {2,13}, {2,14}, {2,15}, {2,16}, {2,17}, {2,18}, {2,19}, {2,20}, {2,21}, {2,22}, {2,23}, {2,24}, {2,25}, {3,-8}, {3,-7}, {3,-6}, {3,-5}, {3,-4}, {3,-3}, {3,-2}, {3,-1}, {3,0}, {3,1}, {3,2}, {3,3}, {3,4}, {3,5}, {3,6}, {3,7}, {3,8}, {3,9}, {3,10}, {3,11}, {3,12}, {3,13}, {3,14}, {3,15}, {3,16}, {3,17}, {3,18}, {3,19}, {3,20}, {3,21}, {3,22}, {3,23}, {3,24}, {3,25}, {4,-8}, {4,-7}, {4,-6}, {4,-5}, {4,-4}, {4,-3}, {4,-2}, {4,-1}, {4,0}, {4,1}, {4,2}, {4,3}, {4,4}, {4,5}, {4,6}, {4,7}, {4,8}, {4,9}, {4,10}, {4,11}, {4,12}, {4,13}, {4,14}, {4,15}, {4,16}, {4,17}, {4,18}, {4,19}, {4,20}, {4,21}, {4,22}, {4,23}, {4,24}, {4,25}, {5,-10}, {5,-9}, {5,-8}, {5,-7}, {5,-6}, {5,-5}, {5,-4}, {5,-3}, {5,-2}, {5,-1}, {5,0}, {5,1}, {5,2}, {5,3}, {5,4}, {5,5}, {5,6}, {5,7}, {5,8}, {5,9}, {5,10}, {5,11}, {5,12}, {5,13}, {5,14}, {5,15}, {5,16}, {5,17}, {5,18}, {5,19}, {5,20}, {5,21}, {5,22}, {5,23}, {5,24}, {5,25}, {6,-11}, {6,-10}, {6,-9}, {6,-8}, {6,-7}, {6,-6}, {6,-5}, {6,-4}, {6,-3}, {6,-2}, {6,-1}, {6,0}, {6,1}, {6,2}, {6,3}, {6,4}, {6,5}, {6,6}, {6,7}, {6,8}, {6,9}, {6,10}, {6,11}, {6,12}, {6,13}, {6,14}, {6,15}, {6,16}, {6,17}, {6,18}, {6,19}, {6,20}, {6,21}, {6,22}, {6,23}, {6,24}, {6,25}, {6,26}, {6,27}, {7,-11}, {7,-10}, {7,-9}, {7,-8}, {7,-7}, {7,-6}, {7,-5}, {7,-4}, {7,-3}, {7,-2}, {7,-1}, {7,0}, {7,1}, {7,2}, {7,3}, {7,4}, {7,5}, {7,6}, {7,7}, {7,8}, {7,9}, {7,10}, {7,11}, {7,12}, {7,13}, {7,14}, {7,15}, {7,16}, {7,17}, {7,18}, {7,19}, {7,20}, {7,21}, {7,22}, {7,23}, {7,24}, {7,25}, {7,26}, {7,27}, {7,28}, {8,-14}, {8,-13}, {8,-12}, {8,-11}, {8,-10}, {8,-9}, {8,-8}, {8,-7}, {8,-6}, {8,-5}, {8,-4}, {8,-3}, {8,-2}, {8,-1}, {8,0}, {8,1}, {8,2}, {8,3}, {8,4}, {8,5}, {8,6}, {8,7}, {8,8}, {8,9}, {8,10}, {8,11}, {8,12}, {8,13}, {8,14}, {8,15}, {8,16}, {8,17}, {8,18}, {8,19}, {8,20}, {8,21}, {8,22}, {8,23}, {8,24}, {8,25}, {8,26}, {8,27}, {8,28}, {9,-16}, {9,-15}, {9,-14}, {9,-13}, {9,-12}, {9,-11}, {9,-10}, {9,-9}, {9,-8}, {9,-7}, {9,-6}, {9,-5}, {9,-4}, {9,-3}, {9,-2}, {9,-1}, {9,0}, {9,1}, {9,2}, {9,3}, {9,4}, {9,5}, {9,6}, {9,7}, {9,8}, {9,9}, {9,10}, {9,11}, {9,12}, {9,13}, {9,14}, {9,15}, {9,16}, {9,17}, {9,18}, {9,19}, {9,20}, {9,21}, {9,22}, {9,23}, {9,24}, {9,25}, {9,26}, {9,27}, {9,28}, {9,29}, {10,-16}, {10,-15}, {10,-14}, {10,-13}, {10,-12}, {10,-11}, {10,-10}, {10,-9}, {10,-8}, {10,-7}, {10,-6}, {10,-5}, {10,-4}, {10,-3}, {10,-2}, {10,-1}, {10,0}, {10,1}, {10,2}, {10,3}, {10,4}, {10,5}, {10,6}, {10,7}, {10,8}, {10,9}, {10,10}, {10,11}, {10,12}, {10,13}, {10,14}, {10,15}, {10,16}, {10,17}, {10,18}, {10,19}, {10,20}, {10,21}, {10,22}, {10,23}, {10,24}, {10,25}, {10,26}, {10,27}, {10,28}, {10,29}, {11,-17}, {11,-16}, {11,-15}, {11,-14}, {11,-13}, {11,-12}, {11,-11}, {11,-10}, {11,-9}, {11,-8}, {11,-7}, {11,-6}, {11,-5}, {11,-4}, {11,-3}, {11,-2}, {11,-1}, {11,0}, {11,1}, {11,2}, {11,3}, {11,4}, {11,5}, {11,6}, {11,7}, {11,8}, {11,9}, {11,10}, {11,11}, {11,12}, {11,13}, {11,14}, {11,15}, {11,16}, {11,17}, {11,18}, {11,19}, {11,20}, {11,21}, {11,22}, {11,23}, {11,24}, {11,25}, {11,26}, {11,27}, {11,28}, {11,29}, {12,-17}, {12,-16}, {12,-15}, {12,-14}, {12,-13}, {12,-12}, {12,-11}, {12,-10}, {12,-9}, {12,-8}, {12,-7}, {12,-6}, {12,-5}, {12,-4}, {12,-3}, {12,-2}, {12,-1}, {12,0}, {12,1}, {12,2}, {12,3}, {12,4}, {12,5}, {12,6}, {12,7}, {12,8}, {12,9}, {12,10}, {12,11}, {12,12}, {12,13}, {12,14}, {12,15}, {12,16}, {12,17}, {12,18}, {12,19}, {12,20}, {12,21}, {12,22}, {12,23}, {12,24}, {12,25}, {12,26}, {12,27}, {12,28}, {12,29}, {13,-19}, {13,-18}, {13,-17}, {13,-16}, {13,-15}, {13,-14}, {13,-13}, {13,-12}, {13,-11}, {13,-10}, {13,-9}, {13,-8}, {13,-7}, {13,-6}, {13,-5}, {13,-4}, {13,-3}, {13,-2}, {13,-1}, {13,0}, {13,1}, {13,2}, {13,3}, {13,4}, {13,5}, {13,6}, {13,7}, {13,8}, {13,9}, {13,10}, {13,11}, {13,12}, {13,13}, {13,14}, {13,15}, {13,16}, {13,17}, {13,18}, {13,19}, {13,20}, {13,21}, {13,22}, {13,23}, {13,24}, {13,25}, {13,26}, {13,27}, {13,28}, {13,29}, {14,-19}, {14,-18}, {14,-17}, {14,-16}, {14,-15}, {14,-14}, {14,-13}, {14,-12}, {14,-11}, {14,-10}, {14,-9}, {14,-8}, {14,-7}, {14,-6}, {14,-5}, {14,-4}, {14,-3}, {14,-2}, {14,-1}, {14,0}, {14,1}, {14,2}, {14,3}, {14,4}, {14,5}, {14,6}, {14,7}, {14,8}, {14,9}, {14,10}, {14,11}, {14,12}, {14,13}, {14,14}, {14,15}, {14,16}, {14,17}, {14,18}, {14,19}, {14,20}, {14,21}, {14,22}, {14,23}, {14,24}, {14,25}, {14,26}, {14,27}, {14,28}, {14,29}, {15,-19}, {15,-18}, {15,-17}, {15,-16}, {15,-15}, {15,-14}, {15,-13}, {15,-12}, {15,-11}, {15,-10}, {15,-9}, {15,-8}, {15,-7}, {15,-6}, {15,-5}, {15,-4}, {15,-3}, {15,-2}, {15,-1}, {15,0}, {15,1}, {15,2}, {15,3}, {15,4}, {15,5}, {15,6}, {15,7}, {15,8}, {15,9}, {15,10}, {15,11}, {15,12}, {15,13}, {15,14}, {15,15}, {15,16}, {15,17}, {15,18}, {15,19}, {15,20}, {15,21}, {15,22}, {15,23}, {15,24}, {15,25}, {15,26}, {15,27}, {15,28}, {15,29}, {15,30}, {16,-19}, {16,-18}, {16,-17}, {16,-16}, {16,-15}, {16,-14}, {16,-13}, {16,-12}, {16,-11}, {16,-10}, {16,-9}, {16,-8}, {16,-7}, {16,-6}, {16,-5}, {16,-4}, {16,-3}, {16,-2}, {16,-1}, {16,0}, {16,1}, {16,2}, {16,3}, {16,4}, {16,5}, {16,6}, {16,7}, {16,8}, {16,9}, {16,10}, {16,11}, {16,12}, {16,13}, {16,14}, {16,15}, {16,16}, {16,17}, {16,18}, {16,19}, {16,20}, {16,21}, {16,22}, {16,23}, {16,24}, {16,25}, {16,26}, {16,27}, {16,28}, {16,29}, {16,30}, {17,-20}, {17,-19}, {17,-18}, {17,-17}, {17,-16}, {17,-15}, {17,-14}, {17,-13}, {17,-12}, {17,-11}, {17,-10}, {17,-9}, {17,-8}, {17,-7}, {17,-6}, {17,-5}, {17,-4}, {17,-3}, {17,-2}, {17,-1}, {17,0}, {17,1}, {17,2}, {17,3}, {17,4}, {17,5}, {17,6}, {17,7}, {17,8}, {17,9}, {17,10}, {17,11}, {17,12}, {17,13}, {17,14}, {17,15}, {17,16}, {17,17}, {17,18}, {17,19}, {17,20}, {17,21}, {17,22}, {17,23}, {17,24}, {17,25}, {17,26}, {17,27}, {17,28}, {17,29}, {17,30}, {18,-20}, {18,-19}, {18,-18}, {18,-17}, {18,-16}, {18,-15}, {18,-14}, {18,-13}, {18,-12}, {18,-11}, {18,-10}, {18,-9}, {18,-8}, {18,-7}, {18,-6}, {18,-5}, {18,-4}, {18,-3}, {18,-2}, {18,-1}, {18,0}, {18,1}, {18,2}, {18,3}, {18,4}, {18,5}, {18,6}, {18,7}, {18,8}, {18,9}, {18,10}, {18,11}, {18,12}, {18,13}, {18,14}, {18,15}, {18,16}, {18,17}, {18,18}, {18,19}, {18,20}, {18,21}, {18,22}, {18,23}, {18,24}, {18,25}, {18,26}, {18,27}, {18,28}, {18,29}, {18,30}, {19,-20}, {19,-19}, {19,-18}, {19,-17}, {19,-16}, {19,-15}, {19,-14}, {19,-13}, {19,-12}, {19,-11}, {19,-10}, {19,-9}, {19,-8}, {19,-7}, {19,-6}, {19,-5}, {19,-4}, {19,-3}, {19,-2}, {19,-1}, {19,0}, {19,1}, {19,2}, {19,3}, {19,4}, {19,5}, {19,6}, {19,7}, {19,8}, {19,9}, {19,10}, {19,11}, {19,12}, {19,13}, {19,14}, {19,15}, {19,16}, {19,17}, {19,18}, {19,19}, {19,20}, {19,21}, {19,22}, {19,23}, {19,24}, {19,25}, {19,26}, {19,27}, {19,28}, {19,29}, {19,30}, {20,-19}, {20,-18}, {20,-17}, {20,-16}, {20,-15}, {20,-14}, {20,-13}, {20,-12}, {20,-11}, {20,-10}, {20,-9}, {20,-8}, {20,-7}, {20,-6}, {20,-5}, {20,-4}, {20,-3}, {20,-2}, {20,-1}, {20,0}, {20,1}, {20,2}, {20,3}, {20,4}, {20,5}, {20,6}, {20,7}, {20,8}, {20,9}, {20,10}, {20,11}, {20,12}, {20,13}, {20,14}, {20,15}, {20,16}, {20,17}, {20,18}, {20,19}, {20,20}, {20,21}, {20,22}, {20,23}, {20,24}, {20,25}, {20,26}, {20,27}, {20,28}, {20,29}, {20,30}, {21,-19}, {21,-18}, {21,-17}, {21,-16}, {21,-15}, {21,-14}, {21,-13}, {21,-12}, {21,-11}, {21,-10}, {21,-9}, {21,-8}, {21,-7}, {21,-6}, {21,-5}, {21,-4}, {21,-3}, {21,-2}, {21,-1}, {21,0}, {21,1}, {21,2}, {21,3}, {21,4}, {21,5}, {21,6}, {21,7}, {21,8}, {21,9}, {21,10}, {21,11}, {21,12}, {21,13}, {21,14}, {21,15}, {21,16}, {21,17}, {21,18}, {21,19}, {21,20}, {21,21}, {21,22}, {21,23}, {21,24}, {21,25}, {21,26}, {21,27}, {21,28}, {21,29}, {21,30}, {21,31}, {22,-18}, {22,-17}, {22,-16}, {22,-15}, {22,-14}, {22,-13}, {22,-12}, {22,-11}, {22,-10}, {22,-9}, {22,-8}, {22,-7}, {22,-6}, {22,-5}, {22,-4}, {22,-3}, {22,-2}, {22,-1}, {22,0}, {22,1}, {22,2}, {22,3}, {22,4}, {22,5}, {22,6}, {22,7}, {22,8}, {22,9}, {22,10}, {22,11}, {22,12}, {22,13}, {22,14}, {22,15}, {22,16}, {22,17}, {22,18}, {22,19}, {22,20}, {22,21}, {22,22}, {22,23}, {22,24}, {22,25}, {22,26}, {22,27}, {22,28}, {22,29}, {22,30}, {22,31}, {23,-17}, {23,-16}, {23,-15}, {23,-14}, {23,-13}, {23,-12}, {23,-11}, {23,-10}, {23,-9}, {23,-8}, {23,-7}, {23,-6}, {23,-5}, {23,-4}, {23,-3}, {23,-2}, {23,-1}, {23,0}, {23,1}, {23,2}, {23,3}, {23,4}, {23,5}, {23,6}, {23,7}, {23,8}, {23,9}, {23,10}, {23,11}, {23,12}, {23,13}, {23,14}, {23,15}, {23,16}, {23,17}, {23,18}, {23,19}, {23,20}, {23,21}, {23,22}, {23,23}, {23,24}, {23,25}, {23,26}, {23,27}, {23,28}, {23,29}, {23,30}, {23,31}, {24,-17}, {24,-16}, {24,-15}, {24,-14}, {24,-13}, {24,-12}, {24,-11}, {24,-10}, {24,-9}, {24,-8}, {24,-7}, {24,-6}, {24,-5}, {24,-4}, {24,-3}, {24,-2}, {24,-1}, {24,0}, {24,1}, {24,2}, {24,3}, {24,4}, {24,5}, {24,6}, {24,7}, {24,8}, {24,9}, {24,10}, {24,11}, {24,12}, {24,13}, {24,14}, {24,15}, {24,16}, {24,17}, {24,18}, {24,19}, {24,20}, {24,21}, {24,22}, {24,23}, {24,24}, {24,25}, {24,26}, {24,27}, {24,28}, {24,29}, {24,30}, {24,31}, {25,-15}, {25,-14}, {25,-13}, {25,-12}, {25,-11}, {25,-10}, {25,-9}, {25,-8}, {25,-7}, {25,-6}, {25,-5}, {25,-4}, {25,-3}, {25,-2}, {25,-1}, {25,0}, {25,1}, {25,2}, {25,3}, {25,4}, {25,5}, {25,6}, {25,7}, {25,8}, {25,9}, {25,10}, {25,11}, {25,12}, {25,13}, {25,14}, {25,15}, {25,16}, {25,17}, {25,18}, {25,19}, {25,20}, {25,21}, {25,22}, {25,23}, {25,24}, {25,25}, {25,26}, {25,27}, {25,28}, {25,29}, {25,30}, {25,31}, {26,-15}, {26,-14}, {26,-13}, {26,-12}, {26,-11}, {26,-10}, {26,-9}, {26,-8}, {26,-7}, {26,-6}, {26,-5}, {26,-4}, {26,-3}, {26,-2}, {26,-1}, {26,0}, {26,1}, {26,2}, {26,3}, {26,4}, {26,5}, {26,6}, {26,7}, {26,8}, {26,9}, {26,10}, {26,11}, {26,12}, {26,13}, {26,14}, {26,15}, {26,16}, {26,17}, {26,18}, {26,19}, {26,20}, {26,21}, {26,22}, {26,23}, {26,24}, {26,25}, {26,26}, {26,30}, {26,31}, {27,-15}, {27,-14}, {27,-13}, {27,-12}, {27,-11}, {27,-10}, {27,-9}, {27,-8}, {27,-7}, {27,-6}, {27,-5}, {27,-4}, {27,-3}, {27,-2}, {27,-1}, {27,0}, {27,1}, {27,2}, {27,3}, {27,4}, {27,5}, {27,6}, {27,7}, {27,8}, {27,9}, {27,10}, {27,11}, {27,12}, {27,13}, {27,14}, {27,15}, {27,16}, {27,17}, {27,18}, {27,19}, {27,20}, {27,21}, {27,22}, {28,-14}, {28,-13}, {28,-12}, {28,-11}, {28,-10}, {28,-9}, {28,-8}, {28,-7}, {28,-6}, {28,-5}, {28,-4}, {28,-3}, {28,-2}, {28,-1}, {28,0}, {28,1}, {28,2}, {28,3}, {28,4}, {28,5}, {28,6}, {28,7}, {28,8}, {28,9}, {28,10}, {28,11}, {28,12}, {28,13}, {28,14}, {28,15}, {28,16}, {28,17}, {28,18}, {28,19}, {28,20}, {28,21}, {29,-9}, {29,-8}, {29,-7}, {29,-6}, {29,-5}, {29,-4}, {29,-3}, {29,-2}, {29,-1}, {29,0}, {29,1}, {29,2}, {29,3}, {29,4}, {29,5}, {29,6}, {29,7}, {29,8}, {29,9}, {29,10}, {29,11}, {29,12}, {29,13}, {29,14}, {29,15}, {29,16}, {29,17}, {29,18}, {29,19}, {30,-8}, {30,-7}, {30,-6}, {30,-5}, {30,-4}, {30,-3}, {30,-2}, {30,-1}, {30,0}, {30,1}, {30,2}, {30,3}, {30,4}, {30,5}, {30,6}, {30,7}, {30,8}, {30,9}, {30,10}, {30,11}, {30,12}, {30,13}, {30,14}, {31,-5}, {31,-4}, {31,-3}, {31,-2}, {31,-1}, {31,3}, {31,4}, {31,5}, {31,6}, {31,7}, {31,8}, {31,9}, {31,10}, {31,11}, {31,12}, {31,13}, },
    ["se-space-platform-plating"] = {{-31,-12}, {-31,-11}, {-31,-10}, {-31,-9}, {-30,-13}, {-30,-8}, {-29,-13}, {-29,-11}, {-29,-10}, {-29,-8}, {-28,-13}, {-28,-11}, {-28,-10}, {-28,-8}, {-27,-13}, {-26,-12}, {-26,-11}, {-26,-10}, {-26,-8}, {-25,-7}, {-25,-6}, {-24,-7}, {-20,27}, {-20,28}, {-20,29}, {-20,30}, {-19,25}, {-19,26}, {-19,31}, {-16,25}, {-15,25}, {-15,26}, {-14,23}, {-14,24}, {-11,23}, {-11,24}, {-10,25}, {-10,26}, {-9,25}, {-6,25}, {-6,26}, {-6,31}, {-5,27}, {-5,28}, {-5,29}, {-5,30}, {5,-31}, {5,-30}, {5,-29}, {5,-26}, {5,-25}, {5,-24}, {6,-31}, {6,-30}, {6,-29}, {6,-26}, {6,-25}, {6,-24}, {7,-31}, {7,-30}, {7,-29}, {7,-26}, {7,-25}, {7,-24}, {8,-32}, {8,-31}, {8,-30}, {8,-29}, {8,-26}, {8,-25}, {8,-24}, {8,-23}, {9,-32}, {9,-31}, {9,-30}, {9,-29}, {9,-26}, {9,-25}, {9,-24}, {9,-23}, {10,-32}, {10,-31}, {10,-30}, {10,-29}, {10,-26}, {10,-25}, {10,-24}, {10,-23}, {11,-32}, {11,-31}, {11,-30}, {11,-29}, {11,-26}, {11,-25}, {11,-24}, {11,-23}, {12,-32}, {12,-31}, {12,-30}, {12,-29}, {12,-26}, {12,-25}, {12,-24}, {12,-23}, {13,-32}, {13,-31}, {13,-30}, {13,-29}, {13,-26}, {13,-25}, {13,-24}, {13,-23}, {14,-32}, {14,-31}, {14,-30}, {14,-29}, {14,-26}, {14,-25}, {14,-24}, {14,-23}, {15,-32}, {15,-31}, {15,-30}, {15,-29}, {15,-26}, {15,-25}, {15,-24}, {15,-23}, {17,-31}, {17,-30}, {17,-25}, {17,-24}, {18,-31}, {18,-30}, {18,-25}, {18,-24}, {20,-32}, {20,-31}, {20,-30}, {20,-29}, {20,-26}, {20,-25}, {20,-24}, {20,-23}, {21,-32}, {21,-31}, {21,-30}, {21,-29}, {21,-26}, {21,-25}, {21,-24}, {21,-23}, {22,-32}, {22,-31}, {22,-30}, {22,-29}, {22,-26}, {22,-25}, {22,-24}, {22,-23}, {23,-32}, {23,-31}, {23,-30}, {23,-29}, {23,-26}, {23,-25}, {23,-24}, {23,-23}, {24,-32}, {24,-31}, {24,-30}, {24,-29}, {24,-26}, {24,-25}, {24,-24}, {24,-23}, {25,-32}, {25,-31}, {25,-30}, {25,-29}, {25,-26}, {25,-25}, {25,-24}, {25,-23}, {26,-32}, {26,-31}, {26,-30}, {26,-29}, {26,-26}, {26,-25}, {26,-24}, {26,-23}, {27,-32}, {27,-31}, {27,-30}, {27,-29}, {27,-26}, {27,-25}, {27,-24}, {27,-23}, {28,-31}, {28,-30}, {28,-29}, {28,-26}, {28,-25}, {28,-24}, {29,-31}, {29,-30}, {29,-29}, {29,-26}, {29,-25}, {29,-24}, {30,-31}, {30,-30}, {30,-29}, {30,-26}, {30,-25}, {30,-24}, },
    ["se-space-platform-scaffold"] = {{-30,-12}, {-30,-11}, {-30,-10}, {-30,-9}, {-29,-12}, {-29,-9}, {-28,-12}, {-28,-9}, {-27,-12}, {-27,-11}, {-27,-10}, {-27,-9}, {-27,-8}, {-26,-9}, {-23,22}, {-23,23}, {-23,24}, {-23,25}, {-23,26}, {-22,23}, {-22,24}, {-22,25}, {-22,26}, {-22,27}, {-22,28}, {-21,23}, {-21,24}, {-21,25}, {-21,26}, {-21,27}, {-21,28}, {-21,29}, {-21,30}, {-20,23}, {-20,24}, {-20,25}, {-20,26}, {-19,23}, {-19,24}, {-18,-13}, {-18,-12}, {-18,-11}, {-18,-10}, {-18,23}, {-18,24}, {-18,25}, {-17,-13}, {-17,-12}, {-17,-11}, {-17,-10}, {-17,23}, {-17,24}, {-17,25}, {-16,23}, {-16,24}, {-15,23}, {-15,24}, {-13,23}, {-13,24}, {-12,-13}, {-12,-12}, {-12,-11}, {-12,23}, {-12,24}, {-11,-13}, {-11,-12}, {-11,-11}, {-10,23}, {-10,24}, {-9,23}, {-9,24}, {-8,23}, {-8,24}, {-8,25}, {-7,23}, {-7,24}, {-7,25}, {-6,-14}, {-6,-13}, {-6,-12}, {-6,-11}, {-6,-10}, {-6,23}, {-6,24}, {-5,-14}, {-5,-13}, {-5,-12}, {-5,-11}, {-5,-10}, {-5,23}, {-5,24}, {-5,25}, {-5,26}, {-4,24}, {-4,25}, {-4,26}, {-4,27}, {-4,28}, {-4,29}, {-4,30}, {-3,24}, {-3,25}, {-3,26}, {-3,27}, {-3,28}, {-3,29}, {-2,25}, {-2,26}, {-2,27}, {-1,25}, {-1,26}, {0,25}, {0,26}, {0,27}, {1,26}, {1,27}, {1,28}, {2,26}, {3,26}, {4,26}, {5,26}, {5,27}, {16,-31}, {16,-30}, {16,-25}, {16,-24}, {17,-29}, {17,-28}, {17,-27}, {17,-26}, {17,-23}, {17,-22}, {17,-21}, {18,-29}, {18,-28}, {18,-27}, {18,-26}, {18,-23}, {18,-22}, {18,-21}, {19,-31}, {19,-30}, {19,-25}, {19,-24}, },
  },
  under_tiles = {
    ["se-space"] = {{-31,-12}, {-31,-11}, {-31,-10}, {-31,-9}, {-30,-13}, {-30,-8}, {-29,-13}, {-29,-11}, {-29,-10}, {-29,-8}, {-28,-13}, {-28,-11}, {-28,-10}, {-28,-8}, {-27,-13}, {-26,-12}, {-26,-11}, {-26,-10}, {-26,-8}, {-25,-7}, {-25,-6}, {-24,-7}, {-20,27}, {-20,28}, {-20,29}, {-20,30}, {-19,25}, {-19,26}, {-19,31}, {-16,25}, {-15,25}, {-15,26}, {-14,23}, {-14,24}, {-11,23}, {-11,24}, {-10,25}, {-10,26}, {-9,25}, {-6,25}, {-6,26}, {-6,31}, {-5,27}, {-5,28}, {-5,29}, {-5,30}, {5,-31}, {5,-30}, {5,-29}, {5,-26}, {5,-25}, {5,-24}, {6,-31}, {6,-30}, {6,-29}, {6,-26}, {6,-25}, {6,-24}, {7,-31}, {7,-30}, {7,-29}, {7,-26}, {7,-25}, {7,-24}, {8,-32}, {8,-31}, {8,-30}, {8,-29}, {8,-26}, {8,-25}, {8,-24}, {8,-23}, {9,-32}, {9,-31}, {9,-30}, {9,-29}, {9,-26}, {9,-25}, {9,-24}, {9,-23}, {10,-32}, {10,-31}, {10,-30}, {10,-29}, {10,-26}, {10,-25}, {10,-24}, {10,-23}, {11,-32}, {11,-31}, {11,-30}, {11,-29}, {11,-26}, {11,-25}, {11,-24}, {11,-23}, {12,-32}, {12,-31}, {12,-30}, {12,-29}, {12,-26}, {12,-25}, {12,-24}, {12,-23}, {13,-32}, {13,-31}, {13,-30}, {13,-29}, {13,-26}, {13,-25}, {13,-24}, {13,-23}, {14,-32}, {14,-31}, {14,-30}, {14,-29}, {14,-26}, {14,-25}, {14,-24}, {14,-23}, {15,-32}, {15,-31}, {15,-30}, {15,-29}, {15,-26}, {15,-25}, {15,-24}, {15,-23}, {17,-31}, {17,-30}, {17,-25}, {17,-24}, {18,-31}, {18,-30}, {18,-25}, {18,-24}, {20,-32}, {20,-31}, {20,-30}, {20,-29}, {20,-26}, {20,-25}, {20,-24}, {20,-23}, {21,-32}, {21,-31}, {21,-30}, {21,-29}, {21,-26}, {21,-25}, {21,-24}, {21,-23}, {22,-32}, {22,-31}, {22,-30}, {22,-29}, {22,-26}, {22,-25}, {22,-24}, {22,-23}, {23,-32}, {23,-31}, {23,-30}, {23,-29}, {23,-26}, {23,-25}, {23,-24}, {23,-23}, {24,-32}, {24,-31}, {24,-30}, {24,-29}, {24,-26}, {24,-25}, {24,-24}, {24,-23}, {25,-32}, {25,-31}, {25,-30}, {25,-29}, {25,-26}, {25,-25}, {25,-24}, {25,-23}, {26,-32}, {26,-31}, {26,-30}, {26,-29}, {26,-26}, {26,-25}, {26,-24}, {26,-23}, {27,-32}, {27,-31}, {27,-30}, {27,-29}, {27,-26}, {27,-25}, {27,-24}, {27,-23}, {28,-31}, {28,-30}, {28,-29}, {28,-26}, {28,-25}, {28,-24}, {29,-31}, {29,-30}, {29,-29}, {29,-26}, {29,-25}, {29,-24}, {30,-31}, {30,-30}, {30,-29}, {30,-26}, {30,-25}, {30,-24}, {-30,-12}, {-30,-11}, {-30,-10}, {-30,-9}, {-29,-12}, {-29,-9}, {-28,-12}, {-28,-9}, {-27,-12}, {-27,-11}, {-27,-10}, {-27,-9}, {-27,-8}, {-26,-9}, {-23,22}, {-23,23}, {-23,24}, {-23,25}, {-23,26}, {-22,23}, {-22,24}, {-22,25}, {-22,26}, {-22,27}, {-22,28}, {-21,23}, {-21,24}, {-21,25}, {-21,26}, {-21,27}, {-21,28}, {-21,29}, {-21,30}, {-20,23}, {-20,24}, {-20,25}, {-20,26}, {-19,23}, {-19,24}, {-18,-13}, {-18,-12}, {-18,-11}, {-18,-10}, {-18,23}, {-18,24}, {-18,25}, {-17,-13}, {-17,-12}, {-17,-11}, {-17,-10}, {-17,23}, {-17,24}, {-17,25}, {-16,23}, {-16,24}, {-15,23}, {-15,24}, {-13,23}, {-13,24}, {-12,-13}, {-12,-12}, {-12,-11}, {-12,23}, {-12,24}, {-11,-13}, {-11,-12}, {-11,-11}, {-10,23}, {-10,24}, {-9,23}, {-9,24}, {-8,23}, {-8,24}, {-8,25}, {-7,23}, {-7,24}, {-7,25}, {-6,-14}, {-6,-13}, {-6,-12}, {-6,-11}, {-6,-10}, {-6,23}, {-6,24}, {-5,-14}, {-5,-13}, {-5,-12}, {-5,-11}, {-5,-10}, {-5,23}, {-5,24}, {-5,25}, {-5,26}, {-4,24}, {-4,25}, {-4,26}, {-4,27}, {-4,28}, {-4,29}, {-4,30}, {-3,24}, {-3,25}, {-3,26}, {-3,27}, {-3,28}, {-3,29}, {-2,25}, {-2,26}, {-2,27}, {-1,25}, {-1,26}, {0,25}, {0,26}, {0,27}, {1,26}, {1,27}, {1,28}, {2,26}, {3,26}, {4,26}, {5,26}, {5,27}, {16,-31}, {16,-30}, {16,-25}, {16,-24}, {17,-29}, {17,-28}, {17,-27}, {17,-26}, {17,-23}, {17,-22}, {17,-21}, {18,-29}, {18,-28}, {18,-27}, {18,-26}, {18,-23}, {18,-22}, {18,-21}, {19,-31}, {19,-30}, {19,-25}, {19,-24}, },
  },

  entities = {
    ["se-static-rocket-fragment-small-c"] = {{x=-15.0546875, y=-27.765625, graphics_variation=1}, {x=20.21484375, y=-5.48046875, graphics_variation=1}, {x=-3.71484375, y=30.90234375, graphics_variation=1}, },
    ["se-big-rock-asteroid"] = {{x=-10.67578125, y=-28.59375, graphics_variation=2}, {x=-16.41796875, y=-24.68359375, graphics_variation=2}, {x=0.76171875, y=-24.80859375, graphics_variation=7}, {x=-27.3984375, y=-19.00390625, graphics_variation=6}, {x=-3.58984375, y=-17.1171875, graphics_variation=7}, {x=18.71875, y=-18.8359375, graphics_variation=15}, {x=-25.37890625, y=-17.09375, graphics_variation=5}, {x=-14.04296875, y=-14.7734375, graphics_variation=6}, {x=10.6328125, y=-14.90625, graphics_variation=20}, {x=8.88671875, y=-10.02734375, graphics_variation=4}, {x=27.48828125, y=-10.8671875, graphics_variation=2}, {x=26.9375, y=-8.0546875, graphics_variation=14}, {x=-19.8984375, y=-5.97265625, graphics_variation=19}, {x=-17.66796875, y=-5.97265625, graphics_variation=10}, {x=29.546875, y=-6.64453125, graphics_variation=5}, {x=-18.27734375, y=-3.8515625, graphics_variation=5}, {x=-24.50390625, y=-1.19921875, graphics_variation=13}, {x=24.45703125, y=-1.6171875, graphics_variation=13}, {x=-3.87890625, y=-0.6171875, graphics_variation=20}, {x=30.19921875, y=-1.0078125, graphics_variation=2}, {x=-23.06640625, y=1.5703125, graphics_variation=18}, {x=2.7265625, y=2.09765625, graphics_variation=5}, {x=8.515625, y=2.87109375, graphics_variation=16}, {x=11.62890625, y=3.56640625, graphics_variation=12}, {x=-25.92578125, y=5.87890625, graphics_variation=9}, {x=19.0078125, y=5.11328125, graphics_variation=11}, {x=-26.875, y=8.8671875, graphics_variation=15}, {x=-22.71875, y=17.0625, graphics_variation=5}, {x=-1.0546875, y=18.83203125, graphics_variation=10}, {x=15.6015625, y=17.55859375, graphics_variation=17}, {x=-21.51953125, y=20.0703125, graphics_variation=12}, {x=-5.2421875, y=20.80859375, graphics_variation=6}, {x=-1.7265625, y=20.87109375, graphics_variation=13}, {x=0.62890625, y=21.4375, graphics_variation=3}, {x=12.97265625, y=22.8984375, graphics_variation=3}, {x=14.5078125, y=25.00390625, graphics_variation=7}, {x=17.74609375, y=26.8203125, graphics_variation=17}, {x=19.828125, y=29.8671875, graphics_variation=20}, },
    ["se-static-rocket-fragment-big-b"] = {{x=-24.3515625, y=-23.76171875, graphics_variation=1}, {x=2.75390625, y=25.64453125, graphics_variation=1}, },
    ["se-static-rocket-fragment-tiny-c"] = {{x=-19.44140625, y=-22.3359375, graphics_variation=1}, {x=-4.7890625, y=13.23046875, graphics_variation=1}, {x=-15.90625, y=19.484375, graphics_variation=1}, },
    ["ruin-radar-remnants"] = {{x=-15.5, y=-22.5}, {x=-6.5, y=-1.5}, {x=-12.5, y=1.5}, {x=-8.5, y=4.5}, {x=-13.5, y=13.5}, },
    ["se-static-rocket-fragment-medium-a"] = {{x=-6.23828125, y=-20.29296875, graphics_variation=1}, {x=24.21875, y=26.35546875, graphics_variation=1}, },
    ["se-static-rocket-fragment-small-a"] = {{x=-5.96875, y=-18.796875, graphics_variation=1}, {x=3.63671875, y=-7.26953125, graphics_variation=1}, {x=-6.94140625, y=19.015625, graphics_variation=1}, {x=-21.15234375, y=30.1796875, graphics_variation=1}, },
    ["se-water-ice"] = {{x=16.5, y=-18.5}, {x=14.5, y=-16.5}, {x=15.5, y=-17.5}, {x=15.5, y=-16.5}, {x=16.5, y=-17.5}, {x=16.5, y=-16.5}, {x=18.5, y=-17.5}, {x=18.5, y=-16.5}, {x=17.5, y=-17.5}, {x=17.5, y=-16.5}, {x=20.5, y=-16.5}, {x=19.5, y=-16.5}, {x=12.5, y=-14.5}, {x=13.5, y=-14.5}, {x=14.5, y=-14.5}, {x=13.5, y=-15.5}, {x=14.5, y=-15.5}, {x=15.5, y=-15.5}, {x=16.5, y=-14.5}, {x=15.5, y=-14.5}, {x=16.5, y=-15.5}, {x=18.5, y=-14.5}, {x=17.5, y=-14.5}, {x=18.5, y=-15.5}, {x=17.5, y=-15.5}, {x=20.5, y=-14.5}, {x=20.5, y=-15.5}, {x=19.5, y=-15.5}, {x=19.5, y=-14.5}, {x=22.5, y=-14.5}, {x=21.5, y=-15.5}, {x=21.5, y=-14.5}, {x=10.5, y=-12.5}, {x=11.5, y=-12.5}, {x=12.5, y=-12.5}, {x=11.5, y=-13.5}, {x=12.5, y=-13.5}, {x=13.5, y=-12.5}, {x=14.5, y=-12.5}, {x=13.5, y=-13.5}, {x=14.5, y=-13.5}, {x=16.5, y=-12.5}, {x=15.5, y=-12.5}, {x=15.5, y=-13.5}, {x=16.5, y=-13.5}, {x=18.5, y=-12.5}, {x=17.5, y=-12.5}, {x=18.5, y=-13.5}, {x=17.5, y=-13.5}, {x=20.5, y=-12.5}, {x=19.5, y=-12.5}, {x=20.5, y=-13.5}, {x=19.5, y=-13.5}, {x=22.5, y=-13.5}, {x=22.5, y=-12.5}, {x=21.5, y=-12.5}, {x=21.5, y=-13.5}, {x=23.5, y=-13.5}, {x=23.5, y=-12.5}, {x=10.5, y=-10.5}, {x=10.5, y=-11.5}, {x=11.5, y=-11.5}, {x=11.5, y=-10.5}, {x=12.5, y=-11.5}, {x=12.5, y=-10.5}, {x=13.5, y=-10.5}, {x=14.5, y=-10.5}, {x=13.5, y=-11.5}, {x=14.5, y=-11.5}, {x=15.5, y=-10.5}, {x=16.5, y=-10.5}, {x=16.5, y=-11.5}, {x=15.5, y=-11.5}, {x=17.5, y=-10.5}, {x=18.5, y=-10.5}, {x=17.5, y=-11.5}, {x=18.5, y=-11.5}, {x=19.5, y=-10.5}, {x=20.5, y=-10.5}, {x=20.5, y=-11.5}, {x=19.5, y=-11.5}, {x=22.5, y=-10.5}, {x=21.5, y=-10.5}, {x=22.5, y=-11.5}, {x=21.5, y=-11.5}, {x=24.5, y=-11.5}, {x=24.5, y=-10.5}, {x=23.5, y=-11.5}, {x=23.5, y=-10.5}, {x=25.5, y=-10.5}, {x=12.5, y=-8.5}, {x=11.5, y=-9.5}, {x=12.5, y=-9.5}, {x=13.5, y=-8.5}, {x=14.5, y=-8.5}, {x=14.5, y=-9.5}, {x=13.5, y=-9.5}, {x=16.5, y=-8.5}, {x=15.5, y=-8.5}, {x=15.5, y=-9.5}, {x=16.5, y=-9.5}, {x=18.5, y=-8.5}, {x=17.5, y=-8.5}, {x=17.5, y=-9.5}, {x=18.5, y=-9.5}, {x=20.5, y=-8.5}, {x=19.5, y=-8.5}, {x=19.5, y=-9.5}, {x=20.5, y=-9.5}, {x=22.5, y=-8.5}, {x=21.5, y=-8.5}, {x=22.5, y=-9.5}, {x=21.5, y=-9.5}, {x=24.5, y=-8.5}, {x=23.5, y=-8.5}, {x=24.5, y=-9.5}, {x=23.5, y=-9.5}, {x=26.5, y=-8.5}, {x=25.5, y=-8.5}, {x=26.5, y=-9.5}, {x=25.5, y=-9.5}, {x=14.5, y=-7.5}, {x=13.5, y=-7.5}, {x=16.5, y=-7.5}, {x=15.5, y=-7.5}, {x=18.5, y=-6.5}, {x=18.5, y=-7.5}, {x=17.5, y=-7.5}, {x=20.5, y=-6.5}, {x=19.5, y=-6.5}, {x=19.5, y=-7.5}, {x=20.5, y=-7.5}, {x=21.5, y=-7.5}, {x=21.5, y=-6.5}, {x=22.5, y=-6.5}, {x=22.5, y=-7.5}, {x=23.5, y=-6.5}, {x=24.5, y=-6.5}, {x=24.5, y=-7.5}, {x=23.5, y=-7.5}, {x=26.5, y=-6.5}, {x=25.5, y=-6.5}, {x=26.5, y=-7.5}, {x=25.5, y=-7.5}, {x=19.5, y=-5.5}, {x=20.5, y=-5.5}, {x=21.5, y=-4.5}, {x=22.5, y=-4.5}, {x=21.5, y=-5.5}, {x=22.5, y=-5.5}, {x=23.5, y=-4.5}, {x=24.5, y=-4.5}, {x=23.5, y=-5.5}, {x=24.5, y=-5.5}, {x=25.5, y=-5.5}, },
    ["se-static-rocket-fragment-tiny-d"] = {{x=-22.08203125, y=-16.234375, graphics_variation=1}, {x=-3.3359375, y=-5.1796875, graphics_variation=1}, },
    ["se-static-rocket-fragment-small-d"] = {{x=-19.90234375, y=-16.38671875, graphics_variation=1}, {x=-19.21484375, y=12.83984375, graphics_variation=1}, {x=19.0625, y=12.94140625, graphics_variation=1}, {x=-10.0546875, y=21.5078125, graphics_variation=1}, },
    ["se-static-rocket-fragment-small-b"] = {{x=-16.578125, y=-16.40234375, graphics_variation=1}, {x=-20.42578125, y=6.671875, graphics_variation=1}, {x=-14.3671875, y=19.00390625, graphics_variation=1}, {x=22.01953125, y=21.8671875, graphics_variation=1}, },
    ["se-static-rocket-fragment-small-j"] = {{x=23.82421875, y=-15.4453125, graphics_variation=1}, {x=-11.98046875, y=-6.91796875, graphics_variation=1}, {x=22.46875, y=-4.9765625, graphics_variation=1}, {x=-25.55078125, y=11.78515625, graphics_variation=1}, {x=-23.33984375, y=22.8125, graphics_variation=1}, {x=0.625, y=28.59765625, graphics_variation=1}, {x=16.13671875, y=29.74609375, graphics_variation=1}, },
    ["se-static-rocket-fragment-medium-c"] = {{x=10.87109375, y=-11.16796875, graphics_variation=1}, {x=-24.0078125, y=13.43359375, graphics_variation=1}, {x=19.546875, y=19.94921875, graphics_variation=1}, },
    ["se-static-rocket-fragment-medium-b"] = {{x=24.30859375, y=-10.51953125, graphics_variation=1}, {x=-14.98828125, y=17.24609375, graphics_variation=1}, },
    ["se-static-rocket-fragment-tiny-e"] = {{x=0.3359375, y=-6.46875, graphics_variation=1}, },
    ["se-static-rocket-fragment-small-g"] = {{x=-13.44140625, y=-3.359375, graphics_variation=1}, {x=-3.84765625, y=11.3359375, graphics_variation=1}, {x=-17.05078125, y=15.48828125, graphics_variation=1}, },
    ["se-static-rocket-fragment-big-d"] = {{x=-20.51171875, y=-1.40625, graphics_variation=1}, },
    ["se-static-rocket-fragment-small-h"] = {{x=-15.75, y=-2.8984375, graphics_variation=1}, {x=-7.46875, y=12.78125, graphics_variation=1}, },
    ["se-static-rocket-fragment-tiny-a"] = {{x=-5.6328125, y=-3.07421875, graphics_variation=1}, {x=19.43359375, y=-1.19140625, graphics_variation=1}, {x=-16.05859375, y=21.0546875, graphics_variation=1}, },
    ["se-static-rocket-fragment-big-a"] = {{x=-27.85546875, y=-0.93359375, graphics_variation=1}, },
    ["se-static-rocket-fragment-tiny-f"] = {{x=-25.18359375, y=0.5078125, graphics_variation=1}, {x=-0.83984375, y=10.671875, graphics_variation=1}, },
    ["se-static-rocket-fragment-small-f"] = {{x=-4.38671875, y=9.26171875, graphics_variation=1}, },
    ["se-static-meteor-15"] = {{x=24.4296875, y=9.4921875, graphics_variation=1}, },
    ["se-static-rocket-fragment-tiny-b"] = {{x=12.484375, y=17.37109375, graphics_variation=1}, {x=10.484375, y=18.83984375, graphics_variation=1}, },
    ["se-static-meteor-02"] = {{x=5.44921875, y=24.3125, graphics_variation=1}, },
    ["se-static-rocket-fragment-small-i"] = {{x=15.62109375, y=24.80859375, graphics_variation=1}, }
  },
  blueprint_strings = {
    { -- entities
      xadj = 0, yadj = 2,
      string = "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"
  }}
}

return satellite2
