-- Only one of these presets can be used.
-- The preset with the highest number of "required mods" matches will be selected. (e.g. Bob's and Angel's will be selected over just Bob's)

-- If you would like to add a preset for your own mod, you will need to implement the remote interface. Please see the README for more info.


presets = {
    ["Vanilla"] = {
        required_mods = {},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="automation-science-pack", quantity=1},
            {type="item",       name="logistic-science-pack",   quantity=1},
            {type="item",       name="military-science-pack",   quantity=1},
            {type="item",       name="chemical-science-pack",   quantity=1},
            {type="item",       name="production-science-pack", quantity=1},
            {type="item",       name="utility-science-pack",    quantity=1},
            {type="item",       name="space-science-pack",      quantity=1},
            {type="item",       name="automation-science-pack", quantity=1000, next="x10"},
            {type="item",       name="logistic-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="military-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="chemical-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="production-science-pack", quantity=1000, next="x10"},
            {type="item",       name="utility-science-pack",    quantity=1000, next="x10"},
            {type="item",       name="space-science-pack",      quantity=10000, next="x10"},

            {type="group",      name="Progress"},
            {type="item",       name="locomotive",              quantity=1},
            {type="fluid",      name="petroleum-gas",           quantity=1},
            {type="item",       name="construction-robot",      quantity=1},
            {type="technology", name="rocket-silo",             quantity=1},
            {type="item",       name="rocket-part",             quantity=100},
            {type="item",       name="spidertron",              quantity=1},

            {type="group",      name="Power"},
            {type="item",       name="solar-panel",             quantity=1},
            {type="item",       name="solar-panel",             quantity=1000, next="x10"},
            {type="item",       name="nuclear-reactor",         quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="medium-biter",            quantity=1},
            {type="kill",       name="big-biter",               quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1000, next="x10"},
            {type="kill",       name="character",               quantity=1, next="x5", hidden=true},
        }
    },


    ["Space Age"] = {
        required_mods = {"space-age"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="automation-science-pack",      quantity=1},
            {type="item",       name="logistic-science-pack",        quantity=1},
            {type="item",       name="military-science-pack",        quantity=1},
            {type="item",       name="chemical-science-pack",        quantity=1},
            {type="item",       name="production-science-pack",      quantity=1},
            {type="item",       name="utility-science-pack",         quantity=1},
            {type="item",       name="space-science-pack",           quantity=1},
            {type="item",       name="metallurgic-science-pack",     quantity=1},
            {type="item",       name="electromagnetic-science-pack", quantity=1},
            {type="item",       name="agricultural-science-pack",    quantity=1},
            {type="item",       name="cryogenic-science-pack",       quantity=1},
            {type="item",       name="promethium-science-pack",      quantity=1},

            {type="group",      name="Science at scale"},
            {type="item",       name="automation-science-pack",      quantity=1000, next="x10"},
            {type="item",       name="logistic-science-pack",        quantity=1000, next="x10"},
            {type="item",       name="military-science-pack",        quantity=1000, next="x10"},
            {type="item",       name="chemical-science-pack",        quantity=1000, next="x10"},
            {type="item",       name="production-science-pack",      quantity=1000, next="x10"},
            {type="item",       name="utility-science-pack",         quantity=1000, next="x10"},
            {type="item",       name="space-science-pack",           quantity=1000, next="x10"},
            {type="item",       name="metallurgic-science-pack",     quantity=1000, next="x10"},
            {type="item",       name="electromagnetic-science-pack", quantity=1000, next="x10"},
            {type="item",       name="agricultural-science-pack",    quantity=1000, next="x10"},
            {type="item",       name="cryogenic-science-pack",       quantity=1000, next="x10"},
            {type="item",       name="promethium-science-pack",      quantity=1000, next="x10"},

            {type="group",      name="Progress"},
            {type="item",       name="locomotive",                  quantity=1},
            {type="fluid",      name="petroleum-gas",               quantity=1},
            {type="item",       name="construction-robot",          quantity=1},
            {type="item",       name="spidertron",                  quantity=1},
            {type="item",       name="mech-armor",                  quantity=1},
            {type="item_consumption", name="space-platform-starter-pack", quantity=1},
            {type="item_consumption", name="space-platform-starter-pack", quantity=10, next="x2"},
            {type="item",       name="foundry",                     quantity=1},
            {type="item",       name="biochamber",                  quantity=1},
            {type="item",       name="biolab",                      quantity=1},
            {type="item",       name="electromagnetic-plant",       quantity=1},
            {type="item",       name="cryogenic-plant",             quantity=1},
            {type="kill",       name="huge-promethium-asteroid",    quantity=1},

            {type="group",      name="Power"},
            {type="item",       name="solar-panel",             quantity=1},
            {type="item",       name="solar-panel",             quantity=1000, next="x10"},
            {type="item",       name="nuclear-reactor",         quantity=1},
            {type="item",       name="fusion-reactor",          quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="medium-biter",            quantity=1},
            {type="kill",       name="big-biter",               quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1000, next="x10"},
            {type="kill",       name="small-strafer-pentapod",  quantity=1},
            {type="kill",       name="medium-strafer-pentapod", quantity=1},
            {type="kill",       name="big-strafer-pentapod",    quantity=1},
            {type="kill",       name="big-strafer-pentapod",    quantity=1000, next="x10"},
            {type="kill",       name="small-stomper-pentapod",  quantity=1},
            {type="kill",       name="medium-stomper-pentapod", quantity=1},
            {type="kill",       name="big-stomper-pentapod",    quantity=1},
            {type="kill",       name="big-stomper-pentapod",    quantity=1000, next="x10"},
            {type="kill",       name="small-demolisher",        quantity=1},
            {type="kill",       name="medium-demolisher",       quantity=1},
            {type="kill",       name="big-demolisher",          quantity=1},
            {type="kill",       name="big-demolisher",          quantity=10, next="x2"},
            {type="kill",       name="character",               quantity=1, next="x5", hidden=true},

            {type="group",      name="Quality"},
            {type="item",       name="quality-module",        quantity=1, quality="rare"},
            {type="item",       name="quality-module-2",      quantity=1, quality="rare"},
            {type="item",       name="quality-module-3",      quantity=1, quality="epic"},
            {type="item",       name="quality-module-3",      quantity=1, quality="legendary"},
            {type="item",       name="productivity-module-3", quantity=100, next="x10", quality="legendary"},
            {type="item",       name="power-armor-mk2",       quantity=1, quality="rare"},
            {type="item",       name="power-armor-mk2",       quantity=1, quality="epic"},
            {type="item",       name="power-armor-mk2",       quantity=1, quality="legendary"},
            {type="item",       name="mech-armor",            quantity=1, quality="epic"},
            {type="item",       name="mech-armor",            quantity=1, quality="legendary"},
            {type="item",       name="spidertron",            quantity=1, quality="legendary"},
            {type="item",       name="raw-fish",              quantity=1, quality="legendary"},
        }
    },


    ["Nullius"] = {
        required_mods = {"angelssmelting", "nullius"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="nullius-geology-pack",             quantity=1},
            {type="item",       name="nullius-climatology-pack",         quantity=1},
            {type="item",       name="nullius-mechanical-pack",          quantity=1},
            {type="item",       name="nullius-electrical-pack",          quantity=1},
            {type="item",       name="nullius-chemical-pack",            quantity=1},
            {type="item",       name="nullius-physics-pack",             quantity=1},
            {type="item",       name="nullius-astronomy-pack",           quantity=1},
            {type="item",       name="nullius-biochemistry-pack",        quantity=1},
            {type="item",       name="nullius-microbiology-pack",        quantity=1},
            {type="item",       name="nullius-botany-pack",              quantity=1},
            {type="item",       name="nullius-nematology-pack",          quantity=1},
            {type="item",       name="nullius-dendrology-pack",          quantity=1},
            {type="item",       name="nullius-ichthyology-pack",         quantity=1},
            {type="item",       name="nullius-zoology-pack",             quantity=1},
            {type="item",       name="nullius-geology-pack",             quantity=1000, next="x10"},
            {type="item",       name="nullius-climatology-pack",         quantity=1000, next="x10"},
            {type="item",       name="nullius-mechanical-pack",          quantity=1000, next="x10"},
            {type="item",       name="nullius-electrical-pack",          quantity=1000, next="x10"},
            {type="item",       name="nullius-chemical-pack",            quantity=1000, next="x10"},
            {type="item",       name="nullius-physics-pack",             quantity=1000, next="x10"},
            {type="item",       name="nullius-astronomy-pack",           quantity=1000, next="x10"},
            {type="item",       name="nullius-biochemistry-pack",        quantity=1000, next="x10"},
            {type="item",       name="nullius-microbiology-pack",        quantity=1000, next="x10"},
            {type="item",       name="nullius-botany-pack",              quantity=1000, next="x10"},
            {type="item",       name="nullius-nematology-pack",          quantity=1000, next="x10"},
            {type="item",       name="nullius-dendrology-pack",          quantity=1000, next="x10"},
            {type="item",       name="nullius-ichthyology-pack",         quantity=1000, next="x10"},
            {type="item",       name="nullius-zoology-pack",             quantity=1000, next="x10"},

            -- Science boxes, a box is 5 packs
            {type="alias",      name="nullius-box-geology-pack",     equals="nullius-geology-pack",     quantity=5},
            {type="alias",      name="nullius-box-climatology-pack", equals="nullius-climatology-pack", quantity=5},
            {type="alias",      name="nullius-box-mechanical-pack",  equals="nullius-mechanical-pack",  quantity=5},
            {type="alias",      name="nullius-box-electrical-pack",  equals="nullius-electrical-pack",  quantity=5},
            {type="alias",      name="nullius-box-chemical-pack",    equals="nullius-chemical-pack",    quantity=5},
            {type="alias",      name="nullius-box-physics-pack",     equals="nullius-physics-pack",     quantity=5},
            {type="alias",      name="nullius-box-astronomy-pack",   equals="nullius-astronomy-pack",   quantity=5},

            {type="group",      name="Resources"},
            {type="item",       name="nullius-iron-ingot",               quantity=1},
            {type="item",       name="nullius-plastic",                  quantity=1},
            {type="item",       name="nullius-glass",                    quantity=1},
            {type="item",       name="nullius-aluminum-ingot",           quantity=1},
            {type="item",       name="nullius-silicon-ingot",            quantity=1},
            {type="item",       name="nullius-steel-ingot",              quantity=1},
            {type="item",       name="nullius-fiberglass",               quantity=1},
            {type="item",       name="nullius-titanium-ingot",           quantity=1},
            {type="item",       name="nullius-copper-ingot",             quantity=1},
            {type="item",       name="nullius-processor-1",              quantity=1},
            {type="item",       name="nullius-processor-2",              quantity=1},
            {type="item",       name="nullius-processor-3",              quantity=1},

            -- Item boxes, a box is 5 items
            {type="alias",      name="nullius-box-iron-ingot",     equals="nullius-iron-ingot",     quantity=5},
            {type="alias",      name="nullius-box-plastic",        equals="nullius-plastic",        quantity=5},
            {type="alias",      name="nullius-box-glass",          equals="nullius-glass",          quantity=5},
            {type="alias",      name="nullius-box-aluminum-ingot", equals="nullius-aluminum-ingot", quantity=5},
            {type="alias",      name="nullius-box-silicon-ingot",  equals="nullius-silicon-ingot",  quantity=5},
            {type="alias",      name="nullius-box-steel-ingot",    equals="nullius-steel-ingot",    quantity=5},
            {type="alias",      name="nullius-box-fiberglass",     equals="nullius-fiberglass",     quantity=5},
            {type="alias",      name="nullius-box-titanium-ingot", equals="nullius-titanium-ingot", quantity=5},
            {type="alias",      name="nullius-box-copper-ingot",   equals="nullius-copper-ingot",   quantity=5},
            {type="alias",      name="nullius-box-processor-1",    equals="nullius-processor-1",    quantity=5},
            {type="alias",      name="nullius-box-processor-2",    equals="nullius-processor-2",    quantity=5},
            {type="alias",      name="nullius-box-processor-3",    equals="nullius-processor-3",    quantity=5},

            {type="group",      name="Terraforming"},
            {type="item",       name="nullius-terraforming-drone-brown", quantity=1},
            {type="item",       name="nullius-rocket",                   quantity=1},
            {type="item",       name="nullius-algaculture-drone",        quantity=1},
            {type="item",       name="nullius-horticulture-drone",       quantity=1},
            {type="item",       name="nullius-arboriculture-drone",      quantity=1},
            {type="item",       name="nullius-entomology-drone",         quantity=1},
            {type="item",       name="nullius-aquaculture-drone",        quantity=1},
            {type="item",       name="nullius-husbandry-drone",          quantity=1},
            {type="item",       name="nullius-guide-drone-copper-1",     quantity=1},
            {type="item",       name="nullius-guide-drone-uranium-1",    quantity=1},
            {type="item",       name="nullius-antimatter",               quantity=1},
            {type="item",       name="nullius-probe",                    quantity=1},
            {type="item",       name="nullius-probe",                    quantity=10},

            {type="group",      name="Progress"},
            {type="item",       name="nullius-locomotive-1",             quantity=1},
            {type="item",       name="nullius-logistic-bot-1",           quantity=1},
            {type="item",       name="cliff-explosives",                 quantity=1},
            {type="item",       name="nullius-android-1",                quantity=1},
            {type="item",       name="nullius-android-2",                quantity=1},
            {type="item",       name="nullius-mecha",                    quantity=1},

            {type="group",      name="Power"},
            {type="item",       name="nullius-wind-turbine-1",           quantity=1},
            {type="item",       name="nullius-solar-collector-1",        quantity=1},
            {type="item",       name="nullius-solar-panel-1",            quantity=16},
            {type="item",       name="nullius-geothermal-plant-1",       quantity=1},
            {type="item",       name="nullius-grid-battery-1",           quantity=11},
            {type="item",       name="nullius-fusion-cell",              quantity=1},
            {type="item",       name="nullius-breeder-cell",             quantity=1},
            {type="item",       name="nullius-fission-cell",             quantity=1},
            {type="item",       name="nullius-antimatter",               quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="character",                        quantity=1, hidden=true},
        }
    },
}

