local grass_dirt = alien_biomes.list_tiles(alien_biomes.require_tag(alien_biomes.all_tiles(), {"grass", "dirt"}))
local grass = alien_biomes.list_tiles(alien_biomes.require_tag(alien_biomes.all_tiles(), {"grass"}))

local trees = {
  -- wetland
  {
    name = "tree-wetland-a",
    model = "oaktapus",
    locale = "lemon",
    noise = "trees_1",
    temperature_low = 0.65,
    temperature_high = 1,
    aux_low = 0,
    aux_high = 0.2,
    water_band = 4,
    density = 4,
    colors = {
      {r = 241, g = 238, b = 14},
      {r = 245, g = 165, b = 11},
      {r = 105, g = 184, b = 40}
    },
    tags = {"green", "yellow"},
    tile_restriction = grass,
  },
  {
    name = "tree-wetland-b",
    model = "specter",
    locale = "auburn",
    noise = "trees_2",
    temperature_low = 0.9,
    temperature_high = 1,
    aux_low = 0.2,
    aux_high = 0.7,
    water_band = 4,
    density = 4,
    colors = {
      {r = 245, g = 165, b = 11},
      {r = 163, g = 113, b = 21},
      {r = 184, g = 32, b = 32},
    },
    tags = {"orange", "red"},
    tile_restriction = grass,
  },
  {
    name = "tree-wetland-c",
    model = "05",
    locale = "vermilion",
    noise = "trees_3",
    temperature_low = 0.9,
    temperature_high = 1,
    aux_low = 0.7,
    aux_high = 1,
    water_band = 4,
    density = 4,
    colors = {
      {r = 227, g = 169, b = 209},
      {r = 184, g = 31, b = 31},
      {r = 107, g = 70, b = 25},
    },
    tags = {"red"},
    tile_restriction = grass,
  },
  {
    name = "tree-wetland-d",
    model = "specter",
    locale = "scarlet",
    noise = "trees_4",
    temperature_low = 0.35,
    temperature_high = 0.9,
    aux_low = 0.2,
    aux_high = 0.4,
    water_band = 4,
    density = 4,
    colors = {
      {r = 84, g = 17, b = 17},
      {r = 184, g = 31, b = 31},
      {r = 109, g = 53, b = 33},
      {r = 106, g = 89, b = 32},
      {r = 96, g = 101, b = 40},
      {r = 174, g = 130, b = 34},
    },
    tags = {"red"},
    tile_restriction = grass,
  },
  {
    name = "tree-wetland-e",
    model = "04",
    locale = "evergreen",
    noise = "trees_5",
    temperature_low = 0.35,
    temperature_high = 0.9,
    aux_low = 0.4,
    aux_high = 0.8,
    water_band = 4,
    density = 4,
    colors = {
      {r = 218, g = 187, b = 44},
      {r = 79, g = 119, b = 21},
      {r = 105, g = 184, b = 40},
    },
    tags = {"green"},
    tile_restriction = grass,
  },
  {
    name = "tree-wetland-f",
    model = "mangrove",
    locale = "marshmallow",
    noise = "trees_6",
    temperature_low = 0.55,
    temperature_high = 0.9,
    aux_low = 0.8,
    aux_high = 1,
    water_band = 4,
    density = 4,
    colors = {
      {r = 166, g = 76, b = 112},
      {r = 219, g = 192, b = 209},
      {r = 86, g = 41, b = 79},
      {r = 240, g = 119, b = 206},
      {r = 200, g = 97, b = 108},
    },
    tags = {"violet", "white"},
    tile_restriction = grass,
  },
  {
    name = "tree-wetland-g",
    model = "05",
    locale = "arsenic",
    noise = "trees_7",
    temperature_low = 0.4,
    temperature_high = 0.65,
    aux_low = 0.0,
    aux_high = 0.2,
    water_band = 4,
    density = 4,
    colors = {
      {r = 245, g = 165, b = 11},
      {r = 241, g = 238, b = 14},
      {r = 142, g = 99, b = 23},
    },
    tags = {"yellow"},
    tile_restriction = grass,
  },
  {
    name = "tree-wetland-h",
    model = "07",
    locale = "plumb",
    noise = "trees_8",
    temperature_low = 0.4,
    temperature_high = 0.65,
    aux_low = 0.8,
    aux_high = 1,
    water_band = 4,
    density = 4,
    colors = {
      {r = 154, g = 93, b = 228},
      {r = 50, g = 34, b = 70},
      {r = 112, g = 56, b = 180},
      {r = 152, g = 131, b = 178},
      {r = 138, g = 97, b = 221},
      {r = 152, g = 67, b = 206},
      {r = 103, g = 98, b = 221},
    },
    tags = {"purple"},
    tile_restriction = grass,
  },
  {
    name = "tree-wetland-i",
    model = "mangrove",
    locale = "bile",
    noise = "trees_9",
    temperature_low = 0.35,
    temperature_high = 0.4,
    aux_low = 0.0,
    aux_high = 0.2,
    water_band = 4,
    density = 4,
    colors = {
      {r = 150, g = 134, b = 46},
      {r = 70, g = 76, b = 23},
      {r = 94, g = 125, b = 20},
      {r = 109, g = 122, b = 56},
      {r = 105, g = 164, b = 40},
      {r = 79, g = 119, b = 21},
    },
    tags = {"green"},
    tile_restriction = grass,
  },
  {
    name = "tree-wetland-j",
    model = "ash",
    locale = "opal",
    noise = "trees_1",
    temperature_low = 0.1,
    temperature_high = 0.35,
    aux_low = 0.2,
    aux_high = 0.55,
    water_band = 4,
    density = 4,
    colors = {
      {r = 55, g = 22, b = 74},
      {r = 36, g = 106, b = 112},
      {r = 17, g = 80, b = 17},
    },
    tags = {"purple", "turquoise", "blue"},
    tile_restriction = grass,
  },
  {
    name = "tree-wetland-k",
    model = "03",
    locale = "cherry",
    noise = "trees_2",
    temperature_low = 0.1,
    temperature_high = 0.35,
    aux_low = 0.55,
    aux_high = 0.8,
    water_band = 4,
    density = 4,
    colors = {
      {r = 128, g = 28, b = 120},
      {r = 184, g = 31, b = 31},
      {r = 55, g = 22, b = 74},
    },
    tags = {"red", "purple"},
    tile_restriction = grass,
  },
  {
    name = "tree-wetland-l",
    model = "oaktapus",
    locale = "topaz",
    noise = "trees_3",
    temperature_low = 0.1,
    temperature_high = 0.3,
    aux_low = 0.8,
    aux_high = 1,
    water_band = 4,
    density = 4,
    colors = {
      {r = 17, g = 202, b = 248},
      {r = 192, g = 180, b = 237},
      {r = 77, g = 81, b = 163},
    },
    tags = {"blue"},
    tile_restriction = grass,
  },
  {
    name = "tree-wetland-m",
    model = "07",
    locale = "jade",
    noise = "trees_4",
    temperature_low = 0.0,
    temperature_high = 0.25,
    aux_low = 0.0,
    aux_high = 0.2,
    water_band = 4,
    density = 4,
    colors = {
      {r = 36, g = 225, b = 157},
      {r = 176, g = 220, b = 155},
      {r = 105, g = 184, b = 40},
    },
    tags = {"green", "turquoise"},
    tile_restriction = grass,
  },
  {
    name = "tree-wetland-n",
    model = "mangrove",
    locale = "cyanide",
    noise = "trees_5",
    temperature_low = 0.0,
    temperature_high = 0.1,
    aux_low = 0.2,
    aux_high = 0.6,
    water_band = 4,
    density = 4,
    colors = {
      {r = 65, g = 123, b = 122},
      {r = 43, g = 122, b = 89},
      {r = 75, g = 110, b = 123},
      {r = 17, g = 62, b = 5},
      {r = 103, g = 149, b = 156},
    },
    tags = {"green", "turquoise"},
    tile_restriction = grass,
  },
  {
    name = "tree-wetland-o",
    model = "01",
    locale = "tickling",
    noise = "trees_6",
    temperature_low = 0.0,
    temperature_high = 0.1,
    aux_low = 0.6,
    aux_high = 1,
    water_band = 4,
    density = 4,
    colors = {
      {r = 17, g = 62, b = 5},
      {r = 69, g = 73, b = 9},
      {r = 105, g = 184, b = 40},
    },
    tags = {"green"},
    tile_restriction = grass,
  },

  -- Grassland
  {
    name = "tree-grassland-a",
    model = "ash",
    locale = "olive",
    noise = "trees_7",
    temperature_low = 0.6,
    temperature_high = 1,
    aux_low = 0,
    aux_high = 0.15,
    water_band = 3,
    density = 3,
    colors = {
      {r = 165, g = 184, b = 40},
      {r = 79, g = 119, b = 21},
      {r = 69, g = 73, b = 9},
    },
    tags = {"green"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-b",
    model = "scarecrow",
    locale = "amber",
    noise = "trees_8",
    temperature_low = 0.85,
    temperature_high = 1,
    aux_low = 0.15,
    aux_high = 0.35,
    water_band = 3,
    density = 3,
    colors = {
      {r = 142, g = 109, b = 23},
      {r = 184, g = 91, b = 31},
      {r = 218, g = 167, b = 44},
    },
    tags = {"red", "orange"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-c",
    model = "oaktapus",
    locale = "crimson",
    noise = "trees_9",
    temperature_low = 0.75,
    temperature_high = 1,
    aux_low = 0.35,
    aux_high = 0.7,
    water_band = 3,
    density = 3,
    colors = {
      {r = 184, g = 31, b = 31},
      {r = 245, g = 145, b = 11},
      {r = 109, g = 53, b = 33},
    },
    tags = {"red", "orange"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-d",
    model = "ash",
    locale = "mulberry",
    noise = "trees_1",
    temperature_low = 0.9,
    temperature_high = 1,
    aux_low = 0.7,
    aux_high = 1,
    water_band = 3,
    density = 3,
    colors = {
      {r = 109, g = 53, b = 33},
      {r = 128, g = 28, b = 120},
      {r = 184, g = 31, b = 31},
    },
    tags = {"red", "purple"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-e",
    model = "scarecrow",
    locale = "grape",
    noise = "trees_2",
    temperature_low = 0.75,
    temperature_high = 0.9,
    aux_low = 0.7,
    aux_high = 1,
    water_band = 3,
    density = 3,
    colors = {
      {r = 128, g = 28, b = 120},
      {r = 109, g = 53, b = 33},
      {r = 55, g = 22, b = 74},
    },
    tags = {"purple"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-f",
    model = "ash",
    locale = "sunleaf",
    noise = "trees_3",
    temperature_low = 0.6,
    temperature_high = 0.85,
    aux_low = 0.15,
    aux_high = 0.35,
    water_band = 3,
    density = 3,
    colors = {
      {r = 218, g = 187, b = 44},
      {r = 245, g = 165, b = 11},
      {r = 142, g = 99, b = 23},
    },
    tags = {"yellow"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-g",
    model = "ash",
    locale = "springleaf",
    noise = "trees_4",
    temperature_low = 0.4,
    temperature_high = 0.75,
    aux_low = 0.35,
    aux_high = 0.55,
    water_band = 3,
    density = 3,
    colors = {
      {r = 69, g = 73, b = 9},
      {r = 165, g = 184, b = 40},
      {r = 79, g = 119, b = 21},
      {r = 210, g = 185, b = 48},
      {r = 218, g = 187, b = 44},
    },
    tags = {"green", "yellow"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-h",
    model = "05",
    locale = "broadleaf",
    noise = "trees_5",
    temperature_low = 0.1,
    temperature_high = 0.75,
    aux_low = 0.55,
    aux_high = 0.65,
    water_band = 3,
    density = 3,
    colors = {
      {r = 79, g = 119, b = 21},
      {r = 165, g = 184, b = 40},
      {r = 69, g = 73, b = 9},
    },
    tags = {"green"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-h2",
    model = "04",
    locale = "beetroot",
    noise = "trees_6",
    temperature_low = 0.4,
    temperature_high = 0.75,
    aux_low = 0.65,
    aux_high = 0.85,
    water_band = 2,
    density = 2.1,
    colors = {
      {r = 128, g = 28, b = 75},
      {r = 219, g = 78, b = 173},
      {r = 95, g = 75, b = 147},
      {r = 184, g = 31, b = 67},
    },
    tags = {"purple", "violet"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-h3",
    model = "scarecrow",
    locale = "amethyst",
    noise = "trees_7",
    temperature_low = 0.1,
    temperature_high = 0.4,
    aux_low = 0.65,
    aux_high = 0.85,
    water_band = 2,
    density = 2.1,
    colors = {
      {r = 67, g = 67, b = 142},
      {r = 115, g = 67, b = 142},
      {r = 95, g = 75, b = 147},
      {r = 75, g = 28, b = 148},
    },
    tags = {"purple", "blue"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-i",
    model = "greypine",
    locale = "candyfloss",
    noise = "trees_8",
    temperature_low = 0.3,
    temperature_high = 0.75,
    aux_low = 0.8,
    aux_high = 1,
    water_band = 3,
    density = 3,
    colors = {
      {r = 55, g = 22, b = 74},
      {r = 128, g = 28, b = 120},
      {r = 192, g = 180, b = 237},
      {r = 230, g = 120, b = 255},
    },
    tags = {"violet", "white"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-j",
    model = "08",
    locale = "starleaf",
    noise = "trees_8",
    temperature_low = 0.4,
    temperature_high = 0.6,
    aux_low = 0,
    aux_high = 0.3,
    water_band = 3,
    density = 3,
    colors = {
      {r = 218, g = 187, b = 44},
      {r = 79, g = 119, b = 21},
      {r = 105, g = 184, b = 40},
    },
    tags = {"green"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-k",
    model = "02",
    locale = "emerald",
    noise = "trees_9",
    temperature_low = 0.1,
    temperature_high = 0.4,
    aux_low = 0,
    aux_high = 0.3,
    water_band = 3,
    density = 3,
    colors = {
      {r = 76, g = 61, b = 16},
      {r = 69, g = 137, b = 69},
      {r = 152, g = 119, b = 33},
      {r = 109, g = 132, b = 43},
    },
    tags = {"green"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-l",
    model = "specter",
    locale = "sunset",
    noise = "trees_1",
    temperature_low = 0.25,
    temperature_high = 0.4,
    aux_low = 0.3,
    aux_high = 0.55,
    water_band = 3,
    density = 3,
    colors = {
      {r = 184, g = 31, b = 31},
      {r = 142, g = 99, b = 23},
      {r = 76, g = 61, b = 16},
    },
    tags = {"red"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-m",
    model = "ash",
    locale = "thistle",
    noise = "trees_2",
    temperature_low = 0.1,
    temperature_high = 0.3,
    aux_low = 0.8,
    aux_high = 1,
    water_band = 3,
    density = 3,
    colors = {
      {r = 192, g = 180, b = 237},
      {r = 128, g = 28, b = 120},
      {r = 167, g = 198, b = 220},
    },
    tags = {"violet", "white", "blue"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-n",
    model = "greypine",
    locale = "smoky",
    noise = "trees_3",
    temperature_low = 0.1,
    temperature_high = 0.25,
    aux_low = 0.3,
    aux_high = 0.55,
    water_band = 3,
    density = 3,
    colors = {
      {r = 221, g = 176, b = 207},
      {r = 184, g = 31, b = 31},
      {r = 75, g = 92, b = 123},
    },
    tags = {"red", "white", "blue"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-o",
    model = "02",
    locale = "blackleaf",
    noise = "trees_4",
    temperature_low = 0.0,
    temperature_high = 0.1,
    aux_low = 0.0,
    aux_high = 0.3,
    water_band = 3,
    density = 3,
    colors = {
      {r = 32, g = 76, b = 69},
      {r = 75, g = 92, b = 123},
      {r = 76, g = 61, b = 16},
    },
    tags = {"turquoise"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-p",
    model = "05",
    locale = "twilight",
    noise = "trees_5",
    temperature_low = 0.0,
    temperature_high = 0.1,
    aux_low = 0.3,
    aux_high = 0.7,
    water_band = 3,
    density = 3,
    colors = {
      {r = 75, g = 92, b = 123},
      {r = 44, g = 65, b = 126},
      {r = 32, g = 76, b = 69},
    },
    tags = {"turquoise", "blue"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-grassland-q",
    model = "specter",
    locale = "sapphire",
    noise = "trees_6",
    temperature_low = 0.0,
    temperature_high = 0.1,
    aux_low = 0.7,
    aux_high = 0.1,
    water_band = 3,
    density = 3,
    colors = {
      {r = 167, g = 198, b = 220},
      {r = 44, g = 65, b = 126},
      {r = 192, g = 180, b = 237},
    },
    tags = {"white", "blue"},
    tile_restriction = grass_dirt,
  },


  -- dryland
  {
    name = "tree-dryland-a",
    model = "willow",
    locale = "bloodlash",
    noise = "trees_7",
    temperature_low = 0.85,
    temperature_high = 1,
    aux_low = 0.0,
    aux_high = 0.4,
    water_band = 2,
    density = 1,
    colors = {
      {r = 255, g = 0, b = 0},
      {r = 255, g = 99, b = 23},
      {r = 255, g = 200, b = 0},
      {r = 142, g = 99, b = 23},
      {r = 245, g = 165, b = 11},
      {r = 79, g = 119, b = 21},
    },
    tags = {"red", "yellow"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-dryland-b",
    model = "04",
    locale = "succulent",
    noise = "trees_8",
    temperature_low = 0.85,
    temperature_high = 1,
    aux_low = 0.4,
    aux_high = 0.7,
    water_band = 2,
    density = 1,
    colors = {
      {r = 17, g = 62, b = 5},
      {r = 142, g = 99, b = 23},
      {r = 79, g = 119, b = 21},
    },
    tags = {"green"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-dryland-c",
    model = "scarecrow",
    locale = "powderpuff",
    noise = "trees_9",
    temperature_low = 0.7,
    temperature_high = 1,
    aux_low = 0.7,
    aux_high = 0.9,
    water_band = 2,
    density = 1,
    colors = {
      {r = 138, g = 61, b = 44},
      {r = 87, g = 54, b = 83},
      {r = 241, g = 200, b = 241},
      {r = 150, g = 100, b = 110},
    },
    tags = {"white", "red", "violet"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-dryland-d",
    model = "04",
    locale = "dusky",
    noise = "trees_1",
    temperature_low = 0.7,
    temperature_high = 1,
    aux_low = 0.9,
    aux_high = 1,
    water_band = 2,
    density = 1,
    colors = {
      {r = 44, g = 65, b = 126},
      {r = 128, g = 28, b = 118},
      {r = 55, g = 22, b = 74},
    },
    tags = {"red", "purple", "blue"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-dryland-e",
    model = "oaktapus",
    locale = "mint",
    noise = "trees_2",
    temperature_low = 0.45,
    temperature_high = 0.85,
    aux_low = 0,
    aux_high = 0.2,
    water_band = 2,
    density = 1,
    colors = {
      {r = 105, g = 184, b = 40},
      {r = 176, g = 220, b = 165},
      {r = 142, g = 99, b = 23},
    },
    tags = {"green", "turquoise"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-dryland-f",
    model = "08",
    locale = "spinleaf",
    noise = "trees_3",
    temperature_low = 0.7,
    temperature_high = 0.85,
    aux_low = 0.2,
    aux_high = 0.7,
    water_band = 2,
    density = 1,
    colors = {
      {r = 245, g = 165, b = 11},
      {r = 241, g = 238, b = 14},
      {r = 142, g = 99, b = 23},
    },
    tags = {"green", "yellow"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-dryland-g",
    model = "oaktapus",
    locale = "mottled",
    noise = "trees_4",
    temperature_low = 0.45,
    temperature_high = 0.7,
    aux_low = 0.2,
    aux_high = 0.5,
    water_band = 2,
    density = 1,
    colors = {
      {r = 174, g = 156, b = 56},
      {r = 163, g = 88, b = 33},
      {r = 152, g = 99, b = 23},
      {r = 79, g = 119, b = 21},
    },
    tags = {"green", "yellow"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-dryland-h",
    model = "04",
    locale = "mosaic",
    noise = "trees_5",
    temperature_low = 0.45,
    temperature_high = 0.7,
    aux_low = 0.5,
    aux_high = 0.85,
    water_band = 2,
    density = 1,
    colors = {
      {r = 184, g = 31, b = 31},
      {r = 84, g = 17, b = 17},
      {r = 245, g = 145, b = 11},
      {r = 85, g = 22, b = 74},
    },
    tags = {"red", "yellow", "purple"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-dryland-i",
    model = "willow",
    locale = "strangling",
    noise = "trees_6",
    temperature_low = 0.45,
    temperature_high = 0.7,
    aux_low = 0.85,
    aux_high = 1,
    water_band = 2,
    density = 1,
    colors = {
      {r = 128, g = 28, b = 120},
      {r = 84, g = 17, b = 17},
      {r = 184, g = 31, b = 31},
    },
    tags = {"violet"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-dryland-j",
    model = "01",
    locale = "fluffy",
    noise = "trees_7",
    temperature_low = 0.0,
    temperature_high = 0.45,
    aux_low = 0.0,
    aux_high = 0.15,
    water_band = 2,
    density = 1,
    colors = {
      {r = 176, g = 220, b = 165},
      {r = 105, g = 184, b = 40},
      {r = 75, g = 92, b = 123},
    },
    tags = {"turquoise", "green"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-dryland-k",
    model = "greypine",
    locale = "mothwing",
    noise = "trees_8",
    temperature_low = 0.15,
    temperature_high = 0.45,
    aux_low = 0.15,
    aux_high = 0.45,
    water_band = 2,
    density = 1,
    colors = {
      {r = 17, g = 62, b = 5},
      {r = 79, g = 119, b = 21},
      {r = 75, g = 92, b = 123},
    },
    tags = {"turquoise", "green", "blue"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-dryland-l",
    model = "01",
    locale = "bearded",
    noise = "trees_9",
    temperature_low = 0.0,
    temperature_high = 0.45,
    aux_low = 0.45,
    aux_high = 0.75,
    water_band = 2,
    density = 1,
    colors = {
      {r = 42, g = 86, b = 79},
      {r = 74, g = 32, b = 27},
      {r = 17, g = 82, b = 17},
    },
    tags = {"turquoise", "green", "red"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-dryland-m",
    model = "scarecrow",
    locale = "fusia",
    noise = "trees_1",
    temperature_low = 0.2,
    temperature_high = 0.45,
    aux_low = 0.75,
    aux_high = 1,
    water_band = 2,
    density = 1,
    colors = {
      {r = 84, g = 17, b = 17},
      {r = 55, g = 22, b = 74},
      {r = 128, g = 28, b = 120},
    },
    tags = {"violet", "purple"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-dryland-n",
    model = "06",
    locale = "sticky",
    noise = "trees_2",
    temperature_low = 0,
    temperature_high = 0.15,
    aux_low = 0.15,
    aux_high = 0.45,
    water_band = 2,
    density = 1,
    colors = {
      {r = 75, g = 92, b = 123},
      {r = 32, g = 76, b = 69},
      {r = 17, g = 62, b = 5},
    },
    tags = {"turquoise"},
    tile_restriction = grass_dirt,
  },
  {
    name = "tree-dryland-o",
    model = "01",
    locale = "dreamtrap",
    noise = "trees_3",
    temperature_low = 0,
    temperature_high = 0.2,
    aux_low = 0.85,
    aux_high = 1,
    water_band = 2,
    density = 1,
    colors = {
      {r = 230, g = 220, b = 255},
      {r = 55, g = 22, b = 74},
      {r = 100, g = 100, b = 200},
      {r = 200, g = 150, b = 255},
      {r = 160, g = 150, b = 160},
    },
    tile_restriction = not_sand,
    tags = {"purple", "white"},
    tile_restriction = grass_dirt,
  },

  -- desert
  {
    name = "tree-desert-a",
    model = "08",
    locale = "cactuar",
    noise = "trees_4",
    temperature_low = 0.75,
    temperature_high = 1,
    aux_low = 0.0,
    aux_high = 0.15,
    water_band = 1,
    density = 1,
    colors = {
      {r = 142, g = 99, b = 23},
      {r = 241, g = 238, b = 14},
      {r = 69, g = 73, b = 9},
    },
    tags = {"green"}
  },
  {
    name = "tree-desert-b",
    model = "pear",
    locale = "orchid",
    noise = "trees_5",
    temperature_low = 0.8,
    temperature_high = 1,
    aux_low = 0.15,
    aux_high = 0.45,
    water_band = 1,
    density = 1,
    colors = {
      {r = 227, g = 169, b = 209},
      {r = 220, g = 47, b = 222},
      {r = 184, g = 31, b = 31},
    },
    tags = {"red", "violet"}
  },
  {
    name = "tree-desert-c",
    model = "greypine",
    locale = "cinder",
    noise = "trees_6",
    temperature_low = 0.75,
    temperature_high = 1,
    aux_low = 0.45,
    aux_high = 0.7,
    water_band = 1,
    density = 1,
    colors = {
      {r = 245, g = 165, b = 11},
      {r = 163, g = 113, b = 21},
      {r = 184, g = 32, b = 32},
    },
    tags = {"yellow", "red"}
  },
  {
    name = "tree-desert-d",
    model = "pear",
    locale = "dragonfly",
    noise = "trees_7",
    temperature_low = 0.75,
    temperature_high = 1,
    aux_low = 0.7,
    aux_high = 0.9,
    water_band = 1,
    density = 1,
    colors = {
      {r = 79, g = 119, b = 21},
      {r = 176, g = 220, b = 165},
      {r = 76, g = 61, b = 16},
    },
    tags = {"green"}
  },
  {
    name = "tree-desert-e",
    model = "08",
    locale = "deeproot",
    noise = "trees_8",
    temperature_low = 0.75,
    temperature_high = 1,
    aux_low = 0.9,
    aux_high = 1,
    water_band = 1,
    density = 1,
    colors = {
      {r = 167, g = 198, b = 86},
      {r = 176, g = 220, b = 165},
      {r = 79, g = 119, b = 21},
    },
    tags = {"green"}
  },
  {
    name = "tree-desert-f",
    model = "pear",
    locale = "sporepuff",
    noise = "trees_9",
    temperature_low = 0.5,
    temperature_high = 0.8,
    aux_low = 0.15,
    aux_high = 0.45,
    water_band = 1,
    density = 1,
    colors = {
      {r = 150, g = 150, b = 20},
      {r = 69, g = 73, b = 9},
      {r = 79, g = 119, b = 21},
    },
    tags = {"yellow"}
  },
  {
    name = "tree-desert-g",
    model = "06",
    locale = "hangman",
    noise = "trees_1",
    temperature_low = 0.45,
    temperature_high = 0.75,
    aux_low = 0.0,
    aux_high = 0.15,
    water_band = 1,
    density = 1,
    colors = {
      {r = 184, g = 31, b = 31},
      {r = 55, g = 22, b = 74},
      {r = 245, g = 165, b = 11},
    },
    tags = {"green"}
  },
  {
    name = "tree-desert-h",
    model = "baobab",
    locale = "ruby",
    noise = "trees_2",
    temperature_low = 0.5,
    temperature_high = 0.75,
    aux_low = 0.45,
    aux_high = 1,
    water_band = 1,
    density = 1,
    colors = {
      {r = 84, g = 17, b = 17},
      {r = 184, g = 31, b = 31},
      {r = 76, g = 61, b = 16},
    },
    tags = {"red"}
  },
  {
    name = "tree-desert-i",
    model = "greypine",
    locale = "magnolia",
    noise = "trees_3",
    temperature_low = 0.0,
    temperature_high = 0.5,
    aux_low = 0.15,
    aux_high = 0.5,
    water_band = 1,
    density = 1,
    colors = {
      {r = 255, g = 255, b = 255},
      {r = 255, g = 255, b = 200},
      {r = 250, g = 250, b = 250},
      {r = 255, g = 225, b = 200},
    },
    tags = {"white", "yellow"}
  },
  {
    name = "tree-desert-j",
    model = "09",
    locale = "dustyrose",
    noise = "trees_4",
    temperature_low = 0.15,
    temperature_high = 0.5,
    aux_low = 0.5,
    aux_high = 0.7,
    water_band = 1,
    density = 1,
    colors = {
      {r = 245, g = 165, b = 165},
      {r = 184, g = 31, b = 31},
      {r = 225, g = 134, b = 177},
    },
    tags = {"violet", "red", "white"}
  },
  {
    name = "tree-desert-k",
    model = "baobab",
    locale = "autumn",
    noise = "trees_5",
    temperature_low = 0.15,
    temperature_high = 0.5,
    aux_low = 0.7,
    aux_high = 0.9,
    water_band = 1,
    density = 1,
    colors = {
      {r = 184, g = 31, b = 31},
      {r = 84, g = 17, b = 17},
      {r = 245, g = 165, b = 11},
    },
    tags = {"red", "yellow"}
  },
  {
    name = "tree-desert-l",
    model = "09",
    locale = "raisin",
    noise = "trees_6",
    temperature_low = 0.15,
    temperature_high = 0.5,
    aux_low = 0.9,
    aux_high = 1,
    water_band = 1,
    density = 1,
    colors = {
      {r = 227, g = 169, b = 189},
      {r = 136, g = 28, b = 118},
      {r = 164, g = 31, b = 144},
    },
    tags = {"red", "violet"}
  },
  {
    name = "tree-desert-m",
    model = "baobab",
    locale = "midnight",
    noise = "trees_7",
    temperature_low = 0.0,
    temperature_high = 0.45,
    aux_low = 0.0,
    aux_high = 0.15,
    water_band = 1,
    density = 1,
    colors = {
      {r = 55, g = 40, b = 74},
      {r = 22, g = 44, b = 120},
      {r = 16, g = 42, b = 42},
      {r = 8, g = 8, b = 8},
    },
    tags = {"purple", "blue", "turquoise"}
  },
  {
    name = "tree-desert-n",
    model = "09",
    locale = "snowdrop",
    noise = "trees_8",
    temperature_low = 0.0,
    temperature_high = 0.15,
    aux_low = 0.5,
    aux_high = 1,
    water_band = 1,
    density = 1,
    colors = {
      {r = 255, g = 255, b = 255},
      {r = 192, g = 180, b = 237},
      {r = 108, g = 28, b = 140},
      {r = 190, g = 190, b = 229},
    },
    tags = {"purple", "blue", "white"}
  },
  -- frozen
  {
    name = "tree-snow-a",
    model = "conifer-01",
    locale = "iceblade",
    noise = "trees_1",
    stump = "tree-02-stump",
    temperature_low = -0.15,
    temperature_high = 0,
    aux_low = 0,
    aux_high = 1,
    density = 2,
    colors = {
      {r = 255, g = 255, b = 255},
      {r = 167, g = 198, b = 220},
      {r = 32, g = 76, b = 42},
      {r = 17, g = 62, b = 5},
    },
    tags = {"green", "turquoise", "white"},
    tile_restriction = alien_biomes.list_tiles(alien_biomes.exclude_tags(alien_biomes.all_tiles(), {"ice", "volcanic", "sand"}))
  },
  -- volcanic
  {
    name = "tree-volcanic-a",
    model = "medusa-01",
    locale = "amber",
    noise = "trees_1",
    stump = "tree-02-stump",
    temperature_low = 1,
    temperature_high = 1.25,
    aux_low = 0,
    aux_high = 1,
    density = 1,
    colors = {
      {r = 194, g = 31, b = 31},
      {r = 245, g = 165, b = 11},
      {r = 241, g = 208, b = 14},
      {r = 162, g = 99, b = 23},
    },
    tags = {"red", "yellow"},
    tile_restriction = alien_biomes.list_tiles(alien_biomes.require_tag(alien_biomes.all_tiles(), {"heat-1"}))
  },
  -- palm
  {
    name = "tree-palm-a",
    model = "palm",
    locale = "paradise",
    noise = "trees_3",
    stump = "tree-02-stump",
    elevation_low = 0,
    elevation_high = 2,
    temperature_high = 1,
    temperature_low = 0.25,
    temperature_high = 1,
    water_low = 0.4,
    water_high = 1,
    aux_low = 0,
    aux_high = 0.5,
    density = 1,
    colors = {
      {r = 85, g = 114, b = 47},
      {r = 100, g = 127, b = 52},
      {r = 63, g = 118, b = 10},
      {r = 101, g = 106, b = 23}
    },
    tags = {"green"},
    tile_restriction = alien_biomes.list_tiles(alien_biomes.require_tag(alien_biomes.all_tiles(), {"sand"}))
  },
  -- palm
  {
    name = "tree-palm-b",
    model = "palm",
    locale = "amaranth",
    noise = "trees_2",
    stump = "tree-02-stump",
    elevation_low = 0,
    elevation_high = 2,
    temperature_high = 1,
    temperature_low = 0.25,
    temperature_high = 1,
    water_low = 0.4,
    water_high = 1,
    aux_low = 0.5,
    aux_high = 1,
    density = 1,
    colors = {
      {r = 114, g = 47, b = 85},
      {r = 127, g = 52, b = 100},
      {r = 118, g = 10, b = 63},
      {r = 106, g = 23, b = 101}
    },
    tags = {"violet"},
    tile_restriction = alien_biomes.list_tiles(alien_biomes.require_tag(alien_biomes.all_tiles(), {"sand"}))
  },
}
return trees
