-- SE+K2 sim: burner_base_night
local surface = game.surfaces.nauvis
local force = game.forces.player
local logo = surface.find_entities_filtered{name = "se-space-exploration-logo-shattered-15tiles", limit = 1}[1]
game.simulation.camera_position = {logo.position.x, logo.position.y+10.50}
game.simulation.camera_zoom = 1
game.tick_paused = false
surface.daytime = 0.5
surface.always_day = false

game.forces.player.add_research("military")

local mod_gui = require("__core__/lualib/mod-gui")
if script.level.is_simulation then
  local frame = mod_gui.get_button_flow(game.players[1])
  frame.parent.visible = false
end

script.on_nth_tick(1, function()
  if game.tick % 30 == 0 then
    game.forces.player.research_progress = 0
  end
end)

if prototypes.item["kr-loader"] == nil then
  local burn_ins_1 = surface.create_entity{name="burner-inserter", position={-0.5,-17.5}, direction=defines.direction.west, force=force, create_build_effect_smoke=false}
  burn_ins_1.get_fuel_inventory().insert({name="wood",count=10})
  burn_ins_1.clone{position={-0.5,-16.5}, surface=surface, force=force, create_build_effect_smoke=false}
  burn_ins_1.clone{position={-0.5,-15.5}, surface=surface, force=force, create_build_effect_smoke=false}
  surface.create_entity{name="transport-belt", position={0.5, -17.5}, direction=defines.direction.east, force=force, create_build_effect_smoke=false}
  surface.create_entity{name="transport-belt", position={0.5, -15.5}, direction=defines.direction.east, force=force, create_build_effect_smoke=false}

  burn_ins_1.clone{position={-0.5,-24.5}, surface=surface, force=force, create_build_effect_smoke=false}
  burn_ins_1.clone{position={-0.5,-23.5}, surface=surface, force=force, create_build_effect_smoke=false}
  burn_ins_1.clone{position={-0.5,-22.5}, surface=surface, force=force, create_build_effect_smoke=false}
  surface.create_entity{name="transport-belt", position={0.5, -24.5}, direction=defines.direction.east, force=force, create_build_effect_smoke=false}
  surface.create_entity{name="transport-belt", position={0.5, -22.5}, direction=defines.direction.east, force=force, create_build_effect_smoke=false}

  local burn_ins_2 = burn_ins_1.clone{position={3.5,-30.5}, surface=surface, force=force, create_build_effect_smoke=false}
  burn_ins_2.rotate()
  burn_ins_2.rotate()
  burn_ins_2.clone{position={3.5,-29.5}, surface=surface, force=force, create_build_effect_smoke=false}
  burn_ins_2.clone{position={3.5,-28.5}, surface=surface, force=force, create_build_effect_smoke=false}
  surface.create_entity{name="transport-belt", position={2.5, -29.5}, direction=defines.direction.west, force=force, create_build_effect_smoke=false}
  surface.create_entity{name="transport-belt", position={2.5, -28.5}, direction=defines.direction.west, force=force, create_build_effect_smoke=false}

  burn_ins_2.clone{position={3.5,-24.5}, surface=surface, force=force, create_build_effect_smoke=false}
  burn_ins_2.clone{position={3.5,-23.5}, surface=surface, force=force, create_build_effect_smoke=false}
  burn_ins_2.clone{position={3.5,-22.5}, surface=surface, force=force, create_build_effect_smoke=false}
  surface.create_entity{name="transport-belt", position={2.5, -24.5}, direction=defines.direction.west, force=force, create_build_effect_smoke=false}
  surface.create_entity{name="transport-belt", position={2.5, -22.5}, direction=defines.direction.west, force=force, create_build_effect_smoke=false}
end
