-- SE sim: weapon_delivery
local surface = game.surfaces.nauvis
local logo = surface.find_entities_filtered{name = "se-space-exploration-logo-shattered-15tiles", limit = 1}[1]
game.simulation.camera_position = {logo.position.x, logo.position.y+10.50}
game.simulation.camera_zoom = 1
game.tick_paused = false
surface.daytime = 0.35

game.forces.enemy.set_evolution_factor(0.95, surface)
game.forces.player.bulk_inserter_capacity_bonus = 11

local mod_gui = require("__core__/lualib/mod-gui")
if script.level.is_simulation then
  local frame = mod_gui.get_button_flow(game.players[1])
  frame.parent.visible = false
end

local tick_start = game.tick

script.on_nth_tick(1, function()
  local ticks_since_start = game.tick - tick_start

  if ticks_since_start == 60 * 12.7 then
    local get_tags = function(coordinates)
      return {
        destination = {
          zone_name = "Nauvis",
          coordinate = coordinates
        },
        is_off = false,
        auto_select_targets = false
      }
    end

    remote.call("space-exploration-menu-simulations", "find_and_enable_cannon", {position = {6.5, -262.5}, tags = get_tags{x=-19.5, y=-10.5}})
    remote.call("space-exploration-menu-simulations", "find_and_enable_cannon", {position = {16.5, -262.5}, tags = get_tags{x=-3.5, y=11.5}})
    remote.call("space-exploration-menu-simulations", "find_and_enable_cannon", {position = {26.5, -262.5}, tags = get_tags{x=16, y=-10.5}})
  end

  if ticks_since_start == 60 * 13.7 then
    local logo2 = game.surfaces.nauvis.find_entities_filtered{name = "se-space-exploration-logo-shattered-15tiles", limit = 2}[2]
    game.simulation.camera_position = {logo2.position.x, logo2.position.y+10.50}
    game.simulation.camera_zoom = 1
    game.tick_paused = false
    game.surfaces.nauvis.daytime = 0
  end
end)


-- Add heavy rocket chest for K2
if script.active_mods["Krastorio2"] then
  local chest = surface.create_entity({name="requester-chest", position={-25.5, -267.5}})
  chest.insert({name="kr-heavy-rocket", count=200})
  surface.create_entity({name="inserter", position={-24.5, -267.5}, direction=defines.direction.west})
end
